import { Sequence } from 'gensequence';
import { TrieRoot } from '../TrieNode';
export interface ExportOptions {
    base?: number;
    comment?: string;
    version?: number;
}
/**
 * Serialize a TrieNode.
 * Note: This is destructive.  The node will no longer be usable.
 * Even though it is possible to preserve the trie, dealing with very large tries can consume a lot of memory.
 * Considering this is the last step before exporting, it was decided to let this be destructive.
 */
export declare function serializeTrie(root: TrieRoot, options?: ExportOptions | number): Sequence<string>;
export declare function importTrie(lines: Iterable<string> | IterableIterator<string>): TrieRoot;
//# sourceMappingURL=importExport.d.ts.map