import { TrieNode, TrieRoot } from './TrieNode';
import type { PartialWithUndefined } from './types';
declare type Root = PartialWithUndefined<TrieRoot>;
/**
 * No compounding allowed.
 */
export declare type CompoundModeNone = 'none';
/**
 * Allow natural compounding in the dictionary
 * using compound prefixes
 */
export declare type CompoundModesCompound = 'compound';
/**
 * Allow all possible compounds -- Very slow.
 */
export declare type CompoundModesLegacy = 'legacy';
export declare type CompoundModes = CompoundModeNone | CompoundModesCompound | CompoundModesLegacy;
export interface FindOptions {
    matchCase: boolean;
    compoundMode: CompoundModes;
    forbidPrefix: string;
    compoundFix: string;
    caseInsensitivePrefix: string;
    legacyMinCompoundLength: number;
}
export declare type PartialFindOptions = PartialWithUndefined<FindOptions> | undefined;
export interface FindNodeResult {
    node: TrieNode | undefined;
}
export interface FindResult {
    found: string | false;
    compoundUsed: boolean;
    caseMatched: boolean;
}
export interface FindFullResult extends FindResult {
    /**
     * Is the word explicitly forbidden.
     * - `true` - word is in the forbidden list.
     * - `false` - word is not in the forbidden list.
     * - `undefined` - unknown - was not checked.
     * */
    forbidden: boolean | undefined;
}
export interface FindFullNodeResult extends FindNodeResult, FindFullResult {
}
/**
 *
 * @param root Trie root node. root.c contains the compound root and forbidden root.
 * @param word A pre normalized word use `normalizeWord` or `normalizeWordToLowercase`
 * @param options
 */
export declare function findWord(root: Root, word: string, options?: PartialFindOptions): FindFullResult;
/**
 *
 * @param root Trie root node. root.c contains the compound root and forbidden root.
 * @param word A pre normalized word use `normalizeWord` or `normalizeWordToLowercase`
 * @param options
 */
export declare function findWordNode(root: Root, word: string, options?: PartialFindOptions): FindFullNodeResult;
export declare function findLegacyCompound(root: Root, word: string, options: FindOptions): FindFullNodeResult;
export declare function findCompoundNode(root: Root | undefined, word: string, compoundCharacter: string, ignoreCasePrefix: string): FindFullNodeResult;
export declare function findWordExact(root: Root | TrieNode | undefined, word: string): boolean;
export declare function isEndOfWordNode(n: TrieNode | undefined): boolean;
declare function findLegacyCompoundWord(roots: (TrieNode | undefined)[], word: string, minCompoundLength: number): FindResult;
export declare function isForbiddenWord(root: Root | TrieNode | undefined, word: string, forbiddenPrefix: string): boolean;
export declare function createFindOptions(options: PartialFindOptions | undefined): FindOptions;
export declare const __testing__: {
    findLegacyCompoundWord: typeof findLegacyCompoundWord;
};
export {};
//# sourceMappingURL=find.d.ts.map