import { SuggestionCostMapDef } from '../models/suggestionCostsDef';
export declare type WeightedRepMapTrie = Record<string, WeightedRepTrieNode>;
interface WeightedRepTrieNode {
    /** The nested Trie nodes */
    r?: WeightedRepMapTrie | undefined;
    /** The cost to replace */
    rep?: number | undefined;
    /** The cost to swap */
    swap?: number | undefined;
}
/**
 * Costs are minimized while penalties are maximized.
 */
interface Cost {
    /**
     * The cost of an operation
     * `c'' = min(c, c')`
     */
    c?: number | undefined;
    /**
     * The penalties applied
     * `p'' = max(p, p')`
     */
    p?: number | undefined;
}
interface TrieCost extends Cost {
    /** nested trie nodes */
    n?: Record<string, TrieCost>;
}
interface TrieTrieCost {
    /** nested trie nodes */
    n?: Record<string, TrieTrieCost>;
    /** root of cost trie */
    t?: Record<string, TrieCost>;
}
export interface CostPosition {
    a: string;
    ai: number;
    b: string;
    bi: number;
    c: number;
    p: number;
}
export interface WeightMap {
    readonly insDel: TrieCost;
    readonly replace: TrieTrieCost;
    readonly swap: TrieTrieCost;
    readonly adjustments: Map<string, PenaltyAdjustment>;
    calcInsDelCosts(pos: CostPosition): Iterable<CostPosition>;
    calcSwapCosts(pos: CostPosition): Iterable<CostPosition>;
    calcReplaceCosts(pos: CostPosition): Iterable<CostPosition>;
    calcAdjustment(word: string): number;
}
export interface PenaltyAdjustment {
    /** Penalty Identifier */
    id: string;
    /** RegExp Pattern to match */
    regexp: RegExp;
    /** Penalty to apply */
    penalty: number;
}
export declare function createWeightMap(...defs: SuggestionCostMapDef[]): WeightMap;
export declare function addDefToWeightMap(map: WeightMap, def: SuggestionCostMapDef, ...defs: SuggestionCostMapDef[]): WeightMap;
export declare function addAdjustment(map: WeightMap, ...adjustments: PenaltyAdjustment[]): WeightMap;
export declare function addAdjustment(map: WeightMap, adjustment: PenaltyAdjustment): WeightMap;
export declare function addDefsToWeightMap(map: WeightMap, defs: SuggestionCostMapDef[]): WeightMap;
export declare function splitMapSubstringsIterable(map: string): Iterable<string>;
export declare function splitMapSubstrings(map: string): string[];
/**
 * Splits a WeightedMapDef.map
 * @param map
 */
declare function splitMap(def: Pick<SuggestionCostMapDef, 'map'>): string[][];
interface MatchTrieCost {
    i: number;
    c: number;
    p: number;
}
declare function findTrieCostPrefixes(trie: TrieCost, str: string, i: number): Iterable<MatchTrieCost>;
interface MatchTrieTrieCost {
    i: number;
    t: TrieCost;
}
declare function findTrieTrieCostPrefixes(trie: TrieTrieCost, str: string, i: number): Iterable<MatchTrieTrieCost>;
export declare function prettyPrintReplace(trie: TrieTrieCost, pfx?: string, indent?: string): string;
export declare function prettyPrintSwap(trie: TrieTrieCost, pfx?: string, indent?: string): string;
export declare function prettyPrintWeightMap(map: WeightMap): string;
export declare function lookupReplaceCost(map: WeightMap, a: string, b: string): undefined | number;
declare function normalizeDef(def: SuggestionCostMapDef): SuggestionCostMapDef;
export declare const __testing__: {
    findTrieCostPrefixes: typeof findTrieCostPrefixes;
    findTrieTrieCostPrefixes: typeof findTrieTrieCostPrefixes;
    normalizeDef: typeof normalizeDef;
    splitMap: typeof splitMap;
    splitMapSubstrings: typeof splitMapSubstrings;
};
export {};
//# sourceMappingURL=weightedMaps.d.ts.map