"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formattedDistance = exports.formatExResult = void 0;
const distanceAStarWeighted_1 = require("./distanceAStarWeighted");
function pL(s, w) {
    const strWidth = vizWidth(s);
    const w0 = Math.max(0, w - strWidth);
    return ' '.repeat(w0) + s;
}
function pR(s, w) {
    const strWidth = vizWidth(s);
    const w0 = Math.max(0, w - strWidth);
    return s + ' '.repeat(w0);
}
function vizWidth(s) {
    const r = s.replace(/[\u0300-\u036F\u007f-\u009f]/gu, '');
    let i = 0;
    for (const c of r) {
        i += c.length;
    }
    return i;
}
function formatExResult(ex) {
    if (!ex)
        return '<undefined>';
    const { cost, segments, penalty } = ex;
    const asString = segments.map(({ a, b, c, p }) => ({
        a: `<${a}>`,
        b: `<${b}>`,
        c: c.toString(10),
        p: p.toString(10),
    }));
    asString.push({
        a: '',
        b: '',
        c: ' = ' + segments.reduce((sum, { c }) => sum + c, 0).toString(10),
        p: ' = ' + segments.reduce((sum, { p }) => sum + p, 0).toString(10),
    });
    const parts = asString.map(({ a, b, c, p }) => ({
        a,
        b,
        c,
        p,
        w: Math.max(vizWidth(a), vizWidth(b), vizWidth(c), vizWidth(p)),
    }));
    const a = 'a: |' + parts.map(({ a, w }) => pR(a, w)).join('|') + '|';
    const b = 'b: |' + parts.map(({ b, w }) => pR(b, w)).join('|') + '|';
    const c = 'c: |' + parts.map(({ c, w }) => pL(c, w)).join('|') + '|';
    const p = 'p: |' + parts.map(({ p, w }) => pL(p, w)).join('|') + '|';
    const penaltyMsg = penalty ? `[+${penalty}]` : '';
    return `<${ex.a.slice(1, -1)}> -> <${ex.b.slice(1, -1)}> (${cost - penalty}${penaltyMsg})\n${[a, b, c, p].join('\n')}\n`;
}
exports.formatExResult = formatExResult;
function formattedDistance(wordA, wordB, weightMap, cost) {
    const x = (0, distanceAStarWeighted_1.distanceAStarWeightedEx)(wordA, wordB, weightMap, cost);
    return formatExResult(x);
}
exports.formattedDistance = formattedDistance;
//# sourceMappingURL=formatResultEx.js.map