import { WeightMap } from './weightedMaps';
/**
 * Calculate the edit distance between two words using an A* algorithm.
 *
 * Using basic weights, this algorithm has the same results as the Damerau-Levenshtein algorithm.
 */
export declare function distanceAStarWeighted(wordA: string, wordB: string, map: WeightMap, cost?: number): number;
export interface ExResult {
    a: string;
    b: string;
    cost: number;
    penalty: number;
    segments: {
        a: string;
        b: string;
        c: number;
        p: number;
    }[];
}
export declare function distanceAStarWeightedEx(wordA: string, wordB: string, map: WeightMap, cost?: number): ExResult;
//# sourceMappingURL=distanceAStarWeighted.d.ts.map