import type { SuggestionCostMapDef } from '../models/suggestionCostsDef';
import type { WeightMap } from './weightedMaps';
export type { SuggestionCostMapDef } from '../models/suggestionCostsDef';
export type { WeightMap } from './weightedMaps';
/**
 * Calculate the edit distance between any two words.
 * Use the Damerau–Levenshtein distance algorithm.
 * @param wordA
 * @param wordB
 * @param editCost - the cost of each edit (defaults to 100)
 * @returns the edit distance.
 */
export declare function editDistance(wordA: string, wordB: string, editCost?: number): number;
/**
 * Calculate the weighted edit distance between any two words.
 * @param wordA
 * @param wordB
 * @param weights - the weights to use
 * @param editCost - the cost of each edit (defaults to 100)
 * @returns the edit distance
 */
export declare function editDistanceWeighted(wordA: string, wordB: string, weights: WeightMap, editCost?: number): number;
/**
 * Collect Map definitions into a single weighted map.
 * @param defs - list of definitions
 * @returns A Weighted Map to be used with distance calculations.
 */
export declare function createWeightedMap(defs: SuggestionCostMapDef[]): WeightMap;
/**
 * Update a WeightedMap with a WeightedMapDef
 * @param weightedMap - map to update
 * @param def - the definition to use
 */
export declare function updatedWeightedMap(weightedMap: WeightMap, def: SuggestionCostMapDef): void;
//# sourceMappingURL=distance.d.ts.map