"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compoundWords = exports.compoundWalker = void 0;
/**
 *
 * Depth first walk of a compound trie.
 * If there are compounds, this becomes an infinite iterator.
 * Use i.next(false) to prevent the walker from going deeper into the trie.
 *
 * @param trie the compound Trie to walk
 */
function* compoundWalker(trie, caseSensitive = true) {
    var _a;
    const { compoundCharacter: cc, forbiddenWordPrefix: forbidden, stripCaseAndAccentsPrefix } = trie.options;
    const blockNode = new Set([cc, forbidden, stripCaseAndAccentsPrefix]);
    const root = (!caseSensitive && ((_a = trie.root.c) === null || _a === void 0 ? void 0 : _a.get(stripCaseAndAccentsPrefix))) || trie.root;
    function* walk(n, s, c, d) {
        var _a;
        const deeper = yield { n, s, c, d };
        if (deeper !== false && n.c) {
            for (const [k, cn] of n.c) {
                if (blockNode.has(k))
                    continue;
                yield* walk(cn, s + k, false, d);
            }
            if (n.c.has(cc)) {
                const compoundNodes = (_a = root.c) === null || _a === void 0 ? void 0 : _a.get(cc);
                if (compoundNodes) {
                    yield* walk(compoundNodes, s, true, d + 1);
                }
            }
        }
    }
    // Make sure we do not walk forbidden and compound only words from the root.
    for (const n of root.c || []) {
        if (!blockNode.has(n[0])) {
            yield* walk(n[1], n[0], false, 0);
        }
    }
}
exports.compoundWalker = compoundWalker;
/**
 *
 * @param trie Trie to walk
 * @param maxDepth Max compound depth
 * @param caseSensitive case sensitive search.
 */
function* compoundWords(trie, maxDepth, caseSensitive = true) {
    const stream = compoundWalker(trie, caseSensitive);
    let item = stream.next();
    while (!item.done) {
        const { n, s, d } = item.value;
        if (d >= maxDepth) {
            item = stream.next(false);
            continue;
        }
        if (n.f) {
            yield s;
        }
        item = stream.next();
    }
}
exports.compoundWords = compoundWords;
//# sourceMappingURL=compoundWalker.js.map