import { Trie } from './trie';
import { TrieNode } from './TrieNode';
export interface WalkItem {
    /** prefix so far */
    s: string;
    n: TrieNode;
    /** compound depth */
    d: number;
    /** true iff compound edge */
    c: boolean;
}
export declare type WalkNext = boolean;
/**
 *
 * Depth first walk of a compound trie.
 * If there are compounds, this becomes an infinite iterator.
 * Use i.next(false) to prevent the walker from going deeper into the trie.
 *
 * @param trie the compound Trie to walk
 */
export declare function compoundWalker(trie: Trie, caseSensitive?: boolean): Generator<WalkItem, void, WalkNext>;
/**
 *
 * @param trie Trie to walk
 * @param maxDepth Max compound depth
 * @param caseSensitive case sensitive search.
 */
export declare function compoundWords(trie: Trie, maxDepth: number, caseSensitive?: boolean): Generator<string, void, unknown>;
//# sourceMappingURL=compoundWalker.d.ts.map