import { Trie, PartialTrieOptions, TrieOptions } from './trie';
/**
 * Builds an optimized Trie from a Iterable<string>. It attempts to reduce the size of the trie
 * by finding common endings.
 * @param words Iterable set of words -- no processing is done on the words, they are inserted as is.
 * @param trieOptions options for the Trie
 */
export declare function buildTrie(words: Iterable<string>, trieOptions?: PartialTrieOptions): Trie;
/**
 * Builds a Trie from a Iterable<string>. NO attempt a reducing the size of the Trie is done.
 * @param words Iterable set of words -- no processing is done on the words, they are inserted as is.
 * @param trieOptions options for the Trie
 */
export declare function buildTrieFast(words: Iterable<string>, trieOptions?: PartialTrieOptions): Trie;
export declare class TrieBuilder {
    private count;
    private readonly signatures;
    private readonly cached;
    private readonly transforms;
    private _eow;
    /** position 0 of lastPath is always the root */
    private lastPath;
    private tails;
    trieOptions: TrieOptions;
    constructor(words?: Iterable<string>, trieOptions?: PartialTrieOptions);
    private set _root(value);
    private get _root();
    private signature;
    private _canBeCached;
    private tryCacheFrozen;
    private freeze;
    private tryToCache;
    private storeTransform;
    private addChild;
    private buildTail;
    private _insert;
    insertWord(word: string): void;
    insert(words: Iterable<string>): void;
    /**
     * Resets the builder
     */
    reset(): void;
    build(consolidateSuffixes?: boolean): Trie;
}
//# sourceMappingURL=TrieBuilder.d.ts.map