import { GlobPattern, GlobPatternNormalized, GlobPatternWithOptionalRoot, GlobPatternWithRoot, PathInterface } from './GlobMatcherTypes';
/**
 * This function tries its best to determine if `fileOrGlob` is a path to a file or a glob pattern.
 * @param fileOrGlob - file (with absolute path) or glob.
 * @param root - absolute path to the directory that will be considered the root when testing the glob pattern.
 * @param path - optional node path methods - used for testing
 */
export declare function fileOrGlobToGlob(fileOrGlob: string | GlobPattern, root: string, path?: PathInterface): GlobPatternWithRoot;
/**
 * Decide if a childPath is contained within a root or at the same level.
 * @param root - absolute path
 * @param childPath - absolute path
 */
export declare function doesRootContainPath(root: string, child: string, path: PathInterface): boolean;
export declare function isGlobPatternWithOptionalRoot(g: GlobPattern): g is GlobPatternWithOptionalRoot;
export declare function isGlobPatternWithRoot(g: GlobPatternWithRoot | GlobPatternWithOptionalRoot): g is GlobPatternWithRoot;
export declare function isGlobPatternNormalized(g: GlobPattern | GlobPatternNormalized): g is GlobPatternNormalized;
export interface NormalizeOptions {
    /**
     * Indicates that the glob should be modified to match nested patterns.
     *
     * Example: `node_modules` becomes `**​/node_modules/​**`, `**​/node_modules`, and `node_modules/​**`
     */
    nested: boolean;
    /**
     * This is the root to use for the glob if the glob does not already contain one.
     */
    root: string;
    /**
     * This is the replacement for `${cwd}` in either the root or in the glob.
     */
    cwd?: string;
    /**
     * Optional path interface for working with paths.
     */
    nodePath?: PathInterface;
}
/**
 *
 * @param patterns - glob patterns to normalize.
 * @param options - Normalization options.
 */
export declare function normalizeGlobPatterns(patterns: GlobPattern[], options: NormalizeOptions): GlobPatternNormalized[];
export declare function normalizeGlobPattern(g: GlobPattern, options: NormalizeOptions): GlobPatternNormalized[];
/**
 * Try to adjust the root of a glob to match a new root. If it is not possible, the original glob is returned.
 * Note: this does NOT generate absolutely correct glob patterns. The results are intended to be used as a
 * first pass only filter. Followed by testing against the original glob/root pair.
 * @param glob - glob to map
 * @param root - new root to use if possible
 * @param path - Node Path modules to use (testing only)
 */
export declare function normalizeGlobToRoot<Glob extends GlobPatternWithRoot>(glob: Glob, root: string, path: PathInterface): Glob;
/**
 * Rebase a glob string to a new prefix
 * @param glob - glob string
 * @param rebaseTo - glob prefix
 */
declare function rebaseGlob(glob: string, rebaseTo: string): string | undefined;
/**
 * Trims any trailing spaces, tabs, line-feeds, new-lines, and comments
 * @param glob - glob string
 * @returns trimmed glob
 */
declare function trimGlob(glob: string): string;
export declare const __testing__: {
    rebaseGlob: typeof rebaseGlob;
    trimGlob: typeof trimGlob;
};
export {};
//# sourceMappingURL=globHelper.d.ts.map