"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobMatcher = void 0;
const mm = require("micromatch");
const Path = __importStar(require("path"));
const globHelper_1 = require("./globHelper");
class GlobMatcher {
    constructor(patterns, rootOrOptions, _nodePath) {
        var _a;
        _nodePath = _nodePath !== null && _nodePath !== void 0 ? _nodePath : Path;
        const options = typeof rootOrOptions === 'string' ? { root: rootOrOptions } : rootOrOptions !== null && rootOrOptions !== void 0 ? rootOrOptions : {};
        const { mode = 'exclude' } = options;
        const isExcludeMode = mode !== 'include';
        _nodePath = (_a = options.nodePath) !== null && _a !== void 0 ? _a : _nodePath;
        const { root = _nodePath.resolve(), dot = isExcludeMode, nodePath = _nodePath, nested = isExcludeMode, cwd = process.cwd(), nobrace, } = clean(options);
        const normalizedRoot = nodePath.resolve(nodePath.normalize(root));
        this.options = { root: normalizedRoot, dot, nodePath, nested, mode, nobrace, cwd };
        patterns = Array.isArray(patterns)
            ? patterns
            : typeof patterns === 'string'
                ? patterns.split(/\r?\n/g)
                : [patterns];
        const globPatterns = (0, globHelper_1.normalizeGlobPatterns)(patterns, this.options);
        this.patternsNormalizedToRoot = globPatterns
            .map((g) => (0, globHelper_1.normalizeGlobToRoot)(g, normalizedRoot, nodePath))
            // Only keep globs that do not match the root when using exclude mode.
            .filter((g) => nodePath.relative(g.root, normalizedRoot) === '');
        this.patterns = globPatterns;
        this.root = normalizedRoot;
        this.path = nodePath;
        this.dot = dot;
        this.matchEx = buildMatcherFn(this.patterns, this.options);
    }
    /**
     * Check to see if a filename matches any of the globs.
     * If filename is relative, it is considered relative to the root.
     * If filename is absolute and contained within the root, it will be made relative before being tested for a glob match.
     * If filename is absolute and not contained within the root, it will be tested as is.
     * @param filename full path of the file to check.
     */
    match(filename) {
        return this.matchEx(filename).matched;
    }
}
exports.GlobMatcher = GlobMatcher;
/**
 * This function attempts to emulate .gitignore functionality as much as possible.
 *
 * The resulting matcher function: (filename: string) => GlobMatch
 *
 * If filename is relative, it is considered relative to the root.
 * If filename is absolute and contained within the root, it will be made relative before being tested for a glob match.
 * If filename is absolute and not contained within the root, it will return a GlobMatchNoRule.
 *
 * @param patterns - the contents of a .gitignore style file or an array of individual glob rules.
 * @param options - defines root and other options
 * @returns a function given a filename returns true if it matches.
 */
function buildMatcherFn(patterns, options) {
    const { nodePath: path, dot, nobrace } = options;
    const makeReOptions = { dot, nobrace };
    const rules = patterns
        .map((pattern, index) => ({ pattern, index }))
        .filter((r) => !!r.pattern.glob)
        .filter((r) => !r.pattern.glob.startsWith('#'))
        .map(({ pattern, index }) => {
        const matchNeg = pattern.glob.match(/^!/);
        const glob = pattern.glob.replace(/^!/, '');
        const isNeg = (matchNeg && matchNeg[0].length & 1 && true) || false;
        const reg = mm.makeRe(glob, makeReOptions);
        const fn = (filename) => {
            const match = filename.match(reg);
            return !!match;
        };
        return { pattern, index, isNeg, fn, reg };
    });
    const negRules = rules.filter((r) => r.isNeg);
    const posRules = rules.filter((r) => !r.isNeg);
    const fn = (filename) => {
        filename = path.resolve(path.normalize(filename));
        function testRules(rules, matched) {
            for (const rule of rules) {
                const pattern = rule.pattern;
                const root = pattern.root;
                if (!(0, globHelper_1.doesRootContainPath)(root, filename, path)) {
                    continue;
                }
                const relName = path.relative(root, filename);
                const fname = path.sep === '\\' ? relName.replace(/\\/g, '/') : relName;
                if (rule.fn(fname)) {
                    return {
                        matched,
                        glob: pattern.glob,
                        root,
                        pattern,
                        index: rule.index,
                        isNeg: rule.isNeg,
                    };
                }
            }
        }
        return testRules(negRules, false) || testRules(posRules, true) || { matched: false };
    };
    return fn;
}
function clean(obj) {
    if (typeof obj !== 'object')
        return obj;
    const r = obj;
    for (const key of Object.keys(r)) {
        if (r[key] === undefined) {
            delete r[key];
        }
    }
    return obj;
}
//# sourceMappingURL=GlobMatcher.js.map