import Mat33 from '../Mat33';
import { Point2 } from '../Vec2';
import Vec3 from '../Vec3';
import Abstract2DShape from './Abstract2DShape';
import LineSegment2 from './LineSegment2';
import Rect2 from './Rect2';
type TriangleBoundary = [LineSegment2, LineSegment2, LineSegment2];
export default class Triangle extends Abstract2DShape {
    #private;
    readonly vertex1: Vec3;
    readonly vertex2: Vec3;
    readonly vertex3: Vec3;
    /**
     * @see {@link fromVertices}
     */
    protected constructor(vertex1: Vec3, vertex2: Vec3, vertex3: Vec3);
    /**
     * Creates a triangle from its three corners. Corners may be stored in a different
     * order than given.
     */
    static fromVertices(vertex1: Vec3, vertex2: Vec3, vertex3: Vec3): Triangle;
    get vertices(): [Point2, Point2, Point2];
    map(mapping: (vertex: Vec3) => Vec3): Triangle;
    transformed2DBy(affineTransform: Mat33): Triangle;
    transformedBy(linearTransform: Mat33): Triangle;
    /**
     * Returns the sides of this triangle, as an array of `LineSegment2`s.
     *
     * The first side is from `vertex1` to `vertex2`, the next from `vertex2` to `vertex3`,
     * and the last from `vertex3` to `vertex1`.
     */
    getEdges(): TriangleBoundary;
    intersectsLineSegment(lineSegment: LineSegment2): Vec3[];
    /** @inheritdoc */
    containsPoint(point: Vec3, epsilon?: number): boolean;
    /**
     * @returns the signed distance from `point` to the closest edge of this triangle.
     *
     * If `point` is inside `this`, the result is negative, otherwise, the result is
     * positive.
     */
    signedDistance(point: Vec3): number;
    /** @inheritdoc */
    getTightBoundingBox(): Rect2;
}
export {};
