import  { Vec2 }  from '../Vec2.mjs';
import  Parameterized2DShape  from './Parameterized2DShape.mjs';
import  Rect2  from './Rect2.mjs';
/**
 * Like a {@link Point2}, but with additional functionality (e.g. SDF).
 *
 * Access the internal `Point2` using the `p` property.
 */
class PointShape2D extends Parameterized2DShape {
    constructor(p) {
        super();
        this.p = p;
    }
    signedDistance(point) {
        return this.p.distanceTo(point);
    }
    argIntersectsLineSegment(lineSegment, epsilon) {
        if (lineSegment.containsPoint(this.p, epsilon)) {
            return [0];
        }
        return [];
    }
    getTightBoundingBox() {
        return new Rect2(this.p.x, this.p.y, 0, 0);
    }
    at(_t) {
        return this.p;
    }
    /**
     * Returns an arbitrary unit-length vector.
     */
    normalAt(_t) {
        // Return a vector that makes sense.
        return Vec2.unitY;
    }
    tangentAt(_t) {
        return Vec2.unitX;
    }
    splitAt(_t) {
        return [this];
    }
    nearestPointTo(_point) {
        return {
            point: this.p,
            parameterValue: 0,
        };
    }
}
export default PointShape2D;
