import { Point2 } from '../Vec2';
import Vec3 from '../Vec3';
import LineSegment2 from './LineSegment2';
import Parameterized2DShape from './Parameterized2DShape';
import Rect2 from './Rect2';
/**
 * Like a {@link Point2}, but with additional functionality (e.g. SDF).
 *
 * Access the internal `Point2` using the `p` property.
 */
declare class PointShape2D extends Parameterized2DShape {
    readonly p: Point2;
    constructor(p: Point2);
    signedDistance(point: Vec3): number;
    argIntersectsLineSegment(lineSegment: LineSegment2, epsilon?: number): number[];
    getTightBoundingBox(): Rect2;
    at(_t: number): Vec3;
    /**
     * Returns an arbitrary unit-length vector.
     */
    normalAt(_t: number): {
        readonly x: number;
        readonly y: number;
        readonly z: number;
        readonly xy: {
            x: number;
            y: number;
        };
        at(idx: number): number;
        length(): number;
        magnitude(): number;
        magnitudeSquared(): number;
        squareDistanceTo(p: Vec3): number;
        distanceTo(p: Vec3): number;
        maximumEntryMagnitude(): number;
        angle(): number;
        normalized(): Vec3;
        normalizedOrZero(): Vec3;
        times(c: number): Vec3;
        plus(v: Vec3): Vec3;
        minus(v: Vec3): Vec3;
        dot(other: Vec3): number;
        cross(other: Vec3): Vec3;
        scale(other: Vec3 | number): Vec3;
        orthog(): Vec3;
        extend(distance: number, direction: Vec3): Vec3;
        lerp(target: Vec3, fractionTo: number): Vec3;
        zip(other: Vec3, zip: (componentInThis: number, componentInOther: number) => number): Vec3;
        map(fn: (component: number, index: number) => number): Vec3;
        asArray(): [number, number, number];
        eq(other: Vec3, fuzz?: number): boolean;
        toString(): string;
    };
    tangentAt(_t: number): Vec3;
    splitAt(_t: number): [PointShape2D];
    nearestPointTo(_point: Point2): {
        point: Vec3;
        parameterValue: number;
    };
}
export default PointShape2D;
