import  BezierJSWrapper  from './BezierJSWrapper.mjs';
import  Rect2  from './Rect2.mjs';
/**
 * A wrapper around [`bezier-js`](https://github.com/Pomax/bezierjs)'s cubic Bezier.
 */
class CubicBezier extends BezierJSWrapper {
    constructor(
    // Start point
    p0, 
    // Control point 1
    p1, 
    // Control point 2
    p2, 
    // End point
    p3) {
        super();
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
    }
    getPoints() {
        return [this.p0, this.p1, this.p2, this.p3];
    }
    /** Returns an overestimate of this shape's bounding box. */
    getLooseBoundingBox() {
        return Rect2.bboxOf([this.p0, this.p1, this.p2, this.p3]);
    }
}
export default CubicBezier;
