import { Point2 } from '../Vec2';
import BezierJSWrapper from './BezierJSWrapper';
import Rect2 from './Rect2';
/**
 * A wrapper around [`bezier-js`](https://github.com/Pomax/bezierjs)'s cubic Bezier.
 */
declare class CubicBezier extends BezierJSWrapper {
    readonly p0: Point2;
    readonly p1: Point2;
    readonly p2: Point2;
    readonly p3: Point2;
    constructor(p0: Point2, p1: Point2, p2: Point2, p3: Point2);
    getPoints(): import("../Vec3").Vec3[];
    /** Returns an overestimate of this shape's bounding box. */
    getLooseBoundingBox(): Rect2;
}
export default CubicBezier;
