import { Bezier } from 'bezier-js';
import { Point2, Vec2 } from '../Vec2';
import LineSegment2 from './LineSegment2';
import Rect2 from './Rect2';
import Parameterized2DShape from './Parameterized2DShape';
interface CorrectedBezierType extends Bezier {
    dderivative(t: number): {
        x: number;
        y: number;
    };
}
/**
 * A lazy-initializing wrapper around Bezier-js.
 *
 * Subclasses may override `at`, `derivativeAt`, and `normal` with functions
 * that do not initialize a `bezier-js` `Bezier`.
 *
 * **Do not use this class directly.** It may be removed/replaced in a future release.
 * @internal
 */
export declare abstract class BezierJSWrapper extends Parameterized2DShape {
    #private;
    protected constructor(bezierJsBezier?: Bezier);
    /** Returns the start, control points, and end point of this Bézier. */
    abstract getPoints(): readonly Point2[];
    protected getBezier(): CorrectedBezierType;
    signedDistance(point: Point2): number;
    /**
     * @returns the (more) exact distance from `point` to this.
     *
     * @see {@link approximateDistance}
     */
    distance(point: Point2): number;
    /**
     * @returns the curve evaluated at `t`.
     */
    at(t: number): Point2;
    /** @returns the curve's directional derivative at `t`. */
    derivativeAt(t: number): Point2;
    secondDerivativeAt(t: number): Point2;
    /** @returns the [normal vector](https://en.wikipedia.org/wiki/Normal_(geometry)) to this curve at `t`. */
    normal(t: number): Vec2;
    normalAt(t: number): Vec2;
    tangentAt(t: number): Vec2;
    getTightBoundingBox(): Rect2;
    argIntersectsLineSegment(line: LineSegment2): number[];
    splitAt(t: number): [BezierJSWrapper] | [BezierJSWrapper, BezierJSWrapper];
    nearestPointTo(point: Point2): {
        parameterValue: number;
        point: import("../Vec3").Vec3;
    };
    intersectsBezier(other: BezierJSWrapper): {
        parameterValue: number;
        point: import("../Vec3").Vec3;
    }[];
    toString(): string;
}
export default BezierJSWrapper;
