"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Vec2_1 = require("../Vec2");
const Parameterized2DShape_1 = __importDefault(require("./Parameterized2DShape"));
const Rect2_1 = __importDefault(require("./Rect2"));
/**
 * Like a {@link Point2}, but with additional functionality (e.g. SDF).
 *
 * Access the internal `Point2` using the `p` property.
 */
class PointShape2D extends Parameterized2DShape_1.default {
    constructor(p) {
        super();
        this.p = p;
    }
    signedDistance(point) {
        return this.p.distanceTo(point);
    }
    argIntersectsLineSegment(lineSegment, epsilon) {
        if (lineSegment.containsPoint(this.p, epsilon)) {
            return [0];
        }
        return [];
    }
    getTightBoundingBox() {
        return new Rect2_1.default(this.p.x, this.p.y, 0, 0);
    }
    at(_t) {
        return this.p;
    }
    /**
     * Returns an arbitrary unit-length vector.
     */
    normalAt(_t) {
        // Return a vector that makes sense.
        return Vec2_1.Vec2.unitY;
    }
    tangentAt(_t) {
        return Vec2_1.Vec2.unitX;
    }
    splitAt(_t) {
        return [this];
    }
    nearestPointTo(_point) {
        return {
            point: this.p,
            parameterValue: 0,
        };
    }
}
exports.default = PointShape2D;
