"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Parameterized2DShape = void 0;
const Abstract2DShape_1 = __importDefault(require("./Abstract2DShape"));
/**
 * A 2-dimensional path with parameter interval $t \in [0, 1]$.
 *
 * **Note:** Avoid extending this class outside of `js-draw` --- new abstract methods
 * may be added between minor versions.
 */
class Parameterized2DShape extends Abstract2DShape_1.default {
    intersectsLineSegment(line) {
        return this.argIntersectsLineSegment(line).map((t) => this.at(t));
    }
}
exports.Parameterized2DShape = Parameterized2DShape;
exports.default = Parameterized2DShape;
