"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const BezierJSWrapper_1 = __importDefault(require("./BezierJSWrapper"));
const Rect2_1 = __importDefault(require("./Rect2"));
/**
 * A wrapper around [`bezier-js`](https://github.com/Pomax/bezierjs)'s cubic Bezier.
 */
class CubicBezier extends BezierJSWrapper_1.default {
    constructor(
    // Start point
    p0, 
    // Control point 1
    p1, 
    // Control point 2
    p2, 
    // End point
    p3) {
        super();
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
    }
    getPoints() {
        return [this.p0, this.p1, this.p2, this.p3];
    }
    /** Returns an overestimate of this shape's bounding box. */
    getLooseBoundingBox() {
        return Rect2_1.default.bboxOf([this.p0, this.p1, this.p2, this.p3]);
    }
}
exports.default = CubicBezier;
