"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLenAfterDecimal = void 0;
const constants_1 = require("./constants");
/**
 * Returns the length of `numberAsString` after a decimal point.
 *
 * For example,
 * ```ts
 * getLenAfterDecimal('1.001') // -> 3
 * ```
 */
const getLenAfterDecimal = (numberAsString) => {
    const numberMatch = constants_1.numberRegex.exec(numberAsString);
    if (!numberMatch) {
        // If not a match, either the number is exponential notation (or is something
        // like NaN or Infinity)
        if (numberAsString.search(/[eE]/) !== -1 || /^[a-zA-Z]+$/.exec(numberAsString)) {
            return -1;
            // Or it has no decimal point
        }
        else {
            return 0;
        }
    }
    const afterDecimalLen = numberMatch[3].length;
    return afterDecimalLen;
};
exports.getLenAfterDecimal = getLenAfterDecimal;
exports.default = exports.getLenAfterDecimal;
