"use strict";
/**
 * This package contains general math utilities used by `js-draw`.
 * These include 2D and 3D vectors, 2D paths, and 3x3 matrices.
 *
 * ```ts,runnable,console
 * import { Vec2, Mat33, Rect2 } from '@js-draw/math';
 *
 * // Example: Rotate a vector 90 degrees about the z-axis
 * const rotate90Degrees = Mat33.zRotation(Math.PI/2); // π/2 radians = 90 deg
 * const moveUp = Mat33.translation(Vec2.of(1, 0));
 * const moveUpThenRotate = rotate90Degrees.rightMul(moveUp);
 * console.log(moveUpThenRotate.transformVec2(Vec2.of(1, 2)));
 *
 * // Example: Bounding box of some points
 * console.log(Rect2.bboxOf([
 *   Vec2.of(1, 2), Vec2.of(3, 4), Vec2.of(-100, 1000),
 * ]));
 * ```
 *
 * @packageDocumentation
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Color4 = exports.Vec3 = exports.Vec2 = exports.Mat33 = exports.Abstract2DShape = exports.QuadraticBezier = exports.Parameterized2DShape = exports.Rect2 = exports.PathCommandType = exports.comparePathIndices = exports.stepPathIndexBy = exports.Path = exports.LineSegment2 = void 0;
var LineSegment2_1 = require("./shapes/LineSegment2");
Object.defineProperty(exports, "LineSegment2", { enumerable: true, get: function () { return LineSegment2_1.LineSegment2; } });
var Path_1 = require("./shapes/Path");
Object.defineProperty(exports, "Path", { enumerable: true, get: function () { return Path_1.Path; } });
Object.defineProperty(exports, "stepPathIndexBy", { enumerable: true, get: function () { return Path_1.stepCurveIndexBy; } });
Object.defineProperty(exports, "comparePathIndices", { enumerable: true, get: function () { return Path_1.compareCurveIndices; } });
Object.defineProperty(exports, "PathCommandType", { enumerable: true, get: function () { return Path_1.PathCommandType; } });
var Rect2_1 = require("./shapes/Rect2");
Object.defineProperty(exports, "Rect2", { enumerable: true, get: function () { return Rect2_1.Rect2; } });
var Parameterized2DShape_1 = require("./shapes/Parameterized2DShape");
Object.defineProperty(exports, "Parameterized2DShape", { enumerable: true, get: function () { return Parameterized2DShape_1.Parameterized2DShape; } });
var QuadraticBezier_1 = require("./shapes/QuadraticBezier");
Object.defineProperty(exports, "QuadraticBezier", { enumerable: true, get: function () { return QuadraticBezier_1.QuadraticBezier; } });
var Abstract2DShape_1 = require("./shapes/Abstract2DShape");
Object.defineProperty(exports, "Abstract2DShape", { enumerable: true, get: function () { return Abstract2DShape_1.Abstract2DShape; } });
var Mat33_1 = require("./Mat33");
Object.defineProperty(exports, "Mat33", { enumerable: true, get: function () { return Mat33_1.Mat33; } });
var Vec2_1 = require("./Vec2");
Object.defineProperty(exports, "Vec2", { enumerable: true, get: function () { return Vec2_1.Vec2; } });
var Vec3_1 = require("./Vec3");
Object.defineProperty(exports, "Vec3", { enumerable: true, get: function () { return Vec3_1.Vec3; } });
var Color4_1 = require("./Color4");
Object.defineProperty(exports, "Color4", { enumerable: true, get: function () { return Color4_1.Color4; } });
__exportStar(require("./rounding/lib"), exports);
// Note: All above exports cannot use `export { default as ... } from "..."` because this
// breaks TypeDoc -- TypeDoc otherwise labels any imports of these classes as `default`.
