# @ts-graphviz/ast

> It is part of the ts-graphviz library, which is split into modular packages to improve maintainability, flexibility, and ease of use.

This package contains the module for processing the DOT language at the **A**bstract **S**yntax **T**ree (AST) level for the ts-graphviz library.

## Features

- Parsing and generating DOT language ASTs
- Functions for manipulating and transforming ASTs
- Support for custom AST nodes and attributes

## Usage

Import the necessary functions and classes from the `@ts-graphviz/ast` package:

```ts
import { parse, stringify } from '@ts-graphviz/ast';
```

Use the imported items in your project to work with DOT language ASTs:

```ts
const dotString = 'digraph G { A -> B; }';
const ast = parse(dotString);

const outputDotString = stringify(ast);
console.log('Output DOT string:', outputDotString);
```

For more examples and usage details, please refer to the ts-graphviz documentation.


## Contributing

Contributions to the ts-graphviz project are welcome.

Please refer to the main ts-graphviz repository for guidelines on how to contribute.

## License

This package is released under the MIT License.
