import dedent from "ts-dedent";
import dayjs from "dayjs";
import { sanitizeUrl } from "@braintree/sanitize-url";
import { select, curveBasis, curveBasisClosed, curveBasisOpen, curveBumpX, curveBumpY, curveBundle, curveCardinalClosed, curveCardinalOpen, curveCardinal, curveCatmullRomClosed, curveCatmullRomOpen, curveCatmullRom, curveLinear, curveLinearClosed, curveMonotoneX, curveMonotoneY, curveNatural, curveStep, curveStepAfter, curveStepBefore, line, selectAll, scaleTime, min, max, scaleLinear, interpolateHcl, axisBottom, timeFormat, timeMonth, timeWeek, timeDay, timeHour, timeMinute, axisTop, scaleOrdinal, pie, arc } from "d3";
import DOMPurify from "dompurify";
import { adjust, invert, darken, lighten, rgba } from "khroma";
import memoize from "lodash-es/memoize.js";
import { serialize, compile, stringify } from "stylis";
import { layout } from "dagre-d3-es/src/dagre/index.js";
import * as graphlib from "dagre-d3-es/src/graphlib/index.js";
import * as graphlibJson from "dagre-d3-es/src/graphlib/json.js";
import { v5 } from "uuid";
import { render as render$2 } from "dagre-d3-es";
import { applyStyle as applyStyle$1 } from "dagre-d3-es/src/dagre-js/util.js";
import { addHtmlLabel as addHtmlLabel$1 } from "dagre-d3-es/src/dagre-js/label/add-html-label.js";
import { intersectPolygon as intersectPolygon$1 } from "dagre-d3-es/src/dagre-js/intersect/intersect-polygon.js";
import { intersectRect as intersectRect$2 } from "dagre-d3-es/src/dagre-js/intersect/intersect-rect.js";
import dayjsIsoWeek from "dayjs/plugin/isoWeek.js";
import dayjsCustomParseFormat from "dayjs/plugin/customParseFormat.js";
import dayjsAdvancedFormat from "dayjs/plugin/advancedFormat.js";
import isEmpty from "lodash-es/isEmpty.js";
const LEVELS = {
  trace: 0,
  debug: 1,
  info: 2,
  warn: 3,
  error: 4,
  fatal: 5
};
const log$1 = {
  trace: (..._args) => {
  },
  debug: (..._args) => {
  },
  info: (..._args) => {
  },
  warn: (..._args) => {
  },
  error: (..._args) => {
  },
  fatal: (..._args) => {
  }
};
const setLogLevel$1 = function(level = "fatal") {
  let numericLevel = LEVELS.fatal;
  if (typeof level === "string") {
    level = level.toLowerCase();
    if (level in LEVELS) {
      numericLevel = LEVELS[level];
    }
  } else if (typeof level === "number") {
    numericLevel = level;
  }
  log$1.trace = () => {
  };
  log$1.debug = () => {
  };
  log$1.info = () => {
  };
  log$1.warn = () => {
  };
  log$1.error = () => {
  };
  log$1.fatal = () => {
  };
  if (numericLevel <= LEVELS.fatal) {
    log$1.fatal = console.error ? console.error.bind(console, format("FATAL"), "color: orange") : console.log.bind(console, "\x1B[35m", format("FATAL"));
  }
  if (numericLevel <= LEVELS.error) {
    log$1.error = console.error ? console.error.bind(console, format("ERROR"), "color: orange") : console.log.bind(console, "\x1B[31m", format("ERROR"));
  }
  if (numericLevel <= LEVELS.warn) {
    log$1.warn = console.warn ? console.warn.bind(console, format("WARN"), "color: orange") : console.log.bind(console, `\x1B[33m`, format("WARN"));
  }
  if (numericLevel <= LEVELS.info) {
    log$1.info = console.info ? console.info.bind(console, format("INFO"), "color: lightblue") : console.log.bind(console, "\x1B[34m", format("INFO"));
  }
  if (numericLevel <= LEVELS.debug) {
    log$1.debug = console.debug ? console.debug.bind(console, format("DEBUG"), "color: lightgreen") : console.log.bind(console, "\x1B[32m", format("DEBUG"));
  }
  if (numericLevel <= LEVELS.trace) {
    log$1.trace = console.debug ? console.debug.bind(console, format("TRACE"), "color: lightgreen") : console.log.bind(console, "\x1B[32m", format("TRACE"));
  }
};
const format = (level) => {
  const time = dayjs().format("ss.SSS");
  return `%c${time} : ${level} : `;
};
const getRows = (s) => {
  if (!s) {
    return [""];
  }
  const str2 = breakToPlaceholder(s).replace(/\\n/g, "#br#");
  return str2.split("#br#");
};
const removeScript = (txt) => {
  return DOMPurify.sanitize(txt);
};
const sanitizeMore = (text, config2) => {
  var _a;
  if (((_a = config2.flowchart) == null ? void 0 : _a.htmlLabels) !== false) {
    const level = config2.securityLevel;
    if (level === "antiscript" || level === "strict") {
      text = removeScript(text);
    } else if (level !== "loose") {
      text = breakToPlaceholder(text);
      text = text.replace(/</g, "&lt;").replace(/>/g, "&gt;");
      text = text.replace(/=/g, "&equals;");
      text = placeholderToBreak(text);
    }
  }
  return text;
};
const sanitizeText$5 = (text, config2) => {
  if (!text) {
    return text;
  }
  if (config2.dompurifyConfig) {
    text = DOMPurify.sanitize(sanitizeMore(text, config2), config2.dompurifyConfig).toString();
  } else {
    text = DOMPurify.sanitize(sanitizeMore(text, config2), {
      FORBID_TAGS: ["style"]
    }).toString();
  }
  return text;
};
const sanitizeTextOrArray = (a, config2) => {
  if (typeof a === "string") {
    return sanitizeText$5(a, config2);
  }
  return a.flat().map((x) => sanitizeText$5(x, config2));
};
const lineBreakRegex = /<br\s*\/?>/gi;
const hasBreaks = (text) => {
  return lineBreakRegex.test(text);
};
const splitBreaks = (text) => {
  return text.split(lineBreakRegex);
};
const placeholderToBreak = (s) => {
  return s.replace(/#br#/g, "<br/>");
};
const breakToPlaceholder = (s) => {
  return s.replace(lineBreakRegex, "#br#");
};
const getUrl = (useAbsolute) => {
  let url = "";
  if (useAbsolute) {
    url = window.location.protocol + "//" + window.location.host + window.location.pathname + window.location.search;
    url = url.replaceAll(/\(/g, "\\(");
    url = url.replaceAll(/\)/g, "\\)");
  }
  return url;
};
const evaluate = (val) => val === false || ["false", "null", "0"].includes(String(val).trim().toLowerCase()) ? false : true;
const parseGenericTypes = function(text) {
  let cleanedText = text;
  if (text.split("~").length - 1 >= 2) {
    let newCleanedText = cleanedText;
    do {
      cleanedText = newCleanedText;
      newCleanedText = cleanedText.replace(/~([^\s,:;]+)~/, "<$1>");
    } while (newCleanedText != cleanedText);
    return parseGenericTypes(newCleanedText);
  } else {
    return cleanedText;
  }
};
const common$1 = {
  getRows,
  sanitizeText: sanitizeText$5,
  sanitizeTextOrArray,
  hasBreaks,
  splitBreaks,
  lineBreakRegex,
  removeScript,
  getUrl,
  evaluate
};
const mkBorder = (col, darkMode) => darkMode ? adjust(col, { s: -40, l: 10 }) : adjust(col, { s: -40, l: -10 });
const oldAttributeBackgroundColorOdd = "#ffffff";
const oldAttributeBackgroundColorEven = "#f2f2f2";
let Theme$4 = class Theme {
  constructor() {
    this.background = "#f4f4f4";
    this.primaryColor = "#fff4dd";
    this.noteBkgColor = "#fff5ad";
    this.noteTextColor = "#333";
    this.THEME_COLOR_LIMIT = 12;
    this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
    this.fontSize = "16px";
  }
  updateColors() {
    this.primaryTextColor = this.primaryTextColor || (this.darkMode ? "#eee" : "#333");
    this.secondaryColor = this.secondaryColor || adjust(this.primaryColor, { h: -120 });
    this.tertiaryColor = this.tertiaryColor || adjust(this.primaryColor, { h: 180, l: 5 });
    this.primaryBorderColor = this.primaryBorderColor || mkBorder(this.primaryColor, this.darkMode);
    this.secondaryBorderColor = this.secondaryBorderColor || mkBorder(this.secondaryColor, this.darkMode);
    this.tertiaryBorderColor = this.tertiaryBorderColor || mkBorder(this.tertiaryColor, this.darkMode);
    this.noteBorderColor = this.noteBorderColor || mkBorder(this.noteBkgColor, this.darkMode);
    this.noteBkgColor = this.noteBkgColor || "#fff5ad";
    this.noteTextColor = this.noteTextColor || "#333";
    this.secondaryTextColor = this.secondaryTextColor || invert(this.secondaryColor);
    this.tertiaryTextColor = this.tertiaryTextColor || invert(this.tertiaryColor);
    this.lineColor = this.lineColor || invert(this.background);
    this.textColor = this.textColor || this.primaryTextColor;
    this.nodeBkg = this.nodeBkg || this.primaryColor;
    this.mainBkg = this.mainBkg || this.primaryColor;
    this.nodeBorder = this.nodeBorder || this.primaryBorderColor;
    this.clusterBkg = this.clusterBkg || this.tertiaryColor;
    this.clusterBorder = this.clusterBorder || this.tertiaryBorderColor;
    this.defaultLinkColor = this.defaultLinkColor || this.lineColor;
    this.titleColor = this.titleColor || this.tertiaryTextColor;
    this.edgeLabelBackground = this.edgeLabelBackground || (this.darkMode ? darken(this.secondaryColor, 30) : this.secondaryColor);
    this.nodeTextColor = this.nodeTextColor || this.primaryTextColor;
    this.actorBorder = this.actorBorder || this.primaryBorderColor;
    this.actorBkg = this.actorBkg || this.mainBkg;
    this.actorTextColor = this.actorTextColor || this.primaryTextColor;
    this.actorLineColor = this.actorLineColor || "grey";
    this.labelBoxBkgColor = this.labelBoxBkgColor || this.actorBkg;
    this.signalColor = this.signalColor || this.textColor;
    this.signalTextColor = this.signalTextColor || this.textColor;
    this.labelBoxBorderColor = this.labelBoxBorderColor || this.actorBorder;
    this.labelTextColor = this.labelTextColor || this.actorTextColor;
    this.loopTextColor = this.loopTextColor || this.actorTextColor;
    this.activationBorderColor = this.activationBorderColor || darken(this.secondaryColor, 10);
    this.activationBkgColor = this.activationBkgColor || this.secondaryColor;
    this.sequenceNumberColor = this.sequenceNumberColor || invert(this.lineColor);
    this.sectionBkgColor = this.sectionBkgColor || this.tertiaryColor;
    this.altSectionBkgColor = this.altSectionBkgColor || "white";
    this.sectionBkgColor = this.sectionBkgColor || this.secondaryColor;
    this.sectionBkgColor2 = this.sectionBkgColor2 || this.primaryColor;
    this.excludeBkgColor = this.excludeBkgColor || "#eeeeee";
    this.taskBorderColor = this.taskBorderColor || this.primaryBorderColor;
    this.taskBkgColor = this.taskBkgColor || this.primaryColor;
    this.activeTaskBorderColor = this.activeTaskBorderColor || this.primaryColor;
    this.activeTaskBkgColor = this.activeTaskBkgColor || lighten(this.primaryColor, 23);
    this.gridColor = this.gridColor || "lightgrey";
    this.doneTaskBkgColor = this.doneTaskBkgColor || "lightgrey";
    this.doneTaskBorderColor = this.doneTaskBorderColor || "grey";
    this.critBorderColor = this.critBorderColor || "#ff8888";
    this.critBkgColor = this.critBkgColor || "red";
    this.todayLineColor = this.todayLineColor || "red";
    this.taskTextColor = this.taskTextColor || this.textColor;
    this.taskTextOutsideColor = this.taskTextOutsideColor || this.textColor;
    this.taskTextLightColor = this.taskTextLightColor || this.textColor;
    this.taskTextColor = this.taskTextColor || this.primaryTextColor;
    this.taskTextDarkColor = this.taskTextDarkColor || this.textColor;
    this.taskTextClickableColor = this.taskTextClickableColor || "#003163";
    this.personBorder = this.personBorder || this.primaryBorderColor;
    this.personBkg = this.personBkg || this.mainBkg;
    this.transitionColor = this.transitionColor || this.lineColor;
    this.transitionLabelColor = this.transitionLabelColor || this.textColor;
    this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
    this.stateBkg = this.stateBkg || this.mainBkg;
    this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
    this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
    this.altBackground = this.altBackground || this.tertiaryColor;
    this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
    this.compositeBorder = this.compositeBorder || this.nodeBorder;
    this.innerEndBackground = this.nodeBorder;
    this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
    this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
    this.transitionColor = this.transitionColor || this.lineColor;
    this.specialStateColor = this.lineColor;
    this.cScale0 = this.cScale0 || this.primaryColor;
    this.cScale1 = this.cScale1 || this.secondaryColor;
    this.cScale2 = this.cScale2 || this.tertiaryColor;
    this.cScale3 = this.cScale3 || adjust(this.primaryColor, { h: 30 });
    this.cScale4 = this.cScale4 || adjust(this.primaryColor, { h: 60 });
    this.cScale5 = this.cScale5 || adjust(this.primaryColor, { h: 90 });
    this.cScale6 = this.cScale6 || adjust(this.primaryColor, { h: 120 });
    this.cScale7 = this.cScale7 || adjust(this.primaryColor, { h: 150 });
    this.cScale8 = this.cScale8 || adjust(this.primaryColor, { h: 210, l: 150 });
    this.cScale9 = this.cScale9 || adjust(this.primaryColor, { h: 270 });
    this.cScale10 = this.cScale10 || adjust(this.primaryColor, { h: 300 });
    this.cScale11 = this.cScale11 || adjust(this.primaryColor, { h: 330 });
    if (this.darkMode) {
      for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
        this["cScale" + i] = darken(this["cScale" + i], 75);
      }
    } else {
      for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
        this["cScale" + i] = darken(this["cScale" + i], 25);
      }
    }
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["cScaleInv" + i] = this["cScaleInv" + i] || invert(this["cScale" + i]);
    }
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      if (this.darkMode) {
        this["cScalePeer" + i] = this["cScalePeer" + i] || lighten(this["cScale" + i], 10);
      } else {
        this["cScalePeer" + i] = this["cScalePeer" + i] || darken(this["cScale" + i], 10);
      }
    }
    this.scaleLabelColor = this.scaleLabelColor || this.labelTextColor;
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["cScaleLabel" + i] = this["cScaleLabel" + i] || this.scaleLabelColor;
    }
    const multiplier = this.darkMode ? -4 : -1;
    for (let i = 0; i < 5; i++) {
      this["surface" + i] = this["surface" + i] || adjust(this.mainBkg, { h: 180, s: -15, l: multiplier * (5 + i * 3) });
      this["surfacePeer" + i] = this["surfacePeer" + i] || adjust(this.mainBkg, { h: 180, s: -15, l: multiplier * (8 + i * 3) });
    }
    this.classText = this.classText || this.textColor;
    this.fillType0 = this.fillType0 || this.primaryColor;
    this.fillType1 = this.fillType1 || this.secondaryColor;
    this.fillType2 = this.fillType2 || adjust(this.primaryColor, { h: 64 });
    this.fillType3 = this.fillType3 || adjust(this.secondaryColor, { h: 64 });
    this.fillType4 = this.fillType4 || adjust(this.primaryColor, { h: -64 });
    this.fillType5 = this.fillType5 || adjust(this.secondaryColor, { h: -64 });
    this.fillType6 = this.fillType6 || adjust(this.primaryColor, { h: 128 });
    this.fillType7 = this.fillType7 || adjust(this.secondaryColor, { h: 128 });
    this.pie1 = this.pie1 || this.primaryColor;
    this.pie2 = this.pie2 || this.secondaryColor;
    this.pie3 = this.pie3 || this.tertiaryColor;
    this.pie4 = this.pie4 || adjust(this.primaryColor, { l: -10 });
    this.pie5 = this.pie5 || adjust(this.secondaryColor, { l: -10 });
    this.pie6 = this.pie6 || adjust(this.tertiaryColor, { l: -10 });
    this.pie7 = this.pie7 || adjust(this.primaryColor, { h: 60, l: -10 });
    this.pie8 = this.pie8 || adjust(this.primaryColor, { h: -60, l: -10 });
    this.pie9 = this.pie9 || adjust(this.primaryColor, { h: 120, l: 0 });
    this.pie10 = this.pie10 || adjust(this.primaryColor, { h: 60, l: -20 });
    this.pie11 = this.pie11 || adjust(this.primaryColor, { h: -60, l: -20 });
    this.pie12 = this.pie12 || adjust(this.primaryColor, { h: 120, l: -10 });
    this.pieTitleTextSize = this.pieTitleTextSize || "25px";
    this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
    this.pieSectionTextSize = this.pieSectionTextSize || "17px";
    this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
    this.pieLegendTextSize = this.pieLegendTextSize || "17px";
    this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
    this.pieStrokeColor = this.pieStrokeColor || "black";
    this.pieStrokeWidth = this.pieStrokeWidth || "2px";
    this.pieOpacity = this.pieOpacity || "0.7";
    this.requirementBackground = this.requirementBackground || this.primaryColor;
    this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
    this.requirementBorderSize = this.requirementBorderSize || this.primaryBorderColor;
    this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
    this.relationColor = this.relationColor || this.lineColor;
    this.relationLabelBackground = this.relationLabelBackground || (this.darkMode ? darken(this.secondaryColor, 30) : this.secondaryColor);
    this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
    this.git0 = this.git0 || this.primaryColor;
    this.git1 = this.git1 || this.secondaryColor;
    this.git2 = this.git2 || this.tertiaryColor;
    this.git3 = this.git3 || adjust(this.primaryColor, { h: -30 });
    this.git4 = this.git4 || adjust(this.primaryColor, { h: -60 });
    this.git5 = this.git5 || adjust(this.primaryColor, { h: -90 });
    this.git6 = this.git6 || adjust(this.primaryColor, { h: 60 });
    this.git7 = this.git7 || adjust(this.primaryColor, { h: 120 });
    if (this.darkMode) {
      this.git0 = lighten(this.git0, 25);
      this.git1 = lighten(this.git1, 25);
      this.git2 = lighten(this.git2, 25);
      this.git3 = lighten(this.git3, 25);
      this.git4 = lighten(this.git4, 25);
      this.git5 = lighten(this.git5, 25);
      this.git6 = lighten(this.git6, 25);
      this.git7 = lighten(this.git7, 25);
    } else {
      this.git0 = darken(this.git0, 25);
      this.git1 = darken(this.git1, 25);
      this.git2 = darken(this.git2, 25);
      this.git3 = darken(this.git3, 25);
      this.git4 = darken(this.git4, 25);
      this.git5 = darken(this.git5, 25);
      this.git6 = darken(this.git6, 25);
      this.git7 = darken(this.git7, 25);
    }
    this.gitInv0 = this.gitInv0 || invert(this.git0);
    this.gitInv1 = this.gitInv1 || invert(this.git1);
    this.gitInv2 = this.gitInv2 || invert(this.git2);
    this.gitInv3 = this.gitInv3 || invert(this.git3);
    this.gitInv4 = this.gitInv4 || invert(this.git4);
    this.gitInv5 = this.gitInv5 || invert(this.git5);
    this.gitInv6 = this.gitInv6 || invert(this.git6);
    this.gitInv7 = this.gitInv7 || invert(this.git7);
    this.branchLabelColor = this.branchLabelColor || (this.darkMode ? "black" : this.labelTextColor);
    this.gitBranchLabel0 = this.gitBranchLabel0 || this.branchLabelColor;
    this.gitBranchLabel1 = this.gitBranchLabel1 || this.branchLabelColor;
    this.gitBranchLabel2 = this.gitBranchLabel2 || this.branchLabelColor;
    this.gitBranchLabel3 = this.gitBranchLabel3 || this.branchLabelColor;
    this.gitBranchLabel4 = this.gitBranchLabel4 || this.branchLabelColor;
    this.gitBranchLabel5 = this.gitBranchLabel5 || this.branchLabelColor;
    this.gitBranchLabel6 = this.gitBranchLabel6 || this.branchLabelColor;
    this.gitBranchLabel7 = this.gitBranchLabel7 || this.branchLabelColor;
    this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
    this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
    this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
    this.tagLabelFontSize = this.tagLabelFontSize || "10px";
    this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
    this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
    this.commitLabelFontSize = this.commitLabelFontSize || "10px";
    this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
    this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
  }
  calculate(overrides) {
    if (typeof overrides !== "object") {
      this.updateColors();
      return;
    }
    const keys2 = Object.keys(overrides);
    keys2.forEach((k) => {
      this[k] = overrides[k];
    });
    this.updateColors();
    keys2.forEach((k) => {
      this[k] = overrides[k];
    });
  }
};
const getThemeVariables$4 = (userOverrides) => {
  const theme2 = new Theme$4();
  theme2.calculate(userOverrides);
  return theme2;
};
let Theme$3 = class Theme2 {
  constructor() {
    this.background = "#333";
    this.primaryColor = "#1f2020";
    this.secondaryColor = lighten(this.primaryColor, 16);
    this.tertiaryColor = adjust(this.primaryColor, { h: -160 });
    this.primaryBorderColor = invert(this.background);
    this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
    this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
    this.primaryTextColor = invert(this.primaryColor);
    this.secondaryTextColor = invert(this.secondaryColor);
    this.tertiaryTextColor = invert(this.tertiaryColor);
    this.lineColor = invert(this.background);
    this.textColor = invert(this.background);
    this.mainBkg = "#1f2020";
    this.secondBkg = "calculated";
    this.mainContrastColor = "lightgrey";
    this.darkTextColor = lighten(invert("#323D47"), 10);
    this.lineColor = "calculated";
    this.border1 = "#81B1DB";
    this.border2 = rgba(255, 255, 255, 0.25);
    this.arrowheadColor = "calculated";
    this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
    this.fontSize = "16px";
    this.labelBackground = "#181818";
    this.textColor = "#ccc";
    this.THEME_COLOR_LIMIT = 12;
    this.nodeBkg = "calculated";
    this.nodeBorder = "calculated";
    this.clusterBkg = "calculated";
    this.clusterBorder = "calculated";
    this.defaultLinkColor = "calculated";
    this.titleColor = "#F9FFFE";
    this.edgeLabelBackground = "calculated";
    this.actorBorder = "calculated";
    this.actorBkg = "calculated";
    this.actorTextColor = "calculated";
    this.actorLineColor = "calculated";
    this.signalColor = "calculated";
    this.signalTextColor = "calculated";
    this.labelBoxBkgColor = "calculated";
    this.labelBoxBorderColor = "calculated";
    this.labelTextColor = "calculated";
    this.loopTextColor = "calculated";
    this.noteBorderColor = "calculated";
    this.noteBkgColor = "#fff5ad";
    this.noteTextColor = "calculated";
    this.activationBorderColor = "calculated";
    this.activationBkgColor = "calculated";
    this.sequenceNumberColor = "black";
    this.sectionBkgColor = darken("#EAE8D9", 30);
    this.altSectionBkgColor = "calculated";
    this.sectionBkgColor2 = "#EAE8D9";
    this.taskBorderColor = rgba(255, 255, 255, 70);
    this.taskBkgColor = "calculated";
    this.taskTextColor = "calculated";
    this.taskTextLightColor = "calculated";
    this.taskTextOutsideColor = "calculated";
    this.taskTextClickableColor = "#003163";
    this.activeTaskBorderColor = rgba(255, 255, 255, 50);
    this.activeTaskBkgColor = "#81B1DB";
    this.gridColor = "calculated";
    this.doneTaskBkgColor = "calculated";
    this.doneTaskBorderColor = "grey";
    this.critBorderColor = "#E83737";
    this.critBkgColor = "#E83737";
    this.taskTextDarkColor = "calculated";
    this.todayLineColor = "#DB5757";
    this.personBorder = "calculated";
    this.personBkg = "calculated";
    this.labelColor = "calculated";
    this.errorBkgColor = "#a44141";
    this.errorTextColor = "#ddd";
  }
  updateColors() {
    this.secondBkg = lighten(this.mainBkg, 16);
    this.lineColor = this.mainContrastColor;
    this.arrowheadColor = this.mainContrastColor;
    this.nodeBkg = this.mainBkg;
    this.nodeBorder = this.border1;
    this.clusterBkg = this.secondBkg;
    this.clusterBorder = this.border2;
    this.defaultLinkColor = this.lineColor;
    this.edgeLabelBackground = lighten(this.labelBackground, 25);
    this.actorBorder = this.border1;
    this.actorBkg = this.mainBkg;
    this.actorTextColor = this.mainContrastColor;
    this.actorLineColor = this.mainContrastColor;
    this.signalColor = this.mainContrastColor;
    this.signalTextColor = this.mainContrastColor;
    this.labelBoxBkgColor = this.actorBkg;
    this.labelBoxBorderColor = this.actorBorder;
    this.labelTextColor = this.mainContrastColor;
    this.loopTextColor = this.mainContrastColor;
    this.noteBorderColor = this.secondaryBorderColor;
    this.noteBkgColor = this.secondBkg;
    this.noteTextColor = this.secondaryTextColor;
    this.activationBorderColor = this.border1;
    this.activationBkgColor = this.secondBkg;
    this.altSectionBkgColor = this.background;
    this.taskBkgColor = lighten(this.mainBkg, 23);
    this.taskTextColor = this.darkTextColor;
    this.taskTextLightColor = this.mainContrastColor;
    this.taskTextOutsideColor = this.taskTextLightColor;
    this.gridColor = this.mainContrastColor;
    this.doneTaskBkgColor = this.mainContrastColor;
    this.taskTextDarkColor = this.darkTextColor;
    this.transitionColor = this.transitionColor || this.lineColor;
    this.transitionLabelColor = this.transitionLabelColor || this.textColor;
    this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
    this.stateBkg = this.stateBkg || this.mainBkg;
    this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
    this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
    this.altBackground = this.altBackground || "#555";
    this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
    this.compositeBorder = this.compositeBorder || this.nodeBorder;
    this.innerEndBackground = this.primaryBorderColor;
    this.specialStateColor = "#f4f4f4";
    this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
    this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
    this.fillType0 = this.primaryColor;
    this.fillType1 = this.secondaryColor;
    this.fillType2 = adjust(this.primaryColor, { h: 64 });
    this.fillType3 = adjust(this.secondaryColor, { h: 64 });
    this.fillType4 = adjust(this.primaryColor, { h: -64 });
    this.fillType5 = adjust(this.secondaryColor, { h: -64 });
    this.fillType6 = adjust(this.primaryColor, { h: 128 });
    this.fillType7 = adjust(this.secondaryColor, { h: 128 });
    this.cScale1 = this.cScale1 || "#0b0000";
    this.cScale2 = this.cScale2 || "#4d1037";
    this.cScale3 = this.cScale3 || "#3f5258";
    this.cScale4 = this.cScale4 || "#4f2f1b";
    this.cScale5 = this.cScale5 || "#6e0a0a";
    this.cScale6 = this.cScale6 || "#3b0048";
    this.cScale7 = this.cScale7 || "#995a01";
    this.cScale8 = this.cScale8 || "#154706";
    this.cScale9 = this.cScale9 || "#161722";
    this.cScale10 = this.cScale10 || "#00296f";
    this.cScale11 = this.cScale11 || "#01629c";
    this.cScale12 = this.cScale12 || "#010029";
    this.cScale0 = this.cScale0 || this.primaryColor;
    this.cScale1 = this.cScale1 || this.secondaryColor;
    this.cScale2 = this.cScale2 || this.tertiaryColor;
    this.cScale3 = this.cScale3 || adjust(this.primaryColor, { h: 30 });
    this.cScale4 = this.cScale4 || adjust(this.primaryColor, { h: 60 });
    this.cScale5 = this.cScale5 || adjust(this.primaryColor, { h: 90 });
    this.cScale6 = this.cScale6 || adjust(this.primaryColor, { h: 120 });
    this.cScale7 = this.cScale7 || adjust(this.primaryColor, { h: 150 });
    this.cScale8 = this.cScale8 || adjust(this.primaryColor, { h: 210 });
    this.cScale9 = this.cScale9 || adjust(this.primaryColor, { h: 270 });
    this.cScale10 = this.cScale10 || adjust(this.primaryColor, { h: 300 });
    this.cScale11 = this.cScale11 || adjust(this.primaryColor, { h: 330 });
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["cScaleInv" + i] = this["cScaleInv" + i] || invert(this["cScale" + i]);
    }
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["cScalePeer" + i] = this["cScalePeer" + i] || lighten(this["cScale" + i], 10);
    }
    for (let i = 0; i < 5; i++) {
      this["surface" + i] = this["surface" + i] || adjust(this.mainBkg, { h: 30, s: -30, l: -(-10 + i * 4) });
      this["surfacePeer" + i] = this["surfacePeer" + i] || adjust(this.mainBkg, { h: 30, s: -30, l: -(-7 + i * 4) });
    }
    this.scaleLabelColor = this.scaleLabelColor || (this.darkMode ? "black" : this.labelTextColor);
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["cScaleLabel" + i] = this["cScaleLabel" + i] || this.scaleLabelColor;
    }
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["pie" + i] = this["cScale" + i];
    }
    this.pieTitleTextSize = this.pieTitleTextSize || "25px";
    this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
    this.pieSectionTextSize = this.pieSectionTextSize || "17px";
    this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
    this.pieLegendTextSize = this.pieLegendTextSize || "17px";
    this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
    this.pieStrokeColor = this.pieStrokeColor || "black";
    this.pieStrokeWidth = this.pieStrokeWidth || "2px";
    this.pieOpacity = this.pieOpacity || "0.7";
    this.classText = this.primaryTextColor;
    this.requirementBackground = this.requirementBackground || this.primaryColor;
    this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
    this.requirementBorderSize = this.requirementBorderSize || this.primaryBorderColor;
    this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
    this.relationColor = this.relationColor || this.lineColor;
    this.relationLabelBackground = this.relationLabelBackground || (this.darkMode ? darken(this.secondaryColor, 30) : this.secondaryColor);
    this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
    this.git0 = lighten(this.secondaryColor, 20);
    this.git1 = lighten(this.pie2 || this.secondaryColor, 20);
    this.git2 = lighten(this.pie3 || this.tertiaryColor, 20);
    this.git3 = lighten(this.pie4 || adjust(this.primaryColor, { h: -30 }), 20);
    this.git4 = lighten(this.pie5 || adjust(this.primaryColor, { h: -60 }), 20);
    this.git5 = lighten(this.pie6 || adjust(this.primaryColor, { h: -90 }), 10);
    this.git6 = lighten(this.pie7 || adjust(this.primaryColor, { h: 60 }), 10);
    this.git7 = lighten(this.pie8 || adjust(this.primaryColor, { h: 120 }), 20);
    this.gitInv0 = this.gitInv0 || invert(this.git0);
    this.gitInv1 = this.gitInv1 || invert(this.git1);
    this.gitInv2 = this.gitInv2 || invert(this.git2);
    this.gitInv3 = this.gitInv3 || invert(this.git3);
    this.gitInv4 = this.gitInv4 || invert(this.git4);
    this.gitInv5 = this.gitInv5 || invert(this.git5);
    this.gitInv6 = this.gitInv6 || invert(this.git6);
    this.gitInv7 = this.gitInv7 || invert(this.git7);
    this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
    this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
    this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
    this.tagLabelFontSize = this.tagLabelFontSize || "10px";
    this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
    this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
    this.commitLabelFontSize = this.commitLabelFontSize || "10px";
    this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || lighten(this.background, 12);
    this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || lighten(this.background, 2);
  }
  calculate(overrides) {
    if (typeof overrides !== "object") {
      this.updateColors();
      return;
    }
    const keys2 = Object.keys(overrides);
    keys2.forEach((k) => {
      this[k] = overrides[k];
    });
    this.updateColors();
    keys2.forEach((k) => {
      this[k] = overrides[k];
    });
  }
};
const getThemeVariables$3 = (userOverrides) => {
  const theme2 = new Theme$3();
  theme2.calculate(userOverrides);
  return theme2;
};
let Theme$2 = class Theme3 {
  constructor() {
    this.background = "#f4f4f4";
    this.primaryColor = "#ECECFF";
    this.secondaryColor = adjust(this.primaryColor, { h: 120 });
    this.secondaryColor = "#ffffde";
    this.tertiaryColor = adjust(this.primaryColor, { h: -160 });
    this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
    this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
    this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
    this.primaryTextColor = invert(this.primaryColor);
    this.secondaryTextColor = invert(this.secondaryColor);
    this.tertiaryTextColor = invert(this.tertiaryColor);
    this.lineColor = invert(this.background);
    this.textColor = invert(this.background);
    this.background = "white";
    this.mainBkg = "#ECECFF";
    this.secondBkg = "#ffffde";
    this.lineColor = "#333333";
    this.border1 = "#9370DB";
    this.border2 = "#aaaa33";
    this.arrowheadColor = "#333333";
    this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
    this.fontSize = "16px";
    this.labelBackground = "#e8e8e8";
    this.textColor = "#333";
    this.THEME_COLOR_LIMIT = 12;
    this.nodeBkg = "calculated";
    this.nodeBorder = "calculated";
    this.clusterBkg = "calculated";
    this.clusterBorder = "calculated";
    this.defaultLinkColor = "calculated";
    this.titleColor = "calculated";
    this.edgeLabelBackground = "calculated";
    this.actorBorder = "calculated";
    this.actorBkg = "calculated";
    this.actorTextColor = "black";
    this.actorLineColor = "grey";
    this.signalColor = "calculated";
    this.signalTextColor = "calculated";
    this.labelBoxBkgColor = "calculated";
    this.labelBoxBorderColor = "calculated";
    this.labelTextColor = "calculated";
    this.loopTextColor = "calculated";
    this.noteBorderColor = "calculated";
    this.noteBkgColor = "#fff5ad";
    this.noteTextColor = "calculated";
    this.activationBorderColor = "#666";
    this.activationBkgColor = "#f4f4f4";
    this.sequenceNumberColor = "white";
    this.sectionBkgColor = "calculated";
    this.altSectionBkgColor = "calculated";
    this.sectionBkgColor2 = "calculated";
    this.excludeBkgColor = "#eeeeee";
    this.taskBorderColor = "calculated";
    this.taskBkgColor = "calculated";
    this.taskTextLightColor = "calculated";
    this.taskTextColor = this.taskTextLightColor;
    this.taskTextDarkColor = "calculated";
    this.taskTextOutsideColor = this.taskTextDarkColor;
    this.taskTextClickableColor = "calculated";
    this.activeTaskBorderColor = "calculated";
    this.activeTaskBkgColor = "calculated";
    this.gridColor = "calculated";
    this.doneTaskBkgColor = "calculated";
    this.doneTaskBorderColor = "calculated";
    this.critBorderColor = "calculated";
    this.critBkgColor = "calculated";
    this.todayLineColor = "calculated";
    this.sectionBkgColor = rgba(102, 102, 255, 0.49);
    this.altSectionBkgColor = "white";
    this.sectionBkgColor2 = "#fff400";
    this.taskBorderColor = "#534fbc";
    this.taskBkgColor = "#8a90dd";
    this.taskTextLightColor = "white";
    this.taskTextColor = "calculated";
    this.taskTextDarkColor = "black";
    this.taskTextOutsideColor = "calculated";
    this.taskTextClickableColor = "#003163";
    this.activeTaskBorderColor = "#534fbc";
    this.activeTaskBkgColor = "#bfc7ff";
    this.gridColor = "lightgrey";
    this.doneTaskBkgColor = "lightgrey";
    this.doneTaskBorderColor = "grey";
    this.critBorderColor = "#ff8888";
    this.critBkgColor = "red";
    this.todayLineColor = "red";
    this.personBorder = "calculated";
    this.personBkg = "calculated";
    this.labelColor = "black";
    this.errorBkgColor = "#552222";
    this.errorTextColor = "#552222";
    this.updateColors();
  }
  updateColors() {
    this.cScale0 = this.cScale0 || this.primaryColor;
    this.cScale1 = this.cScale1 || this.secondaryColor;
    this.cScale2 = this.cScale2 || this.tertiaryColor;
    this.cScale3 = this.cScale3 || adjust(this.primaryColor, { h: 30 });
    this.cScale4 = this.cScale4 || adjust(this.primaryColor, { h: 60 });
    this.cScale5 = this.cScale5 || adjust(this.primaryColor, { h: 90 });
    this.cScale6 = this.cScale6 || adjust(this.primaryColor, { h: 120 });
    this.cScale7 = this.cScale7 || adjust(this.primaryColor, { h: 150 });
    this.cScale8 = this.cScale8 || adjust(this.primaryColor, { h: 210 });
    this.cScale9 = this.cScale9 || adjust(this.primaryColor, { h: 270 });
    this.cScale10 = this.cScale10 || adjust(this.primaryColor, { h: 300 });
    this.cScale11 = this.cScale11 || adjust(this.primaryColor, { h: 330 });
    this["cScalePeer" + 1] = this["cScalePeer" + 1] || darken(this.secondaryColor, 45);
    this["cScalePeer" + 2] = this["cScalePeer" + 2] || darken(this.tertiaryColor, 40);
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["cScale" + i] = darken(this["cScale" + i], 10);
      this["cScalePeer" + i] = this["cScalePeer" + i] || darken(this["cScale" + i], 25);
    }
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["cScaleInv" + i] = this["cScaleInv" + i] || adjust(this["cScale" + i], { h: 180 });
    }
    for (let i = 0; i < 5; i++) {
      this["surface" + i] = this["surface" + i] || adjust(this.mainBkg, { h: 30, l: -(5 + i * 5) });
      this["surfacePeer" + i] = this["surfacePeer" + i] || adjust(this.mainBkg, { h: 30, l: -(7 + i * 5) });
    }
    this.scaleLabelColor = this.scaleLabelColor !== "calculated" && this.scaleLabelColor ? this.scaleLabelColor : this.labelTextColor;
    if (this.labelTextColor !== "calculated") {
      this.cScaleLabel0 = this.cScaleLabel0 || invert(this.labelTextColor);
      this.cScaleLabel3 = this.cScaleLabel3 || invert(this.labelTextColor);
      for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
        this["cScaleLabel" + i] = this["cScaleLabel" + i] || this.labelTextColor;
      }
    }
    this.nodeBkg = this.mainBkg;
    this.nodeBorder = this.border1;
    this.clusterBkg = this.secondBkg;
    this.clusterBorder = this.border2;
    this.defaultLinkColor = this.lineColor;
    this.titleColor = this.textColor;
    this.edgeLabelBackground = this.labelBackground;
    this.actorBorder = lighten(this.border1, 23);
    this.actorBkg = this.mainBkg;
    this.labelBoxBkgColor = this.actorBkg;
    this.signalColor = this.textColor;
    this.signalTextColor = this.textColor;
    this.labelBoxBorderColor = this.actorBorder;
    this.labelTextColor = this.actorTextColor;
    this.loopTextColor = this.actorTextColor;
    this.noteBorderColor = this.border2;
    this.noteTextColor = this.actorTextColor;
    this.taskTextColor = this.taskTextLightColor;
    this.taskTextOutsideColor = this.taskTextDarkColor;
    this.transitionColor = this.transitionColor || this.lineColor;
    this.transitionLabelColor = this.transitionLabelColor || this.textColor;
    this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
    this.stateBkg = this.stateBkg || this.mainBkg;
    this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
    this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
    this.altBackground = this.altBackground || "#f0f0f0";
    this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
    this.compositeBorder = this.compositeBorder || this.nodeBorder;
    this.innerEndBackground = this.nodeBorder;
    this.specialStateColor = this.lineColor;
    this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
    this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
    this.transitionColor = this.transitionColor || this.lineColor;
    this.classText = this.primaryTextColor;
    this.fillType0 = this.primaryColor;
    this.fillType1 = this.secondaryColor;
    this.fillType2 = adjust(this.primaryColor, { h: 64 });
    this.fillType3 = adjust(this.secondaryColor, { h: 64 });
    this.fillType4 = adjust(this.primaryColor, { h: -64 });
    this.fillType5 = adjust(this.secondaryColor, { h: -64 });
    this.fillType6 = adjust(this.primaryColor, { h: 128 });
    this.fillType7 = adjust(this.secondaryColor, { h: 128 });
    this.pie1 = this.pie1 || this.primaryColor;
    this.pie2 = this.pie2 || this.secondaryColor;
    this.pie3 = this.pie3 || adjust(this.tertiaryColor, { l: -40 });
    this.pie4 = this.pie4 || adjust(this.primaryColor, { l: -10 });
    this.pie5 = this.pie5 || adjust(this.secondaryColor, { l: -30 });
    this.pie6 = this.pie6 || adjust(this.tertiaryColor, { l: -20 });
    this.pie7 = this.pie7 || adjust(this.primaryColor, { h: 60, l: -20 });
    this.pie8 = this.pie8 || adjust(this.primaryColor, { h: -60, l: -40 });
    this.pie9 = this.pie9 || adjust(this.primaryColor, { h: 120, l: -40 });
    this.pie10 = this.pie10 || adjust(this.primaryColor, { h: 60, l: -40 });
    this.pie11 = this.pie11 || adjust(this.primaryColor, { h: -90, l: -40 });
    this.pie12 = this.pie12 || adjust(this.primaryColor, { h: 120, l: -30 });
    this.pieTitleTextSize = this.pieTitleTextSize || "25px";
    this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
    this.pieSectionTextSize = this.pieSectionTextSize || "17px";
    this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
    this.pieLegendTextSize = this.pieLegendTextSize || "17px";
    this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
    this.pieStrokeColor = this.pieStrokeColor || "black";
    this.pieStrokeWidth = this.pieStrokeWidth || "2px";
    this.pieOpacity = this.pieOpacity || "0.7";
    this.requirementBackground = this.requirementBackground || this.primaryColor;
    this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
    this.requirementBorderSize = this.requirementBorderSize || this.primaryBorderColor;
    this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
    this.relationColor = this.relationColor || this.lineColor;
    this.relationLabelBackground = this.relationLabelBackground || this.labelBackground;
    this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
    this.git0 = this.git0 || this.primaryColor;
    this.git1 = this.git1 || this.secondaryColor;
    this.git2 = this.git2 || this.tertiaryColor;
    this.git3 = this.git3 || adjust(this.primaryColor, { h: -30 });
    this.git4 = this.git4 || adjust(this.primaryColor, { h: -60 });
    this.git5 = this.git5 || adjust(this.primaryColor, { h: -90 });
    this.git6 = this.git6 || adjust(this.primaryColor, { h: 60 });
    this.git7 = this.git7 || adjust(this.primaryColor, { h: 120 });
    if (this.darkMode) {
      this.git0 = lighten(this.git0, 25);
      this.git1 = lighten(this.git1, 25);
      this.git2 = lighten(this.git2, 25);
      this.git3 = lighten(this.git3, 25);
      this.git4 = lighten(this.git4, 25);
      this.git5 = lighten(this.git5, 25);
      this.git6 = lighten(this.git6, 25);
      this.git7 = lighten(this.git7, 25);
    } else {
      this.git0 = darken(this.git0, 25);
      this.git1 = darken(this.git1, 25);
      this.git2 = darken(this.git2, 25);
      this.git3 = darken(this.git3, 25);
      this.git4 = darken(this.git4, 25);
      this.git5 = darken(this.git5, 25);
      this.git6 = darken(this.git6, 25);
      this.git7 = darken(this.git7, 25);
    }
    this.gitInv0 = this.gitInv0 || darken(invert(this.git0), 25);
    this.gitInv1 = this.gitInv1 || invert(this.git1);
    this.gitInv2 = this.gitInv2 || invert(this.git2);
    this.gitInv3 = this.gitInv3 || invert(this.git3);
    this.gitInv4 = this.gitInv4 || invert(this.git4);
    this.gitInv5 = this.gitInv5 || invert(this.git5);
    this.gitInv6 = this.gitInv6 || invert(this.git6);
    this.gitInv7 = this.gitInv7 || invert(this.git7);
    this.gitBranchLabel0 = this.gitBranchLabel0 || invert(this.labelTextColor);
    this.gitBranchLabel1 = this.gitBranchLabel1 || this.labelTextColor;
    this.gitBranchLabel2 = this.gitBranchLabel2 || this.labelTextColor;
    this.gitBranchLabel3 = this.gitBranchLabel3 || invert(this.labelTextColor);
    this.gitBranchLabel4 = this.gitBranchLabel4 || this.labelTextColor;
    this.gitBranchLabel5 = this.gitBranchLabel5 || this.labelTextColor;
    this.gitBranchLabel6 = this.gitBranchLabel6 || this.labelTextColor;
    this.gitBranchLabel7 = this.gitBranchLabel7 || this.labelTextColor;
    this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
    this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
    this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
    this.tagLabelFontSize = this.tagLabelFontSize || "10px";
    this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
    this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
    this.commitLabelFontSize = this.commitLabelFontSize || "10px";
    this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
    this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
  }
  calculate(overrides) {
    if (typeof overrides !== "object") {
      this.updateColors();
      return;
    }
    const keys2 = Object.keys(overrides);
    keys2.forEach((k) => {
      this[k] = overrides[k];
    });
    this.updateColors();
    keys2.forEach((k) => {
      this[k] = overrides[k];
    });
  }
};
const getThemeVariables$2 = (userOverrides) => {
  const theme2 = new Theme$2();
  theme2.calculate(userOverrides);
  return theme2;
};
let Theme$1 = class Theme4 {
  constructor() {
    this.background = "#f4f4f4";
    this.primaryColor = "#cde498";
    this.secondaryColor = "#cdffb2";
    this.background = "white";
    this.mainBkg = "#cde498";
    this.secondBkg = "#cdffb2";
    this.lineColor = "green";
    this.border1 = "#13540c";
    this.border2 = "#6eaa49";
    this.arrowheadColor = "green";
    this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
    this.fontSize = "16px";
    this.tertiaryColor = lighten("#cde498", 10);
    this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
    this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
    this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
    this.primaryTextColor = invert(this.primaryColor);
    this.secondaryTextColor = invert(this.secondaryColor);
    this.tertiaryTextColor = invert(this.primaryColor);
    this.lineColor = invert(this.background);
    this.textColor = invert(this.background);
    this.THEME_COLOR_LIMIT = 12;
    this.nodeBkg = "calculated";
    this.nodeBorder = "calculated";
    this.clusterBkg = "calculated";
    this.clusterBorder = "calculated";
    this.defaultLinkColor = "calculated";
    this.titleColor = "#333";
    this.edgeLabelBackground = "#e8e8e8";
    this.actorBorder = "calculated";
    this.actorBkg = "calculated";
    this.actorTextColor = "black";
    this.actorLineColor = "grey";
    this.signalColor = "#333";
    this.signalTextColor = "#333";
    this.labelBoxBkgColor = "calculated";
    this.labelBoxBorderColor = "#326932";
    this.labelTextColor = "calculated";
    this.loopTextColor = "calculated";
    this.noteBorderColor = "calculated";
    this.noteBkgColor = "#fff5ad";
    this.noteTextColor = "calculated";
    this.activationBorderColor = "#666";
    this.activationBkgColor = "#f4f4f4";
    this.sequenceNumberColor = "white";
    this.sectionBkgColor = "#6eaa49";
    this.altSectionBkgColor = "white";
    this.sectionBkgColor2 = "#6eaa49";
    this.excludeBkgColor = "#eeeeee";
    this.taskBorderColor = "calculated";
    this.taskBkgColor = "#487e3a";
    this.taskTextLightColor = "white";
    this.taskTextColor = "calculated";
    this.taskTextDarkColor = "black";
    this.taskTextOutsideColor = "calculated";
    this.taskTextClickableColor = "#003163";
    this.activeTaskBorderColor = "calculated";
    this.activeTaskBkgColor = "calculated";
    this.gridColor = "lightgrey";
    this.doneTaskBkgColor = "lightgrey";
    this.doneTaskBorderColor = "grey";
    this.critBorderColor = "#ff8888";
    this.critBkgColor = "red";
    this.todayLineColor = "red";
    this.personBorder = "calculated";
    this.personBkg = "calculated";
    this.labelColor = "black";
    this.errorBkgColor = "#552222";
    this.errorTextColor = "#552222";
  }
  updateColors() {
    this.cScale0 = this.cScale0 || this.primaryColor;
    this.cScale1 = this.cScale1 || this.secondaryColor;
    this.cScale2 = this.cScale2 || this.tertiaryColor;
    this.cScale3 = this.cScale3 || adjust(this.primaryColor, { h: 30 });
    this.cScale4 = this.cScale4 || adjust(this.primaryColor, { h: 60 });
    this.cScale5 = this.cScale5 || adjust(this.primaryColor, { h: 90 });
    this.cScale6 = this.cScale6 || adjust(this.primaryColor, { h: 120 });
    this.cScale7 = this.cScale7 || adjust(this.primaryColor, { h: 150 });
    this.cScale8 = this.cScale8 || adjust(this.primaryColor, { h: 210 });
    this.cScale9 = this.cScale9 || adjust(this.primaryColor, { h: 270 });
    this.cScale10 = this.cScale10 || adjust(this.primaryColor, { h: 300 });
    this.cScale11 = this.cScale11 || adjust(this.primaryColor, { h: 330 });
    this["cScalePeer" + 1] = this["cScalePeer" + 1] || darken(this.secondaryColor, 45);
    this["cScalePeer" + 2] = this["cScalePeer" + 2] || darken(this.tertiaryColor, 40);
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["cScale" + i] = darken(this["cScale" + i], 10);
      this["cScalePeer" + i] = this["cScalePeer" + i] || darken(this["cScale" + i], 25);
    }
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["cScaleInv" + i] = this["cScaleInv" + i] || adjust(this["cScale" + i], { h: 180 });
    }
    this.scaleLabelColor = this.scaleLabelColor !== "calculated" && this.scaleLabelColor ? this.scaleLabelColor : this.labelTextColor;
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["cScaleLabel" + i] = this["cScaleLabel" + i] || this.scaleLabelColor;
    }
    for (let i = 0; i < 5; i++) {
      this["surface" + i] = this["surface" + i] || adjust(this.mainBkg, { h: 30, s: -30, l: -(5 + i * 5) });
      this["surfacePeer" + i] = this["surfacePeer" + i] || adjust(this.mainBkg, { h: 30, s: -30, l: -(8 + i * 5) });
    }
    this.nodeBkg = this.mainBkg;
    this.nodeBorder = this.border1;
    this.clusterBkg = this.secondBkg;
    this.clusterBorder = this.border2;
    this.defaultLinkColor = this.lineColor;
    this.actorBorder = darken(this.mainBkg, 20);
    this.actorBkg = this.mainBkg;
    this.labelBoxBkgColor = this.actorBkg;
    this.labelTextColor = this.actorTextColor;
    this.loopTextColor = this.actorTextColor;
    this.noteBorderColor = this.border2;
    this.noteTextColor = this.actorTextColor;
    this.taskBorderColor = this.border1;
    this.taskTextColor = this.taskTextLightColor;
    this.taskTextOutsideColor = this.taskTextDarkColor;
    this.activeTaskBorderColor = this.taskBorderColor;
    this.activeTaskBkgColor = this.mainBkg;
    this.transitionColor = this.transitionColor || this.lineColor;
    this.transitionLabelColor = this.transitionLabelColor || this.textColor;
    this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
    this.stateBkg = this.stateBkg || this.mainBkg;
    this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
    this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
    this.altBackground = this.altBackground || "#f0f0f0";
    this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
    this.compositeBorder = this.compositeBorder || this.nodeBorder;
    this.innerEndBackground = this.primaryBorderColor;
    this.specialStateColor = this.lineColor;
    this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
    this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
    this.transitionColor = this.transitionColor || this.lineColor;
    this.classText = this.primaryTextColor;
    this.fillType0 = this.primaryColor;
    this.fillType1 = this.secondaryColor;
    this.fillType2 = adjust(this.primaryColor, { h: 64 });
    this.fillType3 = adjust(this.secondaryColor, { h: 64 });
    this.fillType4 = adjust(this.primaryColor, { h: -64 });
    this.fillType5 = adjust(this.secondaryColor, { h: -64 });
    this.fillType6 = adjust(this.primaryColor, { h: 128 });
    this.fillType7 = adjust(this.secondaryColor, { h: 128 });
    this.pie1 = this.pie1 || this.primaryColor;
    this.pie2 = this.pie2 || this.secondaryColor;
    this.pie3 = this.pie3 || this.tertiaryColor;
    this.pie4 = this.pie4 || adjust(this.primaryColor, { l: -30 });
    this.pie5 = this.pie5 || adjust(this.secondaryColor, { l: -30 });
    this.pie6 = this.pie6 || adjust(this.tertiaryColor, { h: 40, l: -40 });
    this.pie7 = this.pie7 || adjust(this.primaryColor, { h: 60, l: -10 });
    this.pie8 = this.pie8 || adjust(this.primaryColor, { h: -60, l: -10 });
    this.pie9 = this.pie9 || adjust(this.primaryColor, { h: 120, l: 0 });
    this.pie10 = this.pie10 || adjust(this.primaryColor, { h: 60, l: -50 });
    this.pie11 = this.pie11 || adjust(this.primaryColor, { h: -60, l: -50 });
    this.pie12 = this.pie12 || adjust(this.primaryColor, { h: 120, l: -50 });
    this.pieTitleTextSize = this.pieTitleTextSize || "25px";
    this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
    this.pieSectionTextSize = this.pieSectionTextSize || "17px";
    this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
    this.pieLegendTextSize = this.pieLegendTextSize || "17px";
    this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
    this.pieStrokeColor = this.pieStrokeColor || "black";
    this.pieStrokeWidth = this.pieStrokeWidth || "2px";
    this.pieOpacity = this.pieOpacity || "0.7";
    this.requirementBackground = this.requirementBackground || this.primaryColor;
    this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
    this.requirementBorderSize = this.requirementBorderSize || this.primaryBorderColor;
    this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
    this.relationColor = this.relationColor || this.lineColor;
    this.relationLabelBackground = this.relationLabelBackground || this.edgeLabelBackground;
    this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
    this.git0 = this.git0 || this.primaryColor;
    this.git1 = this.git1 || this.secondaryColor;
    this.git2 = this.git2 || this.tertiaryColor;
    this.git3 = this.git3 || adjust(this.primaryColor, { h: -30 });
    this.git4 = this.git4 || adjust(this.primaryColor, { h: -60 });
    this.git5 = this.git5 || adjust(this.primaryColor, { h: -90 });
    this.git6 = this.git6 || adjust(this.primaryColor, { h: 60 });
    this.git7 = this.git7 || adjust(this.primaryColor, { h: 120 });
    if (this.darkMode) {
      this.git0 = lighten(this.git0, 25);
      this.git1 = lighten(this.git1, 25);
      this.git2 = lighten(this.git2, 25);
      this.git3 = lighten(this.git3, 25);
      this.git4 = lighten(this.git4, 25);
      this.git5 = lighten(this.git5, 25);
      this.git6 = lighten(this.git6, 25);
      this.git7 = lighten(this.git7, 25);
    } else {
      this.git0 = darken(this.git0, 25);
      this.git1 = darken(this.git1, 25);
      this.git2 = darken(this.git2, 25);
      this.git3 = darken(this.git3, 25);
      this.git4 = darken(this.git4, 25);
      this.git5 = darken(this.git5, 25);
      this.git6 = darken(this.git6, 25);
      this.git7 = darken(this.git7, 25);
    }
    this.gitInv0 = this.gitInv0 || invert(this.git0);
    this.gitInv1 = this.gitInv1 || invert(this.git1);
    this.gitInv2 = this.gitInv2 || invert(this.git2);
    this.gitInv3 = this.gitInv3 || invert(this.git3);
    this.gitInv4 = this.gitInv4 || invert(this.git4);
    this.gitInv5 = this.gitInv5 || invert(this.git5);
    this.gitInv6 = this.gitInv6 || invert(this.git6);
    this.gitInv7 = this.gitInv7 || invert(this.git7);
    this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
    this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
    this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
    this.tagLabelFontSize = this.tagLabelFontSize || "10px";
    this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
    this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
    this.commitLabelFontSize = this.commitLabelFontSize || "10px";
    this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
    this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
  }
  calculate(overrides) {
    if (typeof overrides !== "object") {
      this.updateColors();
      return;
    }
    const keys2 = Object.keys(overrides);
    keys2.forEach((k) => {
      this[k] = overrides[k];
    });
    this.updateColors();
    keys2.forEach((k) => {
      this[k] = overrides[k];
    });
  }
};
const getThemeVariables$1 = (userOverrides) => {
  const theme2 = new Theme$1();
  theme2.calculate(userOverrides);
  return theme2;
};
class Theme5 {
  constructor() {
    this.primaryColor = "#eee";
    this.contrast = "#707070";
    this.secondaryColor = lighten(this.contrast, 55);
    this.background = "#ffffff";
    this.tertiaryColor = adjust(this.primaryColor, { h: -160 });
    this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
    this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
    this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
    this.primaryTextColor = invert(this.primaryColor);
    this.secondaryTextColor = invert(this.secondaryColor);
    this.tertiaryTextColor = invert(this.tertiaryColor);
    this.lineColor = invert(this.background);
    this.textColor = invert(this.background);
    this.mainBkg = "#eee";
    this.secondBkg = "calculated";
    this.lineColor = "#666";
    this.border1 = "#999";
    this.border2 = "calculated";
    this.note = "#ffa";
    this.text = "#333";
    this.critical = "#d42";
    this.done = "#bbb";
    this.arrowheadColor = "#333333";
    this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
    this.fontSize = "16px";
    this.THEME_COLOR_LIMIT = 12;
    this.nodeBkg = "calculated";
    this.nodeBorder = "calculated";
    this.clusterBkg = "calculated";
    this.clusterBorder = "calculated";
    this.defaultLinkColor = "calculated";
    this.titleColor = "calculated";
    this.edgeLabelBackground = "white";
    this.actorBorder = "calculated";
    this.actorBkg = "calculated";
    this.actorTextColor = "calculated";
    this.actorLineColor = "calculated";
    this.signalColor = "calculated";
    this.signalTextColor = "calculated";
    this.labelBoxBkgColor = "calculated";
    this.labelBoxBorderColor = "calculated";
    this.labelTextColor = "calculated";
    this.loopTextColor = "calculated";
    this.noteBorderColor = "calculated";
    this.noteBkgColor = "calculated";
    this.noteTextColor = "calculated";
    this.activationBorderColor = "#666";
    this.activationBkgColor = "#f4f4f4";
    this.sequenceNumberColor = "white";
    this.sectionBkgColor = "calculated";
    this.altSectionBkgColor = "white";
    this.sectionBkgColor2 = "calculated";
    this.excludeBkgColor = "#eeeeee";
    this.taskBorderColor = "calculated";
    this.taskBkgColor = "calculated";
    this.taskTextLightColor = "white";
    this.taskTextColor = "calculated";
    this.taskTextDarkColor = "calculated";
    this.taskTextOutsideColor = "calculated";
    this.taskTextClickableColor = "#003163";
    this.activeTaskBorderColor = "calculated";
    this.activeTaskBkgColor = "calculated";
    this.gridColor = "calculated";
    this.doneTaskBkgColor = "calculated";
    this.doneTaskBorderColor = "calculated";
    this.critBkgColor = "calculated";
    this.critBorderColor = "calculated";
    this.todayLineColor = "calculated";
    this.personBorder = "calculated";
    this.personBkg = "calculated";
    this.labelColor = "black";
    this.errorBkgColor = "#552222";
    this.errorTextColor = "#552222";
  }
  updateColors() {
    this.secondBkg = lighten(this.contrast, 55);
    this.border2 = this.contrast;
    this.cScale0 = this.cScale0 || "#555";
    this.cScale1 = this.cScale1 || "#F4F4F4";
    this.cScale2 = this.cScale2 || "#555";
    this.cScale3 = this.cScale3 || "#BBB";
    this.cScale4 = this.cScale4 || "#777";
    this.cScale5 = this.cScale5 || "#999";
    this.cScale6 = this.cScale6 || "#DDD";
    this.cScale7 = this.cScale7 || "#FFF";
    this.cScale8 = this.cScale8 || "#DDD";
    this.cScale9 = this.cScale9 || "#BBB";
    this.cScale10 = this.cScale10 || "#999";
    this.cScale11 = this.cScale11 || "#777";
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["cScaleInv" + i] = this["cScaleInv" + i] || invert(this["cScale" + i]);
    }
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      if (this.darkMode) {
        this["cScalePeer" + i] = this["cScalePeer" + i] || lighten(this["cScale" + i], 10);
      } else {
        this["cScalePeer" + i] = this["cScalePeer" + i] || darken(this["cScale" + i], 10);
      }
    }
    this.scaleLabelColor = this.scaleLabelColor || (this.darkMode ? "black" : this.labelTextColor);
    this["cScaleLabel0"] = this["cScaleLabel0"] || this.cScale1;
    this["cScaleLabel2"] = this["cScaleLabel2"] || this.cScale1;
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["cScaleLabel" + i] = this["cScaleLabel" + i] || this.scaleLabelColor;
    }
    for (let i = 0; i < 5; i++) {
      this["surface" + i] = this["surface" + i] || adjust(this.mainBkg, { l: -(5 + i * 5) });
      this["surfacePeer" + i] = this["surfacePeer" + i] || adjust(this.mainBkg, { l: -(8 + i * 5) });
    }
    this.nodeBkg = this.mainBkg;
    this.nodeBorder = this.border1;
    this.clusterBkg = this.secondBkg;
    this.clusterBorder = this.border2;
    this.defaultLinkColor = this.lineColor;
    this.titleColor = this.text;
    this.actorBorder = lighten(this.border1, 23);
    this.actorBkg = this.mainBkg;
    this.actorTextColor = this.text;
    this.actorLineColor = this.lineColor;
    this.signalColor = this.text;
    this.signalTextColor = this.text;
    this.labelBoxBkgColor = this.actorBkg;
    this.labelBoxBorderColor = this.actorBorder;
    this.labelTextColor = this.text;
    this.loopTextColor = this.text;
    this.noteBorderColor = "#999";
    this.noteBkgColor = "#666";
    this.noteTextColor = "#fff";
    this.sectionBkgColor = lighten(this.contrast, 30);
    this.sectionBkgColor2 = lighten(this.contrast, 30);
    this.taskBorderColor = darken(this.contrast, 10);
    this.taskBkgColor = this.contrast;
    this.taskTextColor = this.taskTextLightColor;
    this.taskTextDarkColor = this.text;
    this.taskTextOutsideColor = this.taskTextDarkColor;
    this.activeTaskBorderColor = this.taskBorderColor;
    this.activeTaskBkgColor = this.mainBkg;
    this.gridColor = lighten(this.border1, 30);
    this.doneTaskBkgColor = this.done;
    this.doneTaskBorderColor = this.lineColor;
    this.critBkgColor = this.critical;
    this.critBorderColor = darken(this.critBkgColor, 10);
    this.todayLineColor = this.critBkgColor;
    this.transitionColor = this.transitionColor || "#000";
    this.transitionLabelColor = this.transitionLabelColor || this.textColor;
    this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
    this.stateBkg = this.stateBkg || this.mainBkg;
    this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
    this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
    this.altBackground = this.altBackground || "#f4f4f4";
    this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
    this.stateBorder = this.stateBorder || "#000";
    this.innerEndBackground = this.primaryBorderColor;
    this.specialStateColor = "#222";
    this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
    this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
    this.classText = this.primaryTextColor;
    this.fillType0 = this.primaryColor;
    this.fillType1 = this.secondaryColor;
    this.fillType2 = adjust(this.primaryColor, { h: 64 });
    this.fillType3 = adjust(this.secondaryColor, { h: 64 });
    this.fillType4 = adjust(this.primaryColor, { h: -64 });
    this.fillType5 = adjust(this.secondaryColor, { h: -64 });
    this.fillType6 = adjust(this.primaryColor, { h: 128 });
    this.fillType7 = adjust(this.secondaryColor, { h: 128 });
    for (let i = 0; i < this.THEME_COLOR_LIMIT; i++) {
      this["pie" + i] = this["cScale" + i];
    }
    this.pie12 = this.pie0;
    this.pieTitleTextSize = this.pieTitleTextSize || "25px";
    this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
    this.pieSectionTextSize = this.pieSectionTextSize || "17px";
    this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
    this.pieLegendTextSize = this.pieLegendTextSize || "17px";
    this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
    this.pieStrokeColor = this.pieStrokeColor || "black";
    this.pieStrokeWidth = this.pieStrokeWidth || "2px";
    this.pieOpacity = this.pieOpacity || "0.7";
    this.requirementBackground = this.requirementBackground || this.primaryColor;
    this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
    this.requirementBorderSize = this.requirementBorderSize || this.primaryBorderColor;
    this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
    this.relationColor = this.relationColor || this.lineColor;
    this.relationLabelBackground = this.relationLabelBackground || this.edgeLabelBackground;
    this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
    this.git0 = darken(this.pie1, 25) || this.primaryColor;
    this.git1 = this.pie2 || this.secondaryColor;
    this.git2 = this.pie3 || this.tertiaryColor;
    this.git3 = this.pie4 || adjust(this.primaryColor, { h: -30 });
    this.git4 = this.pie5 || adjust(this.primaryColor, { h: -60 });
    this.git5 = this.pie6 || adjust(this.primaryColor, { h: -90 });
    this.git6 = this.pie7 || adjust(this.primaryColor, { h: 60 });
    this.git7 = this.pie8 || adjust(this.primaryColor, { h: 120 });
    this.gitInv0 = this.gitInv0 || invert(this.git0);
    this.gitInv1 = this.gitInv1 || invert(this.git1);
    this.gitInv2 = this.gitInv2 || invert(this.git2);
    this.gitInv3 = this.gitInv3 || invert(this.git3);
    this.gitInv4 = this.gitInv4 || invert(this.git4);
    this.gitInv5 = this.gitInv5 || invert(this.git5);
    this.gitInv6 = this.gitInv6 || invert(this.git6);
    this.gitInv7 = this.gitInv7 || invert(this.git7);
    this.branchLabelColor = this.branchLabelColor || this.labelTextColor;
    this.gitBranchLabel0 = this.branchLabelColor;
    this.gitBranchLabel1 = "white";
    this.gitBranchLabel2 = this.branchLabelColor;
    this.gitBranchLabel3 = "white";
    this.gitBranchLabel4 = this.branchLabelColor;
    this.gitBranchLabel5 = this.branchLabelColor;
    this.gitBranchLabel6 = this.branchLabelColor;
    this.gitBranchLabel7 = this.branchLabelColor;
    this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
    this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
    this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
    this.tagLabelFontSize = this.tagLabelFontSize || "10px";
    this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
    this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
    this.commitLabelFontSize = this.commitLabelFontSize || "10px";
    this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
    this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
  }
  calculate(overrides) {
    if (typeof overrides !== "object") {
      this.updateColors();
      return;
    }
    const keys2 = Object.keys(overrides);
    keys2.forEach((k) => {
      this[k] = overrides[k];
    });
    this.updateColors();
    keys2.forEach((k) => {
      this[k] = overrides[k];
    });
  }
}
const getThemeVariables = (userOverrides) => {
  const theme2 = new Theme5();
  theme2.calculate(userOverrides);
  return theme2;
};
const theme = {
  base: {
    getThemeVariables: getThemeVariables$4
  },
  dark: {
    getThemeVariables: getThemeVariables$3
  },
  default: {
    getThemeVariables: getThemeVariables$2
  },
  forest: {
    getThemeVariables: getThemeVariables$1
  },
  neutral: {
    getThemeVariables
  }
};
const config$1 = {
  /**
   * Theme , the CSS style sheet
   *
   * | Parameter | Description     | Type   | Required | Values                                         |
   * | --------- | --------------- | ------ | -------- | ---------------------------------------------- |
   * | theme     | Built in Themes | string | Optional | 'default', 'forest', 'dark', 'neutral', 'null' |
   *
   * **Notes:** To disable any pre-defined mermaid theme, use "null".
   *
   * @example
   *
   * ```js
   * {
   *   "theme": "forest",
   *   "themeCSS": ".node rect { fill: red; }"
   * }
   * ```
   */
  theme: "default",
  themeVariables: theme["default"].getThemeVariables(),
  themeCSS: void 0,
  /* **maxTextSize** - The maximum allowed size of the users text diagram */
  maxTextSize: 5e4,
  darkMode: false,
  /**
   * | Parameter  | Description                                            | Type   | Required | Values                      |
   * | ---------- | ------------------------------------------------------ | ------ | -------- | --------------------------- |
   * | fontFamily | specifies the font to be used in the rendered diagrams | string | Required | Any Possible CSS FontFamily |
   *
   * **Notes:** Default value: '"trebuchet ms", verdana, arial, sans-serif;'.
   */
  fontFamily: '"trebuchet ms", verdana, arial, sans-serif;',
  /**
   * | Parameter | Description                                           | Type             | Required | Values                                        |
   * | --------- | ----------------------------------------------------- | ---------------- | -------- | --------------------------------------------- |
   * | logLevel  | This option decides the amount of logging to be used. | string \| number | Required | 'trace','debug','info','warn','error','fatal' |
   *
   * **Notes:**
   *
   * - Trace: 0
   * - Debug: 1
   * - Info: 2
   * - Warn: 3
   * - Error: 4
   * - Fatal: 5 (default)
   */
  logLevel: 5,
  /**
   * | Parameter     | Description                       | Type   | Required | Values                                     |
   * | ------------- | --------------------------------- | ------ | -------- | ------------------------------------------ |
   * | securityLevel | Level of trust for parsed diagram | string | Required | 'sandbox', 'strict', 'loose', 'antiscript' |
   *
   * **Notes**:
   *
   * - **strict**: (**default**) tags in text are encoded, click functionality is disabled
   * - **loose**: tags in text are allowed, click functionality is enabled
   * - **antiscript**: html tags in text are allowed, (only script element is removed), click
   *   functionality is enabled
   * - **sandbox**: With this security level all rendering takes place in a sandboxed iframe. This
   *   prevent any JavaScript from running in the context. This may hinder interactive functionality
   *   of the diagram like scripts, popups in sequence diagram or links to other tabs/targets etc.
   */
  securityLevel: "strict",
  /**
   * | Parameter   | Description                                  | Type    | Required | Values      |
   * | ----------- | -------------------------------------------- | ------- | -------- | ----------- |
   * | startOnLoad | Dictates whether mermaid starts on Page load | boolean | Required | true, false |
   *
   * **Notes:** Default value: true
   */
  startOnLoad: true,
  /**
   * | Parameter           | Description                                                                  | Type    | Required | Values      |
   * | ------------------- | ---------------------------------------------------------------------------- | ------- | -------- | ----------- |
   * | arrowMarkerAbsolute | Controls whether or arrow markers in html code are absolute paths or anchors | boolean | Required | true, false |
   *
   * **Notes**:
   *
   * This matters if you are using base tag settings.
   *
   * Default value: false
   */
  arrowMarkerAbsolute: false,
  /**
   * This option controls which currentConfig keys are considered _secure_ and can only be changed
   * via call to mermaidAPI.initialize. Calls to mermaidAPI.reinitialize cannot make changes to the
   * `secure` keys in the current currentConfig. This prevents malicious graph directives from
   * overriding a site's default security.
   *
   * **Notes**:
   *
   * Default value: ['secure', 'securityLevel', 'startOnLoad', 'maxTextSize']
   */
  secure: ["secure", "securityLevel", "startOnLoad", "maxTextSize"],
  /**
   * This option controls if the generated ids of nodes in the SVG are generated randomly or based
   * on a seed. If set to false, the IDs are generated based on the current date and thus are not
   * deterministic. This is the default behavior.
   *
   * **Notes**:
   *
   * This matters if your files are checked into source control e.g. git and should not change unless
   * content is changed.
   *
   * Default value: false
   */
  deterministicIds: false,
  /**
   * This option is the optional seed for deterministic ids. if set to undefined but
   * deterministicIds is true, a simple number iterator is used. You can set this attribute to base
   * the seed on a static string.
   */
  deterministicIDSeed: void 0,
  /** The object containing configurations specific for flowcharts */
  flowchart: {
    /**
     * ### titleTopMargin
     *
     * | Parameter      | Description                                    | Type    | Required | Values             |
     * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
     * | titleTopMargin | Margin top for the text over the flowchart     | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 25
     */
    titleTopMargin: 25,
    /**
     * | Parameter      | Description                                     | Type    | Required | Values             |
     * | -------------- | ----------------------------------------------- | ------- | -------- | ------------------ |
     * | diagramPadding | Amount of padding around the diagram as a whole | Integer | Required | Any Positive Value |
     *
     * **Notes:**
     *
     * The amount of padding around the diagram as a whole so that embedded diagrams have margins,
     * expressed in pixels
     *
     * Default value: 8
     */
    diagramPadding: 8,
    /**
     * | Parameter  | Description                                                                                  | Type    | Required | Values      |
     * | ---------- | -------------------------------------------------------------------------------------------- | ------- | -------- | ----------- |
     * | htmlLabels | Flag for setting whether or not a html tag should be used for rendering labels on the edges. | boolean | Required | true, false |
     *
     * **Notes:** Default value: true.
     */
    htmlLabels: true,
    /**
     * | Parameter   | Description                                         | Type    | Required | Values              |
     * | ----------- | --------------------------------------------------- | ------- | -------- | ------------------- |
     * | nodeSpacing | Defines the spacing between nodes on the same level | Integer | Required | Any positive Number |
     *
     * **Notes:**
     *
     * Pertains to horizontal spacing for TB (top to bottom) or BT (bottom to top) graphs, and the
     * vertical spacing for LR as well as RL graphs.**
     *
     * Default value: 50
     */
    nodeSpacing: 50,
    /**
     * | Parameter   | Description                                           | Type    | Required | Values              |
     * | ----------- | ----------------------------------------------------- | ------- | -------- | ------------------- |
     * | rankSpacing | Defines the spacing between nodes on different levels | Integer | Required | Any Positive Number |
     *
     * **Notes**:
     *
     * Pertains to vertical spacing for TB (top to bottom) or BT (bottom to top), and the horizontal
     * spacing for LR as well as RL graphs.
     *
     * Default value 50
     */
    rankSpacing: 50,
    /**
     * | Parameter | Description                                        | Type   | Required | Values                        |
     * | --------- | -------------------------------------------------- | ------ | -------- | ----------------------------- |
     * | curve     | Defines how mermaid renders curves for flowcharts. | string | Required | 'basis', 'linear', 'cardinal' |
     *
     * **Notes:**
     *
     * Default Value: 'basis'
     */
    curve: "basis",
    // Only used in new experimental rendering
    // represents the padding between the labels and the shape
    padding: 15,
    /**
     * | Parameter   | Description | Type    | Required | Values      |
     * | ----------- | ----------- | ------- | -------- | ----------- |
     * | useMaxWidth | See notes   | boolean | 4        | true, false |
     *
     * **Notes:**
     *
     * When this flag is set the height and width is set to 100% and is then scaling with the
     * available space if not the absolute space required is used.
     *
     * Default value: true
     */
    useMaxWidth: true,
    /**
     * | Parameter       | Description | Type    | Required | Values                  |
     * | --------------- | ----------- | ------- | -------- | ----------------------- |
     * | defaultRenderer | See notes   | boolean | 4        | dagre-d3, dagre-wrapper, elk |
     *
     * **Notes:**
     *
     * Decides which rendering engine that is to be used for the rendering. Legal values are:
     * dagre-d3 dagre-wrapper - wrapper for dagre implemented in mermaid, elk for layout using
     * elkjs
     *
     * Default value: 'dagre-wrapper'
     */
    defaultRenderer: "dagre-wrapper"
  },
  /** The object containing configurations specific for sequence diagrams */
  sequence: {
    hideUnusedParticipants: false,
    /**
     * | Parameter       | Description                  | Type    | Required | Values             |
     * | --------------- | ---------------------------- | ------- | -------- | ------------------ |
     * | activationWidth | Width of the activation rect | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value :10
     */
    activationWidth: 10,
    /**
     * | Parameter      | Description                                          | Type    | Required | Values             |
     * | -------------- | ---------------------------------------------------- | ------- | -------- | ------------------ |
     * | diagramMarginX | Margin to the right and left of the sequence diagram | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 50
     */
    diagramMarginX: 50,
    /**
     * | Parameter      | Description                                       | Type    | Required | Values             |
     * | -------------- | ------------------------------------------------- | ------- | -------- | ------------------ |
     * | diagramMarginY | Margin to the over and under the sequence diagram | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 10
     */
    diagramMarginY: 10,
    /**
     * | Parameter   | Description           | Type    | Required | Values             |
     * | ----------- | --------------------- | ------- | -------- | ------------------ |
     * | actorMargin | Margin between actors | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 50
     */
    actorMargin: 50,
    /**
     * | Parameter | Description          | Type    | Required | Values             |
     * | --------- | -------------------- | ------- | -------- | ------------------ |
     * | width     | Width of actor boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 150
     */
    width: 150,
    /**
     * | Parameter | Description           | Type    | Required | Values             |
     * | --------- | --------------------- | ------- | -------- | ------------------ |
     * | height    | Height of actor boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 65
     */
    height: 65,
    /**
     * | Parameter | Description              | Type    | Required | Values             |
     * | --------- | ------------------------ | ------- | -------- | ------------------ |
     * | boxMargin | Margin around loop boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 10
     */
    boxMargin: 10,
    /**
     * | Parameter     | Description                                  | Type    | Required | Values             |
     * | ------------- | -------------------------------------------- | ------- | -------- | ------------------ |
     * | boxTextMargin | Margin around the text in loop/alt/opt boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 5
     */
    boxTextMargin: 5,
    /**
     * | Parameter  | Description         | Type    | Required | Values             |
     * | ---------- | ------------------- | ------- | -------- | ------------------ |
     * | noteMargin | margin around notes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 10
     */
    noteMargin: 10,
    /**
     * | Parameter     | Description            | Type    | Required | Values             |
     * | ------------- | ---------------------- | ------- | -------- | ------------------ |
     * | messageMargin | Space between messages | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 35
     */
    messageMargin: 35,
    /**
     * | Parameter    | Description                 | Type   | Required | Values                    |
     * | ------------ | --------------------------- | ------ | -------- | ------------------------- |
     * | messageAlign | Multiline message alignment | string | Required | 'left', 'center', 'right' |
     *
     * **Notes:** Default value: 'center'
     */
    messageAlign: "center",
    /**
     * | Parameter    | Description                 | Type    | Required | Values      |
     * | ------------ | --------------------------- | ------- | -------- | ----------- |
     * | mirrorActors | Mirror actors under diagram | boolean | Required | true, false |
     *
     * **Notes:** Default value: true
     */
    mirrorActors: true,
    /**
     * | Parameter  | Description                                                             | Type    | Required | Values      |
     * | ---------- | ----------------------------------------------------------------------- | ------- | -------- | ----------- |
     * | forceMenus | forces actor popup menus to always be visible (to support E2E testing). | Boolean | Required | True, False |
     *
     * **Notes:**
     *
     * Default value: false.
     */
    forceMenus: false,
    /**
     * | Parameter       | Description                                | Type    | Required | Values             |
     * | --------------- | ------------------------------------------ | ------- | -------- | ------------------ |
     * | bottomMarginAdj | Prolongs the edge of the diagram downwards | Integer | Required | Any Positive Value |
     *
     * **Notes:**
     *
     * Depending on css styling this might need adjustment.
     *
     * Default value: 1
     */
    bottomMarginAdj: 1,
    /**
     * | Parameter   | Description | Type    | Required | Values      |
     * | ----------- | ----------- | ------- | -------- | ----------- |
     * | useMaxWidth | See Notes   | boolean | Required | true, false |
     *
     * **Notes:** When this flag is set to true, the height and width is set to 100% and is then
     * scaling with the available space. If set to false, the absolute space required is used.
     *
     * Default value: true
     */
    useMaxWidth: true,
    /**
     * | Parameter   | Description                          | Type    | Required | Values      |
     * | ----------- | ------------------------------------ | ------- | -------- | ----------- |
     * | rightAngles | display curve arrows as right angles | boolean | Required | true, false |
     *
     * **Notes:**
     *
     * This will display arrows that start and begin at the same node as right angles, rather than a
     * curve
     *
     * Default value: false
     */
    rightAngles: false,
    /**
     * | Parameter           | Description                     | Type    | Required | Values      |
     * | ------------------- | ------------------------------- | ------- | -------- | ----------- |
     * | showSequenceNumbers | This will show the node numbers | boolean | Required | true, false |
     *
     * **Notes:** Default value: false
     */
    showSequenceNumbers: false,
    /**
     * | Parameter     | Description                                        | Type    | Required | Values             |
     * | ------------- | -------------------------------------------------- | ------- | -------- | ------------------ |
     * | actorFontSize | This sets the font size of the actor's description | Integer | Require  | Any Positive Value |
     *
     * **Notes:** **Default value 14**..
     */
    actorFontSize: 14,
    /**
     * | Parameter       | Description                                          | Type   | Required | Values                      |
     * | --------------- | ---------------------------------------------------- | ------ | -------- | --------------------------- |
     * | actorFontFamily | This sets the font family of the actor's description | string | Required | Any Possible CSS FontFamily |
     *
     * **Notes:** Default value: "'Open Sans", sans-serif'
     */
    actorFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of the actor's description
     *
     * **Notes:** Default value: 400.
     */
    actorFontWeight: 400,
    /**
     * | Parameter    | Description                                     | Type    | Required | Values             |
     * | ------------ | ----------------------------------------------- | ------- | -------- | ------------------ |
     * | noteFontSize | This sets the font size of actor-attached notes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 14
     */
    noteFontSize: 14,
    /**
     * | Parameter      | Description                                        | Type   | Required | Values                      |
     * | -------------- | -------------------------------------------------- | ------ | -------- | --------------------------- |
     * | noteFontFamily | This sets the font family of actor-attached notes. | string | Required | Any Possible CSS FontFamily |
     *
     * **Notes:** Default value: ''"trebuchet ms", verdana, arial, sans-serif'
     */
    noteFontFamily: '"trebuchet ms", verdana, arial, sans-serif',
    /**
     * This sets the font weight of the note's description
     *
     * **Notes:** Default value: 400
     */
    noteFontWeight: 400,
    /**
     * | Parameter | Description                                          | Type   | Required | Values                    |
     * | --------- | ---------------------------------------------------- | ------ | -------- | ------------------------- |
     * | noteAlign | This sets the text alignment of actor-attached notes | string | required | 'left', 'center', 'right' |
     *
     * **Notes:** Default value: 'center'
     */
    noteAlign: "center",
    /**
     * | Parameter       | Description                               | Type    | Required | Values              |
     * | --------------- | ----------------------------------------- | ------- | -------- | ------------------- |
     * | messageFontSize | This sets the font size of actor messages | Integer | Required | Any Positive Number |
     *
     * **Notes:** Default value: 16
     */
    messageFontSize: 16,
    /**
     * | Parameter         | Description                                 | Type   | Required | Values                      |
     * | ----------------- | ------------------------------------------- | ------ | -------- | --------------------------- |
     * | messageFontFamily | This sets the font family of actor messages | string | Required | Any Possible CSS FontFamily |
     *
     * **Notes:** Default value: '"trebuchet ms", verdana, arial, sans-serif'
     */
    messageFontFamily: '"trebuchet ms", verdana, arial, sans-serif',
    /**
     * This sets the font weight of the message's description
     *
     * **Notes:** Default value: 400.
     */
    messageFontWeight: 400,
    /**
     * This sets the auto-wrap state for the diagram
     *
     * **Notes:** Default value: false.
     */
    wrap: false,
    /**
     * This sets the auto-wrap padding for the diagram (sides only)
     *
     * **Notes:** Default value: 0.
     */
    wrapPadding: 10,
    /**
     * This sets the width of the loop-box (loop, alt, opt, par)
     *
     * **Notes:** Default value: 50.
     */
    labelBoxWidth: 50,
    /**
     * This sets the height of the loop-box (loop, alt, opt, par)
     *
     * **Notes:** Default value: 20.
     */
    labelBoxHeight: 20,
    messageFont: function() {
      return {
        fontFamily: this.messageFontFamily,
        fontSize: this.messageFontSize,
        fontWeight: this.messageFontWeight
      };
    },
    noteFont: function() {
      return {
        fontFamily: this.noteFontFamily,
        fontSize: this.noteFontSize,
        fontWeight: this.noteFontWeight
      };
    },
    actorFont: function() {
      return {
        fontFamily: this.actorFontFamily,
        fontSize: this.actorFontSize,
        fontWeight: this.actorFontWeight
      };
    }
  },
  /** The object containing configurations specific for gantt diagrams */
  gantt: {
    /**
     * ### titleTopMargin
     *
     * | Parameter      | Description                                    | Type    | Required | Values             |
     * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
     * | titleTopMargin | Margin top for the text over the gantt diagram | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 25
     */
    titleTopMargin: 25,
    /**
     * | Parameter | Description                         | Type    | Required | Values             |
     * | --------- | ----------------------------------- | ------- | -------- | ------------------ |
     * | barHeight | The height of the bars in the graph | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 20
     */
    barHeight: 20,
    /**
     * | Parameter | Description                                                      | Type    | Required | Values             |
     * | --------- | ---------------------------------------------------------------- | ------- | -------- | ------------------ |
     * | barGap    | The margin between the different activities in the gantt diagram | Integer | Optional | Any Positive Value |
     *
     * **Notes:** Default value: 4
     */
    barGap: 4,
    /**
     * | Parameter  | Description                                                                | Type    | Required | Values             |
     * | ---------- | -------------------------------------------------------------------------- | ------- | -------- | ------------------ |
     * | topPadding | Margin between title and gantt diagram and between axis and gantt diagram. | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 50
     */
    topPadding: 50,
    /**
     * | Parameter    | Description                                                             | Type    | Required | Values             |
     * | ------------ | ----------------------------------------------------------------------- | ------- | -------- | ------------------ |
     * | rightPadding | The space allocated for the section name to the right of the activities | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 75
     */
    rightPadding: 75,
    /**
     * | Parameter   | Description                                                            | Type    | Required | Values             |
     * | ----------- | ---------------------------------------------------------------------- | ------- | -------- | ------------------ |
     * | leftPadding | The space allocated for the section name to the left of the activities | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 75
     */
    leftPadding: 75,
    /**
     * | Parameter            | Description                                  | Type    | Required | Values             |
     * | -------------------- | -------------------------------------------- | ------- | -------- | ------------------ |
     * | gridLineStartPadding | Vertical starting position of the grid lines | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 35
     */
    gridLineStartPadding: 35,
    /**
     * | Parameter | Description | Type    | Required | Values             |
     * | --------- | ----------- | ------- | -------- | ------------------ |
     * | fontSize  | Font size   | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 11
     */
    fontSize: 11,
    /**
     * | Parameter       | Description            | Type    | Required | Values             |
     * | --------------- | ---------------------- | ------- | -------- | ------------------ |
     * | sectionFontSize | Font size for sections | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 11
     */
    sectionFontSize: 11,
    /**
     * | Parameter           | Description                              | Type    | Required | Values             |
     * | ------------------- | ---------------------------------------- | ------- | -------- | ------------------ |
     * | numberSectionStyles | The number of alternating section styles | Integer | 4        | Any Positive Value |
     *
     * **Notes:** Default value: 4
     */
    numberSectionStyles: 4,
    /**
     * | Parameter  | Description                  | Type | Required | Values           |
     * | ---------- | ---------------------------- | ---- | -------- | ---------------- |
     * | axisFormat | Date/time format of the axis | 3    | Required | Date in yy-mm-dd |
     *
     * **Notes:**
     *
     * This might need adjustment to match your locale and preferences
     *
     * Default value: '%Y-%m-%d'.
     */
    axisFormat: "%Y-%m-%d",
    /**
     * | Parameter    | Description | Type   | Required | Values  |
     * | ------------ | ------------| ------ | -------- | ------- |
     * | tickInterval | axis ticks  | string | Optional | string  |
     *
     * **Notes:**
     *
     * Pattern is /^([1-9][0-9]*)(minute|hour|day|week|month)$/
     *
     * Default value: undefined
     */
    tickInterval: void 0,
    /**
     * | Parameter   | Description | Type    | Required | Values      |
     * | ----------- | ----------- | ------- | -------- | ----------- |
     * | useMaxWidth | See notes   | boolean | 4        | true, false |
     *
     * **Notes:**
     *
     * When this flag is set the height and width is set to 100% and is then scaling with the
     * available space if not the absolute space required is used.
     *
     * Default value: true
     */
    useMaxWidth: true,
    /**
     * | Parameter | Description | Type    | Required | Values      |
     * | --------- | ----------- | ------- | -------- | ----------- |
     * | topAxis   | See notes   | Boolean | 4        | True, False |
     *
     * **Notes:** when this flag is set date labels will be added to the top of the chart
     *
     * **Default value false**.
     */
    topAxis: false,
    useWidth: void 0
  },
  /** The object containing configurations specific for journey diagrams */
  journey: {
    /**
     * | Parameter      | Description                                          | Type    | Required | Values             |
     * | -------------- | ---------------------------------------------------- | ------- | -------- | ------------------ |
     * | diagramMarginX | Margin to the right and left of the sequence diagram | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 50
     */
    diagramMarginX: 50,
    /**
     * | Parameter      | Description                                        | Type    | Required | Values             |
     * | -------------- | -------------------------------------------------- | ------- | -------- | ------------------ |
     * | diagramMarginY | Margin to the over and under the sequence diagram. | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 10
     */
    diagramMarginY: 10,
    /**
     * | Parameter   | Description           | Type    | Required | Values             |
     * | ----------- | --------------------- | ------- | -------- | ------------------ |
     * | actorMargin | Margin between actors | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 50
     */
    leftMargin: 150,
    /**
     * | Parameter | Description          | Type    | Required | Values             |
     * | --------- | -------------------- | ------- | -------- | ------------------ |
     * | width     | Width of actor boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 150
     */
    width: 150,
    /**
     * | Parameter | Description           | Type    | Required | Values             |
     * | --------- | --------------------- | ------- | -------- | ------------------ |
     * | height    | Height of actor boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 65
     */
    height: 50,
    /**
     * | Parameter | Description              | Type    | Required | Values             |
     * | --------- | ------------------------ | ------- | -------- | ------------------ |
     * | boxMargin | Margin around loop boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 10
     */
    boxMargin: 10,
    /**
     * | Parameter     | Description                                  | Type    | Required | Values             |
     * | ------------- | -------------------------------------------- | ------- | -------- | ------------------ |
     * | boxTextMargin | Margin around the text in loop/alt/opt boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 5
     */
    boxTextMargin: 5,
    /**
     * | Parameter  | Description         | Type    | Required | Values             |
     * | ---------- | ------------------- | ------- | -------- | ------------------ |
     * | noteMargin | Margin around notes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 10
     */
    noteMargin: 10,
    /**
     * | Parameter     | Description             | Type    | Required | Values             |
     * | ------------- | ----------------------- | ------- | -------- | ------------------ |
     * | messageMargin | Space between messages. | Integer | Required | Any Positive Value |
     *
     * **Notes:**
     *
     * Space between messages.
     *
     * Default value: 35
     */
    messageMargin: 35,
    /**
     * | Parameter    | Description                 | Type | Required | Values                    |
     * | ------------ | --------------------------- | ---- | -------- | ------------------------- |
     * | messageAlign | Multiline message alignment | 3    | 4        | 'left', 'center', 'right' |
     *
     * **Notes:** Default value: 'center'
     */
    messageAlign: "center",
    /**
     * | Parameter       | Description                                | Type    | Required | Values             |
     * | --------------- | ------------------------------------------ | ------- | -------- | ------------------ |
     * | bottomMarginAdj | Prolongs the edge of the diagram downwards | Integer | 4        | Any Positive Value |
     *
     * **Notes:**
     *
     * Depending on css styling this might need adjustment.
     *
     * Default value: 1
     */
    bottomMarginAdj: 1,
    /**
     * | Parameter   | Description | Type    | Required | Values      |
     * | ----------- | ----------- | ------- | -------- | ----------- |
     * | useMaxWidth | See notes   | boolean | 4        | true, false |
     *
     * **Notes:**
     *
     * When this flag is set the height and width is set to 100% and is then scaling with the
     * available space if not the absolute space required is used.
     *
     * Default value: true
     */
    useMaxWidth: true,
    /**
     * | Parameter   | Description                       | Type | Required | Values      |
     * | ----------- | --------------------------------- | ---- | -------- | ----------- |
     * | rightAngles | Curved Arrows become Right Angles | 3    | 4        | true, false |
     *
     * **Notes:**
     *
     * This will display arrows that start and begin at the same node as right angles, rather than a
     * curves
     *
     * Default value: false
     */
    rightAngles: false,
    taskFontSize: 14,
    taskFontFamily: '"Open Sans", sans-serif',
    taskMargin: 50,
    // width of activation box
    activationWidth: 10,
    // text placement as: tspan | fo | old only text as before
    textPlacement: "fo",
    actorColours: ["#8FBC8F", "#7CFC00", "#00FFFF", "#20B2AA", "#B0E0E6", "#FFFFE0"],
    sectionFills: ["#191970", "#8B008B", "#4B0082", "#2F4F4F", "#800000", "#8B4513", "#00008B"],
    sectionColours: ["#fff"]
  },
  /** The object containing configurations specific for timeline diagrams */
  timeline: {
    /**
     * | Parameter      | Description                                          | Type    | Required | Values             |
     * | -------------- | ---------------------------------------------------- | ------- | -------- | ------------------ |
     * | diagramMarginX | Margin to the right and left of the sequence diagram | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 50
     */
    diagramMarginX: 50,
    /**
     * | Parameter      | Description                                        | Type    | Required | Values             |
     * | -------------- | -------------------------------------------------- | ------- | -------- | ------------------ |
     * | diagramMarginY | Margin to the over and under the sequence diagram. | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 10
     */
    diagramMarginY: 10,
    /**
     * | Parameter   | Description           | Type    | Required | Values             |
     * | ----------- | --------------------- | ------- | -------- | ------------------ |
     * | actorMargin | Margin between actors | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 50
     */
    leftMargin: 150,
    /**
     * | Parameter | Description          | Type    | Required | Values             |
     * | --------- | -------------------- | ------- | -------- | ------------------ |
     * | width     | Width of actor boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 150
     */
    width: 150,
    /**
     * | Parameter | Description           | Type    | Required | Values             |
     * | --------- | --------------------- | ------- | -------- | ------------------ |
     * | height    | Height of actor boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 65
     */
    height: 50,
    /**
     * | Parameter | Description              | Type    | Required | Values             |
     * | --------- | ------------------------ | ------- | -------- | ------------------ |
     * | boxMargin | Margin around loop boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 10
     */
    boxMargin: 10,
    /**
     * | Parameter     | Description                                  | Type    | Required | Values             |
     * | ------------- | -------------------------------------------- | ------- | -------- | ------------------ |
     * | boxTextMargin | Margin around the text in loop/alt/opt boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 5
     */
    boxTextMargin: 5,
    /**
     * | Parameter  | Description         | Type    | Required | Values             |
     * | ---------- | ------------------- | ------- | -------- | ------------------ |
     * | noteMargin | Margin around notes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 10
     */
    noteMargin: 10,
    /**
     * | Parameter     | Description             | Type    | Required | Values             |
     * | ------------- | ----------------------- | ------- | -------- | ------------------ |
     * | messageMargin | Space between messages. | Integer | Required | Any Positive Value |
     *
     * **Notes:**
     *
     * Space between messages.
     *
     * Default value: 35
     */
    messageMargin: 35,
    /**
     * | Parameter    | Description                 | Type | Required | Values                    |
     * | ------------ | --------------------------- | ---- | -------- | ------------------------- |
     * | messageAlign | Multiline message alignment | 3    | 4        | 'left', 'center', 'right' |
     *
     * **Notes:** Default value: 'center'
     */
    messageAlign: "center",
    /**
     * | Parameter       | Description                                | Type    | Required | Values             |
     * | --------------- | ------------------------------------------ | ------- | -------- | ------------------ |
     * | bottomMarginAdj | Prolongs the edge of the diagram downwards | Integer | 4        | Any Positive Value |
     *
     * **Notes:**
     *
     * Depending on css styling this might need adjustment.
     *
     * Default value: 1
     */
    bottomMarginAdj: 1,
    /**
     * | Parameter   | Description | Type    | Required | Values      |
     * | ----------- | ----------- | ------- | -------- | ----------- |
     * | useMaxWidth | See notes   | boolean | 4        | true, false |
     *
     * **Notes:**
     *
     * When this flag is set the height and width is set to 100% and is then scaling with the
     * available space if not the absolute space required is used.
     *
     * Default value: true
     */
    useMaxWidth: true,
    /**
     * | Parameter   | Description                       | Type | Required | Values      |
     * | ----------- | --------------------------------- | ---- | -------- | ----------- |
     * | rightAngles | Curved Arrows become Right Angles | 3    | 4        | true, false |
     *
     * **Notes:**
     *
     * This will display arrows that start and begin at the same node as right angles, rather than a
     * curves
     *
     * Default value: false
     */
    rightAngles: false,
    taskFontSize: 14,
    taskFontFamily: '"Open Sans", sans-serif',
    taskMargin: 50,
    // width of activation box
    activationWidth: 10,
    // text placement as: tspan | fo | old only text as before
    textPlacement: "fo",
    actorColours: ["#8FBC8F", "#7CFC00", "#00FFFF", "#20B2AA", "#B0E0E6", "#FFFFE0"],
    sectionFills: ["#191970", "#8B008B", "#4B0082", "#2F4F4F", "#800000", "#8B4513", "#00008B"],
    sectionColours: ["#fff"],
    disableMulticolor: false
  },
  class: {
    /**
     * ### titleTopMargin
     *
     * | Parameter      | Description                                    | Type    | Required | Values             |
     * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
     * | titleTopMargin | Margin top for the text over the class diagram | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 25
     */
    titleTopMargin: 25,
    arrowMarkerAbsolute: false,
    dividerMargin: 10,
    padding: 5,
    textHeight: 10,
    /**
     * | Parameter   | Description | Type    | Required | Values      |
     * | ----------- | ----------- | ------- | -------- | ----------- |
     * | useMaxWidth | See notes   | boolean | 4        | true, false |
     *
     * **Notes:**
     *
     * When this flag is set the height and width is set to 100% and is then scaling with the
     * available space if not the absolute space required is used.
     *
     * Default value: true
     */
    useMaxWidth: true,
    /**
     * | Parameter       | Description | Type    | Required | Values                  |
     * | --------------- | ----------- | ------- | -------- | ----------------------- |
     * | defaultRenderer | See notes   | boolean | 4        | dagre-d3, dagre-wrapper |
     *
     * **Notes**:
     *
     * Decides which rendering engine that is to be used for the rendering. Legal values are:
     * dagre-d3 dagre-wrapper - wrapper for dagre implemented in mermaid
     *
     * Default value: 'dagre-d3'
     */
    defaultRenderer: "dagre-wrapper"
  },
  state: {
    /**
     * ### titleTopMargin
     *
     * | Parameter      | Description                                    | Type    | Required | Values             |
     * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
     * | titleTopMargin | Margin top for the text over the state diagram | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 25
     */
    titleTopMargin: 25,
    dividerMargin: 10,
    sizeUnit: 5,
    padding: 8,
    textHeight: 10,
    titleShift: -15,
    noteMargin: 10,
    forkWidth: 70,
    forkHeight: 7,
    // Used
    miniPadding: 2,
    // Font size factor, this is used to guess the width of the edges labels before rendering by dagre
    // layout. This might need updating if/when switching font
    fontSizeFactor: 5.02,
    fontSize: 24,
    labelHeight: 16,
    edgeLengthFactor: "20",
    compositTitleSize: 35,
    radius: 5,
    /**
     * | Parameter   | Description | Type    | Required | Values      |
     * | ----------- | ----------- | ------- | -------- | ----------- |
     * | useMaxWidth | See notes   | boolean | 4        | true, false |
     *
     * **Notes:**
     *
     * When this flag is set the height and width is set to 100% and is then scaling with the
     * available space if not the absolute space required is used.
     *
     * Default value: true
     */
    useMaxWidth: true,
    /**
     * | Parameter       | Description | Type    | Required | Values                  |
     * | --------------- | ----------- | ------- | -------- | ----------------------- |
     * | defaultRenderer | See notes   | boolean | 4        | dagre-d3, dagre-wrapper |
     *
     * **Notes:**
     *
     * Decides which rendering engine that is to be used for the rendering. Legal values are:
     * dagre-d3 dagre-wrapper - wrapper for dagre implemented in mermaid
     *
     * Default value: 'dagre-d3'
     */
    defaultRenderer: "dagre-wrapper"
  },
  /** The object containing configurations specific for entity relationship diagrams */
  er: {
    /**
     * ### titleTopMargin
     *
     * | Parameter      | Description                                    | Type    | Required | Values             |
     * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
     * | titleTopMargin | Margin top for the text over the diagram       | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 25
     */
    titleTopMargin: 25,
    /**
     * | Parameter      | Description                                     | Type    | Required | Values             |
     * | -------------- | ----------------------------------------------- | ------- | -------- | ------------------ |
     * | diagramPadding | Amount of padding around the diagram as a whole | Integer | Required | Any Positive Value |
     *
     * **Notes:**
     *
     * The amount of padding around the diagram as a whole so that embedded diagrams have margins,
     * expressed in pixels
     *
     * Default value: 20
     */
    diagramPadding: 20,
    /**
     * | Parameter       | Description                              | Type   | Required | Values                 |
     * | --------------- | ---------------------------------------- | ------ | -------- | ---------------------- |
     * | layoutDirection | Directional bias for layout of entities. | string | Required | "TB", "BT", "LR", "RL" |
     *
     * **Notes:**
     *
     * 'TB' for Top-Bottom, 'BT'for Bottom-Top, 'LR' for Left-Right, or 'RL' for Right to Left.
     *
     * T = top, B = bottom, L = left, and R = right.
     *
     * Default value: 'TB'
     */
    layoutDirection: "TB",
    /**
     * | Parameter      | Description                        | Type    | Required | Values             |
     * | -------------- | ---------------------------------- | ------- | -------- | ------------------ |
     * | minEntityWidth | The minimum width of an entity box | Integer | Required | Any Positive Value |
     *
     * **Notes:** Expressed in pixels. Default value: 100
     */
    minEntityWidth: 100,
    /**
     * | Parameter       | Description                         | Type    | Required | Values             |
     * | --------------- | ----------------------------------- | ------- | -------- | ------------------ |
     * | minEntityHeight | The minimum height of an entity box | Integer | 4        | Any Positive Value |
     *
     * **Notes:** Expressed in pixels Default value: 75
     */
    minEntityHeight: 75,
    /**
     * | Parameter     | Description                                                  | Type    | Required | Values             |
     * | ------------- | ------------------------------------------------------------ | ------- | -------- | ------------------ |
     * | entityPadding | Minimum internal padding between text in box and box borders | Integer | 4        | Any Positive Value |
     *
     * **Notes:**
     *
     * The minimum internal padding between text in an entity box and the enclosing box borders,
     * expressed in pixels.
     *
     * Default value: 15
     */
    entityPadding: 15,
    /**
     * | Parameter | Description                         | Type   | Required | Values               |
     * | --------- | ----------------------------------- | ------ | -------- | -------------------- |
     * | stroke    | Stroke color of box edges and lines | string | 4        | Any recognized color |
     *
     * **Notes:** Default value: 'gray'
     */
    stroke: "gray",
    /**
     * | Parameter | Description                | Type   | Required | Values               |
     * | --------- | -------------------------- | ------ | -------- | -------------------- |
     * | fill      | Fill color of entity boxes | string | 4        | Any recognized color |
     *
     * **Notes:** Default value: 'honeydew'
     */
    fill: "honeydew",
    /**
     * | Parameter | Description         | Type    | Required | Values             |
     * | --------- | ------------------- | ------- | -------- | ------------------ |
     * | fontSize  | Font Size in pixels | Integer |          | Any Positive Value |
     *
     * **Notes:**
     *
     * Font size (expressed as an integer representing a number of pixels) Default value: 12
     */
    fontSize: 12,
    /**
     * | Parameter   | Description | Type    | Required | Values      |
     * | ----------- | ----------- | ------- | -------- | ----------- |
     * | useMaxWidth | See Notes   | boolean | Required | true, false |
     *
     * **Notes:**
     *
     * When this flag is set to true, the diagram width is locked to 100% and scaled based on
     * available space. If set to false, the diagram reserves its absolute width.
     *
     * Default value: true
     */
    useMaxWidth: true
  },
  /** The object containing configurations specific for pie diagrams */
  pie: {
    useWidth: void 0,
    /**
     * | Parameter   | Description | Type    | Required | Values      |
     * | ----------- | ----------- | ------- | -------- | ----------- |
     * | useMaxWidth | See Notes   | boolean | Required | true, false |
     *
     * **Notes:**
     *
     * When this flag is set to true, the diagram width is locked to 100% and scaled based on
     * available space. If set to false, the diagram reserves its absolute width.
     *
     * Default value: true
     */
    useMaxWidth: true
  },
  /** The object containing configurations specific for req diagrams */
  requirement: {
    useWidth: void 0,
    /**
     * | Parameter   | Description | Type    | Required | Values      |
     * | ----------- | ----------- | ------- | -------- | ----------- |
     * | useMaxWidth | See Notes   | boolean | Required | true, false |
     *
     * **Notes:**
     *
     * When this flag is set to true, the diagram width is locked to 100% and scaled based on
     * available space. If set to false, the diagram reserves its absolute width.
     *
     * Default value: true
     */
    useMaxWidth: true,
    rect_fill: "#f9f9f9",
    text_color: "#333",
    rect_border_size: "0.5px",
    rect_border_color: "#bbb",
    rect_min_width: 200,
    rect_min_height: 200,
    fontSize: 14,
    rect_padding: 10,
    line_height: 20
  },
  gitGraph: {
    /**
     * ### titleTopMargin
     *
     * | Parameter      | Description                                    | Type    | Required | Values             |
     * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
     * | titleTopMargin | Margin top for the text over the Git diagram   | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 25
     */
    titleTopMargin: 25,
    diagramPadding: 8,
    nodeLabel: {
      width: 75,
      height: 100,
      x: -25,
      y: 0
    },
    mainBranchName: "main",
    mainBranchOrder: 0,
    showCommitLabel: true,
    showBranches: true,
    rotateCommitLabel: true
  },
  /** The object containing configurations specific for c4 diagrams */
  c4: {
    useWidth: void 0,
    /**
     * | Parameter      | Description                                    | Type    | Required | Values             |
     * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
     * | diagramMarginX | Margin to the right and left of the c4 diagram | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 50
     */
    diagramMarginX: 50,
    /**
     * | Parameter      | Description                                 | Type    | Required | Values             |
     * | -------------- | ------------------------------------------- | ------- | -------- | ------------------ |
     * | diagramMarginY | Margin to the over and under the c4 diagram | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 10
     */
    diagramMarginY: 10,
    /**
     * | Parameter     | Description           | Type    | Required | Values             |
     * | ------------- | --------------------- | ------- | -------- | ------------------ |
     * | c4ShapeMargin | Margin between shapes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 50
     */
    c4ShapeMargin: 50,
    /**
     * | Parameter      | Description            | Type    | Required | Values             |
     * | -------------- | ---------------------- | ------- | -------- | ------------------ |
     * | c4ShapePadding | Padding between shapes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 20
     */
    c4ShapePadding: 20,
    /**
     * | Parameter | Description           | Type    | Required | Values             |
     * | --------- | --------------------- | ------- | -------- | ------------------ |
     * | width     | Width of person boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 216
     */
    width: 216,
    /**
     * | Parameter | Description            | Type    | Required | Values             |
     * | --------- | ---------------------- | ------- | -------- | ------------------ |
     * | height    | Height of person boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 60
     */
    height: 60,
    /**
     * | Parameter | Description         | Type    | Required | Values             |
     * | --------- | ------------------- | ------- | -------- | ------------------ |
     * | boxMargin | Margin around boxes | Integer | Required | Any Positive Value |
     *
     * **Notes:** Default value: 10
     */
    boxMargin: 10,
    /**
     * | Parameter   | Description | Type    | Required | Values      |
     * | ----------- | ----------- | ------- | -------- | ----------- |
     * | useMaxWidth | See Notes   | boolean | Required | true, false |
     *
     * **Notes:** When this flag is set to true, the height and width is set to 100% and is then
     * scaling with the available space. If set to false, the absolute space required is used.
     *
     * Default value: true
     */
    useMaxWidth: true,
    /**
     * | Parameter    | Description | Type    | Required | Values             |
     * | ------------ | ----------- | ------- | -------- | ------------------ |
     * | c4ShapeInRow | See Notes   | Integer | Required | Any Positive Value |
     *
     * **Notes:** How many shapes to place in each row.
     *
     * Default value: 4
     */
    c4ShapeInRow: 4,
    nextLinePaddingX: 0,
    /**
     * | Parameter       | Description | Type    | Required | Values             |
     * | --------------- | ----------- | ------- | -------- | ------------------ |
     * | c4BoundaryInRow | See Notes   | Integer | Required | Any Positive Value |
     *
     * **Notes:** How many boundaries to place in each row.
     *
     * Default value: 2
     */
    c4BoundaryInRow: 2,
    /**
     * This sets the font size of Person shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    personFontSize: 14,
    /**
     * This sets the font family of Person shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    personFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of Person shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    personFontWeight: "normal",
    /**
     * This sets the font size of External Person shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    external_personFontSize: 14,
    /**
     * This sets the font family of External Person shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    external_personFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of External Person shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    external_personFontWeight: "normal",
    /**
     * This sets the font size of System shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    systemFontSize: 14,
    /**
     * This sets the font family of System shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    systemFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of System shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    systemFontWeight: "normal",
    /**
     * This sets the font size of External System shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    external_systemFontSize: 14,
    /**
     * This sets the font family of External System shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    external_systemFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of External System shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    external_systemFontWeight: "normal",
    /**
     * This sets the font size of System DB shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    system_dbFontSize: 14,
    /**
     * This sets the font family of System DB shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    system_dbFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of System DB shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    system_dbFontWeight: "normal",
    /**
     * This sets the font size of External System DB shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    external_system_dbFontSize: 14,
    /**
     * This sets the font family of External System DB shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    external_system_dbFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of External System DB shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    external_system_dbFontWeight: "normal",
    /**
     * This sets the font size of System Queue shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    system_queueFontSize: 14,
    /**
     * This sets the font family of System Queue shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    system_queueFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of System Queue shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    system_queueFontWeight: "normal",
    /**
     * This sets the font size of External System Queue shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    external_system_queueFontSize: 14,
    /**
     * This sets the font family of External System Queue shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    external_system_queueFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of External System Queue shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    external_system_queueFontWeight: "normal",
    /**
     * This sets the font size of Boundary shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    boundaryFontSize: 14,
    /**
     * This sets the font family of Boundary shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    boundaryFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of Boundary shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    boundaryFontWeight: "normal",
    /**
     * This sets the font size of Message shape for the diagram
     *
     * **Notes:** Default value: 12.
     */
    messageFontSize: 12,
    /**
     * This sets the font family of Message shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    messageFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of Message shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    messageFontWeight: "normal",
    /**
     * This sets the font size of Container shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    containerFontSize: 14,
    /**
     * This sets the font family of Container shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    containerFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of Container shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    containerFontWeight: "normal",
    /**
     * This sets the font size of External Container shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    external_containerFontSize: 14,
    /**
     * This sets the font family of External Container shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    external_containerFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of External Container shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    external_containerFontWeight: "normal",
    /**
     * This sets the font size of Container DB shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    container_dbFontSize: 14,
    /**
     * This sets the font family of Container DB shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    container_dbFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of Container DB shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    container_dbFontWeight: "normal",
    /**
     * This sets the font size of External Container DB shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    external_container_dbFontSize: 14,
    /**
     * This sets the font family of External Container DB shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    external_container_dbFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of External Container DB shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    external_container_dbFontWeight: "normal",
    /**
     * This sets the font size of Container Queue shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    container_queueFontSize: 14,
    /**
     * This sets the font family of Container Queue shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    container_queueFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of Container Queue shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    container_queueFontWeight: "normal",
    /**
     * This sets the font size of External Container Queue shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    external_container_queueFontSize: 14,
    /**
     * This sets the font family of External Container Queue shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    external_container_queueFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of External Container Queue shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    external_container_queueFontWeight: "normal",
    /**
     * This sets the font size of Component shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    componentFontSize: 14,
    /**
     * This sets the font family of Component shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    componentFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of Component shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    componentFontWeight: "normal",
    /**
     * This sets the font size of External Component shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    external_componentFontSize: 14,
    /**
     * This sets the font family of External Component shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    external_componentFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of External Component shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    external_componentFontWeight: "normal",
    /**
     * This sets the font size of Component DB shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    component_dbFontSize: 14,
    /**
     * This sets the font family of Component DB shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    component_dbFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of Component DB shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    component_dbFontWeight: "normal",
    /**
     * This sets the font size of External Component DB shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    external_component_dbFontSize: 14,
    /**
     * This sets the font family of External Component DB shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    external_component_dbFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of External Component DB shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    external_component_dbFontWeight: "normal",
    /**
     * This sets the font size of Component Queue shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    component_queueFontSize: 14,
    /**
     * This sets the font family of Component Queue shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    component_queueFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of Component Queue shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    component_queueFontWeight: "normal",
    /**
     * This sets the font size of External Component Queue shape for the diagram
     *
     * **Notes:** Default value: 14.
     */
    external_component_queueFontSize: 14,
    /**
     * This sets the font family of External Component Queue shape for the diagram
     *
     * **Notes:** Default value: "Open Sans", sans-serif.
     */
    external_component_queueFontFamily: '"Open Sans", sans-serif',
    /**
     * This sets the font weight of External Component Queue shape for the diagram
     *
     * **Notes:** Default value: normal.
     */
    external_component_queueFontWeight: "normal",
    /**
     * This sets the auto-wrap state for the diagram
     *
     * **Notes:** Default value: true.
     */
    wrap: true,
    /**
     * This sets the auto-wrap padding for the diagram (sides only)
     *
     * **Notes:** Default value: 0.
     */
    wrapPadding: 10,
    personFont: function() {
      return {
        fontFamily: this.personFontFamily,
        fontSize: this.personFontSize,
        fontWeight: this.personFontWeight
      };
    },
    external_personFont: function() {
      return {
        fontFamily: this.external_personFontFamily,
        fontSize: this.external_personFontSize,
        fontWeight: this.external_personFontWeight
      };
    },
    systemFont: function() {
      return {
        fontFamily: this.systemFontFamily,
        fontSize: this.systemFontSize,
        fontWeight: this.systemFontWeight
      };
    },
    external_systemFont: function() {
      return {
        fontFamily: this.external_systemFontFamily,
        fontSize: this.external_systemFontSize,
        fontWeight: this.external_systemFontWeight
      };
    },
    system_dbFont: function() {
      return {
        fontFamily: this.system_dbFontFamily,
        fontSize: this.system_dbFontSize,
        fontWeight: this.system_dbFontWeight
      };
    },
    external_system_dbFont: function() {
      return {
        fontFamily: this.external_system_dbFontFamily,
        fontSize: this.external_system_dbFontSize,
        fontWeight: this.external_system_dbFontWeight
      };
    },
    system_queueFont: function() {
      return {
        fontFamily: this.system_queueFontFamily,
        fontSize: this.system_queueFontSize,
        fontWeight: this.system_queueFontWeight
      };
    },
    external_system_queueFont: function() {
      return {
        fontFamily: this.external_system_queueFontFamily,
        fontSize: this.external_system_queueFontSize,
        fontWeight: this.external_system_queueFontWeight
      };
    },
    containerFont: function() {
      return {
        fontFamily: this.containerFontFamily,
        fontSize: this.containerFontSize,
        fontWeight: this.containerFontWeight
      };
    },
    external_containerFont: function() {
      return {
        fontFamily: this.external_containerFontFamily,
        fontSize: this.external_containerFontSize,
        fontWeight: this.external_containerFontWeight
      };
    },
    container_dbFont: function() {
      return {
        fontFamily: this.container_dbFontFamily,
        fontSize: this.container_dbFontSize,
        fontWeight: this.container_dbFontWeight
      };
    },
    external_container_dbFont: function() {
      return {
        fontFamily: this.external_container_dbFontFamily,
        fontSize: this.external_container_dbFontSize,
        fontWeight: this.external_container_dbFontWeight
      };
    },
    container_queueFont: function() {
      return {
        fontFamily: this.container_queueFontFamily,
        fontSize: this.container_queueFontSize,
        fontWeight: this.container_queueFontWeight
      };
    },
    external_container_queueFont: function() {
      return {
        fontFamily: this.external_container_queueFontFamily,
        fontSize: this.external_container_queueFontSize,
        fontWeight: this.external_container_queueFontWeight
      };
    },
    componentFont: function() {
      return {
        fontFamily: this.componentFontFamily,
        fontSize: this.componentFontSize,
        fontWeight: this.componentFontWeight
      };
    },
    external_componentFont: function() {
      return {
        fontFamily: this.external_componentFontFamily,
        fontSize: this.external_componentFontSize,
        fontWeight: this.external_componentFontWeight
      };
    },
    component_dbFont: function() {
      return {
        fontFamily: this.component_dbFontFamily,
        fontSize: this.component_dbFontSize,
        fontWeight: this.component_dbFontWeight
      };
    },
    external_component_dbFont: function() {
      return {
        fontFamily: this.external_component_dbFontFamily,
        fontSize: this.external_component_dbFontSize,
        fontWeight: this.external_component_dbFontWeight
      };
    },
    component_queueFont: function() {
      return {
        fontFamily: this.component_queueFontFamily,
        fontSize: this.component_queueFontSize,
        fontWeight: this.component_queueFontWeight
      };
    },
    external_component_queueFont: function() {
      return {
        fontFamily: this.external_component_queueFontFamily,
        fontSize: this.external_component_queueFontSize,
        fontWeight: this.external_component_queueFontWeight
      };
    },
    boundaryFont: function() {
      return {
        fontFamily: this.boundaryFontFamily,
        fontSize: this.boundaryFontSize,
        fontWeight: this.boundaryFontWeight
      };
    },
    messageFont: function() {
      return {
        fontFamily: this.messageFontFamily,
        fontSize: this.messageFontSize,
        fontWeight: this.messageFontWeight
      };
    },
    // ' Colors
    // ' ##################################
    person_bg_color: "#08427B",
    person_border_color: "#073B6F",
    external_person_bg_color: "#686868",
    external_person_border_color: "#8A8A8A",
    system_bg_color: "#1168BD",
    system_border_color: "#3C7FC0",
    system_db_bg_color: "#1168BD",
    system_db_border_color: "#3C7FC0",
    system_queue_bg_color: "#1168BD",
    system_queue_border_color: "#3C7FC0",
    external_system_bg_color: "#999999",
    external_system_border_color: "#8A8A8A",
    external_system_db_bg_color: "#999999",
    external_system_db_border_color: "#8A8A8A",
    external_system_queue_bg_color: "#999999",
    external_system_queue_border_color: "#8A8A8A",
    container_bg_color: "#438DD5",
    container_border_color: "#3C7FC0",
    container_db_bg_color: "#438DD5",
    container_db_border_color: "#3C7FC0",
    container_queue_bg_color: "#438DD5",
    container_queue_border_color: "#3C7FC0",
    external_container_bg_color: "#B3B3B3",
    external_container_border_color: "#A6A6A6",
    external_container_db_bg_color: "#B3B3B3",
    external_container_db_border_color: "#A6A6A6",
    external_container_queue_bg_color: "#B3B3B3",
    external_container_queue_border_color: "#A6A6A6",
    component_bg_color: "#85BBF0",
    component_border_color: "#78A8D8",
    component_db_bg_color: "#85BBF0",
    component_db_border_color: "#78A8D8",
    component_queue_bg_color: "#85BBF0",
    component_queue_border_color: "#78A8D8",
    external_component_bg_color: "#CCCCCC",
    external_component_border_color: "#BFBFBF",
    external_component_db_bg_color: "#CCCCCC",
    external_component_db_border_color: "#BFBFBF",
    external_component_queue_bg_color: "#CCCCCC",
    external_component_queue_border_color: "#BFBFBF"
  },
  mindmap: {
    useMaxWidth: true,
    padding: 10,
    maxNodeWidth: 200
  },
  fontSize: 16
};
if (config$1.class) {
  config$1.class.arrowMarkerAbsolute = config$1.arrowMarkerAbsolute;
}
if (config$1.gitGraph) {
  config$1.gitGraph.arrowMarkerAbsolute = config$1.arrowMarkerAbsolute;
}
const keyify = (obj, prefix = "") => Object.keys(obj).reduce((res, el) => {
  if (Array.isArray(obj[el])) {
    return res;
  } else if (typeof obj[el] === "object" && obj[el] !== null) {
    return [...res, prefix + el, ...keyify(obj[el], "")];
  }
  return [...res, prefix + el];
}, []);
const configKeys = keyify(config$1, "");
const config$2 = config$1;
/*! js-yaml 4.1.0 https://github.com/nodeca/js-yaml @license MIT */
function isNothing(subject) {
  return typeof subject === "undefined" || subject === null;
}
function isObject(subject) {
  return typeof subject === "object" && subject !== null;
}
function toArray(sequence) {
  if (Array.isArray(sequence))
    return sequence;
  else if (isNothing(sequence))
    return [];
  return [sequence];
}
function extend(target, source) {
  var index, length, key, sourceKeys;
  if (source) {
    sourceKeys = Object.keys(source);
    for (index = 0, length = sourceKeys.length; index < length; index += 1) {
      key = sourceKeys[index];
      target[key] = source[key];
    }
  }
  return target;
}
function repeat(string, count) {
  var result = "", cycle;
  for (cycle = 0; cycle < count; cycle += 1) {
    result += string;
  }
  return result;
}
function isNegativeZero(number) {
  return number === 0 && Number.NEGATIVE_INFINITY === 1 / number;
}
var isNothing_1 = isNothing;
var isObject_1 = isObject;
var toArray_1 = toArray;
var repeat_1 = repeat;
var isNegativeZero_1 = isNegativeZero;
var extend_1 = extend;
var common = {
  isNothing: isNothing_1,
  isObject: isObject_1,
  toArray: toArray_1,
  repeat: repeat_1,
  isNegativeZero: isNegativeZero_1,
  extend: extend_1
};
function formatError(exception2, compact) {
  var where = "", message2 = exception2.reason || "(unknown reason)";
  if (!exception2.mark)
    return message2;
  if (exception2.mark.name) {
    where += 'in "' + exception2.mark.name + '" ';
  }
  where += "(" + (exception2.mark.line + 1) + ":" + (exception2.mark.column + 1) + ")";
  if (!compact && exception2.mark.snippet) {
    where += "\n\n" + exception2.mark.snippet;
  }
  return message2 + " " + where;
}
function YAMLException$1(reason, mark) {
  Error.call(this);
  this.name = "YAMLException";
  this.reason = reason;
  this.mark = mark;
  this.message = formatError(this, false);
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, this.constructor);
  } else {
    this.stack = new Error().stack || "";
  }
}
YAMLException$1.prototype = Object.create(Error.prototype);
YAMLException$1.prototype.constructor = YAMLException$1;
YAMLException$1.prototype.toString = function toString(compact) {
  return this.name + ": " + formatError(this, compact);
};
var exception = YAMLException$1;
function getLine(buffer, lineStart, lineEnd, position, maxLineLength) {
  var head2 = "";
  var tail = "";
  var maxHalfLength = Math.floor(maxLineLength / 2) - 1;
  if (position - lineStart > maxHalfLength) {
    head2 = " ... ";
    lineStart = position - maxHalfLength + head2.length;
  }
  if (lineEnd - position > maxHalfLength) {
    tail = " ...";
    lineEnd = position + maxHalfLength - tail.length;
  }
  return {
    str: head2 + buffer.slice(lineStart, lineEnd).replace(/\t/g, "→") + tail,
    pos: position - lineStart + head2.length
    // relative position
  };
}
function padStart(string, max2) {
  return common.repeat(" ", max2 - string.length) + string;
}
function makeSnippet(mark, options2) {
  options2 = Object.create(options2 || null);
  if (!mark.buffer)
    return null;
  if (!options2.maxLength)
    options2.maxLength = 79;
  if (typeof options2.indent !== "number")
    options2.indent = 1;
  if (typeof options2.linesBefore !== "number")
    options2.linesBefore = 3;
  if (typeof options2.linesAfter !== "number")
    options2.linesAfter = 2;
  var re = /\r?\n|\r|\0/g;
  var lineStarts = [0];
  var lineEnds = [];
  var match;
  var foundLineNo = -1;
  while (match = re.exec(mark.buffer)) {
    lineEnds.push(match.index);
    lineStarts.push(match.index + match[0].length);
    if (mark.position <= match.index && foundLineNo < 0) {
      foundLineNo = lineStarts.length - 2;
    }
  }
  if (foundLineNo < 0)
    foundLineNo = lineStarts.length - 1;
  var result = "", i, line2;
  var lineNoLength = Math.min(mark.line + options2.linesAfter, lineEnds.length).toString().length;
  var maxLineLength = options2.maxLength - (options2.indent + lineNoLength + 3);
  for (i = 1; i <= options2.linesBefore; i++) {
    if (foundLineNo - i < 0)
      break;
    line2 = getLine(
      mark.buffer,
      lineStarts[foundLineNo - i],
      lineEnds[foundLineNo - i],
      mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo - i]),
      maxLineLength
    );
    result = common.repeat(" ", options2.indent) + padStart((mark.line - i + 1).toString(), lineNoLength) + " | " + line2.str + "\n" + result;
  }
  line2 = getLine(mark.buffer, lineStarts[foundLineNo], lineEnds[foundLineNo], mark.position, maxLineLength);
  result += common.repeat(" ", options2.indent) + padStart((mark.line + 1).toString(), lineNoLength) + " | " + line2.str + "\n";
  result += common.repeat("-", options2.indent + lineNoLength + 3 + line2.pos) + "^\n";
  for (i = 1; i <= options2.linesAfter; i++) {
    if (foundLineNo + i >= lineEnds.length)
      break;
    line2 = getLine(
      mark.buffer,
      lineStarts[foundLineNo + i],
      lineEnds[foundLineNo + i],
      mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo + i]),
      maxLineLength
    );
    result += common.repeat(" ", options2.indent) + padStart((mark.line + i + 1).toString(), lineNoLength) + " | " + line2.str + "\n";
  }
  return result.replace(/\n$/, "");
}
var snippet = makeSnippet;
var TYPE_CONSTRUCTOR_OPTIONS = [
  "kind",
  "multi",
  "resolve",
  "construct",
  "instanceOf",
  "predicate",
  "represent",
  "representName",
  "defaultStyle",
  "styleAliases"
];
var YAML_NODE_KINDS = [
  "scalar",
  "sequence",
  "mapping"
];
function compileStyleAliases(map2) {
  var result = {};
  if (map2 !== null) {
    Object.keys(map2).forEach(function(style) {
      map2[style].forEach(function(alias) {
        result[String(alias)] = style;
      });
    });
  }
  return result;
}
function Type$1(tag, options2) {
  options2 = options2 || {};
  Object.keys(options2).forEach(function(name) {
    if (TYPE_CONSTRUCTOR_OPTIONS.indexOf(name) === -1) {
      throw new exception('Unknown option "' + name + '" is met in definition of "' + tag + '" YAML type.');
    }
  });
  this.options = options2;
  this.tag = tag;
  this.kind = options2["kind"] || null;
  this.resolve = options2["resolve"] || function() {
    return true;
  };
  this.construct = options2["construct"] || function(data) {
    return data;
  };
  this.instanceOf = options2["instanceOf"] || null;
  this.predicate = options2["predicate"] || null;
  this.represent = options2["represent"] || null;
  this.representName = options2["representName"] || null;
  this.defaultStyle = options2["defaultStyle"] || null;
  this.multi = options2["multi"] || false;
  this.styleAliases = compileStyleAliases(options2["styleAliases"] || null);
  if (YAML_NODE_KINDS.indexOf(this.kind) === -1) {
    throw new exception('Unknown kind "' + this.kind + '" is specified for "' + tag + '" YAML type.');
  }
}
var type = Type$1;
function compileList(schema2, name) {
  var result = [];
  schema2[name].forEach(function(currentType) {
    var newIndex = result.length;
    result.forEach(function(previousType, previousIndex) {
      if (previousType.tag === currentType.tag && previousType.kind === currentType.kind && previousType.multi === currentType.multi) {
        newIndex = previousIndex;
      }
    });
    result[newIndex] = currentType;
  });
  return result;
}
function compileMap() {
  var result = {
    scalar: {},
    sequence: {},
    mapping: {},
    fallback: {},
    multi: {
      scalar: [],
      sequence: [],
      mapping: [],
      fallback: []
    }
  }, index, length;
  function collectType(type2) {
    if (type2.multi) {
      result.multi[type2.kind].push(type2);
      result.multi["fallback"].push(type2);
    } else {
      result[type2.kind][type2.tag] = result["fallback"][type2.tag] = type2;
    }
  }
  for (index = 0, length = arguments.length; index < length; index += 1) {
    arguments[index].forEach(collectType);
  }
  return result;
}
function Schema$1(definition) {
  return this.extend(definition);
}
Schema$1.prototype.extend = function extend2(definition) {
  var implicit = [];
  var explicit = [];
  if (definition instanceof type) {
    explicit.push(definition);
  } else if (Array.isArray(definition)) {
    explicit = explicit.concat(definition);
  } else if (definition && (Array.isArray(definition.implicit) || Array.isArray(definition.explicit))) {
    if (definition.implicit)
      implicit = implicit.concat(definition.implicit);
    if (definition.explicit)
      explicit = explicit.concat(definition.explicit);
  } else {
    throw new exception("Schema.extend argument should be a Type, [ Type ], or a schema definition ({ implicit: [...], explicit: [...] })");
  }
  implicit.forEach(function(type$1) {
    if (!(type$1 instanceof type)) {
      throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
    }
    if (type$1.loadKind && type$1.loadKind !== "scalar") {
      throw new exception("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");
    }
    if (type$1.multi) {
      throw new exception("There is a multi type in the implicit list of a schema. Multi tags can only be listed as explicit.");
    }
  });
  explicit.forEach(function(type$1) {
    if (!(type$1 instanceof type)) {
      throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
    }
  });
  var result = Object.create(Schema$1.prototype);
  result.implicit = (this.implicit || []).concat(implicit);
  result.explicit = (this.explicit || []).concat(explicit);
  result.compiledImplicit = compileList(result, "implicit");
  result.compiledExplicit = compileList(result, "explicit");
  result.compiledTypeMap = compileMap(result.compiledImplicit, result.compiledExplicit);
  return result;
};
var schema = Schema$1;
var str = new type("tag:yaml.org,2002:str", {
  kind: "scalar",
  construct: function(data) {
    return data !== null ? data : "";
  }
});
var seq$1 = new type("tag:yaml.org,2002:seq", {
  kind: "sequence",
  construct: function(data) {
    return data !== null ? data : [];
  }
});
var map = new type("tag:yaml.org,2002:map", {
  kind: "mapping",
  construct: function(data) {
    return data !== null ? data : {};
  }
});
var failsafe = new schema({
  explicit: [
    str,
    seq$1,
    map
  ]
});
function resolveYamlNull(data) {
  if (data === null)
    return true;
  var max2 = data.length;
  return max2 === 1 && data === "~" || max2 === 4 && (data === "null" || data === "Null" || data === "NULL");
}
function constructYamlNull() {
  return null;
}
function isNull(object) {
  return object === null;
}
var _null = new type("tag:yaml.org,2002:null", {
  kind: "scalar",
  resolve: resolveYamlNull,
  construct: constructYamlNull,
  predicate: isNull,
  represent: {
    canonical: function() {
      return "~";
    },
    lowercase: function() {
      return "null";
    },
    uppercase: function() {
      return "NULL";
    },
    camelcase: function() {
      return "Null";
    },
    empty: function() {
      return "";
    }
  },
  defaultStyle: "lowercase"
});
function resolveYamlBoolean(data) {
  if (data === null)
    return false;
  var max2 = data.length;
  return max2 === 4 && (data === "true" || data === "True" || data === "TRUE") || max2 === 5 && (data === "false" || data === "False" || data === "FALSE");
}
function constructYamlBoolean(data) {
  return data === "true" || data === "True" || data === "TRUE";
}
function isBoolean(object) {
  return Object.prototype.toString.call(object) === "[object Boolean]";
}
var bool = new type("tag:yaml.org,2002:bool", {
  kind: "scalar",
  resolve: resolveYamlBoolean,
  construct: constructYamlBoolean,
  predicate: isBoolean,
  represent: {
    lowercase: function(object) {
      return object ? "true" : "false";
    },
    uppercase: function(object) {
      return object ? "TRUE" : "FALSE";
    },
    camelcase: function(object) {
      return object ? "True" : "False";
    }
  },
  defaultStyle: "lowercase"
});
function isHexCode(c2) {
  return 48 <= c2 && c2 <= 57 || 65 <= c2 && c2 <= 70 || 97 <= c2 && c2 <= 102;
}
function isOctCode(c2) {
  return 48 <= c2 && c2 <= 55;
}
function isDecCode(c2) {
  return 48 <= c2 && c2 <= 57;
}
function resolveYamlInteger(data) {
  if (data === null)
    return false;
  var max2 = data.length, index = 0, hasDigits = false, ch;
  if (!max2)
    return false;
  ch = data[index];
  if (ch === "-" || ch === "+") {
    ch = data[++index];
  }
  if (ch === "0") {
    if (index + 1 === max2)
      return true;
    ch = data[++index];
    if (ch === "b") {
      index++;
      for (; index < max2; index++) {
        ch = data[index];
        if (ch === "_")
          continue;
        if (ch !== "0" && ch !== "1")
          return false;
        hasDigits = true;
      }
      return hasDigits && ch !== "_";
    }
    if (ch === "x") {
      index++;
      for (; index < max2; index++) {
        ch = data[index];
        if (ch === "_")
          continue;
        if (!isHexCode(data.charCodeAt(index)))
          return false;
        hasDigits = true;
      }
      return hasDigits && ch !== "_";
    }
    if (ch === "o") {
      index++;
      for (; index < max2; index++) {
        ch = data[index];
        if (ch === "_")
          continue;
        if (!isOctCode(data.charCodeAt(index)))
          return false;
        hasDigits = true;
      }
      return hasDigits && ch !== "_";
    }
  }
  if (ch === "_")
    return false;
  for (; index < max2; index++) {
    ch = data[index];
    if (ch === "_")
      continue;
    if (!isDecCode(data.charCodeAt(index))) {
      return false;
    }
    hasDigits = true;
  }
  if (!hasDigits || ch === "_")
    return false;
  return true;
}
function constructYamlInteger(data) {
  var value = data, sign = 1, ch;
  if (value.indexOf("_") !== -1) {
    value = value.replace(/_/g, "");
  }
  ch = value[0];
  if (ch === "-" || ch === "+") {
    if (ch === "-")
      sign = -1;
    value = value.slice(1);
    ch = value[0];
  }
  if (value === "0")
    return 0;
  if (ch === "0") {
    if (value[1] === "b")
      return sign * parseInt(value.slice(2), 2);
    if (value[1] === "x")
      return sign * parseInt(value.slice(2), 16);
    if (value[1] === "o")
      return sign * parseInt(value.slice(2), 8);
  }
  return sign * parseInt(value, 10);
}
function isInteger(object) {
  return Object.prototype.toString.call(object) === "[object Number]" && (object % 1 === 0 && !common.isNegativeZero(object));
}
var int = new type("tag:yaml.org,2002:int", {
  kind: "scalar",
  resolve: resolveYamlInteger,
  construct: constructYamlInteger,
  predicate: isInteger,
  represent: {
    binary: function(obj) {
      return obj >= 0 ? "0b" + obj.toString(2) : "-0b" + obj.toString(2).slice(1);
    },
    octal: function(obj) {
      return obj >= 0 ? "0o" + obj.toString(8) : "-0o" + obj.toString(8).slice(1);
    },
    decimal: function(obj) {
      return obj.toString(10);
    },
    /* eslint-disable max-len */
    hexadecimal: function(obj) {
      return obj >= 0 ? "0x" + obj.toString(16).toUpperCase() : "-0x" + obj.toString(16).toUpperCase().slice(1);
    }
  },
  defaultStyle: "decimal",
  styleAliases: {
    binary: [2, "bin"],
    octal: [8, "oct"],
    decimal: [10, "dec"],
    hexadecimal: [16, "hex"]
  }
});
var YAML_FLOAT_PATTERN = new RegExp(
  // 2.5e4, 2.5 and integers
  "^(?:[-+]?(?:[0-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$"
);
function resolveYamlFloat(data) {
  if (data === null)
    return false;
  if (!YAML_FLOAT_PATTERN.test(data) || // Quick hack to not allow integers end with `_`
  // Probably should update regexp & check speed
  data[data.length - 1] === "_") {
    return false;
  }
  return true;
}
function constructYamlFloat(data) {
  var value, sign;
  value = data.replace(/_/g, "").toLowerCase();
  sign = value[0] === "-" ? -1 : 1;
  if ("+-".indexOf(value[0]) >= 0) {
    value = value.slice(1);
  }
  if (value === ".inf") {
    return sign === 1 ? Number.POSITIVE_INFINITY : Number.NEGATIVE_INFINITY;
  } else if (value === ".nan") {
    return NaN;
  }
  return sign * parseFloat(value, 10);
}
var SCIENTIFIC_WITHOUT_DOT = /^[-+]?[0-9]+e/;
function representYamlFloat(object, style) {
  var res;
  if (isNaN(object)) {
    switch (style) {
      case "lowercase":
        return ".nan";
      case "uppercase":
        return ".NAN";
      case "camelcase":
        return ".NaN";
    }
  } else if (Number.POSITIVE_INFINITY === object) {
    switch (style) {
      case "lowercase":
        return ".inf";
      case "uppercase":
        return ".INF";
      case "camelcase":
        return ".Inf";
    }
  } else if (Number.NEGATIVE_INFINITY === object) {
    switch (style) {
      case "lowercase":
        return "-.inf";
      case "uppercase":
        return "-.INF";
      case "camelcase":
        return "-.Inf";
    }
  } else if (common.isNegativeZero(object)) {
    return "-0.0";
  }
  res = object.toString(10);
  return SCIENTIFIC_WITHOUT_DOT.test(res) ? res.replace("e", ".e") : res;
}
function isFloat(object) {
  return Object.prototype.toString.call(object) === "[object Number]" && (object % 1 !== 0 || common.isNegativeZero(object));
}
var float = new type("tag:yaml.org,2002:float", {
  kind: "scalar",
  resolve: resolveYamlFloat,
  construct: constructYamlFloat,
  predicate: isFloat,
  represent: representYamlFloat,
  defaultStyle: "lowercase"
});
var json = failsafe.extend({
  implicit: [
    _null,
    bool,
    int,
    float
  ]
});
var core = json;
var YAML_DATE_REGEXP = new RegExp(
  "^([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])$"
);
var YAML_TIMESTAMP_REGEXP = new RegExp(
  "^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?$"
);
function resolveYamlTimestamp(data) {
  if (data === null)
    return false;
  if (YAML_DATE_REGEXP.exec(data) !== null)
    return true;
  if (YAML_TIMESTAMP_REGEXP.exec(data) !== null)
    return true;
  return false;
}
function constructYamlTimestamp(data) {
  var match, year, month, day, hour, minute, second, fraction = 0, delta = null, tz_hour, tz_minute, date;
  match = YAML_DATE_REGEXP.exec(data);
  if (match === null)
    match = YAML_TIMESTAMP_REGEXP.exec(data);
  if (match === null)
    throw new Error("Date resolve error");
  year = +match[1];
  month = +match[2] - 1;
  day = +match[3];
  if (!match[4]) {
    return new Date(Date.UTC(year, month, day));
  }
  hour = +match[4];
  minute = +match[5];
  second = +match[6];
  if (match[7]) {
    fraction = match[7].slice(0, 3);
    while (fraction.length < 3) {
      fraction += "0";
    }
    fraction = +fraction;
  }
  if (match[9]) {
    tz_hour = +match[10];
    tz_minute = +(match[11] || 0);
    delta = (tz_hour * 60 + tz_minute) * 6e4;
    if (match[9] === "-")
      delta = -delta;
  }
  date = new Date(Date.UTC(year, month, day, hour, minute, second, fraction));
  if (delta)
    date.setTime(date.getTime() - delta);
  return date;
}
function representYamlTimestamp(object) {
  return object.toISOString();
}
var timestamp = new type("tag:yaml.org,2002:timestamp", {
  kind: "scalar",
  resolve: resolveYamlTimestamp,
  construct: constructYamlTimestamp,
  instanceOf: Date,
  represent: representYamlTimestamp
});
function resolveYamlMerge(data) {
  return data === "<<" || data === null;
}
var merge$1 = new type("tag:yaml.org,2002:merge", {
  kind: "scalar",
  resolve: resolveYamlMerge
});
var BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";
function resolveYamlBinary(data) {
  if (data === null)
    return false;
  var code, idx, bitlen = 0, max2 = data.length, map2 = BASE64_MAP;
  for (idx = 0; idx < max2; idx++) {
    code = map2.indexOf(data.charAt(idx));
    if (code > 64)
      continue;
    if (code < 0)
      return false;
    bitlen += 6;
  }
  return bitlen % 8 === 0;
}
function constructYamlBinary(data) {
  var idx, tailbits, input = data.replace(/[\r\n=]/g, ""), max2 = input.length, map2 = BASE64_MAP, bits = 0, result = [];
  for (idx = 0; idx < max2; idx++) {
    if (idx % 4 === 0 && idx) {
      result.push(bits >> 16 & 255);
      result.push(bits >> 8 & 255);
      result.push(bits & 255);
    }
    bits = bits << 6 | map2.indexOf(input.charAt(idx));
  }
  tailbits = max2 % 4 * 6;
  if (tailbits === 0) {
    result.push(bits >> 16 & 255);
    result.push(bits >> 8 & 255);
    result.push(bits & 255);
  } else if (tailbits === 18) {
    result.push(bits >> 10 & 255);
    result.push(bits >> 2 & 255);
  } else if (tailbits === 12) {
    result.push(bits >> 4 & 255);
  }
  return new Uint8Array(result);
}
function representYamlBinary(object) {
  var result = "", bits = 0, idx, tail, max2 = object.length, map2 = BASE64_MAP;
  for (idx = 0; idx < max2; idx++) {
    if (idx % 3 === 0 && idx) {
      result += map2[bits >> 18 & 63];
      result += map2[bits >> 12 & 63];
      result += map2[bits >> 6 & 63];
      result += map2[bits & 63];
    }
    bits = (bits << 8) + object[idx];
  }
  tail = max2 % 3;
  if (tail === 0) {
    result += map2[bits >> 18 & 63];
    result += map2[bits >> 12 & 63];
    result += map2[bits >> 6 & 63];
    result += map2[bits & 63];
  } else if (tail === 2) {
    result += map2[bits >> 10 & 63];
    result += map2[bits >> 4 & 63];
    result += map2[bits << 2 & 63];
    result += map2[64];
  } else if (tail === 1) {
    result += map2[bits >> 2 & 63];
    result += map2[bits << 4 & 63];
    result += map2[64];
    result += map2[64];
  }
  return result;
}
function isBinary(obj) {
  return Object.prototype.toString.call(obj) === "[object Uint8Array]";
}
var binary = new type("tag:yaml.org,2002:binary", {
  kind: "scalar",
  resolve: resolveYamlBinary,
  construct: constructYamlBinary,
  predicate: isBinary,
  represent: representYamlBinary
});
var _hasOwnProperty$3 = Object.prototype.hasOwnProperty;
var _toString$2 = Object.prototype.toString;
function resolveYamlOmap(data) {
  if (data === null)
    return true;
  var objectKeys = [], index, length, pair, pairKey, pairHasKey, object = data;
  for (index = 0, length = object.length; index < length; index += 1) {
    pair = object[index];
    pairHasKey = false;
    if (_toString$2.call(pair) !== "[object Object]")
      return false;
    for (pairKey in pair) {
      if (_hasOwnProperty$3.call(pair, pairKey)) {
        if (!pairHasKey)
          pairHasKey = true;
        else
          return false;
      }
    }
    if (!pairHasKey)
      return false;
    if (objectKeys.indexOf(pairKey) === -1)
      objectKeys.push(pairKey);
    else
      return false;
  }
  return true;
}
function constructYamlOmap(data) {
  return data !== null ? data : [];
}
var omap = new type("tag:yaml.org,2002:omap", {
  kind: "sequence",
  resolve: resolveYamlOmap,
  construct: constructYamlOmap
});
var _toString$1 = Object.prototype.toString;
function resolveYamlPairs(data) {
  if (data === null)
    return true;
  var index, length, pair, keys2, result, object = data;
  result = new Array(object.length);
  for (index = 0, length = object.length; index < length; index += 1) {
    pair = object[index];
    if (_toString$1.call(pair) !== "[object Object]")
      return false;
    keys2 = Object.keys(pair);
    if (keys2.length !== 1)
      return false;
    result[index] = [keys2[0], pair[keys2[0]]];
  }
  return true;
}
function constructYamlPairs(data) {
  if (data === null)
    return [];
  var index, length, pair, keys2, result, object = data;
  result = new Array(object.length);
  for (index = 0, length = object.length; index < length; index += 1) {
    pair = object[index];
    keys2 = Object.keys(pair);
    result[index] = [keys2[0], pair[keys2[0]]];
  }
  return result;
}
var pairs = new type("tag:yaml.org,2002:pairs", {
  kind: "sequence",
  resolve: resolveYamlPairs,
  construct: constructYamlPairs
});
var _hasOwnProperty$2 = Object.prototype.hasOwnProperty;
function resolveYamlSet(data) {
  if (data === null)
    return true;
  var key, object = data;
  for (key in object) {
    if (_hasOwnProperty$2.call(object, key)) {
      if (object[key] !== null)
        return false;
    }
  }
  return true;
}
function constructYamlSet(data) {
  return data !== null ? data : {};
}
var set$1 = new type("tag:yaml.org,2002:set", {
  kind: "mapping",
  resolve: resolveYamlSet,
  construct: constructYamlSet
});
var _default = core.extend({
  implicit: [
    timestamp,
    merge$1
  ],
  explicit: [
    binary,
    omap,
    pairs,
    set$1
  ]
});
var _hasOwnProperty$1 = Object.prototype.hasOwnProperty;
var CONTEXT_FLOW_IN = 1;
var CONTEXT_FLOW_OUT = 2;
var CONTEXT_BLOCK_IN = 3;
var CONTEXT_BLOCK_OUT = 4;
var CHOMPING_CLIP = 1;
var CHOMPING_STRIP = 2;
var CHOMPING_KEEP = 3;
var PATTERN_NON_PRINTABLE = /[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
var PATTERN_NON_ASCII_LINE_BREAKS = /[\x85\u2028\u2029]/;
var PATTERN_FLOW_INDICATORS = /[,\[\]\{\}]/;
var PATTERN_TAG_HANDLE = /^(?:!|!!|![a-z\-]+!)$/i;
var PATTERN_TAG_URI = /^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;
function _class(obj) {
  return Object.prototype.toString.call(obj);
}
function is_EOL(c2) {
  return c2 === 10 || c2 === 13;
}
function is_WHITE_SPACE(c2) {
  return c2 === 9 || c2 === 32;
}
function is_WS_OR_EOL(c2) {
  return c2 === 9 || c2 === 32 || c2 === 10 || c2 === 13;
}
function is_FLOW_INDICATOR(c2) {
  return c2 === 44 || c2 === 91 || c2 === 93 || c2 === 123 || c2 === 125;
}
function fromHexCode(c2) {
  var lc;
  if (48 <= c2 && c2 <= 57) {
    return c2 - 48;
  }
  lc = c2 | 32;
  if (97 <= lc && lc <= 102) {
    return lc - 97 + 10;
  }
  return -1;
}
function escapedHexLen(c2) {
  if (c2 === 120) {
    return 2;
  }
  if (c2 === 117) {
    return 4;
  }
  if (c2 === 85) {
    return 8;
  }
  return 0;
}
function fromDecimalCode(c2) {
  if (48 <= c2 && c2 <= 57) {
    return c2 - 48;
  }
  return -1;
}
function simpleEscapeSequence(c2) {
  return c2 === 48 ? "\0" : c2 === 97 ? "\x07" : c2 === 98 ? "\b" : c2 === 116 ? "	" : c2 === 9 ? "	" : c2 === 110 ? "\n" : c2 === 118 ? "\v" : c2 === 102 ? "\f" : c2 === 114 ? "\r" : c2 === 101 ? "\x1B" : c2 === 32 ? " " : c2 === 34 ? '"' : c2 === 47 ? "/" : c2 === 92 ? "\\" : c2 === 78 ? "" : c2 === 95 ? " " : c2 === 76 ? "\u2028" : c2 === 80 ? "\u2029" : "";
}
function charFromCodepoint(c2) {
  if (c2 <= 65535) {
    return String.fromCharCode(c2);
  }
  return String.fromCharCode(
    (c2 - 65536 >> 10) + 55296,
    (c2 - 65536 & 1023) + 56320
  );
}
var simpleEscapeCheck = new Array(256);
var simpleEscapeMap = new Array(256);
for (var i = 0; i < 256; i++) {
  simpleEscapeCheck[i] = simpleEscapeSequence(i) ? 1 : 0;
  simpleEscapeMap[i] = simpleEscapeSequence(i);
}
function State$1(input, options2) {
  this.input = input;
  this.filename = options2["filename"] || null;
  this.schema = options2["schema"] || _default;
  this.onWarning = options2["onWarning"] || null;
  this.legacy = options2["legacy"] || false;
  this.json = options2["json"] || false;
  this.listener = options2["listener"] || null;
  this.implicitTypes = this.schema.compiledImplicit;
  this.typeMap = this.schema.compiledTypeMap;
  this.length = input.length;
  this.position = 0;
  this.line = 0;
  this.lineStart = 0;
  this.lineIndent = 0;
  this.firstTabInLine = -1;
  this.documents = [];
}
function generateError(state, message2) {
  var mark = {
    name: state.filename,
    buffer: state.input.slice(0, -1),
    // omit trailing \0
    position: state.position,
    line: state.line,
    column: state.position - state.lineStart
  };
  mark.snippet = snippet(mark);
  return new exception(message2, mark);
}
function throwError(state, message2) {
  throw generateError(state, message2);
}
function throwWarning(state, message2) {
  if (state.onWarning) {
    state.onWarning.call(null, generateError(state, message2));
  }
}
var directiveHandlers = {
  YAML: function handleYamlDirective(state, name, args) {
    var match, major, minor;
    if (state.version !== null) {
      throwError(state, "duplication of %YAML directive");
    }
    if (args.length !== 1) {
      throwError(state, "YAML directive accepts exactly one argument");
    }
    match = /^([0-9]+)\.([0-9]+)$/.exec(args[0]);
    if (match === null) {
      throwError(state, "ill-formed argument of the YAML directive");
    }
    major = parseInt(match[1], 10);
    minor = parseInt(match[2], 10);
    if (major !== 1) {
      throwError(state, "unacceptable YAML version of the document");
    }
    state.version = args[0];
    state.checkLineBreaks = minor < 2;
    if (minor !== 1 && minor !== 2) {
      throwWarning(state, "unsupported YAML version of the document");
    }
  },
  TAG: function handleTagDirective(state, name, args) {
    var handle, prefix;
    if (args.length !== 2) {
      throwError(state, "TAG directive accepts exactly two arguments");
    }
    handle = args[0];
    prefix = args[1];
    if (!PATTERN_TAG_HANDLE.test(handle)) {
      throwError(state, "ill-formed tag handle (first argument) of the TAG directive");
    }
    if (_hasOwnProperty$1.call(state.tagMap, handle)) {
      throwError(state, 'there is a previously declared suffix for "' + handle + '" tag handle');
    }
    if (!PATTERN_TAG_URI.test(prefix)) {
      throwError(state, "ill-formed tag prefix (second argument) of the TAG directive");
    }
    try {
      prefix = decodeURIComponent(prefix);
    } catch (err) {
      throwError(state, "tag prefix is malformed: " + prefix);
    }
    state.tagMap[handle] = prefix;
  }
};
function captureSegment(state, start2, end2, checkJson) {
  var _position, _length, _character, _result;
  if (start2 < end2) {
    _result = state.input.slice(start2, end2);
    if (checkJson) {
      for (_position = 0, _length = _result.length; _position < _length; _position += 1) {
        _character = _result.charCodeAt(_position);
        if (!(_character === 9 || 32 <= _character && _character <= 1114111)) {
          throwError(state, "expected valid JSON character");
        }
      }
    } else if (PATTERN_NON_PRINTABLE.test(_result)) {
      throwError(state, "the stream contains non-printable characters");
    }
    state.result += _result;
  }
}
function mergeMappings(state, destination, source, overridableKeys) {
  var sourceKeys, key, index, quantity;
  if (!common.isObject(source)) {
    throwError(state, "cannot merge mappings; the provided source object is unacceptable");
  }
  sourceKeys = Object.keys(source);
  for (index = 0, quantity = sourceKeys.length; index < quantity; index += 1) {
    key = sourceKeys[index];
    if (!_hasOwnProperty$1.call(destination, key)) {
      destination[key] = source[key];
      overridableKeys[key] = true;
    }
  }
}
function storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, startLine, startLineStart, startPos) {
  var index, quantity;
  if (Array.isArray(keyNode)) {
    keyNode = Array.prototype.slice.call(keyNode);
    for (index = 0, quantity = keyNode.length; index < quantity; index += 1) {
      if (Array.isArray(keyNode[index])) {
        throwError(state, "nested arrays are not supported inside keys");
      }
      if (typeof keyNode === "object" && _class(keyNode[index]) === "[object Object]") {
        keyNode[index] = "[object Object]";
      }
    }
  }
  if (typeof keyNode === "object" && _class(keyNode) === "[object Object]") {
    keyNode = "[object Object]";
  }
  keyNode = String(keyNode);
  if (_result === null) {
    _result = {};
  }
  if (keyTag === "tag:yaml.org,2002:merge") {
    if (Array.isArray(valueNode)) {
      for (index = 0, quantity = valueNode.length; index < quantity; index += 1) {
        mergeMappings(state, _result, valueNode[index], overridableKeys);
      }
    } else {
      mergeMappings(state, _result, valueNode, overridableKeys);
    }
  } else {
    if (!state.json && !_hasOwnProperty$1.call(overridableKeys, keyNode) && _hasOwnProperty$1.call(_result, keyNode)) {
      state.line = startLine || state.line;
      state.lineStart = startLineStart || state.lineStart;
      state.position = startPos || state.position;
      throwError(state, "duplicated mapping key");
    }
    if (keyNode === "__proto__") {
      Object.defineProperty(_result, keyNode, {
        configurable: true,
        enumerable: true,
        writable: true,
        value: valueNode
      });
    } else {
      _result[keyNode] = valueNode;
    }
    delete overridableKeys[keyNode];
  }
  return _result;
}
function readLineBreak(state) {
  var ch;
  ch = state.input.charCodeAt(state.position);
  if (ch === 10) {
    state.position++;
  } else if (ch === 13) {
    state.position++;
    if (state.input.charCodeAt(state.position) === 10) {
      state.position++;
    }
  } else {
    throwError(state, "a line break is expected");
  }
  state.line += 1;
  state.lineStart = state.position;
  state.firstTabInLine = -1;
}
function skipSeparationSpace(state, allowComments, checkIndent) {
  var lineBreaks = 0, ch = state.input.charCodeAt(state.position);
  while (ch !== 0) {
    while (is_WHITE_SPACE(ch)) {
      if (ch === 9 && state.firstTabInLine === -1) {
        state.firstTabInLine = state.position;
      }
      ch = state.input.charCodeAt(++state.position);
    }
    if (allowComments && ch === 35) {
      do {
        ch = state.input.charCodeAt(++state.position);
      } while (ch !== 10 && ch !== 13 && ch !== 0);
    }
    if (is_EOL(ch)) {
      readLineBreak(state);
      ch = state.input.charCodeAt(state.position);
      lineBreaks++;
      state.lineIndent = 0;
      while (ch === 32) {
        state.lineIndent++;
        ch = state.input.charCodeAt(++state.position);
      }
    } else {
      break;
    }
  }
  if (checkIndent !== -1 && lineBreaks !== 0 && state.lineIndent < checkIndent) {
    throwWarning(state, "deficient indentation");
  }
  return lineBreaks;
}
function testDocumentSeparator(state) {
  var _position = state.position, ch;
  ch = state.input.charCodeAt(_position);
  if ((ch === 45 || ch === 46) && ch === state.input.charCodeAt(_position + 1) && ch === state.input.charCodeAt(_position + 2)) {
    _position += 3;
    ch = state.input.charCodeAt(_position);
    if (ch === 0 || is_WS_OR_EOL(ch)) {
      return true;
    }
  }
  return false;
}
function writeFoldedLines(state, count) {
  if (count === 1) {
    state.result += " ";
  } else if (count > 1) {
    state.result += common.repeat("\n", count - 1);
  }
}
function readPlainScalar(state, nodeIndent, withinFlowCollection) {
  var preceding, following, captureStart, captureEnd, hasPendingContent, _line, _lineStart, _lineIndent, _kind = state.kind, _result = state.result, ch;
  ch = state.input.charCodeAt(state.position);
  if (is_WS_OR_EOL(ch) || is_FLOW_INDICATOR(ch) || ch === 35 || ch === 38 || ch === 42 || ch === 33 || ch === 124 || ch === 62 || ch === 39 || ch === 34 || ch === 37 || ch === 64 || ch === 96) {
    return false;
  }
  if (ch === 63 || ch === 45) {
    following = state.input.charCodeAt(state.position + 1);
    if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
      return false;
    }
  }
  state.kind = "scalar";
  state.result = "";
  captureStart = captureEnd = state.position;
  hasPendingContent = false;
  while (ch !== 0) {
    if (ch === 58) {
      following = state.input.charCodeAt(state.position + 1);
      if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
        break;
      }
    } else if (ch === 35) {
      preceding = state.input.charCodeAt(state.position - 1);
      if (is_WS_OR_EOL(preceding)) {
        break;
      }
    } else if (state.position === state.lineStart && testDocumentSeparator(state) || withinFlowCollection && is_FLOW_INDICATOR(ch)) {
      break;
    } else if (is_EOL(ch)) {
      _line = state.line;
      _lineStart = state.lineStart;
      _lineIndent = state.lineIndent;
      skipSeparationSpace(state, false, -1);
      if (state.lineIndent >= nodeIndent) {
        hasPendingContent = true;
        ch = state.input.charCodeAt(state.position);
        continue;
      } else {
        state.position = captureEnd;
        state.line = _line;
        state.lineStart = _lineStart;
        state.lineIndent = _lineIndent;
        break;
      }
    }
    if (hasPendingContent) {
      captureSegment(state, captureStart, captureEnd, false);
      writeFoldedLines(state, state.line - _line);
      captureStart = captureEnd = state.position;
      hasPendingContent = false;
    }
    if (!is_WHITE_SPACE(ch)) {
      captureEnd = state.position + 1;
    }
    ch = state.input.charCodeAt(++state.position);
  }
  captureSegment(state, captureStart, captureEnd, false);
  if (state.result) {
    return true;
  }
  state.kind = _kind;
  state.result = _result;
  return false;
}
function readSingleQuotedScalar(state, nodeIndent) {
  var ch, captureStart, captureEnd;
  ch = state.input.charCodeAt(state.position);
  if (ch !== 39) {
    return false;
  }
  state.kind = "scalar";
  state.result = "";
  state.position++;
  captureStart = captureEnd = state.position;
  while ((ch = state.input.charCodeAt(state.position)) !== 0) {
    if (ch === 39) {
      captureSegment(state, captureStart, state.position, true);
      ch = state.input.charCodeAt(++state.position);
      if (ch === 39) {
        captureStart = state.position;
        state.position++;
        captureEnd = state.position;
      } else {
        return true;
      }
    } else if (is_EOL(ch)) {
      captureSegment(state, captureStart, captureEnd, true);
      writeFoldedLines(state, skipSeparationSpace(state, false, nodeIndent));
      captureStart = captureEnd = state.position;
    } else if (state.position === state.lineStart && testDocumentSeparator(state)) {
      throwError(state, "unexpected end of the document within a single quoted scalar");
    } else {
      state.position++;
      captureEnd = state.position;
    }
  }
  throwError(state, "unexpected end of the stream within a single quoted scalar");
}
function readDoubleQuotedScalar(state, nodeIndent) {
  var captureStart, captureEnd, hexLength, hexResult, tmp, ch;
  ch = state.input.charCodeAt(state.position);
  if (ch !== 34) {
    return false;
  }
  state.kind = "scalar";
  state.result = "";
  state.position++;
  captureStart = captureEnd = state.position;
  while ((ch = state.input.charCodeAt(state.position)) !== 0) {
    if (ch === 34) {
      captureSegment(state, captureStart, state.position, true);
      state.position++;
      return true;
    } else if (ch === 92) {
      captureSegment(state, captureStart, state.position, true);
      ch = state.input.charCodeAt(++state.position);
      if (is_EOL(ch)) {
        skipSeparationSpace(state, false, nodeIndent);
      } else if (ch < 256 && simpleEscapeCheck[ch]) {
        state.result += simpleEscapeMap[ch];
        state.position++;
      } else if ((tmp = escapedHexLen(ch)) > 0) {
        hexLength = tmp;
        hexResult = 0;
        for (; hexLength > 0; hexLength--) {
          ch = state.input.charCodeAt(++state.position);
          if ((tmp = fromHexCode(ch)) >= 0) {
            hexResult = (hexResult << 4) + tmp;
          } else {
            throwError(state, "expected hexadecimal character");
          }
        }
        state.result += charFromCodepoint(hexResult);
        state.position++;
      } else {
        throwError(state, "unknown escape sequence");
      }
      captureStart = captureEnd = state.position;
    } else if (is_EOL(ch)) {
      captureSegment(state, captureStart, captureEnd, true);
      writeFoldedLines(state, skipSeparationSpace(state, false, nodeIndent));
      captureStart = captureEnd = state.position;
    } else if (state.position === state.lineStart && testDocumentSeparator(state)) {
      throwError(state, "unexpected end of the document within a double quoted scalar");
    } else {
      state.position++;
      captureEnd = state.position;
    }
  }
  throwError(state, "unexpected end of the stream within a double quoted scalar");
}
function readFlowCollection(state, nodeIndent) {
  var readNext = true, _line, _lineStart, _pos, _tag = state.tag, _result, _anchor = state.anchor, following, terminator, isPair, isExplicitPair, isMapping, overridableKeys = /* @__PURE__ */ Object.create(null), keyNode, keyTag, valueNode, ch;
  ch = state.input.charCodeAt(state.position);
  if (ch === 91) {
    terminator = 93;
    isMapping = false;
    _result = [];
  } else if (ch === 123) {
    terminator = 125;
    isMapping = true;
    _result = {};
  } else {
    return false;
  }
  if (state.anchor !== null) {
    state.anchorMap[state.anchor] = _result;
  }
  ch = state.input.charCodeAt(++state.position);
  while (ch !== 0) {
    skipSeparationSpace(state, true, nodeIndent);
    ch = state.input.charCodeAt(state.position);
    if (ch === terminator) {
      state.position++;
      state.tag = _tag;
      state.anchor = _anchor;
      state.kind = isMapping ? "mapping" : "sequence";
      state.result = _result;
      return true;
    } else if (!readNext) {
      throwError(state, "missed comma between flow collection entries");
    } else if (ch === 44) {
      throwError(state, "expected the node content, but found ','");
    }
    keyTag = keyNode = valueNode = null;
    isPair = isExplicitPair = false;
    if (ch === 63) {
      following = state.input.charCodeAt(state.position + 1);
      if (is_WS_OR_EOL(following)) {
        isPair = isExplicitPair = true;
        state.position++;
        skipSeparationSpace(state, true, nodeIndent);
      }
    }
    _line = state.line;
    _lineStart = state.lineStart;
    _pos = state.position;
    composeNode(state, nodeIndent, CONTEXT_FLOW_IN, false, true);
    keyTag = state.tag;
    keyNode = state.result;
    skipSeparationSpace(state, true, nodeIndent);
    ch = state.input.charCodeAt(state.position);
    if ((isExplicitPair || state.line === _line) && ch === 58) {
      isPair = true;
      ch = state.input.charCodeAt(++state.position);
      skipSeparationSpace(state, true, nodeIndent);
      composeNode(state, nodeIndent, CONTEXT_FLOW_IN, false, true);
      valueNode = state.result;
    }
    if (isMapping) {
      storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos);
    } else if (isPair) {
      _result.push(storeMappingPair(state, null, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos));
    } else {
      _result.push(keyNode);
    }
    skipSeparationSpace(state, true, nodeIndent);
    ch = state.input.charCodeAt(state.position);
    if (ch === 44) {
      readNext = true;
      ch = state.input.charCodeAt(++state.position);
    } else {
      readNext = false;
    }
  }
  throwError(state, "unexpected end of the stream within a flow collection");
}
function readBlockScalar(state, nodeIndent) {
  var captureStart, folding, chomping = CHOMPING_CLIP, didReadContent = false, detectedIndent = false, textIndent = nodeIndent, emptyLines = 0, atMoreIndented = false, tmp, ch;
  ch = state.input.charCodeAt(state.position);
  if (ch === 124) {
    folding = false;
  } else if (ch === 62) {
    folding = true;
  } else {
    return false;
  }
  state.kind = "scalar";
  state.result = "";
  while (ch !== 0) {
    ch = state.input.charCodeAt(++state.position);
    if (ch === 43 || ch === 45) {
      if (CHOMPING_CLIP === chomping) {
        chomping = ch === 43 ? CHOMPING_KEEP : CHOMPING_STRIP;
      } else {
        throwError(state, "repeat of a chomping mode identifier");
      }
    } else if ((tmp = fromDecimalCode(ch)) >= 0) {
      if (tmp === 0) {
        throwError(state, "bad explicit indentation width of a block scalar; it cannot be less than one");
      } else if (!detectedIndent) {
        textIndent = nodeIndent + tmp - 1;
        detectedIndent = true;
      } else {
        throwError(state, "repeat of an indentation width identifier");
      }
    } else {
      break;
    }
  }
  if (is_WHITE_SPACE(ch)) {
    do {
      ch = state.input.charCodeAt(++state.position);
    } while (is_WHITE_SPACE(ch));
    if (ch === 35) {
      do {
        ch = state.input.charCodeAt(++state.position);
      } while (!is_EOL(ch) && ch !== 0);
    }
  }
  while (ch !== 0) {
    readLineBreak(state);
    state.lineIndent = 0;
    ch = state.input.charCodeAt(state.position);
    while ((!detectedIndent || state.lineIndent < textIndent) && ch === 32) {
      state.lineIndent++;
      ch = state.input.charCodeAt(++state.position);
    }
    if (!detectedIndent && state.lineIndent > textIndent) {
      textIndent = state.lineIndent;
    }
    if (is_EOL(ch)) {
      emptyLines++;
      continue;
    }
    if (state.lineIndent < textIndent) {
      if (chomping === CHOMPING_KEEP) {
        state.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
      } else if (chomping === CHOMPING_CLIP) {
        if (didReadContent) {
          state.result += "\n";
        }
      }
      break;
    }
    if (folding) {
      if (is_WHITE_SPACE(ch)) {
        atMoreIndented = true;
        state.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
      } else if (atMoreIndented) {
        atMoreIndented = false;
        state.result += common.repeat("\n", emptyLines + 1);
      } else if (emptyLines === 0) {
        if (didReadContent) {
          state.result += " ";
        }
      } else {
        state.result += common.repeat("\n", emptyLines);
      }
    } else {
      state.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
    }
    didReadContent = true;
    detectedIndent = true;
    emptyLines = 0;
    captureStart = state.position;
    while (!is_EOL(ch) && ch !== 0) {
      ch = state.input.charCodeAt(++state.position);
    }
    captureSegment(state, captureStart, state.position, false);
  }
  return true;
}
function readBlockSequence(state, nodeIndent) {
  var _line, _tag = state.tag, _anchor = state.anchor, _result = [], following, detected = false, ch;
  if (state.firstTabInLine !== -1)
    return false;
  if (state.anchor !== null) {
    state.anchorMap[state.anchor] = _result;
  }
  ch = state.input.charCodeAt(state.position);
  while (ch !== 0) {
    if (state.firstTabInLine !== -1) {
      state.position = state.firstTabInLine;
      throwError(state, "tab characters must not be used in indentation");
    }
    if (ch !== 45) {
      break;
    }
    following = state.input.charCodeAt(state.position + 1);
    if (!is_WS_OR_EOL(following)) {
      break;
    }
    detected = true;
    state.position++;
    if (skipSeparationSpace(state, true, -1)) {
      if (state.lineIndent <= nodeIndent) {
        _result.push(null);
        ch = state.input.charCodeAt(state.position);
        continue;
      }
    }
    _line = state.line;
    composeNode(state, nodeIndent, CONTEXT_BLOCK_IN, false, true);
    _result.push(state.result);
    skipSeparationSpace(state, true, -1);
    ch = state.input.charCodeAt(state.position);
    if ((state.line === _line || state.lineIndent > nodeIndent) && ch !== 0) {
      throwError(state, "bad indentation of a sequence entry");
    } else if (state.lineIndent < nodeIndent) {
      break;
    }
  }
  if (detected) {
    state.tag = _tag;
    state.anchor = _anchor;
    state.kind = "sequence";
    state.result = _result;
    return true;
  }
  return false;
}
function readBlockMapping(state, nodeIndent, flowIndent) {
  var following, allowCompact, _line, _keyLine, _keyLineStart, _keyPos, _tag = state.tag, _anchor = state.anchor, _result = {}, overridableKeys = /* @__PURE__ */ Object.create(null), keyTag = null, keyNode = null, valueNode = null, atExplicitKey = false, detected = false, ch;
  if (state.firstTabInLine !== -1)
    return false;
  if (state.anchor !== null) {
    state.anchorMap[state.anchor] = _result;
  }
  ch = state.input.charCodeAt(state.position);
  while (ch !== 0) {
    if (!atExplicitKey && state.firstTabInLine !== -1) {
      state.position = state.firstTabInLine;
      throwError(state, "tab characters must not be used in indentation");
    }
    following = state.input.charCodeAt(state.position + 1);
    _line = state.line;
    if ((ch === 63 || ch === 58) && is_WS_OR_EOL(following)) {
      if (ch === 63) {
        if (atExplicitKey) {
          storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
          keyTag = keyNode = valueNode = null;
        }
        detected = true;
        atExplicitKey = true;
        allowCompact = true;
      } else if (atExplicitKey) {
        atExplicitKey = false;
        allowCompact = true;
      } else {
        throwError(state, "incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line");
      }
      state.position += 1;
      ch = following;
    } else {
      _keyLine = state.line;
      _keyLineStart = state.lineStart;
      _keyPos = state.position;
      if (!composeNode(state, flowIndent, CONTEXT_FLOW_OUT, false, true)) {
        break;
      }
      if (state.line === _line) {
        ch = state.input.charCodeAt(state.position);
        while (is_WHITE_SPACE(ch)) {
          ch = state.input.charCodeAt(++state.position);
        }
        if (ch === 58) {
          ch = state.input.charCodeAt(++state.position);
          if (!is_WS_OR_EOL(ch)) {
            throwError(state, "a whitespace character is expected after the key-value separator within a block mapping");
          }
          if (atExplicitKey) {
            storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
            keyTag = keyNode = valueNode = null;
          }
          detected = true;
          atExplicitKey = false;
          allowCompact = false;
          keyTag = state.tag;
          keyNode = state.result;
        } else if (detected) {
          throwError(state, "can not read an implicit mapping pair; a colon is missed");
        } else {
          state.tag = _tag;
          state.anchor = _anchor;
          return true;
        }
      } else if (detected) {
        throwError(state, "can not read a block mapping entry; a multiline key may not be an implicit key");
      } else {
        state.tag = _tag;
        state.anchor = _anchor;
        return true;
      }
    }
    if (state.line === _line || state.lineIndent > nodeIndent) {
      if (atExplicitKey) {
        _keyLine = state.line;
        _keyLineStart = state.lineStart;
        _keyPos = state.position;
      }
      if (composeNode(state, nodeIndent, CONTEXT_BLOCK_OUT, true, allowCompact)) {
        if (atExplicitKey) {
          keyNode = state.result;
        } else {
          valueNode = state.result;
        }
      }
      if (!atExplicitKey) {
        storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, _keyLine, _keyLineStart, _keyPos);
        keyTag = keyNode = valueNode = null;
      }
      skipSeparationSpace(state, true, -1);
      ch = state.input.charCodeAt(state.position);
    }
    if ((state.line === _line || state.lineIndent > nodeIndent) && ch !== 0) {
      throwError(state, "bad indentation of a mapping entry");
    } else if (state.lineIndent < nodeIndent) {
      break;
    }
  }
  if (atExplicitKey) {
    storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
  }
  if (detected) {
    state.tag = _tag;
    state.anchor = _anchor;
    state.kind = "mapping";
    state.result = _result;
  }
  return detected;
}
function readTagProperty(state) {
  var _position, isVerbatim = false, isNamed = false, tagHandle, tagName, ch;
  ch = state.input.charCodeAt(state.position);
  if (ch !== 33)
    return false;
  if (state.tag !== null) {
    throwError(state, "duplication of a tag property");
  }
  ch = state.input.charCodeAt(++state.position);
  if (ch === 60) {
    isVerbatim = true;
    ch = state.input.charCodeAt(++state.position);
  } else if (ch === 33) {
    isNamed = true;
    tagHandle = "!!";
    ch = state.input.charCodeAt(++state.position);
  } else {
    tagHandle = "!";
  }
  _position = state.position;
  if (isVerbatim) {
    do {
      ch = state.input.charCodeAt(++state.position);
    } while (ch !== 0 && ch !== 62);
    if (state.position < state.length) {
      tagName = state.input.slice(_position, state.position);
      ch = state.input.charCodeAt(++state.position);
    } else {
      throwError(state, "unexpected end of the stream within a verbatim tag");
    }
  } else {
    while (ch !== 0 && !is_WS_OR_EOL(ch)) {
      if (ch === 33) {
        if (!isNamed) {
          tagHandle = state.input.slice(_position - 1, state.position + 1);
          if (!PATTERN_TAG_HANDLE.test(tagHandle)) {
            throwError(state, "named tag handle cannot contain such characters");
          }
          isNamed = true;
          _position = state.position + 1;
        } else {
          throwError(state, "tag suffix cannot contain exclamation marks");
        }
      }
      ch = state.input.charCodeAt(++state.position);
    }
    tagName = state.input.slice(_position, state.position);
    if (PATTERN_FLOW_INDICATORS.test(tagName)) {
      throwError(state, "tag suffix cannot contain flow indicator characters");
    }
  }
  if (tagName && !PATTERN_TAG_URI.test(tagName)) {
    throwError(state, "tag name cannot contain such characters: " + tagName);
  }
  try {
    tagName = decodeURIComponent(tagName);
  } catch (err) {
    throwError(state, "tag name is malformed: " + tagName);
  }
  if (isVerbatim) {
    state.tag = tagName;
  } else if (_hasOwnProperty$1.call(state.tagMap, tagHandle)) {
    state.tag = state.tagMap[tagHandle] + tagName;
  } else if (tagHandle === "!") {
    state.tag = "!" + tagName;
  } else if (tagHandle === "!!") {
    state.tag = "tag:yaml.org,2002:" + tagName;
  } else {
    throwError(state, 'undeclared tag handle "' + tagHandle + '"');
  }
  return true;
}
function readAnchorProperty(state) {
  var _position, ch;
  ch = state.input.charCodeAt(state.position);
  if (ch !== 38)
    return false;
  if (state.anchor !== null) {
    throwError(state, "duplication of an anchor property");
  }
  ch = state.input.charCodeAt(++state.position);
  _position = state.position;
  while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
    ch = state.input.charCodeAt(++state.position);
  }
  if (state.position === _position) {
    throwError(state, "name of an anchor node must contain at least one character");
  }
  state.anchor = state.input.slice(_position, state.position);
  return true;
}
function readAlias(state) {
  var _position, alias, ch;
  ch = state.input.charCodeAt(state.position);
  if (ch !== 42)
    return false;
  ch = state.input.charCodeAt(++state.position);
  _position = state.position;
  while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
    ch = state.input.charCodeAt(++state.position);
  }
  if (state.position === _position) {
    throwError(state, "name of an alias node must contain at least one character");
  }
  alias = state.input.slice(_position, state.position);
  if (!_hasOwnProperty$1.call(state.anchorMap, alias)) {
    throwError(state, 'unidentified alias "' + alias + '"');
  }
  state.result = state.anchorMap[alias];
  skipSeparationSpace(state, true, -1);
  return true;
}
function composeNode(state, parentIndent, nodeContext, allowToSeek, allowCompact) {
  var allowBlockStyles, allowBlockScalars, allowBlockCollections, indentStatus = 1, atNewLine = false, hasContent = false, typeIndex, typeQuantity, typeList, type2, flowIndent, blockIndent;
  if (state.listener !== null) {
    state.listener("open", state);
  }
  state.tag = null;
  state.anchor = null;
  state.kind = null;
  state.result = null;
  allowBlockStyles = allowBlockScalars = allowBlockCollections = CONTEXT_BLOCK_OUT === nodeContext || CONTEXT_BLOCK_IN === nodeContext;
  if (allowToSeek) {
    if (skipSeparationSpace(state, true, -1)) {
      atNewLine = true;
      if (state.lineIndent > parentIndent) {
        indentStatus = 1;
      } else if (state.lineIndent === parentIndent) {
        indentStatus = 0;
      } else if (state.lineIndent < parentIndent) {
        indentStatus = -1;
      }
    }
  }
  if (indentStatus === 1) {
    while (readTagProperty(state) || readAnchorProperty(state)) {
      if (skipSeparationSpace(state, true, -1)) {
        atNewLine = true;
        allowBlockCollections = allowBlockStyles;
        if (state.lineIndent > parentIndent) {
          indentStatus = 1;
        } else if (state.lineIndent === parentIndent) {
          indentStatus = 0;
        } else if (state.lineIndent < parentIndent) {
          indentStatus = -1;
        }
      } else {
        allowBlockCollections = false;
      }
    }
  }
  if (allowBlockCollections) {
    allowBlockCollections = atNewLine || allowCompact;
  }
  if (indentStatus === 1 || CONTEXT_BLOCK_OUT === nodeContext) {
    if (CONTEXT_FLOW_IN === nodeContext || CONTEXT_FLOW_OUT === nodeContext) {
      flowIndent = parentIndent;
    } else {
      flowIndent = parentIndent + 1;
    }
    blockIndent = state.position - state.lineStart;
    if (indentStatus === 1) {
      if (allowBlockCollections && (readBlockSequence(state, blockIndent) || readBlockMapping(state, blockIndent, flowIndent)) || readFlowCollection(state, flowIndent)) {
        hasContent = true;
      } else {
        if (allowBlockScalars && readBlockScalar(state, flowIndent) || readSingleQuotedScalar(state, flowIndent) || readDoubleQuotedScalar(state, flowIndent)) {
          hasContent = true;
        } else if (readAlias(state)) {
          hasContent = true;
          if (state.tag !== null || state.anchor !== null) {
            throwError(state, "alias node should not have any properties");
          }
        } else if (readPlainScalar(state, flowIndent, CONTEXT_FLOW_IN === nodeContext)) {
          hasContent = true;
          if (state.tag === null) {
            state.tag = "?";
          }
        }
        if (state.anchor !== null) {
          state.anchorMap[state.anchor] = state.result;
        }
      }
    } else if (indentStatus === 0) {
      hasContent = allowBlockCollections && readBlockSequence(state, blockIndent);
    }
  }
  if (state.tag === null) {
    if (state.anchor !== null) {
      state.anchorMap[state.anchor] = state.result;
    }
  } else if (state.tag === "?") {
    if (state.result !== null && state.kind !== "scalar") {
      throwError(state, 'unacceptable node kind for !<?> tag; it should be "scalar", not "' + state.kind + '"');
    }
    for (typeIndex = 0, typeQuantity = state.implicitTypes.length; typeIndex < typeQuantity; typeIndex += 1) {
      type2 = state.implicitTypes[typeIndex];
      if (type2.resolve(state.result)) {
        state.result = type2.construct(state.result);
        state.tag = type2.tag;
        if (state.anchor !== null) {
          state.anchorMap[state.anchor] = state.result;
        }
        break;
      }
    }
  } else if (state.tag !== "!") {
    if (_hasOwnProperty$1.call(state.typeMap[state.kind || "fallback"], state.tag)) {
      type2 = state.typeMap[state.kind || "fallback"][state.tag];
    } else {
      type2 = null;
      typeList = state.typeMap.multi[state.kind || "fallback"];
      for (typeIndex = 0, typeQuantity = typeList.length; typeIndex < typeQuantity; typeIndex += 1) {
        if (state.tag.slice(0, typeList[typeIndex].tag.length) === typeList[typeIndex].tag) {
          type2 = typeList[typeIndex];
          break;
        }
      }
    }
    if (!type2) {
      throwError(state, "unknown tag !<" + state.tag + ">");
    }
    if (state.result !== null && type2.kind !== state.kind) {
      throwError(state, "unacceptable node kind for !<" + state.tag + '> tag; it should be "' + type2.kind + '", not "' + state.kind + '"');
    }
    if (!type2.resolve(state.result, state.tag)) {
      throwError(state, "cannot resolve a node with !<" + state.tag + "> explicit tag");
    } else {
      state.result = type2.construct(state.result, state.tag);
      if (state.anchor !== null) {
        state.anchorMap[state.anchor] = state.result;
      }
    }
  }
  if (state.listener !== null) {
    state.listener("close", state);
  }
  return state.tag !== null || state.anchor !== null || hasContent;
}
function readDocument(state) {
  var documentStart = state.position, _position, directiveName, directiveArgs, hasDirectives = false, ch;
  state.version = null;
  state.checkLineBreaks = state.legacy;
  state.tagMap = /* @__PURE__ */ Object.create(null);
  state.anchorMap = /* @__PURE__ */ Object.create(null);
  while ((ch = state.input.charCodeAt(state.position)) !== 0) {
    skipSeparationSpace(state, true, -1);
    ch = state.input.charCodeAt(state.position);
    if (state.lineIndent > 0 || ch !== 37) {
      break;
    }
    hasDirectives = true;
    ch = state.input.charCodeAt(++state.position);
    _position = state.position;
    while (ch !== 0 && !is_WS_OR_EOL(ch)) {
      ch = state.input.charCodeAt(++state.position);
    }
    directiveName = state.input.slice(_position, state.position);
    directiveArgs = [];
    if (directiveName.length < 1) {
      throwError(state, "directive name must not be less than one character in length");
    }
    while (ch !== 0) {
      while (is_WHITE_SPACE(ch)) {
        ch = state.input.charCodeAt(++state.position);
      }
      if (ch === 35) {
        do {
          ch = state.input.charCodeAt(++state.position);
        } while (ch !== 0 && !is_EOL(ch));
        break;
      }
      if (is_EOL(ch))
        break;
      _position = state.position;
      while (ch !== 0 && !is_WS_OR_EOL(ch)) {
        ch = state.input.charCodeAt(++state.position);
      }
      directiveArgs.push(state.input.slice(_position, state.position));
    }
    if (ch !== 0)
      readLineBreak(state);
    if (_hasOwnProperty$1.call(directiveHandlers, directiveName)) {
      directiveHandlers[directiveName](state, directiveName, directiveArgs);
    } else {
      throwWarning(state, 'unknown document directive "' + directiveName + '"');
    }
  }
  skipSeparationSpace(state, true, -1);
  if (state.lineIndent === 0 && state.input.charCodeAt(state.position) === 45 && state.input.charCodeAt(state.position + 1) === 45 && state.input.charCodeAt(state.position + 2) === 45) {
    state.position += 3;
    skipSeparationSpace(state, true, -1);
  } else if (hasDirectives) {
    throwError(state, "directives end mark is expected");
  }
  composeNode(state, state.lineIndent - 1, CONTEXT_BLOCK_OUT, false, true);
  skipSeparationSpace(state, true, -1);
  if (state.checkLineBreaks && PATTERN_NON_ASCII_LINE_BREAKS.test(state.input.slice(documentStart, state.position))) {
    throwWarning(state, "non-ASCII line breaks are interpreted as content");
  }
  state.documents.push(state.result);
  if (state.position === state.lineStart && testDocumentSeparator(state)) {
    if (state.input.charCodeAt(state.position) === 46) {
      state.position += 3;
      skipSeparationSpace(state, true, -1);
    }
    return;
  }
  if (state.position < state.length - 1) {
    throwError(state, "end of the stream or a document separator is expected");
  } else {
    return;
  }
}
function loadDocuments(input, options2) {
  input = String(input);
  options2 = options2 || {};
  if (input.length !== 0) {
    if (input.charCodeAt(input.length - 1) !== 10 && input.charCodeAt(input.length - 1) !== 13) {
      input += "\n";
    }
    if (input.charCodeAt(0) === 65279) {
      input = input.slice(1);
    }
  }
  var state = new State$1(input, options2);
  var nullpos = input.indexOf("\0");
  if (nullpos !== -1) {
    state.position = nullpos;
    throwError(state, "null byte is not allowed in input");
  }
  state.input += "\0";
  while (state.input.charCodeAt(state.position) === 32) {
    state.lineIndent += 1;
    state.position += 1;
  }
  while (state.position < state.length - 1) {
    readDocument(state);
  }
  return state.documents;
}
function loadAll$1(input, iterator2, options2) {
  if (iterator2 !== null && typeof iterator2 === "object" && typeof options2 === "undefined") {
    options2 = iterator2;
    iterator2 = null;
  }
  var documents2 = loadDocuments(input, options2);
  if (typeof iterator2 !== "function") {
    return documents2;
  }
  for (var index = 0, length = documents2.length; index < length; index += 1) {
    iterator2(documents2[index]);
  }
}
function load$1(input, options2) {
  var documents2 = loadDocuments(input, options2);
  if (documents2.length === 0) {
    return void 0;
  } else if (documents2.length === 1) {
    return documents2[0];
  }
  throw new exception("expected a single document in the stream, but found more");
}
var loadAll_1 = loadAll$1;
var load_1 = load$1;
var loader$3 = {
  loadAll: loadAll_1,
  load: load_1
};
var FAILSAFE_SCHEMA = failsafe;
var load = loader$3.load;
const frontMatterRegex = /^-{3}\s*[\n\r](.*?)[\n\r]-{3}\s*[\n\r]+/s;
function extractFrontMatter(text, db2) {
  var _a;
  const matches = text.match(frontMatterRegex);
  if (matches) {
    const parsed = load(matches[1], {
      // To keep things simple, only allow strings, arrays, and plain objects.
      // https://www.yaml.org/spec/1.2/spec.html#id2802346
      schema: FAILSAFE_SCHEMA
    });
    if (parsed == null ? void 0 : parsed.title) {
      (_a = db2.setDiagramTitle) == null ? void 0 : _a.call(db2, parsed.title);
    }
    return text.slice(matches[0].length);
  } else {
    return text;
  }
}
const directive$1 = /%{2}{\s*(?:(\w+)\s*:|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
const anyComment = /\s*%%.*\n/gm;
const detectors = {};
const detectType = function(text, config2) {
  text = text.replace(frontMatterRegex, "").replace(directive$1, "").replace(anyComment, "\n");
  for (const [key, { detector: detector2 }] of Object.entries(detectors)) {
    const diagram = detector2(text, config2);
    if (diagram) {
      return key;
    }
  }
  throw new Error(`No diagram type detected for text: ${text}`);
};
const registerLazyLoadedDiagrams = (...diagrams2) => {
  for (const { id: id2, detector: detector2, loader: loader2 } of diagrams2) {
    addDetector(id2, detector2, loader2);
  }
};
const addDetector = (key, detector2, loader2) => {
  if (detectors[key]) {
    log$1.error(`Detector with key ${key} already exists`);
  } else {
    detectors[key] = { detector: detector2, loader: loader2 };
  }
  log$1.debug(`Detector with key ${key} added${loader2 ? " with loader" : ""}`);
};
const getDiagramLoader = (key) => detectors[key].loader;
const assignWithDepth = function(dst, src, config2) {
  const { depth, clobber } = Object.assign({ depth: 2, clobber: false }, config2);
  if (Array.isArray(src) && !Array.isArray(dst)) {
    src.forEach((s) => assignWithDepth(dst, s, config2));
    return dst;
  } else if (Array.isArray(src) && Array.isArray(dst)) {
    src.forEach((s) => {
      if (!dst.includes(s)) {
        dst.push(s);
      }
    });
    return dst;
  }
  if (dst === void 0 || depth <= 0) {
    if (dst !== void 0 && dst !== null && typeof dst === "object" && typeof src === "object") {
      return Object.assign(dst, src);
    } else {
      return src;
    }
  }
  if (src !== void 0 && typeof dst === "object" && typeof src === "object") {
    Object.keys(src).forEach((key) => {
      if (typeof src[key] === "object" && (dst[key] === void 0 || typeof dst[key] === "object")) {
        if (dst[key] === void 0) {
          dst[key] = Array.isArray(src[key]) ? [] : {};
        }
        dst[key] = assignWithDepth(dst[key], src[key], { depth: depth - 1, clobber });
      } else if (clobber || typeof dst[key] !== "object" && typeof src[key] !== "object") {
        dst[key] = src[key];
      }
    });
  }
  return dst;
};
const assignWithDepth$1 = assignWithDepth;
const d3CurveTypes = {
  curveBasis,
  curveBasisClosed,
  curveBasisOpen,
  curveBumpX,
  curveBumpY,
  curveBundle,
  curveCardinalClosed,
  curveCardinalOpen,
  curveCardinal,
  curveCatmullRomClosed,
  curveCatmullRomOpen,
  curveCatmullRom,
  curveLinear,
  curveLinearClosed,
  curveMonotoneX,
  curveMonotoneY,
  curveNatural,
  curveStep,
  curveStepAfter,
  curveStepBefore
};
const directive = /%{2}{\s*(?:(\w+)\s*:|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
const directiveWithoutOpen = /\s*(?:(\w+)(?=:):|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
const detectInit = function(text, config2) {
  const inits = detectDirective(text, /(?:init\b)|(?:initialize\b)/);
  let results = {};
  if (Array.isArray(inits)) {
    const args = inits.map((init2) => init2.args);
    directiveSanitizer(args);
    results = assignWithDepth$1(results, [...args]);
  } else {
    results = inits.args;
  }
  if (results) {
    let type2 = detectType(text, config2);
    ["config"].forEach((prop) => {
      if (results[prop] !== void 0) {
        if (type2 === "flowchart-v2") {
          type2 = "flowchart";
        }
        results[type2] = results[prop];
        delete results[prop];
      }
    });
  }
  return results;
};
const detectDirective = function(text, type2 = null) {
  try {
    const commentWithoutDirectives = new RegExp(
      `[%]{2}(?![{]${directiveWithoutOpen.source})(?=[}][%]{2}).*
`,
      "ig"
    );
    text = text.trim().replace(commentWithoutDirectives, "").replace(/'/gm, '"');
    log$1.debug(
      `Detecting diagram directive${type2 !== null ? " type:" + type2 : ""} based on the text:${text}`
    );
    let match;
    const result = [];
    while ((match = directive.exec(text)) !== null) {
      if (match.index === directive.lastIndex) {
        directive.lastIndex++;
      }
      if (match && !type2 || type2 && match[1] && match[1].match(type2) || type2 && match[2] && match[2].match(type2)) {
        const type22 = match[1] ? match[1] : match[2];
        const args = match[3] ? match[3].trim() : match[4] ? JSON.parse(match[4].trim()) : null;
        result.push({ type: type22, args });
      }
    }
    if (result.length === 0) {
      result.push({ type: text, args: null });
    }
    return result.length === 1 ? result[0] : result;
  } catch (error) {
    log$1.error(
      `ERROR: ${error.message} - Unable to parse directive
      ${type2 !== null ? " type:" + type2 : ""} based on the text:${text}`
    );
    return { type: null, args: null };
  }
};
const isSubstringInArray = function(str2, arr) {
  for (const [i, element] of arr.entries()) {
    if (element.match(str2)) {
      return i;
    }
  }
  return -1;
};
function interpolateToCurve(interpolate, defaultCurve) {
  if (!interpolate) {
    return defaultCurve;
  }
  const curveName = `curve${interpolate.charAt(0).toUpperCase() + interpolate.slice(1)}`;
  return d3CurveTypes[curveName] || defaultCurve;
}
function formatUrl(linkStr, config2) {
  const url = linkStr.trim();
  if (url) {
    if (config2.securityLevel !== "loose") {
      return sanitizeUrl(url);
    }
    return url;
  }
}
const runFunc = (functionName, ...params) => {
  const arrPaths = functionName.split(".");
  const len = arrPaths.length - 1;
  const fnName = arrPaths[len];
  let obj = window;
  for (let i = 0; i < len; i++) {
    obj = obj[arrPaths[i]];
    if (!obj) {
      return;
    }
  }
  obj[fnName](...params);
};
function distance(p1, p2) {
  return p1 && p2 ? Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2)) : 0;
}
function traverseEdge(points) {
  let prevPoint;
  let totalDistance = 0;
  points.forEach((point2) => {
    totalDistance += distance(point2, prevPoint);
    prevPoint = point2;
  });
  let remainingDistance = totalDistance / 2;
  let center = void 0;
  prevPoint = void 0;
  points.forEach((point2) => {
    if (prevPoint && !center) {
      const vectorDistance = distance(point2, prevPoint);
      if (vectorDistance < remainingDistance) {
        remainingDistance -= vectorDistance;
      } else {
        const distanceRatio = remainingDistance / vectorDistance;
        if (distanceRatio <= 0) {
          center = prevPoint;
        }
        if (distanceRatio >= 1) {
          center = { x: point2.x, y: point2.y };
        }
        if (distanceRatio > 0 && distanceRatio < 1) {
          center = {
            x: (1 - distanceRatio) * prevPoint.x + distanceRatio * point2.x,
            y: (1 - distanceRatio) * prevPoint.y + distanceRatio * point2.y
          };
        }
      }
    }
    prevPoint = point2;
  });
  return center;
}
function calcLabelPosition(points) {
  if (points.length === 1) {
    return points[0];
  }
  return traverseEdge(points);
}
const calcCardinalityPosition = (isRelationTypePresent, points, initialPosition) => {
  let prevPoint;
  log$1.info(`our points ${JSON.stringify(points)}`);
  if (points[0] !== initialPosition) {
    points = points.reverse();
  }
  const distanceToCardinalityPoint = 25;
  let remainingDistance = distanceToCardinalityPoint;
  let center;
  prevPoint = void 0;
  points.forEach((point2) => {
    if (prevPoint && !center) {
      const vectorDistance = distance(point2, prevPoint);
      if (vectorDistance < remainingDistance) {
        remainingDistance -= vectorDistance;
      } else {
        const distanceRatio = remainingDistance / vectorDistance;
        if (distanceRatio <= 0) {
          center = prevPoint;
        }
        if (distanceRatio >= 1) {
          center = { x: point2.x, y: point2.y };
        }
        if (distanceRatio > 0 && distanceRatio < 1) {
          center = {
            x: (1 - distanceRatio) * prevPoint.x + distanceRatio * point2.x,
            y: (1 - distanceRatio) * prevPoint.y + distanceRatio * point2.y
          };
        }
      }
    }
    prevPoint = point2;
  });
  const d = isRelationTypePresent ? 10 : 5;
  const angle = Math.atan2(points[0].y - center.y, points[0].x - center.x);
  const cardinalityPosition = { x: 0, y: 0 };
  cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center.x) / 2;
  cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center.y) / 2;
  return cardinalityPosition;
};
function calcTerminalLabelPosition(terminalMarkerSize, position, _points) {
  let points = JSON.parse(JSON.stringify(_points));
  let prevPoint;
  log$1.info("our points", points);
  if (position !== "start_left" && position !== "start_right") {
    points = points.reverse();
  }
  points.forEach((point2) => {
    prevPoint = point2;
  });
  const distanceToCardinalityPoint = 25 + terminalMarkerSize;
  let remainingDistance = distanceToCardinalityPoint;
  let center;
  prevPoint = void 0;
  points.forEach((point2) => {
    if (prevPoint && !center) {
      const vectorDistance = distance(point2, prevPoint);
      if (vectorDistance < remainingDistance) {
        remainingDistance -= vectorDistance;
      } else {
        const distanceRatio = remainingDistance / vectorDistance;
        if (distanceRatio <= 0) {
          center = prevPoint;
        }
        if (distanceRatio >= 1) {
          center = { x: point2.x, y: point2.y };
        }
        if (distanceRatio > 0 && distanceRatio < 1) {
          center = {
            x: (1 - distanceRatio) * prevPoint.x + distanceRatio * point2.x,
            y: (1 - distanceRatio) * prevPoint.y + distanceRatio * point2.y
          };
        }
      }
    }
    prevPoint = point2;
  });
  const d = 10 + terminalMarkerSize * 0.5;
  const angle = Math.atan2(points[0].y - center.y, points[0].x - center.x);
  const cardinalityPosition = { x: 0, y: 0 };
  cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center.x) / 2;
  cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center.y) / 2;
  if (position === "start_left") {
    cardinalityPosition.x = Math.sin(angle + Math.PI) * d + (points[0].x + center.x) / 2;
    cardinalityPosition.y = -Math.cos(angle + Math.PI) * d + (points[0].y + center.y) / 2;
  }
  if (position === "end_right") {
    cardinalityPosition.x = Math.sin(angle - Math.PI) * d + (points[0].x + center.x) / 2 - 5;
    cardinalityPosition.y = -Math.cos(angle - Math.PI) * d + (points[0].y + center.y) / 2 - 5;
  }
  if (position === "end_left") {
    cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center.x) / 2 - 5;
    cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center.y) / 2 - 5;
  }
  return cardinalityPosition;
}
function getStylesFromArray(arr) {
  let style = "";
  let labelStyle = "";
  for (const element of arr) {
    if (element !== void 0) {
      if (element.startsWith("color:") || element.startsWith("text-align:")) {
        labelStyle = labelStyle + element + ";";
      } else {
        style = style + element + ";";
      }
    }
  }
  return { style, labelStyle };
}
let cnt = 0;
const generateId$1 = () => {
  cnt++;
  return "id-" + Math.random().toString(36).substr(2, 12) + "-" + cnt;
};
function makeid(length) {
  let result = "";
  const characters = "0123456789abcdef";
  const charactersLength = characters.length;
  for (let i = 0; i < length; i++) {
    result += characters.charAt(Math.floor(Math.random() * charactersLength));
  }
  return result;
}
const random = (options2) => {
  return makeid(options2.length);
};
const getTextObj$2 = function() {
  return {
    x: 0,
    y: 0,
    fill: void 0,
    anchor: "start",
    style: "#666",
    width: 100,
    height: 100,
    textMargin: 0,
    rx: 0,
    ry: 0,
    valign: void 0
  };
};
const drawSimpleText = function(elem, textData) {
  const nText = textData.text.replace(common$1.lineBreakRegex, " ");
  const [, _fontSizePx] = parseFontSize(textData.fontSize);
  const textElem = elem.append("text");
  textElem.attr("x", textData.x);
  textElem.attr("y", textData.y);
  textElem.style("text-anchor", textData.anchor);
  textElem.style("font-family", textData.fontFamily);
  textElem.style("font-size", _fontSizePx);
  textElem.style("font-weight", textData.fontWeight);
  textElem.attr("fill", textData.fill);
  if (textData.class !== void 0) {
    textElem.attr("class", textData.class);
  }
  const span = textElem.append("tspan");
  span.attr("x", textData.x + textData.textMargin * 2);
  span.attr("fill", textData.fill);
  span.text(nText);
  return textElem;
};
const wrapLabel = memoize(
  (label, maxWidth, config2) => {
    if (!label) {
      return label;
    }
    config2 = Object.assign(
      { fontSize: 12, fontWeight: 400, fontFamily: "Arial", joinWith: "<br/>" },
      config2
    );
    if (common$1.lineBreakRegex.test(label)) {
      return label;
    }
    const words = label.split(" ");
    const completedLines = [];
    let nextLine = "";
    words.forEach((word, index) => {
      const wordLength = calculateTextWidth(`${word} `, config2);
      const nextLineLength = calculateTextWidth(nextLine, config2);
      if (wordLength > maxWidth) {
        const { hyphenatedStrings, remainingWord } = breakString(word, maxWidth, "-", config2);
        completedLines.push(nextLine, ...hyphenatedStrings);
        nextLine = remainingWord;
      } else if (nextLineLength + wordLength >= maxWidth) {
        completedLines.push(nextLine);
        nextLine = word;
      } else {
        nextLine = [nextLine, word].filter(Boolean).join(" ");
      }
      const currentWord = index + 1;
      const isLastWord = currentWord === words.length;
      if (isLastWord) {
        completedLines.push(nextLine);
      }
    });
    return completedLines.filter((line2) => line2 !== "").join(config2.joinWith);
  },
  (label, maxWidth, config2) => `${label}${maxWidth}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}${config2.joinWith}`
);
const breakString = memoize(
  (word, maxWidth, hyphenCharacter = "-", config2) => {
    config2 = Object.assign(
      { fontSize: 12, fontWeight: 400, fontFamily: "Arial", margin: 0 },
      config2
    );
    const characters = [...word];
    const lines = [];
    let currentLine = "";
    characters.forEach((character, index) => {
      const nextLine = `${currentLine}${character}`;
      const lineWidth = calculateTextWidth(nextLine, config2);
      if (lineWidth >= maxWidth) {
        const currentCharacter = index + 1;
        const isLastLine = characters.length === currentCharacter;
        const hyphenatedNextLine = `${nextLine}${hyphenCharacter}`;
        lines.push(isLastLine ? nextLine : hyphenatedNextLine);
        currentLine = "";
      } else {
        currentLine = nextLine;
      }
    });
    return { hyphenatedStrings: lines, remainingWord: currentLine };
  },
  (word, maxWidth, hyphenCharacter = "-", config2) => `${word}${maxWidth}${hyphenCharacter}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}`
);
function calculateTextHeight(text, config2) {
  config2 = Object.assign(
    { fontSize: 12, fontWeight: 400, fontFamily: "Arial", margin: 15 },
    config2
  );
  return calculateTextDimensions(text, config2).height;
}
function calculateTextWidth(text, config2) {
  config2 = Object.assign({ fontSize: 12, fontWeight: 400, fontFamily: "Arial" }, config2);
  return calculateTextDimensions(text, config2).width;
}
const calculateTextDimensions = memoize(
  (text, config2) => {
    config2 = Object.assign({ fontSize: 12, fontWeight: 400, fontFamily: "Arial" }, config2);
    const { fontSize, fontFamily, fontWeight } = config2;
    if (!text) {
      return { width: 0, height: 0 };
    }
    const [, _fontSizePx] = parseFontSize(fontSize);
    const fontFamilies = ["sans-serif", fontFamily];
    const lines = text.split(common$1.lineBreakRegex);
    const dims = [];
    const body = select("body");
    if (!body.remove) {
      return { width: 0, height: 0, lineHeight: 0 };
    }
    const g = body.append("svg");
    for (const fontFamily2 of fontFamilies) {
      let cheight = 0;
      const dim = { width: 0, height: 0, lineHeight: 0 };
      for (const line2 of lines) {
        const textObj = getTextObj$2();
        textObj.text = line2;
        const textElem = drawSimpleText(g, textObj).style("font-size", _fontSizePx).style("font-weight", fontWeight).style("font-family", fontFamily2);
        const bBox = (textElem._groups || textElem)[0][0].getBBox();
        dim.width = Math.round(Math.max(dim.width, bBox.width));
        cheight = Math.round(bBox.height);
        dim.height += cheight;
        dim.lineHeight = Math.round(Math.max(dim.lineHeight, cheight));
      }
      dims.push(dim);
    }
    g.remove();
    const index = isNaN(dims[1].height) || isNaN(dims[1].width) || isNaN(dims[1].lineHeight) || dims[0].height > dims[1].height && dims[0].width > dims[1].width && dims[0].lineHeight > dims[1].lineHeight ? 0 : 1;
    return dims[index];
  },
  (text, config2) => `${text}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}`
);
const initIdGenerator = class iterator {
  constructor(deterministic, seed) {
    this.deterministic = deterministic;
    this.seed = seed;
    this.count = seed ? seed.length : 0;
  }
  next() {
    if (!this.deterministic) {
      return Date.now();
    }
    return this.count++;
  }
};
let decoder;
const entityDecode = function(html) {
  decoder = decoder || document.createElement("div");
  html = escape(html).replace(/%26/g, "&").replace(/%23/g, "#").replace(/%3B/g, ";");
  decoder.innerHTML = html;
  return unescape(decoder.textContent);
};
const directiveSanitizer = (args) => {
  log$1.debug("directiveSanitizer called with", args);
  if (typeof args === "object") {
    if (args.length) {
      args.forEach((arg) => directiveSanitizer(arg));
    } else {
      Object.keys(args).forEach((key) => {
        log$1.debug("Checking key", key);
        if (key.startsWith("__")) {
          log$1.debug("sanitize deleting __ option", key);
          delete args[key];
        }
        if (key.includes("proto")) {
          log$1.debug("sanitize deleting proto option", key);
          delete args[key];
        }
        if (key.includes("constr")) {
          log$1.debug("sanitize deleting constr option", key);
          delete args[key];
        }
        if (key.includes("themeCSS")) {
          log$1.debug("sanitizing themeCss option");
          args[key] = sanitizeCss(args[key]);
        }
        if (key.includes("fontFamily")) {
          log$1.debug("sanitizing fontFamily option");
          args[key] = sanitizeCss(args[key]);
        }
        if (key.includes("altFontFamily")) {
          log$1.debug("sanitizing altFontFamily option");
          args[key] = sanitizeCss(args[key]);
        }
        if (!configKeys.includes(key)) {
          log$1.debug("sanitize deleting option", key);
          delete args[key];
        } else {
          if (typeof args[key] === "object") {
            log$1.debug("sanitize deleting object", key);
            directiveSanitizer(args[key]);
          }
        }
      });
    }
  }
  if (args.themeVariables) {
    const kArr = Object.keys(args.themeVariables);
    for (const k of kArr) {
      const val = args.themeVariables[k];
      if (val && val.match && !val.match(/^[\d "#%(),.;A-Za-z]+$/)) {
        args.themeVariables[k] = "";
      }
    }
  }
  log$1.debug("After sanitization", args);
};
const sanitizeCss = (str2) => {
  let startCnt = 0;
  let endCnt = 0;
  for (const element of str2) {
    if (startCnt < endCnt) {
      return "{ /* ERROR: Unbalanced CSS */ }";
    }
    if (element === "{") {
      startCnt++;
    } else if (element === "}") {
      endCnt++;
    }
  }
  if (startCnt !== endCnt) {
    return "{ /* ERROR: Unbalanced CSS */ }";
  }
  return str2;
};
function isDetailedError(error) {
  return "str" in error;
}
function getErrorMessage(error) {
  if (error instanceof Error) {
    return error.message;
  }
  return String(error);
}
const insertTitle = (parent, cssClass, titleTopMargin, title2) => {
  if (!title2) {
    return;
  }
  const bounds2 = parent.node().getBBox();
  parent.append("text").text(title2).attr("x", bounds2.x + bounds2.width / 2).attr("y", -titleTopMargin).attr("class", cssClass);
};
const parseFontSize = (fontSize) => {
  if (typeof fontSize === "number") {
    return [fontSize, fontSize + "px"];
  }
  const fontSizeNumber = parseInt(fontSize, 10);
  if (Number.isNaN(fontSizeNumber)) {
    return [void 0, void 0];
  } else if (fontSize === String(fontSizeNumber)) {
    return [fontSizeNumber, fontSize + "px"];
  } else {
    return [fontSizeNumber, fontSize];
  }
};
const utils = {
  assignWithDepth: assignWithDepth$1,
  wrapLabel,
  calculateTextHeight,
  calculateTextWidth,
  calculateTextDimensions,
  detectInit,
  detectDirective,
  isSubstringInArray,
  interpolateToCurve,
  calcLabelPosition,
  calcCardinalityPosition,
  calcTerminalLabelPosition,
  formatUrl,
  getStylesFromArray,
  generateId: generateId$1,
  random,
  runFunc,
  entityDecode,
  initIdGenerator,
  directiveSanitizer,
  sanitizeCss,
  insertTitle,
  parseFontSize
};
const version$1 = "9.4.3";
const defaultConfig = Object.freeze(config$2);
let siteConfig = assignWithDepth$1({}, defaultConfig);
let configFromInitialize;
let directives = [];
let currentConfig = assignWithDepth$1({}, defaultConfig);
const updateCurrentConfig = (siteCfg, _directives) => {
  let cfg = assignWithDepth$1({}, siteCfg);
  let sumOfDirectives = {};
  for (const d of _directives) {
    sanitize(d);
    sumOfDirectives = assignWithDepth$1(sumOfDirectives, d);
  }
  cfg = assignWithDepth$1(cfg, sumOfDirectives);
  if (sumOfDirectives.theme && sumOfDirectives.theme in theme) {
    const tmpConfigFromInitialize = assignWithDepth$1({}, configFromInitialize);
    const themeVariables = assignWithDepth$1(
      tmpConfigFromInitialize.themeVariables || {},
      sumOfDirectives.themeVariables
    );
    if (cfg.theme && cfg.theme in theme) {
      cfg.themeVariables = theme[cfg.theme].getThemeVariables(themeVariables);
    }
  }
  currentConfig = cfg;
  checkConfig(currentConfig);
  return currentConfig;
};
const setSiteConfig = (conf2) => {
  siteConfig = assignWithDepth$1({}, defaultConfig);
  siteConfig = assignWithDepth$1(siteConfig, conf2);
  if (conf2.theme && theme[conf2.theme]) {
    siteConfig.themeVariables = theme[conf2.theme].getThemeVariables(conf2.themeVariables);
  }
  updateCurrentConfig(siteConfig, directives);
  return siteConfig;
};
const saveConfigFromInitialize = (conf2) => {
  configFromInitialize = assignWithDepth$1({}, conf2);
};
const updateSiteConfig = (conf2) => {
  siteConfig = assignWithDepth$1(siteConfig, conf2);
  updateCurrentConfig(siteConfig, directives);
  return siteConfig;
};
const getSiteConfig = () => {
  return assignWithDepth$1({}, siteConfig);
};
const setConfig = (conf2) => {
  checkConfig(conf2);
  assignWithDepth$1(currentConfig, conf2);
  return getConfig$1();
};
const getConfig$1 = () => {
  return assignWithDepth$1({}, currentConfig);
};
const sanitize = (options2) => {
  ["secure", ...siteConfig.secure ?? []].forEach((key) => {
    if (options2[key] !== void 0) {
      log$1.debug(`Denied attempt to modify a secure key ${key}`, options2[key]);
      delete options2[key];
    }
  });
  Object.keys(options2).forEach((key) => {
    if (key.indexOf("__") === 0) {
      delete options2[key];
    }
  });
  Object.keys(options2).forEach((key) => {
    if (typeof options2[key] === "string" && (options2[key].includes("<") || options2[key].includes(">") || options2[key].includes("url(data:"))) {
      delete options2[key];
    }
    if (typeof options2[key] === "object") {
      sanitize(options2[key]);
    }
  });
};
const addDirective = (directive2) => {
  if (directive2.fontFamily) {
    if (!directive2.themeVariables) {
      directive2.themeVariables = { fontFamily: directive2.fontFamily };
    } else {
      if (!directive2.themeVariables.fontFamily) {
        directive2.themeVariables = { fontFamily: directive2.fontFamily };
      }
    }
  }
  directives.push(directive2);
  updateCurrentConfig(siteConfig, directives);
};
const reset = (config2 = siteConfig) => {
  directives = [];
  updateCurrentConfig(config2, directives);
};
var ConfigWarning = /* @__PURE__ */ ((ConfigWarning2) => {
  ConfigWarning2["LAZY_LOAD_DEPRECATED"] = "The configuration options lazyLoadedDiagrams and loadExternalDiagramsAtStartup are deprecated. Please use registerExternalDiagrams instead.";
  return ConfigWarning2;
})(ConfigWarning || {});
const issuedWarnings = {};
const issueWarning = (warning) => {
  if (issuedWarnings[warning]) {
    return;
  }
  log$1.warn(ConfigWarning[warning]);
  issuedWarnings[warning] = true;
};
const checkConfig = (config2) => {
  if (!config2) {
    return;
  }
  if (config2.lazyLoadedDiagrams || config2.loadExternalDiagramsAtStartup) {
    issueWarning("LAZY_LOAD_DEPRECATED");
  }
};
const d3Attrs = function(d3Elem, attrs) {
  for (let attr of attrs) {
    d3Elem.attr(attr[0], attr[1]);
  }
};
const calculateSvgSizeAttrs = function(height2, width2, useMaxWidth) {
  let attrs = /* @__PURE__ */ new Map();
  if (useMaxWidth) {
    attrs.set("width", "100%");
    attrs.set("style", `max-width: ${width2}px;`);
  } else {
    attrs.set("height", height2);
    attrs.set("width", width2);
  }
  return attrs;
};
const configureSvgSize = function(svgElem, height2, width2, useMaxWidth) {
  const attrs = calculateSvgSizeAttrs(height2, width2, useMaxWidth);
  d3Attrs(svgElem, attrs);
};
const setupGraphViewbox$1 = function(graph, svgElem, padding2, useMaxWidth) {
  const svgBounds = svgElem.node().getBBox();
  const sWidth = svgBounds.width;
  const sHeight = svgBounds.height;
  log$1.info(`SVG bounds: ${sWidth}x${sHeight}`, svgBounds);
  let width2 = 0;
  let height2 = 0;
  log$1.info(`Graph bounds: ${width2}x${height2}`, graph);
  width2 = sWidth + padding2 * 2;
  height2 = sHeight + padding2 * 2;
  log$1.info(`Calculated bounds: ${width2}x${height2}`);
  configureSvgSize(svgElem, height2, width2, useMaxWidth);
  const vBox = `${svgBounds.x - padding2} ${svgBounds.y - padding2} ${svgBounds.width + 2 * padding2} ${svgBounds.height + 2 * padding2}`;
  svgElem.attr("viewBox", vBox);
};
const getStyles$e = (options2) => `g.classGroup text {
  fill: ${options2.nodeBorder};
  fill: ${options2.classText};
  stroke: none;
  font-family: ${options2.fontFamily};
  font-size: 10px;

  .title {
    font-weight: bolder;
  }

}

.nodeLabel, .edgeLabel {
  color: ${options2.classText};
}
.edgeLabel .label rect {
  fill: ${options2.mainBkg};
}
.label text {
  fill: ${options2.classText};
}
.edgeLabel .label span {
  background: ${options2.mainBkg};
}

.classTitle {
  font-weight: bolder;
}
.node rect,
  .node circle,
  .node ellipse,
  .node polygon,
  .node path {
    fill: ${options2.mainBkg};
    stroke: ${options2.nodeBorder};
    stroke-width: 1px;
  }


.divider {
  stroke: ${options2.nodeBorder};
  stroke: 1;
}

g.clickable {
  cursor: pointer;
}

g.classGroup rect {
  fill: ${options2.mainBkg};
  stroke: ${options2.nodeBorder};
}

g.classGroup line {
  stroke: ${options2.nodeBorder};
  stroke-width: 1;
}

.classLabel .box {
  stroke: none;
  stroke-width: 0;
  fill: ${options2.mainBkg};
  opacity: 0.5;
}

.classLabel .label {
  fill: ${options2.nodeBorder};
  font-size: 10px;
}

.relation {
  stroke: ${options2.lineColor};
  stroke-width: 1;
  fill: none;
}

.dashed-line{
  stroke-dasharray: 3;
}

.dotted-line{
  stroke-dasharray: 1 2;
}

#compositionStart, .composition {
  fill: ${options2.lineColor} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#compositionEnd, .composition {
  fill: ${options2.lineColor} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#dependencyStart, .dependency {
  fill: ${options2.lineColor} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#dependencyStart, .dependency {
  fill: ${options2.lineColor} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#extensionStart, .extension {
  fill: ${options2.mainBkg} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#extensionEnd, .extension {
  fill: ${options2.mainBkg} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#aggregationStart, .aggregation {
  fill: ${options2.mainBkg} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#aggregationEnd, .aggregation {
  fill: ${options2.mainBkg} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#lollipopStart, .lollipop {
  fill: ${options2.mainBkg} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

#lollipopEnd, .lollipop {
  fill: ${options2.mainBkg} !important;
  stroke: ${options2.lineColor} !important;
  stroke-width: 1;
}

.edgeTerminals {
  font-size: 11px;
}

.classTitleText {
  text-anchor: middle;
  font-size: 18px;
  fill: ${options2.textColor};
}
`;
const classStyles = getStyles$e;
const getStyles$d = (options2) => `
  .entityBox {
    fill: ${options2.mainBkg};
    stroke: ${options2.nodeBorder};
  }

  .attributeBoxOdd {
    fill: ${options2.attributeBackgroundColorOdd};
    stroke: ${options2.nodeBorder};
  }

  .attributeBoxEven {
    fill:  ${options2.attributeBackgroundColorEven};
    stroke: ${options2.nodeBorder};
  }

  .relationshipLabelBox {
    fill: ${options2.tertiaryColor};
    opacity: 0.7;
    background-color: ${options2.tertiaryColor};
      rect {
        opacity: 0.5;
      }
  }

    .relationshipLine {
      stroke: ${options2.lineColor};
    }

  .entityTitleText {
    text-anchor: middle;
    font-size: 18px;
    fill: ${options2.textColor};
  }    
`;
const erStyles = getStyles$d;
const getStyles$c = () => ``;
const errorStyles = getStyles$c;
const getStyles$b = (options2) => `.label {
    font-family: ${options2.fontFamily};
    color: ${options2.nodeTextColor || options2.textColor};
  }
  .cluster-label text {
    fill: ${options2.titleColor};
  }
  .cluster-label span {
    color: ${options2.titleColor};
  }

  .label text,span {
    fill: ${options2.nodeTextColor || options2.textColor};
    color: ${options2.nodeTextColor || options2.textColor};
  }

  .node rect,
  .node circle,
  .node ellipse,
  .node polygon,
  .node path {
    fill: ${options2.mainBkg};
    stroke: ${options2.nodeBorder};
    stroke-width: 1px;
  }

  .node .label {
    text-align: center;
  }
  .node.clickable {
    cursor: pointer;
  }

  .arrowheadPath {
    fill: ${options2.arrowheadColor};
  }

  .edgePath .path {
    stroke: ${options2.lineColor};
    stroke-width: 2.0px;
  }

  .flowchart-link {
    stroke: ${options2.lineColor};
    fill: none;
  }

  .edgeLabel {
    background-color: ${options2.edgeLabelBackground};
    rect {
      opacity: 0.5;
      background-color: ${options2.edgeLabelBackground};
      fill: ${options2.edgeLabelBackground};
    }
    text-align: center;
  }

  .cluster rect {
    fill: ${options2.clusterBkg};
    stroke: ${options2.clusterBorder};
    stroke-width: 1px;
  }

  .cluster text {
    fill: ${options2.titleColor};
  }

  .cluster span {
    color: ${options2.titleColor};
  }
  /* .cluster div {
    color: ${options2.titleColor};
  } */

  div.mermaidTooltip {
    position: absolute;
    text-align: center;
    max-width: 200px;
    padding: 2px;
    font-family: ${options2.fontFamily};
    font-size: 12px;
    background: ${options2.tertiaryColor};
    border: 1px solid ${options2.border2};
    border-radius: 2px;
    pointer-events: none;
    z-index: 100;
  }

  .flowchartTitleText {
    text-anchor: middle;
    font-size: 18px;
    fill: ${options2.textColor};
  }
`;
const flowStyles = getStyles$b;
const getStyles$a = (options2) => `
  .mermaid-main-font {
    font-family: "trebuchet ms", verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);
  }
  .exclude-range {
    fill: ${options2.excludeBkgColor};
  }

  .section {
    stroke: none;
    opacity: 0.2;
  }

  .section0 {
    fill: ${options2.sectionBkgColor};
  }

  .section2 {
    fill: ${options2.sectionBkgColor2};
  }

  .section1,
  .section3 {
    fill: ${options2.altSectionBkgColor};
    opacity: 0.2;
  }

  .sectionTitle0 {
    fill: ${options2.titleColor};
  }

  .sectionTitle1 {
    fill: ${options2.titleColor};
  }

  .sectionTitle2 {
    fill: ${options2.titleColor};
  }

  .sectionTitle3 {
    fill: ${options2.titleColor};
  }

  .sectionTitle {
    text-anchor: start;
    // font-size: ${options2.ganttFontSize};
    // text-height: 14px;
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);

  }


  /* Grid and axis */

  .grid .tick {
    stroke: ${options2.gridColor};
    opacity: 0.8;
    shape-rendering: crispEdges;
    text {
      font-family: ${options2.fontFamily};
      fill: ${options2.textColor};
    }
  }

  .grid path {
    stroke-width: 0;
  }


  /* Today line */

  .today {
    fill: none;
    stroke: ${options2.todayLineColor};
    stroke-width: 2px;
  }


  /* Task styling */

  /* Default task */

  .task {
    stroke-width: 2;
  }

  .taskText {
    text-anchor: middle;
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);
  }

  // .taskText:not([font-size]) {
  //   font-size: ${options2.ganttFontSize};
  // }

  .taskTextOutsideRight {
    fill: ${options2.taskTextDarkColor};
    text-anchor: start;
    // font-size: ${options2.ganttFontSize};
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);

  }

  .taskTextOutsideLeft {
    fill: ${options2.taskTextDarkColor};
    text-anchor: end;
    // font-size: ${options2.ganttFontSize};
  }

  /* Special case clickable */
  .task.clickable {
    cursor: pointer;
  }
  .taskText.clickable {
    cursor: pointer;
    fill: ${options2.taskTextClickableColor} !important;
    font-weight: bold;
  }

  .taskTextOutsideLeft.clickable {
    cursor: pointer;
    fill: ${options2.taskTextClickableColor} !important;
    font-weight: bold;
  }

  .taskTextOutsideRight.clickable {
    cursor: pointer;
    fill: ${options2.taskTextClickableColor} !important;
    font-weight: bold;
  }

  /* Specific task settings for the sections*/

  .taskText0,
  .taskText1,
  .taskText2,
  .taskText3 {
    fill: ${options2.taskTextColor};
  }

  .task0,
  .task1,
  .task2,
  .task3 {
    fill: ${options2.taskBkgColor};
    stroke: ${options2.taskBorderColor};
  }

  .taskTextOutside0,
  .taskTextOutside2
  {
    fill: ${options2.taskTextOutsideColor};
  }

  .taskTextOutside1,
  .taskTextOutside3 {
    fill: ${options2.taskTextOutsideColor};
  }


  /* Active task */

  .active0,
  .active1,
  .active2,
  .active3 {
    fill: ${options2.activeTaskBkgColor};
    stroke: ${options2.activeTaskBorderColor};
  }

  .activeText0,
  .activeText1,
  .activeText2,
  .activeText3 {
    fill: ${options2.taskTextDarkColor} !important;
  }


  /* Completed task */

  .done0,
  .done1,
  .done2,
  .done3 {
    stroke: ${options2.doneTaskBorderColor};
    fill: ${options2.doneTaskBkgColor};
    stroke-width: 2;
  }

  .doneText0,
  .doneText1,
  .doneText2,
  .doneText3 {
    fill: ${options2.taskTextDarkColor} !important;
  }


  /* Tasks on the critical line */

  .crit0,
  .crit1,
  .crit2,
  .crit3 {
    stroke: ${options2.critBorderColor};
    fill: ${options2.critBkgColor};
    stroke-width: 2;
  }

  .activeCrit0,
  .activeCrit1,
  .activeCrit2,
  .activeCrit3 {
    stroke: ${options2.critBorderColor};
    fill: ${options2.activeTaskBkgColor};
    stroke-width: 2;
  }

  .doneCrit0,
  .doneCrit1,
  .doneCrit2,
  .doneCrit3 {
    stroke: ${options2.critBorderColor};
    fill: ${options2.doneTaskBkgColor};
    stroke-width: 2;
    cursor: pointer;
    shape-rendering: crispEdges;
  }

  .milestone {
    transform: rotate(45deg) scale(0.8,0.8);
  }

  .milestoneText {
    font-style: italic;
  }
  .doneCritText0,
  .doneCritText1,
  .doneCritText2,
  .doneCritText3 {
    fill: ${options2.taskTextDarkColor} !important;
  }

  .activeCritText0,
  .activeCritText1,
  .activeCritText2,
  .activeCritText3 {
    fill: ${options2.taskTextDarkColor} !important;
  }

  .titleText {
    text-anchor: middle;
    font-size: 18px;
    fill: ${options2.textColor}    ;
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);
  }
`;
const ganttStyles = getStyles$a;
const getStyles$9 = () => ``;
const infoStyles = getStyles$9;
const getStyles$8 = (options2) => `
  .pieCircle{
    stroke: ${options2.pieStrokeColor};
    stroke-width : ${options2.pieStrokeWidth};
    opacity : ${options2.pieOpacity};
  }
  .pieTitleText {
    text-anchor: middle;
    font-size: ${options2.pieTitleTextSize};
    fill: ${options2.pieTitleTextColor};
    font-family: ${options2.fontFamily};
  }
  .slice {
    font-family: ${options2.fontFamily};
    fill: ${options2.pieSectionTextColor};
    font-size:${options2.pieSectionTextSize};
    // fill: white;
  }
  .legend text {
    fill: ${options2.pieLegendTextColor};
    font-family: ${options2.fontFamily};
    font-size: ${options2.pieLegendTextSize};
  }
`;
const pieStyles = getStyles$8;
const getStyles$7 = (options2) => `

  marker {
    fill: ${options2.relationColor};
    stroke: ${options2.relationColor};
  }

  marker.cross {
    stroke: ${options2.lineColor};
  }

  svg {
    font-family: ${options2.fontFamily};
    font-size: ${options2.fontSize};
  }

  .reqBox {
    fill: ${options2.requirementBackground};
    fill-opacity: 100%;
    stroke: ${options2.requirementBorderColor};
    stroke-width: ${options2.requirementBorderSize};
  }
  
  .reqTitle, .reqLabel{
    fill:  ${options2.requirementTextColor};
  }
  .reqLabelBox {
    fill: ${options2.relationLabelBackground};
    fill-opacity: 100%;
  }

  .req-title-line {
    stroke: ${options2.requirementBorderColor};
    stroke-width: ${options2.requirementBorderSize};
  }
  .relationshipLine {
    stroke: ${options2.relationColor};
    stroke-width: 1;
  }
  .relationshipLabel {
    fill: ${options2.relationLabelColor};
  }

`;
const requirementStyles = getStyles$7;
const getStyles$6 = (options2) => `.actor {
    stroke: ${options2.actorBorder};
    fill: ${options2.actorBkg};
  }

  text.actor > tspan {
    fill: ${options2.actorTextColor};
    stroke: none;
  }

  .actor-line {
    stroke: ${options2.actorLineColor};
  }

  .messageLine0 {
    stroke-width: 1.5;
    stroke-dasharray: none;
    stroke: ${options2.signalColor};
  }

  .messageLine1 {
    stroke-width: 1.5;
    stroke-dasharray: 2, 2;
    stroke: ${options2.signalColor};
  }

  #arrowhead path {
    fill: ${options2.signalColor};
    stroke: ${options2.signalColor};
  }

  .sequenceNumber {
    fill: ${options2.sequenceNumberColor};
  }

  #sequencenumber {
    fill: ${options2.signalColor};
  }

  #crosshead path {
    fill: ${options2.signalColor};
    stroke: ${options2.signalColor};
  }

  .messageText {
    fill: ${options2.signalTextColor};
    stroke: none;
  }

  .labelBox {
    stroke: ${options2.labelBoxBorderColor};
    fill: ${options2.labelBoxBkgColor};
  }

  .labelText, .labelText > tspan {
    fill: ${options2.labelTextColor};
    stroke: none;
  }

  .loopText, .loopText > tspan {
    fill: ${options2.loopTextColor};
    stroke: none;
  }

  .loopLine {
    stroke-width: 2px;
    stroke-dasharray: 2, 2;
    stroke: ${options2.labelBoxBorderColor};
    fill: ${options2.labelBoxBorderColor};
  }

  .note {
    //stroke: #decc93;
    stroke: ${options2.noteBorderColor};
    fill: ${options2.noteBkgColor};
  }

  .noteText, .noteText > tspan {
    fill: ${options2.noteTextColor};
    stroke: none;
  }

  .activation0 {
    fill: ${options2.activationBkgColor};
    stroke: ${options2.activationBorderColor};
  }

  .activation1 {
    fill: ${options2.activationBkgColor};
    stroke: ${options2.activationBorderColor};
  }

  .activation2 {
    fill: ${options2.activationBkgColor};
    stroke: ${options2.activationBorderColor};
  }

  .actorPopupMenu {
    position: absolute;
  }

  .actorPopupMenuPanel {
    position: absolute;
    fill: ${options2.actorBkg};
    box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2);
    filter: drop-shadow(3px 5px 2px rgb(0 0 0 / 0.4));
}
  .actor-man line {
    stroke: ${options2.actorBorder};
    fill: ${options2.actorBkg};
  }
  .actor-man circle, line {
    stroke: ${options2.actorBorder};
    fill: ${options2.actorBkg};
    stroke-width: 2px;
  }
`;
const sequenceStyles = getStyles$6;
const getStyles$5 = (options2) => `
defs #statediagram-barbEnd {
    fill: ${options2.transitionColor};
    stroke: ${options2.transitionColor};
  }
g.stateGroup text {
  fill: ${options2.nodeBorder};
  stroke: none;
  font-size: 10px;
}
g.stateGroup text {
  fill: ${options2.textColor};
  stroke: none;
  font-size: 10px;

}
g.stateGroup .state-title {
  font-weight: bolder;
  fill: ${options2.stateLabelColor};
}

g.stateGroup rect {
  fill: ${options2.mainBkg};
  stroke: ${options2.nodeBorder};
}

g.stateGroup line {
  stroke: ${options2.lineColor};
  stroke-width: 1;
}

.transition {
  stroke: ${options2.transitionColor};
  stroke-width: 1;
  fill: none;
}

.stateGroup .composit {
  fill: ${options2.background};
  border-bottom: 1px
}

.stateGroup .alt-composit {
  fill: #e0e0e0;
  border-bottom: 1px
}

.state-note {
  stroke: ${options2.noteBorderColor};
  fill: ${options2.noteBkgColor};

  text {
    fill: ${options2.noteTextColor};
    stroke: none;
    font-size: 10px;
  }
}

.stateLabel .box {
  stroke: none;
  stroke-width: 0;
  fill: ${options2.mainBkg};
  opacity: 0.5;
}

.edgeLabel .label rect {
  fill: ${options2.labelBackgroundColor};
  opacity: 0.5;
}
.edgeLabel .label text {
  fill: ${options2.transitionLabelColor || options2.tertiaryTextColor};
}
.label div .edgeLabel {
  color: ${options2.transitionLabelColor || options2.tertiaryTextColor};
}

.stateLabel text {
  fill: ${options2.stateLabelColor};
  font-size: 10px;
  font-weight: bold;
}

.node circle.state-start {
  fill: ${options2.specialStateColor};
  stroke: ${options2.specialStateColor};
}

.node .fork-join {
  fill: ${options2.specialStateColor};
  stroke: ${options2.specialStateColor};
}

.node circle.state-end {
  fill: ${options2.innerEndBackground};
  stroke: ${options2.background};
  stroke-width: 1.5
}
.end-state-inner {
  fill: ${options2.compositeBackground || options2.background};
  // stroke: ${options2.background};
  stroke-width: 1.5
}

.node rect {
  fill: ${options2.stateBkg || options2.mainBkg};
  stroke: ${options2.stateBorder || options2.nodeBorder};
  stroke-width: 1px;
}
.node polygon {
  fill: ${options2.mainBkg};
  stroke: ${options2.stateBorder || options2.nodeBorder};;
  stroke-width: 1px;
}
#statediagram-barbEnd {
  fill: ${options2.lineColor};
}

.statediagram-cluster rect {
  fill: ${options2.compositeTitleBackground};
  stroke: ${options2.stateBorder || options2.nodeBorder};
  stroke-width: 1px;
}

.cluster-label, .nodeLabel {
  color: ${options2.stateLabelColor};
}

.statediagram-cluster rect.outer {
  rx: 5px;
  ry: 5px;
}
.statediagram-state .divider {
  stroke: ${options2.stateBorder || options2.nodeBorder};
}

.statediagram-state .title-state {
  rx: 5px;
  ry: 5px;
}
.statediagram-cluster.statediagram-cluster .inner {
  fill: ${options2.compositeBackground || options2.background};
}
.statediagram-cluster.statediagram-cluster-alt .inner {
  fill: ${options2.altBackground ? options2.altBackground : "#efefef"};
}

.statediagram-cluster .inner {
  rx:0;
  ry:0;
}

.statediagram-state rect.basic {
  rx: 5px;
  ry: 5px;
}
.statediagram-state rect.divider {
  stroke-dasharray: 10,10;
  fill: ${options2.altBackground ? options2.altBackground : "#efefef"};
}

.note-edge {
  stroke-dasharray: 5;
}

.statediagram-note rect {
  fill: ${options2.noteBkgColor};
  stroke: ${options2.noteBorderColor};
  stroke-width: 1px;
  rx: 0;
  ry: 0;
}
.statediagram-note rect {
  fill: ${options2.noteBkgColor};
  stroke: ${options2.noteBorderColor};
  stroke-width: 1px;
  rx: 0;
  ry: 0;
}

.statediagram-note text {
  fill: ${options2.noteTextColor};
}

.statediagram-note .nodeLabel {
  color: ${options2.noteTextColor};
}
.statediagram .edgeLabel {
  color: red; // ${options2.noteTextColor};
}

#dependencyStart, #dependencyEnd {
  fill: ${options2.lineColor};
  stroke: ${options2.lineColor};
  stroke-width: 1;
}

.statediagramTitleText {
  text-anchor: middle;
  font-size: 18px;
  fill: ${options2.textColor};
}
`;
const stateStyles = getStyles$5;
const getStyles$4 = (options2) => `.label {
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);
    color: ${options2.textColor};
  }
  .mouth {
    stroke: #666;
  }

  line {
    stroke: ${options2.textColor}
  }

  .legend {
    fill: ${options2.textColor};
  }

  .label text {
    fill: #333;
  }
  .label {
    color: ${options2.textColor}
  }

  .face {
    ${options2.faceColor ? `fill: ${options2.faceColor}` : "fill: #FFF8DC"};
    stroke: #999;
  }

  .node rect,
  .node circle,
  .node ellipse,
  .node polygon,
  .node path {
    fill: ${options2.mainBkg};
    stroke: ${options2.nodeBorder};
    stroke-width: 1px;
  }

  .node .label {
    text-align: center;
  }
  .node.clickable {
    cursor: pointer;
  }

  .arrowheadPath {
    fill: ${options2.arrowheadColor};
  }

  .edgePath .path {
    stroke: ${options2.lineColor};
    stroke-width: 1.5px;
  }

  .flowchart-link {
    stroke: ${options2.lineColor};
    fill: none;
  }

  .edgeLabel {
    background-color: ${options2.edgeLabelBackground};
    rect {
      opacity: 0.5;
    }
    text-align: center;
  }

  .cluster rect {
  }

  .cluster text {
    fill: ${options2.titleColor};
  }

  div.mermaidTooltip {
    position: absolute;
    text-align: center;
    max-width: 200px;
    padding: 2px;
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);
    font-size: 12px;
    background: ${options2.tertiaryColor};
    border: 1px solid ${options2.border2};
    border-radius: 2px;
    pointer-events: none;
    z-index: 100;
  }

  .task-type-0, .section-type-0  {
    ${options2.fillType0 ? `fill: ${options2.fillType0}` : ""};
  }
  .task-type-1, .section-type-1  {
    ${options2.fillType0 ? `fill: ${options2.fillType1}` : ""};
  }
  .task-type-2, .section-type-2  {
    ${options2.fillType0 ? `fill: ${options2.fillType2}` : ""};
  }
  .task-type-3, .section-type-3  {
    ${options2.fillType0 ? `fill: ${options2.fillType3}` : ""};
  }
  .task-type-4, .section-type-4  {
    ${options2.fillType0 ? `fill: ${options2.fillType4}` : ""};
  }
  .task-type-5, .section-type-5  {
    ${options2.fillType0 ? `fill: ${options2.fillType5}` : ""};
  }
  .task-type-6, .section-type-6  {
    ${options2.fillType0 ? `fill: ${options2.fillType6}` : ""};
  }
  .task-type-7, .section-type-7  {
    ${options2.fillType0 ? `fill: ${options2.fillType7}` : ""};
  }

  .actor-0 {
    ${options2.actor0 ? `fill: ${options2.actor0}` : ""};
  }
  .actor-1 {
    ${options2.actor1 ? `fill: ${options2.actor1}` : ""};
  }
  .actor-2 {
    ${options2.actor2 ? `fill: ${options2.actor2}` : ""};
  }
  .actor-3 {
    ${options2.actor3 ? `fill: ${options2.actor3}` : ""};
  }
  .actor-4 {
    ${options2.actor4 ? `fill: ${options2.actor4}` : ""};
  }
  .actor-5 {
    ${options2.actor5 ? `fill: ${options2.actor5}` : ""};
  }
`;
const journeyStyles = getStyles$4;
const getStyles$3 = (options2) => `.person {
    stroke: ${options2.personBorder};
    fill: ${options2.personBkg};
  }
`;
const c4Styles = getStyles$3;
const themes = {
  flowchart: flowStyles,
  "flowchart-v2": flowStyles,
  sequence: sequenceStyles,
  gantt: ganttStyles,
  classDiagram: classStyles,
  "classDiagram-v2": classStyles,
  class: classStyles,
  stateDiagram: stateStyles,
  state: stateStyles,
  // gitGraph,
  info: infoStyles,
  pie: pieStyles,
  er: erStyles,
  error: errorStyles,
  journey: journeyStyles,
  requirement: requirementStyles,
  c4: c4Styles
};
const getStyles$1 = (type2, userStyles, options2) => {
  let diagramStyles = "";
  if (type2 in themes && themes[type2]) {
    diagramStyles = themes[type2](options2);
  } else {
    log$1.warn(`No theme found for ${type2}`);
  }
  return ` & {
    font-family: ${options2.fontFamily};
    font-size: ${options2.fontSize};
    fill: ${options2.textColor}
  }

  /* Classes common for multiple diagrams */

  & .error-icon {
    fill: ${options2.errorBkgColor};
  }
  & .error-text {
    fill: ${options2.errorTextColor};
    stroke: ${options2.errorTextColor};
  }

  & .edge-thickness-normal {
    stroke-width: 2px;
  }
  & .edge-thickness-thick {
    stroke-width: 3.5px
  }
  & .edge-pattern-solid {
    stroke-dasharray: 0;
  }

  & .edge-pattern-dashed{
    stroke-dasharray: 3;
  }
  .edge-pattern-dotted {
    stroke-dasharray: 2;
  }

  & .marker {
    fill: ${options2.lineColor};
    stroke: ${options2.lineColor};
  }
  & .marker.cross {
    stroke: ${options2.lineColor};
  }

  & svg {
    font-family: ${options2.fontFamily};
    font-size: ${options2.fontSize};
  }

  ${diagramStyles}

  ${userStyles}
`;
};
const addStylesForDiagram = (type2, diagramTheme) => {
  themes[type2] = diagramTheme;
};
const getStyles$2 = getStyles$1;
let title$1 = "";
let diagramTitle = "";
let description = "";
const sanitizeText$4 = (txt) => sanitizeText$5(txt, getConfig$1());
const clear$g = function() {
  title$1 = "";
  description = "";
  diagramTitle = "";
};
const setAccTitle = function(txt) {
  title$1 = sanitizeText$4(txt).replace(/^\s+/g, "");
};
const getAccTitle = function() {
  return title$1 || diagramTitle;
};
const setAccDescription = function(txt) {
  description = sanitizeText$4(txt).replace(/\n\s+/g, "\n");
};
const getAccDescription = function() {
  return description;
};
const setDiagramTitle = function(txt) {
  diagramTitle = sanitizeText$4(txt);
};
const getDiagramTitle = function() {
  return diagramTitle;
};
const commonDb = {
  setAccTitle,
  getAccTitle,
  setDiagramTitle,
  getDiagramTitle,
  getAccDescription,
  setAccDescription,
  clear: clear$g
};
const commonDb$1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  clear: clear$g,
  default: commonDb,
  getAccDescription,
  getAccTitle,
  getDiagramTitle,
  setAccDescription,
  setAccTitle,
  setDiagramTitle
}, Symbol.toStringTag, { value: "Module" }));
let currentDirective = {};
const parseDirective$c = function(p, statement, context, type2) {
  log$1.debug("parseDirective is being called", statement, context, type2);
  try {
    if (statement !== void 0) {
      statement = statement.trim();
      switch (context) {
        case "open_directive":
          currentDirective = {};
          break;
        case "type_directive":
          if (!currentDirective) {
            throw new Error("currentDirective is undefined");
          }
          currentDirective.type = statement.toLowerCase();
          break;
        case "arg_directive":
          if (!currentDirective) {
            throw new Error("currentDirective is undefined");
          }
          currentDirective.args = JSON.parse(statement);
          break;
        case "close_directive":
          handleDirective(p, currentDirective, type2);
          currentDirective = void 0;
          break;
      }
    }
  } catch (error) {
    log$1.error(
      `Error while rendering sequenceDiagram directive: ${statement} jison context: ${context}`
    );
    log$1.error(error.message);
  }
};
const handleDirective = function(p, directive2, type2) {
  log$1.info(`Directive type=${directive2.type} with args:`, directive2.args);
  switch (directive2.type) {
    case "init":
    case "initialize": {
      ["config"].forEach((prop) => {
        if (directive2.args[prop] !== void 0) {
          if (type2 === "flowchart-v2") {
            type2 = "flowchart";
          }
          directive2.args[type2] = directive2.args[prop];
          delete directive2.args[prop];
        }
      });
      log$1.info("sanitize in handleDirective", directive2.args);
      directiveSanitizer(directive2.args);
      log$1.info("sanitize in handleDirective (done)", directive2.args);
      addDirective(directive2.args);
      break;
    }
    case "wrap":
    case "nowrap":
      if (p && p["setWrap"]) {
        p.setWrap(directive2.type === "wrap");
      }
      break;
    case "themeCss":
      log$1.warn("themeCss encountered");
      break;
    default:
      log$1.warn(
        `Unhandled directive: source: '%%{${directive2.type}: ${JSON.stringify(
          directive2.args ? directive2.args : {}
        )}}%%`,
        directive2
      );
      break;
  }
};
const log = log$1;
const setLogLevel = setLogLevel$1;
const getConfig = getConfig$1;
const sanitizeText$3 = (text) => sanitizeText$5(text, getConfig());
const setupGraphViewbox = setupGraphViewbox$1;
const getCommonDb = () => {
  return commonDb$1;
};
const parseDirective$b = (p, statement, context, type2) => parseDirective$c(p, statement, context, type2);
const diagrams = {};
const registerDiagram = (id2, diagram, detector2) => {
  if (diagrams[id2]) {
    throw new Error(`Diagram ${id2} already registered.`);
  }
  diagrams[id2] = diagram;
  if (detector2) {
    addDetector(id2, detector2);
  }
  addStylesForDiagram(id2, diagram.styles);
  if (diagram.injectUtils) {
    diagram.injectUtils(
      log,
      setLogLevel,
      getConfig,
      sanitizeText$3,
      setupGraphViewbox,
      getCommonDb(),
      parseDirective$b
    );
  }
};
const getDiagram = (name) => {
  if (name in diagrams) {
    return diagrams[name];
  }
  throw new Error(`Diagram ${name} not found.`);
};
var parser$c = function() {
  var o = function(k, v, o2, l) {
    for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
      ;
    return o2;
  }, $V0 = [1, 4], $V1 = [1, 7], $V2 = [1, 5], $V3 = [1, 9], $V4 = [1, 6], $V5 = [2, 6], $V6 = [1, 16], $V7 = [6, 8, 14, 20, 22, 24, 25, 27, 29, 32, 37, 40, 50, 55], $V8 = [8, 14, 20, 22, 24, 25, 27, 29, 32, 37, 40], $V9 = [8, 13, 14, 20, 22, 24, 25, 27, 29, 32, 37, 40], $Va = [1, 26], $Vb = [6, 8, 14, 50, 55], $Vc = [8, 14, 55], $Vd = [1, 53], $Ve = [1, 52], $Vf = [8, 14, 30, 33, 35, 38, 55], $Vg = [1, 67], $Vh = [1, 68], $Vi = [1, 69], $Vj = [8, 14, 33, 35, 42, 55];
  var parser2 = {
    trace: function trace() {
    },
    yy: {},
    symbols_: { "error": 2, "start": 3, "eol": 4, "directive": 5, "GG": 6, "document": 7, "EOF": 8, ":": 9, "DIR": 10, "options": 11, "body": 12, "OPT": 13, "NL": 14, "line": 15, "statement": 16, "commitStatement": 17, "mergeStatement": 18, "cherryPickStatement": 19, "acc_title": 20, "acc_title_value": 21, "acc_descr": 22, "acc_descr_value": 23, "acc_descr_multiline_value": 24, "section": 25, "branchStatement": 26, "CHECKOUT": 27, "ref": 28, "BRANCH": 29, "ORDER": 30, "NUM": 31, "CHERRY_PICK": 32, "COMMIT_ID": 33, "STR": 34, "COMMIT_TAG": 35, "EMPTYSTR": 36, "MERGE": 37, "COMMIT_TYPE": 38, "commitType": 39, "COMMIT": 40, "commit_arg": 41, "COMMIT_MSG": 42, "NORMAL": 43, "REVERSE": 44, "HIGHLIGHT": 45, "openDirective": 46, "typeDirective": 47, "closeDirective": 48, "argDirective": 49, "open_directive": 50, "type_directive": 51, "arg_directive": 52, "close_directive": 53, "ID": 54, ";": 55, "$accept": 0, "$end": 1 },
    terminals_: { 2: "error", 6: "GG", 8: "EOF", 9: ":", 10: "DIR", 13: "OPT", 14: "NL", 20: "acc_title", 21: "acc_title_value", 22: "acc_descr", 23: "acc_descr_value", 24: "acc_descr_multiline_value", 25: "section", 27: "CHECKOUT", 29: "BRANCH", 30: "ORDER", 31: "NUM", 32: "CHERRY_PICK", 33: "COMMIT_ID", 34: "STR", 35: "COMMIT_TAG", 36: "EMPTYSTR", 37: "MERGE", 38: "COMMIT_TYPE", 40: "COMMIT", 42: "COMMIT_MSG", 43: "NORMAL", 44: "REVERSE", 45: "HIGHLIGHT", 50: "open_directive", 51: "type_directive", 52: "arg_directive", 53: "close_directive", 54: "ID", 55: ";" },
    productions_: [0, [3, 2], [3, 2], [3, 3], [3, 4], [3, 5], [7, 0], [7, 2], [11, 2], [11, 1], [12, 0], [12, 2], [15, 2], [15, 1], [16, 1], [16, 1], [16, 1], [16, 2], [16, 2], [16, 1], [16, 1], [16, 1], [16, 2], [26, 2], [26, 4], [19, 3], [19, 5], [19, 5], [19, 5], [19, 5], [18, 2], [18, 4], [18, 4], [18, 4], [18, 6], [18, 6], [18, 6], [18, 6], [18, 6], [18, 6], [18, 8], [18, 8], [18, 8], [18, 8], [18, 8], [18, 8], [17, 2], [17, 3], [17, 3], [17, 5], [17, 5], [17, 3], [17, 5], [17, 5], [17, 5], [17, 5], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 3], [17, 5], [17, 5], [17, 5], [17, 5], [17, 5], [17, 5], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 7], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [17, 9], [41, 0], [41, 1], [39, 1], [39, 1], [39, 1], [5, 3], [5, 5], [46, 1], [47, 1], [49, 1], [48, 1], [28, 1], [28, 1], [4, 1], [4, 1], [4, 1]],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
      var $0 = $$.length - 1;
      switch (yystate) {
        case 3:
          return $$[$0];
        case 4:
          return $$[$0 - 1];
        case 5:
          yy.setDirection($$[$0 - 3]);
          return $$[$0 - 1];
        case 7:
          yy.setOptions($$[$0 - 1]);
          this.$ = $$[$0];
          break;
        case 8:
          $$[$0 - 1] += $$[$0];
          this.$ = $$[$0 - 1];
          break;
        case 10:
          this.$ = [];
          break;
        case 11:
          $$[$0 - 1].push($$[$0]);
          this.$ = $$[$0 - 1];
          break;
        case 12:
          this.$ = $$[$0 - 1];
          break;
        case 17:
          this.$ = $$[$0].trim();
          yy.setAccTitle(this.$);
          break;
        case 18:
        case 19:
          this.$ = $$[$0].trim();
          yy.setAccDescription(this.$);
          break;
        case 20:
          yy.addSection($$[$0].substr(8));
          this.$ = $$[$0].substr(8);
          break;
        case 22:
          yy.checkout($$[$0]);
          break;
        case 23:
          yy.branch($$[$0]);
          break;
        case 24:
          yy.branch($$[$0 - 2], $$[$0]);
          break;
        case 25:
          yy.cherryPick($$[$0], "", void 0);
          break;
        case 26:
          yy.cherryPick($$[$0 - 2], "", $$[$0]);
          break;
        case 27:
        case 29:
          yy.cherryPick($$[$0 - 2], "", "");
          break;
        case 28:
          yy.cherryPick($$[$0], "", $$[$0 - 2]);
          break;
        case 30:
          yy.merge($$[$0], "", "", "");
          break;
        case 31:
          yy.merge($$[$0 - 2], $$[$0], "", "");
          break;
        case 32:
          yy.merge($$[$0 - 2], "", $$[$0], "");
          break;
        case 33:
          yy.merge($$[$0 - 2], "", "", $$[$0]);
          break;
        case 34:
          yy.merge($$[$0 - 4], $$[$0], "", $$[$0 - 2]);
          break;
        case 35:
          yy.merge($$[$0 - 4], "", $$[$0], $$[$0 - 2]);
          break;
        case 36:
          yy.merge($$[$0 - 4], "", $$[$0 - 2], $$[$0]);
          break;
        case 37:
          yy.merge($$[$0 - 4], $$[$0 - 2], $$[$0], "");
          break;
        case 38:
          yy.merge($$[$0 - 4], $$[$0 - 2], "", $$[$0]);
          break;
        case 39:
          yy.merge($$[$0 - 4], $$[$0], $$[$0 - 2], "");
          break;
        case 40:
          yy.merge($$[$0 - 6], $$[$0 - 4], $$[$0 - 2], $$[$0]);
          break;
        case 41:
          yy.merge($$[$0 - 6], $$[$0], $$[$0 - 4], $$[$0 - 2]);
          break;
        case 42:
          yy.merge($$[$0 - 6], $$[$0 - 4], $$[$0], $$[$0 - 2]);
          break;
        case 43:
          yy.merge($$[$0 - 6], $$[$0 - 2], $$[$0 - 4], $$[$0]);
          break;
        case 44:
          yy.merge($$[$0 - 6], $$[$0], $$[$0 - 2], $$[$0 - 4]);
          break;
        case 45:
          yy.merge($$[$0 - 6], $$[$0 - 2], $$[$0], $$[$0 - 4]);
          break;
        case 46:
          yy.commit($$[$0]);
          break;
        case 47:
          yy.commit("", "", yy.commitType.NORMAL, $$[$0]);
          break;
        case 48:
          yy.commit("", "", $$[$0], "");
          break;
        case 49:
          yy.commit("", "", $$[$0], $$[$0 - 2]);
          break;
        case 50:
          yy.commit("", "", $$[$0 - 2], $$[$0]);
          break;
        case 51:
          yy.commit("", $$[$0], yy.commitType.NORMAL, "");
          break;
        case 52:
          yy.commit("", $$[$0 - 2], yy.commitType.NORMAL, $$[$0]);
          break;
        case 53:
          yy.commit("", $$[$0], yy.commitType.NORMAL, $$[$0 - 2]);
          break;
        case 54:
          yy.commit("", $$[$0 - 2], $$[$0], "");
          break;
        case 55:
          yy.commit("", $$[$0], $$[$0 - 2], "");
          break;
        case 56:
          yy.commit("", $$[$0 - 4], $$[$0 - 2], $$[$0]);
          break;
        case 57:
          yy.commit("", $$[$0 - 4], $$[$0], $$[$0 - 2]);
          break;
        case 58:
          yy.commit("", $$[$0 - 2], $$[$0 - 4], $$[$0]);
          break;
        case 59:
          yy.commit("", $$[$0], $$[$0 - 4], $$[$0 - 2]);
          break;
        case 60:
          yy.commit("", $$[$0], $$[$0 - 2], $$[$0 - 4]);
          break;
        case 61:
          yy.commit("", $$[$0 - 2], $$[$0], $$[$0 - 4]);
          break;
        case 62:
          yy.commit($$[$0], "", yy.commitType.NORMAL, "");
          break;
        case 63:
          yy.commit($$[$0], "", yy.commitType.NORMAL, $$[$0 - 2]);
          break;
        case 64:
          yy.commit($$[$0 - 2], "", yy.commitType.NORMAL, $$[$0]);
          break;
        case 65:
          yy.commit($$[$0 - 2], "", $$[$0], "");
          break;
        case 66:
          yy.commit($$[$0], "", $$[$0 - 2], "");
          break;
        case 67:
          yy.commit($$[$0], $$[$0 - 2], yy.commitType.NORMAL, "");
          break;
        case 68:
          yy.commit($$[$0 - 2], $$[$0], yy.commitType.NORMAL, "");
          break;
        case 69:
          yy.commit($$[$0 - 4], "", $$[$0 - 2], $$[$0]);
          break;
        case 70:
          yy.commit($$[$0 - 4], "", $$[$0], $$[$0 - 2]);
          break;
        case 71:
          yy.commit($$[$0 - 2], "", $$[$0 - 4], $$[$0]);
          break;
        case 72:
          yy.commit($$[$0], "", $$[$0 - 4], $$[$0 - 2]);
          break;
        case 73:
          yy.commit($$[$0], "", $$[$0 - 2], $$[$0 - 4]);
          break;
        case 74:
          yy.commit($$[$0 - 2], "", $$[$0], $$[$0 - 4]);
          break;
        case 75:
          yy.commit($$[$0 - 4], $$[$0], $$[$0 - 2], "");
          break;
        case 76:
          yy.commit($$[$0 - 4], $$[$0 - 2], $$[$0], "");
          break;
        case 77:
          yy.commit($$[$0 - 2], $$[$0], $$[$0 - 4], "");
          break;
        case 78:
          yy.commit($$[$0], $$[$0 - 2], $$[$0 - 4], "");
          break;
        case 79:
          yy.commit($$[$0], $$[$0 - 4], $$[$0 - 2], "");
          break;
        case 80:
          yy.commit($$[$0 - 2], $$[$0 - 4], $$[$0], "");
          break;
        case 81:
          yy.commit($$[$0 - 4], $$[$0], yy.commitType.NORMAL, $$[$0 - 2]);
          break;
        case 82:
          yy.commit($$[$0 - 4], $$[$0 - 2], yy.commitType.NORMAL, $$[$0]);
          break;
        case 83:
          yy.commit($$[$0 - 2], $$[$0], yy.commitType.NORMAL, $$[$0 - 4]);
          break;
        case 84:
          yy.commit($$[$0], $$[$0 - 2], yy.commitType.NORMAL, $$[$0 - 4]);
          break;
        case 85:
          yy.commit($$[$0], $$[$0 - 4], yy.commitType.NORMAL, $$[$0 - 2]);
          break;
        case 86:
          yy.commit($$[$0 - 2], $$[$0 - 4], yy.commitType.NORMAL, $$[$0]);
          break;
        case 87:
          yy.commit($$[$0 - 6], $$[$0 - 4], $$[$0 - 2], $$[$0]);
          break;
        case 88:
          yy.commit($$[$0 - 6], $$[$0 - 4], $$[$0], $$[$0 - 2]);
          break;
        case 89:
          yy.commit($$[$0 - 6], $$[$0 - 2], $$[$0 - 4], $$[$0]);
          break;
        case 90:
          yy.commit($$[$0 - 6], $$[$0], $$[$0 - 4], $$[$0 - 2]);
          break;
        case 91:
          yy.commit($$[$0 - 6], $$[$0 - 2], $$[$0], $$[$0 - 4]);
          break;
        case 92:
          yy.commit($$[$0 - 6], $$[$0], $$[$0 - 2], $$[$0 - 4]);
          break;
        case 93:
          yy.commit($$[$0 - 4], $$[$0 - 6], $$[$0 - 2], $$[$0]);
          break;
        case 94:
          yy.commit($$[$0 - 4], $$[$0 - 6], $$[$0], $$[$0 - 2]);
          break;
        case 95:
          yy.commit($$[$0 - 2], $$[$0 - 6], $$[$0 - 4], $$[$0]);
          break;
        case 96:
          yy.commit($$[$0], $$[$0 - 6], $$[$0 - 4], $$[$0 - 2]);
          break;
        case 97:
          yy.commit($$[$0 - 2], $$[$0 - 6], $$[$0], $$[$0 - 4]);
          break;
        case 98:
          yy.commit($$[$0], $$[$0 - 6], $$[$0 - 2], $$[$0 - 4]);
          break;
        case 99:
          yy.commit($$[$0], $$[$0 - 4], $$[$0 - 2], $$[$0 - 6]);
          break;
        case 100:
          yy.commit($$[$0 - 2], $$[$0 - 4], $$[$0], $$[$0 - 6]);
          break;
        case 101:
          yy.commit($$[$0], $$[$0 - 2], $$[$0 - 4], $$[$0 - 6]);
          break;
        case 102:
          yy.commit($$[$0 - 2], $$[$0], $$[$0 - 4], $$[$0 - 6]);
          break;
        case 103:
          yy.commit($$[$0 - 4], $$[$0 - 2], $$[$0], $$[$0 - 6]);
          break;
        case 104:
          yy.commit($$[$0 - 4], $$[$0], $$[$0 - 2], $$[$0 - 6]);
          break;
        case 105:
          yy.commit($$[$0 - 2], $$[$0 - 4], $$[$0 - 6], $$[$0]);
          break;
        case 106:
          yy.commit($$[$0], $$[$0 - 4], $$[$0 - 6], $$[$0 - 2]);
          break;
        case 107:
          yy.commit($$[$0 - 2], $$[$0], $$[$0 - 6], $$[$0 - 4]);
          break;
        case 108:
          yy.commit($$[$0], $$[$0 - 2], $$[$0 - 6], $$[$0 - 4]);
          break;
        case 109:
          yy.commit($$[$0 - 4], $$[$0 - 2], $$[$0 - 6], $$[$0]);
          break;
        case 110:
          yy.commit($$[$0 - 4], $$[$0], $$[$0 - 6], $$[$0 - 2]);
          break;
        case 111:
          this.$ = "";
          break;
        case 112:
          this.$ = $$[$0];
          break;
        case 113:
          this.$ = yy.commitType.NORMAL;
          break;
        case 114:
          this.$ = yy.commitType.REVERSE;
          break;
        case 115:
          this.$ = yy.commitType.HIGHLIGHT;
          break;
        case 118:
          yy.parseDirective("%%{", "open_directive");
          break;
        case 119:
          yy.parseDirective($$[$0], "type_directive");
          break;
        case 120:
          $$[$0] = $$[$0].trim().replace(/'/g, '"');
          yy.parseDirective($$[$0], "arg_directive");
          break;
        case 121:
          yy.parseDirective("}%%", "close_directive", "gitGraph");
          break;
      }
    },
    table: [{ 3: 1, 4: 2, 5: 3, 6: $V0, 8: $V1, 14: $V2, 46: 8, 50: $V3, 55: $V4 }, { 1: [3] }, { 3: 10, 4: 2, 5: 3, 6: $V0, 8: $V1, 14: $V2, 46: 8, 50: $V3, 55: $V4 }, { 3: 11, 4: 2, 5: 3, 6: $V0, 8: $V1, 14: $V2, 46: 8, 50: $V3, 55: $V4 }, { 7: 12, 8: $V5, 9: [1, 13], 10: [1, 14], 11: 15, 14: $V6 }, o($V7, [2, 124]), o($V7, [2, 125]), o($V7, [2, 126]), { 47: 17, 51: [1, 18] }, { 51: [2, 118] }, { 1: [2, 1] }, { 1: [2, 2] }, { 8: [1, 19] }, { 7: 20, 8: $V5, 11: 15, 14: $V6 }, { 9: [1, 21] }, o($V8, [2, 10], { 12: 22, 13: [1, 23] }), o($V9, [2, 9]), { 9: [1, 25], 48: 24, 53: $Va }, o([9, 53], [2, 119]), { 1: [2, 3] }, { 8: [1, 27] }, { 7: 28, 8: $V5, 11: 15, 14: $V6 }, { 8: [2, 7], 14: [1, 31], 15: 29, 16: 30, 17: 32, 18: 33, 19: 34, 20: [1, 35], 22: [1, 36], 24: [1, 37], 25: [1, 38], 26: 39, 27: [1, 40], 29: [1, 44], 32: [1, 43], 37: [1, 42], 40: [1, 41] }, o($V9, [2, 8]), o($Vb, [2, 116]), { 49: 45, 52: [1, 46] }, o($Vb, [2, 121]), { 1: [2, 4] }, { 8: [1, 47] }, o($V8, [2, 11]), { 4: 48, 8: $V1, 14: $V2, 55: $V4 }, o($V8, [2, 13]), o($Vc, [2, 14]), o($Vc, [2, 15]), o($Vc, [2, 16]), { 21: [1, 49] }, { 23: [1, 50] }, o($Vc, [2, 19]), o($Vc, [2, 20]), o($Vc, [2, 21]), { 28: 51, 34: $Vd, 54: $Ve }, o($Vc, [2, 111], { 41: 54, 33: [1, 57], 34: [1, 59], 35: [1, 55], 38: [1, 56], 42: [1, 58] }), { 28: 60, 34: $Vd, 54: $Ve }, { 33: [1, 61], 35: [1, 62] }, { 28: 63, 34: $Vd, 54: $Ve }, { 48: 64, 53: $Va }, { 53: [2, 120] }, { 1: [2, 5] }, o($V8, [2, 12]), o($Vc, [2, 17]), o($Vc, [2, 18]), o($Vc, [2, 22]), o($Vf, [2, 122]), o($Vf, [2, 123]), o($Vc, [2, 46]), { 34: [1, 65] }, { 39: 66, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 70] }, { 34: [1, 71] }, o($Vc, [2, 112]), o($Vc, [2, 30], { 33: [1, 72], 35: [1, 74], 38: [1, 73] }), { 34: [1, 75] }, { 34: [1, 76], 36: [1, 77] }, o($Vc, [2, 23], { 30: [1, 78] }), o($Vb, [2, 117]), o($Vc, [2, 47], { 33: [1, 80], 38: [1, 79], 42: [1, 81] }), o($Vc, [2, 48], { 33: [1, 83], 35: [1, 82], 42: [1, 84] }), o($Vj, [2, 113]), o($Vj, [2, 114]), o($Vj, [2, 115]), o($Vc, [2, 51], { 35: [1, 85], 38: [1, 86], 42: [1, 87] }), o($Vc, [2, 62], { 33: [1, 90], 35: [1, 88], 38: [1, 89] }), { 34: [1, 91] }, { 39: 92, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 93] }, o($Vc, [2, 25], { 35: [1, 94] }), { 33: [1, 95] }, { 33: [1, 96] }, { 31: [1, 97] }, { 39: 98, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 99] }, { 34: [1, 100] }, { 34: [1, 101] }, { 34: [1, 102] }, { 34: [1, 103] }, { 34: [1, 104] }, { 39: 105, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 106] }, { 34: [1, 107] }, { 39: 108, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 109] }, o($Vc, [2, 31], { 35: [1, 111], 38: [1, 110] }), o($Vc, [2, 32], { 33: [1, 113], 35: [1, 112] }), o($Vc, [2, 33], { 33: [1, 114], 38: [1, 115] }), { 34: [1, 116], 36: [1, 117] }, { 34: [1, 118] }, { 34: [1, 119] }, o($Vc, [2, 24]), o($Vc, [2, 49], { 33: [1, 120], 42: [1, 121] }), o($Vc, [2, 53], { 38: [1, 122], 42: [1, 123] }), o($Vc, [2, 63], { 33: [1, 125], 38: [1, 124] }), o($Vc, [2, 50], { 33: [1, 126], 42: [1, 127] }), o($Vc, [2, 55], { 35: [1, 128], 42: [1, 129] }), o($Vc, [2, 66], { 33: [1, 131], 35: [1, 130] }), o($Vc, [2, 52], { 38: [1, 132], 42: [1, 133] }), o($Vc, [2, 54], { 35: [1, 134], 42: [1, 135] }), o($Vc, [2, 67], { 35: [1, 137], 38: [1, 136] }), o($Vc, [2, 64], { 33: [1, 139], 38: [1, 138] }), o($Vc, [2, 65], { 33: [1, 141], 35: [1, 140] }), o($Vc, [2, 68], { 35: [1, 143], 38: [1, 142] }), { 39: 144, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 145] }, { 34: [1, 146] }, { 34: [1, 147] }, { 34: [1, 148] }, { 39: 149, 43: $Vg, 44: $Vh, 45: $Vi }, o($Vc, [2, 26]), o($Vc, [2, 27]), o($Vc, [2, 28]), o($Vc, [2, 29]), { 34: [1, 150] }, { 34: [1, 151] }, { 39: 152, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 153] }, { 39: 154, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 155] }, { 34: [1, 156] }, { 34: [1, 157] }, { 34: [1, 158] }, { 34: [1, 159] }, { 34: [1, 160] }, { 34: [1, 161] }, { 39: 162, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 163] }, { 34: [1, 164] }, { 34: [1, 165] }, { 39: 166, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 167] }, { 39: 168, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 169] }, { 34: [1, 170] }, { 34: [1, 171] }, { 39: 172, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 173] }, o($Vc, [2, 37], { 35: [1, 174] }), o($Vc, [2, 38], { 38: [1, 175] }), o($Vc, [2, 36], { 33: [1, 176] }), o($Vc, [2, 39], { 35: [1, 177] }), o($Vc, [2, 34], { 38: [1, 178] }), o($Vc, [2, 35], { 33: [1, 179] }), o($Vc, [2, 60], { 42: [1, 180] }), o($Vc, [2, 73], { 33: [1, 181] }), o($Vc, [2, 61], { 42: [1, 182] }), o($Vc, [2, 84], { 38: [1, 183] }), o($Vc, [2, 74], { 33: [1, 184] }), o($Vc, [2, 83], { 38: [1, 185] }), o($Vc, [2, 59], { 42: [1, 186] }), o($Vc, [2, 72], { 33: [1, 187] }), o($Vc, [2, 58], { 42: [1, 188] }), o($Vc, [2, 78], { 35: [1, 189] }), o($Vc, [2, 71], { 33: [1, 190] }), o($Vc, [2, 77], { 35: [1, 191] }), o($Vc, [2, 57], { 42: [1, 192] }), o($Vc, [2, 85], { 38: [1, 193] }), o($Vc, [2, 56], { 42: [1, 194] }), o($Vc, [2, 79], { 35: [1, 195] }), o($Vc, [2, 80], { 35: [1, 196] }), o($Vc, [2, 86], { 38: [1, 197] }), o($Vc, [2, 70], { 33: [1, 198] }), o($Vc, [2, 81], { 38: [1, 199] }), o($Vc, [2, 69], { 33: [1, 200] }), o($Vc, [2, 75], { 35: [1, 201] }), o($Vc, [2, 76], { 35: [1, 202] }), o($Vc, [2, 82], { 38: [1, 203] }), { 34: [1, 204] }, { 39: 205, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 206] }, { 34: [1, 207] }, { 39: 208, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 209] }, { 34: [1, 210] }, { 34: [1, 211] }, { 34: [1, 212] }, { 39: 213, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 214] }, { 39: 215, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 216] }, { 34: [1, 217] }, { 34: [1, 218] }, { 34: [1, 219] }, { 34: [1, 220] }, { 34: [1, 221] }, { 34: [1, 222] }, { 39: 223, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 224] }, { 34: [1, 225] }, { 34: [1, 226] }, { 39: 227, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 228] }, { 39: 229, 43: $Vg, 44: $Vh, 45: $Vi }, { 34: [1, 230] }, { 34: [1, 231] }, { 34: [1, 232] }, { 39: 233, 43: $Vg, 44: $Vh, 45: $Vi }, o($Vc, [2, 40]), o($Vc, [2, 42]), o($Vc, [2, 41]), o($Vc, [2, 43]), o($Vc, [2, 45]), o($Vc, [2, 44]), o($Vc, [2, 101]), o($Vc, [2, 102]), o($Vc, [2, 99]), o($Vc, [2, 100]), o($Vc, [2, 104]), o($Vc, [2, 103]), o($Vc, [2, 108]), o($Vc, [2, 107]), o($Vc, [2, 106]), o($Vc, [2, 105]), o($Vc, [2, 110]), o($Vc, [2, 109]), o($Vc, [2, 98]), o($Vc, [2, 97]), o($Vc, [2, 96]), o($Vc, [2, 95]), o($Vc, [2, 93]), o($Vc, [2, 94]), o($Vc, [2, 92]), o($Vc, [2, 91]), o($Vc, [2, 90]), o($Vc, [2, 89]), o($Vc, [2, 87]), o($Vc, [2, 88])],
    defaultActions: { 9: [2, 118], 10: [2, 1], 11: [2, 2], 19: [2, 3], 27: [2, 4], 46: [2, 120], 47: [2, 5] },
    parseError: function parseError(str2, hash) {
      if (hash.recoverable) {
        this.trace(str2);
      } else {
        var error = new Error(str2);
        error.hash = hash;
        throw error;
      }
    },
    parse: function parse2(input) {
      var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
      var args = lstack.slice.call(arguments, 1);
      var lexer2 = Object.create(this.lexer);
      var sharedState = { yy: {} };
      for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
          sharedState.yy[k] = this.yy[k];
        }
      }
      lexer2.setInput(input, sharedState.yy);
      sharedState.yy.lexer = lexer2;
      sharedState.yy.parser = this;
      if (typeof lexer2.yylloc == "undefined") {
        lexer2.yylloc = {};
      }
      var yyloc = lexer2.yylloc;
      lstack.push(yyloc);
      var ranges = lexer2.options && lexer2.options.ranges;
      if (typeof sharedState.yy.parseError === "function") {
        this.parseError = sharedState.yy.parseError;
      } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
      }
      function lex2() {
        var token;
        token = tstack.pop() || lexer2.lex() || EOF;
        if (typeof token !== "number") {
          if (token instanceof Array) {
            tstack = token;
            token = tstack.pop();
          }
          token = self.symbols_[token] || token;
        }
        return token;
      }
      var symbol, state, action, r, yyval = {}, p, len, newState, expected;
      while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
          action = this.defaultActions[state];
        } else {
          if (symbol === null || typeof symbol == "undefined") {
            symbol = lex2();
          }
          action = table[state] && table[state][symbol];
        }
        if (typeof action === "undefined" || !action.length || !action[0]) {
          var errStr = "";
          expected = [];
          for (p in table[state]) {
            if (this.terminals_[p] && p > TERROR) {
              expected.push("'" + this.terminals_[p] + "'");
            }
          }
          if (lexer2.showPosition) {
            errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
          } else {
            errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
          }
          this.parseError(errStr, {
            text: lexer2.match,
            token: this.terminals_[symbol] || symbol,
            line: lexer2.yylineno,
            loc: yyloc,
            expected
          });
        }
        if (action[0] instanceof Array && action.length > 1) {
          throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
        }
        switch (action[0]) {
          case 1:
            stack.push(symbol);
            vstack.push(lexer2.yytext);
            lstack.push(lexer2.yylloc);
            stack.push(action[1]);
            symbol = null;
            {
              yyleng = lexer2.yyleng;
              yytext = lexer2.yytext;
              yylineno = lexer2.yylineno;
              yyloc = lexer2.yylloc;
            }
            break;
          case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
              first_line: lstack[lstack.length - (len || 1)].first_line,
              last_line: lstack[lstack.length - 1].last_line,
              first_column: lstack[lstack.length - (len || 1)].first_column,
              last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
              yyval._$.range = [
                lstack[lstack.length - (len || 1)].range[0],
                lstack[lstack.length - 1].range[1]
              ];
            }
            r = this.performAction.apply(yyval, [
              yytext,
              yyleng,
              yylineno,
              sharedState.yy,
              action[1],
              vstack,
              lstack
            ].concat(args));
            if (typeof r !== "undefined") {
              return r;
            }
            if (len) {
              stack = stack.slice(0, -1 * len * 2);
              vstack = vstack.slice(0, -1 * len);
              lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
          case 3:
            return true;
        }
      }
      return true;
    }
  };
  var lexer = function() {
    var lexer2 = {
      EOF: 1,
      parseError: function parseError(str2, hash) {
        if (this.yy.parser) {
          this.yy.parser.parseError(str2, hash);
        } else {
          throw new Error(str2);
        }
      },
      // resets the lexer, sets new input
      setInput: function(input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = "";
        this.conditionStack = ["INITIAL"];
        this.yylloc = {
          first_line: 1,
          first_column: 0,
          last_line: 1,
          last_column: 0
        };
        if (this.options.ranges) {
          this.yylloc.range = [0, 0];
        }
        this.offset = 0;
        return this;
      },
      // consumes and returns one char from the input
      input: function() {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno++;
          this.yylloc.last_line++;
        } else {
          this.yylloc.last_column++;
        }
        if (this.options.ranges) {
          this.yylloc.range[1]++;
        }
        this._input = this._input.slice(1);
        return ch;
      },
      // unshifts one char (or a string) into the input
      unput: function(ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);
        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);
        if (lines.length - 1) {
          this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;
        this.yylloc = {
          first_line: this.yylloc.first_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.first_column,
          last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
        };
        if (this.options.ranges) {
          this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
      },
      // When called from action, caches matched text and appends it on next action
      more: function() {
        this._more = true;
        return this;
      },
      // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
      reject: function() {
        if (this.options.backtrack_lexer) {
          this._backtrack = true;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
        return this;
      },
      // retain first n characters of the match
      less: function(n) {
        this.unput(this.match.slice(n));
      },
      // displays already matched input, i.e. for error messages
      pastInput: function() {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
      },
      // displays upcoming input, i.e. for error messages
      upcomingInput: function() {
        var next = this.match;
        if (next.length < 20) {
          next += this._input.substr(0, 20 - next.length);
        }
        return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
      },
      // displays the character position where the lexing error occurred, i.e. for error messages
      showPosition: function() {
        var pre = this.pastInput();
        var c2 = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c2 + "^";
      },
      // test the lexed token: return FALSE when not a match, otherwise return token
      test_match: function(match, indexed_rule) {
        var token, lines, backup;
        if (this.options.backtrack_lexer) {
          backup = {
            yylineno: this.yylineno,
            yylloc: {
              first_line: this.yylloc.first_line,
              last_line: this.last_line,
              first_column: this.yylloc.first_column,
              last_column: this.yylloc.last_column
            },
            yytext: this.yytext,
            match: this.match,
            matches: this.matches,
            matched: this.matched,
            yyleng: this.yyleng,
            offset: this.offset,
            _more: this._more,
            _input: this._input,
            yy: this.yy,
            conditionStack: this.conditionStack.slice(0),
            done: this.done
          };
          if (this.options.ranges) {
            backup.yylloc.range = this.yylloc.range.slice(0);
          }
        }
        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno += lines.length;
        }
        this.yylloc = {
          first_line: this.yylloc.last_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.last_column,
          last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
          this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
          this.done = false;
        }
        if (token) {
          return token;
        } else if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
        return false;
      },
      // return next match in input
      next: function() {
        if (this.done) {
          return this.EOF;
        }
        if (!this._input) {
          this.done = true;
        }
        var token, match, tempMatch, index;
        if (!this._more) {
          this.yytext = "";
          this.match = "";
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
          tempMatch = this._input.match(this.rules[rules[i]]);
          if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
            match = tempMatch;
            index = i;
            if (this.options.backtrack_lexer) {
              token = this.test_match(tempMatch, rules[i]);
              if (token !== false) {
                return token;
              } else if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            } else if (!this.options.flex) {
              break;
            }
          }
        }
        if (match) {
          token = this.test_match(match, rules[index]);
          if (token !== false) {
            return token;
          }
          return false;
        }
        if (this._input === "") {
          return this.EOF;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
      },
      // return next match that has a token
      lex: function lex2() {
        var r = this.next();
        if (r) {
          return r;
        } else {
          return this.lex();
        }
      },
      // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
      begin: function begin(condition) {
        this.conditionStack.push(condition);
      },
      // pop the previously active lexer condition state off the condition stack
      popState: function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
          return this.conditionStack.pop();
        } else {
          return this.conditionStack[0];
        }
      },
      // produce the lexer rule set which is active for the currently active lexer condition state
      _currentRules: function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
          return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
          return this.conditions["INITIAL"].rules;
        }
      },
      // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
      topState: function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
          return this.conditionStack[n];
        } else {
          return "INITIAL";
        }
      },
      // alias for begin(condition)
      pushState: function pushState(condition) {
        this.begin(condition);
      },
      // return the number of states currently on the stack
      stateStackSize: function stateStackSize() {
        return this.conditionStack.length;
      },
      options: { "case-insensitive": true },
      performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
        switch ($avoiding_name_collisions) {
          case 0:
            this.begin("open_directive");
            return 50;
          case 1:
            this.begin("type_directive");
            return 51;
          case 2:
            this.popState();
            this.begin("arg_directive");
            return 9;
          case 3:
            this.popState();
            this.popState();
            return 53;
          case 4:
            return 52;
          case 5:
            this.begin("acc_title");
            return 20;
          case 6:
            this.popState();
            return "acc_title_value";
          case 7:
            this.begin("acc_descr");
            return 22;
          case 8:
            this.popState();
            return "acc_descr_value";
          case 9:
            this.begin("acc_descr_multiline");
            break;
          case 10:
            this.popState();
            break;
          case 11:
            return "acc_descr_multiline_value";
          case 12:
            return 14;
          case 13:
            break;
          case 14:
            break;
          case 15:
            return 6;
          case 16:
            return 40;
          case 17:
            return 33;
          case 18:
            return 38;
          case 19:
            return 42;
          case 20:
            return 43;
          case 21:
            return 44;
          case 22:
            return 45;
          case 23:
            return 35;
          case 24:
            return 29;
          case 25:
            return 30;
          case 26:
            return 37;
          case 27:
            return 32;
          case 28:
            return 27;
          case 29:
            return 10;
          case 30:
            return 10;
          case 31:
            return 9;
          case 32:
            return "CARET";
          case 33:
            this.begin("options");
            break;
          case 34:
            this.popState();
            break;
          case 35:
            return 13;
          case 36:
            return 36;
          case 37:
            this.begin("string");
            break;
          case 38:
            this.popState();
            break;
          case 39:
            return 34;
          case 40:
            return 31;
          case 41:
            return 54;
          case 42:
            return 8;
        }
      },
      rules: [/^(?:%%\{)/i, /^(?:((?:(?!\}%%)[^:.])*))/i, /^(?::)/i, /^(?:\}%%)/i, /^(?:((?:(?!\}%%).|\n)*))/i, /^(?:accTitle\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*\{\s*)/i, /^(?:[\}])/i, /^(?:[^\}]*)/i, /^(?:(\r?\n)+)/i, /^(?:#[^\n]*)/i, /^(?:%[^\n]*)/i, /^(?:gitGraph\b)/i, /^(?:commit(?=\s|$))/i, /^(?:id:)/i, /^(?:type:)/i, /^(?:msg:)/i, /^(?:NORMAL\b)/i, /^(?:REVERSE\b)/i, /^(?:HIGHLIGHT\b)/i, /^(?:tag:)/i, /^(?:branch(?=\s|$))/i, /^(?:order:)/i, /^(?:merge(?=\s|$))/i, /^(?:cherry-pick(?=\s|$))/i, /^(?:checkout(?=\s|$))/i, /^(?:LR\b)/i, /^(?:BT\b)/i, /^(?::)/i, /^(?:\^)/i, /^(?:options\r?\n)/i, /^(?:[ \r\n\t]+end\b)/i, /^(?:[\s\S]+(?=[ \r\n\t]+end))/i, /^(?:["]["])/i, /^(?:["])/i, /^(?:["])/i, /^(?:[^"]*)/i, /^(?:[0-9]+(?=\s|$))/i, /^(?:\w([-\./\w]*[-\w])?)/i, /^(?:$)/i, /^(?:\s+)/i],
      conditions: { "acc_descr_multiline": { "rules": [10, 11], "inclusive": false }, "acc_descr": { "rules": [8], "inclusive": false }, "acc_title": { "rules": [6], "inclusive": false }, "close_directive": { "rules": [], "inclusive": false }, "arg_directive": { "rules": [3, 4], "inclusive": false }, "type_directive": { "rules": [2, 3], "inclusive": false }, "open_directive": { "rules": [1], "inclusive": false }, "options": { "rules": [34, 35], "inclusive": false }, "string": { "rules": [38, 39], "inclusive": false }, "INITIAL": { "rules": [0, 5, 7, 9, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 36, 37, 40, 41, 42, 43], "inclusive": true } }
    };
    return lexer2;
  }();
  parser2.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  Parser.prototype = parser2;
  parser2.Parser = Parser;
  return new Parser();
}();
parser$c.parser = parser$c;
const gitGraphParser = parser$c;
const gitGraphDetector = (txt) => {
  return txt.match(/^\s*gitGraph/) !== null;
};
let mainBranchName = getConfig$1().gitGraph.mainBranchName;
let mainBranchOrder = getConfig$1().gitGraph.mainBranchOrder;
let commits = {};
let head = null;
let branchesConfig = {};
branchesConfig[mainBranchName] = { name: mainBranchName, order: mainBranchOrder };
let branches = {};
branches[mainBranchName] = head;
let curBranch = mainBranchName;
let direction$3 = "LR";
let seq = 0;
function getId() {
  return random({ length: 7 });
}
const parseDirective$a = function(statement, context, type2) {
  mermaidAPI.parseDirective(this, statement, context, type2);
};
function uniqBy(list, fn) {
  const recordMap = /* @__PURE__ */ Object.create(null);
  return list.reduce((out, item) => {
    const key = fn(item);
    if (!recordMap[key]) {
      recordMap[key] = true;
      out.push(item);
    }
    return out;
  }, []);
}
const setDirection$3 = function(dir) {
  direction$3 = dir;
};
let options = {};
const setOptions = function(rawOptString) {
  log$1.debug("options str", rawOptString);
  rawOptString = rawOptString && rawOptString.trim();
  rawOptString = rawOptString || "{}";
  try {
    options = JSON.parse(rawOptString);
  } catch (e) {
    log$1.error("error while parsing gitGraph options", e.message);
  }
};
const getOptions = function() {
  return options;
};
const commit = function(msg, id2, type2, tag) {
  log$1.debug("Entering commit:", msg, id2, type2, tag);
  id2 = common$1.sanitizeText(id2, getConfig$1());
  msg = common$1.sanitizeText(msg, getConfig$1());
  tag = common$1.sanitizeText(tag, getConfig$1());
  const commit2 = {
    id: id2 ? id2 : seq + "-" + getId(),
    message: msg,
    seq: seq++,
    type: type2 ? type2 : commitType$1.NORMAL,
    tag: tag ? tag : "",
    parents: head == null ? [] : [head.id],
    branch: curBranch
  };
  head = commit2;
  commits[commit2.id] = commit2;
  branches[curBranch] = commit2.id;
  log$1.debug("in pushCommit " + commit2.id);
};
const branch = function(name, order) {
  name = common$1.sanitizeText(name, getConfig$1());
  if (branches[name] === void 0) {
    branches[name] = head != null ? head.id : null;
    branchesConfig[name] = { name, order: order ? parseInt(order, 10) : null };
    checkout(name);
    log$1.debug("in createBranch");
  } else {
    let error = new Error(
      'Trying to create an existing branch. (Help: Either use a new name if you want create a new branch or try using "checkout ' + name + '")'
    );
    error.hash = {
      text: "branch " + name,
      token: "branch " + name,
      line: "1",
      loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
      expected: ['"checkout ' + name + '"']
    };
    throw error;
  }
};
const merge = function(otherBranch, custom_id, override_type, custom_tag) {
  otherBranch = common$1.sanitizeText(otherBranch, getConfig$1());
  custom_id = common$1.sanitizeText(custom_id, getConfig$1());
  const currentCommit = commits[branches[curBranch]];
  const otherCommit = commits[branches[otherBranch]];
  if (curBranch === otherBranch) {
    let error = new Error('Incorrect usage of "merge". Cannot merge a branch to itself');
    error.hash = {
      text: "merge " + otherBranch,
      token: "merge " + otherBranch,
      line: "1",
      loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
      expected: ["branch abc"]
    };
    throw error;
  } else if (currentCommit === void 0 || !currentCommit) {
    let error = new Error(
      'Incorrect usage of "merge". Current branch (' + curBranch + ")has no commits"
    );
    error.hash = {
      text: "merge " + otherBranch,
      token: "merge " + otherBranch,
      line: "1",
      loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
      expected: ["commit"]
    };
    throw error;
  } else if (branches[otherBranch] === void 0) {
    let error = new Error(
      'Incorrect usage of "merge". Branch to be merged (' + otherBranch + ") does not exist"
    );
    error.hash = {
      text: "merge " + otherBranch,
      token: "merge " + otherBranch,
      line: "1",
      loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
      expected: ["branch " + otherBranch]
    };
    throw error;
  } else if (otherCommit === void 0 || !otherCommit) {
    let error = new Error(
      'Incorrect usage of "merge". Branch to be merged (' + otherBranch + ") has no commits"
    );
    error.hash = {
      text: "merge " + otherBranch,
      token: "merge " + otherBranch,
      line: "1",
      loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
      expected: ['"commit"']
    };
    throw error;
  } else if (currentCommit === otherCommit) {
    let error = new Error('Incorrect usage of "merge". Both branches have same head');
    error.hash = {
      text: "merge " + otherBranch,
      token: "merge " + otherBranch,
      line: "1",
      loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
      expected: ["branch abc"]
    };
    throw error;
  } else if (custom_id && commits[custom_id] !== void 0) {
    let error = new Error(
      'Incorrect usage of "merge". Commit with id:' + custom_id + " already exists, use different custom Id"
    );
    error.hash = {
      text: "merge " + otherBranch + custom_id + override_type + custom_tag,
      token: "merge " + otherBranch + custom_id + override_type + custom_tag,
      line: "1",
      loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
      expected: [
        "merge " + otherBranch + " " + custom_id + "_UNIQUE " + override_type + " " + custom_tag
      ]
    };
    throw error;
  }
  const commit2 = {
    id: custom_id ? custom_id : seq + "-" + getId(),
    message: "merged branch " + otherBranch + " into " + curBranch,
    seq: seq++,
    parents: [head == null ? null : head.id, branches[otherBranch]],
    branch: curBranch,
    type: commitType$1.MERGE,
    customType: override_type,
    customId: custom_id ? true : false,
    tag: custom_tag ? custom_tag : ""
  };
  head = commit2;
  commits[commit2.id] = commit2;
  branches[curBranch] = commit2.id;
  log$1.debug(branches);
  log$1.debug("in mergeBranch");
};
const cherryPick = function(sourceId, targetId, tag) {
  log$1.debug("Entering cherryPick:", sourceId, targetId, tag);
  sourceId = common$1.sanitizeText(sourceId, getConfig$1());
  targetId = common$1.sanitizeText(targetId, getConfig$1());
  tag = common$1.sanitizeText(tag, getConfig$1());
  if (!sourceId || commits[sourceId] === void 0) {
    let error = new Error(
      'Incorrect usage of "cherryPick". Source commit id should exist and provided'
    );
    error.hash = {
      text: "cherryPick " + sourceId + " " + targetId,
      token: "cherryPick " + sourceId + " " + targetId,
      line: "1",
      loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
      expected: ["cherry-pick abc"]
    };
    throw error;
  }
  let sourceCommit = commits[sourceId];
  let sourceCommitBranch = sourceCommit.branch;
  if (sourceCommit.type === commitType$1.MERGE) {
    let error = new Error(
      'Incorrect usage of "cherryPick". Source commit should not be a merge commit'
    );
    error.hash = {
      text: "cherryPick " + sourceId + " " + targetId,
      token: "cherryPick " + sourceId + " " + targetId,
      line: "1",
      loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
      expected: ["cherry-pick abc"]
    };
    throw error;
  }
  if (!targetId || commits[targetId] === void 0) {
    if (sourceCommitBranch === curBranch) {
      let error = new Error(
        'Incorrect usage of "cherryPick". Source commit is already on current branch'
      );
      error.hash = {
        text: "cherryPick " + sourceId + " " + targetId,
        token: "cherryPick " + sourceId + " " + targetId,
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: ["cherry-pick abc"]
      };
      throw error;
    }
    const currentCommit = commits[branches[curBranch]];
    if (currentCommit === void 0 || !currentCommit) {
      let error = new Error(
        'Incorrect usage of "cherry-pick". Current branch (' + curBranch + ")has no commits"
      );
      error.hash = {
        text: "cherryPick " + sourceId + " " + targetId,
        token: "cherryPick " + sourceId + " " + targetId,
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: ["cherry-pick abc"]
      };
      throw error;
    }
    const commit2 = {
      id: seq + "-" + getId(),
      message: "cherry-picked " + sourceCommit + " into " + curBranch,
      seq: seq++,
      parents: [head == null ? null : head.id, sourceCommit.id],
      branch: curBranch,
      type: commitType$1.CHERRY_PICK,
      tag: tag ?? "cherry-pick:" + sourceCommit.id
    };
    head = commit2;
    commits[commit2.id] = commit2;
    branches[curBranch] = commit2.id;
    log$1.debug(branches);
    log$1.debug("in cherryPick");
  }
};
const checkout = function(branch2) {
  branch2 = common$1.sanitizeText(branch2, getConfig$1());
  if (branches[branch2] === void 0) {
    let error = new Error(
      'Trying to checkout branch which is not yet created. (Help try using "branch ' + branch2 + '")'
    );
    error.hash = {
      text: "checkout " + branch2,
      token: "checkout " + branch2,
      line: "1",
      loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
      expected: ['"branch ' + branch2 + '"']
    };
    throw error;
  } else {
    curBranch = branch2;
    const id2 = branches[curBranch];
    head = commits[id2];
  }
};
function upsert(arr, key, newVal) {
  const index = arr.indexOf(key);
  if (index === -1) {
    arr.push(newVal);
  } else {
    arr.splice(index, 1, newVal);
  }
}
function prettyPrintCommitHistory(commitArr) {
  const commit2 = commitArr.reduce((out, commit3) => {
    if (out.seq > commit3.seq) {
      return out;
    }
    return commit3;
  }, commitArr[0]);
  let line2 = "";
  commitArr.forEach(function(c2) {
    if (c2 === commit2) {
      line2 += "	*";
    } else {
      line2 += "	|";
    }
  });
  const label = [line2, commit2.id, commit2.seq];
  for (let branch2 in branches) {
    if (branches[branch2] === commit2.id) {
      label.push(branch2);
    }
  }
  log$1.debug(label.join(" "));
  if (commit2.parents && commit2.parents.length == 2) {
    const newCommit = commits[commit2.parents[0]];
    upsert(commitArr, commit2, newCommit);
    commitArr.push(commits[commit2.parents[1]]);
  } else if (commit2.parents.length == 0) {
    return;
  } else {
    const nextCommit = commits[commit2.parents];
    upsert(commitArr, commit2, nextCommit);
  }
  commitArr = uniqBy(commitArr, (c2) => c2.id);
  prettyPrintCommitHistory(commitArr);
}
const prettyPrint = function() {
  log$1.debug(commits);
  const node = getCommitsArray()[0];
  prettyPrintCommitHistory([node]);
};
const clear$f = function() {
  commits = {};
  head = null;
  let mainBranch = getConfig$1().gitGraph.mainBranchName;
  let mainBranchOrder2 = getConfig$1().gitGraph.mainBranchOrder;
  branches = {};
  branches[mainBranch] = null;
  branchesConfig = {};
  branchesConfig[mainBranch] = { name: mainBranch, order: mainBranchOrder2 };
  curBranch = mainBranch;
  seq = 0;
  clear$g();
};
const getBranchesAsObjArray = function() {
  const branchesArray = Object.values(branchesConfig).map((branchConfig, i) => {
    if (branchConfig.order !== null) {
      return branchConfig;
    }
    return {
      ...branchConfig,
      order: parseFloat(`0.${i}`, 10)
    };
  }).sort((a, b) => a.order - b.order).map(({ name }) => ({ name }));
  return branchesArray;
};
const getBranches = function() {
  return branches;
};
const getCommits = function() {
  return commits;
};
const getCommitsArray = function() {
  const commitArr = Object.keys(commits).map(function(key) {
    return commits[key];
  });
  commitArr.forEach(function(o) {
    log$1.debug(o.id);
  });
  commitArr.sort((a, b) => a.seq - b.seq);
  return commitArr;
};
const getCurrentBranch = function() {
  return curBranch;
};
const getDirection$3 = function() {
  return direction$3;
};
const getHead = function() {
  return head;
};
const commitType$1 = {
  NORMAL: 0,
  REVERSE: 1,
  HIGHLIGHT: 2,
  MERGE: 3,
  CHERRY_PICK: 4
};
const gitGraphDb = {
  parseDirective: parseDirective$a,
  getConfig: () => getConfig$1().gitGraph,
  setDirection: setDirection$3,
  setOptions,
  getOptions,
  commit,
  branch,
  merge,
  cherryPick,
  checkout,
  //reset,
  prettyPrint,
  clear: clear$f,
  getBranchesAsObjArray,
  getBranches,
  getCommits,
  getCommitsArray,
  getCurrentBranch,
  getDirection: getDirection$3,
  getHead,
  setAccTitle,
  getAccTitle,
  getAccDescription,
  setAccDescription,
  setDiagramTitle,
  getDiagramTitle,
  commitType: commitType$1
};
let allCommitsDict = {};
const commitType = {
  NORMAL: 0,
  REVERSE: 1,
  HIGHLIGHT: 2,
  MERGE: 3,
  CHERRY_PICK: 4
};
const THEME_COLOR_LIMIT = 8;
let branchPos = {};
let commitPos = {};
let lanes = [];
let maxPos = 0;
const clear$e = () => {
  branchPos = {};
  commitPos = {};
  allCommitsDict = {};
  maxPos = 0;
  lanes = [];
};
const drawText$2 = (txt) => {
  const svgLabel = document.createElementNS("http://www.w3.org/2000/svg", "text");
  let rows = [];
  if (typeof txt === "string") {
    rows = txt.split(/\\n|\n|<br\s*\/?>/gi);
  } else if (Array.isArray(txt)) {
    rows = txt;
  } else {
    rows = [];
  }
  for (const row of rows) {
    const tspan = document.createElementNS("http://www.w3.org/2000/svg", "tspan");
    tspan.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
    tspan.setAttribute("dy", "1em");
    tspan.setAttribute("x", "0");
    tspan.setAttribute("class", "row");
    tspan.textContent = row.trim();
    svgLabel.appendChild(tspan);
  }
  return svgLabel;
};
const drawCommits = (svg, commits2, modifyGraph) => {
  const gitGraphConfig = getConfig().gitGraph;
  const gBullets = svg.append("g").attr("class", "commit-bullets");
  const gLabels = svg.append("g").attr("class", "commit-labels");
  let pos = 0;
  const keys2 = Object.keys(commits2);
  const sortedKeys = keys2.sort((a, b) => {
    return commits2[a].seq - commits2[b].seq;
  });
  sortedKeys.forEach((key) => {
    const commit2 = commits2[key];
    const y = branchPos[commit2.branch].pos;
    const x = pos + 10;
    if (modifyGraph) {
      let typeClass;
      let commitSymbolType = commit2.customType !== void 0 && commit2.customType !== "" ? commit2.customType : commit2.type;
      switch (commitSymbolType) {
        case commitType.NORMAL:
          typeClass = "commit-normal";
          break;
        case commitType.REVERSE:
          typeClass = "commit-reverse";
          break;
        case commitType.HIGHLIGHT:
          typeClass = "commit-highlight";
          break;
        case commitType.MERGE:
          typeClass = "commit-merge";
          break;
        case commitType.CHERRY_PICK:
          typeClass = "commit-cherry-pick";
          break;
        default:
          typeClass = "commit-normal";
      }
      if (commitSymbolType === commitType.HIGHLIGHT) {
        const circle2 = gBullets.append("rect");
        circle2.attr("x", x - 10);
        circle2.attr("y", y - 10);
        circle2.attr("height", 20);
        circle2.attr("width", 20);
        circle2.attr(
          "class",
          `commit ${commit2.id} commit-highlight${branchPos[commit2.branch].index % THEME_COLOR_LIMIT} ${typeClass}-outer`
        );
        gBullets.append("rect").attr("x", x - 6).attr("y", y - 6).attr("height", 12).attr("width", 12).attr(
          "class",
          `commit ${commit2.id} commit${branchPos[commit2.branch].index % THEME_COLOR_LIMIT} ${typeClass}-inner`
        );
      } else if (commitSymbolType === commitType.CHERRY_PICK) {
        gBullets.append("circle").attr("cx", x).attr("cy", y).attr("r", 10).attr("class", `commit ${commit2.id} ${typeClass}`);
        gBullets.append("circle").attr("cx", x - 3).attr("cy", y + 2).attr("r", 2.75).attr("fill", "#fff").attr("class", `commit ${commit2.id} ${typeClass}`);
        gBullets.append("circle").attr("cx", x + 3).attr("cy", y + 2).attr("r", 2.75).attr("fill", "#fff").attr("class", `commit ${commit2.id} ${typeClass}`);
        gBullets.append("line").attr("x1", x + 3).attr("y1", y + 1).attr("x2", x).attr("y2", y - 5).attr("stroke", "#fff").attr("class", `commit ${commit2.id} ${typeClass}`);
        gBullets.append("line").attr("x1", x - 3).attr("y1", y + 1).attr("x2", x).attr("y2", y - 5).attr("stroke", "#fff").attr("class", `commit ${commit2.id} ${typeClass}`);
      } else {
        const circle2 = gBullets.append("circle");
        circle2.attr("cx", x);
        circle2.attr("cy", y);
        circle2.attr("r", commit2.type === commitType.MERGE ? 9 : 10);
        circle2.attr(
          "class",
          `commit ${commit2.id} commit${branchPos[commit2.branch].index % THEME_COLOR_LIMIT}`
        );
        if (commitSymbolType === commitType.MERGE) {
          const circle22 = gBullets.append("circle");
          circle22.attr("cx", x);
          circle22.attr("cy", y);
          circle22.attr("r", 6);
          circle22.attr(
            "class",
            `commit ${typeClass} ${commit2.id} commit${branchPos[commit2.branch].index % THEME_COLOR_LIMIT}`
          );
        }
        if (commitSymbolType === commitType.REVERSE) {
          const cross2 = gBullets.append("path");
          cross2.attr("d", `M ${x - 5},${y - 5}L${x + 5},${y + 5}M${x - 5},${y + 5}L${x + 5},${y - 5}`).attr(
            "class",
            `commit ${typeClass} ${commit2.id} commit${branchPos[commit2.branch].index % THEME_COLOR_LIMIT}`
          );
        }
      }
    }
    commitPos[commit2.id] = { x: pos + 10, y };
    if (modifyGraph) {
      const px = 4;
      const py = 2;
      if (commit2.type !== commitType.CHERRY_PICK && (commit2.customId && commit2.type === commitType.MERGE || commit2.type !== commitType.MERGE) && gitGraphConfig.showCommitLabel) {
        const wrapper = gLabels.append("g");
        const labelBkg = wrapper.insert("rect").attr("class", "commit-label-bkg");
        const text = wrapper.append("text").attr("x", pos).attr("y", y + 25).attr("class", "commit-label").text(commit2.id);
        let bbox = text.node().getBBox();
        labelBkg.attr("x", pos + 10 - bbox.width / 2 - py).attr("y", y + 13.5).attr("width", bbox.width + 2 * py).attr("height", bbox.height + 2 * py);
        text.attr("x", pos + 10 - bbox.width / 2);
        if (gitGraphConfig.rotateCommitLabel) {
          let r_x = -7.5 - (bbox.width + 10) / 25 * 9.5;
          let r_y = 10 + bbox.width / 25 * 8.5;
          wrapper.attr(
            "transform",
            "translate(" + r_x + ", " + r_y + ") rotate(" + -45 + ", " + pos + ", " + y + ")"
          );
        }
      }
      if (commit2.tag) {
        const rect2 = gLabels.insert("polygon");
        const hole = gLabels.append("circle");
        const tag = gLabels.append("text").attr("y", y - 16).attr("class", "tag-label").text(commit2.tag);
        let tagBbox = tag.node().getBBox();
        tag.attr("x", pos + 10 - tagBbox.width / 2);
        const h2 = tagBbox.height / 2;
        const ly = y - 19.2;
        rect2.attr("class", "tag-label-bkg").attr(
          "points",
          `
          ${pos - tagBbox.width / 2 - px / 2},${ly + py}
          ${pos - tagBbox.width / 2 - px / 2},${ly - py}
          ${pos + 10 - tagBbox.width / 2 - px},${ly - h2 - py}
          ${pos + 10 + tagBbox.width / 2 + px},${ly - h2 - py}
          ${pos + 10 + tagBbox.width / 2 + px},${ly + h2 + py}
          ${pos + 10 - tagBbox.width / 2 - px},${ly + h2 + py}`
        );
        hole.attr("cx", pos - tagBbox.width / 2 + px / 2).attr("cy", ly).attr("r", 1.5).attr("class", "tag-hole");
      }
    }
    pos += 50;
    if (pos > maxPos) {
      maxPos = pos;
    }
  });
};
const hasOverlappingCommits = (commit1, commit2, allCommits) => {
  const keys2 = Object.keys(allCommits);
  const overlappingComits = keys2.filter((key) => {
    return allCommits[key].branch === commit2.branch && allCommits[key].seq > commit1.seq && allCommits[key].seq < commit2.seq;
  });
  return overlappingComits.length > 0;
};
const findLane = (y1, y2, depth = 0) => {
  const candidate = y1 + Math.abs(y1 - y2) / 2;
  if (depth > 5) {
    return candidate;
  }
  let ok = lanes.every((lane) => Math.abs(lane - candidate) >= 10);
  if (ok) {
    lanes.push(candidate);
    return candidate;
  }
  const diff = Math.abs(y1 - y2);
  return findLane(y1, y2 - diff / 5, depth + 1);
};
const drawArrow = (svg, commit1, commit2, allCommits) => {
  const p1 = commitPos[commit1.id];
  const p2 = commitPos[commit2.id];
  const overlappingCommits = hasOverlappingCommits(commit1, commit2, allCommits);
  let arc2 = "";
  let arc22 = "";
  let radius = 0;
  let offset = 0;
  let colorClassNum = branchPos[commit2.branch].index;
  let lineDef;
  if (overlappingCommits) {
    arc2 = "A 10 10, 0, 0, 0,";
    arc22 = "A 10 10, 0, 0, 1,";
    radius = 10;
    offset = 10;
    colorClassNum = branchPos[commit2.branch].index;
    const lineY = p1.y < p2.y ? findLane(p1.y, p2.y) : findLane(p2.y, p1.y);
    if (p1.y < p2.y) {
      lineDef = `M ${p1.x} ${p1.y} L ${p1.x} ${lineY - radius} ${arc2} ${p1.x + offset} ${lineY} L ${p2.x - radius} ${lineY} ${arc22} ${p2.x} ${lineY + offset} L ${p2.x} ${p2.y}`;
    } else {
      lineDef = `M ${p1.x} ${p1.y} L ${p1.x} ${lineY + radius} ${arc22} ${p1.x + offset} ${lineY} L ${p2.x - radius} ${lineY} ${arc2} ${p2.x} ${lineY - offset} L ${p2.x} ${p2.y}`;
    }
  } else {
    if (p1.y < p2.y) {
      arc2 = "A 20 20, 0, 0, 0,";
      radius = 20;
      offset = 20;
      colorClassNum = branchPos[commit2.branch].index;
      lineDef = `M ${p1.x} ${p1.y} L ${p1.x} ${p2.y - radius} ${arc2} ${p1.x + offset} ${p2.y} L ${p2.x} ${p2.y}`;
    }
    if (p1.y > p2.y) {
      arc2 = "A 20 20, 0, 0, 0,";
      radius = 20;
      offset = 20;
      colorClassNum = branchPos[commit1.branch].index;
      lineDef = `M ${p1.x} ${p1.y} L ${p2.x - radius} ${p1.y} ${arc2} ${p2.x} ${p1.y - offset} L ${p2.x} ${p2.y}`;
    }
    if (p1.y === p2.y) {
      colorClassNum = branchPos[commit1.branch].index;
      lineDef = `M ${p1.x} ${p1.y} L ${p1.x} ${p2.y - radius} ${arc2} ${p1.x + offset} ${p2.y} L ${p2.x} ${p2.y}`;
    }
  }
  svg.append("path").attr("d", lineDef).attr("class", "arrow arrow" + colorClassNum % THEME_COLOR_LIMIT);
};
const drawArrows = (svg, commits2) => {
  const gArrows = svg.append("g").attr("class", "commit-arrows");
  Object.keys(commits2).forEach((key) => {
    const commit2 = commits2[key];
    if (commit2.parents && commit2.parents.length > 0) {
      commit2.parents.forEach((parent) => {
        drawArrow(gArrows, commits2[parent], commit2, commits2);
      });
    }
  });
};
const drawBranches = (svg, branches2) => {
  const gitGraphConfig = getConfig().gitGraph;
  const g = svg.append("g");
  branches2.forEach((branch2, index) => {
    const adjustIndexForTheme = index % THEME_COLOR_LIMIT;
    const pos = branchPos[branch2.name].pos;
    const line2 = g.append("line");
    line2.attr("x1", 0);
    line2.attr("y1", pos);
    line2.attr("x2", maxPos);
    line2.attr("y2", pos);
    line2.attr("class", "branch branch" + adjustIndexForTheme);
    lanes.push(pos);
    let name = branch2.name;
    const labelElement = drawText$2(name);
    const bkg = g.insert("rect");
    const branchLabel = g.insert("g").attr("class", "branchLabel");
    const label = branchLabel.insert("g").attr("class", "label branch-label" + adjustIndexForTheme);
    label.node().appendChild(labelElement);
    let bbox = labelElement.getBBox();
    bkg.attr("class", "branchLabelBkg label" + adjustIndexForTheme).attr("rx", 4).attr("ry", 4).attr("x", -bbox.width - 4 - (gitGraphConfig.rotateCommitLabel === true ? 30 : 0)).attr("y", -bbox.height / 2 + 8).attr("width", bbox.width + 18).attr("height", bbox.height + 4);
    label.attr(
      "transform",
      "translate(" + (-bbox.width - 14 - (gitGraphConfig.rotateCommitLabel === true ? 30 : 0)) + ", " + (pos - bbox.height / 2 - 1) + ")"
    );
    bkg.attr("transform", "translate(" + -19 + ", " + (pos - bbox.height / 2) + ")");
  });
};
const draw$f = function(txt, id2, ver, diagObj) {
  clear$e();
  const conf2 = getConfig();
  const gitGraphConfig = conf2.gitGraph;
  log$1.debug("in gitgraph renderer", txt + "\n", "id:", id2, ver);
  allCommitsDict = diagObj.db.getCommits();
  const branches2 = diagObj.db.getBranchesAsObjArray();
  let pos = 0;
  branches2.forEach((branch2, index) => {
    branchPos[branch2.name] = { pos, index };
    pos += 50 + (gitGraphConfig.rotateCommitLabel ? 40 : 0);
  });
  const diagram = select(`[id="${id2}"]`);
  drawCommits(diagram, allCommitsDict, false);
  if (gitGraphConfig.showBranches) {
    drawBranches(diagram, branches2);
  }
  drawArrows(diagram, allCommitsDict);
  drawCommits(diagram, allCommitsDict, true);
  utils.insertTitle(
    diagram,
    "gitTitleText",
    gitGraphConfig.titleTopMargin,
    diagObj.db.getDiagramTitle()
  );
  setupGraphViewbox(
    void 0,
    diagram,
    gitGraphConfig.diagramPadding,
    gitGraphConfig.useMaxWidth ?? conf2.useMaxWidth
  );
};
const gitGraphRenderer = {
  draw: draw$f
};
const getStyles = (options2) => `
  .commit-id,
  .commit-msg,
  .branch-label {
    fill: lightgrey;
    color: lightgrey;
    font-family: 'trebuchet ms', verdana, arial, sans-serif;
    font-family: var(--mermaid-font-family);
  }
  ${[0, 1, 2, 3, 4, 5, 6, 7].map(
  (i) => `
        .branch-label${i} { fill: ${options2["gitBranchLabel" + i]}; }
        .commit${i} { stroke: ${options2["git" + i]}; fill: ${options2["git" + i]}; }
        .commit-highlight${i} { stroke: ${options2["gitInv" + i]}; fill: ${options2["gitInv" + i]}; }
        .label${i}  { fill: ${options2["git" + i]}; }
        .arrow${i} { stroke: ${options2["git" + i]}; }
        `
).join("\n")}

  .branch {
    stroke-width: 1;
    stroke: ${options2.lineColor};
    stroke-dasharray: 2;
  }
  .commit-label { font-size: ${options2.commitLabelFontSize}; fill: ${options2.commitLabelColor};}
  .commit-label-bkg { font-size: ${options2.commitLabelFontSize}; fill: ${options2.commitLabelBackground}; opacity: 0.5; }
  .tag-label { font-size: ${options2.tagLabelFontSize}; fill: ${options2.tagLabelColor};}
  .tag-label-bkg { fill: ${options2.tagLabelBackground}; stroke: ${options2.tagLabelBorder}; }
  .tag-hole { fill: ${options2.textColor}; }

  .commit-merge {
    stroke: ${options2.primaryColor};
    fill: ${options2.primaryColor};
  }
  .commit-reverse {
    stroke: ${options2.primaryColor};
    fill: ${options2.primaryColor};
    stroke-width: 3;
  }
  .commit-highlight-outer {
  }
  .commit-highlight-inner {
    stroke: ${options2.primaryColor};
    fill: ${options2.primaryColor};
  }

  .arrow { stroke-width: 8; stroke-linecap: round; fill: none}
  .gitTitleText {
    text-anchor: middle;
    font-size: 18px;
    fill: ${options2.textColor};
  }
  }
`;
const gitGraphStyles = getStyles;
var parser$b = function() {
  var o = function(k, v, o2, l) {
    for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
      ;
    return o2;
  }, $V0 = [1, 6], $V1 = [1, 7], $V2 = [1, 8], $V3 = [1, 9], $V4 = [1, 16], $V5 = [1, 11], $V6 = [1, 12], $V7 = [1, 13], $V8 = [1, 14], $V9 = [1, 15], $Va = [1, 27], $Vb = [1, 33], $Vc = [1, 34], $Vd = [1, 35], $Ve = [1, 36], $Vf = [1, 37], $Vg = [1, 72], $Vh = [1, 73], $Vi = [1, 74], $Vj = [1, 75], $Vk = [1, 76], $Vl = [1, 77], $Vm = [1, 78], $Vn = [1, 38], $Vo = [1, 39], $Vp = [1, 40], $Vq = [1, 41], $Vr = [1, 42], $Vs = [1, 43], $Vt = [1, 44], $Vu = [1, 45], $Vv = [1, 46], $Vw = [1, 47], $Vx = [1, 48], $Vy = [1, 49], $Vz = [1, 50], $VA = [1, 51], $VB = [1, 52], $VC = [1, 53], $VD = [1, 54], $VE = [1, 55], $VF = [1, 56], $VG = [1, 57], $VH = [1, 59], $VI = [1, 60], $VJ = [1, 61], $VK = [1, 62], $VL = [1, 63], $VM = [1, 64], $VN = [1, 65], $VO = [1, 66], $VP = [1, 67], $VQ = [1, 68], $VR = [1, 69], $VS = [24, 52], $VT = [24, 44, 46, 47, 48, 49, 50, 51, 52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84], $VU = [15, 24, 44, 46, 47, 48, 49, 50, 51, 52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84], $VV = [1, 94], $VW = [1, 95], $VX = [1, 96], $VY = [1, 97], $VZ = [15, 24, 52], $V_ = [7, 8, 9, 10, 18, 22, 25, 26, 27, 28], $V$ = [15, 24, 43, 52], $V01 = [15, 24, 43, 52, 86, 87, 89, 90], $V11 = [15, 43], $V21 = [44, 46, 47, 48, 49, 50, 51, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84];
  var parser2 = {
    trace: function trace() {
    },
    yy: {},
    symbols_: { "error": 2, "start": 3, "mermaidDoc": 4, "direction": 5, "directive": 6, "direction_tb": 7, "direction_bt": 8, "direction_rl": 9, "direction_lr": 10, "graphConfig": 11, "openDirective": 12, "typeDirective": 13, "closeDirective": 14, "NEWLINE": 15, ":": 16, "argDirective": 17, "open_directive": 18, "type_directive": 19, "arg_directive": 20, "close_directive": 21, "C4_CONTEXT": 22, "statements": 23, "EOF": 24, "C4_CONTAINER": 25, "C4_COMPONENT": 26, "C4_DYNAMIC": 27, "C4_DEPLOYMENT": 28, "otherStatements": 29, "diagramStatements": 30, "otherStatement": 31, "title": 32, "accDescription": 33, "acc_title": 34, "acc_title_value": 35, "acc_descr": 36, "acc_descr_value": 37, "acc_descr_multiline_value": 38, "boundaryStatement": 39, "boundaryStartStatement": 40, "boundaryStopStatement": 41, "boundaryStart": 42, "LBRACE": 43, "ENTERPRISE_BOUNDARY": 44, "attributes": 45, "SYSTEM_BOUNDARY": 46, "BOUNDARY": 47, "CONTAINER_BOUNDARY": 48, "NODE": 49, "NODE_L": 50, "NODE_R": 51, "RBRACE": 52, "diagramStatement": 53, "PERSON": 54, "PERSON_EXT": 55, "SYSTEM": 56, "SYSTEM_DB": 57, "SYSTEM_QUEUE": 58, "SYSTEM_EXT": 59, "SYSTEM_EXT_DB": 60, "SYSTEM_EXT_QUEUE": 61, "CONTAINER": 62, "CONTAINER_DB": 63, "CONTAINER_QUEUE": 64, "CONTAINER_EXT": 65, "CONTAINER_EXT_DB": 66, "CONTAINER_EXT_QUEUE": 67, "COMPONENT": 68, "COMPONENT_DB": 69, "COMPONENT_QUEUE": 70, "COMPONENT_EXT": 71, "COMPONENT_EXT_DB": 72, "COMPONENT_EXT_QUEUE": 73, "REL": 74, "BIREL": 75, "REL_U": 76, "REL_D": 77, "REL_L": 78, "REL_R": 79, "REL_B": 80, "REL_INDEX": 81, "UPDATE_EL_STYLE": 82, "UPDATE_REL_STYLE": 83, "UPDATE_LAYOUT_CONFIG": 84, "attribute": 85, "STR": 86, "STR_KEY": 87, "STR_VALUE": 88, "ATTRIBUTE": 89, "ATTRIBUTE_EMPTY": 90, "$accept": 0, "$end": 1 },
    terminals_: { 2: "error", 7: "direction_tb", 8: "direction_bt", 9: "direction_rl", 10: "direction_lr", 15: "NEWLINE", 16: ":", 18: "open_directive", 19: "type_directive", 20: "arg_directive", 21: "close_directive", 22: "C4_CONTEXT", 24: "EOF", 25: "C4_CONTAINER", 26: "C4_COMPONENT", 27: "C4_DYNAMIC", 28: "C4_DEPLOYMENT", 32: "title", 33: "accDescription", 34: "acc_title", 35: "acc_title_value", 36: "acc_descr", 37: "acc_descr_value", 38: "acc_descr_multiline_value", 43: "LBRACE", 44: "ENTERPRISE_BOUNDARY", 46: "SYSTEM_BOUNDARY", 47: "BOUNDARY", 48: "CONTAINER_BOUNDARY", 49: "NODE", 50: "NODE_L", 51: "NODE_R", 52: "RBRACE", 54: "PERSON", 55: "PERSON_EXT", 56: "SYSTEM", 57: "SYSTEM_DB", 58: "SYSTEM_QUEUE", 59: "SYSTEM_EXT", 60: "SYSTEM_EXT_DB", 61: "SYSTEM_EXT_QUEUE", 62: "CONTAINER", 63: "CONTAINER_DB", 64: "CONTAINER_QUEUE", 65: "CONTAINER_EXT", 66: "CONTAINER_EXT_DB", 67: "CONTAINER_EXT_QUEUE", 68: "COMPONENT", 69: "COMPONENT_DB", 70: "COMPONENT_QUEUE", 71: "COMPONENT_EXT", 72: "COMPONENT_EXT_DB", 73: "COMPONENT_EXT_QUEUE", 74: "REL", 75: "BIREL", 76: "REL_U", 77: "REL_D", 78: "REL_L", 79: "REL_R", 80: "REL_B", 81: "REL_INDEX", 82: "UPDATE_EL_STYLE", 83: "UPDATE_REL_STYLE", 84: "UPDATE_LAYOUT_CONFIG", 86: "STR", 87: "STR_KEY", 88: "STR_VALUE", 89: "ATTRIBUTE", 90: "ATTRIBUTE_EMPTY" },
    productions_: [0, [3, 1], [3, 1], [3, 2], [5, 1], [5, 1], [5, 1], [5, 1], [4, 1], [6, 4], [6, 6], [12, 1], [13, 1], [17, 1], [14, 1], [11, 4], [11, 4], [11, 4], [11, 4], [11, 4], [23, 1], [23, 1], [23, 2], [29, 1], [29, 2], [29, 3], [31, 1], [31, 1], [31, 2], [31, 2], [31, 1], [39, 3], [40, 3], [40, 3], [40, 4], [42, 2], [42, 2], [42, 2], [42, 2], [42, 2], [42, 2], [42, 2], [41, 1], [30, 1], [30, 2], [30, 3], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 1], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [45, 1], [45, 2], [85, 1], [85, 2], [85, 1], [85, 1]],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
      var $0 = $$.length - 1;
      switch (yystate) {
        case 4:
          yy.setDirection("TB");
          break;
        case 5:
          yy.setDirection("BT");
          break;
        case 6:
          yy.setDirection("RL");
          break;
        case 7:
          yy.setDirection("LR");
          break;
        case 11:
          yy.parseDirective("%%{", "open_directive");
          break;
        case 12:
          break;
        case 13:
          $$[$0] = $$[$0].trim().replace(/'/g, '"');
          yy.parseDirective($$[$0], "arg_directive");
          break;
        case 14:
          yy.parseDirective("}%%", "close_directive", "c4Context");
          break;
        case 15:
        case 16:
        case 17:
        case 18:
        case 19:
          yy.setC4Type($$[$0 - 3]);
          break;
        case 26:
          yy.setTitle($$[$0].substring(6));
          this.$ = $$[$0].substring(6);
          break;
        case 27:
          yy.setAccDescription($$[$0].substring(15));
          this.$ = $$[$0].substring(15);
          break;
        case 28:
          this.$ = $$[$0].trim();
          yy.setTitle(this.$);
          break;
        case 29:
        case 30:
          this.$ = $$[$0].trim();
          yy.setAccDescription(this.$);
          break;
        case 35:
        case 36:
          $$[$0].splice(2, 0, "ENTERPRISE");
          yy.addPersonOrSystemBoundary(...$$[$0]);
          this.$ = $$[$0];
          break;
        case 37:
          yy.addPersonOrSystemBoundary(...$$[$0]);
          this.$ = $$[$0];
          break;
        case 38:
          $$[$0].splice(2, 0, "CONTAINER");
          yy.addContainerBoundary(...$$[$0]);
          this.$ = $$[$0];
          break;
        case 39:
          yy.addDeploymentNode("node", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 40:
          yy.addDeploymentNode("nodeL", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 41:
          yy.addDeploymentNode("nodeR", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 42:
          yy.popBoundaryParseStack();
          break;
        case 46:
          yy.addPersonOrSystem("person", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 47:
          yy.addPersonOrSystem("external_person", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 48:
          yy.addPersonOrSystem("system", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 49:
          yy.addPersonOrSystem("system_db", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 50:
          yy.addPersonOrSystem("system_queue", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 51:
          yy.addPersonOrSystem("external_system", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 52:
          yy.addPersonOrSystem("external_system_db", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 53:
          yy.addPersonOrSystem("external_system_queue", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 54:
          yy.addContainer("container", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 55:
          yy.addContainer("container_db", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 56:
          yy.addContainer("container_queue", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 57:
          yy.addContainer("external_container", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 58:
          yy.addContainer("external_container_db", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 59:
          yy.addContainer("external_container_queue", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 60:
          yy.addComponent("component", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 61:
          yy.addComponent("component_db", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 62:
          yy.addComponent("component_queue", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 63:
          yy.addComponent("external_component", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 64:
          yy.addComponent("external_component_db", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 65:
          yy.addComponent("external_component_queue", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 67:
          yy.addRel("rel", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 68:
          yy.addRel("birel", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 69:
          yy.addRel("rel_u", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 70:
          yy.addRel("rel_d", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 71:
          yy.addRel("rel_l", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 72:
          yy.addRel("rel_r", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 73:
          yy.addRel("rel_b", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 74:
          $$[$0].splice(0, 1);
          yy.addRel("rel", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 75:
          yy.updateElStyle("update_el_style", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 76:
          yy.updateRelStyle("update_rel_style", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 77:
          yy.updateLayoutConfig("update_layout_config", ...$$[$0]);
          this.$ = $$[$0];
          break;
        case 78:
          this.$ = [$$[$0]];
          break;
        case 79:
          $$[$0].unshift($$[$0 - 1]);
          this.$ = $$[$0];
          break;
        case 80:
        case 82:
          this.$ = $$[$0].trim();
          break;
        case 81:
          let kv = {};
          kv[$$[$0 - 1].trim()] = $$[$0].trim();
          this.$ = kv;
          break;
        case 83:
          this.$ = "";
          break;
      }
    },
    table: [{ 3: 1, 4: 2, 5: 3, 6: 4, 7: $V0, 8: $V1, 9: $V2, 10: $V3, 11: 5, 12: 10, 18: $V4, 22: $V5, 25: $V6, 26: $V7, 27: $V8, 28: $V9 }, { 1: [3] }, { 1: [2, 1] }, { 1: [2, 2] }, { 3: 17, 4: 2, 5: 3, 6: 4, 7: $V0, 8: $V1, 9: $V2, 10: $V3, 11: 5, 12: 10, 18: $V4, 22: $V5, 25: $V6, 26: $V7, 27: $V8, 28: $V9 }, { 1: [2, 8] }, { 1: [2, 4] }, { 1: [2, 5] }, { 1: [2, 6] }, { 1: [2, 7] }, { 13: 18, 19: [1, 19] }, { 15: [1, 20] }, { 15: [1, 21] }, { 15: [1, 22] }, { 15: [1, 23] }, { 15: [1, 24] }, { 19: [2, 11] }, { 1: [2, 3] }, { 14: 25, 16: [1, 26], 21: $Va }, o([16, 21], [2, 12]), { 23: 28, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 23: 79, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 23: 80, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 23: 81, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 23: 82, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 15: [1, 83] }, { 17: 84, 20: [1, 85] }, { 15: [2, 14] }, { 24: [1, 86] }, o($VS, [2, 20], { 53: 32, 39: 58, 40: 70, 42: 71, 30: 87, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }), o($VS, [2, 21]), o($VT, [2, 23], { 15: [1, 88] }), o($VS, [2, 43], { 15: [1, 89] }), o($VU, [2, 26]), o($VU, [2, 27]), { 35: [1, 90] }, { 37: [1, 91] }, o($VU, [2, 30]), { 45: 92, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 98, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 99, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 100, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 101, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 102, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 103, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 104, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 105, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 106, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 107, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 108, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 109, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 110, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 111, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 112, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 113, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 114, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 115, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 116, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, o($VZ, [2, 66]), { 45: 117, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 118, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 119, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 120, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 121, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 122, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 123, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 124, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 125, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 126, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 127, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 30: 128, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 15: [1, 130], 43: [1, 129] }, { 45: 131, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 132, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 133, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 134, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 135, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 136, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 137, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 24: [1, 138] }, { 24: [1, 139] }, { 24: [1, 140] }, { 24: [1, 141] }, o($V_, [2, 9]), { 14: 142, 21: $Va }, { 21: [2, 13] }, { 1: [2, 15] }, o($VS, [2, 22]), o($VT, [2, 24], { 31: 31, 29: 143, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf }), o($VS, [2, 44], { 29: 29, 30: 30, 31: 31, 53: 32, 39: 58, 40: 70, 42: 71, 23: 144, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }), o($VU, [2, 28]), o($VU, [2, 29]), o($VZ, [2, 46]), o($V$, [2, 78], { 85: 93, 45: 145, 86: $VV, 87: $VW, 89: $VX, 90: $VY }), o($V01, [2, 80]), { 88: [1, 146] }, o($V01, [2, 82]), o($V01, [2, 83]), o($VZ, [2, 47]), o($VZ, [2, 48]), o($VZ, [2, 49]), o($VZ, [2, 50]), o($VZ, [2, 51]), o($VZ, [2, 52]), o($VZ, [2, 53]), o($VZ, [2, 54]), o($VZ, [2, 55]), o($VZ, [2, 56]), o($VZ, [2, 57]), o($VZ, [2, 58]), o($VZ, [2, 59]), o($VZ, [2, 60]), o($VZ, [2, 61]), o($VZ, [2, 62]), o($VZ, [2, 63]), o($VZ, [2, 64]), o($VZ, [2, 65]), o($VZ, [2, 67]), o($VZ, [2, 68]), o($VZ, [2, 69]), o($VZ, [2, 70]), o($VZ, [2, 71]), o($VZ, [2, 72]), o($VZ, [2, 73]), o($VZ, [2, 74]), o($VZ, [2, 75]), o($VZ, [2, 76]), o($VZ, [2, 77]), { 41: 147, 52: [1, 148] }, { 15: [1, 149] }, { 43: [1, 150] }, o($V11, [2, 35]), o($V11, [2, 36]), o($V11, [2, 37]), o($V11, [2, 38]), o($V11, [2, 39]), o($V11, [2, 40]), o($V11, [2, 41]), { 1: [2, 16] }, { 1: [2, 17] }, { 1: [2, 18] }, { 1: [2, 19] }, { 15: [1, 151] }, o($VT, [2, 25]), o($VS, [2, 45]), o($V$, [2, 79]), o($V01, [2, 81]), o($VZ, [2, 31]), o($VZ, [2, 42]), o($V21, [2, 32]), o($V21, [2, 33], { 15: [1, 152] }), o($V_, [2, 10]), o($V21, [2, 34])],
    defaultActions: { 2: [2, 1], 3: [2, 2], 5: [2, 8], 6: [2, 4], 7: [2, 5], 8: [2, 6], 9: [2, 7], 16: [2, 11], 17: [2, 3], 27: [2, 14], 85: [2, 13], 86: [2, 15], 138: [2, 16], 139: [2, 17], 140: [2, 18], 141: [2, 19] },
    parseError: function parseError(str2, hash) {
      if (hash.recoverable) {
        this.trace(str2);
      } else {
        var error = new Error(str2);
        error.hash = hash;
        throw error;
      }
    },
    parse: function parse2(input) {
      var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
      var args = lstack.slice.call(arguments, 1);
      var lexer2 = Object.create(this.lexer);
      var sharedState = { yy: {} };
      for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
          sharedState.yy[k] = this.yy[k];
        }
      }
      lexer2.setInput(input, sharedState.yy);
      sharedState.yy.lexer = lexer2;
      sharedState.yy.parser = this;
      if (typeof lexer2.yylloc == "undefined") {
        lexer2.yylloc = {};
      }
      var yyloc = lexer2.yylloc;
      lstack.push(yyloc);
      var ranges = lexer2.options && lexer2.options.ranges;
      if (typeof sharedState.yy.parseError === "function") {
        this.parseError = sharedState.yy.parseError;
      } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
      }
      function lex2() {
        var token;
        token = tstack.pop() || lexer2.lex() || EOF;
        if (typeof token !== "number") {
          if (token instanceof Array) {
            tstack = token;
            token = tstack.pop();
          }
          token = self.symbols_[token] || token;
        }
        return token;
      }
      var symbol, state, action, r, yyval = {}, p, len, newState, expected;
      while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
          action = this.defaultActions[state];
        } else {
          if (symbol === null || typeof symbol == "undefined") {
            symbol = lex2();
          }
          action = table[state] && table[state][symbol];
        }
        if (typeof action === "undefined" || !action.length || !action[0]) {
          var errStr = "";
          expected = [];
          for (p in table[state]) {
            if (this.terminals_[p] && p > TERROR) {
              expected.push("'" + this.terminals_[p] + "'");
            }
          }
          if (lexer2.showPosition) {
            errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
          } else {
            errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
          }
          this.parseError(errStr, {
            text: lexer2.match,
            token: this.terminals_[symbol] || symbol,
            line: lexer2.yylineno,
            loc: yyloc,
            expected
          });
        }
        if (action[0] instanceof Array && action.length > 1) {
          throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
        }
        switch (action[0]) {
          case 1:
            stack.push(symbol);
            vstack.push(lexer2.yytext);
            lstack.push(lexer2.yylloc);
            stack.push(action[1]);
            symbol = null;
            {
              yyleng = lexer2.yyleng;
              yytext = lexer2.yytext;
              yylineno = lexer2.yylineno;
              yyloc = lexer2.yylloc;
            }
            break;
          case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
              first_line: lstack[lstack.length - (len || 1)].first_line,
              last_line: lstack[lstack.length - 1].last_line,
              first_column: lstack[lstack.length - (len || 1)].first_column,
              last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
              yyval._$.range = [
                lstack[lstack.length - (len || 1)].range[0],
                lstack[lstack.length - 1].range[1]
              ];
            }
            r = this.performAction.apply(yyval, [
              yytext,
              yyleng,
              yylineno,
              sharedState.yy,
              action[1],
              vstack,
              lstack
            ].concat(args));
            if (typeof r !== "undefined") {
              return r;
            }
            if (len) {
              stack = stack.slice(0, -1 * len * 2);
              vstack = vstack.slice(0, -1 * len);
              lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
          case 3:
            return true;
        }
      }
      return true;
    }
  };
  var lexer = function() {
    var lexer2 = {
      EOF: 1,
      parseError: function parseError(str2, hash) {
        if (this.yy.parser) {
          this.yy.parser.parseError(str2, hash);
        } else {
          throw new Error(str2);
        }
      },
      // resets the lexer, sets new input
      setInput: function(input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = "";
        this.conditionStack = ["INITIAL"];
        this.yylloc = {
          first_line: 1,
          first_column: 0,
          last_line: 1,
          last_column: 0
        };
        if (this.options.ranges) {
          this.yylloc.range = [0, 0];
        }
        this.offset = 0;
        return this;
      },
      // consumes and returns one char from the input
      input: function() {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno++;
          this.yylloc.last_line++;
        } else {
          this.yylloc.last_column++;
        }
        if (this.options.ranges) {
          this.yylloc.range[1]++;
        }
        this._input = this._input.slice(1);
        return ch;
      },
      // unshifts one char (or a string) into the input
      unput: function(ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);
        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);
        if (lines.length - 1) {
          this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;
        this.yylloc = {
          first_line: this.yylloc.first_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.first_column,
          last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
        };
        if (this.options.ranges) {
          this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
      },
      // When called from action, caches matched text and appends it on next action
      more: function() {
        this._more = true;
        return this;
      },
      // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
      reject: function() {
        if (this.options.backtrack_lexer) {
          this._backtrack = true;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
        return this;
      },
      // retain first n characters of the match
      less: function(n) {
        this.unput(this.match.slice(n));
      },
      // displays already matched input, i.e. for error messages
      pastInput: function() {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
      },
      // displays upcoming input, i.e. for error messages
      upcomingInput: function() {
        var next = this.match;
        if (next.length < 20) {
          next += this._input.substr(0, 20 - next.length);
        }
        return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
      },
      // displays the character position where the lexing error occurred, i.e. for error messages
      showPosition: function() {
        var pre = this.pastInput();
        var c2 = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c2 + "^";
      },
      // test the lexed token: return FALSE when not a match, otherwise return token
      test_match: function(match, indexed_rule) {
        var token, lines, backup;
        if (this.options.backtrack_lexer) {
          backup = {
            yylineno: this.yylineno,
            yylloc: {
              first_line: this.yylloc.first_line,
              last_line: this.last_line,
              first_column: this.yylloc.first_column,
              last_column: this.yylloc.last_column
            },
            yytext: this.yytext,
            match: this.match,
            matches: this.matches,
            matched: this.matched,
            yyleng: this.yyleng,
            offset: this.offset,
            _more: this._more,
            _input: this._input,
            yy: this.yy,
            conditionStack: this.conditionStack.slice(0),
            done: this.done
          };
          if (this.options.ranges) {
            backup.yylloc.range = this.yylloc.range.slice(0);
          }
        }
        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno += lines.length;
        }
        this.yylloc = {
          first_line: this.yylloc.last_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.last_column,
          last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
          this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
          this.done = false;
        }
        if (token) {
          return token;
        } else if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
        return false;
      },
      // return next match in input
      next: function() {
        if (this.done) {
          return this.EOF;
        }
        if (!this._input) {
          this.done = true;
        }
        var token, match, tempMatch, index;
        if (!this._more) {
          this.yytext = "";
          this.match = "";
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
          tempMatch = this._input.match(this.rules[rules[i]]);
          if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
            match = tempMatch;
            index = i;
            if (this.options.backtrack_lexer) {
              token = this.test_match(tempMatch, rules[i]);
              if (token !== false) {
                return token;
              } else if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            } else if (!this.options.flex) {
              break;
            }
          }
        }
        if (match) {
          token = this.test_match(match, rules[index]);
          if (token !== false) {
            return token;
          }
          return false;
        }
        if (this._input === "") {
          return this.EOF;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
      },
      // return next match that has a token
      lex: function lex2() {
        var r = this.next();
        if (r) {
          return r;
        } else {
          return this.lex();
        }
      },
      // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
      begin: function begin(condition) {
        this.conditionStack.push(condition);
      },
      // pop the previously active lexer condition state off the condition stack
      popState: function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
          return this.conditionStack.pop();
        } else {
          return this.conditionStack[0];
        }
      },
      // produce the lexer rule set which is active for the currently active lexer condition state
      _currentRules: function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
          return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
          return this.conditions["INITIAL"].rules;
        }
      },
      // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
      topState: function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
          return this.conditionStack[n];
        } else {
          return "INITIAL";
        }
      },
      // alias for begin(condition)
      pushState: function pushState(condition) {
        this.begin(condition);
      },
      // return the number of states currently on the stack
      stateStackSize: function stateStackSize() {
        return this.conditionStack.length;
      },
      options: {},
      performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
        switch ($avoiding_name_collisions) {
          case 0:
            this.begin("open_directive");
            return 18;
          case 1:
            return 7;
          case 2:
            return 8;
          case 3:
            return 9;
          case 4:
            return 10;
          case 5:
            this.begin("type_directive");
            return 19;
          case 6:
            this.popState();
            this.begin("arg_directive");
            return 16;
          case 7:
            this.popState();
            this.popState();
            return 21;
          case 8:
            return 20;
          case 9:
            return 32;
          case 10:
            return 33;
          case 11:
            this.begin("acc_title");
            return 34;
          case 12:
            this.popState();
            return "acc_title_value";
          case 13:
            this.begin("acc_descr");
            return 36;
          case 14:
            this.popState();
            return "acc_descr_value";
          case 15:
            this.begin("acc_descr_multiline");
            break;
          case 16:
            this.popState();
            break;
          case 17:
            return "acc_descr_multiline_value";
          case 18:
            break;
          case 19:
            c;
            break;
          case 20:
            return 15;
          case 21:
            break;
          case 22:
            return 22;
          case 23:
            return 25;
          case 24:
            return 26;
          case 25:
            return 27;
          case 26:
            return 28;
          case 27:
            this.begin("person_ext");
            return 55;
          case 28:
            this.begin("person");
            return 54;
          case 29:
            this.begin("system_ext_queue");
            return 61;
          case 30:
            this.begin("system_ext_db");
            return 60;
          case 31:
            this.begin("system_ext");
            return 59;
          case 32:
            this.begin("system_queue");
            return 58;
          case 33:
            this.begin("system_db");
            return 57;
          case 34:
            this.begin("system");
            return 56;
          case 35:
            this.begin("boundary");
            return 47;
          case 36:
            this.begin("enterprise_boundary");
            return 44;
          case 37:
            this.begin("system_boundary");
            return 46;
          case 38:
            this.begin("container_ext_queue");
            return 67;
          case 39:
            this.begin("container_ext_db");
            return 66;
          case 40:
            this.begin("container_ext");
            return 65;
          case 41:
            this.begin("container_queue");
            return 64;
          case 42:
            this.begin("container_db");
            return 63;
          case 43:
            this.begin("container");
            return 62;
          case 44:
            this.begin("container_boundary");
            return 48;
          case 45:
            this.begin("component_ext_queue");
            return 73;
          case 46:
            this.begin("component_ext_db");
            return 72;
          case 47:
            this.begin("component_ext");
            return 71;
          case 48:
            this.begin("component_queue");
            return 70;
          case 49:
            this.begin("component_db");
            return 69;
          case 50:
            this.begin("component");
            return 68;
          case 51:
            this.begin("node");
            return 49;
          case 52:
            this.begin("node");
            return 49;
          case 53:
            this.begin("node_l");
            return 50;
          case 54:
            this.begin("node_r");
            return 51;
          case 55:
            this.begin("rel");
            return 74;
          case 56:
            this.begin("birel");
            return 75;
          case 57:
            this.begin("rel_u");
            return 76;
          case 58:
            this.begin("rel_u");
            return 76;
          case 59:
            this.begin("rel_d");
            return 77;
          case 60:
            this.begin("rel_d");
            return 77;
          case 61:
            this.begin("rel_l");
            return 78;
          case 62:
            this.begin("rel_l");
            return 78;
          case 63:
            this.begin("rel_r");
            return 79;
          case 64:
            this.begin("rel_r");
            return 79;
          case 65:
            this.begin("rel_b");
            return 80;
          case 66:
            this.begin("rel_index");
            return 81;
          case 67:
            this.begin("update_el_style");
            return 82;
          case 68:
            this.begin("update_rel_style");
            return 83;
          case 69:
            this.begin("update_layout_config");
            return 84;
          case 70:
            return "EOF_IN_STRUCT";
          case 71:
            this.begin("attribute");
            return "ATTRIBUTE_EMPTY";
          case 72:
            this.begin("attribute");
            break;
          case 73:
            this.popState();
            this.popState();
            break;
          case 74:
            return 90;
          case 75:
            break;
          case 76:
            return 90;
          case 77:
            this.begin("string");
            break;
          case 78:
            this.popState();
            break;
          case 79:
            return "STR";
          case 80:
            this.begin("string_kv");
            break;
          case 81:
            this.begin("string_kv_key");
            return "STR_KEY";
          case 82:
            this.popState();
            this.begin("string_kv_value");
            break;
          case 83:
            return "STR_VALUE";
          case 84:
            this.popState();
            this.popState();
            break;
          case 85:
            return "STR";
          case 86:
            return "LBRACE";
          case 87:
            return "RBRACE";
          case 88:
            return "SPACE";
          case 89:
            return "EOL";
          case 90:
            return 24;
        }
      },
      rules: [/^(?:%%\{)/, /^(?:.*direction\s+TB[^\n]*)/, /^(?:.*direction\s+BT[^\n]*)/, /^(?:.*direction\s+RL[^\n]*)/, /^(?:.*direction\s+LR[^\n]*)/, /^(?:((?:(?!\}%%)[^:.])*))/, /^(?::)/, /^(?:\}%%)/, /^(?:((?:(?!\}%%).|\n)*))/, /^(?:title\s[^#\n;]+)/, /^(?:accDescription\s[^#\n;]+)/, /^(?:accTitle\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*\{\s*)/, /^(?:[\}])/, /^(?:[^\}]*)/, /^(?:%%(?!\{)*[^\n]*(\r?\n?)+)/, /^(?:%%[^\n]*(\r?\n)*)/, /^(?:\s*(\r?\n)+)/, /^(?:\s+)/, /^(?:C4Context\b)/, /^(?:C4Container\b)/, /^(?:C4Component\b)/, /^(?:C4Dynamic\b)/, /^(?:C4Deployment\b)/, /^(?:Person_Ext\b)/, /^(?:Person\b)/, /^(?:SystemQueue_Ext\b)/, /^(?:SystemDb_Ext\b)/, /^(?:System_Ext\b)/, /^(?:SystemQueue\b)/, /^(?:SystemDb\b)/, /^(?:System\b)/, /^(?:Boundary\b)/, /^(?:Enterprise_Boundary\b)/, /^(?:System_Boundary\b)/, /^(?:ContainerQueue_Ext\b)/, /^(?:ContainerDb_Ext\b)/, /^(?:Container_Ext\b)/, /^(?:ContainerQueue\b)/, /^(?:ContainerDb\b)/, /^(?:Container\b)/, /^(?:Container_Boundary\b)/, /^(?:ComponentQueue_Ext\b)/, /^(?:ComponentDb_Ext\b)/, /^(?:Component_Ext\b)/, /^(?:ComponentQueue\b)/, /^(?:ComponentDb\b)/, /^(?:Component\b)/, /^(?:Deployment_Node\b)/, /^(?:Node\b)/, /^(?:Node_L\b)/, /^(?:Node_R\b)/, /^(?:Rel\b)/, /^(?:BiRel\b)/, /^(?:Rel_Up\b)/, /^(?:Rel_U\b)/, /^(?:Rel_Down\b)/, /^(?:Rel_D\b)/, /^(?:Rel_Left\b)/, /^(?:Rel_L\b)/, /^(?:Rel_Right\b)/, /^(?:Rel_R\b)/, /^(?:Rel_Back\b)/, /^(?:RelIndex\b)/, /^(?:UpdateElementStyle\b)/, /^(?:UpdateRelStyle\b)/, /^(?:UpdateLayoutConfig\b)/, /^(?:$)/, /^(?:[(][ ]*[,])/, /^(?:[(])/, /^(?:[)])/, /^(?:,,)/, /^(?:,)/, /^(?:[ ]*["]["])/, /^(?:[ ]*["])/, /^(?:["])/, /^(?:[^"]*)/, /^(?:[ ]*[\$])/, /^(?:[^=]*)/, /^(?:[=][ ]*["])/, /^(?:[^"]+)/, /^(?:["])/, /^(?:[^,]+)/, /^(?:\{)/, /^(?:\})/, /^(?:[\s]+)/, /^(?:[\n\r]+)/, /^(?:$)/],
      conditions: { "acc_descr_multiline": { "rules": [16, 17], "inclusive": false }, "acc_descr": { "rules": [14], "inclusive": false }, "acc_title": { "rules": [12], "inclusive": false }, "close_directive": { "rules": [], "inclusive": false }, "arg_directive": { "rules": [7, 8], "inclusive": false }, "type_directive": { "rules": [6, 7], "inclusive": false }, "open_directive": { "rules": [5], "inclusive": false }, "string_kv_value": { "rules": [83, 84], "inclusive": false }, "string_kv_key": { "rules": [82], "inclusive": false }, "string_kv": { "rules": [81], "inclusive": false }, "string": { "rules": [78, 79], "inclusive": false }, "attribute": { "rules": [73, 74, 75, 76, 77, 80, 85], "inclusive": false }, "update_layout_config": { "rules": [70, 71, 72, 73], "inclusive": false }, "update_rel_style": { "rules": [70, 71, 72, 73], "inclusive": false }, "update_el_style": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_b": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_r": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_l": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_d": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_u": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_bi": { "rules": [], "inclusive": false }, "rel": { "rules": [70, 71, 72, 73], "inclusive": false }, "node_r": { "rules": [70, 71, 72, 73], "inclusive": false }, "node_l": { "rules": [70, 71, 72, 73], "inclusive": false }, "node": { "rules": [70, 71, 72, 73], "inclusive": false }, "index": { "rules": [], "inclusive": false }, "rel_index": { "rules": [70, 71, 72, 73], "inclusive": false }, "component_ext_queue": { "rules": [], "inclusive": false }, "component_ext_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "component_ext": { "rules": [70, 71, 72, 73], "inclusive": false }, "component_queue": { "rules": [70, 71, 72, 73], "inclusive": false }, "component_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "component": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_boundary": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_ext_queue": { "rules": [], "inclusive": false }, "container_ext_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_ext": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_queue": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "container": { "rules": [70, 71, 72, 73], "inclusive": false }, "birel": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_boundary": { "rules": [70, 71, 72, 73], "inclusive": false }, "enterprise_boundary": { "rules": [70, 71, 72, 73], "inclusive": false }, "boundary": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_ext_queue": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_ext_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_ext": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_queue": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "system": { "rules": [70, 71, 72, 73], "inclusive": false }, "person_ext": { "rules": [70, 71, 72, 73], "inclusive": false }, "person": { "rules": [70, 71, 72, 73], "inclusive": false }, "INITIAL": { "rules": [0, 1, 2, 3, 4, 9, 10, 11, 13, 15, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 86, 87, 88, 89, 90], "inclusive": true } }
    };
    return lexer2;
  }();
  parser2.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  Parser.prototype = parser2;
  parser2.Parser = Parser;
  return new Parser();
}();
parser$b.parser = parser$b;
const c4Parser = parser$b;
const c4Detector = (txt) => {
  return txt.match(/^\s*C4Context|C4Container|C4Component|C4Dynamic|C4Deployment/) !== null;
};
let c4ShapeArray = [];
let boundaryParseStack = [""];
let currentBoundaryParse = "global";
let parentBoundaryParse = "";
let boundarys = [
  {
    alias: "global",
    label: { text: "global" },
    type: { text: "global" },
    tags: null,
    link: null,
    parentBoundary: ""
  }
];
let rels = [];
let title = "";
let wrapEnabled$1 = false;
let c4ShapeInRow$1 = 4;
let c4BoundaryInRow$1 = 2;
var c4Type;
const getC4Type = function() {
  return c4Type;
};
const setC4Type = function(c4TypeParam) {
  let sanitizedText = sanitizeText$5(c4TypeParam, getConfig$1());
  c4Type = sanitizedText;
};
const parseDirective$9 = function(statement, context, type2) {
  mermaidAPI.parseDirective(this, statement, context, type2);
};
const addRel = function(type2, from, to, label, techn, descr, sprite, tags2, link) {
  if (type2 === void 0 || type2 === null || from === void 0 || from === null || to === void 0 || to === null || label === void 0 || label === null) {
    return;
  }
  let rel = {};
  const old = rels.find((rel2) => rel2.from === from && rel2.to === to);
  if (old) {
    rel = old;
  } else {
    rels.push(rel);
  }
  rel.type = type2;
  rel.from = from;
  rel.to = to;
  rel.label = { text: label };
  if (techn === void 0 || techn === null) {
    rel.techn = { text: "" };
  } else {
    if (typeof techn === "object") {
      let [key, value] = Object.entries(techn)[0];
      rel[key] = { text: value };
    } else {
      rel.techn = { text: techn };
    }
  }
  if (descr === void 0 || descr === null) {
    rel.descr = { text: "" };
  } else {
    if (typeof descr === "object") {
      let [key, value] = Object.entries(descr)[0];
      rel[key] = { text: value };
    } else {
      rel.descr = { text: descr };
    }
  }
  if (typeof sprite === "object") {
    let [key, value] = Object.entries(sprite)[0];
    rel[key] = value;
  } else {
    rel.sprite = sprite;
  }
  if (typeof tags2 === "object") {
    let [key, value] = Object.entries(tags2)[0];
    rel[key] = value;
  } else {
    rel.tags = tags2;
  }
  if (typeof link === "object") {
    let [key, value] = Object.entries(link)[0];
    rel[key] = value;
  } else {
    rel.link = link;
  }
  rel.wrap = autoWrap$1();
};
const addPersonOrSystem = function(typeC4Shape, alias, label, descr, sprite, tags2, link) {
  if (alias === null || label === null) {
    return;
  }
  let personOrSystem = {};
  const old = c4ShapeArray.find((personOrSystem2) => personOrSystem2.alias === alias);
  if (old && alias === old.alias) {
    personOrSystem = old;
  } else {
    personOrSystem.alias = alias;
    c4ShapeArray.push(personOrSystem);
  }
  if (label === void 0 || label === null) {
    personOrSystem.label = { text: "" };
  } else {
    personOrSystem.label = { text: label };
  }
  if (descr === void 0 || descr === null) {
    personOrSystem.descr = { text: "" };
  } else {
    if (typeof descr === "object") {
      let [key, value] = Object.entries(descr)[0];
      personOrSystem[key] = { text: value };
    } else {
      personOrSystem.descr = { text: descr };
    }
  }
  if (typeof sprite === "object") {
    let [key, value] = Object.entries(sprite)[0];
    personOrSystem[key] = value;
  } else {
    personOrSystem.sprite = sprite;
  }
  if (typeof tags2 === "object") {
    let [key, value] = Object.entries(tags2)[0];
    personOrSystem[key] = value;
  } else {
    personOrSystem.tags = tags2;
  }
  if (typeof link === "object") {
    let [key, value] = Object.entries(link)[0];
    personOrSystem[key] = value;
  } else {
    personOrSystem.link = link;
  }
  personOrSystem.typeC4Shape = { text: typeC4Shape };
  personOrSystem.parentBoundary = currentBoundaryParse;
  personOrSystem.wrap = autoWrap$1();
};
const addContainer = function(typeC4Shape, alias, label, techn, descr, sprite, tags2, link) {
  if (alias === null || label === null) {
    return;
  }
  let container = {};
  const old = c4ShapeArray.find((container2) => container2.alias === alias);
  if (old && alias === old.alias) {
    container = old;
  } else {
    container.alias = alias;
    c4ShapeArray.push(container);
  }
  if (label === void 0 || label === null) {
    container.label = { text: "" };
  } else {
    container.label = { text: label };
  }
  if (techn === void 0 || techn === null) {
    container.techn = { text: "" };
  } else {
    if (typeof techn === "object") {
      let [key, value] = Object.entries(techn)[0];
      container[key] = { text: value };
    } else {
      container.techn = { text: techn };
    }
  }
  if (descr === void 0 || descr === null) {
    container.descr = { text: "" };
  } else {
    if (typeof descr === "object") {
      let [key, value] = Object.entries(descr)[0];
      container[key] = { text: value };
    } else {
      container.descr = { text: descr };
    }
  }
  if (typeof sprite === "object") {
    let [key, value] = Object.entries(sprite)[0];
    container[key] = value;
  } else {
    container.sprite = sprite;
  }
  if (typeof tags2 === "object") {
    let [key, value] = Object.entries(tags2)[0];
    container[key] = value;
  } else {
    container.tags = tags2;
  }
  if (typeof link === "object") {
    let [key, value] = Object.entries(link)[0];
    container[key] = value;
  } else {
    container.link = link;
  }
  container.wrap = autoWrap$1();
  container.typeC4Shape = { text: typeC4Shape };
  container.parentBoundary = currentBoundaryParse;
};
const addComponent = function(typeC4Shape, alias, label, techn, descr, sprite, tags2, link) {
  if (alias === null || label === null) {
    return;
  }
  let component = {};
  const old = c4ShapeArray.find((component2) => component2.alias === alias);
  if (old && alias === old.alias) {
    component = old;
  } else {
    component.alias = alias;
    c4ShapeArray.push(component);
  }
  if (label === void 0 || label === null) {
    component.label = { text: "" };
  } else {
    component.label = { text: label };
  }
  if (techn === void 0 || techn === null) {
    component.techn = { text: "" };
  } else {
    if (typeof techn === "object") {
      let [key, value] = Object.entries(techn)[0];
      component[key] = { text: value };
    } else {
      component.techn = { text: techn };
    }
  }
  if (descr === void 0 || descr === null) {
    component.descr = { text: "" };
  } else {
    if (typeof descr === "object") {
      let [key, value] = Object.entries(descr)[0];
      component[key] = { text: value };
    } else {
      component.descr = { text: descr };
    }
  }
  if (typeof sprite === "object") {
    let [key, value] = Object.entries(sprite)[0];
    component[key] = value;
  } else {
    component.sprite = sprite;
  }
  if (typeof tags2 === "object") {
    let [key, value] = Object.entries(tags2)[0];
    component[key] = value;
  } else {
    component.tags = tags2;
  }
  if (typeof link === "object") {
    let [key, value] = Object.entries(link)[0];
    component[key] = value;
  } else {
    component.link = link;
  }
  component.wrap = autoWrap$1();
  component.typeC4Shape = { text: typeC4Shape };
  component.parentBoundary = currentBoundaryParse;
};
const addPersonOrSystemBoundary = function(alias, label, type2, tags2, link) {
  if (alias === null || label === null) {
    return;
  }
  let boundary = {};
  const old = boundarys.find((boundary2) => boundary2.alias === alias);
  if (old && alias === old.alias) {
    boundary = old;
  } else {
    boundary.alias = alias;
    boundarys.push(boundary);
  }
  if (label === void 0 || label === null) {
    boundary.label = { text: "" };
  } else {
    boundary.label = { text: label };
  }
  if (type2 === void 0 || type2 === null) {
    boundary.type = { text: "system" };
  } else {
    if (typeof type2 === "object") {
      let [key, value] = Object.entries(type2)[0];
      boundary[key] = { text: value };
    } else {
      boundary.type = { text: type2 };
    }
  }
  if (typeof tags2 === "object") {
    let [key, value] = Object.entries(tags2)[0];
    boundary[key] = value;
  } else {
    boundary.tags = tags2;
  }
  if (typeof link === "object") {
    let [key, value] = Object.entries(link)[0];
    boundary[key] = value;
  } else {
    boundary.link = link;
  }
  boundary.parentBoundary = currentBoundaryParse;
  boundary.wrap = autoWrap$1();
  parentBoundaryParse = currentBoundaryParse;
  currentBoundaryParse = alias;
  boundaryParseStack.push(parentBoundaryParse);
};
const addContainerBoundary = function(alias, label, type2, tags2, link) {
  if (alias === null || label === null) {
    return;
  }
  let boundary = {};
  const old = boundarys.find((boundary2) => boundary2.alias === alias);
  if (old && alias === old.alias) {
    boundary = old;
  } else {
    boundary.alias = alias;
    boundarys.push(boundary);
  }
  if (label === void 0 || label === null) {
    boundary.label = { text: "" };
  } else {
    boundary.label = { text: label };
  }
  if (type2 === void 0 || type2 === null) {
    boundary.type = { text: "container" };
  } else {
    if (typeof type2 === "object") {
      let [key, value] = Object.entries(type2)[0];
      boundary[key] = { text: value };
    } else {
      boundary.type = { text: type2 };
    }
  }
  if (typeof tags2 === "object") {
    let [key, value] = Object.entries(tags2)[0];
    boundary[key] = value;
  } else {
    boundary.tags = tags2;
  }
  if (typeof link === "object") {
    let [key, value] = Object.entries(link)[0];
    boundary[key] = value;
  } else {
    boundary.link = link;
  }
  boundary.parentBoundary = currentBoundaryParse;
  boundary.wrap = autoWrap$1();
  parentBoundaryParse = currentBoundaryParse;
  currentBoundaryParse = alias;
  boundaryParseStack.push(parentBoundaryParse);
};
const addDeploymentNode = function(nodeType, alias, label, type2, descr, sprite, tags2, link) {
  if (alias === null || label === null) {
    return;
  }
  let boundary = {};
  const old = boundarys.find((boundary2) => boundary2.alias === alias);
  if (old && alias === old.alias) {
    boundary = old;
  } else {
    boundary.alias = alias;
    boundarys.push(boundary);
  }
  if (label === void 0 || label === null) {
    boundary.label = { text: "" };
  } else {
    boundary.label = { text: label };
  }
  if (type2 === void 0 || type2 === null) {
    boundary.type = { text: "node" };
  } else {
    if (typeof type2 === "object") {
      let [key, value] = Object.entries(type2)[0];
      boundary[key] = { text: value };
    } else {
      boundary.type = { text: type2 };
    }
  }
  if (descr === void 0 || descr === null) {
    boundary.descr = { text: "" };
  } else {
    if (typeof descr === "object") {
      let [key, value] = Object.entries(descr)[0];
      boundary[key] = { text: value };
    } else {
      boundary.descr = { text: descr };
    }
  }
  if (typeof tags2 === "object") {
    let [key, value] = Object.entries(tags2)[0];
    boundary[key] = value;
  } else {
    boundary.tags = tags2;
  }
  if (typeof link === "object") {
    let [key, value] = Object.entries(link)[0];
    boundary[key] = value;
  } else {
    boundary.link = link;
  }
  boundary.nodeType = nodeType;
  boundary.parentBoundary = currentBoundaryParse;
  boundary.wrap = autoWrap$1();
  parentBoundaryParse = currentBoundaryParse;
  currentBoundaryParse = alias;
  boundaryParseStack.push(parentBoundaryParse);
};
const popBoundaryParseStack = function() {
  currentBoundaryParse = parentBoundaryParse;
  boundaryParseStack.pop();
  parentBoundaryParse = boundaryParseStack.pop();
  boundaryParseStack.push(parentBoundaryParse);
};
const updateElStyle = function(typeC4Shape, elementName, bgColor, fontColor, borderColor, shadowing, shape, sprite, techn, legendText, legendSprite) {
  let old = c4ShapeArray.find((element) => element.alias === elementName);
  if (old === void 0) {
    old = boundarys.find((element) => element.alias === elementName);
    if (old === void 0) {
      return;
    }
  }
  if (bgColor !== void 0 && bgColor !== null) {
    if (typeof bgColor === "object") {
      let [key, value] = Object.entries(bgColor)[0];
      old[key] = value;
    } else {
      old.bgColor = bgColor;
    }
  }
  if (fontColor !== void 0 && fontColor !== null) {
    if (typeof fontColor === "object") {
      let [key, value] = Object.entries(fontColor)[0];
      old[key] = value;
    } else {
      old.fontColor = fontColor;
    }
  }
  if (borderColor !== void 0 && borderColor !== null) {
    if (typeof borderColor === "object") {
      let [key, value] = Object.entries(borderColor)[0];
      old[key] = value;
    } else {
      old.borderColor = borderColor;
    }
  }
  if (shadowing !== void 0 && shadowing !== null) {
    if (typeof shadowing === "object") {
      let [key, value] = Object.entries(shadowing)[0];
      old[key] = value;
    } else {
      old.shadowing = shadowing;
    }
  }
  if (shape !== void 0 && shape !== null) {
    if (typeof shape === "object") {
      let [key, value] = Object.entries(shape)[0];
      old[key] = value;
    } else {
      old.shape = shape;
    }
  }
  if (sprite !== void 0 && sprite !== null) {
    if (typeof sprite === "object") {
      let [key, value] = Object.entries(sprite)[0];
      old[key] = value;
    } else {
      old.sprite = sprite;
    }
  }
  if (techn !== void 0 && techn !== null) {
    if (typeof techn === "object") {
      let [key, value] = Object.entries(techn)[0];
      old[key] = value;
    } else {
      old.techn = techn;
    }
  }
  if (legendText !== void 0 && legendText !== null) {
    if (typeof legendText === "object") {
      let [key, value] = Object.entries(legendText)[0];
      old[key] = value;
    } else {
      old.legendText = legendText;
    }
  }
  if (legendSprite !== void 0 && legendSprite !== null) {
    if (typeof legendSprite === "object") {
      let [key, value] = Object.entries(legendSprite)[0];
      old[key] = value;
    } else {
      old.legendSprite = legendSprite;
    }
  }
};
const updateRelStyle = function(typeC4Shape, from, to, textColor, lineColor, offsetX, offsetY) {
  const old = rels.find((rel) => rel.from === from && rel.to === to);
  if (old === void 0) {
    return;
  }
  if (textColor !== void 0 && textColor !== null) {
    if (typeof textColor === "object") {
      let [key, value] = Object.entries(textColor)[0];
      old[key] = value;
    } else {
      old.textColor = textColor;
    }
  }
  if (lineColor !== void 0 && lineColor !== null) {
    if (typeof lineColor === "object") {
      let [key, value] = Object.entries(lineColor)[0];
      old[key] = value;
    } else {
      old.lineColor = lineColor;
    }
  }
  if (offsetX !== void 0 && offsetX !== null) {
    if (typeof offsetX === "object") {
      let [key, value] = Object.entries(offsetX)[0];
      old[key] = parseInt(value);
    } else {
      old.offsetX = parseInt(offsetX);
    }
  }
  if (offsetY !== void 0 && offsetY !== null) {
    if (typeof offsetY === "object") {
      let [key, value] = Object.entries(offsetY)[0];
      old[key] = parseInt(value);
    } else {
      old.offsetY = parseInt(offsetY);
    }
  }
};
const updateLayoutConfig = function(typeC4Shape, c4ShapeInRowParam, c4BoundaryInRowParam) {
  let c4ShapeInRowValue = c4ShapeInRow$1;
  let c4BoundaryInRowValue = c4BoundaryInRow$1;
  if (typeof c4ShapeInRowParam === "object") {
    const value = Object.values(c4ShapeInRowParam)[0];
    c4ShapeInRowValue = parseInt(value);
  } else {
    c4ShapeInRowValue = parseInt(c4ShapeInRowParam);
  }
  if (typeof c4BoundaryInRowParam === "object") {
    const value = Object.values(c4BoundaryInRowParam)[0];
    c4BoundaryInRowValue = parseInt(value);
  } else {
    c4BoundaryInRowValue = parseInt(c4BoundaryInRowParam);
  }
  if (c4ShapeInRowValue >= 1) {
    c4ShapeInRow$1 = c4ShapeInRowValue;
  }
  if (c4BoundaryInRowValue >= 1) {
    c4BoundaryInRow$1 = c4BoundaryInRowValue;
  }
};
const getC4ShapeInRow = function() {
  return c4ShapeInRow$1;
};
const getC4BoundaryInRow = function() {
  return c4BoundaryInRow$1;
};
const getCurrentBoundaryParse = function() {
  return currentBoundaryParse;
};
const getParentBoundaryParse = function() {
  return parentBoundaryParse;
};
const getC4ShapeArray = function(parentBoundary) {
  if (parentBoundary === void 0 || parentBoundary === null) {
    return c4ShapeArray;
  } else {
    return c4ShapeArray.filter((personOrSystem) => {
      return personOrSystem.parentBoundary === parentBoundary;
    });
  }
};
const getC4Shape = function(alias) {
  return c4ShapeArray.find((personOrSystem) => personOrSystem.alias === alias);
};
const getC4ShapeKeys = function(parentBoundary) {
  return Object.keys(getC4ShapeArray(parentBoundary));
};
const getBoundarys = function(parentBoundary) {
  if (parentBoundary === void 0 || parentBoundary === null) {
    return boundarys;
  } else {
    return boundarys.filter((boundary) => boundary.parentBoundary === parentBoundary);
  }
};
const getRels = function() {
  return rels;
};
const getTitle = function() {
  return title;
};
const setWrap$1 = function(wrapSetting) {
  wrapEnabled$1 = wrapSetting;
};
const autoWrap$1 = function() {
  return wrapEnabled$1;
};
const clear$d = function() {
  c4ShapeArray = [];
  boundarys = [
    {
      alias: "global",
      label: { text: "global" },
      type: { text: "global" },
      tags: null,
      link: null,
      parentBoundary: ""
    }
  ];
  parentBoundaryParse = "";
  currentBoundaryParse = "global";
  boundaryParseStack = [""];
  rels = [];
  boundaryParseStack = [""];
  title = "";
  wrapEnabled$1 = false;
  c4ShapeInRow$1 = 4;
  c4BoundaryInRow$1 = 2;
};
const LINETYPE$1 = {
  SOLID: 0,
  DOTTED: 1,
  NOTE: 2,
  SOLID_CROSS: 3,
  DOTTED_CROSS: 4,
  SOLID_OPEN: 5,
  DOTTED_OPEN: 6,
  LOOP_START: 10,
  LOOP_END: 11,
  ALT_START: 12,
  ALT_ELSE: 13,
  ALT_END: 14,
  OPT_START: 15,
  OPT_END: 16,
  ACTIVE_START: 17,
  ACTIVE_END: 18,
  PAR_START: 19,
  PAR_AND: 20,
  PAR_END: 21,
  RECT_START: 22,
  RECT_END: 23,
  SOLID_POINT: 24,
  DOTTED_POINT: 25
};
const ARROWTYPE$1 = {
  FILLED: 0,
  OPEN: 1
};
const PLACEMENT$1 = {
  LEFTOF: 0,
  RIGHTOF: 1,
  OVER: 2
};
const setTitle = function(txt) {
  let sanitizedText = sanitizeText$5(txt, getConfig$1());
  title = sanitizedText;
};
const c4Db = {
  addPersonOrSystem,
  addPersonOrSystemBoundary,
  addContainer,
  addContainerBoundary,
  addComponent,
  addDeploymentNode,
  popBoundaryParseStack,
  addRel,
  updateElStyle,
  updateRelStyle,
  updateLayoutConfig,
  autoWrap: autoWrap$1,
  setWrap: setWrap$1,
  getC4ShapeArray,
  getC4Shape,
  getC4ShapeKeys,
  getBoundarys,
  getCurrentBoundaryParse,
  getParentBoundaryParse,
  getRels,
  getTitle,
  getC4Type,
  getC4ShapeInRow,
  getC4BoundaryInRow,
  setAccTitle,
  getAccTitle,
  getAccDescription,
  setAccDescription,
  parseDirective: parseDirective$9,
  getConfig: () => getConfig$1().c4,
  clear: clear$d,
  LINETYPE: LINETYPE$1,
  ARROWTYPE: ARROWTYPE$1,
  PLACEMENT: PLACEMENT$1,
  setTitle,
  setC4Type
  // apply,
};
const drawRect$2 = function(elem, rectData) {
  const rectElem = elem.append("rect");
  rectElem.attr("x", rectData.x);
  rectElem.attr("y", rectData.y);
  rectElem.attr("fill", rectData.fill);
  rectElem.attr("stroke", rectData.stroke);
  rectElem.attr("width", rectData.width);
  rectElem.attr("height", rectData.height);
  rectElem.attr("rx", rectData.rx);
  rectElem.attr("ry", rectData.ry);
  if (rectData.attrs !== "undefined" && rectData.attrs !== null) {
    for (let attrKey in rectData.attrs) {
      rectElem.attr(attrKey, rectData.attrs[attrKey]);
    }
  }
  if (rectData.class !== "undefined") {
    rectElem.attr("class", rectData.class);
  }
  return rectElem;
};
const drawImage$1 = function(elem, width2, height2, x, y, link) {
  const imageElem = elem.append("image");
  imageElem.attr("width", width2);
  imageElem.attr("height", height2);
  imageElem.attr("x", x);
  imageElem.attr("y", y);
  let sanitizedLink = link.startsWith("data:image/png;base64") ? link : sanitizeUrl(link);
  imageElem.attr("xlink:href", sanitizedLink);
};
const drawRels$1 = (elem, rels2, conf2) => {
  const relsElem = elem.append("g");
  let i = 0;
  for (let rel of rels2) {
    let textColor = rel.textColor ? rel.textColor : "#444444";
    let strokeColor = rel.lineColor ? rel.lineColor : "#444444";
    let offsetX = rel.offsetX ? parseInt(rel.offsetX) : 0;
    let offsetY = rel.offsetY ? parseInt(rel.offsetY) : 0;
    let url = "";
    if (i === 0) {
      let line2 = relsElem.append("line");
      line2.attr("x1", rel.startPoint.x);
      line2.attr("y1", rel.startPoint.y);
      line2.attr("x2", rel.endPoint.x);
      line2.attr("y2", rel.endPoint.y);
      line2.attr("stroke-width", "1");
      line2.attr("stroke", strokeColor);
      line2.style("fill", "none");
      if (rel.type !== "rel_b") {
        line2.attr("marker-end", "url(" + url + "#arrowhead)");
      }
      if (rel.type === "birel" || rel.type === "rel_b") {
        line2.attr("marker-start", "url(" + url + "#arrowend)");
      }
      i = -1;
    } else {
      let line2 = relsElem.append("path");
      line2.attr("fill", "none").attr("stroke-width", "1").attr("stroke", strokeColor).attr(
        "d",
        "Mstartx,starty Qcontrolx,controly stopx,stopy ".replaceAll("startx", rel.startPoint.x).replaceAll("starty", rel.startPoint.y).replaceAll(
          "controlx",
          rel.startPoint.x + (rel.endPoint.x - rel.startPoint.x) / 2 - (rel.endPoint.x - rel.startPoint.x) / 4
        ).replaceAll("controly", rel.startPoint.y + (rel.endPoint.y - rel.startPoint.y) / 2).replaceAll("stopx", rel.endPoint.x).replaceAll("stopy", rel.endPoint.y)
      );
      if (rel.type !== "rel_b") {
        line2.attr("marker-end", "url(" + url + "#arrowhead)");
      }
      if (rel.type === "birel" || rel.type === "rel_b") {
        line2.attr("marker-start", "url(" + url + "#arrowend)");
      }
    }
    let messageConf = conf2.messageFont();
    _drawTextCandidateFunc$2(conf2)(
      rel.label.text,
      relsElem,
      Math.min(rel.startPoint.x, rel.endPoint.x) + Math.abs(rel.endPoint.x - rel.startPoint.x) / 2 + offsetX,
      Math.min(rel.startPoint.y, rel.endPoint.y) + Math.abs(rel.endPoint.y - rel.startPoint.y) / 2 + offsetY,
      rel.label.width,
      rel.label.height,
      { fill: textColor },
      messageConf
    );
    if (rel.techn && rel.techn.text !== "") {
      messageConf = conf2.messageFont();
      _drawTextCandidateFunc$2(conf2)(
        "[" + rel.techn.text + "]",
        relsElem,
        Math.min(rel.startPoint.x, rel.endPoint.x) + Math.abs(rel.endPoint.x - rel.startPoint.x) / 2 + offsetX,
        Math.min(rel.startPoint.y, rel.endPoint.y) + Math.abs(rel.endPoint.y - rel.startPoint.y) / 2 + conf2.messageFontSize + 5 + offsetY,
        Math.max(rel.label.width, rel.techn.width),
        rel.techn.height,
        { fill: textColor, "font-style": "italic" },
        messageConf
      );
    }
  }
};
const drawBoundary$1 = function(elem, boundary, conf2) {
  const boundaryElem = elem.append("g");
  let fillColor = boundary.bgColor ? boundary.bgColor : "none";
  let strokeColor = boundary.borderColor ? boundary.borderColor : "#444444";
  let fontColor = boundary.fontColor ? boundary.fontColor : "black";
  let attrsValue = { "stroke-width": 1, "stroke-dasharray": "7.0,7.0" };
  if (boundary.nodeType) {
    attrsValue = { "stroke-width": 1 };
  }
  let rectData = {
    x: boundary.x,
    y: boundary.y,
    fill: fillColor,
    stroke: strokeColor,
    width: boundary.width,
    height: boundary.height,
    rx: 2.5,
    ry: 2.5,
    attrs: attrsValue
  };
  drawRect$2(boundaryElem, rectData);
  let boundaryConf = conf2.boundaryFont();
  boundaryConf.fontWeight = "bold";
  boundaryConf.fontSize = boundaryConf.fontSize + 2;
  boundaryConf.fontColor = fontColor;
  _drawTextCandidateFunc$2(conf2)(
    boundary.label.text,
    boundaryElem,
    boundary.x,
    boundary.y + boundary.label.Y,
    boundary.width,
    boundary.height,
    { fill: "#444444" },
    boundaryConf
  );
  if (boundary.type && boundary.type.text !== "") {
    boundaryConf = conf2.boundaryFont();
    boundaryConf.fontColor = fontColor;
    _drawTextCandidateFunc$2(conf2)(
      boundary.type.text,
      boundaryElem,
      boundary.x,
      boundary.y + boundary.type.Y,
      boundary.width,
      boundary.height,
      { fill: "#444444" },
      boundaryConf
    );
  }
  if (boundary.descr && boundary.descr.text !== "") {
    boundaryConf = conf2.boundaryFont();
    boundaryConf.fontSize = boundaryConf.fontSize - 2;
    boundaryConf.fontColor = fontColor;
    _drawTextCandidateFunc$2(conf2)(
      boundary.descr.text,
      boundaryElem,
      boundary.x,
      boundary.y + boundary.descr.Y,
      boundary.width,
      boundary.height,
      { fill: "#444444" },
      boundaryConf
    );
  }
};
const drawC4Shape = function(elem, c4Shape, conf2) {
  var _a;
  let fillColor = c4Shape.bgColor ? c4Shape.bgColor : conf2[c4Shape.typeC4Shape.text + "_bg_color"];
  let strokeColor = c4Shape.borderColor ? c4Shape.borderColor : conf2[c4Shape.typeC4Shape.text + "_border_color"];
  let fontColor = c4Shape.fontColor ? c4Shape.fontColor : "#FFFFFF";
  let personImg = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAACD0lEQVR4Xu2YoU4EMRCGT+4j8Ai8AhaH4QHgAUjQuFMECUgMIUgwJAgMhgQsAYUiJCiQIBBY+EITsjfTdme6V24v4c8vyGbb+ZjOtN0bNcvjQXmkH83WvYBWto6PLm6v7p7uH1/w2fXD+PBycX1Pv2l3IdDm/vn7x+dXQiAubRzoURa7gRZWd0iGRIiJbOnhnfYBQZNJjNbuyY2eJG8fkDE3bbG4ep6MHUAsgYxmE3nVs6VsBWJSGccsOlFPmLIViMzLOB7pCVO2AtHJMohH7Fh6zqitQK7m0rJvAVYgGcEpe//PLdDz65sM4pF9N7ICcXDKIB5Nv6j7tD0NoSdM2QrU9Gg0ewE1LqBhHR3BBdvj2vapnidjHxD/q6vd7Pvhr31AwcY8eXMTXAKECZZJFXuEq27aLgQK5uLMohCenGGuGewOxSjBvYBqeG6B+Nqiblggdjnc+ZXDy+FNFpFzw76O3UBAROuXh6FoiAcf5g9eTvUgzy0nWg6I8cXHRUpg5bOVBCo+KDpFajOf23GgPme7RSQ+lacIENUgJ6gg1k6HjgOlqnLqip4tEuhv0hNEMXUD0clyXE3p6pZA0S2nnvTlXwLJEZWlb7cTQH1+USgTN4VhAenm/wea1OCAOmqo6fE1WCb9WSKBah+rbUWPWAmE2Rvk0ApiB45eOyNAzU8xcTvj8KvkKEoOaIYeHNA3ZuygAvFMUO0AAAAASUVORK5CYII=";
  switch (c4Shape.typeC4Shape.text) {
    case "person":
      personImg = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAACD0lEQVR4Xu2YoU4EMRCGT+4j8Ai8AhaH4QHgAUjQuFMECUgMIUgwJAgMhgQsAYUiJCiQIBBY+EITsjfTdme6V24v4c8vyGbb+ZjOtN0bNcvjQXmkH83WvYBWto6PLm6v7p7uH1/w2fXD+PBycX1Pv2l3IdDm/vn7x+dXQiAubRzoURa7gRZWd0iGRIiJbOnhnfYBQZNJjNbuyY2eJG8fkDE3bbG4ep6MHUAsgYxmE3nVs6VsBWJSGccsOlFPmLIViMzLOB7pCVO2AtHJMohH7Fh6zqitQK7m0rJvAVYgGcEpe//PLdDz65sM4pF9N7ICcXDKIB5Nv6j7tD0NoSdM2QrU9Gg0ewE1LqBhHR3BBdvj2vapnidjHxD/q6vd7Pvhr31AwcY8eXMTXAKECZZJFXuEq27aLgQK5uLMohCenGGuGewOxSjBvYBqeG6B+Nqiblggdjnc+ZXDy+FNFpFzw76O3UBAROuXh6FoiAcf5g9eTvUgzy0nWg6I8cXHRUpg5bOVBCo+KDpFajOf23GgPme7RSQ+lacIENUgJ6gg1k6HjgOlqnLqip4tEuhv0hNEMXUD0clyXE3p6pZA0S2nnvTlXwLJEZWlb7cTQH1+USgTN4VhAenm/wea1OCAOmqo6fE1WCb9WSKBah+rbUWPWAmE2Rvk0ApiB45eOyNAzU8xcTvj8KvkKEoOaIYeHNA3ZuygAvFMUO0AAAAASUVORK5CYII=";
      break;
    case "external_person":
      personImg = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAAB6ElEQVR4Xu2YLY+EMBCG9+dWr0aj0Wg0Go1Go0+j8Xdv2uTCvv1gpt0ebHKPuhDaeW4605Z9mJvx4AdXUyTUdd08z+u6flmWZRnHsWkafk9DptAwDPu+f0eAYtu2PEaGWuj5fCIZrBAC2eLBAnRCsEkkxmeaJp7iDJ2QMDdHsLg8SxKFEJaAo8lAXnmuOFIhTMpxxKATebo4UiFknuNo4OniSIXQyRxEA3YsnjGCVEjVXD7yLUAqxBGUyPv/Y4W2beMgGuS7kVQIBycH0fD+oi5pezQETxdHKmQKGk1eQEYldK+jw5GxPfZ9z7Mk0Qnhf1W1m3w//EUn5BDmSZsbR44QQLBEqrBHqOrmSKaQAxdnLArCrxZcM7A7ZKs4ioRq8LFC+NpC3WCBJsvpVw5edm9iEXFuyNfxXAgSwfrFQ1c0iNda8AdejvUgnktOtJQQxmcfFzGglc5WVCj7oDgFqU18boeFSs52CUh8LE8BIVQDT1ABrB0HtgSEYlX5doJnCwv9TXocKCaKbnwhdDKPq4lf3SwU3HLq4V/+WYhHVMa/3b4IlfyikAduCkcBc7mQ3/z/Qq/cTuikhkzB12Ae/mcJC9U+Vo8Ej1gWAtgbeGgFsAMHr50BIWOLCbezvhpBFUdY6EJuJ/QDW0XoMX60zZ0AAAAASUVORK5CYII=";
      break;
  }
  const c4ShapeElem = elem.append("g");
  c4ShapeElem.attr("class", "person-man");
  const rect2 = getNoteRect$2();
  switch (c4Shape.typeC4Shape.text) {
    case "person":
    case "external_person":
    case "system":
    case "external_system":
    case "container":
    case "external_container":
    case "component":
    case "external_component":
      rect2.x = c4Shape.x;
      rect2.y = c4Shape.y;
      rect2.fill = fillColor;
      rect2.width = c4Shape.width;
      rect2.height = c4Shape.height;
      rect2.stroke = strokeColor;
      rect2.rx = 2.5;
      rect2.ry = 2.5;
      rect2.attrs = { "stroke-width": 0.5 };
      drawRect$2(c4ShapeElem, rect2);
      break;
    case "system_db":
    case "external_system_db":
    case "container_db":
    case "external_container_db":
    case "component_db":
    case "external_component_db":
      c4ShapeElem.append("path").attr("fill", fillColor).attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
        "d",
        "Mstartx,startyc0,-10 half,-10 half,-10c0,0 half,0 half,10l0,heightc0,10 -half,10 -half,10c0,0 -half,0 -half,-10l0,-height".replaceAll("startx", c4Shape.x).replaceAll("starty", c4Shape.y).replaceAll("half", c4Shape.width / 2).replaceAll("height", c4Shape.height)
      );
      c4ShapeElem.append("path").attr("fill", "none").attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
        "d",
        "Mstartx,startyc0,10 half,10 half,10c0,0 half,0 half,-10".replaceAll("startx", c4Shape.x).replaceAll("starty", c4Shape.y).replaceAll("half", c4Shape.width / 2)
      );
      break;
    case "system_queue":
    case "external_system_queue":
    case "container_queue":
    case "external_container_queue":
    case "component_queue":
    case "external_component_queue":
      c4ShapeElem.append("path").attr("fill", fillColor).attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
        "d",
        "Mstartx,startylwidth,0c5,0 5,half 5,halfc0,0 0,half -5,halfl-width,0c-5,0 -5,-half -5,-halfc0,0 0,-half 5,-half".replaceAll("startx", c4Shape.x).replaceAll("starty", c4Shape.y).replaceAll("width", c4Shape.width).replaceAll("half", c4Shape.height / 2)
      );
      c4ShapeElem.append("path").attr("fill", "none").attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
        "d",
        "Mstartx,startyc-5,0 -5,half -5,halfc0,half 5,half 5,half".replaceAll("startx", c4Shape.x + c4Shape.width).replaceAll("starty", c4Shape.y).replaceAll("half", c4Shape.height / 2)
      );
      break;
  }
  let c4ShapeFontConf = getC4ShapeFont(conf2, c4Shape.typeC4Shape.text);
  c4ShapeElem.append("text").attr("fill", fontColor).attr("font-family", c4ShapeFontConf.fontFamily).attr("font-size", c4ShapeFontConf.fontSize - 2).attr("font-style", "italic").attr("lengthAdjust", "spacing").attr("textLength", c4Shape.typeC4Shape.width).attr("x", c4Shape.x + c4Shape.width / 2 - c4Shape.typeC4Shape.width / 2).attr("y", c4Shape.y + c4Shape.typeC4Shape.Y).text("<<" + c4Shape.typeC4Shape.text + ">>");
  switch (c4Shape.typeC4Shape.text) {
    case "person":
    case "external_person":
      drawImage$1(
        c4ShapeElem,
        48,
        48,
        c4Shape.x + c4Shape.width / 2 - 24,
        c4Shape.y + c4Shape.image.Y,
        personImg
      );
      break;
  }
  let textFontConf = conf2[c4Shape.typeC4Shape.text + "Font"]();
  textFontConf.fontWeight = "bold";
  textFontConf.fontSize = textFontConf.fontSize + 2;
  textFontConf.fontColor = fontColor;
  _drawTextCandidateFunc$2(conf2)(
    c4Shape.label.text,
    c4ShapeElem,
    c4Shape.x,
    c4Shape.y + c4Shape.label.Y,
    c4Shape.width,
    c4Shape.height,
    { fill: fontColor },
    textFontConf
  );
  textFontConf = conf2[c4Shape.typeC4Shape.text + "Font"]();
  textFontConf.fontColor = fontColor;
  if (c4Shape.techn && ((_a = c4Shape.techn) == null ? void 0 : _a.text) !== "") {
    _drawTextCandidateFunc$2(conf2)(
      c4Shape.techn.text,
      c4ShapeElem,
      c4Shape.x,
      c4Shape.y + c4Shape.techn.Y,
      c4Shape.width,
      c4Shape.height,
      { fill: fontColor, "font-style": "italic" },
      textFontConf
    );
  } else if (c4Shape.type && c4Shape.type.text !== "") {
    _drawTextCandidateFunc$2(conf2)(
      c4Shape.type.text,
      c4ShapeElem,
      c4Shape.x,
      c4Shape.y + c4Shape.type.Y,
      c4Shape.width,
      c4Shape.height,
      { fill: fontColor, "font-style": "italic" },
      textFontConf
    );
  }
  if (c4Shape.descr && c4Shape.descr.text !== "") {
    textFontConf = conf2.personFont();
    textFontConf.fontColor = fontColor;
    _drawTextCandidateFunc$2(conf2)(
      c4Shape.descr.text,
      c4ShapeElem,
      c4Shape.x,
      c4Shape.y + c4Shape.descr.Y,
      c4Shape.width,
      c4Shape.height,
      { fill: fontColor },
      textFontConf
    );
  }
  return c4Shape.height;
};
const insertDatabaseIcon$1 = function(elem) {
  elem.append("defs").append("symbol").attr("id", "database").attr("fill-rule", "evenodd").attr("clip-rule", "evenodd").append("path").attr("transform", "scale(.5)").attr(
    "d",
    "M12.258.001l.256.004.255.005.253.008.251.01.249.012.247.015.246.016.242.019.241.02.239.023.236.024.233.027.231.028.229.031.225.032.223.034.22.036.217.038.214.04.211.041.208.043.205.045.201.046.198.048.194.05.191.051.187.053.183.054.18.056.175.057.172.059.168.06.163.061.16.063.155.064.15.066.074.033.073.033.071.034.07.034.069.035.068.035.067.035.066.035.064.036.064.036.062.036.06.036.06.037.058.037.058.037.055.038.055.038.053.038.052.038.051.039.05.039.048.039.047.039.045.04.044.04.043.04.041.04.04.041.039.041.037.041.036.041.034.041.033.042.032.042.03.042.029.042.027.042.026.043.024.043.023.043.021.043.02.043.018.044.017.043.015.044.013.044.012.044.011.045.009.044.007.045.006.045.004.045.002.045.001.045v17l-.001.045-.002.045-.004.045-.006.045-.007.045-.009.044-.011.045-.012.044-.013.044-.015.044-.017.043-.018.044-.02.043-.021.043-.023.043-.024.043-.026.043-.027.042-.029.042-.03.042-.032.042-.033.042-.034.041-.036.041-.037.041-.039.041-.04.041-.041.04-.043.04-.044.04-.045.04-.047.039-.048.039-.05.039-.051.039-.052.038-.053.038-.055.038-.055.038-.058.037-.058.037-.06.037-.06.036-.062.036-.064.036-.064.036-.066.035-.067.035-.068.035-.069.035-.07.034-.071.034-.073.033-.074.033-.15.066-.155.064-.16.063-.163.061-.168.06-.172.059-.175.057-.18.056-.183.054-.187.053-.191.051-.194.05-.198.048-.201.046-.205.045-.208.043-.211.041-.214.04-.217.038-.22.036-.223.034-.225.032-.229.031-.231.028-.233.027-.236.024-.239.023-.241.02-.242.019-.246.016-.247.015-.249.012-.251.01-.253.008-.255.005-.256.004-.258.001-.258-.001-.256-.004-.255-.005-.253-.008-.251-.01-.249-.012-.247-.015-.245-.016-.243-.019-.241-.02-.238-.023-.236-.024-.234-.027-.231-.028-.228-.031-.226-.032-.223-.034-.22-.036-.217-.038-.214-.04-.211-.041-.208-.043-.204-.045-.201-.046-.198-.048-.195-.05-.19-.051-.187-.053-.184-.054-.179-.056-.176-.057-.172-.059-.167-.06-.164-.061-.159-.063-.155-.064-.151-.066-.074-.033-.072-.033-.072-.034-.07-.034-.069-.035-.068-.035-.067-.035-.066-.035-.064-.036-.063-.036-.062-.036-.061-.036-.06-.037-.058-.037-.057-.037-.056-.038-.055-.038-.053-.038-.052-.038-.051-.039-.049-.039-.049-.039-.046-.039-.046-.04-.044-.04-.043-.04-.041-.04-.04-.041-.039-.041-.037-.041-.036-.041-.034-.041-.033-.042-.032-.042-.03-.042-.029-.042-.027-.042-.026-.043-.024-.043-.023-.043-.021-.043-.02-.043-.018-.044-.017-.043-.015-.044-.013-.044-.012-.044-.011-.045-.009-.044-.007-.045-.006-.045-.004-.045-.002-.045-.001-.045v-17l.001-.045.002-.045.004-.045.006-.045.007-.045.009-.044.011-.045.012-.044.013-.044.015-.044.017-.043.018-.044.02-.043.021-.043.023-.043.024-.043.026-.043.027-.042.029-.042.03-.042.032-.042.033-.042.034-.041.036-.041.037-.041.039-.041.04-.041.041-.04.043-.04.044-.04.046-.04.046-.039.049-.039.049-.039.051-.039.052-.038.053-.038.055-.038.056-.038.057-.037.058-.037.06-.037.061-.036.062-.036.063-.036.064-.036.066-.035.067-.035.068-.035.069-.035.07-.034.072-.034.072-.033.074-.033.151-.066.155-.064.159-.063.164-.061.167-.06.172-.059.176-.057.179-.056.184-.054.187-.053.19-.051.195-.05.198-.048.201-.046.204-.045.208-.043.211-.041.214-.04.217-.038.22-.036.223-.034.226-.032.228-.031.231-.028.234-.027.236-.024.238-.023.241-.02.243-.019.245-.016.247-.015.249-.012.251-.01.253-.008.255-.005.256-.004.258-.001.258.001zm-9.258 20.499v.01l.001.021.003.021.004.022.005.021.006.022.007.022.009.023.01.022.011.023.012.023.013.023.015.023.016.024.017.023.018.024.019.024.021.024.022.025.023.024.024.025.052.049.056.05.061.051.066.051.07.051.075.051.079.052.084.052.088.052.092.052.097.052.102.051.105.052.11.052.114.051.119.051.123.051.127.05.131.05.135.05.139.048.144.049.147.047.152.047.155.047.16.045.163.045.167.043.171.043.176.041.178.041.183.039.187.039.19.037.194.035.197.035.202.033.204.031.209.03.212.029.216.027.219.025.222.024.226.021.23.02.233.018.236.016.24.015.243.012.246.01.249.008.253.005.256.004.259.001.26-.001.257-.004.254-.005.25-.008.247-.011.244-.012.241-.014.237-.016.233-.018.231-.021.226-.021.224-.024.22-.026.216-.027.212-.028.21-.031.205-.031.202-.034.198-.034.194-.036.191-.037.187-.039.183-.04.179-.04.175-.042.172-.043.168-.044.163-.045.16-.046.155-.046.152-.047.148-.048.143-.049.139-.049.136-.05.131-.05.126-.05.123-.051.118-.052.114-.051.11-.052.106-.052.101-.052.096-.052.092-.052.088-.053.083-.051.079-.052.074-.052.07-.051.065-.051.06-.051.056-.05.051-.05.023-.024.023-.025.021-.024.02-.024.019-.024.018-.024.017-.024.015-.023.014-.024.013-.023.012-.023.01-.023.01-.022.008-.022.006-.022.006-.022.004-.022.004-.021.001-.021.001-.021v-4.127l-.077.055-.08.053-.083.054-.085.053-.087.052-.09.052-.093.051-.095.05-.097.05-.1.049-.102.049-.105.048-.106.047-.109.047-.111.046-.114.045-.115.045-.118.044-.12.043-.122.042-.124.042-.126.041-.128.04-.13.04-.132.038-.134.038-.135.037-.138.037-.139.035-.142.035-.143.034-.144.033-.147.032-.148.031-.15.03-.151.03-.153.029-.154.027-.156.027-.158.026-.159.025-.161.024-.162.023-.163.022-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.011-.178.01-.179.008-.179.008-.181.006-.182.005-.182.004-.184.003-.184.002h-.37l-.184-.002-.184-.003-.182-.004-.182-.005-.181-.006-.179-.008-.179-.008-.178-.01-.176-.011-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.022-.162-.023-.161-.024-.159-.025-.157-.026-.156-.027-.155-.027-.153-.029-.151-.03-.15-.03-.148-.031-.146-.032-.145-.033-.143-.034-.141-.035-.14-.035-.137-.037-.136-.037-.134-.038-.132-.038-.13-.04-.128-.04-.126-.041-.124-.042-.122-.042-.12-.044-.117-.043-.116-.045-.113-.045-.112-.046-.109-.047-.106-.047-.105-.048-.102-.049-.1-.049-.097-.05-.095-.05-.093-.052-.09-.051-.087-.052-.085-.053-.083-.054-.08-.054-.077-.054v4.127zm0-5.654v.011l.001.021.003.021.004.021.005.022.006.022.007.022.009.022.01.022.011.023.012.023.013.023.015.024.016.023.017.024.018.024.019.024.021.024.022.024.023.025.024.024.052.05.056.05.061.05.066.051.07.051.075.052.079.051.084.052.088.052.092.052.097.052.102.052.105.052.11.051.114.051.119.052.123.05.127.051.131.05.135.049.139.049.144.048.147.048.152.047.155.046.16.045.163.045.167.044.171.042.176.042.178.04.183.04.187.038.19.037.194.036.197.034.202.033.204.032.209.03.212.028.216.027.219.025.222.024.226.022.23.02.233.018.236.016.24.014.243.012.246.01.249.008.253.006.256.003.259.001.26-.001.257-.003.254-.006.25-.008.247-.01.244-.012.241-.015.237-.016.233-.018.231-.02.226-.022.224-.024.22-.025.216-.027.212-.029.21-.03.205-.032.202-.033.198-.035.194-.036.191-.037.187-.039.183-.039.179-.041.175-.042.172-.043.168-.044.163-.045.16-.045.155-.047.152-.047.148-.048.143-.048.139-.05.136-.049.131-.05.126-.051.123-.051.118-.051.114-.052.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.051.07-.052.065-.051.06-.05.056-.051.051-.049.023-.025.023-.024.021-.025.02-.024.019-.024.018-.024.017-.024.015-.023.014-.023.013-.024.012-.022.01-.023.01-.023.008-.022.006-.022.006-.022.004-.021.004-.022.001-.021.001-.021v-4.139l-.077.054-.08.054-.083.054-.085.052-.087.053-.09.051-.093.051-.095.051-.097.05-.1.049-.102.049-.105.048-.106.047-.109.047-.111.046-.114.045-.115.044-.118.044-.12.044-.122.042-.124.042-.126.041-.128.04-.13.039-.132.039-.134.038-.135.037-.138.036-.139.036-.142.035-.143.033-.144.033-.147.033-.148.031-.15.03-.151.03-.153.028-.154.028-.156.027-.158.026-.159.025-.161.024-.162.023-.163.022-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.011-.178.009-.179.009-.179.007-.181.007-.182.005-.182.004-.184.003-.184.002h-.37l-.184-.002-.184-.003-.182-.004-.182-.005-.181-.007-.179-.007-.179-.009-.178-.009-.176-.011-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.022-.162-.023-.161-.024-.159-.025-.157-.026-.156-.027-.155-.028-.153-.028-.151-.03-.15-.03-.148-.031-.146-.033-.145-.033-.143-.033-.141-.035-.14-.036-.137-.036-.136-.037-.134-.038-.132-.039-.13-.039-.128-.04-.126-.041-.124-.042-.122-.043-.12-.043-.117-.044-.116-.044-.113-.046-.112-.046-.109-.046-.106-.047-.105-.048-.102-.049-.1-.049-.097-.05-.095-.051-.093-.051-.09-.051-.087-.053-.085-.052-.083-.054-.08-.054-.077-.054v4.139zm0-5.666v.011l.001.02.003.022.004.021.005.022.006.021.007.022.009.023.01.022.011.023.012.023.013.023.015.023.016.024.017.024.018.023.019.024.021.025.022.024.023.024.024.025.052.05.056.05.061.05.066.051.07.051.075.052.079.051.084.052.088.052.092.052.097.052.102.052.105.051.11.052.114.051.119.051.123.051.127.05.131.05.135.05.139.049.144.048.147.048.152.047.155.046.16.045.163.045.167.043.171.043.176.042.178.04.183.04.187.038.19.037.194.036.197.034.202.033.204.032.209.03.212.028.216.027.219.025.222.024.226.021.23.02.233.018.236.017.24.014.243.012.246.01.249.008.253.006.256.003.259.001.26-.001.257-.003.254-.006.25-.008.247-.01.244-.013.241-.014.237-.016.233-.018.231-.02.226-.022.224-.024.22-.025.216-.027.212-.029.21-.03.205-.032.202-.033.198-.035.194-.036.191-.037.187-.039.183-.039.179-.041.175-.042.172-.043.168-.044.163-.045.16-.045.155-.047.152-.047.148-.048.143-.049.139-.049.136-.049.131-.051.126-.05.123-.051.118-.052.114-.051.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.052.07-.051.065-.051.06-.051.056-.05.051-.049.023-.025.023-.025.021-.024.02-.024.019-.024.018-.024.017-.024.015-.023.014-.024.013-.023.012-.023.01-.022.01-.023.008-.022.006-.022.006-.022.004-.022.004-.021.001-.021.001-.021v-4.153l-.077.054-.08.054-.083.053-.085.053-.087.053-.09.051-.093.051-.095.051-.097.05-.1.049-.102.048-.105.048-.106.048-.109.046-.111.046-.114.046-.115.044-.118.044-.12.043-.122.043-.124.042-.126.041-.128.04-.13.039-.132.039-.134.038-.135.037-.138.036-.139.036-.142.034-.143.034-.144.033-.147.032-.148.032-.15.03-.151.03-.153.028-.154.028-.156.027-.158.026-.159.024-.161.024-.162.023-.163.023-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.01-.178.01-.179.009-.179.007-.181.006-.182.006-.182.004-.184.003-.184.001-.185.001-.185-.001-.184-.001-.184-.003-.182-.004-.182-.006-.181-.006-.179-.007-.179-.009-.178-.01-.176-.01-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.023-.162-.023-.161-.024-.159-.024-.157-.026-.156-.027-.155-.028-.153-.028-.151-.03-.15-.03-.148-.032-.146-.032-.145-.033-.143-.034-.141-.034-.14-.036-.137-.036-.136-.037-.134-.038-.132-.039-.13-.039-.128-.041-.126-.041-.124-.041-.122-.043-.12-.043-.117-.044-.116-.044-.113-.046-.112-.046-.109-.046-.106-.048-.105-.048-.102-.048-.1-.05-.097-.049-.095-.051-.093-.051-.09-.052-.087-.052-.085-.053-.083-.053-.08-.054-.077-.054v4.153zm8.74-8.179l-.257.004-.254.005-.25.008-.247.011-.244.012-.241.014-.237.016-.233.018-.231.021-.226.022-.224.023-.22.026-.216.027-.212.028-.21.031-.205.032-.202.033-.198.034-.194.036-.191.038-.187.038-.183.04-.179.041-.175.042-.172.043-.168.043-.163.045-.16.046-.155.046-.152.048-.148.048-.143.048-.139.049-.136.05-.131.05-.126.051-.123.051-.118.051-.114.052-.11.052-.106.052-.101.052-.096.052-.092.052-.088.052-.083.052-.079.052-.074.051-.07.052-.065.051-.06.05-.056.05-.051.05-.023.025-.023.024-.021.024-.02.025-.019.024-.018.024-.017.023-.015.024-.014.023-.013.023-.012.023-.01.023-.01.022-.008.022-.006.023-.006.021-.004.022-.004.021-.001.021-.001.021.001.021.001.021.004.021.004.022.006.021.006.023.008.022.01.022.01.023.012.023.013.023.014.023.015.024.017.023.018.024.019.024.02.025.021.024.023.024.023.025.051.05.056.05.06.05.065.051.07.052.074.051.079.052.083.052.088.052.092.052.096.052.101.052.106.052.11.052.114.052.118.051.123.051.126.051.131.05.136.05.139.049.143.048.148.048.152.048.155.046.16.046.163.045.168.043.172.043.175.042.179.041.183.04.187.038.191.038.194.036.198.034.202.033.205.032.21.031.212.028.216.027.22.026.224.023.226.022.231.021.233.018.237.016.241.014.244.012.247.011.25.008.254.005.257.004.26.001.26-.001.257-.004.254-.005.25-.008.247-.011.244-.012.241-.014.237-.016.233-.018.231-.021.226-.022.224-.023.22-.026.216-.027.212-.028.21-.031.205-.032.202-.033.198-.034.194-.036.191-.038.187-.038.183-.04.179-.041.175-.042.172-.043.168-.043.163-.045.16-.046.155-.046.152-.048.148-.048.143-.048.139-.049.136-.05.131-.05.126-.051.123-.051.118-.051.114-.052.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.051.07-.052.065-.051.06-.05.056-.05.051-.05.023-.025.023-.024.021-.024.02-.025.019-.024.018-.024.017-.023.015-.024.014-.023.013-.023.012-.023.01-.023.01-.022.008-.022.006-.023.006-.021.004-.022.004-.021.001-.021.001-.021-.001-.021-.001-.021-.004-.021-.004-.022-.006-.021-.006-.023-.008-.022-.01-.022-.01-.023-.012-.023-.013-.023-.014-.023-.015-.024-.017-.023-.018-.024-.019-.024-.02-.025-.021-.024-.023-.024-.023-.025-.051-.05-.056-.05-.06-.05-.065-.051-.07-.052-.074-.051-.079-.052-.083-.052-.088-.052-.092-.052-.096-.052-.101-.052-.106-.052-.11-.052-.114-.052-.118-.051-.123-.051-.126-.051-.131-.05-.136-.05-.139-.049-.143-.048-.148-.048-.152-.048-.155-.046-.16-.046-.163-.045-.168-.043-.172-.043-.175-.042-.179-.041-.183-.04-.187-.038-.191-.038-.194-.036-.198-.034-.202-.033-.205-.032-.21-.031-.212-.028-.216-.027-.22-.026-.224-.023-.226-.022-.231-.021-.233-.018-.237-.016-.241-.014-.244-.012-.247-.011-.25-.008-.254-.005-.257-.004-.26-.001-.26.001z"
  );
};
const insertComputerIcon$1 = function(elem) {
  elem.append("defs").append("symbol").attr("id", "computer").attr("width", "24").attr("height", "24").append("path").attr("transform", "scale(.5)").attr(
    "d",
    "M2 2v13h20v-13h-20zm18 11h-16v-9h16v9zm-10.228 6l.466-1h3.524l.467 1h-4.457zm14.228 3h-24l2-6h2.104l-1.33 4h18.45l-1.297-4h2.073l2 6zm-5-10h-14v-7h14v7z"
  );
};
const insertClockIcon$1 = function(elem) {
  elem.append("defs").append("symbol").attr("id", "clock").attr("width", "24").attr("height", "24").append("path").attr("transform", "scale(.5)").attr(
    "d",
    "M12 2c5.514 0 10 4.486 10 10s-4.486 10-10 10-10-4.486-10-10 4.486-10 10-10zm0-2c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm5.848 12.459c.202.038.202.333.001.372-1.907.361-6.045 1.111-6.547 1.111-.719 0-1.301-.582-1.301-1.301 0-.512.77-5.447 1.125-7.445.034-.192.312-.181.343.014l.985 6.238 5.394 1.011z"
  );
};
const insertArrowHead$1 = function(elem) {
  elem.append("defs").append("marker").attr("id", "arrowhead").attr("refX", 9).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 0 0 L 10 5 L 0 10 z");
};
const insertArrowEnd = function(elem) {
  elem.append("defs").append("marker").attr("id", "arrowend").attr("refX", 1).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 10 0 L 0 5 L 10 10 z");
};
const insertArrowFilledHead$1 = function(elem) {
  elem.append("defs").append("marker").attr("id", "filled-head").attr("refX", 18).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L14,7 L9,1 Z");
};
const insertDynamicNumber = function(elem) {
  elem.append("defs").append("marker").attr("id", "sequencenumber").attr("refX", 15).attr("refY", 15).attr("markerWidth", 60).attr("markerHeight", 40).attr("orient", "auto").append("circle").attr("cx", 15).attr("cy", 15).attr("r", 6);
};
const insertArrowCrossHead$1 = function(elem) {
  const defs = elem.append("defs");
  const marker = defs.append("marker").attr("id", "crosshead").attr("markerWidth", 15).attr("markerHeight", 8).attr("orient", "auto").attr("refX", 16).attr("refY", 4);
  marker.append("path").attr("fill", "black").attr("stroke", "#000000").style("stroke-dasharray", "0, 0").attr("stroke-width", "1px").attr("d", "M 9,2 V 6 L16,4 Z");
  marker.append("path").attr("fill", "none").attr("stroke", "#000000").style("stroke-dasharray", "0, 0").attr("stroke-width", "1px").attr("d", "M 0,1 L 6,7 M 6,1 L 0,7");
};
const getNoteRect$2 = function() {
  return {
    x: 0,
    y: 0,
    fill: "#EDF2AE",
    stroke: "#666",
    width: 100,
    anchor: "start",
    height: 100,
    rx: 0,
    ry: 0
  };
};
const getC4ShapeFont = (cnf, typeC4Shape) => {
  return {
    fontFamily: cnf[typeC4Shape + "FontFamily"],
    fontSize: cnf[typeC4Shape + "FontSize"],
    fontWeight: cnf[typeC4Shape + "FontWeight"]
  };
};
const _drawTextCandidateFunc$2 = function() {
  function byText(content, g, x, y, width2, height2, textAttrs) {
    const text = g.append("text").attr("x", x + width2 / 2).attr("y", y + height2 / 2 + 5).style("text-anchor", "middle").text(content);
    _setTextAttrs(text, textAttrs);
  }
  function byTspan(content, g, x, y, width2, height2, textAttrs, conf2) {
    const { fontSize, fontFamily, fontWeight } = conf2;
    const lines = content.split(common$1.lineBreakRegex);
    for (let i = 0; i < lines.length; i++) {
      const dy = i * fontSize - fontSize * (lines.length - 1) / 2;
      const text = g.append("text").attr("x", x + width2 / 2).attr("y", y).style("text-anchor", "middle").attr("dominant-baseline", "middle").style("font-size", fontSize).style("font-weight", fontWeight).style("font-family", fontFamily);
      text.append("tspan").attr("dy", dy).text(lines[i]).attr("alignment-baseline", "mathematical");
      _setTextAttrs(text, textAttrs);
    }
  }
  function byFo(content, g, x, y, width2, height2, textAttrs, conf2) {
    const s = g.append("switch");
    const f = s.append("foreignObject").attr("x", x).attr("y", y).attr("width", width2).attr("height", height2);
    const text = f.append("xhtml:div").style("display", "table").style("height", "100%").style("width", "100%");
    text.append("div").style("display", "table-cell").style("text-align", "center").style("vertical-align", "middle").text(content);
    byTspan(content, s, x, y, width2, height2, textAttrs, conf2);
    _setTextAttrs(text, textAttrs);
  }
  function _setTextAttrs(toText, fromTextAttrsDict) {
    for (const key in fromTextAttrsDict) {
      if (fromTextAttrsDict.hasOwnProperty(key)) {
        toText.attr(key, fromTextAttrsDict[key]);
      }
    }
  }
  return function(conf2) {
    return conf2.textPlacement === "fo" ? byFo : conf2.textPlacement === "old" ? byText : byTspan;
  };
}();
const svgDraw$3 = {
  drawRect: drawRect$2,
  drawBoundary: drawBoundary$1,
  drawC4Shape,
  drawRels: drawRels$1,
  drawImage: drawImage$1,
  insertArrowHead: insertArrowHead$1,
  insertArrowEnd,
  insertArrowFilledHead: insertArrowFilledHead$1,
  insertDynamicNumber,
  insertArrowCrossHead: insertArrowCrossHead$1,
  insertDatabaseIcon: insertDatabaseIcon$1,
  insertComputerIcon: insertComputerIcon$1,
  insertClockIcon: insertClockIcon$1,
  getNoteRect: getNoteRect$2,
  sanitizeUrl
  // TODO why is this exported?
};
let globalBoundaryMaxX = 0, globalBoundaryMaxY = 0;
let c4ShapeInRow = 4;
let c4BoundaryInRow = 2;
parser$b.yy = c4Db;
let conf$a = {};
class Bounds {
  constructor(diagObj) {
    this.name = "";
    this.data = {};
    this.data.startx = void 0;
    this.data.stopx = void 0;
    this.data.starty = void 0;
    this.data.stopy = void 0;
    this.data.widthLimit = void 0;
    this.nextData = {};
    this.nextData.startx = void 0;
    this.nextData.stopx = void 0;
    this.nextData.starty = void 0;
    this.nextData.stopy = void 0;
    this.nextData.cnt = 0;
    setConf$a(diagObj.db.getConfig());
  }
  setData(startx, stopx, starty, stopy) {
    this.nextData.startx = this.data.startx = startx;
    this.nextData.stopx = this.data.stopx = stopx;
    this.nextData.starty = this.data.starty = starty;
    this.nextData.stopy = this.data.stopy = stopy;
  }
  updateVal(obj, key, val, fun) {
    if (obj[key] === void 0) {
      obj[key] = val;
    } else {
      obj[key] = fun(val, obj[key]);
    }
  }
  insert(c4Shape) {
    this.nextData.cnt = this.nextData.cnt + 1;
    let _startx = this.nextData.startx === this.nextData.stopx ? this.nextData.stopx + c4Shape.margin : this.nextData.stopx + c4Shape.margin * 2;
    let _stopx = _startx + c4Shape.width;
    let _starty = this.nextData.starty + c4Shape.margin * 2;
    let _stopy = _starty + c4Shape.height;
    if (_startx >= this.data.widthLimit || _stopx >= this.data.widthLimit || this.nextData.cnt > c4ShapeInRow) {
      _startx = this.nextData.startx + c4Shape.margin + conf$a.nextLinePaddingX;
      _starty = this.nextData.stopy + c4Shape.margin * 2;
      this.nextData.stopx = _stopx = _startx + c4Shape.width;
      this.nextData.starty = this.nextData.stopy;
      this.nextData.stopy = _stopy = _starty + c4Shape.height;
      this.nextData.cnt = 1;
    }
    c4Shape.x = _startx;
    c4Shape.y = _starty;
    this.updateVal(this.data, "startx", _startx, Math.min);
    this.updateVal(this.data, "starty", _starty, Math.min);
    this.updateVal(this.data, "stopx", _stopx, Math.max);
    this.updateVal(this.data, "stopy", _stopy, Math.max);
    this.updateVal(this.nextData, "startx", _startx, Math.min);
    this.updateVal(this.nextData, "starty", _starty, Math.min);
    this.updateVal(this.nextData, "stopx", _stopx, Math.max);
    this.updateVal(this.nextData, "stopy", _stopy, Math.max);
  }
  init(diagObj) {
    this.name = "";
    this.data = {
      startx: void 0,
      stopx: void 0,
      starty: void 0,
      stopy: void 0,
      widthLimit: void 0
    };
    this.nextData = {
      startx: void 0,
      stopx: void 0,
      starty: void 0,
      stopy: void 0,
      cnt: 0
    };
    setConf$a(diagObj.db.getConfig());
  }
  bumpLastMargin(margin) {
    this.data.stopx += margin;
    this.data.stopy += margin;
  }
}
const setConf$a = function(cnf) {
  assignWithDepth$1(conf$a, cnf);
  if (cnf.fontFamily) {
    conf$a.personFontFamily = conf$a.systemFontFamily = conf$a.messageFontFamily = cnf.fontFamily;
  }
  if (cnf.fontSize) {
    conf$a.personFontSize = conf$a.systemFontSize = conf$a.messageFontSize = cnf.fontSize;
  }
  if (cnf.fontWeight) {
    conf$a.personFontWeight = conf$a.systemFontWeight = conf$a.messageFontWeight = cnf.fontWeight;
  }
};
const c4ShapeFont = (cnf, typeC4Shape) => {
  return {
    fontFamily: cnf[typeC4Shape + "FontFamily"],
    fontSize: cnf[typeC4Shape + "FontSize"],
    fontWeight: cnf[typeC4Shape + "FontWeight"]
  };
};
const boundaryFont = (cnf) => {
  return {
    fontFamily: cnf.boundaryFontFamily,
    fontSize: cnf.boundaryFontSize,
    fontWeight: cnf.boundaryFontWeight
  };
};
const messageFont$1 = (cnf) => {
  return {
    fontFamily: cnf.messageFontFamily,
    fontSize: cnf.messageFontSize,
    fontWeight: cnf.messageFontWeight
  };
};
function calcC4ShapeTextWH(textType, c4Shape, c4ShapeTextWrap, textConf, textLimitWidth) {
  if (!c4Shape[textType].width) {
    if (c4ShapeTextWrap) {
      c4Shape[textType].text = wrapLabel(c4Shape[textType].text, textLimitWidth, textConf);
      c4Shape[textType].textLines = c4Shape[textType].text.split(common$1.lineBreakRegex).length;
      c4Shape[textType].width = textLimitWidth;
      c4Shape[textType].height = calculateTextHeight(c4Shape[textType].text, textConf);
    } else {
      let lines = c4Shape[textType].text.split(common$1.lineBreakRegex);
      c4Shape[textType].textLines = lines.length;
      let lineHeight = 0;
      c4Shape[textType].height = 0;
      c4Shape[textType].width = 0;
      for (const line2 of lines) {
        c4Shape[textType].width = Math.max(
          calculateTextWidth(line2, textConf),
          c4Shape[textType].width
        );
        lineHeight = calculateTextHeight(line2, textConf);
        c4Shape[textType].height = c4Shape[textType].height + lineHeight;
      }
    }
  }
}
const drawBoundary = function(diagram, boundary, bounds2) {
  boundary.x = bounds2.data.startx;
  boundary.y = bounds2.data.starty;
  boundary.width = bounds2.data.stopx - bounds2.data.startx;
  boundary.height = bounds2.data.stopy - bounds2.data.starty;
  boundary.label.y = conf$a.c4ShapeMargin - 35;
  let boundaryTextWrap = boundary.wrap && conf$a.wrap;
  let boundaryLabelConf = boundaryFont(conf$a);
  boundaryLabelConf.fontSize = boundaryLabelConf.fontSize + 2;
  boundaryLabelConf.fontWeight = "bold";
  let textLimitWidth = calculateTextWidth(boundary.label.text, boundaryLabelConf);
  calcC4ShapeTextWH("label", boundary, boundaryTextWrap, boundaryLabelConf, textLimitWidth);
  svgDraw$3.drawBoundary(diagram, boundary, conf$a);
};
const drawC4ShapeArray = function(currentBounds, diagram, c4ShapeArray2, c4ShapeKeys) {
  let Y = 0;
  for (const c4ShapeKey of c4ShapeKeys) {
    Y = 0;
    const c4Shape = c4ShapeArray2[c4ShapeKey];
    let c4ShapeTypeConf = c4ShapeFont(conf$a, c4Shape.typeC4Shape.text);
    c4ShapeTypeConf.fontSize = c4ShapeTypeConf.fontSize - 2;
    c4Shape.typeC4Shape.width = calculateTextWidth(
      "<<" + c4Shape.typeC4Shape.text + ">>",
      c4ShapeTypeConf
    );
    c4Shape.typeC4Shape.height = c4ShapeTypeConf.fontSize + 2;
    c4Shape.typeC4Shape.Y = conf$a.c4ShapePadding;
    Y = c4Shape.typeC4Shape.Y + c4Shape.typeC4Shape.height - 4;
    c4Shape.image = { width: 0, height: 0, Y: 0 };
    switch (c4Shape.typeC4Shape.text) {
      case "person":
      case "external_person":
        c4Shape.image.width = 48;
        c4Shape.image.height = 48;
        c4Shape.image.Y = Y;
        Y = c4Shape.image.Y + c4Shape.image.height;
        break;
    }
    if (c4Shape.sprite) {
      c4Shape.image.width = 48;
      c4Shape.image.height = 48;
      c4Shape.image.Y = Y;
      Y = c4Shape.image.Y + c4Shape.image.height;
    }
    let c4ShapeTextWrap = c4Shape.wrap && conf$a.wrap;
    let textLimitWidth = conf$a.width - conf$a.c4ShapePadding * 2;
    let c4ShapeLabelConf = c4ShapeFont(conf$a, c4Shape.typeC4Shape.text);
    c4ShapeLabelConf.fontSize = c4ShapeLabelConf.fontSize + 2;
    c4ShapeLabelConf.fontWeight = "bold";
    calcC4ShapeTextWH("label", c4Shape, c4ShapeTextWrap, c4ShapeLabelConf, textLimitWidth);
    c4Shape["label"].Y = Y + 8;
    Y = c4Shape["label"].Y + c4Shape["label"].height;
    if (c4Shape.type && c4Shape.type.text !== "") {
      c4Shape.type.text = "[" + c4Shape.type.text + "]";
      let c4ShapeTypeConf2 = c4ShapeFont(conf$a, c4Shape.typeC4Shape.text);
      calcC4ShapeTextWH("type", c4Shape, c4ShapeTextWrap, c4ShapeTypeConf2, textLimitWidth);
      c4Shape["type"].Y = Y + 5;
      Y = c4Shape["type"].Y + c4Shape["type"].height;
    } else if (c4Shape.techn && c4Shape.techn.text !== "") {
      c4Shape.techn.text = "[" + c4Shape.techn.text + "]";
      let c4ShapeTechnConf = c4ShapeFont(conf$a, c4Shape.techn.text);
      calcC4ShapeTextWH("techn", c4Shape, c4ShapeTextWrap, c4ShapeTechnConf, textLimitWidth);
      c4Shape["techn"].Y = Y + 5;
      Y = c4Shape["techn"].Y + c4Shape["techn"].height;
    }
    let rectHeight = Y;
    let rectWidth = c4Shape.label.width;
    if (c4Shape.descr && c4Shape.descr.text !== "") {
      let c4ShapeDescrConf = c4ShapeFont(conf$a, c4Shape.typeC4Shape.text);
      calcC4ShapeTextWH("descr", c4Shape, c4ShapeTextWrap, c4ShapeDescrConf, textLimitWidth);
      c4Shape["descr"].Y = Y + 20;
      Y = c4Shape["descr"].Y + c4Shape["descr"].height;
      rectWidth = Math.max(c4Shape.label.width, c4Shape.descr.width);
      rectHeight = Y - c4Shape["descr"].textLines * 5;
    }
    rectWidth = rectWidth + conf$a.c4ShapePadding;
    c4Shape.width = Math.max(c4Shape.width || conf$a.width, rectWidth, conf$a.width);
    c4Shape.height = Math.max(c4Shape.height || conf$a.height, rectHeight, conf$a.height);
    c4Shape.margin = c4Shape.margin || conf$a.c4ShapeMargin;
    currentBounds.insert(c4Shape);
    svgDraw$3.drawC4Shape(diagram, c4Shape, conf$a);
  }
  currentBounds.bumpLastMargin(conf$a.c4ShapeMargin);
};
class Point {
  constructor(x, y) {
    this.x = x;
    this.y = y;
  }
}
let getIntersectPoint = function(fromNode, endPoint) {
  let x1 = fromNode.x;
  let y1 = fromNode.y;
  let x2 = endPoint.x;
  let y2 = endPoint.y;
  let fromCenterX = x1 + fromNode.width / 2;
  let fromCenterY = y1 + fromNode.height / 2;
  let dx = Math.abs(x1 - x2);
  let dy = Math.abs(y1 - y2);
  let tanDYX = dy / dx;
  let fromDYX = fromNode.height / fromNode.width;
  let returnPoint = null;
  if (y1 == y2 && x1 < x2) {
    returnPoint = new Point(x1 + fromNode.width, fromCenterY);
  } else if (y1 == y2 && x1 > x2) {
    returnPoint = new Point(x1, fromCenterY);
  } else if (x1 == x2 && y1 < y2) {
    returnPoint = new Point(fromCenterX, y1 + fromNode.height);
  } else if (x1 == x2 && y1 > y2) {
    returnPoint = new Point(fromCenterX, y1);
  }
  if (x1 > x2 && y1 < y2) {
    if (fromDYX >= tanDYX) {
      returnPoint = new Point(x1, fromCenterY + tanDYX * fromNode.width / 2);
    } else {
      returnPoint = new Point(
        fromCenterX - dx / dy * fromNode.height / 2,
        y1 + fromNode.height
      );
    }
  } else if (x1 < x2 && y1 < y2) {
    if (fromDYX >= tanDYX) {
      returnPoint = new Point(x1 + fromNode.width, fromCenterY + tanDYX * fromNode.width / 2);
    } else {
      returnPoint = new Point(
        fromCenterX + dx / dy * fromNode.height / 2,
        y1 + fromNode.height
      );
    }
  } else if (x1 < x2 && y1 > y2) {
    if (fromDYX >= tanDYX) {
      returnPoint = new Point(x1 + fromNode.width, fromCenterY - tanDYX * fromNode.width / 2);
    } else {
      returnPoint = new Point(fromCenterX + fromNode.height / 2 * dx / dy, y1);
    }
  } else if (x1 > x2 && y1 > y2) {
    if (fromDYX >= tanDYX) {
      returnPoint = new Point(x1, fromCenterY - fromNode.width / 2 * tanDYX);
    } else {
      returnPoint = new Point(fromCenterX - fromNode.height / 2 * dx / dy, y1);
    }
  }
  return returnPoint;
};
let getIntersectPoints = function(fromNode, endNode) {
  let endIntersectPoint = { x: 0, y: 0 };
  endIntersectPoint.x = endNode.x + endNode.width / 2;
  endIntersectPoint.y = endNode.y + endNode.height / 2;
  let startPoint = getIntersectPoint(fromNode, endIntersectPoint);
  endIntersectPoint.x = fromNode.x + fromNode.width / 2;
  endIntersectPoint.y = fromNode.y + fromNode.height / 2;
  let endPoint = getIntersectPoint(endNode, endIntersectPoint);
  return { startPoint, endPoint };
};
const drawRels = function(diagram, rels2, getC4ShapeObj, diagObj) {
  let i = 0;
  for (let rel of rels2) {
    i = i + 1;
    let relTextWrap = rel.wrap && conf$a.wrap;
    let relConf = messageFont$1(conf$a);
    let diagramType = diagObj.db.getC4Type();
    if (diagramType === "C4Dynamic") {
      rel.label.text = i + ": " + rel.label.text;
    }
    let textLimitWidth = calculateTextWidth(rel.label.text, relConf);
    calcC4ShapeTextWH("label", rel, relTextWrap, relConf, textLimitWidth);
    if (rel.techn && rel.techn.text !== "") {
      textLimitWidth = calculateTextWidth(rel.techn.text, relConf);
      calcC4ShapeTextWH("techn", rel, relTextWrap, relConf, textLimitWidth);
    }
    if (rel.descr && rel.descr.text !== "") {
      textLimitWidth = calculateTextWidth(rel.descr.text, relConf);
      calcC4ShapeTextWH("descr", rel, relTextWrap, relConf, textLimitWidth);
    }
    let fromNode = getC4ShapeObj(rel.from);
    let endNode = getC4ShapeObj(rel.to);
    let points = getIntersectPoints(fromNode, endNode);
    rel.startPoint = points.startPoint;
    rel.endPoint = points.endPoint;
  }
  svgDraw$3.drawRels(diagram, rels2, conf$a);
};
function drawInsideBoundary(diagram, parentBoundaryAlias, parentBounds, currentBoundaries, diagObj) {
  let currentBounds = new Bounds(diagObj);
  currentBounds.data.widthLimit = parentBounds.data.widthLimit / Math.min(c4BoundaryInRow, currentBoundaries.length);
  for (let [i, currentBoundary] of currentBoundaries.entries()) {
    let Y = 0;
    currentBoundary.image = { width: 0, height: 0, Y: 0 };
    if (currentBoundary.sprite) {
      currentBoundary.image.width = 48;
      currentBoundary.image.height = 48;
      currentBoundary.image.Y = Y;
      Y = currentBoundary.image.Y + currentBoundary.image.height;
    }
    let currentBoundaryTextWrap = currentBoundary.wrap && conf$a.wrap;
    let currentBoundaryLabelConf = boundaryFont(conf$a);
    currentBoundaryLabelConf.fontSize = currentBoundaryLabelConf.fontSize + 2;
    currentBoundaryLabelConf.fontWeight = "bold";
    calcC4ShapeTextWH(
      "label",
      currentBoundary,
      currentBoundaryTextWrap,
      currentBoundaryLabelConf,
      currentBounds.data.widthLimit
    );
    currentBoundary["label"].Y = Y + 8;
    Y = currentBoundary["label"].Y + currentBoundary["label"].height;
    if (currentBoundary.type && currentBoundary.type.text !== "") {
      currentBoundary.type.text = "[" + currentBoundary.type.text + "]";
      let currentBoundaryTypeConf = boundaryFont(conf$a);
      calcC4ShapeTextWH(
        "type",
        currentBoundary,
        currentBoundaryTextWrap,
        currentBoundaryTypeConf,
        currentBounds.data.widthLimit
      );
      currentBoundary["type"].Y = Y + 5;
      Y = currentBoundary["type"].Y + currentBoundary["type"].height;
    }
    if (currentBoundary.descr && currentBoundary.descr.text !== "") {
      let currentBoundaryDescrConf = boundaryFont(conf$a);
      currentBoundaryDescrConf.fontSize = currentBoundaryDescrConf.fontSize - 2;
      calcC4ShapeTextWH(
        "descr",
        currentBoundary,
        currentBoundaryTextWrap,
        currentBoundaryDescrConf,
        currentBounds.data.widthLimit
      );
      currentBoundary["descr"].Y = Y + 20;
      Y = currentBoundary["descr"].Y + currentBoundary["descr"].height;
    }
    if (i == 0 || i % c4BoundaryInRow === 0) {
      let _x = parentBounds.data.startx + conf$a.diagramMarginX;
      let _y = parentBounds.data.stopy + conf$a.diagramMarginY + Y;
      currentBounds.setData(_x, _x, _y, _y);
    } else {
      let _x = currentBounds.data.stopx !== currentBounds.data.startx ? currentBounds.data.stopx + conf$a.diagramMarginX : currentBounds.data.startx;
      let _y = currentBounds.data.starty;
      currentBounds.setData(_x, _x, _y, _y);
    }
    currentBounds.name = currentBoundary.alias;
    let currentPersonOrSystemArray = diagObj.db.getC4ShapeArray(currentBoundary.alias);
    let currentPersonOrSystemKeys = diagObj.db.getC4ShapeKeys(currentBoundary.alias);
    if (currentPersonOrSystemKeys.length > 0) {
      drawC4ShapeArray(
        currentBounds,
        diagram,
        currentPersonOrSystemArray,
        currentPersonOrSystemKeys
      );
    }
    parentBoundaryAlias = currentBoundary.alias;
    let nextCurrentBoundarys = diagObj.db.getBoundarys(parentBoundaryAlias);
    if (nextCurrentBoundarys.length > 0) {
      drawInsideBoundary(
        diagram,
        parentBoundaryAlias,
        currentBounds,
        nextCurrentBoundarys,
        diagObj
      );
    }
    if (currentBoundary.alias !== "global") {
      drawBoundary(diagram, currentBoundary, currentBounds);
    }
    parentBounds.data.stopy = Math.max(
      currentBounds.data.stopy + conf$a.c4ShapeMargin,
      parentBounds.data.stopy
    );
    parentBounds.data.stopx = Math.max(
      currentBounds.data.stopx + conf$a.c4ShapeMargin,
      parentBounds.data.stopx
    );
    globalBoundaryMaxX = Math.max(globalBoundaryMaxX, parentBounds.data.stopx);
    globalBoundaryMaxY = Math.max(globalBoundaryMaxY, parentBounds.data.stopy);
  }
}
const draw$e = function(_text, id2, _version, diagObj) {
  conf$a = getConfig$1().c4;
  const securityLevel = getConfig$1().securityLevel;
  let sandboxElement;
  if (securityLevel === "sandbox") {
    sandboxElement = select("#i" + id2);
  }
  const root = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
  let db2 = diagObj.db;
  diagObj.db.setWrap(conf$a.wrap);
  c4ShapeInRow = db2.getC4ShapeInRow();
  c4BoundaryInRow = db2.getC4BoundaryInRow();
  log$1.debug(`C:${JSON.stringify(conf$a, null, 2)}`);
  const diagram = securityLevel === "sandbox" ? root.select(`[id="${id2}"]`) : select(`[id="${id2}"]`);
  svgDraw$3.insertComputerIcon(diagram);
  svgDraw$3.insertDatabaseIcon(diagram);
  svgDraw$3.insertClockIcon(diagram);
  let screenBounds = new Bounds(diagObj);
  screenBounds.setData(
    conf$a.diagramMarginX,
    conf$a.diagramMarginX,
    conf$a.diagramMarginY,
    conf$a.diagramMarginY
  );
  screenBounds.data.widthLimit = screen.availWidth;
  globalBoundaryMaxX = conf$a.diagramMarginX;
  globalBoundaryMaxY = conf$a.diagramMarginY;
  const title2 = diagObj.db.getTitle();
  let currentBoundaries = diagObj.db.getBoundarys("");
  drawInsideBoundary(diagram, "", screenBounds, currentBoundaries, diagObj);
  svgDraw$3.insertArrowHead(diagram);
  svgDraw$3.insertArrowEnd(diagram);
  svgDraw$3.insertArrowCrossHead(diagram);
  svgDraw$3.insertArrowFilledHead(diagram);
  drawRels(diagram, diagObj.db.getRels(), diagObj.db.getC4Shape, diagObj);
  screenBounds.data.stopx = globalBoundaryMaxX;
  screenBounds.data.stopy = globalBoundaryMaxY;
  const box = screenBounds.data;
  let boxHeight = box.stopy - box.starty;
  let height2 = boxHeight + 2 * conf$a.diagramMarginY;
  let boxWidth = box.stopx - box.startx;
  const width2 = boxWidth + 2 * conf$a.diagramMarginX;
  if (title2) {
    diagram.append("text").text(title2).attr("x", (box.stopx - box.startx) / 2 - 4 * conf$a.diagramMarginX).attr("y", box.starty + conf$a.diagramMarginY);
  }
  configureSvgSize(diagram, height2, width2, conf$a.useMaxWidth);
  const extraVertForTitle = title2 ? 60 : 0;
  diagram.attr(
    "viewBox",
    box.startx - conf$a.diagramMarginX + " -" + (conf$a.diagramMarginY + extraVertForTitle) + " " + width2 + " " + (height2 + extraVertForTitle)
  );
  log$1.debug(`models:`, box);
};
const c4Renderer = {
  drawPersonOrSystemArray: drawC4ShapeArray,
  drawBoundary,
  setConf: setConf$a,
  draw: draw$e
};
var parser$a = function() {
  var o = function(k, v, o2, l) {
    for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
      ;
    return o2;
  }, $V0 = [1, 3], $V1 = [1, 7], $V2 = [1, 8], $V3 = [1, 9], $V4 = [1, 10], $V5 = [1, 13], $V6 = [1, 12], $V7 = [1, 16, 25], $V8 = [1, 20], $V9 = [1, 32], $Va = [1, 33], $Vb = [1, 34], $Vc = [1, 36], $Vd = [1, 39], $Ve = [1, 37], $Vf = [1, 38], $Vg = [1, 44], $Vh = [1, 45], $Vi = [1, 40], $Vj = [1, 41], $Vk = [1, 42], $Vl = [1, 43], $Vm = [1, 48], $Vn = [1, 49], $Vo = [1, 50], $Vp = [1, 51], $Vq = [16, 25], $Vr = [1, 65], $Vs = [1, 66], $Vt = [1, 67], $Vu = [1, 68], $Vv = [1, 69], $Vw = [1, 70], $Vx = [1, 71], $Vy = [1, 80], $Vz = [16, 25, 32, 45, 46, 54, 60, 61, 62, 63, 64, 65, 66, 71, 73], $VA = [16, 25, 30, 32, 45, 46, 50, 54, 60, 61, 62, 63, 64, 65, 66, 71, 73, 88, 89, 90, 91], $VB = [5, 8, 9, 10, 11, 16, 19, 23, 25], $VC = [54, 88, 89, 90, 91], $VD = [54, 65, 66, 88, 89, 90, 91], $VE = [54, 60, 61, 62, 63, 64, 88, 89, 90, 91], $VF = [16, 25, 32], $VG = [1, 107];
  var parser2 = {
    trace: function trace() {
    },
    yy: {},
    symbols_: { "error": 2, "start": 3, "mermaidDoc": 4, "statments": 5, "direction": 6, "directive": 7, "direction_tb": 8, "direction_bt": 9, "direction_rl": 10, "direction_lr": 11, "graphConfig": 12, "openDirective": 13, "typeDirective": 14, "closeDirective": 15, "NEWLINE": 16, ":": 17, "argDirective": 18, "open_directive": 19, "type_directive": 20, "arg_directive": 21, "close_directive": 22, "CLASS_DIAGRAM": 23, "statements": 24, "EOF": 25, "statement": 26, "className": 27, "alphaNumToken": 28, "classLiteralName": 29, "GENERICTYPE": 30, "relationStatement": 31, "LABEL": 32, "classStatement": 33, "methodStatement": 34, "annotationStatement": 35, "clickStatement": 36, "cssClassStatement": 37, "noteStatement": 38, "acc_title": 39, "acc_title_value": 40, "acc_descr": 41, "acc_descr_value": 42, "acc_descr_multiline_value": 43, "CLASS": 44, "STYLE_SEPARATOR": 45, "STRUCT_START": 46, "members": 47, "STRUCT_STOP": 48, "ANNOTATION_START": 49, "ANNOTATION_END": 50, "MEMBER": 51, "SEPARATOR": 52, "relation": 53, "STR": 54, "NOTE_FOR": 55, "noteText": 56, "NOTE": 57, "relationType": 58, "lineType": 59, "AGGREGATION": 60, "EXTENSION": 61, "COMPOSITION": 62, "DEPENDENCY": 63, "LOLLIPOP": 64, "LINE": 65, "DOTTED_LINE": 66, "CALLBACK": 67, "LINK": 68, "LINK_TARGET": 69, "CLICK": 70, "CALLBACK_NAME": 71, "CALLBACK_ARGS": 72, "HREF": 73, "CSSCLASS": 74, "commentToken": 75, "textToken": 76, "graphCodeTokens": 77, "textNoTagsToken": 78, "TAGSTART": 79, "TAGEND": 80, "==": 81, "--": 82, "PCT": 83, "DEFAULT": 84, "SPACE": 85, "MINUS": 86, "keywords": 87, "UNICODE_TEXT": 88, "NUM": 89, "ALPHA": 90, "BQUOTE_STR": 91, "$accept": 0, "$end": 1 },
    terminals_: { 2: "error", 5: "statments", 8: "direction_tb", 9: "direction_bt", 10: "direction_rl", 11: "direction_lr", 16: "NEWLINE", 17: ":", 19: "open_directive", 20: "type_directive", 21: "arg_directive", 22: "close_directive", 23: "CLASS_DIAGRAM", 25: "EOF", 30: "GENERICTYPE", 32: "LABEL", 39: "acc_title", 40: "acc_title_value", 41: "acc_descr", 42: "acc_descr_value", 43: "acc_descr_multiline_value", 44: "CLASS", 45: "STYLE_SEPARATOR", 46: "STRUCT_START", 48: "STRUCT_STOP", 49: "ANNOTATION_START", 50: "ANNOTATION_END", 51: "MEMBER", 52: "SEPARATOR", 54: "STR", 55: "NOTE_FOR", 57: "NOTE", 60: "AGGREGATION", 61: "EXTENSION", 62: "COMPOSITION", 63: "DEPENDENCY", 64: "LOLLIPOP", 65: "LINE", 66: "DOTTED_LINE", 67: "CALLBACK", 68: "LINK", 69: "LINK_TARGET", 70: "CLICK", 71: "CALLBACK_NAME", 72: "CALLBACK_ARGS", 73: "HREF", 74: "CSSCLASS", 77: "graphCodeTokens", 79: "TAGSTART", 80: "TAGEND", 81: "==", 82: "--", 83: "PCT", 84: "DEFAULT", 85: "SPACE", 86: "MINUS", 87: "keywords", 88: "UNICODE_TEXT", 89: "NUM", 90: "ALPHA", 91: "BQUOTE_STR" },
    productions_: [0, [3, 1], [3, 1], [3, 1], [3, 2], [6, 1], [6, 1], [6, 1], [6, 1], [4, 1], [7, 4], [7, 6], [13, 1], [14, 1], [18, 1], [15, 1], [12, 4], [24, 1], [24, 2], [24, 3], [27, 1], [27, 1], [27, 2], [27, 2], [27, 2], [26, 1], [26, 2], [26, 1], [26, 1], [26, 1], [26, 1], [26, 1], [26, 1], [26, 1], [26, 1], [26, 2], [26, 2], [26, 1], [33, 2], [33, 4], [33, 5], [33, 7], [35, 4], [47, 1], [47, 2], [34, 1], [34, 2], [34, 1], [34, 1], [31, 3], [31, 4], [31, 4], [31, 5], [38, 3], [38, 2], [53, 3], [53, 2], [53, 2], [53, 1], [58, 1], [58, 1], [58, 1], [58, 1], [58, 1], [59, 1], [59, 1], [36, 3], [36, 4], [36, 3], [36, 4], [36, 4], [36, 5], [36, 3], [36, 4], [36, 4], [36, 5], [36, 3], [36, 4], [36, 4], [36, 5], [37, 3], [75, 1], [75, 1], [76, 1], [76, 1], [76, 1], [76, 1], [76, 1], [76, 1], [76, 1], [78, 1], [78, 1], [78, 1], [78, 1], [28, 1], [28, 1], [28, 1], [29, 1], [56, 1]],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
      var $0 = $$.length - 1;
      switch (yystate) {
        case 5:
          yy.setDirection("TB");
          break;
        case 6:
          yy.setDirection("BT");
          break;
        case 7:
          yy.setDirection("RL");
          break;
        case 8:
          yy.setDirection("LR");
          break;
        case 12:
          yy.parseDirective("%%{", "open_directive");
          break;
        case 13:
          yy.parseDirective($$[$0], "type_directive");
          break;
        case 14:
          $$[$0] = $$[$0].trim().replace(/'/g, '"');
          yy.parseDirective($$[$0], "arg_directive");
          break;
        case 15:
          yy.parseDirective("}%%", "close_directive", "class");
          break;
        case 20:
        case 21:
          this.$ = $$[$0];
          break;
        case 22:
          this.$ = $$[$0 - 1] + $$[$0];
          break;
        case 23:
        case 24:
          this.$ = $$[$0 - 1] + "~" + $$[$0];
          break;
        case 25:
          yy.addRelation($$[$0]);
          break;
        case 26:
          $$[$0 - 1].title = yy.cleanupLabel($$[$0]);
          yy.addRelation($$[$0 - 1]);
          break;
        case 35:
          this.$ = $$[$0].trim();
          yy.setAccTitle(this.$);
          break;
        case 36:
        case 37:
          this.$ = $$[$0].trim();
          yy.setAccDescription(this.$);
          break;
        case 38:
          yy.addClass($$[$0]);
          break;
        case 39:
          yy.addClass($$[$0 - 2]);
          yy.setCssClass($$[$0 - 2], $$[$0]);
          break;
        case 40:
          yy.addClass($$[$0 - 3]);
          yy.addMembers($$[$0 - 3], $$[$0 - 1]);
          break;
        case 41:
          yy.addClass($$[$0 - 5]);
          yy.setCssClass($$[$0 - 5], $$[$0 - 3]);
          yy.addMembers($$[$0 - 5], $$[$0 - 1]);
          break;
        case 42:
          yy.addAnnotation($$[$0], $$[$0 - 2]);
          break;
        case 43:
          this.$ = [$$[$0]];
          break;
        case 44:
          $$[$0].push($$[$0 - 1]);
          this.$ = $$[$0];
          break;
        case 45:
          break;
        case 46:
          yy.addMember($$[$0 - 1], yy.cleanupLabel($$[$0]));
          break;
        case 47:
          break;
        case 48:
          break;
        case 49:
          this.$ = { "id1": $$[$0 - 2], "id2": $$[$0], relation: $$[$0 - 1], relationTitle1: "none", relationTitle2: "none" };
          break;
        case 50:
          this.$ = { id1: $$[$0 - 3], id2: $$[$0], relation: $$[$0 - 1], relationTitle1: $$[$0 - 2], relationTitle2: "none" };
          break;
        case 51:
          this.$ = { id1: $$[$0 - 3], id2: $$[$0], relation: $$[$0 - 2], relationTitle1: "none", relationTitle2: $$[$0 - 1] };
          break;
        case 52:
          this.$ = { id1: $$[$0 - 4], id2: $$[$0], relation: $$[$0 - 2], relationTitle1: $$[$0 - 3], relationTitle2: $$[$0 - 1] };
          break;
        case 53:
          yy.addNote($$[$0], $$[$0 - 1]);
          break;
        case 54:
          yy.addNote($$[$0]);
          break;
        case 55:
          this.$ = { type1: $$[$0 - 2], type2: $$[$0], lineType: $$[$0 - 1] };
          break;
        case 56:
          this.$ = { type1: "none", type2: $$[$0], lineType: $$[$0 - 1] };
          break;
        case 57:
          this.$ = { type1: $$[$0 - 1], type2: "none", lineType: $$[$0] };
          break;
        case 58:
          this.$ = { type1: "none", type2: "none", lineType: $$[$0] };
          break;
        case 59:
          this.$ = yy.relationType.AGGREGATION;
          break;
        case 60:
          this.$ = yy.relationType.EXTENSION;
          break;
        case 61:
          this.$ = yy.relationType.COMPOSITION;
          break;
        case 62:
          this.$ = yy.relationType.DEPENDENCY;
          break;
        case 63:
          this.$ = yy.relationType.LOLLIPOP;
          break;
        case 64:
          this.$ = yy.lineType.LINE;
          break;
        case 65:
          this.$ = yy.lineType.DOTTED_LINE;
          break;
        case 66:
        case 72:
          this.$ = $$[$0 - 2];
          yy.setClickEvent($$[$0 - 1], $$[$0]);
          break;
        case 67:
        case 73:
          this.$ = $$[$0 - 3];
          yy.setClickEvent($$[$0 - 2], $$[$0 - 1]);
          yy.setTooltip($$[$0 - 2], $$[$0]);
          break;
        case 68:
        case 76:
          this.$ = $$[$0 - 2];
          yy.setLink($$[$0 - 1], $$[$0]);
          break;
        case 69:
          this.$ = $$[$0 - 3];
          yy.setLink($$[$0 - 2], $$[$0 - 1], $$[$0]);
          break;
        case 70:
        case 78:
          this.$ = $$[$0 - 3];
          yy.setLink($$[$0 - 2], $$[$0 - 1]);
          yy.setTooltip($$[$0 - 2], $$[$0]);
          break;
        case 71:
        case 79:
          this.$ = $$[$0 - 4];
          yy.setLink($$[$0 - 3], $$[$0 - 2], $$[$0]);
          yy.setTooltip($$[$0 - 3], $$[$0 - 1]);
          break;
        case 74:
          this.$ = $$[$0 - 3];
          yy.setClickEvent($$[$0 - 2], $$[$0 - 1], $$[$0]);
          break;
        case 75:
          this.$ = $$[$0 - 4];
          yy.setClickEvent($$[$0 - 3], $$[$0 - 2], $$[$0 - 1]);
          yy.setTooltip($$[$0 - 3], $$[$0]);
          break;
        case 77:
          this.$ = $$[$0 - 3];
          yy.setLink($$[$0 - 2], $$[$0 - 1], $$[$0]);
          break;
        case 80:
          yy.setCssClass($$[$0 - 1], $$[$0]);
          break;
      }
    },
    table: [{ 3: 1, 4: 2, 5: $V0, 6: 4, 7: 5, 8: $V1, 9: $V2, 10: $V3, 11: $V4, 12: 6, 13: 11, 19: $V5, 23: $V6 }, { 1: [3] }, { 1: [2, 1] }, { 1: [2, 2] }, { 1: [2, 3] }, { 3: 14, 4: 2, 5: $V0, 6: 4, 7: 5, 8: $V1, 9: $V2, 10: $V3, 11: $V4, 12: 6, 13: 11, 19: $V5, 23: $V6 }, { 1: [2, 9] }, o($V7, [2, 5]), o($V7, [2, 6]), o($V7, [2, 7]), o($V7, [2, 8]), { 14: 15, 20: [1, 16] }, { 16: [1, 17] }, { 20: [2, 12] }, { 1: [2, 4] }, { 15: 18, 17: [1, 19], 22: $V8 }, o([17, 22], [2, 13]), { 6: 31, 7: 30, 8: $V1, 9: $V2, 10: $V3, 11: $V4, 13: 11, 19: $V5, 24: 21, 26: 22, 27: 35, 28: 46, 29: 47, 31: 23, 33: 24, 34: 25, 35: 26, 36: 27, 37: 28, 38: 29, 39: $V9, 41: $Va, 43: $Vb, 44: $Vc, 49: $Vd, 51: $Ve, 52: $Vf, 55: $Vg, 57: $Vh, 67: $Vi, 68: $Vj, 70: $Vk, 74: $Vl, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 16: [1, 52] }, { 18: 53, 21: [1, 54] }, { 16: [2, 15] }, { 25: [1, 55] }, { 16: [1, 56], 25: [2, 17] }, o($Vq, [2, 25], { 32: [1, 57] }), o($Vq, [2, 27]), o($Vq, [2, 28]), o($Vq, [2, 29]), o($Vq, [2, 30]), o($Vq, [2, 31]), o($Vq, [2, 32]), o($Vq, [2, 33]), o($Vq, [2, 34]), { 40: [1, 58] }, { 42: [1, 59] }, o($Vq, [2, 37]), o($Vq, [2, 45], { 53: 60, 58: 63, 59: 64, 32: [1, 62], 54: [1, 61], 60: $Vr, 61: $Vs, 62: $Vt, 63: $Vu, 64: $Vv, 65: $Vw, 66: $Vx }), { 27: 72, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, o($Vq, [2, 47]), o($Vq, [2, 48]), { 28: 73, 88: $Vm, 89: $Vn, 90: $Vo }, { 27: 74, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 27: 75, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 27: 76, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 54: [1, 77] }, { 27: 78, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 54: $Vy, 56: 79 }, o($Vz, [2, 20], { 28: 46, 29: 47, 27: 81, 30: [1, 82], 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }), o($Vz, [2, 21], { 30: [1, 83] }), o($VA, [2, 94]), o($VA, [2, 95]), o($VA, [2, 96]), o([16, 25, 30, 32, 45, 46, 54, 60, 61, 62, 63, 64, 65, 66, 71, 73], [2, 97]), o($VB, [2, 10]), { 15: 84, 22: $V8 }, { 22: [2, 14] }, { 1: [2, 16] }, { 6: 31, 7: 30, 8: $V1, 9: $V2, 10: $V3, 11: $V4, 13: 11, 19: $V5, 24: 85, 25: [2, 18], 26: 22, 27: 35, 28: 46, 29: 47, 31: 23, 33: 24, 34: 25, 35: 26, 36: 27, 37: 28, 38: 29, 39: $V9, 41: $Va, 43: $Vb, 44: $Vc, 49: $Vd, 51: $Ve, 52: $Vf, 55: $Vg, 57: $Vh, 67: $Vi, 68: $Vj, 70: $Vk, 74: $Vl, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, o($Vq, [2, 26]), o($Vq, [2, 35]), o($Vq, [2, 36]), { 27: 86, 28: 46, 29: 47, 54: [1, 87], 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 53: 88, 58: 63, 59: 64, 60: $Vr, 61: $Vs, 62: $Vt, 63: $Vu, 64: $Vv, 65: $Vw, 66: $Vx }, o($Vq, [2, 46]), { 59: 89, 65: $Vw, 66: $Vx }, o($VC, [2, 58], { 58: 90, 60: $Vr, 61: $Vs, 62: $Vt, 63: $Vu, 64: $Vv }), o($VD, [2, 59]), o($VD, [2, 60]), o($VD, [2, 61]), o($VD, [2, 62]), o($VD, [2, 63]), o($VE, [2, 64]), o($VE, [2, 65]), o($Vq, [2, 38], { 45: [1, 91], 46: [1, 92] }), { 50: [1, 93] }, { 54: [1, 94] }, { 54: [1, 95] }, { 71: [1, 96], 73: [1, 97] }, { 28: 98, 88: $Vm, 89: $Vn, 90: $Vo }, { 54: $Vy, 56: 99 }, o($Vq, [2, 54]), o($Vq, [2, 98]), o($Vz, [2, 22]), o($Vz, [2, 23]), o($Vz, [2, 24]), { 16: [1, 100] }, { 25: [2, 19] }, o($VF, [2, 49]), { 27: 101, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, { 27: 102, 28: 46, 29: 47, 54: [1, 103], 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, o($VC, [2, 57], { 58: 104, 60: $Vr, 61: $Vs, 62: $Vt, 63: $Vu, 64: $Vv }), o($VC, [2, 56]), { 28: 105, 88: $Vm, 89: $Vn, 90: $Vo }, { 47: 106, 51: $VG }, { 27: 108, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, o($Vq, [2, 66], { 54: [1, 109] }), o($Vq, [2, 68], { 54: [1, 111], 69: [1, 110] }), o($Vq, [2, 72], { 54: [1, 112], 72: [1, 113] }), o($Vq, [2, 76], { 54: [1, 115], 69: [1, 114] }), o($Vq, [2, 80]), o($Vq, [2, 53]), o($VB, [2, 11]), o($VF, [2, 51]), o($VF, [2, 50]), { 27: 116, 28: 46, 29: 47, 88: $Vm, 89: $Vn, 90: $Vo, 91: $Vp }, o($VC, [2, 55]), o($Vq, [2, 39], { 46: [1, 117] }), { 48: [1, 118] }, { 47: 119, 48: [2, 43], 51: $VG }, o($Vq, [2, 42]), o($Vq, [2, 67]), o($Vq, [2, 69]), o($Vq, [2, 70], { 69: [1, 120] }), o($Vq, [2, 73]), o($Vq, [2, 74], { 54: [1, 121] }), o($Vq, [2, 77]), o($Vq, [2, 78], { 69: [1, 122] }), o($VF, [2, 52]), { 47: 123, 51: $VG }, o($Vq, [2, 40]), { 48: [2, 44] }, o($Vq, [2, 71]), o($Vq, [2, 75]), o($Vq, [2, 79]), { 48: [1, 124] }, o($Vq, [2, 41])],
    defaultActions: { 2: [2, 1], 3: [2, 2], 4: [2, 3], 6: [2, 9], 13: [2, 12], 14: [2, 4], 20: [2, 15], 54: [2, 14], 55: [2, 16], 85: [2, 19], 119: [2, 44] },
    parseError: function parseError(str2, hash) {
      if (hash.recoverable) {
        this.trace(str2);
      } else {
        var error = new Error(str2);
        error.hash = hash;
        throw error;
      }
    },
    parse: function parse2(input) {
      var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
      var args = lstack.slice.call(arguments, 1);
      var lexer2 = Object.create(this.lexer);
      var sharedState = { yy: {} };
      for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
          sharedState.yy[k] = this.yy[k];
        }
      }
      lexer2.setInput(input, sharedState.yy);
      sharedState.yy.lexer = lexer2;
      sharedState.yy.parser = this;
      if (typeof lexer2.yylloc == "undefined") {
        lexer2.yylloc = {};
      }
      var yyloc = lexer2.yylloc;
      lstack.push(yyloc);
      var ranges = lexer2.options && lexer2.options.ranges;
      if (typeof sharedState.yy.parseError === "function") {
        this.parseError = sharedState.yy.parseError;
      } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
      }
      function lex2() {
        var token;
        token = tstack.pop() || lexer2.lex() || EOF;
        if (typeof token !== "number") {
          if (token instanceof Array) {
            tstack = token;
            token = tstack.pop();
          }
          token = self.symbols_[token] || token;
        }
        return token;
      }
      var symbol, state, action, r, yyval = {}, p, len, newState, expected;
      while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
          action = this.defaultActions[state];
        } else {
          if (symbol === null || typeof symbol == "undefined") {
            symbol = lex2();
          }
          action = table[state] && table[state][symbol];
        }
        if (typeof action === "undefined" || !action.length || !action[0]) {
          var errStr = "";
          expected = [];
          for (p in table[state]) {
            if (this.terminals_[p] && p > TERROR) {
              expected.push("'" + this.terminals_[p] + "'");
            }
          }
          if (lexer2.showPosition) {
            errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
          } else {
            errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
          }
          this.parseError(errStr, {
            text: lexer2.match,
            token: this.terminals_[symbol] || symbol,
            line: lexer2.yylineno,
            loc: yyloc,
            expected
          });
        }
        if (action[0] instanceof Array && action.length > 1) {
          throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
        }
        switch (action[0]) {
          case 1:
            stack.push(symbol);
            vstack.push(lexer2.yytext);
            lstack.push(lexer2.yylloc);
            stack.push(action[1]);
            symbol = null;
            {
              yyleng = lexer2.yyleng;
              yytext = lexer2.yytext;
              yylineno = lexer2.yylineno;
              yyloc = lexer2.yylloc;
            }
            break;
          case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
              first_line: lstack[lstack.length - (len || 1)].first_line,
              last_line: lstack[lstack.length - 1].last_line,
              first_column: lstack[lstack.length - (len || 1)].first_column,
              last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
              yyval._$.range = [
                lstack[lstack.length - (len || 1)].range[0],
                lstack[lstack.length - 1].range[1]
              ];
            }
            r = this.performAction.apply(yyval, [
              yytext,
              yyleng,
              yylineno,
              sharedState.yy,
              action[1],
              vstack,
              lstack
            ].concat(args));
            if (typeof r !== "undefined") {
              return r;
            }
            if (len) {
              stack = stack.slice(0, -1 * len * 2);
              vstack = vstack.slice(0, -1 * len);
              lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
          case 3:
            return true;
        }
      }
      return true;
    }
  };
  var lexer = function() {
    var lexer2 = {
      EOF: 1,
      parseError: function parseError(str2, hash) {
        if (this.yy.parser) {
          this.yy.parser.parseError(str2, hash);
        } else {
          throw new Error(str2);
        }
      },
      // resets the lexer, sets new input
      setInput: function(input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = "";
        this.conditionStack = ["INITIAL"];
        this.yylloc = {
          first_line: 1,
          first_column: 0,
          last_line: 1,
          last_column: 0
        };
        if (this.options.ranges) {
          this.yylloc.range = [0, 0];
        }
        this.offset = 0;
        return this;
      },
      // consumes and returns one char from the input
      input: function() {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno++;
          this.yylloc.last_line++;
        } else {
          this.yylloc.last_column++;
        }
        if (this.options.ranges) {
          this.yylloc.range[1]++;
        }
        this._input = this._input.slice(1);
        return ch;
      },
      // unshifts one char (or a string) into the input
      unput: function(ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);
        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);
        if (lines.length - 1) {
          this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;
        this.yylloc = {
          first_line: this.yylloc.first_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.first_column,
          last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
        };
        if (this.options.ranges) {
          this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
      },
      // When called from action, caches matched text and appends it on next action
      more: function() {
        this._more = true;
        return this;
      },
      // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
      reject: function() {
        if (this.options.backtrack_lexer) {
          this._backtrack = true;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
        return this;
      },
      // retain first n characters of the match
      less: function(n) {
        this.unput(this.match.slice(n));
      },
      // displays already matched input, i.e. for error messages
      pastInput: function() {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
      },
      // displays upcoming input, i.e. for error messages
      upcomingInput: function() {
        var next = this.match;
        if (next.length < 20) {
          next += this._input.substr(0, 20 - next.length);
        }
        return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
      },
      // displays the character position where the lexing error occurred, i.e. for error messages
      showPosition: function() {
        var pre = this.pastInput();
        var c2 = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c2 + "^";
      },
      // test the lexed token: return FALSE when not a match, otherwise return token
      test_match: function(match, indexed_rule) {
        var token, lines, backup;
        if (this.options.backtrack_lexer) {
          backup = {
            yylineno: this.yylineno,
            yylloc: {
              first_line: this.yylloc.first_line,
              last_line: this.last_line,
              first_column: this.yylloc.first_column,
              last_column: this.yylloc.last_column
            },
            yytext: this.yytext,
            match: this.match,
            matches: this.matches,
            matched: this.matched,
            yyleng: this.yyleng,
            offset: this.offset,
            _more: this._more,
            _input: this._input,
            yy: this.yy,
            conditionStack: this.conditionStack.slice(0),
            done: this.done
          };
          if (this.options.ranges) {
            backup.yylloc.range = this.yylloc.range.slice(0);
          }
        }
        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno += lines.length;
        }
        this.yylloc = {
          first_line: this.yylloc.last_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.last_column,
          last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
          this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
          this.done = false;
        }
        if (token) {
          return token;
        } else if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
        return false;
      },
      // return next match in input
      next: function() {
        if (this.done) {
          return this.EOF;
        }
        if (!this._input) {
          this.done = true;
        }
        var token, match, tempMatch, index;
        if (!this._more) {
          this.yytext = "";
          this.match = "";
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
          tempMatch = this._input.match(this.rules[rules[i]]);
          if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
            match = tempMatch;
            index = i;
            if (this.options.backtrack_lexer) {
              token = this.test_match(tempMatch, rules[i]);
              if (token !== false) {
                return token;
              } else if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            } else if (!this.options.flex) {
              break;
            }
          }
        }
        if (match) {
          token = this.test_match(match, rules[index]);
          if (token !== false) {
            return token;
          }
          return false;
        }
        if (this._input === "") {
          return this.EOF;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
      },
      // return next match that has a token
      lex: function lex2() {
        var r = this.next();
        if (r) {
          return r;
        } else {
          return this.lex();
        }
      },
      // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
      begin: function begin(condition) {
        this.conditionStack.push(condition);
      },
      // pop the previously active lexer condition state off the condition stack
      popState: function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
          return this.conditionStack.pop();
        } else {
          return this.conditionStack[0];
        }
      },
      // produce the lexer rule set which is active for the currently active lexer condition state
      _currentRules: function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
          return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
          return this.conditions["INITIAL"].rules;
        }
      },
      // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
      topState: function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
          return this.conditionStack[n];
        } else {
          return "INITIAL";
        }
      },
      // alias for begin(condition)
      pushState: function pushState(condition) {
        this.begin(condition);
      },
      // return the number of states currently on the stack
      stateStackSize: function stateStackSize() {
        return this.conditionStack.length;
      },
      options: {},
      performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
        switch ($avoiding_name_collisions) {
          case 0:
            this.begin("open_directive");
            return 19;
          case 1:
            return 8;
          case 2:
            return 9;
          case 3:
            return 10;
          case 4:
            return 11;
          case 5:
            this.begin("type_directive");
            return 20;
          case 6:
            this.popState();
            this.begin("arg_directive");
            return 17;
          case 7:
            this.popState();
            this.popState();
            return 22;
          case 8:
            return 21;
          case 9:
            break;
          case 10:
            break;
          case 11:
            this.begin("acc_title");
            return 39;
          case 12:
            this.popState();
            return "acc_title_value";
          case 13:
            this.begin("acc_descr");
            return 41;
          case 14:
            this.popState();
            return "acc_descr_value";
          case 15:
            this.begin("acc_descr_multiline");
            break;
          case 16:
            this.popState();
            break;
          case 17:
            return "acc_descr_multiline_value";
          case 18:
            return 16;
          case 19:
            break;
          case 20:
            return 23;
          case 21:
            return 23;
          case 22:
            this.begin("struct");
            return 46;
          case 23:
            return "EDGE_STATE";
          case 24:
            return "EOF_IN_STRUCT";
          case 25:
            return "OPEN_IN_STRUCT";
          case 26:
            this.popState();
            return 48;
          case 27:
            break;
          case 28:
            return "MEMBER";
          case 29:
            return 44;
          case 30:
            return 74;
          case 31:
            return 67;
          case 32:
            return 68;
          case 33:
            return 70;
          case 34:
            return 55;
          case 35:
            return 57;
          case 36:
            return 49;
          case 37:
            return 50;
          case 38:
            this.begin("generic");
            break;
          case 39:
            this.popState();
            break;
          case 40:
            return "GENERICTYPE";
          case 41:
            this.begin("string");
            break;
          case 42:
            this.popState();
            break;
          case 43:
            return "STR";
          case 44:
            this.begin("bqstring");
            break;
          case 45:
            this.popState();
            break;
          case 46:
            return "BQUOTE_STR";
          case 47:
            this.begin("href");
            break;
          case 48:
            this.popState();
            break;
          case 49:
            return 73;
          case 50:
            this.begin("callback_name");
            break;
          case 51:
            this.popState();
            break;
          case 52:
            this.popState();
            this.begin("callback_args");
            break;
          case 53:
            return 71;
          case 54:
            this.popState();
            break;
          case 55:
            return 72;
          case 56:
            return 69;
          case 57:
            return 69;
          case 58:
            return 69;
          case 59:
            return 69;
          case 60:
            return 61;
          case 61:
            return 61;
          case 62:
            return 63;
          case 63:
            return 63;
          case 64:
            return 62;
          case 65:
            return 60;
          case 66:
            return 64;
          case 67:
            return 65;
          case 68:
            return 66;
          case 69:
            return 32;
          case 70:
            return 45;
          case 71:
            return 86;
          case 72:
            return "DOT";
          case 73:
            return "PLUS";
          case 74:
            return 83;
          case 75:
            return "EQUALS";
          case 76:
            return "EQUALS";
          case 77:
            return 90;
          case 78:
            return "PUNCTUATION";
          case 79:
            return 89;
          case 80:
            return 88;
          case 81:
            return 85;
          case 82:
            return 25;
        }
      },
      rules: [/^(?:%%\{)/, /^(?:.*direction\s+TB[^\n]*)/, /^(?:.*direction\s+BT[^\n]*)/, /^(?:.*direction\s+RL[^\n]*)/, /^(?:.*direction\s+LR[^\n]*)/, /^(?:((?:(?!\}%%)[^:.])*))/, /^(?::)/, /^(?:\}%%)/, /^(?:((?:(?!\}%%).|\n)*))/, /^(?:%%(?!\{)*[^\n]*(\r?\n?)+)/, /^(?:%%[^\n]*(\r?\n)*)/, /^(?:accTitle\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*\{\s*)/, /^(?:[\}])/, /^(?:[^\}]*)/, /^(?:\s*(\r?\n)+)/, /^(?:\s+)/, /^(?:classDiagram-v2\b)/, /^(?:classDiagram\b)/, /^(?:[{])/, /^(?:\[\*\])/, /^(?:$)/, /^(?:[{])/, /^(?:[}])/, /^(?:[\n])/, /^(?:[^{}\n]*)/, /^(?:class\b)/, /^(?:cssClass\b)/, /^(?:callback\b)/, /^(?:link\b)/, /^(?:click\b)/, /^(?:note for\b)/, /^(?:note\b)/, /^(?:<<)/, /^(?:>>)/, /^(?:[~])/, /^(?:[~])/, /^(?:[^~]*)/, /^(?:["])/, /^(?:["])/, /^(?:[^"]*)/, /^(?:[`])/, /^(?:[`])/, /^(?:[^`]+)/, /^(?:href[\s]+["])/, /^(?:["])/, /^(?:[^"]*)/, /^(?:call[\s]+)/, /^(?:\([\s]*\))/, /^(?:\()/, /^(?:[^(]*)/, /^(?:\))/, /^(?:[^)]*)/, /^(?:_self\b)/, /^(?:_blank\b)/, /^(?:_parent\b)/, /^(?:_top\b)/, /^(?:\s*<\|)/, /^(?:\s*\|>)/, /^(?:\s*>)/, /^(?:\s*<)/, /^(?:\s*\*)/, /^(?:\s*o\b)/, /^(?:\s*\(\))/, /^(?:--)/, /^(?:\.\.)/, /^(?::{1}[^:\n;]+)/, /^(?::{3})/, /^(?:-)/, /^(?:\.)/, /^(?:\+)/, /^(?:%)/, /^(?:=)/, /^(?:=)/, /^(?:\w+)/, /^(?:[!"#$%&'*+,-.`?\\/])/, /^(?:[0-9]+)/, /^(?:[\u00AA\u00B5\u00BA\u00C0-\u00D6\u00D8-\u00F6]|[\u00F8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377]|[\u037A-\u037D\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5]|[\u03F7-\u0481\u048A-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA]|[\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE]|[\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA]|[\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0]|[\u08A2-\u08AC\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0977]|[\u0979-\u097F\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2]|[\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A]|[\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39]|[\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8]|[\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C]|[\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C]|[\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99]|[\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0]|[\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C33\u0C35-\u0C39\u0C3D]|[\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3]|[\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10]|[\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1]|[\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81]|[\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3]|[\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6]|[\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A]|[\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081]|[\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D]|[\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0]|[\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310]|[\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C]|[\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u1700-\u170C\u170E-\u1711]|[\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7]|[\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191C]|[\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16]|[\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF]|[\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC]|[\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D]|[\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D]|[\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3]|[\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F]|[\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128]|[\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184]|[\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3]|[\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6]|[\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE]|[\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C]|[\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D]|[\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC]|[\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B]|[\uA640-\uA66E\uA67F-\uA697\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788]|[\uA78B-\uA78E\uA790-\uA793\uA7A0-\uA7AA\uA7F8-\uA801\uA803-\uA805]|[\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB]|[\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uAA00-\uAA28]|[\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA80-\uAAAF\uAAB1\uAAB5]|[\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4]|[\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E]|[\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D]|[\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36]|[\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D]|[\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC]|[\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF]|[\uFFD2-\uFFD7\uFFDA-\uFFDC])/, /^(?:\s)/, /^(?:$)/],
      conditions: { "acc_descr_multiline": { "rules": [16, 17], "inclusive": false }, "acc_descr": { "rules": [14], "inclusive": false }, "acc_title": { "rules": [12], "inclusive": false }, "arg_directive": { "rules": [7, 8], "inclusive": false }, "type_directive": { "rules": [6, 7], "inclusive": false }, "open_directive": { "rules": [5], "inclusive": false }, "callback_args": { "rules": [54, 55], "inclusive": false }, "callback_name": { "rules": [51, 52, 53], "inclusive": false }, "href": { "rules": [48, 49], "inclusive": false }, "struct": { "rules": [23, 24, 25, 26, 27, 28], "inclusive": false }, "generic": { "rules": [39, 40], "inclusive": false }, "bqstring": { "rules": [45, 46], "inclusive": false }, "string": { "rules": [42, 43], "inclusive": false }, "INITIAL": { "rules": [0, 1, 2, 3, 4, 9, 10, 11, 13, 15, 18, 19, 20, 21, 22, 23, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 41, 44, 47, 50, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82], "inclusive": true } }
    };
    return lexer2;
  }();
  parser2.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  Parser.prototype = parser2;
  parser2.Parser = Parser;
  return new Parser();
}();
parser$a.parser = parser$a;
const classParser = parser$a;
const classDetector = (txt, config2) => {
  var _a;
  if (((_a = config2 == null ? void 0 : config2.class) == null ? void 0 : _a.defaultRenderer) === "dagre-wrapper") {
    return false;
  }
  return txt.match(/^\s*classDiagram/) !== null;
};
const classDetectorV2 = (txt, config2) => {
  var _a;
  if (txt.match(/^\s*classDiagram/) !== null && ((_a = config2 == null ? void 0 : config2.class) == null ? void 0 : _a.defaultRenderer) === "dagre-wrapper") {
    return true;
  }
  return txt.match(/^\s*classDiagram-v2/) !== null;
};
const MERMAID_DOM_ID_PREFIX$1 = "classid-";
let relations$1 = [];
let classes$2 = {};
let notes = [];
let classCounter = 0;
let funs$2 = [];
const sanitizeText$2 = (txt) => common$1.sanitizeText(txt, getConfig$1());
const parseDirective$8 = function(statement, context, type2) {
  mermaidAPI.parseDirective(this, statement, context, type2);
};
const splitClassNameAndType = function(id2) {
  let genericType = "";
  let className = id2;
  if (id2.indexOf("~") > 0) {
    let split = id2.split("~");
    className = split[0];
    genericType = common$1.sanitizeText(split[1], getConfig$1());
  }
  return { className, type: genericType };
};
const addClass$1 = function(id2) {
  let classId = splitClassNameAndType(id2);
  if (classes$2[classId.className] !== void 0) {
    return;
  }
  classes$2[classId.className] = {
    id: classId.className,
    type: classId.type,
    cssClasses: [],
    methods: [],
    members: [],
    annotations: [],
    domId: MERMAID_DOM_ID_PREFIX$1 + classId.className + "-" + classCounter
  };
  classCounter++;
};
const lookUpDomId$1 = function(id2) {
  const classKeys = Object.keys(classes$2);
  for (const classKey of classKeys) {
    if (classes$2[classKey].id === id2) {
      return classes$2[classKey].domId;
    }
  }
};
const clear$c = function() {
  relations$1 = [];
  classes$2 = {};
  notes = [];
  funs$2 = [];
  funs$2.push(setupToolTips$1);
  clear$g();
};
const getClass = function(id2) {
  return classes$2[id2];
};
const getClasses$5 = function() {
  return classes$2;
};
const getRelations$1 = function() {
  return relations$1;
};
const getNotes = function() {
  return notes;
};
const addRelation$1 = function(relation) {
  log$1.debug("Adding relation: " + JSON.stringify(relation));
  addClass$1(relation.id1);
  addClass$1(relation.id2);
  relation.id1 = splitClassNameAndType(relation.id1).className;
  relation.id2 = splitClassNameAndType(relation.id2).className;
  relation.relationTitle1 = common$1.sanitizeText(
    relation.relationTitle1.trim(),
    getConfig$1()
  );
  relation.relationTitle2 = common$1.sanitizeText(
    relation.relationTitle2.trim(),
    getConfig$1()
  );
  relations$1.push(relation);
};
const addAnnotation = function(className, annotation) {
  const validatedClassName = splitClassNameAndType(className).className;
  classes$2[validatedClassName].annotations.push(annotation);
};
const addMember = function(className, member) {
  const validatedClassName = splitClassNameAndType(className).className;
  const theClass = classes$2[validatedClassName];
  if (typeof member === "string") {
    const memberString = member.trim();
    if (memberString.startsWith("<<") && memberString.endsWith(">>")) {
      theClass.annotations.push(sanitizeText$2(memberString.substring(2, memberString.length - 2)));
    } else if (memberString.indexOf(")") > 0) {
      theClass.methods.push(sanitizeText$2(memberString));
    } else if (memberString) {
      theClass.members.push(sanitizeText$2(memberString));
    }
  }
};
const addMembers = function(className, members) {
  if (Array.isArray(members)) {
    members.reverse();
    members.forEach((member) => addMember(className, member));
  }
};
const addNote$1 = function(text, className) {
  const note2 = {
    id: `note${notes.length}`,
    class: className,
    text
  };
  notes.push(note2);
};
const cleanupLabel$1 = function(label) {
  if (label.substring(0, 1) === ":") {
    return common$1.sanitizeText(label.substr(1).trim(), getConfig$1());
  } else {
    return sanitizeText$2(label.trim());
  }
};
const setCssClass$1 = function(ids, className) {
  ids.split(",").forEach(function(_id) {
    let id2 = _id;
    if (_id[0].match(/\d/)) {
      id2 = MERMAID_DOM_ID_PREFIX$1 + id2;
    }
    if (classes$2[id2] !== void 0) {
      classes$2[id2].cssClasses.push(className);
    }
  });
};
const setTooltip$1 = function(ids, tooltip) {
  const config2 = getConfig$1();
  ids.split(",").forEach(function(id2) {
    if (tooltip !== void 0) {
      classes$2[id2].tooltip = common$1.sanitizeText(tooltip, config2);
    }
  });
};
const getTooltip$1 = function(id2) {
  return classes$2[id2].tooltip;
};
const setLink$2 = function(ids, linkStr, target) {
  const config2 = getConfig$1();
  ids.split(",").forEach(function(_id) {
    let id2 = _id;
    if (_id[0].match(/\d/)) {
      id2 = MERMAID_DOM_ID_PREFIX$1 + id2;
    }
    if (classes$2[id2] !== void 0) {
      classes$2[id2].link = utils.formatUrl(linkStr, config2);
      if (config2.securityLevel === "sandbox") {
        classes$2[id2].linkTarget = "_top";
      } else if (typeof target === "string") {
        classes$2[id2].linkTarget = sanitizeText$2(target);
      } else {
        classes$2[id2].linkTarget = "_blank";
      }
    }
  });
  setCssClass$1(ids, "clickable");
};
const setClickEvent$2 = function(ids, functionName, functionArgs) {
  ids.split(",").forEach(function(id2) {
    setClickFunc(id2, functionName, functionArgs);
    classes$2[id2].haveCallback = true;
  });
  setCssClass$1(ids, "clickable");
};
const setClickFunc = function(domId, functionName, functionArgs) {
  const config2 = getConfig$1();
  let id2 = domId;
  let elemId = lookUpDomId$1(id2);
  if (config2.securityLevel !== "loose") {
    return;
  }
  if (functionName === void 0) {
    return;
  }
  if (classes$2[id2] !== void 0) {
    let argList = [];
    if (typeof functionArgs === "string") {
      argList = functionArgs.split(/,(?=(?:(?:[^"]*"){2})*[^"]*$)/);
      for (let i = 0; i < argList.length; i++) {
        let item = argList[i].trim();
        if (item.charAt(0) === '"' && item.charAt(item.length - 1) === '"') {
          item = item.substr(1, item.length - 2);
        }
        argList[i] = item;
      }
    }
    if (argList.length === 0) {
      argList.push(elemId);
    }
    funs$2.push(function() {
      const elem = document.querySelector(`[id="${elemId}"]`);
      if (elem !== null) {
        elem.addEventListener(
          "click",
          function() {
            utils.runFunc(functionName, ...argList);
          },
          false
        );
      }
    });
  }
};
const bindFunctions$2 = function(element) {
  funs$2.forEach(function(fun) {
    fun(element);
  });
};
const lineType$1 = {
  LINE: 0,
  DOTTED_LINE: 1
};
const relationType$1 = {
  AGGREGATION: 0,
  EXTENSION: 1,
  COMPOSITION: 2,
  DEPENDENCY: 3,
  LOLLIPOP: 4
};
const setupToolTips$1 = function(element) {
  let tooltipElem = select(".mermaidTooltip");
  if ((tooltipElem._groups || tooltipElem)[0][0] === null) {
    tooltipElem = select("body").append("div").attr("class", "mermaidTooltip").style("opacity", 0);
  }
  const svg = select(element).select("svg");
  const nodes = svg.selectAll("g.node");
  nodes.on("mouseover", function() {
    const el = select(this);
    const title2 = el.attr("title");
    if (title2 === null) {
      return;
    }
    const rect2 = this.getBoundingClientRect();
    tooltipElem.transition().duration(200).style("opacity", ".9");
    tooltipElem.text(el.attr("title")).style("left", window.scrollX + rect2.left + (rect2.right - rect2.left) / 2 + "px").style("top", window.scrollY + rect2.top - 14 + document.body.scrollTop + "px");
    tooltipElem.html(tooltipElem.html().replace(/&lt;br\/&gt;/g, "<br/>"));
    el.classed("hover", true);
  }).on("mouseout", function() {
    tooltipElem.transition().duration(500).style("opacity", 0);
    const el = select(this);
    el.classed("hover", false);
  });
};
funs$2.push(setupToolTips$1);
let direction$2 = "TB";
const getDirection$2 = () => direction$2;
const setDirection$2 = (dir) => {
  direction$2 = dir;
};
const classDb = {
  parseDirective: parseDirective$8,
  setAccTitle,
  getAccTitle,
  getAccDescription,
  setAccDescription,
  getConfig: () => getConfig$1().class,
  addClass: addClass$1,
  bindFunctions: bindFunctions$2,
  clear: clear$c,
  getClass,
  getClasses: getClasses$5,
  getNotes,
  addAnnotation,
  addNote: addNote$1,
  getRelations: getRelations$1,
  addRelation: addRelation$1,
  getDirection: getDirection$2,
  setDirection: setDirection$2,
  addMember,
  addMembers,
  cleanupLabel: cleanupLabel$1,
  lineType: lineType$1,
  relationType: relationType$1,
  setClickEvent: setClickEvent$2,
  setCssClass: setCssClass$1,
  setLink: setLink$2,
  getTooltip: getTooltip$1,
  setTooltip: setTooltip$1,
  lookUpDomId: lookUpDomId$1,
  setDiagramTitle,
  getDiagramTitle
};
let edgeCount$1 = 0;
const drawEdge$1 = function(elem, path, relation, conf2, diagObj) {
  const getRelationType = function(type2) {
    switch (type2) {
      case diagObj.db.relationType.AGGREGATION:
        return "aggregation";
      case diagObj.db.relationType.EXTENSION:
        return "extension";
      case diagObj.db.relationType.COMPOSITION:
        return "composition";
      case diagObj.db.relationType.DEPENDENCY:
        return "dependency";
      case diagObj.db.relationType.LOLLIPOP:
        return "lollipop";
    }
  };
  path.points = path.points.filter((p) => !Number.isNaN(p.y));
  const lineData = path.points;
  const lineFunction = line().x(function(d) {
    return d.x;
  }).y(function(d) {
    return d.y;
  }).curve(curveBasis);
  const svgPath = elem.append("path").attr("d", lineFunction(lineData)).attr("id", "edge" + edgeCount$1).attr("class", "relation");
  let url = "";
  if (conf2.arrowMarkerAbsolute) {
    url = window.location.protocol + "//" + window.location.host + window.location.pathname + window.location.search;
    url = url.replace(/\(/g, "\\(");
    url = url.replace(/\)/g, "\\)");
  }
  if (relation.relation.lineType == 1) {
    svgPath.attr("class", "relation dashed-line");
  }
  if (relation.relation.lineType == 10) {
    svgPath.attr("class", "relation dotted-line");
  }
  if (relation.relation.type1 !== "none") {
    svgPath.attr(
      "marker-start",
      "url(" + url + "#" + getRelationType(relation.relation.type1) + "Start)"
    );
  }
  if (relation.relation.type2 !== "none") {
    svgPath.attr(
      "marker-end",
      "url(" + url + "#" + getRelationType(relation.relation.type2) + "End)"
    );
  }
  let x, y;
  const l = path.points.length;
  let labelPosition = utils.calcLabelPosition(path.points);
  x = labelPosition.x;
  y = labelPosition.y;
  let p1_card_x, p1_card_y;
  let p2_card_x, p2_card_y;
  if (l % 2 !== 0 && l > 1) {
    let cardinality_1_point = utils.calcCardinalityPosition(
      relation.relation.type1 !== "none",
      path.points,
      path.points[0]
    );
    let cardinality_2_point = utils.calcCardinalityPosition(
      relation.relation.type2 !== "none",
      path.points,
      path.points[l - 1]
    );
    log$1.debug("cardinality_1_point " + JSON.stringify(cardinality_1_point));
    log$1.debug("cardinality_2_point " + JSON.stringify(cardinality_2_point));
    p1_card_x = cardinality_1_point.x;
    p1_card_y = cardinality_1_point.y;
    p2_card_x = cardinality_2_point.x;
    p2_card_y = cardinality_2_point.y;
  }
  if (relation.title !== void 0) {
    const g = elem.append("g").attr("class", "classLabel");
    const label = g.append("text").attr("class", "label").attr("x", x).attr("y", y).attr("fill", "red").attr("text-anchor", "middle").text(relation.title);
    window.label = label;
    const bounds2 = label.node().getBBox();
    g.insert("rect", ":first-child").attr("class", "box").attr("x", bounds2.x - conf2.padding / 2).attr("y", bounds2.y - conf2.padding / 2).attr("width", bounds2.width + conf2.padding).attr("height", bounds2.height + conf2.padding);
  }
  log$1.info("Rendering relation " + JSON.stringify(relation));
  if (relation.relationTitle1 !== void 0 && relation.relationTitle1 !== "none") {
    const g = elem.append("g").attr("class", "cardinality");
    g.append("text").attr("class", "type1").attr("x", p1_card_x).attr("y", p1_card_y).attr("fill", "black").attr("font-size", "6").text(relation.relationTitle1);
  }
  if (relation.relationTitle2 !== void 0 && relation.relationTitle2 !== "none") {
    const g = elem.append("g").attr("class", "cardinality");
    g.append("text").attr("class", "type2").attr("x", p2_card_x).attr("y", p2_card_y).attr("fill", "black").attr("font-size", "6").text(relation.relationTitle2);
  }
  edgeCount$1++;
};
const drawClass = function(elem, classDef, conf2, diagObj) {
  log$1.debug("Rendering class ", classDef, conf2);
  const id2 = classDef.id;
  const classInfo = {
    id: id2,
    label: classDef.id,
    width: 0,
    height: 0
  };
  const g = elem.append("g").attr("id", diagObj.db.lookUpDomId(id2)).attr("class", "classGroup");
  let title2;
  if (classDef.link) {
    title2 = g.append("svg:a").attr("xlink:href", classDef.link).attr("target", classDef.linkTarget).append("text").attr("y", conf2.textHeight + conf2.padding).attr("x", 0);
  } else {
    title2 = g.append("text").attr("y", conf2.textHeight + conf2.padding).attr("x", 0);
  }
  let isFirst = true;
  classDef.annotations.forEach(function(member) {
    const titleText2 = title2.append("tspan").text("«" + member + "»");
    if (!isFirst) {
      titleText2.attr("dy", conf2.textHeight);
    }
    isFirst = false;
  });
  let classTitleString = classDef.id;
  if (classDef.type !== void 0 && classDef.type !== "") {
    classTitleString += "<" + classDef.type + ">";
  }
  const classTitle = title2.append("tspan").text(classTitleString).attr("class", "title");
  if (!isFirst) {
    classTitle.attr("dy", conf2.textHeight);
  }
  const titleHeight = title2.node().getBBox().height;
  const membersLine = g.append("line").attr("x1", 0).attr("y1", conf2.padding + titleHeight + conf2.dividerMargin / 2).attr("y2", conf2.padding + titleHeight + conf2.dividerMargin / 2);
  const members = g.append("text").attr("x", conf2.padding).attr("y", titleHeight + conf2.dividerMargin + conf2.textHeight).attr("fill", "white").attr("class", "classText");
  isFirst = true;
  classDef.members.forEach(function(member) {
    addTspan(members, member, isFirst, conf2);
    isFirst = false;
  });
  const membersBox = members.node().getBBox();
  const methodsLine = g.append("line").attr("x1", 0).attr("y1", conf2.padding + titleHeight + conf2.dividerMargin + membersBox.height).attr("y2", conf2.padding + titleHeight + conf2.dividerMargin + membersBox.height);
  const methods = g.append("text").attr("x", conf2.padding).attr("y", titleHeight + 2 * conf2.dividerMargin + membersBox.height + conf2.textHeight).attr("fill", "white").attr("class", "classText");
  isFirst = true;
  classDef.methods.forEach(function(method) {
    addTspan(methods, method, isFirst, conf2);
    isFirst = false;
  });
  const classBox = g.node().getBBox();
  var cssClassStr = " ";
  if (classDef.cssClasses.length > 0) {
    cssClassStr = cssClassStr + classDef.cssClasses.join(" ");
  }
  const rect2 = g.insert("rect", ":first-child").attr("x", 0).attr("y", 0).attr("width", classBox.width + 2 * conf2.padding).attr("height", classBox.height + conf2.padding + 0.5 * conf2.dividerMargin).attr("class", cssClassStr);
  const rectWidth = rect2.node().getBBox().width;
  title2.node().childNodes.forEach(function(x) {
    x.setAttribute("x", (rectWidth - x.getBBox().width) / 2);
  });
  if (classDef.tooltip) {
    title2.insert("title").text(classDef.tooltip);
  }
  membersLine.attr("x2", rectWidth);
  methodsLine.attr("x2", rectWidth);
  classInfo.width = rectWidth;
  classInfo.height = classBox.height + conf2.padding + 0.5 * conf2.dividerMargin;
  return classInfo;
};
const drawNote$2 = function(elem, note2, conf2, diagObj) {
  log$1.debug("Rendering note ", note2, conf2);
  const id2 = note2.id;
  const noteInfo = {
    id: id2,
    text: note2.text,
    width: 0,
    height: 0
  };
  const g = elem.append("g").attr("id", id2).attr("class", "classGroup");
  let text = g.append("text").attr("y", conf2.textHeight + conf2.padding).attr("x", 0);
  const lines = JSON.parse(`"${note2.text}"`).split("\n");
  lines.forEach(function(line2) {
    log$1.debug(`Adding line: ${line2}`);
    text.append("tspan").text(line2).attr("class", "title").attr("dy", conf2.textHeight);
  });
  const noteBox = g.node().getBBox();
  const rect2 = g.insert("rect", ":first-child").attr("x", 0).attr("y", 0).attr("width", noteBox.width + 2 * conf2.padding).attr(
    "height",
    noteBox.height + lines.length * conf2.textHeight + conf2.padding + 0.5 * conf2.dividerMargin
  );
  const rectWidth = rect2.node().getBBox().width;
  text.node().childNodes.forEach(function(x) {
    x.setAttribute("x", (rectWidth - x.getBBox().width) / 2);
  });
  noteInfo.width = rectWidth;
  noteInfo.height = noteBox.height + lines.length * conf2.textHeight + conf2.padding + 0.5 * conf2.dividerMargin;
  return noteInfo;
};
const parseMember = function(text) {
  const fieldRegEx = /^([#+~-])?(\w+)(~\w+~|\[])?\s+(\w+) *([$*])?$/;
  const methodRegEx = /^([#+|~-])?(\w+) *\( *(.*)\) *([$*])? *(\w*[[\]|~]*\s*\w*~?)$/;
  let fieldMatch = text.match(fieldRegEx);
  let methodMatch = text.match(methodRegEx);
  if (fieldMatch && !methodMatch) {
    return buildFieldDisplay(fieldMatch);
  } else if (methodMatch) {
    return buildMethodDisplay(methodMatch);
  } else {
    return buildLegacyDisplay(text);
  }
};
const buildFieldDisplay = function(parsedText) {
  let cssStyle = "";
  let displayText = "";
  try {
    let visibility = parsedText[1] ? parsedText[1].trim() : "";
    let fieldType = parsedText[2] ? parsedText[2].trim() : "";
    let genericType = parsedText[3] ? parseGenericTypes(parsedText[3].trim()) : "";
    let fieldName = parsedText[4] ? parsedText[4].trim() : "";
    let classifier = parsedText[5] ? parsedText[5].trim() : "";
    displayText = visibility + fieldType + genericType + " " + fieldName;
    cssStyle = parseClassifier(classifier);
  } catch (err) {
    displayText = parsedText;
  }
  return {
    displayText,
    cssStyle
  };
};
const buildMethodDisplay = function(parsedText) {
  let cssStyle = "";
  let displayText = "";
  try {
    let visibility = parsedText[1] ? parsedText[1].trim() : "";
    let methodName = parsedText[2] ? parsedText[2].trim() : "";
    let parameters = parsedText[3] ? parseGenericTypes(parsedText[3].trim()) : "";
    let classifier = parsedText[4] ? parsedText[4].trim() : "";
    let returnType = parsedText[5] ? " : " + parseGenericTypes(parsedText[5]).trim() : "";
    displayText = visibility + methodName + "(" + parameters + ")" + returnType;
    cssStyle = parseClassifier(classifier);
  } catch (err) {
    displayText = parsedText;
  }
  return {
    displayText,
    cssStyle
  };
};
const buildLegacyDisplay = function(text) {
  let displayText = "";
  let cssStyle = "";
  let returnType = "";
  let methodStart = text.indexOf("(");
  let methodEnd = text.indexOf(")");
  if (methodStart > 1 && methodEnd > methodStart && methodEnd <= text.length) {
    let visibility = "";
    let methodName = "";
    let firstChar = text.substring(0, 1);
    if (firstChar.match(/\w/)) {
      methodName = text.substring(0, methodStart).trim();
    } else {
      if (firstChar.match(/[#+~-]/)) {
        visibility = firstChar;
      }
      methodName = text.substring(1, methodStart).trim();
    }
    const parameters = text.substring(methodStart + 1, methodEnd);
    text.substring(methodEnd + 1, 1);
    cssStyle = parseClassifier(text.substring(methodEnd + 1, methodEnd + 2));
    displayText = visibility + methodName + "(" + parseGenericTypes(parameters.trim()) + ")";
    if (methodEnd < text.length) {
      returnType = text.substring(methodEnd + 2).trim();
      if (returnType !== "") {
        returnType = " : " + parseGenericTypes(returnType);
        displayText += returnType;
      }
    }
  } else {
    displayText = parseGenericTypes(text);
  }
  return {
    displayText,
    cssStyle
  };
};
const addTspan = function(textEl, txt, isFirst, conf2) {
  let member = parseMember(txt);
  const tSpan = textEl.append("tspan").attr("x", conf2.padding).text(member.displayText);
  if (member.cssStyle !== "") {
    tSpan.attr("style", member.cssStyle);
  }
  if (!isFirst) {
    tSpan.attr("dy", conf2.textHeight);
  }
};
const parseClassifier = function(classifier) {
  switch (classifier) {
    case "*":
      return "font-style:italic;";
    case "$":
      return "text-decoration:underline;";
    default:
      return "";
  }
};
const svgDraw$2 = {
  drawClass,
  drawEdge: drawEdge$1,
  drawNote: drawNote$2,
  parseMember
};
let idCache$2 = {};
const padding = 20;
const getGraphId = function(label) {
  const foundEntry = Object.entries(idCache$2).find((entry) => entry[1].label === label);
  if (foundEntry) {
    return foundEntry[0];
  }
};
const insertMarkers$4 = function(elem) {
  elem.append("defs").append("marker").attr("id", "extensionStart").attr("class", "extension").attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 1,7 L18,13 V 1 Z");
  elem.append("defs").append("marker").attr("id", "extensionEnd").attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 1,1 V 13 L18,7 Z");
  elem.append("defs").append("marker").attr("id", "compositionStart").attr("class", "extension").attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
  elem.append("defs").append("marker").attr("id", "compositionEnd").attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
  elem.append("defs").append("marker").attr("id", "aggregationStart").attr("class", "extension").attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
  elem.append("defs").append("marker").attr("id", "aggregationEnd").attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
  elem.append("defs").append("marker").attr("id", "dependencyStart").attr("class", "extension").attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 5,7 L9,13 L1,7 L9,1 Z");
  elem.append("defs").append("marker").attr("id", "dependencyEnd").attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L14,7 L9,1 Z");
};
const draw$d = function(text, id2, _version, diagObj) {
  const conf2 = getConfig$1().class;
  idCache$2 = {};
  log$1.info("Rendering diagram " + text);
  const securityLevel = getConfig$1().securityLevel;
  let sandboxElement;
  if (securityLevel === "sandbox") {
    sandboxElement = select("#i" + id2);
  }
  const root = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
  const diagram = root.select(`[id='${id2}']`);
  insertMarkers$4(diagram);
  const g = new graphlib.Graph({
    multigraph: true
  });
  g.setGraph({
    isMultiGraph: true
  });
  g.setDefaultEdgeLabel(function() {
    return {};
  });
  const classes2 = diagObj.db.getClasses();
  const keys2 = Object.keys(classes2);
  for (const key of keys2) {
    const classDef = classes2[key];
    const node = svgDraw$2.drawClass(diagram, classDef, conf2, diagObj);
    idCache$2[node.id] = node;
    g.setNode(node.id, node);
    log$1.info("Org height: " + node.height);
  }
  const relations2 = diagObj.db.getRelations();
  relations2.forEach(function(relation) {
    log$1.info(
      "tjoho" + getGraphId(relation.id1) + getGraphId(relation.id2) + JSON.stringify(relation)
    );
    g.setEdge(
      getGraphId(relation.id1),
      getGraphId(relation.id2),
      {
        relation
      },
      relation.title || "DEFAULT"
    );
  });
  const notes2 = diagObj.db.getNotes();
  notes2.forEach(function(note2) {
    log$1.debug(`Adding note: ${JSON.stringify(note2)}`);
    const node = svgDraw$2.drawNote(diagram, note2, conf2, diagObj);
    idCache$2[node.id] = node;
    g.setNode(node.id, node);
    if (note2.class && note2.class in classes2) {
      g.setEdge(
        note2.id,
        getGraphId(note2.class),
        {
          relation: {
            id1: note2.id,
            id2: note2.class,
            relation: {
              type1: "none",
              type2: "none",
              lineType: 10
            }
          }
        },
        "DEFAULT"
      );
    }
  });
  layout(g);
  g.nodes().forEach(function(v) {
    if (v !== void 0 && g.node(v) !== void 0) {
      log$1.debug("Node " + v + ": " + JSON.stringify(g.node(v)));
      root.select("#" + (diagObj.db.lookUpDomId(v) || v)).attr(
        "transform",
        "translate(" + (g.node(v).x - g.node(v).width / 2) + "," + (g.node(v).y - g.node(v).height / 2) + " )"
      );
    }
  });
  g.edges().forEach(function(e) {
    if (e !== void 0 && g.edge(e) !== void 0) {
      log$1.debug("Edge " + e.v + " -> " + e.w + ": " + JSON.stringify(g.edge(e)));
      svgDraw$2.drawEdge(diagram, g.edge(e), g.edge(e).relation, conf2, diagObj);
    }
  });
  const svgBounds = diagram.node().getBBox();
  const width2 = svgBounds.width + padding * 2;
  const height2 = svgBounds.height + padding * 2;
  configureSvgSize(diagram, height2, width2, conf2.useMaxWidth);
  const vBox = `${svgBounds.x - padding} ${svgBounds.y - padding} ${width2} ${height2}`;
  log$1.debug(`viewBox ${vBox}`);
  diagram.attr("viewBox", vBox);
};
const classRenderer = {
  draw: draw$d
};
const insertMarkers$2 = (elem, markerArray, type2, id2) => {
  markerArray.forEach((markerName) => {
    markers$1[markerName](elem, type2, id2);
  });
};
const extension = (elem, type2, id2) => {
  log$1.trace("Making markers for ", id2);
  elem.append("defs").append("marker").attr("id", type2 + "-extensionStart").attr("class", "marker extension " + type2).attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 1,7 L18,13 V 1 Z");
  elem.append("defs").append("marker").attr("id", type2 + "-extensionEnd").attr("class", "marker extension " + type2).attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 1,1 V 13 L18,7 Z");
};
const composition = (elem, type2) => {
  elem.append("defs").append("marker").attr("id", type2 + "-compositionStart").attr("class", "marker composition " + type2).attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
  elem.append("defs").append("marker").attr("id", type2 + "-compositionEnd").attr("class", "marker composition " + type2).attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
};
const aggregation = (elem, type2) => {
  elem.append("defs").append("marker").attr("id", type2 + "-aggregationStart").attr("class", "marker aggregation " + type2).attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
  elem.append("defs").append("marker").attr("id", type2 + "-aggregationEnd").attr("class", "marker aggregation " + type2).attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
};
const dependency = (elem, type2) => {
  elem.append("defs").append("marker").attr("id", type2 + "-dependencyStart").attr("class", "marker dependency " + type2).attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 5,7 L9,13 L1,7 L9,1 Z");
  elem.append("defs").append("marker").attr("id", type2 + "-dependencyEnd").attr("class", "marker dependency " + type2).attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L14,7 L9,1 Z");
};
const lollipop = (elem, type2) => {
  elem.append("defs").append("marker").attr("id", type2 + "-lollipopStart").attr("class", "marker lollipop " + type2).attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("circle").attr("stroke", "black").attr("fill", "white").attr("cx", 6).attr("cy", 7).attr("r", 6);
};
const point = (elem, type2) => {
  elem.append("marker").attr("id", type2 + "-pointEnd").attr("class", "marker " + type2).attr("viewBox", "0 0 12 20").attr("refX", 10).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 0 0 L 10 5 L 0 10 z").attr("class", "arrowMarkerPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
  elem.append("marker").attr("id", type2 + "-pointStart").attr("class", "marker " + type2).attr("viewBox", "0 0 10 10").attr("refX", 0).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 0 5 L 10 10 L 10 0 z").attr("class", "arrowMarkerPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
};
const circle$1 = (elem, type2) => {
  elem.append("marker").attr("id", type2 + "-circleEnd").attr("class", "marker " + type2).attr("viewBox", "0 0 10 10").attr("refX", 11).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 11).attr("markerHeight", 11).attr("orient", "auto").append("circle").attr("cx", "5").attr("cy", "5").attr("r", "5").attr("class", "arrowMarkerPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
  elem.append("marker").attr("id", type2 + "-circleStart").attr("class", "marker " + type2).attr("viewBox", "0 0 10 10").attr("refX", -1).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 11).attr("markerHeight", 11).attr("orient", "auto").append("circle").attr("cx", "5").attr("cy", "5").attr("r", "5").attr("class", "arrowMarkerPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
};
const cross = (elem, type2) => {
  elem.append("marker").attr("id", type2 + "-crossEnd").attr("class", "marker cross " + type2).attr("viewBox", "0 0 11 11").attr("refX", 12).attr("refY", 5.2).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 11).attr("markerHeight", 11).attr("orient", "auto").append("path").attr("d", "M 1,1 l 9,9 M 10,1 l -9,9").attr("class", "arrowMarkerPath").style("stroke-width", 2).style("stroke-dasharray", "1,0");
  elem.append("marker").attr("id", type2 + "-crossStart").attr("class", "marker cross " + type2).attr("viewBox", "0 0 11 11").attr("refX", -1).attr("refY", 5.2).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 11).attr("markerHeight", 11).attr("orient", "auto").append("path").attr("d", "M 1,1 l 9,9 M 10,1 l -9,9").attr("class", "arrowMarkerPath").style("stroke-width", 2).style("stroke-dasharray", "1,0");
};
const barb = (elem, type2) => {
  elem.append("defs").append("marker").attr("id", type2 + "-barbEnd").attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 14).attr("markerUnits", "strokeWidth").attr("orient", "auto").append("path").attr("d", "M 19,7 L9,13 L14,7 L9,1 Z");
};
const markers$1 = {
  extension,
  composition,
  aggregation,
  dependency,
  lollipop,
  point,
  circle: circle$1,
  cross,
  barb
};
const insertMarkers$3 = insertMarkers$2;
function applyStyle(dom, styleFn) {
  if (styleFn) {
    dom.attr("style", styleFn);
  }
}
function addHtmlLabel(node) {
  const fo = select(document.createElementNS("http://www.w3.org/2000/svg", "foreignObject"));
  const div = fo.append("xhtml:div");
  const label = node.label;
  const labelClass = node.isNode ? "nodeLabel" : "edgeLabel";
  div.html(
    '<span class="' + labelClass + '" ' + (node.labelStyle ? 'style="' + node.labelStyle + '"' : "") + ">" + label + "</span>"
  );
  applyStyle(div, node.labelStyle);
  div.style("display", "inline-block");
  div.style("white-space", "nowrap");
  div.attr("xmlns", "http://www.w3.org/1999/xhtml");
  return fo.node();
}
const createLabel = (_vertexText, style, isTitle, isNode) => {
  let vertexText = _vertexText || "";
  if (typeof vertexText === "object") {
    vertexText = vertexText[0];
  }
  if (evaluate(getConfig$1().flowchart.htmlLabels)) {
    vertexText = vertexText.replace(/\\n|\n/g, "<br />");
    log$1.info("vertexText" + vertexText);
    const node = {
      isNode,
      label: decodeEntities(vertexText).replace(
        /fa[blrs]?:fa-[\w-]+/g,
        (s) => `<i class='${s.replace(":", " ")}'></i>`
      ),
      labelStyle: style.replace("fill:", "color:")
    };
    let vertexNode = addHtmlLabel(node);
    return vertexNode;
  } else {
    const svgLabel = document.createElementNS("http://www.w3.org/2000/svg", "text");
    svgLabel.setAttribute("style", style.replace("color:", "fill:"));
    let rows = [];
    if (typeof vertexText === "string") {
      rows = vertexText.split(/\\n|\n|<br\s*\/?>/gi);
    } else if (Array.isArray(vertexText)) {
      rows = vertexText;
    } else {
      rows = [];
    }
    for (const row of rows) {
      const tspan = document.createElementNS("http://www.w3.org/2000/svg", "tspan");
      tspan.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
      tspan.setAttribute("dy", "1em");
      tspan.setAttribute("x", "0");
      if (isTitle) {
        tspan.setAttribute("class", "title-row");
      } else {
        tspan.setAttribute("class", "row");
      }
      tspan.textContent = row.trim();
      svgLabel.appendChild(tspan);
    }
    return svgLabel;
  }
};
const createLabel$1 = createLabel;
const labelHelper = (parent, node, _classes, isNode) => {
  let classes2;
  if (!_classes) {
    classes2 = "node default";
  } else {
    classes2 = _classes;
  }
  const shapeSvg = parent.insert("g").attr("class", classes2).attr("id", node.domId || node.id);
  const label = shapeSvg.insert("g").attr("class", "label").attr("style", node.labelStyle);
  let labelText;
  if (node.labelText === void 0) {
    labelText = "";
  } else {
    labelText = typeof node.labelText === "string" ? node.labelText : node.labelText[0];
  }
  const text = label.node().appendChild(
    createLabel$1(
      sanitizeText$5(decodeEntities(labelText), getConfig$1()),
      node.labelStyle,
      false,
      isNode
    )
  );
  let bbox = text.getBBox();
  if (evaluate(getConfig$1().flowchart.htmlLabels)) {
    const div = text.children[0];
    const dv = select(text);
    bbox = div.getBoundingClientRect();
    dv.attr("width", bbox.width);
    dv.attr("height", bbox.height);
  }
  const halfPadding = node.padding / 2;
  label.attr("transform", "translate(" + -bbox.width / 2 + ", " + -bbox.height / 2 + ")");
  return { shapeSvg, bbox, halfPadding, label };
};
const updateNodeBounds = (node, element) => {
  const bbox = element.node().getBBox();
  node.width = bbox.width;
  node.height = bbox.height;
};
function insertPolygonShape$1(parent, w2, h, points) {
  return parent.insert("polygon", ":first-child").attr(
    "points",
    points.map(function(d) {
      return d.x + "," + d.y;
    }).join(" ")
  ).attr("class", "label-container").attr("transform", "translate(" + -w2 / 2 + "," + h / 2 + ")");
}
let clusterDb = {};
let descendants = {};
let parents = {};
const clear$b = () => {
  descendants = {};
  parents = {};
  clusterDb = {};
};
const isDescendant = (id2, ancenstorId) => {
  log$1.trace("In isDecendant", ancenstorId, " ", id2, " = ", descendants[ancenstorId].includes(id2));
  if (descendants[ancenstorId].includes(id2)) {
    return true;
  }
  return false;
};
const edgeInCluster = (edge, clusterId) => {
  log$1.info("Decendants of ", clusterId, " is ", descendants[clusterId]);
  log$1.info("Edge is ", edge);
  if (edge.v === clusterId) {
    return false;
  }
  if (edge.w === clusterId) {
    return false;
  }
  if (!descendants[clusterId]) {
    log$1.debug("Tilt, ", clusterId, ",not in decendants");
    return false;
  }
  return descendants[clusterId].includes(edge.v) || isDescendant(edge.v, clusterId) || isDescendant(edge.w, clusterId) || descendants[clusterId].includes(edge.w);
};
const copy = (clusterId, graph, newGraph, rootId) => {
  log$1.warn(
    "Copying children of ",
    clusterId,
    "root",
    rootId,
    "data",
    graph.node(clusterId),
    rootId
  );
  const nodes = graph.children(clusterId) || [];
  if (clusterId !== rootId) {
    nodes.push(clusterId);
  }
  log$1.warn("Copying (nodes) clusterId", clusterId, "nodes", nodes);
  nodes.forEach((node) => {
    if (graph.children(node).length > 0) {
      copy(node, graph, newGraph, rootId);
    } else {
      const data = graph.node(node);
      log$1.info("cp ", node, " to ", rootId, " with parent ", clusterId);
      newGraph.setNode(node, data);
      if (rootId !== graph.parent(node)) {
        log$1.warn("Setting parent", node, graph.parent(node));
        newGraph.setParent(node, graph.parent(node));
      }
      if (clusterId !== rootId && node !== clusterId) {
        log$1.debug("Setting parent", node, clusterId);
        newGraph.setParent(node, clusterId);
      } else {
        log$1.info("In copy ", clusterId, "root", rootId, "data", graph.node(clusterId), rootId);
        log$1.debug(
          "Not Setting parent for node=",
          node,
          "cluster!==rootId",
          clusterId !== rootId,
          "node!==clusterId",
          node !== clusterId
        );
      }
      const edges2 = graph.edges(node);
      log$1.debug("Copying Edges", edges2);
      edges2.forEach((edge) => {
        log$1.info("Edge", edge);
        const data2 = graph.edge(edge.v, edge.w, edge.name);
        log$1.info("Edge data", data2, rootId);
        try {
          if (edgeInCluster(edge, rootId)) {
            log$1.info("Copying as ", edge.v, edge.w, data2, edge.name);
            newGraph.setEdge(edge.v, edge.w, data2, edge.name);
            log$1.info("newGraph edges ", newGraph.edges(), newGraph.edge(newGraph.edges()[0]));
          } else {
            log$1.info(
              "Skipping copy of edge ",
              edge.v,
              "-->",
              edge.w,
              " rootId: ",
              rootId,
              " clusterId:",
              clusterId
            );
          }
        } catch (e) {
          log$1.error(e);
        }
      });
    }
    log$1.debug("Removing node", node);
    graph.removeNode(node);
  });
};
const extractDescendants = (id2, graph) => {
  const children = graph.children(id2);
  let res = [...children];
  for (const child of children) {
    parents[child] = id2;
    res = [...res, ...extractDescendants(child, graph)];
  }
  return res;
};
const findNonClusterChild = (id2, graph) => {
  log$1.trace("Searching", id2);
  const children = graph.children(id2);
  log$1.trace("Searching children of id ", id2, children);
  if (children.length < 1) {
    log$1.trace("This is a valid node", id2);
    return id2;
  }
  for (const child of children) {
    const _id = findNonClusterChild(child, graph);
    if (_id) {
      log$1.trace("Found replacement for", id2, " => ", _id);
      return _id;
    }
  }
};
const getAnchorId = (id2) => {
  if (!clusterDb[id2]) {
    return id2;
  }
  if (!clusterDb[id2].externalConnections) {
    return id2;
  }
  if (clusterDb[id2]) {
    return clusterDb[id2].id;
  }
  return id2;
};
const adjustClustersAndEdges = (graph, depth) => {
  if (!graph || depth > 10) {
    log$1.debug("Opting out, no graph ");
    return;
  } else {
    log$1.debug("Opting in, graph ");
  }
  graph.nodes().forEach(function(id2) {
    const children = graph.children(id2);
    if (children.length > 0) {
      log$1.warn(
        "Cluster identified",
        id2,
        " Replacement id in edges: ",
        findNonClusterChild(id2, graph)
      );
      descendants[id2] = extractDescendants(id2, graph);
      clusterDb[id2] = { id: findNonClusterChild(id2, graph), clusterData: graph.node(id2) };
    }
  });
  graph.nodes().forEach(function(id2) {
    const children = graph.children(id2);
    const edges2 = graph.edges();
    if (children.length > 0) {
      log$1.debug("Cluster identified", id2, descendants);
      edges2.forEach((edge) => {
        if (edge.v !== id2 && edge.w !== id2) {
          const d1 = isDescendant(edge.v, id2);
          const d2 = isDescendant(edge.w, id2);
          if (d1 ^ d2) {
            log$1.warn("Edge: ", edge, " leaves cluster ", id2);
            log$1.warn("Decendants of XXX ", id2, ": ", descendants[id2]);
            clusterDb[id2].externalConnections = true;
          }
        }
      });
    } else {
      log$1.debug("Not a cluster ", id2, descendants);
    }
  });
  graph.edges().forEach(function(e) {
    const edge = graph.edge(e);
    log$1.warn("Edge " + e.v + " -> " + e.w + ": " + JSON.stringify(e));
    log$1.warn("Edge " + e.v + " -> " + e.w + ": " + JSON.stringify(graph.edge(e)));
    let v = e.v;
    let w2 = e.w;
    log$1.warn(
      "Fix XXX",
      clusterDb,
      "ids:",
      e.v,
      e.w,
      "Translating: ",
      clusterDb[e.v],
      " --- ",
      clusterDb[e.w]
    );
    if (clusterDb[e.v] && clusterDb[e.w] && clusterDb[e.v] === clusterDb[e.w]) {
      log$1.warn("Fixing and trixing link to self - removing XXX", e.v, e.w, e.name);
      log$1.warn("Fixing and trixing - removing XXX", e.v, e.w, e.name);
      v = getAnchorId(e.v);
      w2 = getAnchorId(e.w);
      graph.removeEdge(e.v, e.w, e.name);
      const specialId = e.w + "---" + e.v;
      graph.setNode(specialId, {
        domId: specialId,
        id: specialId,
        labelStyle: "",
        labelText: edge.label,
        padding: 0,
        shape: "labelRect",
        style: ""
      });
      const edge1 = JSON.parse(JSON.stringify(edge));
      const edge2 = JSON.parse(JSON.stringify(edge));
      edge1.label = "";
      edge1.arrowTypeEnd = "none";
      edge2.label = "";
      edge1.fromCluster = e.v;
      edge2.toCluster = e.v;
      graph.setEdge(v, specialId, edge1, e.name + "-cyclic-special");
      graph.setEdge(specialId, w2, edge2, e.name + "-cyclic-special");
    } else if (clusterDb[e.v] || clusterDb[e.w]) {
      log$1.warn("Fixing and trixing - removing XXX", e.v, e.w, e.name);
      v = getAnchorId(e.v);
      w2 = getAnchorId(e.w);
      graph.removeEdge(e.v, e.w, e.name);
      if (v !== e.v) {
        edge.fromCluster = e.v;
      }
      if (w2 !== e.w) {
        edge.toCluster = e.w;
      }
      log$1.warn("Fix Replacing with XXX", v, w2, e.name);
      graph.setEdge(v, w2, edge, e.name);
    }
  });
  log$1.warn("Adjusted Graph", graphlibJson.write(graph));
  extractor(graph, 0);
  log$1.trace(clusterDb);
};
const extractor = (graph, depth) => {
  log$1.warn("extractor - ", depth, graphlibJson.write(graph), graph.children("D"));
  if (depth > 10) {
    log$1.error("Bailing out");
    return;
  }
  let nodes = graph.nodes();
  let hasChildren = false;
  for (const node of nodes) {
    const children = graph.children(node);
    hasChildren = hasChildren || children.length > 0;
  }
  if (!hasChildren) {
    log$1.debug("Done, no node has children", graph.nodes());
    return;
  }
  log$1.debug("Nodes = ", nodes, depth);
  for (const node of nodes) {
    log$1.debug(
      "Extracting node",
      node,
      clusterDb,
      clusterDb[node] && !clusterDb[node].externalConnections,
      !graph.parent(node),
      graph.node(node),
      graph.children("D"),
      " Depth ",
      depth
    );
    if (!clusterDb[node]) {
      log$1.debug("Not a cluster", node, depth);
    } else if (!clusterDb[node].externalConnections && // !graph.parent(node) &&
    graph.children(node) && graph.children(node).length > 0) {
      log$1.warn(
        "Cluster without external connections, without a parent and with children",
        node,
        depth
      );
      const graphSettings = graph.graph();
      let dir = graphSettings.rankdir === "TB" ? "LR" : "TB";
      if (clusterDb[node] && clusterDb[node].clusterData && clusterDb[node].clusterData.dir) {
        dir = clusterDb[node].clusterData.dir;
        log$1.warn("Fixing dir", clusterDb[node].clusterData.dir, dir);
      }
      const clusterGraph = new graphlib.Graph({
        multigraph: true,
        compound: true
      }).setGraph({
        rankdir: dir,
        // Todo: set proper spacing
        nodesep: 50,
        ranksep: 50,
        marginx: 8,
        marginy: 8
      }).setDefaultEdgeLabel(function() {
        return {};
      });
      log$1.warn("Old graph before copy", graphlibJson.write(graph));
      copy(node, graph, clusterGraph, node);
      graph.setNode(node, {
        clusterNode: true,
        id: node,
        clusterData: clusterDb[node].clusterData,
        labelText: clusterDb[node].labelText,
        graph: clusterGraph
      });
      log$1.warn("New graph after copy node: (", node, ")", graphlibJson.write(clusterGraph));
      log$1.debug("Old graph after copy", graphlibJson.write(graph));
    } else {
      log$1.warn(
        "Cluster ** ",
        node,
        " **not meeting the criteria !externalConnections:",
        !clusterDb[node].externalConnections,
        " no parent: ",
        !graph.parent(node),
        " children ",
        graph.children(node) && graph.children(node).length > 0,
        graph.children("D"),
        depth
      );
      log$1.debug(clusterDb);
    }
  }
  nodes = graph.nodes();
  log$1.warn("New list of nodes", nodes);
  for (const node of nodes) {
    const data = graph.node(node);
    log$1.warn(" Now next level", node, data);
    if (data.clusterNode) {
      extractor(data.graph, depth + 1);
    }
  }
};
const sorter = (graph, nodes) => {
  if (nodes.length === 0) {
    return [];
  }
  let result = Object.assign(nodes);
  nodes.forEach((node) => {
    const children = graph.children(node);
    const sorted = sorter(graph, children);
    result = [...result, ...sorted];
  });
  return result;
};
const sortNodesByHierarchy = (graph) => sorter(graph, graph.children());
function intersectNode(node, point2) {
  return node.intersect(point2);
}
function intersectEllipse(node, rx, ry, point2) {
  var cx = node.x;
  var cy = node.y;
  var px = cx - point2.x;
  var py = cy - point2.y;
  var det = Math.sqrt(rx * rx * py * py + ry * ry * px * px);
  var dx = Math.abs(rx * ry * px / det);
  if (point2.x < cx) {
    dx = -dx;
  }
  var dy = Math.abs(rx * ry * py / det);
  if (point2.y < cy) {
    dy = -dy;
  }
  return { x: cx + dx, y: cy + dy };
}
function intersectCircle(node, rx, point2) {
  return intersectEllipse(node, rx, rx, point2);
}
function intersectLine(p1, p2, q1, q2) {
  var a1, a2, b1, b2, c1, c2;
  var r1, r2, r3, r4;
  var denom, offset, num;
  var x, y;
  a1 = p2.y - p1.y;
  b1 = p1.x - p2.x;
  c1 = p2.x * p1.y - p1.x * p2.y;
  r3 = a1 * q1.x + b1 * q1.y + c1;
  r4 = a1 * q2.x + b1 * q2.y + c1;
  if (r3 !== 0 && r4 !== 0 && sameSign(r3, r4)) {
    return;
  }
  a2 = q2.y - q1.y;
  b2 = q1.x - q2.x;
  c2 = q2.x * q1.y - q1.x * q2.y;
  r1 = a2 * p1.x + b2 * p1.y + c2;
  r2 = a2 * p2.x + b2 * p2.y + c2;
  if (r1 !== 0 && r2 !== 0 && sameSign(r1, r2)) {
    return;
  }
  denom = a1 * b2 - a2 * b1;
  if (denom === 0) {
    return;
  }
  offset = Math.abs(denom / 2);
  num = b1 * c2 - b2 * c1;
  x = num < 0 ? (num - offset) / denom : (num + offset) / denom;
  num = a2 * c1 - a1 * c2;
  y = num < 0 ? (num - offset) / denom : (num + offset) / denom;
  return { x, y };
}
function sameSign(r1, r2) {
  return r1 * r2 > 0;
}
function intersectPolygon(node, polyPoints, point2) {
  var x1 = node.x;
  var y1 = node.y;
  var intersections = [];
  var minX = Number.POSITIVE_INFINITY;
  var minY = Number.POSITIVE_INFINITY;
  if (typeof polyPoints.forEach === "function") {
    polyPoints.forEach(function(entry) {
      minX = Math.min(minX, entry.x);
      minY = Math.min(minY, entry.y);
    });
  } else {
    minX = Math.min(minX, polyPoints.x);
    minY = Math.min(minY, polyPoints.y);
  }
  var left = x1 - node.width / 2 - minX;
  var top = y1 - node.height / 2 - minY;
  for (var i = 0; i < polyPoints.length; i++) {
    var p1 = polyPoints[i];
    var p2 = polyPoints[i < polyPoints.length - 1 ? i + 1 : 0];
    var intersect2 = intersectLine(
      node,
      point2,
      { x: left + p1.x, y: top + p1.y },
      { x: left + p2.x, y: top + p2.y }
    );
    if (intersect2) {
      intersections.push(intersect2);
    }
  }
  if (!intersections.length) {
    return node;
  }
  if (intersections.length > 1) {
    intersections.sort(function(p, q) {
      var pdx = p.x - point2.x;
      var pdy = p.y - point2.y;
      var distp = Math.sqrt(pdx * pdx + pdy * pdy);
      var qdx = q.x - point2.x;
      var qdy = q.y - point2.y;
      var distq = Math.sqrt(qdx * qdx + qdy * qdy);
      return distp < distq ? -1 : distp === distq ? 0 : 1;
    });
  }
  return intersections[0];
}
const intersectRect = (node, point2) => {
  var x = node.x;
  var y = node.y;
  var dx = point2.x - x;
  var dy = point2.y - y;
  var w2 = node.width / 2;
  var h = node.height / 2;
  var sx, sy;
  if (Math.abs(dy) * w2 > Math.abs(dx) * h) {
    if (dy < 0) {
      h = -h;
    }
    sx = dy === 0 ? 0 : h * dx / dy;
    sy = h;
  } else {
    if (dx < 0) {
      w2 = -w2;
    }
    sx = w2;
    sy = dx === 0 ? 0 : w2 * dy / dx;
  }
  return { x: x + sx, y: y + sy };
};
const intersectRect$1 = intersectRect;
const intersect = {
  node: intersectNode,
  circle: intersectCircle,
  ellipse: intersectEllipse,
  polygon: intersectPolygon,
  rect: intersectRect$1
};
const note = (parent, node) => {
  const { shapeSvg, bbox, halfPadding } = labelHelper(parent, node, "node " + node.classes, true);
  log$1.info("Classes = ", node.classes);
  const rect2 = shapeSvg.insert("rect", ":first-child");
  rect2.attr("rx", node.rx).attr("ry", node.ry).attr("x", -bbox.width / 2 - halfPadding).attr("y", -bbox.height / 2 - halfPadding).attr("width", bbox.width + node.padding).attr("height", bbox.height + node.padding);
  updateNodeBounds(node, rect2);
  node.intersect = function(point2) {
    return intersect.rect(node, point2);
  };
  return shapeSvg;
};
const note$1 = note;
const question$1 = (parent, node) => {
  const { shapeSvg, bbox } = labelHelper(parent, node, void 0, true);
  const w2 = bbox.width + node.padding;
  const h = bbox.height + node.padding;
  const s = w2 + h;
  const points = [
    { x: s / 2, y: 0 },
    { x: s, y: -s / 2 },
    { x: s / 2, y: -s },
    { x: 0, y: -s / 2 }
  ];
  log$1.info("Question main (Circle)");
  const questionElem = insertPolygonShape$1(shapeSvg, s, s, points);
  questionElem.attr("style", node.style);
  updateNodeBounds(node, questionElem);
  node.intersect = function(point2) {
    log$1.warn("Intersect called");
    return intersect.polygon(node, points, point2);
  };
  return shapeSvg;
};
const choice = (parent, node) => {
  const shapeSvg = parent.insert("g").attr("class", "node default").attr("id", node.domId || node.id);
  const s = 28;
  const points = [
    { x: 0, y: s / 2 },
    { x: s / 2, y: 0 },
    { x: 0, y: -s / 2 },
    { x: -s / 2, y: 0 }
  ];
  const choice2 = shapeSvg.insert("polygon", ":first-child").attr(
    "points",
    points.map(function(d) {
      return d.x + "," + d.y;
    }).join(" ")
  );
  choice2.attr("class", "state-start").attr("r", 7).attr("width", 28).attr("height", 28);
  node.width = 28;
  node.height = 28;
  node.intersect = function(point2) {
    return intersect.circle(node, 14, point2);
  };
  return shapeSvg;
};
const hexagon$1 = (parent, node) => {
  const { shapeSvg, bbox } = labelHelper(parent, node, void 0, true);
  const f = 4;
  const h = bbox.height + node.padding;
  const m = h / f;
  const w2 = bbox.width + 2 * m + node.padding;
  const points = [
    { x: m, y: 0 },
    { x: w2 - m, y: 0 },
    { x: w2, y: -h / 2 },
    { x: w2 - m, y: -h },
    { x: m, y: -h },
    { x: 0, y: -h / 2 }
  ];
  const hex = insertPolygonShape$1(shapeSvg, w2, h, points);
  hex.attr("style", node.style);
  updateNodeBounds(node, hex);
  node.intersect = function(point2) {
    return intersect.polygon(node, points, point2);
  };
  return shapeSvg;
};
const rect_left_inv_arrow$1 = (parent, node) => {
  const { shapeSvg, bbox } = labelHelper(parent, node, void 0, true);
  const w2 = bbox.width + node.padding;
  const h = bbox.height + node.padding;
  const points = [
    { x: -h / 2, y: 0 },
    { x: w2, y: 0 },
    { x: w2, y: -h },
    { x: -h / 2, y: -h },
    { x: 0, y: -h / 2 }
  ];
  const el = insertPolygonShape$1(shapeSvg, w2, h, points);
  el.attr("style", node.style);
  node.width = w2 + h;
  node.height = h;
  node.intersect = function(point2) {
    return intersect.polygon(node, points, point2);
  };
  return shapeSvg;
};
const lean_right$1 = (parent, node) => {
  const { shapeSvg, bbox } = labelHelper(parent, node, void 0, true);
  const w2 = bbox.width + node.padding;
  const h = bbox.height + node.padding;
  const points = [
    { x: -2 * h / 6, y: 0 },
    { x: w2 - h / 6, y: 0 },
    { x: w2 + 2 * h / 6, y: -h },
    { x: h / 6, y: -h }
  ];
  const el = insertPolygonShape$1(shapeSvg, w2, h, points);
  el.attr("style", node.style);
  updateNodeBounds(node, el);
  node.intersect = function(point2) {
    return intersect.polygon(node, points, point2);
  };
  return shapeSvg;
};
const lean_left$1 = (parent, node) => {
  const { shapeSvg, bbox } = labelHelper(parent, node, void 0, true);
  const w2 = bbox.width + node.padding;
  const h = bbox.height + node.padding;
  const points = [
    { x: 2 * h / 6, y: 0 },
    { x: w2 + h / 6, y: 0 },
    { x: w2 - 2 * h / 6, y: -h },
    { x: -h / 6, y: -h }
  ];
  const el = insertPolygonShape$1(shapeSvg, w2, h, points);
  el.attr("style", node.style);
  updateNodeBounds(node, el);
  node.intersect = function(point2) {
    return intersect.polygon(node, points, point2);
  };
  return shapeSvg;
};
const trapezoid$1 = (parent, node) => {
  const { shapeSvg, bbox } = labelHelper(parent, node, void 0, true);
  const w2 = bbox.width + node.padding;
  const h = bbox.height + node.padding;
  const points = [
    { x: -2 * h / 6, y: 0 },
    { x: w2 + 2 * h / 6, y: 0 },
    { x: w2 - h / 6, y: -h },
    { x: h / 6, y: -h }
  ];
  const el = insertPolygonShape$1(shapeSvg, w2, h, points);
  el.attr("style", node.style);
  updateNodeBounds(node, el);
  node.intersect = function(point2) {
    return intersect.polygon(node, points, point2);
  };
  return shapeSvg;
};
const inv_trapezoid$1 = (parent, node) => {
  const { shapeSvg, bbox } = labelHelper(parent, node, void 0, true);
  const w2 = bbox.width + node.padding;
  const h = bbox.height + node.padding;
  const points = [
    { x: h / 6, y: 0 },
    { x: w2 - h / 6, y: 0 },
    { x: w2 + 2 * h / 6, y: -h },
    { x: -2 * h / 6, y: -h }
  ];
  const el = insertPolygonShape$1(shapeSvg, w2, h, points);
  el.attr("style", node.style);
  updateNodeBounds(node, el);
  node.intersect = function(point2) {
    return intersect.polygon(node, points, point2);
  };
  return shapeSvg;
};
const rect_right_inv_arrow$1 = (parent, node) => {
  const { shapeSvg, bbox } = labelHelper(parent, node, void 0, true);
  const w2 = bbox.width + node.padding;
  const h = bbox.height + node.padding;
  const points = [
    { x: 0, y: 0 },
    { x: w2 + h / 2, y: 0 },
    { x: w2, y: -h / 2 },
    { x: w2 + h / 2, y: -h },
    { x: 0, y: -h }
  ];
  const el = insertPolygonShape$1(shapeSvg, w2, h, points);
  el.attr("style", node.style);
  updateNodeBounds(node, el);
  node.intersect = function(point2) {
    return intersect.polygon(node, points, point2);
  };
  return shapeSvg;
};
const cylinder$1 = (parent, node) => {
  const { shapeSvg, bbox } = labelHelper(parent, node, void 0, true);
  const w2 = bbox.width + node.padding;
  const rx = w2 / 2;
  const ry = rx / (2.5 + w2 / 50);
  const h = bbox.height + ry + node.padding;
  const shape = "M 0," + ry + " a " + rx + "," + ry + " 0,0,0 " + w2 + " 0 a " + rx + "," + ry + " 0,0,0 " + -w2 + " 0 l 0," + h + " a " + rx + "," + ry + " 0,0,0 " + w2 + " 0 l 0," + -h;
  const el = shapeSvg.attr("label-offset-y", ry).insert("path", ":first-child").attr("style", node.style).attr("d", shape).attr("transform", "translate(" + -w2 / 2 + "," + -(h / 2 + ry) + ")");
  updateNodeBounds(node, el);
  node.intersect = function(point2) {
    const pos = intersect.rect(node, point2);
    const x = pos.x - node.x;
    if (rx != 0 && (Math.abs(x) < node.width / 2 || Math.abs(x) == node.width / 2 && Math.abs(pos.y - node.y) > node.height / 2 - ry)) {
      let y = ry * ry * (1 - x * x / (rx * rx));
      if (y != 0) {
        y = Math.sqrt(y);
      }
      y = ry - y;
      if (point2.y - node.y > 0) {
        y = -y;
      }
      pos.y += y;
    }
    return pos;
  };
  return shapeSvg;
};
const rect$1 = (parent, node) => {
  const { shapeSvg, bbox, halfPadding } = labelHelper(parent, node, "node " + node.classes, true);
  log$1.trace("Classes = ", node.classes);
  const rect2 = shapeSvg.insert("rect", ":first-child");
  const totalWidth = bbox.width + node.padding;
  const totalHeight = bbox.height + node.padding;
  rect2.attr("class", "basic label-container").attr("style", node.style).attr("rx", node.rx).attr("ry", node.ry).attr("x", -bbox.width / 2 - halfPadding).attr("y", -bbox.height / 2 - halfPadding).attr("width", totalWidth).attr("height", totalHeight);
  if (node.props) {
    const propKeys = new Set(Object.keys(node.props));
    if (node.props.borders) {
      applyNodePropertyBorders(rect2, node.props.borders, totalWidth, totalHeight);
      propKeys.delete("borders");
    }
    propKeys.forEach((propKey) => {
      log$1.warn(`Unknown node property ${propKey}`);
    });
  }
  updateNodeBounds(node, rect2);
  node.intersect = function(point2) {
    return intersect.rect(node, point2);
  };
  return shapeSvg;
};
const labelRect = (parent, node) => {
  const { shapeSvg } = labelHelper(parent, node, "label", true);
  log$1.trace("Classes = ", node.classes);
  const rect2 = shapeSvg.insert("rect", ":first-child");
  const totalWidth = 0;
  const totalHeight = 0;
  rect2.attr("width", totalWidth).attr("height", totalHeight);
  shapeSvg.attr("class", "label edgeLabel");
  if (node.props) {
    const propKeys = new Set(Object.keys(node.props));
    if (node.props.borders) {
      applyNodePropertyBorders(rect2, node.props.borders, totalWidth, totalHeight);
      propKeys.delete("borders");
    }
    propKeys.forEach((propKey) => {
      log$1.warn(`Unknown node property ${propKey}`);
    });
  }
  updateNodeBounds(node, rect2);
  node.intersect = function(point2) {
    return intersect.rect(node, point2);
  };
  return shapeSvg;
};
function applyNodePropertyBorders(rect2, borders, totalWidth, totalHeight) {
  const strokeDashArray = [];
  const addBorder = (length) => {
    strokeDashArray.push(length, 0);
  };
  const skipBorder = (length) => {
    strokeDashArray.push(0, length);
  };
  if (borders.includes("t")) {
    log$1.debug("add top border");
    addBorder(totalWidth);
  } else {
    skipBorder(totalWidth);
  }
  if (borders.includes("r")) {
    log$1.debug("add right border");
    addBorder(totalHeight);
  } else {
    skipBorder(totalHeight);
  }
  if (borders.includes("b")) {
    log$1.debug("add bottom border");
    addBorder(totalWidth);
  } else {
    skipBorder(totalWidth);
  }
  if (borders.includes("l")) {
    log$1.debug("add left border");
    addBorder(totalHeight);
  } else {
    skipBorder(totalHeight);
  }
  rect2.attr("stroke-dasharray", strokeDashArray.join(" "));
}
const rectWithTitle = (parent, node) => {
  let classes2;
  if (!node.classes) {
    classes2 = "node default";
  } else {
    classes2 = "node " + node.classes;
  }
  const shapeSvg = parent.insert("g").attr("class", classes2).attr("id", node.domId || node.id);
  const rect2 = shapeSvg.insert("rect", ":first-child");
  const innerLine = shapeSvg.insert("line");
  const label = shapeSvg.insert("g").attr("class", "label");
  const text2 = node.labelText.flat ? node.labelText.flat() : node.labelText;
  let title2 = "";
  if (typeof text2 === "object") {
    title2 = text2[0];
  } else {
    title2 = text2;
  }
  log$1.info("Label text abc79", title2, text2, typeof text2 === "object");
  const text = label.node().appendChild(createLabel$1(title2, node.labelStyle, true, true));
  let bbox = { width: 0, height: 0 };
  if (evaluate(getConfig$1().flowchart.htmlLabels)) {
    const div = text.children[0];
    const dv = select(text);
    bbox = div.getBoundingClientRect();
    dv.attr("width", bbox.width);
    dv.attr("height", bbox.height);
  }
  log$1.info("Text 2", text2);
  const textRows = text2.slice(1, text2.length);
  let titleBox = text.getBBox();
  const descr = label.node().appendChild(
    createLabel$1(textRows.join ? textRows.join("<br/>") : textRows, node.labelStyle, true, true)
  );
  if (evaluate(getConfig$1().flowchart.htmlLabels)) {
    const div = descr.children[0];
    const dv = select(descr);
    bbox = div.getBoundingClientRect();
    dv.attr("width", bbox.width);
    dv.attr("height", bbox.height);
  }
  const halfPadding = node.padding / 2;
  select(descr).attr(
    "transform",
    "translate( " + // (titleBox.width - bbox.width) / 2 +
    (bbox.width > titleBox.width ? 0 : (titleBox.width - bbox.width) / 2) + ", " + (titleBox.height + halfPadding + 5) + ")"
  );
  select(text).attr(
    "transform",
    "translate( " + // (titleBox.width - bbox.width) / 2 +
    (bbox.width < titleBox.width ? 0 : -(titleBox.width - bbox.width) / 2) + ", " + 0 + ")"
  );
  bbox = label.node().getBBox();
  label.attr(
    "transform",
    "translate(" + -bbox.width / 2 + ", " + (-bbox.height / 2 - halfPadding + 3) + ")"
  );
  rect2.attr("class", "outer title-state").attr("x", -bbox.width / 2 - halfPadding).attr("y", -bbox.height / 2 - halfPadding).attr("width", bbox.width + node.padding).attr("height", bbox.height + node.padding);
  innerLine.attr("class", "divider").attr("x1", -bbox.width / 2 - halfPadding).attr("x2", bbox.width / 2 + halfPadding).attr("y1", -bbox.height / 2 - halfPadding + titleBox.height + halfPadding).attr("y2", -bbox.height / 2 - halfPadding + titleBox.height + halfPadding);
  updateNodeBounds(node, rect2);
  node.intersect = function(point2) {
    return intersect.rect(node, point2);
  };
  return shapeSvg;
};
const stadium$1 = (parent, node) => {
  const { shapeSvg, bbox } = labelHelper(parent, node, void 0, true);
  const h = bbox.height + node.padding;
  const w2 = bbox.width + h / 4 + node.padding;
  const rect2 = shapeSvg.insert("rect", ":first-child").attr("style", node.style).attr("rx", h / 2).attr("ry", h / 2).attr("x", -w2 / 2).attr("y", -h / 2).attr("width", w2).attr("height", h);
  updateNodeBounds(node, rect2);
  node.intersect = function(point2) {
    return intersect.rect(node, point2);
  };
  return shapeSvg;
};
const circle = (parent, node) => {
  const { shapeSvg, bbox, halfPadding } = labelHelper(parent, node, void 0, true);
  const circle2 = shapeSvg.insert("circle", ":first-child");
  circle2.attr("style", node.style).attr("rx", node.rx).attr("ry", node.ry).attr("r", bbox.width / 2 + halfPadding).attr("width", bbox.width + node.padding).attr("height", bbox.height + node.padding);
  log$1.info("Circle main");
  updateNodeBounds(node, circle2);
  node.intersect = function(point2) {
    log$1.info("Circle intersect", node, bbox.width / 2 + halfPadding, point2);
    return intersect.circle(node, bbox.width / 2 + halfPadding, point2);
  };
  return shapeSvg;
};
const doublecircle = (parent, node) => {
  const { shapeSvg, bbox, halfPadding } = labelHelper(parent, node, void 0, true);
  const gap = 5;
  const circleGroup = shapeSvg.insert("g", ":first-child");
  const outerCircle = circleGroup.insert("circle");
  const innerCircle = circleGroup.insert("circle");
  outerCircle.attr("style", node.style).attr("rx", node.rx).attr("ry", node.ry).attr("r", bbox.width / 2 + halfPadding + gap).attr("width", bbox.width + node.padding + gap * 2).attr("height", bbox.height + node.padding + gap * 2);
  innerCircle.attr("style", node.style).attr("rx", node.rx).attr("ry", node.ry).attr("r", bbox.width / 2 + halfPadding).attr("width", bbox.width + node.padding).attr("height", bbox.height + node.padding);
  log$1.info("DoubleCircle main");
  updateNodeBounds(node, outerCircle);
  node.intersect = function(point2) {
    log$1.info("DoubleCircle intersect", node, bbox.width / 2 + halfPadding + gap, point2);
    return intersect.circle(node, bbox.width / 2 + halfPadding + gap, point2);
  };
  return shapeSvg;
};
const subroutine$1 = (parent, node) => {
  const { shapeSvg, bbox } = labelHelper(parent, node, void 0, true);
  const w2 = bbox.width + node.padding;
  const h = bbox.height + node.padding;
  const points = [
    { x: 0, y: 0 },
    { x: w2, y: 0 },
    { x: w2, y: -h },
    { x: 0, y: -h },
    { x: 0, y: 0 },
    { x: -8, y: 0 },
    { x: w2 + 8, y: 0 },
    { x: w2 + 8, y: -h },
    { x: -8, y: -h },
    { x: -8, y: 0 }
  ];
  const el = insertPolygonShape$1(shapeSvg, w2, h, points);
  el.attr("style", node.style);
  updateNodeBounds(node, el);
  node.intersect = function(point2) {
    return intersect.polygon(node, points, point2);
  };
  return shapeSvg;
};
const start = (parent, node) => {
  const shapeSvg = parent.insert("g").attr("class", "node default").attr("id", node.domId || node.id);
  const circle2 = shapeSvg.insert("circle", ":first-child");
  circle2.attr("class", "state-start").attr("r", 7).attr("width", 14).attr("height", 14);
  updateNodeBounds(node, circle2);
  node.intersect = function(point2) {
    return intersect.circle(node, 7, point2);
  };
  return shapeSvg;
};
const forkJoin = (parent, node, dir) => {
  const shapeSvg = parent.insert("g").attr("class", "node default").attr("id", node.domId || node.id);
  let width2 = 70;
  let height2 = 10;
  if (dir === "LR") {
    width2 = 10;
    height2 = 70;
  }
  const shape = shapeSvg.append("rect").attr("x", -1 * width2 / 2).attr("y", -1 * height2 / 2).attr("width", width2).attr("height", height2).attr("class", "fork-join");
  updateNodeBounds(node, shape);
  node.height = node.height + node.padding / 2;
  node.width = node.width + node.padding / 2;
  node.intersect = function(point2) {
    return intersect.rect(node, point2);
  };
  return shapeSvg;
};
const end = (parent, node) => {
  const shapeSvg = parent.insert("g").attr("class", "node default").attr("id", node.domId || node.id);
  const innerCircle = shapeSvg.insert("circle", ":first-child");
  const circle2 = shapeSvg.insert("circle", ":first-child");
  circle2.attr("class", "state-start").attr("r", 7).attr("width", 14).attr("height", 14);
  innerCircle.attr("class", "state-end").attr("r", 5).attr("width", 10).attr("height", 10);
  updateNodeBounds(node, circle2);
  node.intersect = function(point2) {
    return intersect.circle(node, 7, point2);
  };
  return shapeSvg;
};
const class_box = (parent, node) => {
  const halfPadding = node.padding / 2;
  const rowPadding = 4;
  const lineHeight = 8;
  let classes2;
  if (!node.classes) {
    classes2 = "node default";
  } else {
    classes2 = "node " + node.classes;
  }
  const shapeSvg = parent.insert("g").attr("class", classes2).attr("id", node.domId || node.id);
  const rect2 = shapeSvg.insert("rect", ":first-child");
  const topLine = shapeSvg.insert("line");
  const bottomLine = shapeSvg.insert("line");
  let maxWidth = 0;
  let maxHeight = rowPadding;
  const labelContainer = shapeSvg.insert("g").attr("class", "label");
  let verticalPos = 0;
  const hasInterface = node.classData.annotations && node.classData.annotations[0];
  const interfaceLabelText = node.classData.annotations[0] ? "«" + node.classData.annotations[0] + "»" : "";
  const interfaceLabel = labelContainer.node().appendChild(createLabel$1(interfaceLabelText, node.labelStyle, true, true));
  let interfaceBBox = interfaceLabel.getBBox();
  if (evaluate(getConfig$1().flowchart.htmlLabels)) {
    const div = interfaceLabel.children[0];
    const dv = select(interfaceLabel);
    interfaceBBox = div.getBoundingClientRect();
    dv.attr("width", interfaceBBox.width);
    dv.attr("height", interfaceBBox.height);
  }
  if (node.classData.annotations[0]) {
    maxHeight += interfaceBBox.height + rowPadding;
    maxWidth += interfaceBBox.width;
  }
  let classTitleString = node.classData.id;
  if (node.classData.type !== void 0 && node.classData.type !== "") {
    if (getConfig$1().flowchart.htmlLabels) {
      classTitleString += "&lt;" + node.classData.type + "&gt;";
    } else {
      classTitleString += "<" + node.classData.type + ">";
    }
  }
  const classTitleLabel = labelContainer.node().appendChild(createLabel$1(classTitleString, node.labelStyle, true, true));
  select(classTitleLabel).attr("class", "classTitle");
  let classTitleBBox = classTitleLabel.getBBox();
  if (evaluate(getConfig$1().flowchart.htmlLabels)) {
    const div = classTitleLabel.children[0];
    const dv = select(classTitleLabel);
    classTitleBBox = div.getBoundingClientRect();
    dv.attr("width", classTitleBBox.width);
    dv.attr("height", classTitleBBox.height);
  }
  maxHeight += classTitleBBox.height + rowPadding;
  if (classTitleBBox.width > maxWidth) {
    maxWidth = classTitleBBox.width;
  }
  const classAttributes = [];
  node.classData.members.forEach((str2) => {
    const parsedInfo = parseMember(str2);
    let parsedText = parsedInfo.displayText;
    if (getConfig$1().flowchart.htmlLabels) {
      parsedText = parsedText.replace(/</g, "&lt;").replace(/>/g, "&gt;");
    }
    const lbl = labelContainer.node().appendChild(
      createLabel$1(
        parsedText,
        parsedInfo.cssStyle ? parsedInfo.cssStyle : node.labelStyle,
        true,
        true
      )
    );
    let bbox = lbl.getBBox();
    if (evaluate(getConfig$1().flowchart.htmlLabels)) {
      const div = lbl.children[0];
      const dv = select(lbl);
      bbox = div.getBoundingClientRect();
      dv.attr("width", bbox.width);
      dv.attr("height", bbox.height);
    }
    if (bbox.width > maxWidth) {
      maxWidth = bbox.width;
    }
    maxHeight += bbox.height + rowPadding;
    classAttributes.push(lbl);
  });
  maxHeight += lineHeight;
  const classMethods = [];
  node.classData.methods.forEach((str2) => {
    const parsedInfo = parseMember(str2);
    let displayText = parsedInfo.displayText;
    if (getConfig$1().flowchart.htmlLabels) {
      displayText = displayText.replace(/</g, "&lt;").replace(/>/g, "&gt;");
    }
    const lbl = labelContainer.node().appendChild(
      createLabel$1(
        displayText,
        parsedInfo.cssStyle ? parsedInfo.cssStyle : node.labelStyle,
        true,
        true
      )
    );
    let bbox = lbl.getBBox();
    if (evaluate(getConfig$1().flowchart.htmlLabels)) {
      const div = lbl.children[0];
      const dv = select(lbl);
      bbox = div.getBoundingClientRect();
      dv.attr("width", bbox.width);
      dv.attr("height", bbox.height);
    }
    if (bbox.width > maxWidth) {
      maxWidth = bbox.width;
    }
    maxHeight += bbox.height + rowPadding;
    classMethods.push(lbl);
  });
  maxHeight += lineHeight;
  if (hasInterface) {
    let diffX2 = (maxWidth - interfaceBBox.width) / 2;
    select(interfaceLabel).attr(
      "transform",
      "translate( " + (-1 * maxWidth / 2 + diffX2) + ", " + -1 * maxHeight / 2 + ")"
    );
    verticalPos = interfaceBBox.height + rowPadding;
  }
  let diffX = (maxWidth - classTitleBBox.width) / 2;
  select(classTitleLabel).attr(
    "transform",
    "translate( " + (-1 * maxWidth / 2 + diffX) + ", " + (-1 * maxHeight / 2 + verticalPos) + ")"
  );
  verticalPos += classTitleBBox.height + rowPadding;
  topLine.attr("class", "divider").attr("x1", -maxWidth / 2 - halfPadding).attr("x2", maxWidth / 2 + halfPadding).attr("y1", -maxHeight / 2 - halfPadding + lineHeight + verticalPos).attr("y2", -maxHeight / 2 - halfPadding + lineHeight + verticalPos);
  verticalPos += lineHeight;
  classAttributes.forEach((lbl) => {
    select(lbl).attr(
      "transform",
      "translate( " + -maxWidth / 2 + ", " + (-1 * maxHeight / 2 + verticalPos + lineHeight / 2) + ")"
    );
    verticalPos += classTitleBBox.height + rowPadding;
  });
  verticalPos += lineHeight;
  bottomLine.attr("class", "divider").attr("x1", -maxWidth / 2 - halfPadding).attr("x2", maxWidth / 2 + halfPadding).attr("y1", -maxHeight / 2 - halfPadding + lineHeight + verticalPos).attr("y2", -maxHeight / 2 - halfPadding + lineHeight + verticalPos);
  verticalPos += lineHeight;
  classMethods.forEach((lbl) => {
    select(lbl).attr(
      "transform",
      "translate( " + -maxWidth / 2 + ", " + (-1 * maxHeight / 2 + verticalPos) + ")"
    );
    verticalPos += classTitleBBox.height + rowPadding;
  });
  rect2.attr("class", "outer title-state").attr("x", -maxWidth / 2 - halfPadding).attr("y", -(maxHeight / 2) - halfPadding).attr("width", maxWidth + node.padding).attr("height", maxHeight + node.padding);
  updateNodeBounds(node, rect2);
  node.intersect = function(point2) {
    return intersect.rect(node, point2);
  };
  return shapeSvg;
};
const shapes$1 = {
  rhombus: question$1,
  question: question$1,
  rect: rect$1,
  labelRect,
  rectWithTitle,
  choice,
  circle,
  doublecircle,
  stadium: stadium$1,
  hexagon: hexagon$1,
  rect_left_inv_arrow: rect_left_inv_arrow$1,
  lean_right: lean_right$1,
  lean_left: lean_left$1,
  trapezoid: trapezoid$1,
  inv_trapezoid: inv_trapezoid$1,
  rect_right_inv_arrow: rect_right_inv_arrow$1,
  cylinder: cylinder$1,
  start,
  end,
  note: note$1,
  subroutine: subroutine$1,
  fork: forkJoin,
  join: forkJoin,
  class_box
};
let nodeElems = {};
const insertNode = (elem, node, dir) => {
  let newEl;
  let el;
  if (node.link) {
    let target;
    if (getConfig$1().securityLevel === "sandbox") {
      target = "_top";
    } else if (node.linkTarget) {
      target = node.linkTarget || "_blank";
    }
    newEl = elem.insert("svg:a").attr("xlink:href", node.link).attr("target", target);
    el = shapes$1[node.shape](newEl, node, dir);
  } else {
    el = shapes$1[node.shape](elem, node, dir);
    newEl = el;
  }
  if (node.tooltip) {
    el.attr("title", node.tooltip);
  }
  if (node.class) {
    el.attr("class", "node default " + node.class);
  }
  nodeElems[node.id] = newEl;
  if (node.haveCallback) {
    nodeElems[node.id].attr("class", nodeElems[node.id].attr("class") + " clickable");
  }
  return newEl;
};
const setNodeElem = (elem, node) => {
  nodeElems[node.id] = elem;
};
const clear$a = () => {
  nodeElems = {};
};
const positionNode = (node) => {
  const el = nodeElems[node.id];
  log$1.trace(
    "Transforming node",
    node.diff,
    node,
    "translate(" + (node.x - node.width / 2 - 5) + ", " + node.width / 2 + ")"
  );
  const padding2 = 8;
  const diff = node.diff || 0;
  if (node.clusterNode) {
    el.attr(
      "transform",
      "translate(" + (node.x + diff - node.width / 2) + ", " + (node.y - node.height / 2 - padding2) + ")"
    );
  } else {
    el.attr("transform", "translate(" + node.x + ", " + node.y + ")");
  }
  return diff;
};
const rect = (parent, node) => {
  log$1.trace("Creating subgraph rect for ", node.id, node);
  const shapeSvg = parent.insert("g").attr("class", "cluster" + (node.class ? " " + node.class : "")).attr("id", node.id);
  const rect2 = shapeSvg.insert("rect", ":first-child");
  const label = shapeSvg.insert("g").attr("class", "cluster-label");
  const text = label.node().appendChild(createLabel$1(node.labelText, node.labelStyle, void 0, true));
  let bbox = text.getBBox();
  if (evaluate(getConfig$1().flowchart.htmlLabels)) {
    const div = text.children[0];
    const dv = select(text);
    bbox = div.getBoundingClientRect();
    dv.attr("width", bbox.width);
    dv.attr("height", bbox.height);
  }
  const padding2 = 0 * node.padding;
  const halfPadding = padding2 / 2;
  const width2 = node.width <= bbox.width + padding2 ? bbox.width + padding2 : node.width;
  if (node.width <= bbox.width + padding2) {
    node.diff = (bbox.width - node.width) / 2 - node.padding / 2;
  } else {
    node.diff = -node.padding / 2;
  }
  log$1.trace("Data ", node, JSON.stringify(node));
  rect2.attr("style", node.style).attr("rx", node.rx).attr("ry", node.ry).attr("x", node.x - width2 / 2).attr("y", node.y - node.height / 2 - halfPadding).attr("width", width2).attr("height", node.height + padding2);
  label.attr(
    "transform",
    // This puts the labal on top of the box instead of inside it
    // 'translate(' + (node.x - bbox.width / 2) + ', ' + (node.y - node.height / 2 - bbox.height) + ')'
    "translate(" + (node.x - bbox.width / 2) + ", " + (node.y - node.height / 2) + ")"
  );
  const rectBox = rect2.node().getBBox();
  node.width = rectBox.width;
  node.height = rectBox.height;
  node.intersect = function(point2) {
    return intersectRect$1(node, point2);
  };
  return shapeSvg;
};
const noteGroup = (parent, node) => {
  const shapeSvg = parent.insert("g").attr("class", "note-cluster").attr("id", node.id);
  const rect2 = shapeSvg.insert("rect", ":first-child");
  const padding2 = 0 * node.padding;
  const halfPadding = padding2 / 2;
  rect2.attr("rx", node.rx).attr("ry", node.ry).attr("x", node.x - node.width / 2 - halfPadding).attr("y", node.y - node.height / 2 - halfPadding).attr("width", node.width + padding2).attr("height", node.height + padding2).attr("fill", "none");
  const rectBox = rect2.node().getBBox();
  node.width = rectBox.width;
  node.height = rectBox.height;
  node.intersect = function(point2) {
    return intersectRect$1(node, point2);
  };
  return shapeSvg;
};
const roundedWithTitle = (parent, node) => {
  const shapeSvg = parent.insert("g").attr("class", node.classes).attr("id", node.id);
  const rect2 = shapeSvg.insert("rect", ":first-child");
  const label = shapeSvg.insert("g").attr("class", "cluster-label");
  const innerRect = shapeSvg.append("rect");
  const text = label.node().appendChild(createLabel$1(node.labelText, node.labelStyle, void 0, true));
  let bbox = text.getBBox();
  if (evaluate(getConfig$1().flowchart.htmlLabels)) {
    const div = text.children[0];
    const dv = select(text);
    bbox = div.getBoundingClientRect();
    dv.attr("width", bbox.width);
    dv.attr("height", bbox.height);
  }
  bbox = text.getBBox();
  const padding2 = 0 * node.padding;
  const halfPadding = padding2 / 2;
  const width2 = node.width <= bbox.width + node.padding ? bbox.width + node.padding : node.width;
  if (node.width <= bbox.width + node.padding) {
    node.diff = (bbox.width + node.padding * 0 - node.width) / 2;
  } else {
    node.diff = -node.padding / 2;
  }
  rect2.attr("class", "outer").attr("x", node.x - width2 / 2 - halfPadding).attr("y", node.y - node.height / 2 - halfPadding).attr("width", width2 + padding2).attr("height", node.height + padding2);
  innerRect.attr("class", "inner").attr("x", node.x - width2 / 2 - halfPadding).attr("y", node.y - node.height / 2 - halfPadding + bbox.height - 1).attr("width", width2 + padding2).attr("height", node.height + padding2 - bbox.height - 3);
  label.attr(
    "transform",
    "translate(" + (node.x - bbox.width / 2) + ", " + (node.y - node.height / 2 - node.padding / 3 + (evaluate(getConfig$1().flowchart.htmlLabels) ? 5 : 3)) + ")"
  );
  const rectBox = rect2.node().getBBox();
  node.height = rectBox.height;
  node.intersect = function(point2) {
    return intersectRect$1(node, point2);
  };
  return shapeSvg;
};
const divider = (parent, node) => {
  const shapeSvg = parent.insert("g").attr("class", node.classes).attr("id", node.id);
  const rect2 = shapeSvg.insert("rect", ":first-child");
  const padding2 = 0 * node.padding;
  const halfPadding = padding2 / 2;
  rect2.attr("class", "divider").attr("x", node.x - node.width / 2 - halfPadding).attr("y", node.y - node.height / 2).attr("width", node.width + padding2).attr("height", node.height + padding2);
  const rectBox = rect2.node().getBBox();
  node.width = rectBox.width;
  node.height = rectBox.height;
  node.diff = -node.padding / 2;
  node.intersect = function(point2) {
    return intersectRect$1(node, point2);
  };
  return shapeSvg;
};
const shapes = { rect, roundedWithTitle, noteGroup, divider };
let clusterElems = {};
const insertCluster = (elem, node) => {
  log$1.trace("Inserting cluster");
  const shape = node.shape || "rect";
  clusterElems[node.id] = shapes[shape](elem, node);
};
const clear$9 = () => {
  clusterElems = {};
};
let edgeLabels = {};
let terminalLabels = {};
const clear$8 = () => {
  edgeLabels = {};
  terminalLabels = {};
};
const insertEdgeLabel = (elem, edge) => {
  const labelElement = createLabel$1(edge.label, edge.labelStyle);
  const edgeLabel = elem.insert("g").attr("class", "edgeLabel");
  const label = edgeLabel.insert("g").attr("class", "label");
  label.node().appendChild(labelElement);
  let bbox = labelElement.getBBox();
  if (evaluate(getConfig$1().flowchart.htmlLabels)) {
    const div = labelElement.children[0];
    const dv = select(labelElement);
    bbox = div.getBoundingClientRect();
    dv.attr("width", bbox.width);
    dv.attr("height", bbox.height);
  }
  label.attr("transform", "translate(" + -bbox.width / 2 + ", " + -bbox.height / 2 + ")");
  edgeLabels[edge.id] = edgeLabel;
  edge.width = bbox.width;
  edge.height = bbox.height;
  let fo;
  if (edge.startLabelLeft) {
    const startLabelElement = createLabel$1(edge.startLabelLeft, edge.labelStyle);
    const startEdgeLabelLeft = elem.insert("g").attr("class", "edgeTerminals");
    const inner = startEdgeLabelLeft.insert("g").attr("class", "inner");
    fo = inner.node().appendChild(startLabelElement);
    const slBox = startLabelElement.getBBox();
    inner.attr("transform", "translate(" + -slBox.width / 2 + ", " + -slBox.height / 2 + ")");
    if (!terminalLabels[edge.id]) {
      terminalLabels[edge.id] = {};
    }
    terminalLabels[edge.id].startLeft = startEdgeLabelLeft;
    setTerminalWidth(fo, edge.startLabelLeft);
  }
  if (edge.startLabelRight) {
    const startLabelElement = createLabel$1(edge.startLabelRight, edge.labelStyle);
    const startEdgeLabelRight = elem.insert("g").attr("class", "edgeTerminals");
    const inner = startEdgeLabelRight.insert("g").attr("class", "inner");
    fo = startEdgeLabelRight.node().appendChild(startLabelElement);
    inner.node().appendChild(startLabelElement);
    const slBox = startLabelElement.getBBox();
    inner.attr("transform", "translate(" + -slBox.width / 2 + ", " + -slBox.height / 2 + ")");
    if (!terminalLabels[edge.id]) {
      terminalLabels[edge.id] = {};
    }
    terminalLabels[edge.id].startRight = startEdgeLabelRight;
    setTerminalWidth(fo, edge.startLabelRight);
  }
  if (edge.endLabelLeft) {
    const endLabelElement = createLabel$1(edge.endLabelLeft, edge.labelStyle);
    const endEdgeLabelLeft = elem.insert("g").attr("class", "edgeTerminals");
    const inner = endEdgeLabelLeft.insert("g").attr("class", "inner");
    fo = inner.node().appendChild(endLabelElement);
    const slBox = endLabelElement.getBBox();
    inner.attr("transform", "translate(" + -slBox.width / 2 + ", " + -slBox.height / 2 + ")");
    endEdgeLabelLeft.node().appendChild(endLabelElement);
    if (!terminalLabels[edge.id]) {
      terminalLabels[edge.id] = {};
    }
    terminalLabels[edge.id].endLeft = endEdgeLabelLeft;
    setTerminalWidth(fo, edge.endLabelLeft);
  }
  if (edge.endLabelRight) {
    const endLabelElement = createLabel$1(edge.endLabelRight, edge.labelStyle);
    const endEdgeLabelRight = elem.insert("g").attr("class", "edgeTerminals");
    const inner = endEdgeLabelRight.insert("g").attr("class", "inner");
    fo = inner.node().appendChild(endLabelElement);
    const slBox = endLabelElement.getBBox();
    inner.attr("transform", "translate(" + -slBox.width / 2 + ", " + -slBox.height / 2 + ")");
    endEdgeLabelRight.node().appendChild(endLabelElement);
    if (!terminalLabels[edge.id]) {
      terminalLabels[edge.id] = {};
    }
    terminalLabels[edge.id].endRight = endEdgeLabelRight;
    setTerminalWidth(fo, edge.endLabelRight);
  }
  return labelElement;
};
function setTerminalWidth(fo, value) {
  if (getConfig$1().flowchart.htmlLabels && fo) {
    fo.style.width = value.length * 9 + "px";
    fo.style.height = "12px";
  }
}
const positionEdgeLabel = (edge, paths) => {
  log$1.info("Moving label abc78 ", edge.id, edge.label, edgeLabels[edge.id]);
  let path = paths.updatedPath ? paths.updatedPath : paths.originalPath;
  if (edge.label) {
    const el = edgeLabels[edge.id];
    let x = edge.x;
    let y = edge.y;
    if (path) {
      const pos = utils.calcLabelPosition(path);
      log$1.info(
        "Moving label " + edge.label + " from (",
        x,
        ",",
        y,
        ") to (",
        pos.x,
        ",",
        pos.y,
        ") abc78"
      );
      if (paths.updatedPath) {
        x = pos.x;
        y = pos.y;
      }
    }
    el.attr("transform", "translate(" + x + ", " + y + ")");
  }
  if (edge.startLabelLeft) {
    const el = terminalLabels[edge.id].startLeft;
    let x = edge.x;
    let y = edge.y;
    if (path) {
      const pos = utils.calcTerminalLabelPosition(edge.arrowTypeStart ? 10 : 0, "start_left", path);
      x = pos.x;
      y = pos.y;
    }
    el.attr("transform", "translate(" + x + ", " + y + ")");
  }
  if (edge.startLabelRight) {
    const el = terminalLabels[edge.id].startRight;
    let x = edge.x;
    let y = edge.y;
    if (path) {
      const pos = utils.calcTerminalLabelPosition(
        edge.arrowTypeStart ? 10 : 0,
        "start_right",
        path
      );
      x = pos.x;
      y = pos.y;
    }
    el.attr("transform", "translate(" + x + ", " + y + ")");
  }
  if (edge.endLabelLeft) {
    const el = terminalLabels[edge.id].endLeft;
    let x = edge.x;
    let y = edge.y;
    if (path) {
      const pos = utils.calcTerminalLabelPosition(edge.arrowTypeEnd ? 10 : 0, "end_left", path);
      x = pos.x;
      y = pos.y;
    }
    el.attr("transform", "translate(" + x + ", " + y + ")");
  }
  if (edge.endLabelRight) {
    const el = terminalLabels[edge.id].endRight;
    let x = edge.x;
    let y = edge.y;
    if (path) {
      const pos = utils.calcTerminalLabelPosition(edge.arrowTypeEnd ? 10 : 0, "end_right", path);
      x = pos.x;
      y = pos.y;
    }
    el.attr("transform", "translate(" + x + ", " + y + ")");
  }
};
const outsideNode = (node, point2) => {
  const x = node.x;
  const y = node.y;
  const dx = Math.abs(point2.x - x);
  const dy = Math.abs(point2.y - y);
  const w2 = node.width / 2;
  const h = node.height / 2;
  if (dx >= w2 || dy >= h) {
    return true;
  }
  return false;
};
const intersection = (node, outsidePoint, insidePoint) => {
  log$1.warn(`intersection calc abc89:
  outsidePoint: ${JSON.stringify(outsidePoint)}
  insidePoint : ${JSON.stringify(insidePoint)}
  node        : x:${node.x} y:${node.y} w:${node.width} h:${node.height}`);
  const x = node.x;
  const y = node.y;
  const dx = Math.abs(x - insidePoint.x);
  const w2 = node.width / 2;
  let r = insidePoint.x < outsidePoint.x ? w2 - dx : w2 + dx;
  const h = node.height / 2;
  const Q = Math.abs(outsidePoint.y - insidePoint.y);
  const R = Math.abs(outsidePoint.x - insidePoint.x);
  if (Math.abs(y - outsidePoint.y) * w2 > Math.abs(x - outsidePoint.x) * h) {
    let q = insidePoint.y < outsidePoint.y ? outsidePoint.y - h - y : y - h - outsidePoint.y;
    r = R * q / Q;
    const res = {
      x: insidePoint.x < outsidePoint.x ? insidePoint.x + r : insidePoint.x - R + r,
      y: insidePoint.y < outsidePoint.y ? insidePoint.y + Q - q : insidePoint.y - Q + q
    };
    if (r === 0) {
      res.x = outsidePoint.x;
      res.y = outsidePoint.y;
    }
    if (R === 0) {
      res.x = outsidePoint.x;
    }
    if (Q === 0) {
      res.y = outsidePoint.y;
    }
    log$1.warn(`abc89 topp/bott calc, Q ${Q}, q ${q}, R ${R}, r ${r}`, res);
    return res;
  } else {
    if (insidePoint.x < outsidePoint.x) {
      r = outsidePoint.x - w2 - x;
    } else {
      r = x - w2 - outsidePoint.x;
    }
    let q = Q * r / R;
    let _x = insidePoint.x < outsidePoint.x ? insidePoint.x + R - r : insidePoint.x - R + r;
    let _y = insidePoint.y < outsidePoint.y ? insidePoint.y + q : insidePoint.y - q;
    log$1.warn(`sides calc abc89, Q ${Q}, q ${q}, R ${R}, r ${r}`, { _x, _y });
    if (r === 0) {
      _x = outsidePoint.x;
      _y = outsidePoint.y;
    }
    if (R === 0) {
      _x = outsidePoint.x;
    }
    if (Q === 0) {
      _y = outsidePoint.y;
    }
    return { x: _x, y: _y };
  }
};
const cutPathAtIntersect = (_points, boundryNode) => {
  log$1.warn("abc88 cutPathAtIntersect", _points, boundryNode);
  let points = [];
  let lastPointOutside = _points[0];
  let isInside = false;
  _points.forEach((point2) => {
    log$1.info("abc88 checking point", point2, boundryNode);
    if (!outsideNode(boundryNode, point2) && !isInside) {
      const inter = intersection(boundryNode, lastPointOutside, point2);
      log$1.warn("abc88 inside", point2, lastPointOutside, inter);
      log$1.warn("abc88 intersection", inter);
      let pointPresent = false;
      points.forEach((p) => {
        pointPresent = pointPresent || p.x === inter.x && p.y === inter.y;
      });
      if (!points.some((e) => e.x === inter.x && e.y === inter.y)) {
        points.push(inter);
      } else {
        log$1.warn("abc88 no intersect", inter, points);
      }
      isInside = true;
    } else {
      log$1.warn("abc88 outside", point2, lastPointOutside);
      lastPointOutside = point2;
      if (!isInside) {
        points.push(point2);
      }
    }
  });
  log$1.warn("abc88 returning points", points);
  return points;
};
const insertEdge = function(elem, e, edge, clusterDb2, diagramType, graph) {
  let points = edge.points;
  let pointsHasChanged = false;
  const tail = graph.node(e.v);
  var head2 = graph.node(e.w);
  log$1.info("abc88 InsertEdge: ", edge);
  if (head2.intersect && tail.intersect) {
    points = points.slice(1, edge.points.length - 1);
    points.unshift(tail.intersect(points[0]));
    log$1.info(
      "Last point",
      points[points.length - 1],
      head2,
      head2.intersect(points[points.length - 1])
    );
    points.push(head2.intersect(points[points.length - 1]));
  }
  if (edge.toCluster) {
    log$1.info("to cluster abc88", clusterDb2[edge.toCluster]);
    points = cutPathAtIntersect(edge.points, clusterDb2[edge.toCluster].node);
    pointsHasChanged = true;
  }
  if (edge.fromCluster) {
    log$1.info("from cluster abc88", clusterDb2[edge.fromCluster]);
    points = cutPathAtIntersect(points.reverse(), clusterDb2[edge.fromCluster].node).reverse();
    pointsHasChanged = true;
  }
  const lineData = points.filter((p) => !Number.isNaN(p.y));
  let curve;
  if (diagramType === "graph" || diagramType === "flowchart") {
    curve = edge.curve || curveBasis;
  } else {
    curve = curveBasis;
  }
  const lineFunction = line().x(function(d) {
    return d.x;
  }).y(function(d) {
    return d.y;
  }).curve(curve);
  let strokeClasses;
  switch (edge.thickness) {
    case "normal":
      strokeClasses = "edge-thickness-normal";
      break;
    case "thick":
      strokeClasses = "edge-thickness-thick";
      break;
    default:
      strokeClasses = "";
  }
  switch (edge.pattern) {
    case "solid":
      strokeClasses += " edge-pattern-solid";
      break;
    case "dotted":
      strokeClasses += " edge-pattern-dotted";
      break;
    case "dashed":
      strokeClasses += " edge-pattern-dashed";
      break;
  }
  const svgPath = elem.append("path").attr("d", lineFunction(lineData)).attr("id", edge.id).attr("class", " " + strokeClasses + (edge.classes ? " " + edge.classes : "")).attr("style", edge.style);
  let url = "";
  if (getConfig$1().flowchart.arrowMarkerAbsolute || getConfig$1().state.arrowMarkerAbsolute) {
    url = window.location.protocol + "//" + window.location.host + window.location.pathname + window.location.search;
    url = url.replace(/\(/g, "\\(");
    url = url.replace(/\)/g, "\\)");
  }
  log$1.info("arrowTypeStart", edge.arrowTypeStart);
  log$1.info("arrowTypeEnd", edge.arrowTypeEnd);
  switch (edge.arrowTypeStart) {
    case "arrow_cross":
      svgPath.attr("marker-start", "url(" + url + "#" + diagramType + "-crossStart)");
      break;
    case "arrow_point":
      svgPath.attr("marker-start", "url(" + url + "#" + diagramType + "-pointStart)");
      break;
    case "arrow_barb":
      svgPath.attr("marker-start", "url(" + url + "#" + diagramType + "-barbStart)");
      break;
    case "arrow_circle":
      svgPath.attr("marker-start", "url(" + url + "#" + diagramType + "-circleStart)");
      break;
    case "aggregation":
      svgPath.attr("marker-start", "url(" + url + "#" + diagramType + "-aggregationStart)");
      break;
    case "extension":
      svgPath.attr("marker-start", "url(" + url + "#" + diagramType + "-extensionStart)");
      break;
    case "composition":
      svgPath.attr("marker-start", "url(" + url + "#" + diagramType + "-compositionStart)");
      break;
    case "dependency":
      svgPath.attr("marker-start", "url(" + url + "#" + diagramType + "-dependencyStart)");
      break;
    case "lollipop":
      svgPath.attr("marker-start", "url(" + url + "#" + diagramType + "-lollipopStart)");
      break;
  }
  switch (edge.arrowTypeEnd) {
    case "arrow_cross":
      svgPath.attr("marker-end", "url(" + url + "#" + diagramType + "-crossEnd)");
      break;
    case "arrow_point":
      svgPath.attr("marker-end", "url(" + url + "#" + diagramType + "-pointEnd)");
      break;
    case "arrow_barb":
      svgPath.attr("marker-end", "url(" + url + "#" + diagramType + "-barbEnd)");
      break;
    case "arrow_circle":
      svgPath.attr("marker-end", "url(" + url + "#" + diagramType + "-circleEnd)");
      break;
    case "aggregation":
      svgPath.attr("marker-end", "url(" + url + "#" + diagramType + "-aggregationEnd)");
      break;
    case "extension":
      svgPath.attr("marker-end", "url(" + url + "#" + diagramType + "-extensionEnd)");
      break;
    case "composition":
      svgPath.attr("marker-end", "url(" + url + "#" + diagramType + "-compositionEnd)");
      break;
    case "dependency":
      svgPath.attr("marker-end", "url(" + url + "#" + diagramType + "-dependencyEnd)");
      break;
    case "lollipop":
      svgPath.attr("marker-end", "url(" + url + "#" + diagramType + "-lollipopEnd)");
      break;
  }
  let paths = {};
  if (pointsHasChanged) {
    paths.updatedPath = points;
  }
  paths.originalPath = edge.points;
  return paths;
};
const recursiveRender = (_elem, graph, diagramtype, parentCluster) => {
  log$1.info("Graph in recursive render: XXX", graphlibJson.write(graph), parentCluster);
  const dir = graph.graph().rankdir;
  log$1.trace("Dir in recursive render - dir:", dir);
  const elem = _elem.insert("g").attr("class", "root");
  if (!graph.nodes()) {
    log$1.info("No nodes found for", graph);
  } else {
    log$1.info("Recursive render XXX", graph.nodes());
  }
  if (graph.edges().length > 0) {
    log$1.trace("Recursive edges", graph.edge(graph.edges()[0]));
  }
  const clusters = elem.insert("g").attr("class", "clusters");
  const edgePaths = elem.insert("g").attr("class", "edgePaths");
  const edgeLabels2 = elem.insert("g").attr("class", "edgeLabels");
  const nodes = elem.insert("g").attr("class", "nodes");
  graph.nodes().forEach(function(v) {
    const node = graph.node(v);
    if (parentCluster !== void 0) {
      const data = JSON.parse(JSON.stringify(parentCluster.clusterData));
      log$1.info("Setting data for cluster XXX (", v, ") ", data, parentCluster);
      graph.setNode(parentCluster.id, data);
      if (!graph.parent(v)) {
        log$1.trace("Setting parent", v, parentCluster.id);
        graph.setParent(v, parentCluster.id, data);
      }
    }
    log$1.info("(Insert) Node XXX" + v + ": " + JSON.stringify(graph.node(v)));
    if (node && node.clusterNode) {
      log$1.info("Cluster identified", v, node.width, graph.node(v));
      const o = recursiveRender(nodes, node.graph, diagramtype, graph.node(v));
      const newEl = o.elem;
      updateNodeBounds(node, newEl);
      node.diff = o.diff || 0;
      log$1.info("Node bounds (abc123)", v, node, node.width, node.x, node.y);
      setNodeElem(newEl, node);
      log$1.warn("Recursive render complete ", newEl, node);
    } else {
      if (graph.children(v).length > 0) {
        log$1.info("Cluster - the non recursive path XXX", v, node.id, node, graph);
        log$1.info(findNonClusterChild(node.id, graph));
        clusterDb[node.id] = { id: findNonClusterChild(node.id, graph), node };
      } else {
        log$1.info("Node - the non recursive path", v, node.id, node);
        insertNode(nodes, graph.node(v), dir);
      }
    }
  });
  graph.edges().forEach(function(e) {
    const edge = graph.edge(e.v, e.w, e.name);
    log$1.info("Edge " + e.v + " -> " + e.w + ": " + JSON.stringify(e));
    log$1.info("Edge " + e.v + " -> " + e.w + ": ", e, " ", JSON.stringify(graph.edge(e)));
    log$1.info("Fix", clusterDb, "ids:", e.v, e.w, "Translateing: ", clusterDb[e.v], clusterDb[e.w]);
    insertEdgeLabel(edgeLabels2, edge);
  });
  graph.edges().forEach(function(e) {
    log$1.info("Edge " + e.v + " -> " + e.w + ": " + JSON.stringify(e));
  });
  log$1.info("#############################################");
  log$1.info("###                Layout                 ###");
  log$1.info("#############################################");
  log$1.info(graph);
  layout(graph);
  log$1.info("Graph after layout:", graphlibJson.write(graph));
  let diff = 0;
  sortNodesByHierarchy(graph).forEach(function(v) {
    const node = graph.node(v);
    log$1.info("Position " + v + ": " + JSON.stringify(graph.node(v)));
    log$1.info(
      "Position " + v + ": (" + node.x,
      "," + node.y,
      ") width: ",
      node.width,
      " height: ",
      node.height
    );
    if (node && node.clusterNode) {
      positionNode(node);
    } else {
      if (graph.children(v).length > 0) {
        insertCluster(clusters, node);
        clusterDb[node.id].node = node;
      } else {
        positionNode(node);
      }
    }
  });
  graph.edges().forEach(function(e) {
    const edge = graph.edge(e);
    log$1.info("Edge " + e.v + " -> " + e.w + ": " + JSON.stringify(edge), edge);
    const paths = insertEdge(edgePaths, e, edge, clusterDb, diagramtype, graph);
    positionEdgeLabel(edge, paths);
  });
  graph.nodes().forEach(function(v) {
    const n = graph.node(v);
    log$1.info(v, n.type, n.diff);
    if (n.type === "group") {
      diff = n.diff;
    }
  });
  return { elem, diff };
};
const render$1 = (elem, graph, markers2, diagramtype, id2) => {
  insertMarkers$3(elem, markers2, diagramtype, id2);
  clear$a();
  clear$8();
  clear$9();
  clear$b();
  log$1.warn("Graph at first:", graphlibJson.write(graph));
  adjustClustersAndEdges(graph);
  log$1.warn("Graph after:", graphlibJson.write(graph));
  recursiveRender(elem, graph, diagramtype);
};
const sanitizeText$1 = (txt) => common$1.sanitizeText(txt, getConfig$1());
let conf$9 = {
  dividerMargin: 10,
  padding: 5,
  textHeight: 10
};
const addClasses = function(classes2, g, _id, diagObj) {
  const keys2 = Object.keys(classes2);
  log$1.info("keys:", keys2);
  log$1.info(classes2);
  keys2.forEach(function(id2) {
    const vertex = classes2[id2];
    let cssClassStr = "";
    if (vertex.cssClasses.length > 0) {
      cssClassStr = cssClassStr + " " + vertex.cssClasses.join(" ");
    }
    const styles = { labelStyle: "" };
    let vertexText = vertex.text !== void 0 ? vertex.text : vertex.id;
    let radious = 0;
    let _shape = "";
    switch (vertex.type) {
      case "class":
        _shape = "class_box";
        break;
      default:
        _shape = "class_box";
    }
    g.setNode(vertex.id, {
      labelStyle: styles.labelStyle,
      shape: _shape,
      labelText: sanitizeText$1(vertexText),
      classData: vertex,
      rx: radious,
      ry: radious,
      class: cssClassStr,
      style: styles.style,
      id: vertex.id,
      domId: vertex.domId,
      tooltip: diagObj.db.getTooltip(vertex.id) || "",
      haveCallback: vertex.haveCallback,
      link: vertex.link,
      width: vertex.type === "group" ? 500 : void 0,
      type: vertex.type,
      padding: getConfig$1().flowchart.padding
    });
    log$1.info("setNode", {
      labelStyle: styles.labelStyle,
      shape: _shape,
      labelText: vertexText,
      rx: radious,
      ry: radious,
      class: cssClassStr,
      style: styles.style,
      id: vertex.id,
      width: vertex.type === "group" ? 500 : void 0,
      type: vertex.type,
      padding: getConfig$1().flowchart.padding
    });
  });
};
const addNotes = function(notes2, g, startEdgeId, classes2) {
  log$1.info(notes2);
  notes2.forEach(function(note2, i) {
    const vertex = note2;
    let cssNoteStr = "";
    const styles = { labelStyle: "", style: "" };
    let vertexText = vertex.text;
    let radious = 0;
    let _shape = "note";
    g.setNode(vertex.id, {
      labelStyle: styles.labelStyle,
      shape: _shape,
      labelText: sanitizeText$1(vertexText),
      noteData: vertex,
      rx: radious,
      ry: radious,
      class: cssNoteStr,
      style: styles.style,
      id: vertex.id,
      domId: vertex.id,
      tooltip: "",
      type: "note",
      padding: getConfig$1().flowchart.padding
    });
    log$1.info("setNode", {
      labelStyle: styles.labelStyle,
      shape: _shape,
      labelText: vertexText,
      rx: radious,
      ry: radious,
      style: styles.style,
      id: vertex.id,
      type: "note",
      padding: getConfig$1().flowchart.padding
    });
    if (!vertex.class || !(vertex.class in classes2)) {
      return;
    }
    const edgeId = startEdgeId + i;
    const edgeData = {};
    edgeData.classes = "relation";
    edgeData.pattern = "dotted";
    edgeData.id = `edgeNote${edgeId}`;
    edgeData.arrowhead = "none";
    log$1.info(`Note edge: ${JSON.stringify(edgeData)}, ${JSON.stringify(vertex)}`);
    edgeData.startLabelRight = "";
    edgeData.endLabelLeft = "";
    edgeData.arrowTypeStart = "none";
    edgeData.arrowTypeEnd = "none";
    let style = "fill:none";
    let labelStyle = "";
    edgeData.style = style;
    edgeData.labelStyle = labelStyle;
    edgeData.curve = interpolateToCurve(conf$9.curve, curveLinear);
    g.setEdge(vertex.id, vertex.class, edgeData, edgeId);
  });
};
const addRelations = function(relations2, g) {
  const conf2 = getConfig$1().flowchart;
  let cnt2 = 0;
  relations2.forEach(function(edge) {
    cnt2++;
    const edgeData = {};
    edgeData.classes = "relation";
    edgeData.pattern = edge.relation.lineType == 1 ? "dashed" : "solid";
    edgeData.id = "id" + cnt2;
    if (edge.type === "arrow_open") {
      edgeData.arrowhead = "none";
    } else {
      edgeData.arrowhead = "normal";
    }
    log$1.info(edgeData, edge);
    edgeData.startLabelRight = edge.relationTitle1 === "none" ? "" : edge.relationTitle1;
    edgeData.endLabelLeft = edge.relationTitle2 === "none" ? "" : edge.relationTitle2;
    edgeData.arrowTypeStart = getArrowMarker(edge.relation.type1);
    edgeData.arrowTypeEnd = getArrowMarker(edge.relation.type2);
    let style = "";
    let labelStyle = "";
    if (edge.style !== void 0) {
      const styles = getStylesFromArray(edge.style);
      style = styles.style;
      labelStyle = styles.labelStyle;
    } else {
      style = "fill:none";
    }
    edgeData.style = style;
    edgeData.labelStyle = labelStyle;
    if (edge.interpolate !== void 0) {
      edgeData.curve = interpolateToCurve(edge.interpolate, curveLinear);
    } else if (relations2.defaultInterpolate !== void 0) {
      edgeData.curve = interpolateToCurve(relations2.defaultInterpolate, curveLinear);
    } else {
      edgeData.curve = interpolateToCurve(conf2.curve, curveLinear);
    }
    edge.text = edge.title;
    if (edge.text === void 0) {
      if (edge.style !== void 0) {
        edgeData.arrowheadStyle = "fill: #333";
      }
    } else {
      edgeData.arrowheadStyle = "fill: #333";
      edgeData.labelpos = "c";
      if (getConfig$1().flowchart.htmlLabels) {
        edgeData.labelType = "html";
        edgeData.label = '<span class="edgeLabel">' + edge.text + "</span>";
      } else {
        edgeData.labelType = "text";
        edgeData.label = edge.text.replace(common$1.lineBreakRegex, "\n");
        if (edge.style === void 0) {
          edgeData.style = edgeData.style || "stroke: #333; stroke-width: 1.5px;fill:none";
        }
        edgeData.labelStyle = edgeData.labelStyle.replace("color:", "fill:");
      }
    }
    g.setEdge(edge.id1, edge.id2, edgeData, cnt2);
  });
};
const setConf$9 = function(cnf) {
  const keys2 = Object.keys(cnf);
  keys2.forEach(function(key) {
    conf$9[key] = cnf[key];
  });
};
const draw$c = function(text, id2, _version, diagObj) {
  log$1.info("Drawing class - ", id2);
  const conf2 = getConfig$1().flowchart;
  const securityLevel = getConfig$1().securityLevel;
  log$1.info("config:", conf2);
  const nodeSpacing = conf2.nodeSpacing || 50;
  const rankSpacing = conf2.rankSpacing || 50;
  const g = new graphlib.Graph({
    multigraph: true,
    compound: true
  }).setGraph({
    rankdir: diagObj.db.getDirection(),
    nodesep: nodeSpacing,
    ranksep: rankSpacing,
    marginx: 8,
    marginy: 8
  }).setDefaultEdgeLabel(function() {
    return {};
  });
  const classes2 = diagObj.db.getClasses();
  const relations2 = diagObj.db.getRelations();
  const notes2 = diagObj.db.getNotes();
  log$1.info(relations2);
  addClasses(classes2, g, id2, diagObj);
  addRelations(relations2, g);
  addNotes(notes2, g, relations2.length + 1, classes2);
  let sandboxElement;
  if (securityLevel === "sandbox") {
    sandboxElement = select("#i" + id2);
  }
  const root = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
  const svg = root.select(`[id="${id2}"]`);
  const element = root.select("#" + id2 + " g");
  render$1(
    element,
    g,
    ["aggregation", "extension", "composition", "dependency", "lollipop"],
    "classDiagram",
    id2
  );
  utils.insertTitle(svg, "classTitleText", conf2.titleTopMargin, diagObj.db.getDiagramTitle());
  setupGraphViewbox$1(g, svg, conf2.diagramPadding, conf2.useMaxWidth);
  if (!conf2.htmlLabels) {
    const doc = securityLevel === "sandbox" ? sandboxElement.nodes()[0].contentDocument : document;
    const labels = doc.querySelectorAll('[id="' + id2 + '"] .edgeLabel .label');
    for (const label of labels) {
      const dim = label.getBBox();
      const rect2 = doc.createElementNS("http://www.w3.org/2000/svg", "rect");
      rect2.setAttribute("rx", 0);
      rect2.setAttribute("ry", 0);
      rect2.setAttribute("width", dim.width);
      rect2.setAttribute("height", dim.height);
      label.insertBefore(rect2, label.firstChild);
    }
  }
};
function getArrowMarker(type2) {
  let marker;
  switch (type2) {
    case 0:
      marker = "aggregation";
      break;
    case 1:
      marker = "extension";
      break;
    case 2:
      marker = "composition";
      break;
    case 3:
      marker = "dependency";
      break;
    case 4:
      marker = "lollipop";
      break;
    default:
      marker = "none";
  }
  return marker;
}
const classRendererV2 = {
  setConf: setConf$9,
  draw: draw$c
};
var parser$9 = function() {
  var o = function(k, v, o2, l) {
    for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
      ;
    return o2;
  }, $V0 = [1, 2], $V1 = [1, 5], $V2 = [6, 9, 11, 23, 25, 27, 29, 30, 31, 51], $V3 = [1, 17], $V4 = [1, 18], $V5 = [1, 19], $V6 = [1, 20], $V7 = [1, 21], $V8 = [1, 22], $V9 = [1, 25], $Va = [1, 30], $Vb = [1, 31], $Vc = [1, 32], $Vd = [1, 33], $Ve = [6, 9, 11, 15, 20, 23, 25, 27, 29, 30, 31, 44, 45, 46, 47, 51], $Vf = [1, 45], $Vg = [30, 31, 48, 49], $Vh = [4, 6, 9, 11, 23, 25, 27, 29, 30, 31, 51], $Vi = [44, 45, 46, 47], $Vj = [22, 37], $Vk = [1, 65], $Vl = [1, 64], $Vm = [22, 37, 39, 41];
  var parser2 = {
    trace: function trace() {
    },
    yy: {},
    symbols_: { "error": 2, "start": 3, "ER_DIAGRAM": 4, "document": 5, "EOF": 6, "directive": 7, "line": 8, "SPACE": 9, "statement": 10, "NEWLINE": 11, "openDirective": 12, "typeDirective": 13, "closeDirective": 14, ":": 15, "argDirective": 16, "entityName": 17, "relSpec": 18, "role": 19, "BLOCK_START": 20, "attributes": 21, "BLOCK_STOP": 22, "title": 23, "title_value": 24, "acc_title": 25, "acc_title_value": 26, "acc_descr": 27, "acc_descr_value": 28, "acc_descr_multiline_value": 29, "ALPHANUM": 30, "ENTITY_NAME": 31, "attribute": 32, "attributeType": 33, "attributeName": 34, "attributeKeyTypeList": 35, "attributeComment": 36, "ATTRIBUTE_WORD": 37, "attributeKeyType": 38, "COMMA": 39, "ATTRIBUTE_KEY": 40, "COMMENT": 41, "cardinality": 42, "relType": 43, "ZERO_OR_ONE": 44, "ZERO_OR_MORE": 45, "ONE_OR_MORE": 46, "ONLY_ONE": 47, "NON_IDENTIFYING": 48, "IDENTIFYING": 49, "WORD": 50, "open_directive": 51, "type_directive": 52, "arg_directive": 53, "close_directive": 54, "$accept": 0, "$end": 1 },
    terminals_: { 2: "error", 4: "ER_DIAGRAM", 6: "EOF", 9: "SPACE", 11: "NEWLINE", 15: ":", 20: "BLOCK_START", 22: "BLOCK_STOP", 23: "title", 24: "title_value", 25: "acc_title", 26: "acc_title_value", 27: "acc_descr", 28: "acc_descr_value", 29: "acc_descr_multiline_value", 30: "ALPHANUM", 31: "ENTITY_NAME", 37: "ATTRIBUTE_WORD", 39: "COMMA", 40: "ATTRIBUTE_KEY", 41: "COMMENT", 44: "ZERO_OR_ONE", 45: "ZERO_OR_MORE", 46: "ONE_OR_MORE", 47: "ONLY_ONE", 48: "NON_IDENTIFYING", 49: "IDENTIFYING", 50: "WORD", 51: "open_directive", 52: "type_directive", 53: "arg_directive", 54: "close_directive" },
    productions_: [0, [3, 3], [3, 2], [5, 0], [5, 2], [8, 2], [8, 1], [8, 1], [8, 1], [7, 4], [7, 6], [10, 1], [10, 5], [10, 4], [10, 3], [10, 1], [10, 2], [10, 2], [10, 2], [10, 1], [17, 1], [17, 1], [21, 1], [21, 2], [32, 2], [32, 3], [32, 3], [32, 4], [33, 1], [34, 1], [35, 1], [35, 3], [38, 1], [36, 1], [18, 3], [42, 1], [42, 1], [42, 1], [42, 1], [43, 1], [43, 1], [19, 1], [19, 1], [19, 1], [12, 1], [13, 1], [16, 1], [14, 1]],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
      var $0 = $$.length - 1;
      switch (yystate) {
        case 1:
          break;
        case 3:
          this.$ = [];
          break;
        case 4:
          $$[$0 - 1].push($$[$0]);
          this.$ = $$[$0 - 1];
          break;
        case 5:
        case 6:
          this.$ = $$[$0];
          break;
        case 7:
        case 8:
          this.$ = [];
          break;
        case 12:
          yy.addEntity($$[$0 - 4]);
          yy.addEntity($$[$0 - 2]);
          yy.addRelationship($$[$0 - 4], $$[$0], $$[$0 - 2], $$[$0 - 3]);
          break;
        case 13:
          yy.addEntity($$[$0 - 3]);
          yy.addAttributes($$[$0 - 3], $$[$0 - 1]);
          break;
        case 14:
          yy.addEntity($$[$0 - 2]);
          break;
        case 15:
          yy.addEntity($$[$0]);
          break;
        case 16:
        case 17:
          this.$ = $$[$0].trim();
          yy.setAccTitle(this.$);
          break;
        case 18:
        case 19:
          this.$ = $$[$0].trim();
          yy.setAccDescription(this.$);
          break;
        case 20:
        case 43:
          this.$ = $$[$0];
          break;
        case 21:
        case 41:
        case 42:
          this.$ = $$[$0].replace(/"/g, "");
          break;
        case 22:
        case 30:
          this.$ = [$$[$0]];
          break;
        case 23:
          $$[$0].push($$[$0 - 1]);
          this.$ = $$[$0];
          break;
        case 24:
          this.$ = { attributeType: $$[$0 - 1], attributeName: $$[$0] };
          break;
        case 25:
          this.$ = { attributeType: $$[$0 - 2], attributeName: $$[$0 - 1], attributeKeyTypeList: $$[$0] };
          break;
        case 26:
          this.$ = { attributeType: $$[$0 - 2], attributeName: $$[$0 - 1], attributeComment: $$[$0] };
          break;
        case 27:
          this.$ = { attributeType: $$[$0 - 3], attributeName: $$[$0 - 2], attributeKeyTypeList: $$[$0 - 1], attributeComment: $$[$0] };
          break;
        case 28:
        case 29:
        case 32:
          this.$ = $$[$0];
          break;
        case 31:
          $$[$0 - 2].push($$[$0]);
          this.$ = $$[$0 - 2];
          break;
        case 33:
          this.$ = $$[$0].replace(/"/g, "");
          break;
        case 34:
          this.$ = { cardA: $$[$0], relType: $$[$0 - 1], cardB: $$[$0 - 2] };
          break;
        case 35:
          this.$ = yy.Cardinality.ZERO_OR_ONE;
          break;
        case 36:
          this.$ = yy.Cardinality.ZERO_OR_MORE;
          break;
        case 37:
          this.$ = yy.Cardinality.ONE_OR_MORE;
          break;
        case 38:
          this.$ = yy.Cardinality.ONLY_ONE;
          break;
        case 39:
          this.$ = yy.Identification.NON_IDENTIFYING;
          break;
        case 40:
          this.$ = yy.Identification.IDENTIFYING;
          break;
        case 44:
          yy.parseDirective("%%{", "open_directive");
          break;
        case 45:
          yy.parseDirective($$[$0], "type_directive");
          break;
        case 46:
          $$[$0] = $$[$0].trim().replace(/'/g, '"');
          yy.parseDirective($$[$0], "arg_directive");
          break;
        case 47:
          yy.parseDirective("}%%", "close_directive", "er");
          break;
      }
    },
    table: [{ 3: 1, 4: $V0, 7: 3, 12: 4, 51: $V1 }, { 1: [3] }, o($V2, [2, 3], { 5: 6 }), { 3: 7, 4: $V0, 7: 3, 12: 4, 51: $V1 }, { 13: 8, 52: [1, 9] }, { 52: [2, 44] }, { 6: [1, 10], 7: 15, 8: 11, 9: [1, 12], 10: 13, 11: [1, 14], 12: 4, 17: 16, 23: $V3, 25: $V4, 27: $V5, 29: $V6, 30: $V7, 31: $V8, 51: $V1 }, { 1: [2, 2] }, { 14: 23, 15: [1, 24], 54: $V9 }, o([15, 54], [2, 45]), o($V2, [2, 8], { 1: [2, 1] }), o($V2, [2, 4]), { 7: 15, 10: 26, 12: 4, 17: 16, 23: $V3, 25: $V4, 27: $V5, 29: $V6, 30: $V7, 31: $V8, 51: $V1 }, o($V2, [2, 6]), o($V2, [2, 7]), o($V2, [2, 11]), o($V2, [2, 15], { 18: 27, 42: 29, 20: [1, 28], 44: $Va, 45: $Vb, 46: $Vc, 47: $Vd }), { 24: [1, 34] }, { 26: [1, 35] }, { 28: [1, 36] }, o($V2, [2, 19]), o($Ve, [2, 20]), o($Ve, [2, 21]), { 11: [1, 37] }, { 16: 38, 53: [1, 39] }, { 11: [2, 47] }, o($V2, [2, 5]), { 17: 40, 30: $V7, 31: $V8 }, { 21: 41, 22: [1, 42], 32: 43, 33: 44, 37: $Vf }, { 43: 46, 48: [1, 47], 49: [1, 48] }, o($Vg, [2, 35]), o($Vg, [2, 36]), o($Vg, [2, 37]), o($Vg, [2, 38]), o($V2, [2, 16]), o($V2, [2, 17]), o($V2, [2, 18]), o($Vh, [2, 9]), { 14: 49, 54: $V9 }, { 54: [2, 46] }, { 15: [1, 50] }, { 22: [1, 51] }, o($V2, [2, 14]), { 21: 52, 22: [2, 22], 32: 43, 33: 44, 37: $Vf }, { 34: 53, 37: [1, 54] }, { 37: [2, 28] }, { 42: 55, 44: $Va, 45: $Vb, 46: $Vc, 47: $Vd }, o($Vi, [2, 39]), o($Vi, [2, 40]), { 11: [1, 56] }, { 19: 57, 30: [1, 60], 31: [1, 59], 50: [1, 58] }, o($V2, [2, 13]), { 22: [2, 23] }, o($Vj, [2, 24], { 35: 61, 36: 62, 38: 63, 40: $Vk, 41: $Vl }), o([22, 37, 40, 41], [2, 29]), o([30, 31], [2, 34]), o($Vh, [2, 10]), o($V2, [2, 12]), o($V2, [2, 41]), o($V2, [2, 42]), o($V2, [2, 43]), o($Vj, [2, 25], { 36: 66, 39: [1, 67], 41: $Vl }), o($Vj, [2, 26]), o($Vm, [2, 30]), o($Vj, [2, 33]), o($Vm, [2, 32]), o($Vj, [2, 27]), { 38: 68, 40: $Vk }, o($Vm, [2, 31])],
    defaultActions: { 5: [2, 44], 7: [2, 2], 25: [2, 47], 39: [2, 46], 45: [2, 28], 52: [2, 23] },
    parseError: function parseError(str2, hash) {
      if (hash.recoverable) {
        this.trace(str2);
      } else {
        var error = new Error(str2);
        error.hash = hash;
        throw error;
      }
    },
    parse: function parse2(input) {
      var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
      var args = lstack.slice.call(arguments, 1);
      var lexer2 = Object.create(this.lexer);
      var sharedState = { yy: {} };
      for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
          sharedState.yy[k] = this.yy[k];
        }
      }
      lexer2.setInput(input, sharedState.yy);
      sharedState.yy.lexer = lexer2;
      sharedState.yy.parser = this;
      if (typeof lexer2.yylloc == "undefined") {
        lexer2.yylloc = {};
      }
      var yyloc = lexer2.yylloc;
      lstack.push(yyloc);
      var ranges = lexer2.options && lexer2.options.ranges;
      if (typeof sharedState.yy.parseError === "function") {
        this.parseError = sharedState.yy.parseError;
      } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
      }
      function lex2() {
        var token;
        token = tstack.pop() || lexer2.lex() || EOF;
        if (typeof token !== "number") {
          if (token instanceof Array) {
            tstack = token;
            token = tstack.pop();
          }
          token = self.symbols_[token] || token;
        }
        return token;
      }
      var symbol, state, action, r, yyval = {}, p, len, newState, expected;
      while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
          action = this.defaultActions[state];
        } else {
          if (symbol === null || typeof symbol == "undefined") {
            symbol = lex2();
          }
          action = table[state] && table[state][symbol];
        }
        if (typeof action === "undefined" || !action.length || !action[0]) {
          var errStr = "";
          expected = [];
          for (p in table[state]) {
            if (this.terminals_[p] && p > TERROR) {
              expected.push("'" + this.terminals_[p] + "'");
            }
          }
          if (lexer2.showPosition) {
            errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
          } else {
            errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
          }
          this.parseError(errStr, {
            text: lexer2.match,
            token: this.terminals_[symbol] || symbol,
            line: lexer2.yylineno,
            loc: yyloc,
            expected
          });
        }
        if (action[0] instanceof Array && action.length > 1) {
          throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
        }
        switch (action[0]) {
          case 1:
            stack.push(symbol);
            vstack.push(lexer2.yytext);
            lstack.push(lexer2.yylloc);
            stack.push(action[1]);
            symbol = null;
            {
              yyleng = lexer2.yyleng;
              yytext = lexer2.yytext;
              yylineno = lexer2.yylineno;
              yyloc = lexer2.yylloc;
            }
            break;
          case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
              first_line: lstack[lstack.length - (len || 1)].first_line,
              last_line: lstack[lstack.length - 1].last_line,
              first_column: lstack[lstack.length - (len || 1)].first_column,
              last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
              yyval._$.range = [
                lstack[lstack.length - (len || 1)].range[0],
                lstack[lstack.length - 1].range[1]
              ];
            }
            r = this.performAction.apply(yyval, [
              yytext,
              yyleng,
              yylineno,
              sharedState.yy,
              action[1],
              vstack,
              lstack
            ].concat(args));
            if (typeof r !== "undefined") {
              return r;
            }
            if (len) {
              stack = stack.slice(0, -1 * len * 2);
              vstack = vstack.slice(0, -1 * len);
              lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
          case 3:
            return true;
        }
      }
      return true;
    }
  };
  var lexer = function() {
    var lexer2 = {
      EOF: 1,
      parseError: function parseError(str2, hash) {
        if (this.yy.parser) {
          this.yy.parser.parseError(str2, hash);
        } else {
          throw new Error(str2);
        }
      },
      // resets the lexer, sets new input
      setInput: function(input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = "";
        this.conditionStack = ["INITIAL"];
        this.yylloc = {
          first_line: 1,
          first_column: 0,
          last_line: 1,
          last_column: 0
        };
        if (this.options.ranges) {
          this.yylloc.range = [0, 0];
        }
        this.offset = 0;
        return this;
      },
      // consumes and returns one char from the input
      input: function() {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno++;
          this.yylloc.last_line++;
        } else {
          this.yylloc.last_column++;
        }
        if (this.options.ranges) {
          this.yylloc.range[1]++;
        }
        this._input = this._input.slice(1);
        return ch;
      },
      // unshifts one char (or a string) into the input
      unput: function(ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);
        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);
        if (lines.length - 1) {
          this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;
        this.yylloc = {
          first_line: this.yylloc.first_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.first_column,
          last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
        };
        if (this.options.ranges) {
          this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
      },
      // When called from action, caches matched text and appends it on next action
      more: function() {
        this._more = true;
        return this;
      },
      // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
      reject: function() {
        if (this.options.backtrack_lexer) {
          this._backtrack = true;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
        return this;
      },
      // retain first n characters of the match
      less: function(n) {
        this.unput(this.match.slice(n));
      },
      // displays already matched input, i.e. for error messages
      pastInput: function() {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
      },
      // displays upcoming input, i.e. for error messages
      upcomingInput: function() {
        var next = this.match;
        if (next.length < 20) {
          next += this._input.substr(0, 20 - next.length);
        }
        return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
      },
      // displays the character position where the lexing error occurred, i.e. for error messages
      showPosition: function() {
        var pre = this.pastInput();
        var c2 = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c2 + "^";
      },
      // test the lexed token: return FALSE when not a match, otherwise return token
      test_match: function(match, indexed_rule) {
        var token, lines, backup;
        if (this.options.backtrack_lexer) {
          backup = {
            yylineno: this.yylineno,
            yylloc: {
              first_line: this.yylloc.first_line,
              last_line: this.last_line,
              first_column: this.yylloc.first_column,
              last_column: this.yylloc.last_column
            },
            yytext: this.yytext,
            match: this.match,
            matches: this.matches,
            matched: this.matched,
            yyleng: this.yyleng,
            offset: this.offset,
            _more: this._more,
            _input: this._input,
            yy: this.yy,
            conditionStack: this.conditionStack.slice(0),
            done: this.done
          };
          if (this.options.ranges) {
            backup.yylloc.range = this.yylloc.range.slice(0);
          }
        }
        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno += lines.length;
        }
        this.yylloc = {
          first_line: this.yylloc.last_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.last_column,
          last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
          this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
          this.done = false;
        }
        if (token) {
          return token;
        } else if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
        return false;
      },
      // return next match in input
      next: function() {
        if (this.done) {
          return this.EOF;
        }
        if (!this._input) {
          this.done = true;
        }
        var token, match, tempMatch, index;
        if (!this._more) {
          this.yytext = "";
          this.match = "";
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
          tempMatch = this._input.match(this.rules[rules[i]]);
          if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
            match = tempMatch;
            index = i;
            if (this.options.backtrack_lexer) {
              token = this.test_match(tempMatch, rules[i]);
              if (token !== false) {
                return token;
              } else if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            } else if (!this.options.flex) {
              break;
            }
          }
        }
        if (match) {
          token = this.test_match(match, rules[index]);
          if (token !== false) {
            return token;
          }
          return false;
        }
        if (this._input === "") {
          return this.EOF;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
      },
      // return next match that has a token
      lex: function lex2() {
        var r = this.next();
        if (r) {
          return r;
        } else {
          return this.lex();
        }
      },
      // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
      begin: function begin(condition) {
        this.conditionStack.push(condition);
      },
      // pop the previously active lexer condition state off the condition stack
      popState: function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
          return this.conditionStack.pop();
        } else {
          return this.conditionStack[0];
        }
      },
      // produce the lexer rule set which is active for the currently active lexer condition state
      _currentRules: function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
          return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
          return this.conditions["INITIAL"].rules;
        }
      },
      // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
      topState: function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
          return this.conditionStack[n];
        } else {
          return "INITIAL";
        }
      },
      // alias for begin(condition)
      pushState: function pushState(condition) {
        this.begin(condition);
      },
      // return the number of states currently on the stack
      stateStackSize: function stateStackSize() {
        return this.conditionStack.length;
      },
      options: { "case-insensitive": true },
      performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
        switch ($avoiding_name_collisions) {
          case 0:
            this.begin("acc_title");
            return 25;
          case 1:
            this.popState();
            return "acc_title_value";
          case 2:
            this.begin("acc_descr");
            return 27;
          case 3:
            this.popState();
            return "acc_descr_value";
          case 4:
            this.begin("acc_descr_multiline");
            break;
          case 5:
            this.popState();
            break;
          case 6:
            return "acc_descr_multiline_value";
          case 7:
            this.begin("open_directive");
            return 51;
          case 8:
            this.begin("type_directive");
            return 52;
          case 9:
            this.popState();
            this.begin("arg_directive");
            return 15;
          case 10:
            this.popState();
            this.popState();
            return 54;
          case 11:
            return 53;
          case 12:
            break;
          case 13:
            break;
          case 14:
            return 11;
          case 15:
            break;
          case 16:
            return 9;
          case 17:
            return 31;
          case 18:
            return 50;
          case 19:
            return 4;
          case 20:
            this.begin("block");
            return 20;
          case 21:
            return 39;
          case 22:
            break;
          case 23:
            return 40;
          case 24:
            return 37;
          case 25:
            return 37;
          case 26:
            return 41;
          case 27:
            break;
          case 28:
            this.popState();
            return 22;
          case 29:
            return yy_.yytext[0];
          case 30:
            return 44;
          case 31:
            return 46;
          case 32:
            return 46;
          case 33:
            return 46;
          case 34:
            return 44;
          case 35:
            return 44;
          case 36:
            return 45;
          case 37:
            return 45;
          case 38:
            return 45;
          case 39:
            return 45;
          case 40:
            return 45;
          case 41:
            return 46;
          case 42:
            return 45;
          case 43:
            return 46;
          case 44:
            return 47;
          case 45:
            return 47;
          case 46:
            return 47;
          case 47:
            return 47;
          case 48:
            return 44;
          case 49:
            return 45;
          case 50:
            return 46;
          case 51:
            return 48;
          case 52:
            return 49;
          case 53:
            return 49;
          case 54:
            return 48;
          case 55:
            return 48;
          case 56:
            return 48;
          case 57:
            return 30;
          case 58:
            return yy_.yytext[0];
          case 59:
            return 6;
        }
      },
      rules: [/^(?:accTitle\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*\{\s*)/i, /^(?:[\}])/i, /^(?:[^\}]*)/i, /^(?:%%\{)/i, /^(?:((?:(?!\}%%)[^:.])*))/i, /^(?::)/i, /^(?:\}%%)/i, /^(?:((?:(?!\}%%).|\n)*))/i, /^(?:%(?!\{)[^\n]*)/i, /^(?:[^\}]%%[^\n]*)/i, /^(?:[\n]+)/i, /^(?:\s+)/i, /^(?:[\s]+)/i, /^(?:"[^"%\r\n\v\b\\]+")/i, /^(?:"[^"]*")/i, /^(?:erDiagram\b)/i, /^(?:\{)/i, /^(?:,)/i, /^(?:\s+)/i, /^(?:\b((?:PK)|(?:FK)|(?:UK))\b)/i, /^(?:(.*?)[~](.*?)*[~])/i, /^(?:[A-Za-z_][A-Za-z0-9\-_\[\]\(\)]*)/i, /^(?:"[^"]*")/i, /^(?:[\n]+)/i, /^(?:\})/i, /^(?:.)/i, /^(?:one or zero\b)/i, /^(?:one or more\b)/i, /^(?:one or many\b)/i, /^(?:1\+)/i, /^(?:\|o\b)/i, /^(?:zero or one\b)/i, /^(?:zero or more\b)/i, /^(?:zero or many\b)/i, /^(?:0\+)/i, /^(?:\}o\b)/i, /^(?:many\(0\))/i, /^(?:many\(1\))/i, /^(?:many\b)/i, /^(?:\}\|)/i, /^(?:one\b)/i, /^(?:only one\b)/i, /^(?:1\b)/i, /^(?:\|\|)/i, /^(?:o\|)/i, /^(?:o\{)/i, /^(?:\|\{)/i, /^(?:\.\.)/i, /^(?:--)/i, /^(?:to\b)/i, /^(?:optionally to\b)/i, /^(?:\.-)/i, /^(?:-\.)/i, /^(?:[A-Za-z][A-Za-z0-9\-_]*)/i, /^(?:.)/i, /^(?:$)/i],
      conditions: { "acc_descr_multiline": { "rules": [5, 6], "inclusive": false }, "acc_descr": { "rules": [3], "inclusive": false }, "acc_title": { "rules": [1], "inclusive": false }, "open_directive": { "rules": [8], "inclusive": false }, "type_directive": { "rules": [9, 10], "inclusive": false }, "arg_directive": { "rules": [10, 11], "inclusive": false }, "block": { "rules": [21, 22, 23, 24, 25, 26, 27, 28, 29], "inclusive": false }, "INITIAL": { "rules": [0, 2, 4, 7, 12, 13, 14, 15, 16, 17, 18, 19, 20, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59], "inclusive": true } }
    };
    return lexer2;
  }();
  parser2.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  Parser.prototype = parser2;
  parser2.Parser = Parser;
  return new Parser();
}();
parser$9.parser = parser$9;
const erParser = parser$9;
const erDetector = (txt) => {
  return txt.match(/^\s*erDiagram/) !== null;
};
let entities = {};
let relationships = [];
const Cardinality = {
  ZERO_OR_ONE: "ZERO_OR_ONE",
  ZERO_OR_MORE: "ZERO_OR_MORE",
  ONE_OR_MORE: "ONE_OR_MORE",
  ONLY_ONE: "ONLY_ONE"
};
const Identification = {
  NON_IDENTIFYING: "NON_IDENTIFYING",
  IDENTIFYING: "IDENTIFYING"
};
const parseDirective$7 = function(statement, context, type2) {
  mermaidAPI.parseDirective(this, statement, context, type2);
};
const addEntity = function(name) {
  if (entities[name] === void 0) {
    entities[name] = { attributes: [] };
    log$1.info("Added new entity :", name);
  }
  return entities[name];
};
const getEntities = () => entities;
const addAttributes = function(entityName, attribs) {
  let entity = addEntity(entityName);
  let i;
  for (i = attribs.length - 1; i >= 0; i--) {
    entity.attributes.push(attribs[i]);
    log$1.debug("Added attribute ", attribs[i].attributeName);
  }
};
const addRelationship$1 = function(entA, rolA, entB, rSpec) {
  let rel = {
    entityA: entA,
    roleA: rolA,
    entityB: entB,
    relSpec: rSpec
  };
  relationships.push(rel);
  log$1.debug("Added new relationship :", rel);
};
const getRelationships$1 = () => relationships;
const clear$7 = function() {
  entities = {};
  relationships = [];
  clear$g();
};
const erDb = {
  Cardinality,
  Identification,
  parseDirective: parseDirective$7,
  getConfig: () => getConfig$1().er,
  addEntity,
  addAttributes,
  getEntities,
  addRelationship: addRelationship$1,
  getRelationships: getRelationships$1,
  clear: clear$7,
  setAccTitle,
  getAccTitle,
  setAccDescription,
  getAccDescription,
  setDiagramTitle,
  getDiagramTitle
};
const ERMarkers = {
  ONLY_ONE_START: "ONLY_ONE_START",
  ONLY_ONE_END: "ONLY_ONE_END",
  ZERO_OR_ONE_START: "ZERO_OR_ONE_START",
  ZERO_OR_ONE_END: "ZERO_OR_ONE_END",
  ONE_OR_MORE_START: "ONE_OR_MORE_START",
  ONE_OR_MORE_END: "ONE_OR_MORE_END",
  ZERO_OR_MORE_START: "ZERO_OR_MORE_START",
  ZERO_OR_MORE_END: "ZERO_OR_MORE_END"
};
const insertMarkers$1 = function(elem, conf2) {
  let marker;
  elem.append("defs").append("marker").attr("id", ERMarkers.ONLY_ONE_START).attr("refX", 0).attr("refY", 9).attr("markerWidth", 18).attr("markerHeight", 18).attr("orient", "auto").append("path").attr("stroke", conf2.stroke).attr("fill", "none").attr("d", "M9,0 L9,18 M15,0 L15,18");
  elem.append("defs").append("marker").attr("id", ERMarkers.ONLY_ONE_END).attr("refX", 18).attr("refY", 9).attr("markerWidth", 18).attr("markerHeight", 18).attr("orient", "auto").append("path").attr("stroke", conf2.stroke).attr("fill", "none").attr("d", "M3,0 L3,18 M9,0 L9,18");
  marker = elem.append("defs").append("marker").attr("id", ERMarkers.ZERO_OR_ONE_START).attr("refX", 0).attr("refY", 9).attr("markerWidth", 30).attr("markerHeight", 18).attr("orient", "auto");
  marker.append("circle").attr("stroke", conf2.stroke).attr("fill", "white").attr("cx", 21).attr("cy", 9).attr("r", 6);
  marker.append("path").attr("stroke", conf2.stroke).attr("fill", "none").attr("d", "M9,0 L9,18");
  marker = elem.append("defs").append("marker").attr("id", ERMarkers.ZERO_OR_ONE_END).attr("refX", 30).attr("refY", 9).attr("markerWidth", 30).attr("markerHeight", 18).attr("orient", "auto");
  marker.append("circle").attr("stroke", conf2.stroke).attr("fill", "white").attr("cx", 9).attr("cy", 9).attr("r", 6);
  marker.append("path").attr("stroke", conf2.stroke).attr("fill", "none").attr("d", "M21,0 L21,18");
  elem.append("defs").append("marker").attr("id", ERMarkers.ONE_OR_MORE_START).attr("refX", 18).attr("refY", 18).attr("markerWidth", 45).attr("markerHeight", 36).attr("orient", "auto").append("path").attr("stroke", conf2.stroke).attr("fill", "none").attr("d", "M0,18 Q 18,0 36,18 Q 18,36 0,18 M42,9 L42,27");
  elem.append("defs").append("marker").attr("id", ERMarkers.ONE_OR_MORE_END).attr("refX", 27).attr("refY", 18).attr("markerWidth", 45).attr("markerHeight", 36).attr("orient", "auto").append("path").attr("stroke", conf2.stroke).attr("fill", "none").attr("d", "M3,9 L3,27 M9,18 Q27,0 45,18 Q27,36 9,18");
  marker = elem.append("defs").append("marker").attr("id", ERMarkers.ZERO_OR_MORE_START).attr("refX", 18).attr("refY", 18).attr("markerWidth", 57).attr("markerHeight", 36).attr("orient", "auto");
  marker.append("circle").attr("stroke", conf2.stroke).attr("fill", "white").attr("cx", 48).attr("cy", 18).attr("r", 6);
  marker.append("path").attr("stroke", conf2.stroke).attr("fill", "none").attr("d", "M0,18 Q18,0 36,18 Q18,36 0,18");
  marker = elem.append("defs").append("marker").attr("id", ERMarkers.ZERO_OR_MORE_END).attr("refX", 39).attr("refY", 18).attr("markerWidth", 57).attr("markerHeight", 36).attr("orient", "auto");
  marker.append("circle").attr("stroke", conf2.stroke).attr("fill", "white").attr("cx", 9).attr("cy", 18).attr("r", 6);
  marker.append("path").attr("stroke", conf2.stroke).attr("fill", "none").attr("d", "M21,18 Q39,0 57,18 Q39,36 21,18");
  return;
};
const erMarkers = {
  ERMarkers,
  insertMarkers: insertMarkers$1
};
const BAD_ID_CHARS_REGEXP = /[^\dA-Za-z](\W)*/g;
let conf$8 = {};
let entityNameIds = /* @__PURE__ */ new Map();
const setConf$8 = function(cnf) {
  const keys2 = Object.keys(cnf);
  for (const key of keys2) {
    conf$8[key] = cnf[key];
  }
};
const drawAttributes = (groupNode, entityTextNode, attributes) => {
  const heightPadding = conf$8.entityPadding / 3;
  const widthPadding = conf$8.entityPadding / 3;
  const attrFontSize = conf$8.fontSize * 0.85;
  const labelBBox = entityTextNode.node().getBBox();
  const attributeNodes = [];
  let hasKeyType = false;
  let hasComment = false;
  let maxTypeWidth = 0;
  let maxNameWidth = 0;
  let maxKeyWidth = 0;
  let maxCommentWidth = 0;
  let cumulativeHeight = labelBBox.height + heightPadding * 2;
  let attrNum = 1;
  attributes.forEach((item) => {
    if (item.attributeKeyTypeList !== void 0 && item.attributeKeyTypeList.length > 0) {
      hasKeyType = true;
    }
    if (item.attributeComment !== void 0) {
      hasComment = true;
    }
  });
  attributes.forEach((item) => {
    const attrPrefix = `${entityTextNode.node().id}-attr-${attrNum}`;
    let nodeHeight = 0;
    const attributeType = parseGenericTypes(item.attributeType);
    const typeNode = groupNode.append("text").classed("er entityLabel", true).attr("id", `${attrPrefix}-type`).attr("x", 0).attr("y", 0).style("dominant-baseline", "middle").style("text-anchor", "left").style("font-family", getConfig$1().fontFamily).style("font-size", attrFontSize + "px").text(attributeType);
    const nameNode = groupNode.append("text").classed("er entityLabel", true).attr("id", `${attrPrefix}-name`).attr("x", 0).attr("y", 0).style("dominant-baseline", "middle").style("text-anchor", "left").style("font-family", getConfig$1().fontFamily).style("font-size", attrFontSize + "px").text(item.attributeName);
    const attributeNode = {};
    attributeNode.tn = typeNode;
    attributeNode.nn = nameNode;
    const typeBBox = typeNode.node().getBBox();
    const nameBBox = nameNode.node().getBBox();
    maxTypeWidth = Math.max(maxTypeWidth, typeBBox.width);
    maxNameWidth = Math.max(maxNameWidth, nameBBox.width);
    nodeHeight = Math.max(typeBBox.height, nameBBox.height);
    if (hasKeyType) {
      const keyTypeNodeText = item.attributeKeyTypeList !== void 0 ? item.attributeKeyTypeList.join(",") : "";
      const keyTypeNode = groupNode.append("text").classed("er entityLabel", true).attr("id", `${attrPrefix}-key`).attr("x", 0).attr("y", 0).style("dominant-baseline", "middle").style("text-anchor", "left").style("font-family", getConfig$1().fontFamily).style("font-size", attrFontSize + "px").text(keyTypeNodeText);
      attributeNode.kn = keyTypeNode;
      const keyTypeBBox = keyTypeNode.node().getBBox();
      maxKeyWidth = Math.max(maxKeyWidth, keyTypeBBox.width);
      nodeHeight = Math.max(nodeHeight, keyTypeBBox.height);
    }
    if (hasComment) {
      const commentNode = groupNode.append("text").classed("er entityLabel", true).attr("id", `${attrPrefix}-comment`).attr("x", 0).attr("y", 0).style("dominant-baseline", "middle").style("text-anchor", "left").style("font-family", getConfig$1().fontFamily).style("font-size", attrFontSize + "px").text(item.attributeComment || "");
      attributeNode.cn = commentNode;
      const commentNodeBBox = commentNode.node().getBBox();
      maxCommentWidth = Math.max(maxCommentWidth, commentNodeBBox.width);
      nodeHeight = Math.max(nodeHeight, commentNodeBBox.height);
    }
    attributeNode.height = nodeHeight;
    attributeNodes.push(attributeNode);
    cumulativeHeight += nodeHeight + heightPadding * 2;
    attrNum += 1;
  });
  let widthPaddingFactor = 4;
  if (hasKeyType) {
    widthPaddingFactor += 2;
  }
  if (hasComment) {
    widthPaddingFactor += 2;
  }
  const maxWidth = maxTypeWidth + maxNameWidth + maxKeyWidth + maxCommentWidth;
  const bBox = {
    width: Math.max(
      conf$8.minEntityWidth,
      Math.max(
        labelBBox.width + conf$8.entityPadding * 2,
        maxWidth + widthPadding * widthPaddingFactor
      )
    ),
    height: attributes.length > 0 ? cumulativeHeight : Math.max(conf$8.minEntityHeight, labelBBox.height + conf$8.entityPadding * 2)
  };
  if (attributes.length > 0) {
    const spareColumnWidth = Math.max(
      0,
      (bBox.width - maxWidth - widthPadding * widthPaddingFactor) / (widthPaddingFactor / 2)
    );
    entityTextNode.attr(
      "transform",
      "translate(" + bBox.width / 2 + "," + (heightPadding + labelBBox.height / 2) + ")"
    );
    let heightOffset = labelBBox.height + heightPadding * 2;
    let attribStyle = "attributeBoxOdd";
    attributeNodes.forEach((attributeNode) => {
      const alignY = heightOffset + heightPadding + attributeNode.height / 2;
      attributeNode.tn.attr("transform", "translate(" + widthPadding + "," + alignY + ")");
      const typeRect = groupNode.insert("rect", "#" + attributeNode.tn.node().id).classed(`er ${attribStyle}`, true).attr("x", 0).attr("y", heightOffset).attr("width", maxTypeWidth + widthPadding * 2 + spareColumnWidth).attr("height", attributeNode.height + heightPadding * 2);
      const nameXOffset = parseFloat(typeRect.attr("x")) + parseFloat(typeRect.attr("width"));
      attributeNode.nn.attr(
        "transform",
        "translate(" + (nameXOffset + widthPadding) + "," + alignY + ")"
      );
      const nameRect = groupNode.insert("rect", "#" + attributeNode.nn.node().id).classed(`er ${attribStyle}`, true).attr("x", nameXOffset).attr("y", heightOffset).attr("width", maxNameWidth + widthPadding * 2 + spareColumnWidth).attr("height", attributeNode.height + heightPadding * 2);
      let keyTypeAndCommentXOffset = parseFloat(nameRect.attr("x")) + parseFloat(nameRect.attr("width"));
      if (hasKeyType) {
        attributeNode.kn.attr(
          "transform",
          "translate(" + (keyTypeAndCommentXOffset + widthPadding) + "," + alignY + ")"
        );
        const keyTypeRect = groupNode.insert("rect", "#" + attributeNode.kn.node().id).classed(`er ${attribStyle}`, true).attr("x", keyTypeAndCommentXOffset).attr("y", heightOffset).attr("width", maxKeyWidth + widthPadding * 2 + spareColumnWidth).attr("height", attributeNode.height + heightPadding * 2);
        keyTypeAndCommentXOffset = parseFloat(keyTypeRect.attr("x")) + parseFloat(keyTypeRect.attr("width"));
      }
      if (hasComment) {
        attributeNode.cn.attr(
          "transform",
          "translate(" + (keyTypeAndCommentXOffset + widthPadding) + "," + alignY + ")"
        );
        groupNode.insert("rect", "#" + attributeNode.cn.node().id).classed(`er ${attribStyle}`, "true").attr("x", keyTypeAndCommentXOffset).attr("y", heightOffset).attr("width", maxCommentWidth + widthPadding * 2 + spareColumnWidth).attr("height", attributeNode.height + heightPadding * 2);
      }
      heightOffset += attributeNode.height + heightPadding * 2;
      attribStyle = attribStyle === "attributeBoxOdd" ? "attributeBoxEven" : "attributeBoxOdd";
    });
  } else {
    bBox.height = Math.max(conf$8.minEntityHeight, cumulativeHeight);
    entityTextNode.attr("transform", "translate(" + bBox.width / 2 + "," + bBox.height / 2 + ")");
  }
  return bBox;
};
const drawEntities = function(svgNode, entities2, graph) {
  const keys2 = Object.keys(entities2);
  let firstOne;
  keys2.forEach(function(entityName) {
    const entityId = generateId(entityName, "entity");
    entityNameIds.set(entityName, entityId);
    const groupNode = svgNode.append("g").attr("id", entityId);
    firstOne = firstOne === void 0 ? entityId : firstOne;
    const textId = "text-" + entityId;
    const textNode = groupNode.append("text").classed("er entityLabel", true).attr("id", textId).attr("x", 0).attr("y", 0).style("dominant-baseline", "middle").style("text-anchor", "middle").style("font-family", getConfig$1().fontFamily).style("font-size", conf$8.fontSize + "px").text(entityName);
    const { width: entityWidth, height: entityHeight } = drawAttributes(
      groupNode,
      textNode,
      entities2[entityName].attributes
    );
    const rectNode = groupNode.insert("rect", "#" + textId).classed("er entityBox", true).attr("x", 0).attr("y", 0).attr("width", entityWidth).attr("height", entityHeight);
    const rectBBox = rectNode.node().getBBox();
    graph.setNode(entityId, {
      width: rectBBox.width,
      height: rectBBox.height,
      shape: "rect",
      id: entityId
    });
  });
  return firstOne;
};
const adjustEntities$1 = function(svgNode, graph) {
  graph.nodes().forEach(function(v) {
    if (v !== void 0 && graph.node(v) !== void 0) {
      svgNode.select("#" + v).attr(
        "transform",
        "translate(" + (graph.node(v).x - graph.node(v).width / 2) + "," + (graph.node(v).y - graph.node(v).height / 2) + " )"
      );
    }
  });
};
const getEdgeName = function(rel) {
  return (rel.entityA + rel.roleA + rel.entityB).replace(/\s/g, "");
};
const addRelationships$1 = function(relationships2, g) {
  relationships2.forEach(function(r) {
    g.setEdge(
      entityNameIds.get(r.entityA),
      entityNameIds.get(r.entityB),
      { relationship: r },
      getEdgeName(r)
    );
  });
  return relationships2;
};
let relCnt$1 = 0;
const drawRelationshipFromLayout$1 = function(svg, rel, g, insert, diagObj) {
  relCnt$1++;
  const edge = g.edge(
    entityNameIds.get(rel.entityA),
    entityNameIds.get(rel.entityB),
    getEdgeName(rel)
  );
  const lineFunction = line().x(function(d) {
    return d.x;
  }).y(function(d) {
    return d.y;
  }).curve(curveBasis);
  const svgPath = svg.insert("path", "#" + insert).classed("er relationshipLine", true).attr("d", lineFunction(edge.points)).style("stroke", conf$8.stroke).style("fill", "none");
  if (rel.relSpec.relType === diagObj.db.Identification.NON_IDENTIFYING) {
    svgPath.attr("stroke-dasharray", "8,8");
  }
  let url = "";
  if (conf$8.arrowMarkerAbsolute) {
    url = window.location.protocol + "//" + window.location.host + window.location.pathname + window.location.search;
    url = url.replace(/\(/g, "\\(");
    url = url.replace(/\)/g, "\\)");
  }
  switch (rel.relSpec.cardA) {
    case diagObj.db.Cardinality.ZERO_OR_ONE:
      svgPath.attr("marker-end", "url(" + url + "#" + erMarkers.ERMarkers.ZERO_OR_ONE_END + ")");
      break;
    case diagObj.db.Cardinality.ZERO_OR_MORE:
      svgPath.attr("marker-end", "url(" + url + "#" + erMarkers.ERMarkers.ZERO_OR_MORE_END + ")");
      break;
    case diagObj.db.Cardinality.ONE_OR_MORE:
      svgPath.attr("marker-end", "url(" + url + "#" + erMarkers.ERMarkers.ONE_OR_MORE_END + ")");
      break;
    case diagObj.db.Cardinality.ONLY_ONE:
      svgPath.attr("marker-end", "url(" + url + "#" + erMarkers.ERMarkers.ONLY_ONE_END + ")");
      break;
  }
  switch (rel.relSpec.cardB) {
    case diagObj.db.Cardinality.ZERO_OR_ONE:
      svgPath.attr(
        "marker-start",
        "url(" + url + "#" + erMarkers.ERMarkers.ZERO_OR_ONE_START + ")"
      );
      break;
    case diagObj.db.Cardinality.ZERO_OR_MORE:
      svgPath.attr(
        "marker-start",
        "url(" + url + "#" + erMarkers.ERMarkers.ZERO_OR_MORE_START + ")"
      );
      break;
    case diagObj.db.Cardinality.ONE_OR_MORE:
      svgPath.attr(
        "marker-start",
        "url(" + url + "#" + erMarkers.ERMarkers.ONE_OR_MORE_START + ")"
      );
      break;
    case diagObj.db.Cardinality.ONLY_ONE:
      svgPath.attr("marker-start", "url(" + url + "#" + erMarkers.ERMarkers.ONLY_ONE_START + ")");
      break;
  }
  const len = svgPath.node().getTotalLength();
  const labelPoint = svgPath.node().getPointAtLength(len * 0.5);
  const labelId = "rel" + relCnt$1;
  const labelNode = svg.append("text").classed("er relationshipLabel", true).attr("id", labelId).attr("x", labelPoint.x).attr("y", labelPoint.y).style("text-anchor", "middle").style("dominant-baseline", "middle").style("font-family", getConfig$1().fontFamily).style("font-size", conf$8.fontSize + "px").text(rel.roleA);
  const labelBBox = labelNode.node().getBBox();
  svg.insert("rect", "#" + labelId).classed("er relationshipLabelBox", true).attr("x", labelPoint.x - labelBBox.width / 2).attr("y", labelPoint.y - labelBBox.height / 2).attr("width", labelBBox.width).attr("height", labelBBox.height);
};
const draw$b = function(text, id2, _version, diagObj) {
  conf$8 = getConfig$1().er;
  log$1.info("Drawing ER diagram");
  const securityLevel = getConfig$1().securityLevel;
  let sandboxElement;
  if (securityLevel === "sandbox") {
    sandboxElement = select("#i" + id2);
  }
  const root = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
  const svg = root.select(`[id='${id2}']`);
  erMarkers.insertMarkers(svg, conf$8);
  let g;
  g = new graphlib.Graph({
    multigraph: true,
    directed: true,
    compound: false
  }).setGraph({
    rankdir: conf$8.layoutDirection,
    marginx: 20,
    marginy: 20,
    nodesep: 100,
    edgesep: 100,
    ranksep: 100
  }).setDefaultEdgeLabel(function() {
    return {};
  });
  const firstEntity = drawEntities(svg, diagObj.db.getEntities(), g);
  const relationships2 = addRelationships$1(diagObj.db.getRelationships(), g);
  layout(g);
  adjustEntities$1(svg, g);
  relationships2.forEach(function(rel) {
    drawRelationshipFromLayout$1(svg, rel, g, firstEntity, diagObj);
  });
  const padding2 = conf$8.diagramPadding;
  utils.insertTitle(svg, "entityTitleText", conf$8.titleTopMargin, diagObj.db.getDiagramTitle());
  const svgBounds = svg.node().getBBox();
  const width2 = svgBounds.width + padding2 * 2;
  const height2 = svgBounds.height + padding2 * 2;
  configureSvgSize(svg, height2, width2, conf$8.useMaxWidth);
  svg.attr("viewBox", `${svgBounds.x - padding2} ${svgBounds.y - padding2} ${width2} ${height2}`);
};
const MERMAID_ERDIAGRAM_UUID = "28e9f9db-3c8d-5aa5-9faf-44286ae5937c";
function generateId(str2 = "", prefix = "") {
  const simplifiedStr = str2.replace(BAD_ID_CHARS_REGEXP, "");
  return `${strWithHyphen(prefix)}${strWithHyphen(simplifiedStr)}${v5(
    str2,
    MERMAID_ERDIAGRAM_UUID
  )}`;
}
function strWithHyphen(str2 = "") {
  return str2.length > 0 ? `${str2}-` : "";
}
const erRenderer = {
  setConf: setConf$8,
  draw: draw$b
};
var parser$7 = function() {
  var o = function(k, v, o2, l) {
    for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
      ;
    return o2;
  }, $V0 = [1, 9], $V1 = [1, 7], $V2 = [1, 6], $V3 = [1, 8], $V4 = [1, 20, 21, 22, 23, 38, 44, 46, 48, 52, 66, 67, 86, 87, 88, 89, 90, 91, 95, 105, 106, 109, 111, 112, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127], $V5 = [2, 10], $V6 = [1, 20], $V7 = [1, 21], $V8 = [1, 22], $V9 = [1, 23], $Va = [1, 30], $Vb = [1, 32], $Vc = [1, 33], $Vd = [1, 34], $Ve = [1, 62], $Vf = [1, 48], $Vg = [1, 52], $Vh = [1, 36], $Vi = [1, 37], $Vj = [1, 38], $Vk = [1, 39], $Vl = [1, 40], $Vm = [1, 56], $Vn = [1, 63], $Vo = [1, 51], $Vp = [1, 53], $Vq = [1, 55], $Vr = [1, 59], $Vs = [1, 60], $Vt = [1, 41], $Vu = [1, 42], $Vv = [1, 43], $Vw = [1, 44], $Vx = [1, 61], $Vy = [1, 50], $Vz = [1, 54], $VA = [1, 57], $VB = [1, 58], $VC = [1, 49], $VD = [1, 66], $VE = [1, 71], $VF = [1, 20, 21, 22, 23, 38, 42, 44, 46, 48, 52, 66, 67, 86, 87, 88, 89, 90, 91, 95, 105, 106, 109, 111, 112, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127], $VG = [1, 75], $VH = [1, 74], $VI = [1, 76], $VJ = [20, 21, 23, 81, 82], $VK = [1, 99], $VL = [1, 104], $VM = [1, 107], $VN = [1, 108], $VO = [1, 101], $VP = [1, 106], $VQ = [1, 109], $VR = [1, 102], $VS = [1, 114], $VT = [1, 113], $VU = [1, 103], $VV = [1, 105], $VW = [1, 110], $VX = [1, 111], $VY = [1, 112], $VZ = [1, 115], $V_ = [20, 21, 22, 23, 81, 82], $V$ = [20, 21, 22, 23, 53, 81, 82], $V01 = [20, 21, 22, 23, 40, 52, 53, 55, 57, 59, 61, 63, 65, 66, 67, 69, 71, 73, 74, 76, 81, 82, 91, 95, 105, 106, 109, 111, 112, 122, 123, 124, 125, 126, 127], $V11 = [20, 21, 23], $V21 = [20, 21, 23, 52, 66, 67, 81, 82, 91, 95, 105, 106, 109, 111, 112, 122, 123, 124, 125, 126, 127], $V31 = [1, 12, 20, 21, 22, 23, 24, 38, 42, 44, 46, 48, 52, 66, 67, 86, 87, 88, 89, 90, 91, 95, 105, 106, 109, 111, 112, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127], $V41 = [52, 66, 67, 91, 95, 105, 106, 109, 111, 112, 122, 123, 124, 125, 126, 127], $V51 = [1, 149], $V61 = [1, 157], $V71 = [1, 158], $V81 = [1, 159], $V91 = [1, 160], $Va1 = [1, 144], $Vb1 = [1, 145], $Vc1 = [1, 141], $Vd1 = [1, 152], $Ve1 = [1, 153], $Vf1 = [1, 154], $Vg1 = [1, 155], $Vh1 = [1, 156], $Vi1 = [1, 161], $Vj1 = [1, 162], $Vk1 = [1, 147], $Vl1 = [1, 150], $Vm1 = [1, 146], $Vn1 = [1, 143], $Vo1 = [20, 21, 22, 23, 38, 42, 44, 46, 48, 52, 66, 67, 86, 87, 88, 89, 90, 91, 95, 105, 106, 109, 111, 112, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127], $Vp1 = [1, 165], $Vq1 = [20, 21, 22, 23, 26, 52, 66, 67, 91, 105, 106, 109, 111, 112, 122, 123, 124, 125, 126, 127], $Vr1 = [20, 21, 22, 23, 24, 26, 38, 40, 41, 42, 52, 56, 58, 60, 62, 64, 66, 67, 68, 70, 72, 73, 75, 77, 81, 82, 86, 87, 88, 89, 90, 91, 92, 95, 105, 106, 109, 111, 112, 113, 114, 122, 123, 124, 125, 126, 127], $Vs1 = [12, 21, 22, 24], $Vt1 = [22, 106], $Vu1 = [1, 250], $Vv1 = [1, 245], $Vw1 = [1, 246], $Vx1 = [1, 254], $Vy1 = [1, 251], $Vz1 = [1, 248], $VA1 = [1, 247], $VB1 = [1, 249], $VC1 = [1, 252], $VD1 = [1, 253], $VE1 = [1, 255], $VF1 = [1, 273], $VG1 = [20, 21, 23, 106], $VH1 = [20, 21, 22, 23, 66, 67, 86, 102, 105, 106, 109, 110, 111, 112, 113];
  var parser2 = {
    trace: function trace() {
    },
    yy: {},
    symbols_: { "error": 2, "start": 3, "mermaidDoc": 4, "directive": 5, "openDirective": 6, "typeDirective": 7, "closeDirective": 8, "separator": 9, ":": 10, "argDirective": 11, "open_directive": 12, "type_directive": 13, "arg_directive": 14, "close_directive": 15, "graphConfig": 16, "document": 17, "line": 18, "statement": 19, "SEMI": 20, "NEWLINE": 21, "SPACE": 22, "EOF": 23, "GRAPH": 24, "NODIR": 25, "DIR": 26, "FirstStmtSeperator": 27, "ending": 28, "endToken": 29, "spaceList": 30, "spaceListNewline": 31, "verticeStatement": 32, "styleStatement": 33, "linkStyleStatement": 34, "classDefStatement": 35, "classStatement": 36, "clickStatement": 37, "subgraph": 38, "text": 39, "SQS": 40, "SQE": 41, "end": 42, "direction": 43, "acc_title": 44, "acc_title_value": 45, "acc_descr": 46, "acc_descr_value": 47, "acc_descr_multiline_value": 48, "link": 49, "node": 50, "vertex": 51, "AMP": 52, "STYLE_SEPARATOR": 53, "idString": 54, "DOUBLECIRCLESTART": 55, "DOUBLECIRCLEEND": 56, "PS": 57, "PE": 58, "(-": 59, "-)": 60, "STADIUMSTART": 61, "STADIUMEND": 62, "SUBROUTINESTART": 63, "SUBROUTINEEND": 64, "VERTEX_WITH_PROPS_START": 65, "ALPHA": 66, "COLON": 67, "PIPE": 68, "CYLINDERSTART": 69, "CYLINDEREND": 70, "DIAMOND_START": 71, "DIAMOND_STOP": 72, "TAGEND": 73, "TRAPSTART": 74, "TRAPEND": 75, "INVTRAPSTART": 76, "INVTRAPEND": 77, "linkStatement": 78, "arrowText": 79, "TESTSTR": 80, "START_LINK": 81, "LINK": 82, "textToken": 83, "STR": 84, "keywords": 85, "STYLE": 86, "LINKSTYLE": 87, "CLASSDEF": 88, "CLASS": 89, "CLICK": 90, "DOWN": 91, "UP": 92, "textNoTags": 93, "textNoTagsToken": 94, "DEFAULT": 95, "stylesOpt": 96, "alphaNum": 97, "CALLBACKNAME": 98, "CALLBACKARGS": 99, "HREF": 100, "LINK_TARGET": 101, "HEX": 102, "numList": 103, "INTERPOLATE": 104, "NUM": 105, "COMMA": 106, "style": 107, "styleComponent": 108, "MINUS": 109, "UNIT": 110, "BRKT": 111, "DOT": 112, "PCT": 113, "TAGSTART": 114, "alphaNumToken": 115, "idStringToken": 116, "alphaNumStatement": 117, "direction_tb": 118, "direction_bt": 119, "direction_rl": 120, "direction_lr": 121, "PUNCTUATION": 122, "UNICODE_TEXT": 123, "PLUS": 124, "EQUALS": 125, "MULT": 126, "UNDERSCORE": 127, "graphCodeTokens": 128, "ARROW_CROSS": 129, "ARROW_POINT": 130, "ARROW_CIRCLE": 131, "ARROW_OPEN": 132, "QUOTE": 133, "$accept": 0, "$end": 1 },
    terminals_: { 2: "error", 10: ":", 12: "open_directive", 13: "type_directive", 14: "arg_directive", 15: "close_directive", 20: "SEMI", 21: "NEWLINE", 22: "SPACE", 23: "EOF", 24: "GRAPH", 25: "NODIR", 26: "DIR", 38: "subgraph", 40: "SQS", 41: "SQE", 42: "end", 44: "acc_title", 45: "acc_title_value", 46: "acc_descr", 47: "acc_descr_value", 48: "acc_descr_multiline_value", 52: "AMP", 53: "STYLE_SEPARATOR", 55: "DOUBLECIRCLESTART", 56: "DOUBLECIRCLEEND", 57: "PS", 58: "PE", 59: "(-", 60: "-)", 61: "STADIUMSTART", 62: "STADIUMEND", 63: "SUBROUTINESTART", 64: "SUBROUTINEEND", 65: "VERTEX_WITH_PROPS_START", 66: "ALPHA", 67: "COLON", 68: "PIPE", 69: "CYLINDERSTART", 70: "CYLINDEREND", 71: "DIAMOND_START", 72: "DIAMOND_STOP", 73: "TAGEND", 74: "TRAPSTART", 75: "TRAPEND", 76: "INVTRAPSTART", 77: "INVTRAPEND", 80: "TESTSTR", 81: "START_LINK", 82: "LINK", 84: "STR", 86: "STYLE", 87: "LINKSTYLE", 88: "CLASSDEF", 89: "CLASS", 90: "CLICK", 91: "DOWN", 92: "UP", 95: "DEFAULT", 98: "CALLBACKNAME", 99: "CALLBACKARGS", 100: "HREF", 101: "LINK_TARGET", 102: "HEX", 104: "INTERPOLATE", 105: "NUM", 106: "COMMA", 109: "MINUS", 110: "UNIT", 111: "BRKT", 112: "DOT", 113: "PCT", 114: "TAGSTART", 118: "direction_tb", 119: "direction_bt", 120: "direction_rl", 121: "direction_lr", 122: "PUNCTUATION", 123: "UNICODE_TEXT", 124: "PLUS", 125: "EQUALS", 126: "MULT", 127: "UNDERSCORE", 129: "ARROW_CROSS", 130: "ARROW_POINT", 131: "ARROW_CIRCLE", 132: "ARROW_OPEN", 133: "QUOTE" },
    productions_: [0, [3, 1], [3, 2], [5, 4], [5, 6], [6, 1], [7, 1], [11, 1], [8, 1], [4, 2], [17, 0], [17, 2], [18, 1], [18, 1], [18, 1], [18, 1], [18, 1], [16, 2], [16, 2], [16, 2], [16, 3], [28, 2], [28, 1], [29, 1], [29, 1], [29, 1], [27, 1], [27, 1], [27, 2], [31, 2], [31, 2], [31, 1], [31, 1], [30, 2], [30, 1], [19, 2], [19, 2], [19, 2], [19, 2], [19, 2], [19, 2], [19, 9], [19, 6], [19, 4], [19, 1], [19, 2], [19, 2], [19, 1], [9, 1], [9, 1], [9, 1], [32, 3], [32, 4], [32, 2], [32, 1], [50, 1], [50, 5], [50, 3], [51, 4], [51, 4], [51, 6], [51, 4], [51, 4], [51, 4], [51, 8], [51, 4], [51, 4], [51, 4], [51, 6], [51, 4], [51, 4], [51, 4], [51, 4], [51, 4], [51, 1], [49, 2], [49, 3], [49, 3], [49, 1], [49, 3], [78, 1], [79, 3], [39, 1], [39, 2], [39, 1], [85, 1], [85, 1], [85, 1], [85, 1], [85, 1], [85, 1], [85, 1], [85, 1], [85, 1], [85, 1], [85, 1], [93, 1], [93, 2], [35, 5], [35, 5], [36, 5], [37, 2], [37, 4], [37, 3], [37, 5], [37, 2], [37, 4], [37, 4], [37, 6], [37, 2], [37, 4], [37, 2], [37, 4], [37, 4], [37, 6], [33, 5], [33, 5], [34, 5], [34, 5], [34, 9], [34, 9], [34, 7], [34, 7], [103, 1], [103, 3], [96, 1], [96, 3], [107, 1], [107, 2], [108, 1], [108, 1], [108, 1], [108, 1], [108, 1], [108, 1], [108, 1], [108, 1], [108, 1], [108, 1], [108, 1], [83, 1], [83, 1], [83, 1], [83, 1], [83, 1], [83, 1], [94, 1], [94, 1], [94, 1], [94, 1], [54, 1], [54, 2], [97, 1], [97, 2], [117, 1], [117, 1], [117, 1], [117, 1], [43, 1], [43, 1], [43, 1], [43, 1], [115, 1], [115, 1], [115, 1], [115, 1], [115, 1], [115, 1], [115, 1], [115, 1], [115, 1], [115, 1], [115, 1], [115, 1], [115, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1], [128, 1]],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
      var $0 = $$.length - 1;
      switch (yystate) {
        case 5:
          yy.parseDirective("%%{", "open_directive");
          break;
        case 6:
          yy.parseDirective($$[$0], "type_directive");
          break;
        case 7:
          $$[$0] = $$[$0].trim().replace(/'/g, '"');
          yy.parseDirective($$[$0], "arg_directive");
          break;
        case 8:
          yy.parseDirective("}%%", "close_directive", "flowchart");
          break;
        case 10:
          this.$ = [];
          break;
        case 11:
          if (!Array.isArray($$[$0]) || $$[$0].length > 0) {
            $$[$0 - 1].push($$[$0]);
          }
          this.$ = $$[$0 - 1];
          break;
        case 12:
        case 82:
        case 84:
        case 96:
        case 152:
        case 154:
        case 155:
          this.$ = $$[$0];
          break;
        case 19:
          yy.setDirection("TB");
          this.$ = "TB";
          break;
        case 20:
          yy.setDirection($$[$0 - 1]);
          this.$ = $$[$0 - 1];
          break;
        case 35:
          this.$ = $$[$0 - 1].nodes;
          break;
        case 36:
        case 37:
        case 38:
        case 39:
        case 40:
          this.$ = [];
          break;
        case 41:
          this.$ = yy.addSubGraph($$[$0 - 6], $$[$0 - 1], $$[$0 - 4]);
          break;
        case 42:
          this.$ = yy.addSubGraph($$[$0 - 3], $$[$0 - 1], $$[$0 - 3]);
          break;
        case 43:
          this.$ = yy.addSubGraph(void 0, $$[$0 - 1], void 0);
          break;
        case 45:
          this.$ = $$[$0].trim();
          yy.setAccTitle(this.$);
          break;
        case 46:
        case 47:
          this.$ = $$[$0].trim();
          yy.setAccDescription(this.$);
          break;
        case 51:
          yy.addLink($$[$0 - 2].stmt, $$[$0], $$[$0 - 1]);
          this.$ = { stmt: $$[$0], nodes: $$[$0].concat($$[$0 - 2].nodes) };
          break;
        case 52:
          yy.addLink($$[$0 - 3].stmt, $$[$0 - 1], $$[$0 - 2]);
          this.$ = { stmt: $$[$0 - 1], nodes: $$[$0 - 1].concat($$[$0 - 3].nodes) };
          break;
        case 53:
          this.$ = { stmt: $$[$0 - 1], nodes: $$[$0 - 1] };
          break;
        case 54:
          this.$ = { stmt: $$[$0], nodes: $$[$0] };
          break;
        case 55:
          this.$ = [$$[$0]];
          break;
        case 56:
          this.$ = $$[$0 - 4].concat($$[$0]);
          break;
        case 57:
          this.$ = [$$[$0 - 2]];
          yy.setClass($$[$0 - 2], $$[$0]);
          break;
        case 58:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "square");
          break;
        case 59:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "doublecircle");
          break;
        case 60:
          this.$ = $$[$0 - 5];
          yy.addVertex($$[$0 - 5], $$[$0 - 2], "circle");
          break;
        case 61:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "ellipse");
          break;
        case 62:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "stadium");
          break;
        case 63:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "subroutine");
          break;
        case 64:
          this.$ = $$[$0 - 7];
          yy.addVertex($$[$0 - 7], $$[$0 - 1], "rect", void 0, void 0, void 0, Object.fromEntries([[$$[$0 - 5], $$[$0 - 3]]]));
          break;
        case 65:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "cylinder");
          break;
        case 66:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "round");
          break;
        case 67:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "diamond");
          break;
        case 68:
          this.$ = $$[$0 - 5];
          yy.addVertex($$[$0 - 5], $$[$0 - 2], "hexagon");
          break;
        case 69:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "odd");
          break;
        case 70:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "trapezoid");
          break;
        case 71:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "inv_trapezoid");
          break;
        case 72:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "lean_right");
          break;
        case 73:
          this.$ = $$[$0 - 3];
          yy.addVertex($$[$0 - 3], $$[$0 - 1], "lean_left");
          break;
        case 74:
          this.$ = $$[$0];
          yy.addVertex($$[$0]);
          break;
        case 75:
          $$[$0 - 1].text = $$[$0];
          this.$ = $$[$0 - 1];
          break;
        case 76:
        case 77:
          $$[$0 - 2].text = $$[$0 - 1];
          this.$ = $$[$0 - 2];
          break;
        case 78:
          this.$ = $$[$0];
          break;
        case 79:
          var inf = yy.destructLink($$[$0], $$[$0 - 2]);
          this.$ = { "type": inf.type, "stroke": inf.stroke, "length": inf.length, "text": $$[$0 - 1] };
          break;
        case 80:
          var inf = yy.destructLink($$[$0]);
          this.$ = { "type": inf.type, "stroke": inf.stroke, "length": inf.length };
          break;
        case 81:
          this.$ = $$[$0 - 1];
          break;
        case 83:
        case 97:
        case 153:
          this.$ = $$[$0 - 1] + "" + $$[$0];
          break;
        case 98:
        case 99:
          this.$ = $$[$0 - 4];
          yy.addClass($$[$0 - 2], $$[$0]);
          break;
        case 100:
          this.$ = $$[$0 - 4];
          yy.setClass($$[$0 - 2], $$[$0]);
          break;
        case 101:
        case 109:
          this.$ = $$[$0 - 1];
          yy.setClickEvent($$[$0 - 1], $$[$0]);
          break;
        case 102:
        case 110:
          this.$ = $$[$0 - 3];
          yy.setClickEvent($$[$0 - 3], $$[$0 - 2]);
          yy.setTooltip($$[$0 - 3], $$[$0]);
          break;
        case 103:
          this.$ = $$[$0 - 2];
          yy.setClickEvent($$[$0 - 2], $$[$0 - 1], $$[$0]);
          break;
        case 104:
          this.$ = $$[$0 - 4];
          yy.setClickEvent($$[$0 - 4], $$[$0 - 3], $$[$0 - 2]);
          yy.setTooltip($$[$0 - 4], $$[$0]);
          break;
        case 105:
        case 111:
          this.$ = $$[$0 - 1];
          yy.setLink($$[$0 - 1], $$[$0]);
          break;
        case 106:
        case 112:
          this.$ = $$[$0 - 3];
          yy.setLink($$[$0 - 3], $$[$0 - 2]);
          yy.setTooltip($$[$0 - 3], $$[$0]);
          break;
        case 107:
        case 113:
          this.$ = $$[$0 - 3];
          yy.setLink($$[$0 - 3], $$[$0 - 2], $$[$0]);
          break;
        case 108:
        case 114:
          this.$ = $$[$0 - 5];
          yy.setLink($$[$0 - 5], $$[$0 - 4], $$[$0]);
          yy.setTooltip($$[$0 - 5], $$[$0 - 2]);
          break;
        case 115:
          this.$ = $$[$0 - 4];
          yy.addVertex($$[$0 - 2], void 0, void 0, $$[$0]);
          break;
        case 116:
        case 118:
          this.$ = $$[$0 - 4];
          yy.updateLink($$[$0 - 2], $$[$0]);
          break;
        case 117:
          this.$ = $$[$0 - 4];
          yy.updateLink([$$[$0 - 2]], $$[$0]);
          break;
        case 119:
          this.$ = $$[$0 - 8];
          yy.updateLinkInterpolate([$$[$0 - 6]], $$[$0 - 2]);
          yy.updateLink([$$[$0 - 6]], $$[$0]);
          break;
        case 120:
          this.$ = $$[$0 - 8];
          yy.updateLinkInterpolate($$[$0 - 6], $$[$0 - 2]);
          yy.updateLink($$[$0 - 6], $$[$0]);
          break;
        case 121:
          this.$ = $$[$0 - 6];
          yy.updateLinkInterpolate([$$[$0 - 4]], $$[$0]);
          break;
        case 122:
          this.$ = $$[$0 - 6];
          yy.updateLinkInterpolate($$[$0 - 4], $$[$0]);
          break;
        case 123:
        case 125:
          this.$ = [$$[$0]];
          break;
        case 124:
        case 126:
          $$[$0 - 2].push($$[$0]);
          this.$ = $$[$0 - 2];
          break;
        case 128:
          this.$ = $$[$0 - 1] + $$[$0];
          break;
        case 150:
          this.$ = $$[$0];
          break;
        case 151:
          this.$ = $$[$0 - 1] + "" + $$[$0];
          break;
        case 156:
          this.$ = "v";
          break;
        case 157:
          this.$ = "-";
          break;
        case 158:
          this.$ = { stmt: "dir", value: "TB" };
          break;
        case 159:
          this.$ = { stmt: "dir", value: "BT" };
          break;
        case 160:
          this.$ = { stmt: "dir", value: "RL" };
          break;
        case 161:
          this.$ = { stmt: "dir", value: "LR" };
          break;
      }
    },
    table: [{ 3: 1, 4: 2, 5: 3, 6: 5, 12: $V0, 16: 4, 21: $V1, 22: $V2, 24: $V3 }, { 1: [3] }, { 1: [2, 1] }, { 3: 10, 4: 2, 5: 3, 6: 5, 12: $V0, 16: 4, 21: $V1, 22: $V2, 24: $V3 }, o($V4, $V5, { 17: 11 }), { 7: 12, 13: [1, 13] }, { 16: 14, 21: $V1, 22: $V2, 24: $V3 }, { 16: 15, 21: $V1, 22: $V2, 24: $V3 }, { 25: [1, 16], 26: [1, 17] }, { 13: [2, 5] }, { 1: [2, 2] }, { 1: [2, 9], 18: 18, 19: 19, 20: $V6, 21: $V7, 22: $V8, 23: $V9, 32: 24, 33: 25, 34: 26, 35: 27, 36: 28, 37: 29, 38: $Va, 43: 31, 44: $Vb, 46: $Vc, 48: $Vd, 50: 35, 51: 45, 52: $Ve, 54: 46, 66: $Vf, 67: $Vg, 86: $Vh, 87: $Vi, 88: $Vj, 89: $Vk, 90: $Vl, 91: $Vm, 95: $Vn, 105: $Vo, 106: $Vp, 109: $Vq, 111: $Vr, 112: $Vs, 116: 47, 118: $Vt, 119: $Vu, 120: $Vv, 121: $Vw, 122: $Vx, 123: $Vy, 124: $Vz, 125: $VA, 126: $VB, 127: $VC }, { 8: 64, 10: [1, 65], 15: $VD }, o([10, 15], [2, 6]), o($V4, [2, 17]), o($V4, [2, 18]), o($V4, [2, 19]), { 20: [1, 68], 21: [1, 69], 22: $VE, 27: 67, 30: 70 }, o($VF, [2, 11]), o($VF, [2, 12]), o($VF, [2, 13]), o($VF, [2, 14]), o($VF, [2, 15]), o($VF, [2, 16]), { 9: 72, 20: $VG, 21: $VH, 23: $VI, 49: 73, 78: 77, 81: [1, 78], 82: [1, 79] }, { 9: 80, 20: $VG, 21: $VH, 23: $VI }, { 9: 81, 20: $VG, 21: $VH, 23: $VI }, { 9: 82, 20: $VG, 21: $VH, 23: $VI }, { 9: 83, 20: $VG, 21: $VH, 23: $VI }, { 9: 84, 20: $VG, 21: $VH, 23: $VI }, { 9: 86, 20: $VG, 21: $VH, 22: [1, 85], 23: $VI }, o($VF, [2, 44]), { 45: [1, 87] }, { 47: [1, 88] }, o($VF, [2, 47]), o($VJ, [2, 54], { 30: 89, 22: $VE }), { 22: [1, 90] }, { 22: [1, 91] }, { 22: [1, 92] }, { 22: [1, 93] }, { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 84: [1, 97], 91: $VO, 97: 96, 98: [1, 94], 100: [1, 95], 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 115: 100, 117: 98, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o($VF, [2, 158]), o($VF, [2, 159]), o($VF, [2, 160]), o($VF, [2, 161]), o($V_, [2, 55], { 53: [1, 116] }), o($V$, [2, 74], { 116: 129, 40: [1, 117], 52: $Ve, 55: [1, 118], 57: [1, 119], 59: [1, 120], 61: [1, 121], 63: [1, 122], 65: [1, 123], 66: $Vf, 67: $Vg, 69: [1, 124], 71: [1, 125], 73: [1, 126], 74: [1, 127], 76: [1, 128], 91: $Vm, 95: $Vn, 105: $Vo, 106: $Vp, 109: $Vq, 111: $Vr, 112: $Vs, 122: $Vx, 123: $Vy, 124: $Vz, 125: $VA, 126: $VB, 127: $VC }), o($V01, [2, 150]), o($V01, [2, 175]), o($V01, [2, 176]), o($V01, [2, 177]), o($V01, [2, 178]), o($V01, [2, 179]), o($V01, [2, 180]), o($V01, [2, 181]), o($V01, [2, 182]), o($V01, [2, 183]), o($V01, [2, 184]), o($V01, [2, 185]), o($V01, [2, 186]), o($V01, [2, 187]), o($V01, [2, 188]), o($V01, [2, 189]), o($V01, [2, 190]), { 9: 130, 20: $VG, 21: $VH, 23: $VI }, { 11: 131, 14: [1, 132] }, o($V11, [2, 8]), o($V4, [2, 20]), o($V4, [2, 26]), o($V4, [2, 27]), { 21: [1, 133] }, o($V21, [2, 34], { 30: 134, 22: $VE }), o($VF, [2, 35]), { 50: 135, 51: 45, 52: $Ve, 54: 46, 66: $Vf, 67: $Vg, 91: $Vm, 95: $Vn, 105: $Vo, 106: $Vp, 109: $Vq, 111: $Vr, 112: $Vs, 116: 47, 122: $Vx, 123: $Vy, 124: $Vz, 125: $VA, 126: $VB, 127: $VC }, o($V31, [2, 48]), o($V31, [2, 49]), o($V31, [2, 50]), o($V41, [2, 78], { 79: 136, 68: [1, 138], 80: [1, 137] }), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 139, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o([52, 66, 67, 68, 80, 91, 95, 105, 106, 109, 111, 112, 122, 123, 124, 125, 126, 127], [2, 80]), o($VF, [2, 36]), o($VF, [2, 37]), o($VF, [2, 38]), o($VF, [2, 39]), o($VF, [2, 40]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 163, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o($Vo1, $V5, { 17: 164 }), o($VF, [2, 45]), o($VF, [2, 46]), o($VJ, [2, 53], { 52: $Vp1 }), { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 97: 166, 102: [1, 167], 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 115: 100, 117: 98, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 95: [1, 168], 103: 169, 105: [1, 170] }, { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 95: [1, 171], 97: 172, 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 115: 100, 117: 98, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 97: 173, 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 115: 100, 117: 98, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o($V11, [2, 101], { 22: [1, 174], 99: [1, 175] }), o($V11, [2, 105], { 22: [1, 176] }), o($V11, [2, 109], { 115: 100, 117: 178, 22: [1, 177], 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }), o($V11, [2, 111], { 22: [1, 179] }), o($Vq1, [2, 152]), o($Vq1, [2, 154]), o($Vq1, [2, 155]), o($Vq1, [2, 156]), o($Vq1, [2, 157]), o($Vr1, [2, 162]), o($Vr1, [2, 163]), o($Vr1, [2, 164]), o($Vr1, [2, 165]), o($Vr1, [2, 166]), o($Vr1, [2, 167]), o($Vr1, [2, 168]), o($Vr1, [2, 169]), o($Vr1, [2, 170]), o($Vr1, [2, 171]), o($Vr1, [2, 172]), o($Vr1, [2, 173]), o($Vr1, [2, 174]), { 52: $Ve, 54: 180, 66: $Vf, 67: $Vg, 91: $Vm, 95: $Vn, 105: $Vo, 106: $Vp, 109: $Vq, 111: $Vr, 112: $Vs, 116: 47, 122: $Vx, 123: $Vy, 124: $Vz, 125: $VA, 126: $VB, 127: $VC }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 181, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 182, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 184, 42: $V91, 52: $VL, 57: [1, 183], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 185, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 186, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 187, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 66: [1, 188] }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 189, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 190, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 71: [1, 191], 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 192, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 193, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 194, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o($V01, [2, 151]), o($Vs1, [2, 3]), { 8: 195, 15: $VD }, { 15: [2, 7] }, o($V4, [2, 28]), o($V21, [2, 33]), o($VJ, [2, 51], { 30: 196, 22: $VE }), o($V41, [2, 75], { 22: [1, 197] }), { 22: [1, 198] }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 199, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 82: [1, 200], 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o($Vr1, [2, 82]), o($Vr1, [2, 84]), o($Vr1, [2, 140]), o($Vr1, [2, 141]), o($Vr1, [2, 142]), o($Vr1, [2, 143]), o($Vr1, [2, 144]), o($Vr1, [2, 145]), o($Vr1, [2, 146]), o($Vr1, [2, 147]), o($Vr1, [2, 148]), o($Vr1, [2, 149]), o($Vr1, [2, 85]), o($Vr1, [2, 86]), o($Vr1, [2, 87]), o($Vr1, [2, 88]), o($Vr1, [2, 89]), o($Vr1, [2, 90]), o($Vr1, [2, 91]), o($Vr1, [2, 92]), o($Vr1, [2, 93]), o($Vr1, [2, 94]), o($Vr1, [2, 95]), { 9: 203, 20: $VG, 21: $VH, 22: $V51, 23: $VI, 24: $V61, 26: $V71, 38: $V81, 40: [1, 202], 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 18: 18, 19: 19, 20: $V6, 21: $V7, 22: $V8, 23: $V9, 32: 24, 33: 25, 34: 26, 35: 27, 36: 28, 37: 29, 38: $Va, 42: [1, 204], 43: 31, 44: $Vb, 46: $Vc, 48: $Vd, 50: 35, 51: 45, 52: $Ve, 54: 46, 66: $Vf, 67: $Vg, 86: $Vh, 87: $Vi, 88: $Vj, 89: $Vk, 90: $Vl, 91: $Vm, 95: $Vn, 105: $Vo, 106: $Vp, 109: $Vq, 111: $Vr, 112: $Vs, 116: 47, 118: $Vt, 119: $Vu, 120: $Vv, 121: $Vw, 122: $Vx, 123: $Vy, 124: $Vz, 125: $VA, 126: $VB, 127: $VC }, { 22: $VE, 30: 205 }, { 22: [1, 206], 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 115: 100, 117: 178, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: [1, 207] }, { 22: [1, 208] }, { 22: [1, 209], 106: [1, 210] }, o($Vt1, [2, 123]), { 22: [1, 211] }, { 22: [1, 212], 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 115: 100, 117: 178, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: [1, 213], 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 115: 100, 117: 178, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 84: [1, 214] }, o($V11, [2, 103], { 22: [1, 215] }), { 84: [1, 216], 101: [1, 217] }, { 84: [1, 218] }, o($Vq1, [2, 153]), { 84: [1, 219], 101: [1, 220] }, o($V_, [2, 57], { 116: 129, 52: $Ve, 66: $Vf, 67: $Vg, 91: $Vm, 95: $Vn, 105: $Vo, 106: $Vp, 109: $Vq, 111: $Vr, 112: $Vs, 122: $Vx, 123: $Vy, 124: $Vz, 125: $VA, 126: $VB, 127: $VC }), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 41: [1, 221], 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 56: [1, 222], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 223, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 58: [1, 224], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 60: [1, 225], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 62: [1, 226], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 64: [1, 227], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 67: [1, 228] }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 70: [1, 229], 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 72: [1, 230], 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 231, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 41: [1, 232], 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 75: [1, 233], 77: [1, 234], 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 75: [1, 236], 77: [1, 235], 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 9: 237, 20: $VG, 21: $VH, 23: $VI }, o($VJ, [2, 52], { 52: $Vp1 }), o($V41, [2, 77]), o($V41, [2, 76]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 68: [1, 238], 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o($V41, [2, 79]), o($Vr1, [2, 83]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 239, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o($Vo1, $V5, { 17: 240 }), o($VF, [2, 43]), { 51: 241, 52: $Ve, 54: 46, 66: $Vf, 67: $Vg, 91: $Vm, 95: $Vn, 105: $Vo, 106: $Vp, 109: $Vq, 111: $Vr, 112: $Vs, 116: 47, 122: $Vx, 123: $Vy, 124: $Vz, 125: $VA, 126: $VB, 127: $VC }, { 22: $Vu1, 66: $Vv1, 67: $Vw1, 86: $Vx1, 96: 242, 102: $Vy1, 105: $Vz1, 107: 243, 108: 244, 109: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1 }, { 22: $Vu1, 66: $Vv1, 67: $Vw1, 86: $Vx1, 96: 256, 102: $Vy1, 105: $Vz1, 107: 243, 108: 244, 109: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1 }, { 22: $Vu1, 66: $Vv1, 67: $Vw1, 86: $Vx1, 96: 257, 102: $Vy1, 104: [1, 258], 105: $Vz1, 107: 243, 108: 244, 109: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1 }, { 22: $Vu1, 66: $Vv1, 67: $Vw1, 86: $Vx1, 96: 259, 102: $Vy1, 104: [1, 260], 105: $Vz1, 107: 243, 108: 244, 109: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1 }, { 105: [1, 261] }, { 22: $Vu1, 66: $Vv1, 67: $Vw1, 86: $Vx1, 96: 262, 102: $Vy1, 105: $Vz1, 107: 243, 108: 244, 109: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1 }, { 22: $Vu1, 66: $Vv1, 67: $Vw1, 86: $Vx1, 96: 263, 102: $Vy1, 105: $Vz1, 107: 243, 108: 244, 109: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1 }, { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 97: 264, 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 115: 100, 117: 98, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o($V11, [2, 102]), { 84: [1, 265] }, o($V11, [2, 106], { 22: [1, 266] }), o($V11, [2, 107]), o($V11, [2, 110]), o($V11, [2, 112], { 22: [1, 267] }), o($V11, [2, 113]), o($V$, [2, 58]), o($V$, [2, 59]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 58: [1, 268], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o($V$, [2, 66]), o($V$, [2, 61]), o($V$, [2, 62]), o($V$, [2, 63]), { 66: [1, 269] }, o($V$, [2, 65]), o($V$, [2, 67]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 72: [1, 270], 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o($V$, [2, 69]), o($V$, [2, 70]), o($V$, [2, 72]), o($V$, [2, 71]), o($V$, [2, 73]), o($Vs1, [2, 4]), o([22, 52, 66, 67, 91, 95, 105, 106, 109, 111, 112, 122, 123, 124, 125, 126, 127], [2, 81]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 41: [1, 271], 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 18: 18, 19: 19, 20: $V6, 21: $V7, 22: $V8, 23: $V9, 32: 24, 33: 25, 34: 26, 35: 27, 36: 28, 37: 29, 38: $Va, 42: [1, 272], 43: 31, 44: $Vb, 46: $Vc, 48: $Vd, 50: 35, 51: 45, 52: $Ve, 54: 46, 66: $Vf, 67: $Vg, 86: $Vh, 87: $Vi, 88: $Vj, 89: $Vk, 90: $Vl, 91: $Vm, 95: $Vn, 105: $Vo, 106: $Vp, 109: $Vq, 111: $Vr, 112: $Vs, 116: 47, 118: $Vt, 119: $Vu, 120: $Vv, 121: $Vw, 122: $Vx, 123: $Vy, 124: $Vz, 125: $VA, 126: $VB, 127: $VC }, o($V_, [2, 56]), o($V11, [2, 115], { 106: $VF1 }), o($VG1, [2, 125], { 108: 274, 22: $Vu1, 66: $Vv1, 67: $Vw1, 86: $Vx1, 102: $Vy1, 105: $Vz1, 109: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1 }), o($VH1, [2, 127]), o($VH1, [2, 129]), o($VH1, [2, 130]), o($VH1, [2, 131]), o($VH1, [2, 132]), o($VH1, [2, 133]), o($VH1, [2, 134]), o($VH1, [2, 135]), o($VH1, [2, 136]), o($VH1, [2, 137]), o($VH1, [2, 138]), o($VH1, [2, 139]), o($V11, [2, 116], { 106: $VF1 }), o($V11, [2, 117], { 106: $VF1 }), { 22: [1, 275] }, o($V11, [2, 118], { 106: $VF1 }), { 22: [1, 276] }, o($Vt1, [2, 124]), o($V11, [2, 98], { 106: $VF1 }), o($V11, [2, 99], { 106: $VF1 }), o($V11, [2, 100], { 115: 100, 117: 178, 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }), o($V11, [2, 104]), { 101: [1, 277] }, { 101: [1, 278] }, { 58: [1, 279] }, { 68: [1, 280] }, { 72: [1, 281] }, { 9: 282, 20: $VG, 21: $VH, 23: $VI }, o($VF, [2, 42]), { 22: $Vu1, 66: $Vv1, 67: $Vw1, 86: $Vx1, 102: $Vy1, 105: $Vz1, 107: 283, 108: 244, 109: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1 }, o($VH1, [2, 128]), { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 97: 284, 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 115: 100, 117: 98, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 97: 285, 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 115: 100, 117: 98, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o($V11, [2, 108]), o($V11, [2, 114]), o($V$, [2, 60]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 286, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, o($V$, [2, 68]), o($Vo1, $V5, { 17: 287 }), o($VG1, [2, 126], { 108: 274, 22: $Vu1, 66: $Vv1, 67: $Vw1, 86: $Vx1, 102: $Vy1, 105: $Vz1, 109: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1 }), o($V11, [2, 121], { 115: 100, 117: 178, 22: [1, 288], 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }), o($V11, [2, 122], { 115: 100, 117: 178, 22: [1, 289], 26: $VK, 52: $VL, 66: $VM, 67: $VN, 91: $VO, 105: $VP, 106: $VQ, 109: $VR, 111: $VS, 112: $VT, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 41: [1, 290], 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 201, 85: 151, 86: $Vd1, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 94: 142, 95: $Vk1, 105: $VP, 106: $VQ, 109: $Vl1, 111: $VS, 112: $VT, 113: $Vm1, 114: $Vn1, 115: 148, 122: $VU, 123: $VV, 124: $VW, 125: $VX, 126: $VY, 127: $VZ }, { 18: 18, 19: 19, 20: $V6, 21: $V7, 22: $V8, 23: $V9, 32: 24, 33: 25, 34: 26, 35: 27, 36: 28, 37: 29, 38: $Va, 42: [1, 291], 43: 31, 44: $Vb, 46: $Vc, 48: $Vd, 50: 35, 51: 45, 52: $Ve, 54: 46, 66: $Vf, 67: $Vg, 86: $Vh, 87: $Vi, 88: $Vj, 89: $Vk, 90: $Vl, 91: $Vm, 95: $Vn, 105: $Vo, 106: $Vp, 109: $Vq, 111: $Vr, 112: $Vs, 116: 47, 118: $Vt, 119: $Vu, 120: $Vv, 121: $Vw, 122: $Vx, 123: $Vy, 124: $Vz, 125: $VA, 126: $VB, 127: $VC }, { 22: $Vu1, 66: $Vv1, 67: $Vw1, 86: $Vx1, 96: 292, 102: $Vy1, 105: $Vz1, 107: 243, 108: 244, 109: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1 }, { 22: $Vu1, 66: $Vv1, 67: $Vw1, 86: $Vx1, 96: 293, 102: $Vy1, 105: $Vz1, 107: 243, 108: 244, 109: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1 }, o($V$, [2, 64]), o($VF, [2, 41]), o($V11, [2, 119], { 106: $VF1 }), o($V11, [2, 120], { 106: $VF1 })],
    defaultActions: { 2: [2, 1], 9: [2, 5], 10: [2, 2], 132: [2, 7] },
    parseError: function parseError(str2, hash) {
      if (hash.recoverable) {
        this.trace(str2);
      } else {
        var error = new Error(str2);
        error.hash = hash;
        throw error;
      }
    },
    parse: function parse2(input) {
      var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
      var args = lstack.slice.call(arguments, 1);
      var lexer2 = Object.create(this.lexer);
      var sharedState = { yy: {} };
      for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
          sharedState.yy[k] = this.yy[k];
        }
      }
      lexer2.setInput(input, sharedState.yy);
      sharedState.yy.lexer = lexer2;
      sharedState.yy.parser = this;
      if (typeof lexer2.yylloc == "undefined") {
        lexer2.yylloc = {};
      }
      var yyloc = lexer2.yylloc;
      lstack.push(yyloc);
      var ranges = lexer2.options && lexer2.options.ranges;
      if (typeof sharedState.yy.parseError === "function") {
        this.parseError = sharedState.yy.parseError;
      } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
      }
      function lex2() {
        var token;
        token = tstack.pop() || lexer2.lex() || EOF;
        if (typeof token !== "number") {
          if (token instanceof Array) {
            tstack = token;
            token = tstack.pop();
          }
          token = self.symbols_[token] || token;
        }
        return token;
      }
      var symbol, state, action, r, yyval = {}, p, len, newState, expected;
      while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
          action = this.defaultActions[state];
        } else {
          if (symbol === null || typeof symbol == "undefined") {
            symbol = lex2();
          }
          action = table[state] && table[state][symbol];
        }
        if (typeof action === "undefined" || !action.length || !action[0]) {
          var errStr = "";
          expected = [];
          for (p in table[state]) {
            if (this.terminals_[p] && p > TERROR) {
              expected.push("'" + this.terminals_[p] + "'");
            }
          }
          if (lexer2.showPosition) {
            errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
          } else {
            errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
          }
          this.parseError(errStr, {
            text: lexer2.match,
            token: this.terminals_[symbol] || symbol,
            line: lexer2.yylineno,
            loc: yyloc,
            expected
          });
        }
        if (action[0] instanceof Array && action.length > 1) {
          throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
        }
        switch (action[0]) {
          case 1:
            stack.push(symbol);
            vstack.push(lexer2.yytext);
            lstack.push(lexer2.yylloc);
            stack.push(action[1]);
            symbol = null;
            {
              yyleng = lexer2.yyleng;
              yytext = lexer2.yytext;
              yylineno = lexer2.yylineno;
              yyloc = lexer2.yylloc;
            }
            break;
          case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
              first_line: lstack[lstack.length - (len || 1)].first_line,
              last_line: lstack[lstack.length - 1].last_line,
              first_column: lstack[lstack.length - (len || 1)].first_column,
              last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
              yyval._$.range = [
                lstack[lstack.length - (len || 1)].range[0],
                lstack[lstack.length - 1].range[1]
              ];
            }
            r = this.performAction.apply(yyval, [
              yytext,
              yyleng,
              yylineno,
              sharedState.yy,
              action[1],
              vstack,
              lstack
            ].concat(args));
            if (typeof r !== "undefined") {
              return r;
            }
            if (len) {
              stack = stack.slice(0, -1 * len * 2);
              vstack = vstack.slice(0, -1 * len);
              lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
          case 3:
            return true;
        }
      }
      return true;
    }
  };
  var lexer = function() {
    var lexer2 = {
      EOF: 1,
      parseError: function parseError(str2, hash) {
        if (this.yy.parser) {
          this.yy.parser.parseError(str2, hash);
        } else {
          throw new Error(str2);
        }
      },
      // resets the lexer, sets new input
      setInput: function(input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = "";
        this.conditionStack = ["INITIAL"];
        this.yylloc = {
          first_line: 1,
          first_column: 0,
          last_line: 1,
          last_column: 0
        };
        if (this.options.ranges) {
          this.yylloc.range = [0, 0];
        }
        this.offset = 0;
        return this;
      },
      // consumes and returns one char from the input
      input: function() {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno++;
          this.yylloc.last_line++;
        } else {
          this.yylloc.last_column++;
        }
        if (this.options.ranges) {
          this.yylloc.range[1]++;
        }
        this._input = this._input.slice(1);
        return ch;
      },
      // unshifts one char (or a string) into the input
      unput: function(ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);
        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);
        if (lines.length - 1) {
          this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;
        this.yylloc = {
          first_line: this.yylloc.first_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.first_column,
          last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
        };
        if (this.options.ranges) {
          this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
      },
      // When called from action, caches matched text and appends it on next action
      more: function() {
        this._more = true;
        return this;
      },
      // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
      reject: function() {
        if (this.options.backtrack_lexer) {
          this._backtrack = true;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
        return this;
      },
      // retain first n characters of the match
      less: function(n) {
        this.unput(this.match.slice(n));
      },
      // displays already matched input, i.e. for error messages
      pastInput: function() {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
      },
      // displays upcoming input, i.e. for error messages
      upcomingInput: function() {
        var next = this.match;
        if (next.length < 20) {
          next += this._input.substr(0, 20 - next.length);
        }
        return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
      },
      // displays the character position where the lexing error occurred, i.e. for error messages
      showPosition: function() {
        var pre = this.pastInput();
        var c2 = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c2 + "^";
      },
      // test the lexed token: return FALSE when not a match, otherwise return token
      test_match: function(match, indexed_rule) {
        var token, lines, backup;
        if (this.options.backtrack_lexer) {
          backup = {
            yylineno: this.yylineno,
            yylloc: {
              first_line: this.yylloc.first_line,
              last_line: this.last_line,
              first_column: this.yylloc.first_column,
              last_column: this.yylloc.last_column
            },
            yytext: this.yytext,
            match: this.match,
            matches: this.matches,
            matched: this.matched,
            yyleng: this.yyleng,
            offset: this.offset,
            _more: this._more,
            _input: this._input,
            yy: this.yy,
            conditionStack: this.conditionStack.slice(0),
            done: this.done
          };
          if (this.options.ranges) {
            backup.yylloc.range = this.yylloc.range.slice(0);
          }
        }
        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno += lines.length;
        }
        this.yylloc = {
          first_line: this.yylloc.last_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.last_column,
          last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
          this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
          this.done = false;
        }
        if (token) {
          return token;
        } else if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
        return false;
      },
      // return next match in input
      next: function() {
        if (this.done) {
          return this.EOF;
        }
        if (!this._input) {
          this.done = true;
        }
        var token, match, tempMatch, index;
        if (!this._more) {
          this.yytext = "";
          this.match = "";
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
          tempMatch = this._input.match(this.rules[rules[i]]);
          if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
            match = tempMatch;
            index = i;
            if (this.options.backtrack_lexer) {
              token = this.test_match(tempMatch, rules[i]);
              if (token !== false) {
                return token;
              } else if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            } else if (!this.options.flex) {
              break;
            }
          }
        }
        if (match) {
          token = this.test_match(match, rules[index]);
          if (token !== false) {
            return token;
          }
          return false;
        }
        if (this._input === "") {
          return this.EOF;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
      },
      // return next match that has a token
      lex: function lex2() {
        var r = this.next();
        if (r) {
          return r;
        } else {
          return this.lex();
        }
      },
      // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
      begin: function begin(condition) {
        this.conditionStack.push(condition);
      },
      // pop the previously active lexer condition state off the condition stack
      popState: function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
          return this.conditionStack.pop();
        } else {
          return this.conditionStack[0];
        }
      },
      // produce the lexer rule set which is active for the currently active lexer condition state
      _currentRules: function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
          return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
          return this.conditions["INITIAL"].rules;
        }
      },
      // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
      topState: function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
          return this.conditionStack[n];
        } else {
          return "INITIAL";
        }
      },
      // alias for begin(condition)
      pushState: function pushState(condition) {
        this.begin(condition);
      },
      // return the number of states currently on the stack
      stateStackSize: function stateStackSize() {
        return this.conditionStack.length;
      },
      options: {},
      performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
        switch ($avoiding_name_collisions) {
          case 0:
            this.begin("open_directive");
            return 12;
          case 1:
            this.begin("type_directive");
            return 13;
          case 2:
            this.popState();
            this.begin("arg_directive");
            return 10;
          case 3:
            this.popState();
            this.popState();
            return 15;
          case 4:
            return 14;
          case 5:
            break;
          case 6:
            break;
          case 7:
            this.begin("acc_title");
            return 44;
          case 8:
            this.popState();
            return "acc_title_value";
          case 9:
            this.begin("acc_descr");
            return 46;
          case 10:
            this.popState();
            return "acc_descr_value";
          case 11:
            this.begin("acc_descr_multiline");
            break;
          case 12:
            this.popState();
            break;
          case 13:
            return "acc_descr_multiline_value";
          case 14:
            this.begin("string");
            break;
          case 15:
            this.popState();
            break;
          case 16:
            return "STR";
          case 17:
            return 86;
          case 18:
            return 95;
          case 19:
            return 87;
          case 20:
            return 104;
          case 21:
            return 88;
          case 22:
            return 89;
          case 23:
            this.begin("href");
            break;
          case 24:
            this.popState();
            break;
          case 25:
            return 100;
          case 26:
            this.begin("callbackname");
            break;
          case 27:
            this.popState();
            break;
          case 28:
            this.popState();
            this.begin("callbackargs");
            break;
          case 29:
            return 98;
          case 30:
            this.popState();
            break;
          case 31:
            return 99;
          case 32:
            this.begin("click");
            break;
          case 33:
            this.popState();
            break;
          case 34:
            return 90;
          case 35:
            if (yy.lex.firstGraph()) {
              this.begin("dir");
            }
            return 24;
          case 36:
            if (yy.lex.firstGraph()) {
              this.begin("dir");
            }
            return 24;
          case 37:
            if (yy.lex.firstGraph()) {
              this.begin("dir");
            }
            return 24;
          case 38:
            return 38;
          case 39:
            return 42;
          case 40:
            return 101;
          case 41:
            return 101;
          case 42:
            return 101;
          case 43:
            return 101;
          case 44:
            this.popState();
            return 25;
          case 45:
            this.popState();
            return 26;
          case 46:
            this.popState();
            return 26;
          case 47:
            this.popState();
            return 26;
          case 48:
            this.popState();
            return 26;
          case 49:
            this.popState();
            return 26;
          case 50:
            this.popState();
            return 26;
          case 51:
            this.popState();
            return 26;
          case 52:
            this.popState();
            return 26;
          case 53:
            this.popState();
            return 26;
          case 54:
            this.popState();
            return 26;
          case 55:
            return 118;
          case 56:
            return 119;
          case 57:
            return 120;
          case 58:
            return 121;
          case 59:
            return 105;
          case 60:
            return 111;
          case 61:
            return 53;
          case 62:
            return 67;
          case 63:
            return 52;
          case 64:
            return 20;
          case 65:
            return 106;
          case 66:
            return 126;
          case 67:
            return 82;
          case 68:
            return 82;
          case 69:
            return 82;
          case 70:
            return 81;
          case 71:
            return 81;
          case 72:
            return 81;
          case 73:
            return 59;
          case 74:
            return 60;
          case 75:
            return 61;
          case 76:
            return 62;
          case 77:
            return 63;
          case 78:
            return 64;
          case 79:
            return 65;
          case 80:
            return 69;
          case 81:
            return 70;
          case 82:
            return 55;
          case 83:
            return 56;
          case 84:
            return 109;
          case 85:
            return 112;
          case 86:
            return 127;
          case 87:
            return 124;
          case 88:
            return 113;
          case 89:
            return 125;
          case 90:
            return 125;
          case 91:
            return 114;
          case 92:
            return 73;
          case 93:
            return 92;
          case 94:
            return "SEP";
          case 95:
            return 91;
          case 96:
            return 66;
          case 97:
            return 75;
          case 98:
            return 74;
          case 99:
            return 77;
          case 100:
            return 76;
          case 101:
            return 122;
          case 102:
            return 123;
          case 103:
            return 68;
          case 104:
            return 57;
          case 105:
            return 58;
          case 106:
            return 40;
          case 107:
            return 41;
          case 108:
            return 71;
          case 109:
            return 72;
          case 110:
            return 133;
          case 111:
            return 21;
          case 112:
            return 22;
          case 113:
            return 23;
        }
      },
      rules: [/^(?:%%\{)/, /^(?:((?:(?!\}%%)[^:.])*))/, /^(?::)/, /^(?:\}%%)/, /^(?:((?:(?!\}%%).|\n)*))/, /^(?:%%(?!\{)[^\n]*)/, /^(?:[^\}]%%[^\n]*)/, /^(?:accTitle\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*\{\s*)/, /^(?:[\}])/, /^(?:[^\}]*)/, /^(?:["])/, /^(?:["])/, /^(?:[^"]*)/, /^(?:style\b)/, /^(?:default\b)/, /^(?:linkStyle\b)/, /^(?:interpolate\b)/, /^(?:classDef\b)/, /^(?:class\b)/, /^(?:href[\s]+["])/, /^(?:["])/, /^(?:[^"]*)/, /^(?:call[\s]+)/, /^(?:\([\s]*\))/, /^(?:\()/, /^(?:[^(]*)/, /^(?:\))/, /^(?:[^)]*)/, /^(?:click[\s]+)/, /^(?:[\s\n])/, /^(?:[^\s\n]*)/, /^(?:flowchart-elk\b)/, /^(?:graph\b)/, /^(?:flowchart\b)/, /^(?:subgraph\b)/, /^(?:end\b\s*)/, /^(?:_self\b)/, /^(?:_blank\b)/, /^(?:_parent\b)/, /^(?:_top\b)/, /^(?:(\r?\n)*\s*\n)/, /^(?:\s*LR\b)/, /^(?:\s*RL\b)/, /^(?:\s*TB\b)/, /^(?:\s*BT\b)/, /^(?:\s*TD\b)/, /^(?:\s*BR\b)/, /^(?:\s*<)/, /^(?:\s*>)/, /^(?:\s*\^)/, /^(?:\s*v\b)/, /^(?:.*direction\s+TB[^\n]*)/, /^(?:.*direction\s+BT[^\n]*)/, /^(?:.*direction\s+RL[^\n]*)/, /^(?:.*direction\s+LR[^\n]*)/, /^(?:[0-9]+)/, /^(?:#)/, /^(?::::)/, /^(?::)/, /^(?:&)/, /^(?:;)/, /^(?:,)/, /^(?:\*)/, /^(?:\s*[xo<]?--+[-xo>]\s*)/, /^(?:\s*[xo<]?==+[=xo>]\s*)/, /^(?:\s*[xo<]?-?\.+-[xo>]?\s*)/, /^(?:\s*[xo<]?--\s*)/, /^(?:\s*[xo<]?==\s*)/, /^(?:\s*[xo<]?-\.\s*)/, /^(?:\(-)/, /^(?:-\))/, /^(?:\(\[)/, /^(?:\]\))/, /^(?:\[\[)/, /^(?:\]\])/, /^(?:\[\|)/, /^(?:\[\()/, /^(?:\)\])/, /^(?:\(\(\()/, /^(?:\)\)\))/, /^(?:-)/, /^(?:\.)/, /^(?:[\_])/, /^(?:\+)/, /^(?:%)/, /^(?:=)/, /^(?:=)/, /^(?:<)/, /^(?:>)/, /^(?:\^)/, /^(?:\\\|)/, /^(?:v\b)/, /^(?:[A-Za-z]+)/, /^(?:\\\])/, /^(?:\[\/)/, /^(?:\/\])/, /^(?:\[\\)/, /^(?:[!"#$%&'*+,-.`?\\_/])/, /^(?:[\u00AA\u00B5\u00BA\u00C0-\u00D6\u00D8-\u00F6]|[\u00F8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377]|[\u037A-\u037D\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5]|[\u03F7-\u0481\u048A-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA]|[\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE]|[\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA]|[\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0]|[\u08A2-\u08AC\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0977]|[\u0979-\u097F\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2]|[\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A]|[\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39]|[\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8]|[\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C]|[\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C]|[\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99]|[\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0]|[\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C33\u0C35-\u0C39\u0C3D]|[\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3]|[\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10]|[\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1]|[\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81]|[\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3]|[\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6]|[\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A]|[\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081]|[\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D]|[\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0]|[\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310]|[\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C]|[\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u1700-\u170C\u170E-\u1711]|[\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7]|[\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191C]|[\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16]|[\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF]|[\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC]|[\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D]|[\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D]|[\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3]|[\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F]|[\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128]|[\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184]|[\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3]|[\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6]|[\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE]|[\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C]|[\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D]|[\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC]|[\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B]|[\uA640-\uA66E\uA67F-\uA697\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788]|[\uA78B-\uA78E\uA790-\uA793\uA7A0-\uA7AA\uA7F8-\uA801\uA803-\uA805]|[\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB]|[\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uAA00-\uAA28]|[\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA80-\uAAAF\uAAB1\uAAB5]|[\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4]|[\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E]|[\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D]|[\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36]|[\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D]|[\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC]|[\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF]|[\uFFD2-\uFFD7\uFFDA-\uFFDC])/, /^(?:\|)/, /^(?:\()/, /^(?:\))/, /^(?:\[)/, /^(?:\])/, /^(?:\{)/, /^(?:\})/, /^(?:")/, /^(?:(\r?\n)+)/, /^(?:\s)/, /^(?:$)/],
      conditions: { "close_directive": { "rules": [], "inclusive": false }, "arg_directive": { "rules": [3, 4], "inclusive": false }, "type_directive": { "rules": [2, 3], "inclusive": false }, "open_directive": { "rules": [1], "inclusive": false }, "callbackargs": { "rules": [30, 31], "inclusive": false }, "callbackname": { "rules": [27, 28, 29], "inclusive": false }, "href": { "rules": [24, 25], "inclusive": false }, "click": { "rules": [33, 34], "inclusive": false }, "vertex": { "rules": [], "inclusive": false }, "dir": { "rules": [44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54], "inclusive": false }, "acc_descr_multiline": { "rules": [12, 13], "inclusive": false }, "acc_descr": { "rules": [10], "inclusive": false }, "acc_title": { "rules": [8], "inclusive": false }, "string": { "rules": [15, 16], "inclusive": false }, "INITIAL": { "rules": [0, 5, 6, 7, 9, 11, 14, 17, 18, 19, 20, 21, 22, 23, 26, 32, 35, 36, 37, 38, 39, 40, 41, 42, 43, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113], "inclusive": true } }
    };
    return lexer2;
  }();
  parser2.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  Parser.prototype = parser2;
  parser2.Parser = Parser;
  return new Parser();
}();
parser$7.parser = parser$7;
const parser$8 = parser$7;
const flowDetector = (txt, config2) => {
  var _a, _b;
  if (((_a = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _a.defaultRenderer) === "dagre-wrapper") {
    return false;
  }
  if (((_b = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _b.defaultRenderer) === "elk") {
    return false;
  }
  return txt.match(/^\s*graph/) !== null;
};
const flowDetectorV2 = (txt, config2) => {
  var _a, _b;
  if (((_a = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _a.defaultRenderer) === "dagre-d3") {
    return false;
  }
  if (((_b = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _b.defaultRenderer) === "elk") {
    return false;
  }
  if (txt.match(/^\s*graph/) !== null) {
    return true;
  }
  return txt.match(/^\s*flowchart/) !== null;
};
const MERMAID_DOM_ID_PREFIX = "flowchart-";
let vertexCounter = 0;
let config = getConfig$1();
let vertices = {};
let edges = [];
let classes$1 = {};
let subGraphs = [];
let subGraphLookup = {};
let tooltips = {};
let subCount = 0;
let firstGraphFlag = true;
let direction$1;
let version;
let funs$1 = [];
const sanitizeText = (txt) => common$1.sanitizeText(txt, config);
const parseDirective$6 = function(statement, context, type2) {
  mermaidAPI.parseDirective(this, statement, context, type2);
};
const lookUpDomId = function(id2) {
  const veritceKeys = Object.keys(vertices);
  for (const veritceKey of veritceKeys) {
    if (vertices[veritceKey].id === id2) {
      return vertices[veritceKey].domId;
    }
  }
  return id2;
};
const addVertex = function(_id, text, type2, style, classes2, dir, props = {}) {
  let txt;
  let id2 = _id;
  if (id2 === void 0) {
    return;
  }
  if (id2.trim().length === 0) {
    return;
  }
  if (vertices[id2] === void 0) {
    vertices[id2] = {
      id: id2,
      domId: MERMAID_DOM_ID_PREFIX + id2 + "-" + vertexCounter,
      styles: [],
      classes: []
    };
  }
  vertexCounter++;
  if (text !== void 0) {
    config = getConfig$1();
    txt = sanitizeText(text.trim());
    if (txt[0] === '"' && txt[txt.length - 1] === '"') {
      txt = txt.substring(1, txt.length - 1);
    }
    vertices[id2].text = txt;
  } else {
    if (vertices[id2].text === void 0) {
      vertices[id2].text = _id;
    }
  }
  if (type2 !== void 0) {
    vertices[id2].type = type2;
  }
  if (style !== void 0 && style !== null) {
    style.forEach(function(s) {
      vertices[id2].styles.push(s);
    });
  }
  if (classes2 !== void 0 && classes2 !== null) {
    classes2.forEach(function(s) {
      vertices[id2].classes.push(s);
    });
  }
  if (dir !== void 0) {
    vertices[id2].dir = dir;
  }
  if (vertices[id2].props === void 0) {
    vertices[id2].props = props;
  } else if (props !== void 0) {
    Object.assign(vertices[id2].props, props);
  }
};
const addSingleLink = function(_start, _end, type2, linkText) {
  let start2 = _start;
  let end2 = _end;
  const edge = { start: start2, end: end2, type: void 0, text: "" };
  linkText = type2.text;
  if (linkText !== void 0) {
    edge.text = sanitizeText(linkText.trim());
    if (edge.text[0] === '"' && edge.text[edge.text.length - 1] === '"') {
      edge.text = edge.text.substring(1, edge.text.length - 1);
    }
  }
  if (type2 !== void 0) {
    edge.type = type2.type;
    edge.stroke = type2.stroke;
    edge.length = type2.length;
  }
  edges.push(edge);
};
const addLink = function(_start, _end, type2, linktext) {
  let i, j;
  for (i = 0; i < _start.length; i++) {
    for (j = 0; j < _end.length; j++) {
      addSingleLink(_start[i], _end[j], type2, linktext);
    }
  }
};
const updateLinkInterpolate = function(positions, interp) {
  positions.forEach(function(pos) {
    if (pos === "default") {
      edges.defaultInterpolate = interp;
    } else {
      edges[pos].interpolate = interp;
    }
  });
};
const updateLink = function(positions, style) {
  positions.forEach(function(pos) {
    if (pos === "default") {
      edges.defaultStyle = style;
    } else {
      if (utils.isSubstringInArray("fill", style) === -1) {
        style.push("fill:none");
      }
      edges[pos].style = style;
    }
  });
};
const addClass = function(id2, style) {
  if (classes$1[id2] === void 0) {
    classes$1[id2] = { id: id2, styles: [], textStyles: [] };
  }
  if (style !== void 0 && style !== null) {
    style.forEach(function(s) {
      if (s.match("color")) {
        const newStyle1 = s.replace("fill", "bgFill");
        const newStyle2 = newStyle1.replace("color", "fill");
        classes$1[id2].textStyles.push(newStyle2);
      }
      classes$1[id2].styles.push(s);
    });
  }
};
const setDirection$1 = function(dir) {
  direction$1 = dir;
  if (direction$1.match(/.*</)) {
    direction$1 = "RL";
  }
  if (direction$1.match(/.*\^/)) {
    direction$1 = "BT";
  }
  if (direction$1.match(/.*>/)) {
    direction$1 = "LR";
  }
  if (direction$1.match(/.*v/)) {
    direction$1 = "TB";
  }
  if (direction$1 === "TD") {
    direction$1 = "TB";
  }
};
const setClass$1 = function(ids, className) {
  ids.split(",").forEach(function(_id) {
    let id2 = _id;
    if (vertices[id2] !== void 0) {
      vertices[id2].classes.push(className);
    }
    if (subGraphLookup[id2] !== void 0) {
      subGraphLookup[id2].classes.push(className);
    }
  });
};
const setTooltip = function(ids, tooltip) {
  ids.split(",").forEach(function(id2) {
    if (tooltip !== void 0) {
      tooltips[version === "gen-1" ? lookUpDomId(id2) : id2] = sanitizeText(tooltip);
    }
  });
};
const setClickFun$1 = function(id2, functionName, functionArgs) {
  let domId = lookUpDomId(id2);
  if (getConfig$1().securityLevel !== "loose") {
    return;
  }
  if (functionName === void 0) {
    return;
  }
  let argList = [];
  if (typeof functionArgs === "string") {
    argList = functionArgs.split(/,(?=(?:(?:[^"]*"){2})*[^"]*$)/);
    for (let i = 0; i < argList.length; i++) {
      let item = argList[i].trim();
      if (item.charAt(0) === '"' && item.charAt(item.length - 1) === '"') {
        item = item.substr(1, item.length - 2);
      }
      argList[i] = item;
    }
  }
  if (argList.length === 0) {
    argList.push(id2);
  }
  if (vertices[id2] !== void 0) {
    vertices[id2].haveCallback = true;
    funs$1.push(function() {
      const elem = document.querySelector(`[id="${domId}"]`);
      if (elem !== null) {
        elem.addEventListener(
          "click",
          function() {
            utils.runFunc(functionName, ...argList);
          },
          false
        );
      }
    });
  }
};
const setLink$1 = function(ids, linkStr, target) {
  ids.split(",").forEach(function(id2) {
    if (vertices[id2] !== void 0) {
      vertices[id2].link = utils.formatUrl(linkStr, config);
      vertices[id2].linkTarget = target;
    }
  });
  setClass$1(ids, "clickable");
};
const getTooltip = function(id2) {
  return tooltips[id2];
};
const setClickEvent$1 = function(ids, functionName, functionArgs) {
  ids.split(",").forEach(function(id2) {
    setClickFun$1(id2, functionName, functionArgs);
  });
  setClass$1(ids, "clickable");
};
const bindFunctions$1 = function(element) {
  funs$1.forEach(function(fun) {
    fun(element);
  });
};
const getDirection$1 = function() {
  return direction$1.trim();
};
const getVertices = function() {
  return vertices;
};
const getEdges = function() {
  return edges;
};
const getClasses$4 = function() {
  return classes$1;
};
const setupToolTips = function(element) {
  let tooltipElem = select(".mermaidTooltip");
  if ((tooltipElem._groups || tooltipElem)[0][0] === null) {
    tooltipElem = select("body").append("div").attr("class", "mermaidTooltip").style("opacity", 0);
  }
  const svg = select(element).select("svg");
  const nodes = svg.selectAll("g.node");
  nodes.on("mouseover", function() {
    const el = select(this);
    const title2 = el.attr("title");
    if (title2 === null) {
      return;
    }
    const rect2 = this.getBoundingClientRect();
    tooltipElem.transition().duration(200).style("opacity", ".9");
    tooltipElem.text(el.attr("title")).style("left", window.scrollX + rect2.left + (rect2.right - rect2.left) / 2 + "px").style("top", window.scrollY + rect2.top - 14 + document.body.scrollTop + "px");
    tooltipElem.html(tooltipElem.html().replace(/&lt;br\/&gt;/g, "<br/>"));
    el.classed("hover", true);
  }).on("mouseout", function() {
    tooltipElem.transition().duration(500).style("opacity", 0);
    const el = select(this);
    el.classed("hover", false);
  });
};
funs$1.push(setupToolTips);
const clear$6 = function(ver = "gen-1") {
  vertices = {};
  classes$1 = {};
  edges = [];
  funs$1 = [setupToolTips];
  subGraphs = [];
  subGraphLookup = {};
  subCount = 0;
  tooltips = [];
  firstGraphFlag = true;
  version = ver;
  clear$g();
};
const setGen = (ver) => {
  version = ver || "gen-2";
};
const defaultStyle = function() {
  return "fill:#ffa;stroke: #f66; stroke-width: 3px; stroke-dasharray: 5, 5;fill:#ffa;stroke: #666;";
};
const addSubGraph = function(_id, list, _title) {
  let id2 = _id.trim();
  let title2 = _title;
  if (_id === _title && _title.match(/\s/)) {
    id2 = void 0;
  }
  function uniq(a) {
    const prims = { boolean: {}, number: {}, string: {} };
    const objs = [];
    let dir2;
    const nodeList2 = a.filter(function(item) {
      const type2 = typeof item;
      if (item.stmt && item.stmt === "dir") {
        dir2 = item.value;
        return false;
      }
      if (item.trim() === "") {
        return false;
      }
      if (type2 in prims) {
        return prims[type2].hasOwnProperty(item) ? false : prims[type2][item] = true;
      } else {
        return objs.includes(item) ? false : objs.push(item);
      }
    });
    return { nodeList: nodeList2, dir: dir2 };
  }
  let nodeList = [];
  const { nodeList: nl, dir } = uniq(nodeList.concat.apply(nodeList, list));
  nodeList = nl;
  if (version === "gen-1") {
    for (let i = 0; i < nodeList.length; i++) {
      nodeList[i] = lookUpDomId(nodeList[i]);
    }
  }
  id2 = id2 || "subGraph" + subCount;
  title2 = title2 || "";
  title2 = sanitizeText(title2);
  subCount = subCount + 1;
  const subGraph = { id: id2, nodes: nodeList, title: title2.trim(), classes: [], dir };
  log$1.info("Adding", subGraph.id, subGraph.nodes, subGraph.dir);
  subGraph.nodes = makeUniq(subGraph, subGraphs).nodes;
  subGraphs.push(subGraph);
  subGraphLookup[id2] = subGraph;
  return id2;
};
const getPosForId = function(id2) {
  for (const [i, subGraph] of subGraphs.entries()) {
    if (subGraph.id === id2) {
      return i;
    }
  }
  return -1;
};
let secCount = -1;
const posCrossRef = [];
const indexNodes2 = function(id2, pos) {
  const nodes = subGraphs[pos].nodes;
  secCount = secCount + 1;
  if (secCount > 2e3) {
    return;
  }
  posCrossRef[secCount] = pos;
  if (subGraphs[pos].id === id2) {
    return {
      result: true,
      count: 0
    };
  }
  let count = 0;
  let posCount = 1;
  while (count < nodes.length) {
    const childPos = getPosForId(nodes[count]);
    if (childPos >= 0) {
      const res = indexNodes2(id2, childPos);
      if (res.result) {
        return {
          result: true,
          count: posCount + res.count
        };
      } else {
        posCount = posCount + res.count;
      }
    }
    count = count + 1;
  }
  return {
    result: false,
    count: posCount
  };
};
const getDepthFirstPos = function(pos) {
  return posCrossRef[pos];
};
const indexNodes = function() {
  secCount = -1;
  if (subGraphs.length > 0) {
    indexNodes2("none", subGraphs.length - 1);
  }
};
const getSubGraphs = function() {
  return subGraphs;
};
const firstGraph = () => {
  if (firstGraphFlag) {
    firstGraphFlag = false;
    return true;
  }
  return false;
};
const destructStartLink = (_str) => {
  let str2 = _str.trim();
  let type2 = "arrow_open";
  switch (str2[0]) {
    case "<":
      type2 = "arrow_point";
      str2 = str2.slice(1);
      break;
    case "x":
      type2 = "arrow_cross";
      str2 = str2.slice(1);
      break;
    case "o":
      type2 = "arrow_circle";
      str2 = str2.slice(1);
      break;
  }
  let stroke = "normal";
  if (str2.includes("=")) {
    stroke = "thick";
  }
  if (str2.includes(".")) {
    stroke = "dotted";
  }
  return { type: type2, stroke };
};
const countChar = (char, str2) => {
  const length = str2.length;
  let count = 0;
  for (let i = 0; i < length; ++i) {
    if (str2[i] === char) {
      ++count;
    }
  }
  return count;
};
const destructEndLink = (_str) => {
  const str2 = _str.trim();
  let line2 = str2.slice(0, -1);
  let type2 = "arrow_open";
  switch (str2.slice(-1)) {
    case "x":
      type2 = "arrow_cross";
      if (str2[0] === "x") {
        type2 = "double_" + type2;
        line2 = line2.slice(1);
      }
      break;
    case ">":
      type2 = "arrow_point";
      if (str2[0] === "<") {
        type2 = "double_" + type2;
        line2 = line2.slice(1);
      }
      break;
    case "o":
      type2 = "arrow_circle";
      if (str2[0] === "o") {
        type2 = "double_" + type2;
        line2 = line2.slice(1);
      }
      break;
  }
  let stroke = "normal";
  let length = line2.length - 1;
  if (line2[0] === "=") {
    stroke = "thick";
  }
  let dots = countChar(".", line2);
  if (dots) {
    stroke = "dotted";
    length = dots;
  }
  return { type: type2, stroke, length };
};
const destructLink = (_str, _startStr) => {
  const info2 = destructEndLink(_str);
  let startInfo;
  if (_startStr) {
    startInfo = destructStartLink(_startStr);
    if (startInfo.stroke !== info2.stroke) {
      return { type: "INVALID", stroke: "INVALID" };
    }
    if (startInfo.type === "arrow_open") {
      startInfo.type = info2.type;
    } else {
      if (startInfo.type !== info2.type) {
        return { type: "INVALID", stroke: "INVALID" };
      }
      startInfo.type = "double_" + startInfo.type;
    }
    if (startInfo.type === "double_arrow") {
      startInfo.type = "double_arrow_point";
    }
    startInfo.length = info2.length;
    return startInfo;
  }
  return info2;
};
const exists = (allSgs, _id) => {
  let res = false;
  allSgs.forEach((sg) => {
    const pos = sg.nodes.indexOf(_id);
    if (pos >= 0) {
      res = true;
    }
  });
  return res;
};
const makeUniq = (sg, allSubgraphs) => {
  const res = [];
  sg.nodes.forEach((_id, pos) => {
    if (!exists(allSubgraphs, _id)) {
      res.push(sg.nodes[pos]);
    }
  });
  return { nodes: res };
};
const lex = {
  firstGraph
};
const flowDb = {
  parseDirective: parseDirective$6,
  defaultConfig: () => defaultConfig.flowchart,
  setAccTitle,
  getAccTitle,
  getAccDescription,
  setAccDescription,
  addVertex,
  lookUpDomId,
  addLink,
  updateLinkInterpolate,
  updateLink,
  addClass,
  setDirection: setDirection$1,
  setClass: setClass$1,
  setTooltip,
  getTooltip,
  setClickEvent: setClickEvent$1,
  setLink: setLink$1,
  bindFunctions: bindFunctions$1,
  getDirection: getDirection$1,
  getVertices,
  getEdges,
  getClasses: getClasses$4,
  clear: clear$6,
  setGen,
  defaultStyle,
  addSubGraph,
  getDepthFirstPos,
  indexNodes,
  getSubGraphs,
  destructLink,
  lex,
  exists,
  makeUniq,
  setDiagramTitle,
  getDiagramTitle
};
const db = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  addClass,
  addLink,
  addSingleLink,
  addSubGraph,
  addVertex,
  bindFunctions: bindFunctions$1,
  clear: clear$6,
  default: flowDb,
  defaultStyle,
  destructLink,
  firstGraph,
  getClasses: getClasses$4,
  getDepthFirstPos,
  getDirection: getDirection$1,
  getEdges,
  getSubGraphs,
  getTooltip,
  getVertices,
  indexNodes,
  lex,
  lookUpDomId,
  parseDirective: parseDirective$6,
  setClass: setClass$1,
  setClickEvent: setClickEvent$1,
  setDirection: setDirection$1,
  setGen,
  setLink: setLink$1,
  updateLink,
  updateLinkInterpolate
}, Symbol.toStringTag, { value: "Module" }));
function question(parent, bbox, node) {
  const w2 = bbox.width;
  const h = bbox.height;
  const s = (w2 + h) * 0.9;
  const points = [
    { x: s / 2, y: 0 },
    { x: s, y: -s / 2 },
    { x: s / 2, y: -s },
    { x: 0, y: -s / 2 }
  ];
  const shapeSvg = insertPolygonShape(parent, s, s, points);
  node.intersect = function(point2) {
    return intersectPolygon$1(node, points, point2);
  };
  return shapeSvg;
}
function hexagon(parent, bbox, node) {
  const f = 4;
  const h = bbox.height;
  const m = h / f;
  const w2 = bbox.width + 2 * m;
  const points = [
    { x: m, y: 0 },
    { x: w2 - m, y: 0 },
    { x: w2, y: -h / 2 },
    { x: w2 - m, y: -h },
    { x: m, y: -h },
    { x: 0, y: -h / 2 }
  ];
  const shapeSvg = insertPolygonShape(parent, w2, h, points);
  node.intersect = function(point2) {
    return intersectPolygon$1(node, points, point2);
  };
  return shapeSvg;
}
function rect_left_inv_arrow(parent, bbox, node) {
  const w2 = bbox.width;
  const h = bbox.height;
  const points = [
    { x: -h / 2, y: 0 },
    { x: w2, y: 0 },
    { x: w2, y: -h },
    { x: -h / 2, y: -h },
    { x: 0, y: -h / 2 }
  ];
  const shapeSvg = insertPolygonShape(parent, w2, h, points);
  node.intersect = function(point2) {
    return intersectPolygon$1(node, points, point2);
  };
  return shapeSvg;
}
function lean_right(parent, bbox, node) {
  const w2 = bbox.width;
  const h = bbox.height;
  const points = [
    { x: -2 * h / 6, y: 0 },
    { x: w2 - h / 6, y: 0 },
    { x: w2 + 2 * h / 6, y: -h },
    { x: h / 6, y: -h }
  ];
  const shapeSvg = insertPolygonShape(parent, w2, h, points);
  node.intersect = function(point2) {
    return intersectPolygon$1(node, points, point2);
  };
  return shapeSvg;
}
function lean_left(parent, bbox, node) {
  const w2 = bbox.width;
  const h = bbox.height;
  const points = [
    { x: 2 * h / 6, y: 0 },
    { x: w2 + h / 6, y: 0 },
    { x: w2 - 2 * h / 6, y: -h },
    { x: -h / 6, y: -h }
  ];
  const shapeSvg = insertPolygonShape(parent, w2, h, points);
  node.intersect = function(point2) {
    return intersectPolygon$1(node, points, point2);
  };
  return shapeSvg;
}
function trapezoid(parent, bbox, node) {
  const w2 = bbox.width;
  const h = bbox.height;
  const points = [
    { x: -2 * h / 6, y: 0 },
    { x: w2 + 2 * h / 6, y: 0 },
    { x: w2 - h / 6, y: -h },
    { x: h / 6, y: -h }
  ];
  const shapeSvg = insertPolygonShape(parent, w2, h, points);
  node.intersect = function(point2) {
    return intersectPolygon$1(node, points, point2);
  };
  return shapeSvg;
}
function inv_trapezoid(parent, bbox, node) {
  const w2 = bbox.width;
  const h = bbox.height;
  const points = [
    { x: h / 6, y: 0 },
    { x: w2 - h / 6, y: 0 },
    { x: w2 + 2 * h / 6, y: -h },
    { x: -2 * h / 6, y: -h }
  ];
  const shapeSvg = insertPolygonShape(parent, w2, h, points);
  node.intersect = function(point2) {
    return intersectPolygon$1(node, points, point2);
  };
  return shapeSvg;
}
function rect_right_inv_arrow(parent, bbox, node) {
  const w2 = bbox.width;
  const h = bbox.height;
  const points = [
    { x: 0, y: 0 },
    { x: w2 + h / 2, y: 0 },
    { x: w2, y: -h / 2 },
    { x: w2 + h / 2, y: -h },
    { x: 0, y: -h }
  ];
  const shapeSvg = insertPolygonShape(parent, w2, h, points);
  node.intersect = function(point2) {
    return intersectPolygon$1(node, points, point2);
  };
  return shapeSvg;
}
function stadium(parent, bbox, node) {
  const h = bbox.height;
  const w2 = bbox.width + h / 4;
  const shapeSvg = parent.insert("rect", ":first-child").attr("rx", h / 2).attr("ry", h / 2).attr("x", -w2 / 2).attr("y", -h / 2).attr("width", w2).attr("height", h);
  node.intersect = function(point2) {
    return intersectRect$2(node, point2);
  };
  return shapeSvg;
}
function subroutine(parent, bbox, node) {
  const w2 = bbox.width;
  const h = bbox.height;
  const points = [
    { x: 0, y: 0 },
    { x: w2, y: 0 },
    { x: w2, y: -h },
    { x: 0, y: -h },
    { x: 0, y: 0 },
    { x: -8, y: 0 },
    { x: w2 + 8, y: 0 },
    { x: w2 + 8, y: -h },
    { x: -8, y: -h },
    { x: -8, y: 0 }
  ];
  const shapeSvg = insertPolygonShape(parent, w2, h, points);
  node.intersect = function(point2) {
    return intersectPolygon$1(node, points, point2);
  };
  return shapeSvg;
}
function cylinder(parent, bbox, node) {
  const w2 = bbox.width;
  const rx = w2 / 2;
  const ry = rx / (2.5 + w2 / 50);
  const h = bbox.height + ry;
  const shape = "M 0," + ry + " a " + rx + "," + ry + " 0,0,0 " + w2 + " 0 a " + rx + "," + ry + " 0,0,0 " + -w2 + " 0 l 0," + h + " a " + rx + "," + ry + " 0,0,0 " + w2 + " 0 l 0," + -h;
  const shapeSvg = parent.attr("label-offset-y", ry).insert("path", ":first-child").attr("d", shape).attr("transform", "translate(" + -w2 / 2 + "," + -(h / 2 + ry) + ")");
  node.intersect = function(point2) {
    const pos = intersectRect$2(node, point2);
    const x = pos.x - node.x;
    if (rx != 0 && (Math.abs(x) < node.width / 2 || Math.abs(x) == node.width / 2 && Math.abs(pos.y - node.y) > node.height / 2 - ry)) {
      let y = ry * ry * (1 - x * x / (rx * rx));
      if (y != 0) {
        y = Math.sqrt(y);
      }
      y = ry - y;
      if (point2.y - node.y > 0) {
        y = -y;
      }
      pos.y += y;
    }
    return pos;
  };
  return shapeSvg;
}
function addToRender(render2) {
  render2.shapes().question = question;
  render2.shapes().hexagon = hexagon;
  render2.shapes().stadium = stadium;
  render2.shapes().subroutine = subroutine;
  render2.shapes().cylinder = cylinder;
  render2.shapes().rect_left_inv_arrow = rect_left_inv_arrow;
  render2.shapes().lean_right = lean_right;
  render2.shapes().lean_left = lean_left;
  render2.shapes().trapezoid = trapezoid;
  render2.shapes().inv_trapezoid = inv_trapezoid;
  render2.shapes().rect_right_inv_arrow = rect_right_inv_arrow;
}
function addToRenderV2(addShape) {
  addShape({ question });
  addShape({ hexagon });
  addShape({ stadium });
  addShape({ subroutine });
  addShape({ cylinder });
  addShape({ rect_left_inv_arrow });
  addShape({ lean_right });
  addShape({ lean_left });
  addShape({ trapezoid });
  addShape({ inv_trapezoid });
  addShape({ rect_right_inv_arrow });
}
function insertPolygonShape(parent, w2, h, points) {
  return parent.insert("polygon", ":first-child").attr(
    "points",
    points.map(function(d) {
      return d.x + "," + d.y;
    }).join(" ")
  ).attr("transform", "translate(" + -w2 / 2 + "," + h / 2 + ")");
}
const flowChartShapes = {
  addToRender,
  addToRenderV2
};
const conf$7 = {};
const setConf$7 = function(cnf) {
  const keys2 = Object.keys(cnf);
  for (const key of keys2) {
    conf$7[key] = cnf[key];
  }
};
const addVertices$1 = function(vert, g, svgId, root, _doc, diagObj) {
  const svg = !root ? select(`[id="${svgId}"]`) : root.select(`[id="${svgId}"]`);
  const doc = !_doc ? document : _doc;
  const keys2 = Object.keys(vert);
  keys2.forEach(function(id2) {
    const vertex = vert[id2];
    let classStr = "default";
    if (vertex.classes.length > 0) {
      classStr = vertex.classes.join(" ");
    }
    const styles = getStylesFromArray(vertex.styles);
    let vertexText = vertex.text !== void 0 ? vertex.text : vertex.id;
    let vertexNode;
    if (evaluate(getConfig$1().flowchart.htmlLabels)) {
      const node = {
        label: vertexText.replace(
          /fa[blrs]?:fa-[\w-]+/g,
          (s) => `<i class='${s.replace(":", " ")}'></i>`
        )
      };
      vertexNode = addHtmlLabel$1(svg, node).node();
      vertexNode.parentNode.removeChild(vertexNode);
    } else {
      const svgLabel = doc.createElementNS("http://www.w3.org/2000/svg", "text");
      svgLabel.setAttribute("style", styles.labelStyle.replace("color:", "fill:"));
      const rows = vertexText.split(common$1.lineBreakRegex);
      for (const row of rows) {
        const tspan = doc.createElementNS("http://www.w3.org/2000/svg", "tspan");
        tspan.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        tspan.setAttribute("dy", "1em");
        tspan.setAttribute("x", "1");
        tspan.textContent = row;
        svgLabel.appendChild(tspan);
      }
      vertexNode = svgLabel;
    }
    let radious = 0;
    let _shape = "";
    switch (vertex.type) {
      case "round":
        radious = 5;
        _shape = "rect";
        break;
      case "square":
        _shape = "rect";
        break;
      case "diamond":
        _shape = "question";
        break;
      case "hexagon":
        _shape = "hexagon";
        break;
      case "odd":
        _shape = "rect_left_inv_arrow";
        break;
      case "lean_right":
        _shape = "lean_right";
        break;
      case "lean_left":
        _shape = "lean_left";
        break;
      case "trapezoid":
        _shape = "trapezoid";
        break;
      case "inv_trapezoid":
        _shape = "inv_trapezoid";
        break;
      case "odd_right":
        _shape = "rect_left_inv_arrow";
        break;
      case "circle":
        _shape = "circle";
        break;
      case "ellipse":
        _shape = "ellipse";
        break;
      case "stadium":
        _shape = "stadium";
        break;
      case "subroutine":
        _shape = "subroutine";
        break;
      case "cylinder":
        _shape = "cylinder";
        break;
      case "group":
        _shape = "rect";
        break;
      default:
        _shape = "rect";
    }
    log$1.warn("Adding node", vertex.id, vertex.domId);
    g.setNode(diagObj.db.lookUpDomId(vertex.id), {
      labelType: "svg",
      labelStyle: styles.labelStyle,
      shape: _shape,
      label: vertexNode,
      rx: radious,
      ry: radious,
      class: classStr,
      style: styles.style,
      id: diagObj.db.lookUpDomId(vertex.id)
    });
  });
};
const addEdges$1 = function(edges2, g, diagObj) {
  let cnt2 = 0;
  let defaultStyle2;
  let defaultLabelStyle;
  if (edges2.defaultStyle !== void 0) {
    const defaultStyles = getStylesFromArray(edges2.defaultStyle);
    defaultStyle2 = defaultStyles.style;
    defaultLabelStyle = defaultStyles.labelStyle;
  }
  edges2.forEach(function(edge) {
    cnt2++;
    var linkId = "L-" + edge.start + "-" + edge.end;
    var linkNameStart = "LS-" + edge.start;
    var linkNameEnd = "LE-" + edge.end;
    const edgeData = {};
    if (edge.type === "arrow_open") {
      edgeData.arrowhead = "none";
    } else {
      edgeData.arrowhead = "normal";
    }
    let style = "";
    let labelStyle = "";
    if (edge.style !== void 0) {
      const styles = getStylesFromArray(edge.style);
      style = styles.style;
      labelStyle = styles.labelStyle;
    } else {
      switch (edge.stroke) {
        case "normal":
          style = "fill:none";
          if (defaultStyle2 !== void 0) {
            style = defaultStyle2;
          }
          if (defaultLabelStyle !== void 0) {
            labelStyle = defaultLabelStyle;
          }
          break;
        case "dotted":
          style = "fill:none;stroke-width:2px;stroke-dasharray:3;";
          break;
        case "thick":
          style = " stroke-width: 3.5px;fill:none";
          break;
      }
    }
    edgeData.style = style;
    edgeData.labelStyle = labelStyle;
    if (edge.interpolate !== void 0) {
      edgeData.curve = interpolateToCurve(edge.interpolate, curveLinear);
    } else if (edges2.defaultInterpolate !== void 0) {
      edgeData.curve = interpolateToCurve(edges2.defaultInterpolate, curveLinear);
    } else {
      edgeData.curve = interpolateToCurve(conf$7.curve, curveLinear);
    }
    if (edge.text === void 0) {
      if (edge.style !== void 0) {
        edgeData.arrowheadStyle = "fill: #333";
      }
    } else {
      edgeData.arrowheadStyle = "fill: #333";
      edgeData.labelpos = "c";
      if (evaluate(getConfig$1().flowchart.htmlLabels)) {
        edgeData.labelType = "html";
        edgeData.label = `<span id="L-${linkId}" class="edgeLabel L-${linkNameStart}' L-${linkNameEnd}" style="${edgeData.labelStyle}">${edge.text.replace(
          /fa[blrs]?:fa-[\w-]+/g,
          (s) => `<i class='${s.replace(":", " ")}'></i>`
        )}</span>`;
      } else {
        edgeData.labelType = "text";
        edgeData.label = edge.text.replace(common$1.lineBreakRegex, "\n");
        if (edge.style === void 0) {
          edgeData.style = edgeData.style || "stroke: #333; stroke-width: 1.5px;fill:none";
        }
        edgeData.labelStyle = edgeData.labelStyle.replace("color:", "fill:");
      }
    }
    edgeData.id = linkId;
    edgeData.class = linkNameStart + " " + linkNameEnd;
    edgeData.minlen = edge.length || 1;
    g.setEdge(diagObj.db.lookUpDomId(edge.start), diagObj.db.lookUpDomId(edge.end), edgeData, cnt2);
  });
};
const getClasses$3 = function(text, diagObj) {
  log$1.info("Extracting classes");
  diagObj.db.clear();
  try {
    diagObj.parse(text);
    return diagObj.db.getClasses();
  } catch (e) {
    log$1.error(e);
    return {};
  }
};
const draw$a = function(text, id2, _version, diagObj) {
  log$1.info("Drawing flowchart");
  diagObj.db.clear();
  const { securityLevel, flowchart: conf2 } = getConfig$1();
  let sandboxElement;
  if (securityLevel === "sandbox") {
    sandboxElement = select("#i" + id2);
  }
  const root = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
  const doc = securityLevel === "sandbox" ? sandboxElement.nodes()[0].contentDocument : document;
  try {
    diagObj.parser.parse(text);
  } catch (err) {
    log$1.debug("Parsing failed");
  }
  let dir = diagObj.db.getDirection();
  if (dir === void 0) {
    dir = "TD";
  }
  const nodeSpacing = conf2.nodeSpacing || 50;
  const rankSpacing = conf2.rankSpacing || 50;
  const g = new graphlib.Graph({
    multigraph: true,
    compound: true
  }).setGraph({
    rankdir: dir,
    nodesep: nodeSpacing,
    ranksep: rankSpacing,
    marginx: 8,
    marginy: 8
  }).setDefaultEdgeLabel(function() {
    return {};
  });
  let subG;
  const subGraphs2 = diagObj.db.getSubGraphs();
  for (let i2 = subGraphs2.length - 1; i2 >= 0; i2--) {
    subG = subGraphs2[i2];
    diagObj.db.addVertex(subG.id, subG.title, "group", void 0, subG.classes);
  }
  const vert = diagObj.db.getVertices();
  log$1.warn("Get vertices", vert);
  const edges2 = diagObj.db.getEdges();
  let i = 0;
  for (i = subGraphs2.length - 1; i >= 0; i--) {
    subG = subGraphs2[i];
    selectAll("cluster").append("text");
    for (let j = 0; j < subG.nodes.length; j++) {
      log$1.warn(
        "Setting subgraph",
        subG.nodes[j],
        diagObj.db.lookUpDomId(subG.nodes[j]),
        diagObj.db.lookUpDomId(subG.id)
      );
      g.setParent(diagObj.db.lookUpDomId(subG.nodes[j]), diagObj.db.lookUpDomId(subG.id));
    }
  }
  addVertices$1(vert, g, id2, root, doc, diagObj);
  addEdges$1(edges2, g, diagObj);
  const render2 = new render$2();
  flowChartShapes.addToRender(render2);
  render2.arrows().none = function normal(parent, id3, edge, type2) {
    const marker = parent.append("marker").attr("id", id3).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 8).attr("markerHeight", 6).attr("orient", "auto");
    const path = marker.append("path").attr("d", "M 0 0 L 0 0 L 0 0 z");
    applyStyle$1(path, edge[type2 + "Style"]);
  };
  render2.arrows().normal = function normal(parent, id3) {
    const marker = parent.append("marker").attr("id", id3).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 8).attr("markerHeight", 6).attr("orient", "auto");
    marker.append("path").attr("d", "M 0 0 L 10 5 L 0 10 z").attr("class", "arrowheadPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
  };
  const svg = root.select(`[id="${id2}"]`);
  const element = root.select("#" + id2 + " g");
  render2(element, g);
  element.selectAll("g.node").attr("title", function() {
    return diagObj.db.getTooltip(this.id);
  });
  diagObj.db.indexNodes("subGraph" + i);
  for (i = 0; i < subGraphs2.length; i++) {
    subG = subGraphs2[i];
    if (subG.title !== "undefined") {
      const clusterRects = doc.querySelectorAll(
        "#" + id2 + ' [id="' + diagObj.db.lookUpDomId(subG.id) + '"] rect'
      );
      const clusterEl = doc.querySelectorAll(
        "#" + id2 + ' [id="' + diagObj.db.lookUpDomId(subG.id) + '"]'
      );
      const xPos = clusterRects[0].x.baseVal.value;
      const yPos = clusterRects[0].y.baseVal.value;
      const _width = clusterRects[0].width.baseVal.value;
      const cluster = select(clusterEl[0]);
      const te = cluster.select(".label");
      te.attr("transform", `translate(${xPos + _width / 2}, ${yPos + 14})`);
      te.attr("id", id2 + "Text");
      for (let j = 0; j < subG.classes.length; j++) {
        clusterEl[0].classList.add(subG.classes[j]);
      }
    }
  }
  if (!conf2.htmlLabels) {
    const labels = doc.querySelectorAll('[id="' + id2 + '"] .edgeLabel .label');
    for (const label of labels) {
      const dim = label.getBBox();
      const rect2 = doc.createElementNS("http://www.w3.org/2000/svg", "rect");
      rect2.setAttribute("rx", 0);
      rect2.setAttribute("ry", 0);
      rect2.setAttribute("width", dim.width);
      rect2.setAttribute("height", dim.height);
      label.insertBefore(rect2, label.firstChild);
    }
  }
  setupGraphViewbox$1(g, svg, conf2.diagramPadding, conf2.useMaxWidth);
  const keys2 = Object.keys(vert);
  keys2.forEach(function(key) {
    const vertex = vert[key];
    if (vertex.link) {
      const node = root.select("#" + id2 + ' [id="' + diagObj.db.lookUpDomId(key) + '"]');
      if (node) {
        const link = doc.createElementNS("http://www.w3.org/2000/svg", "a");
        link.setAttributeNS("http://www.w3.org/2000/svg", "class", vertex.classes.join(" "));
        link.setAttributeNS("http://www.w3.org/2000/svg", "href", vertex.link);
        link.setAttributeNS("http://www.w3.org/2000/svg", "rel", "noopener");
        if (securityLevel === "sandbox") {
          link.setAttributeNS("http://www.w3.org/2000/svg", "target", "_top");
        } else if (vertex.linkTarget) {
          link.setAttributeNS("http://www.w3.org/2000/svg", "target", vertex.linkTarget);
        }
        const linkNode = node.insert(function() {
          return link;
        }, ":first-child");
        const shape = node.select(".label-container");
        if (shape) {
          linkNode.append(function() {
            return shape.node();
          });
        }
        const label = node.select(".label");
        if (label) {
          linkNode.append(function() {
            return label.node();
          });
        }
      }
    }
  });
};
const flowRenderer = {
  setConf: setConf$7,
  addVertices: addVertices$1,
  addEdges: addEdges$1,
  getClasses: getClasses$3,
  draw: draw$a
};
const conf$6 = {};
const setConf$6 = function(cnf) {
  const keys2 = Object.keys(cnf);
  for (const key of keys2) {
    conf$6[key] = cnf[key];
  }
};
const addVertices = function(vert, g, svgId, root, doc, diagObj) {
  const svg = root.select(`[id="${svgId}"]`);
  const keys2 = Object.keys(vert);
  keys2.forEach(function(id2) {
    const vertex = vert[id2];
    let classStr = "default";
    if (vertex.classes.length > 0) {
      classStr = vertex.classes.join(" ");
    }
    const styles = getStylesFromArray(vertex.styles);
    let vertexText = vertex.text !== void 0 ? vertex.text : vertex.id;
    let vertexNode;
    if (evaluate(getConfig$1().flowchart.htmlLabels)) {
      const node = {
        label: vertexText.replace(
          /fa[blrs]?:fa-[\w-]+/g,
          (s) => `<i class='${s.replace(":", " ")}'></i>`
        )
      };
      vertexNode = addHtmlLabel$1(svg, node).node();
      vertexNode.parentNode.removeChild(vertexNode);
    } else {
      const svgLabel = doc.createElementNS("http://www.w3.org/2000/svg", "text");
      svgLabel.setAttribute("style", styles.labelStyle.replace("color:", "fill:"));
      const rows = vertexText.split(common$1.lineBreakRegex);
      for (const row of rows) {
        const tspan = doc.createElementNS("http://www.w3.org/2000/svg", "tspan");
        tspan.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        tspan.setAttribute("dy", "1em");
        tspan.setAttribute("x", "1");
        tspan.textContent = row;
        svgLabel.appendChild(tspan);
      }
      vertexNode = svgLabel;
    }
    let radious = 0;
    let _shape = "";
    switch (vertex.type) {
      case "round":
        radious = 5;
        _shape = "rect";
        break;
      case "square":
        _shape = "rect";
        break;
      case "diamond":
        _shape = "question";
        break;
      case "hexagon":
        _shape = "hexagon";
        break;
      case "odd":
        _shape = "rect_left_inv_arrow";
        break;
      case "lean_right":
        _shape = "lean_right";
        break;
      case "lean_left":
        _shape = "lean_left";
        break;
      case "trapezoid":
        _shape = "trapezoid";
        break;
      case "inv_trapezoid":
        _shape = "inv_trapezoid";
        break;
      case "odd_right":
        _shape = "rect_left_inv_arrow";
        break;
      case "circle":
        _shape = "circle";
        break;
      case "ellipse":
        _shape = "ellipse";
        break;
      case "stadium":
        _shape = "stadium";
        break;
      case "subroutine":
        _shape = "subroutine";
        break;
      case "cylinder":
        _shape = "cylinder";
        break;
      case "group":
        _shape = "rect";
        break;
      case "doublecircle":
        _shape = "doublecircle";
        break;
      default:
        _shape = "rect";
    }
    g.setNode(vertex.id, {
      labelStyle: styles.labelStyle,
      shape: _shape,
      labelText: vertexText,
      rx: radious,
      ry: radious,
      class: classStr,
      style: styles.style,
      id: vertex.id,
      link: vertex.link,
      linkTarget: vertex.linkTarget,
      tooltip: diagObj.db.getTooltip(vertex.id) || "",
      domId: diagObj.db.lookUpDomId(vertex.id),
      haveCallback: vertex.haveCallback,
      width: vertex.type === "group" ? 500 : void 0,
      dir: vertex.dir,
      type: vertex.type,
      props: vertex.props,
      padding: getConfig$1().flowchart.padding
    });
    log$1.info("setNode", {
      labelStyle: styles.labelStyle,
      shape: _shape,
      labelText: vertexText,
      rx: radious,
      ry: radious,
      class: classStr,
      style: styles.style,
      id: vertex.id,
      domId: diagObj.db.lookUpDomId(vertex.id),
      width: vertex.type === "group" ? 500 : void 0,
      type: vertex.type,
      dir: vertex.dir,
      props: vertex.props,
      padding: getConfig$1().flowchart.padding
    });
  });
};
const addEdges = function(edges2, g, diagObj) {
  log$1.info("abc78 edges = ", edges2);
  let cnt2 = 0;
  let linkIdCnt = {};
  let defaultStyle2;
  let defaultLabelStyle;
  if (edges2.defaultStyle !== void 0) {
    const defaultStyles = getStylesFromArray(edges2.defaultStyle);
    defaultStyle2 = defaultStyles.style;
    defaultLabelStyle = defaultStyles.labelStyle;
  }
  edges2.forEach(function(edge) {
    cnt2++;
    var linkIdBase = "L-" + edge.start + "-" + edge.end;
    if (linkIdCnt[linkIdBase] === void 0) {
      linkIdCnt[linkIdBase] = 0;
      log$1.info("abc78 new entry", linkIdBase, linkIdCnt[linkIdBase]);
    } else {
      linkIdCnt[linkIdBase]++;
      log$1.info("abc78 new entry", linkIdBase, linkIdCnt[linkIdBase]);
    }
    let linkId = linkIdBase + "-" + linkIdCnt[linkIdBase];
    log$1.info("abc78 new link id to be used is", linkIdBase, linkId, linkIdCnt[linkIdBase]);
    var linkNameStart = "LS-" + edge.start;
    var linkNameEnd = "LE-" + edge.end;
    const edgeData = { style: "", labelStyle: "" };
    edgeData.minlen = edge.length || 1;
    if (edge.type === "arrow_open") {
      edgeData.arrowhead = "none";
    } else {
      edgeData.arrowhead = "normal";
    }
    edgeData.arrowTypeStart = "arrow_open";
    edgeData.arrowTypeEnd = "arrow_open";
    switch (edge.type) {
      case "double_arrow_cross":
        edgeData.arrowTypeStart = "arrow_cross";
      case "arrow_cross":
        edgeData.arrowTypeEnd = "arrow_cross";
        break;
      case "double_arrow_point":
        edgeData.arrowTypeStart = "arrow_point";
      case "arrow_point":
        edgeData.arrowTypeEnd = "arrow_point";
        break;
      case "double_arrow_circle":
        edgeData.arrowTypeStart = "arrow_circle";
      case "arrow_circle":
        edgeData.arrowTypeEnd = "arrow_circle";
        break;
    }
    let style = "";
    let labelStyle = "";
    switch (edge.stroke) {
      case "normal":
        style = "fill:none;";
        if (defaultStyle2 !== void 0) {
          style = defaultStyle2;
        }
        if (defaultLabelStyle !== void 0) {
          labelStyle = defaultLabelStyle;
        }
        edgeData.thickness = "normal";
        edgeData.pattern = "solid";
        break;
      case "dotted":
        edgeData.thickness = "normal";
        edgeData.pattern = "dotted";
        edgeData.style = "fill:none;stroke-width:2px;stroke-dasharray:3;";
        break;
      case "thick":
        edgeData.thickness = "thick";
        edgeData.pattern = "solid";
        edgeData.style = "stroke-width: 3.5px;fill:none;";
        break;
    }
    if (edge.style !== void 0) {
      const styles = getStylesFromArray(edge.style);
      style = styles.style;
      labelStyle = styles.labelStyle;
    }
    edgeData.style = edgeData.style += style;
    edgeData.labelStyle = edgeData.labelStyle += labelStyle;
    if (edge.interpolate !== void 0) {
      edgeData.curve = interpolateToCurve(edge.interpolate, curveLinear);
    } else if (edges2.defaultInterpolate !== void 0) {
      edgeData.curve = interpolateToCurve(edges2.defaultInterpolate, curveLinear);
    } else {
      edgeData.curve = interpolateToCurve(conf$6.curve, curveLinear);
    }
    if (edge.text === void 0) {
      if (edge.style !== void 0) {
        edgeData.arrowheadStyle = "fill: #333";
      }
    } else {
      edgeData.arrowheadStyle = "fill: #333";
      edgeData.labelpos = "c";
    }
    edgeData.labelType = "text";
    edgeData.label = edge.text.replace(common$1.lineBreakRegex, "\n");
    if (edge.style === void 0) {
      edgeData.style = edgeData.style || "stroke: #333; stroke-width: 1.5px;fill:none;";
    }
    edgeData.labelStyle = edgeData.labelStyle.replace("color:", "fill:");
    edgeData.id = linkId;
    edgeData.classes = "flowchart-link " + linkNameStart + " " + linkNameEnd;
    g.setEdge(edge.start, edge.end, edgeData, cnt2);
  });
};
const getClasses$2 = function(text, diagObj) {
  log$1.info("Extracting classes");
  diagObj.db.clear();
  try {
    diagObj.parse(text);
    return diagObj.db.getClasses();
  } catch (e) {
    return;
  }
};
const draw$9 = function(text, id2, _version, diagObj) {
  log$1.info("Drawing flowchart");
  diagObj.db.clear();
  flowDb.setGen("gen-2");
  diagObj.parser.parse(text);
  let dir = diagObj.db.getDirection();
  if (dir === void 0) {
    dir = "TD";
  }
  const { securityLevel, flowchart: conf2 } = getConfig$1();
  const nodeSpacing = conf2.nodeSpacing || 50;
  const rankSpacing = conf2.rankSpacing || 50;
  let sandboxElement;
  if (securityLevel === "sandbox") {
    sandboxElement = select("#i" + id2);
  }
  const root = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
  const doc = securityLevel === "sandbox" ? sandboxElement.nodes()[0].contentDocument : document;
  const g = new graphlib.Graph({
    multigraph: true,
    compound: true
  }).setGraph({
    rankdir: dir,
    nodesep: nodeSpacing,
    ranksep: rankSpacing,
    marginx: 0,
    marginy: 0
  }).setDefaultEdgeLabel(function() {
    return {};
  });
  let subG;
  const subGraphs2 = diagObj.db.getSubGraphs();
  log$1.info("Subgraphs - ", subGraphs2);
  for (let i2 = subGraphs2.length - 1; i2 >= 0; i2--) {
    subG = subGraphs2[i2];
    log$1.info("Subgraph - ", subG);
    diagObj.db.addVertex(subG.id, subG.title, "group", void 0, subG.classes, subG.dir);
  }
  const vert = diagObj.db.getVertices();
  const edges2 = diagObj.db.getEdges();
  log$1.info("Edges", edges2);
  let i = 0;
  for (i = subGraphs2.length - 1; i >= 0; i--) {
    subG = subGraphs2[i];
    selectAll("cluster").append("text");
    for (let j = 0; j < subG.nodes.length; j++) {
      log$1.info("Setting up subgraphs", subG.nodes[j], subG.id);
      g.setParent(subG.nodes[j], subG.id);
    }
  }
  addVertices(vert, g, id2, root, doc, diagObj);
  addEdges(edges2, g);
  const svg = root.select(`[id="${id2}"]`);
  const element = root.select("#" + id2 + " g");
  render$1(element, g, ["point", "circle", "cross"], "flowchart", id2);
  utils.insertTitle(svg, "flowchartTitleText", conf2.titleTopMargin, diagObj.db.getDiagramTitle());
  setupGraphViewbox$1(g, svg, conf2.diagramPadding, conf2.useMaxWidth);
  diagObj.db.indexNodes("subGraph" + i);
  if (!conf2.htmlLabels) {
    const labels = doc.querySelectorAll('[id="' + id2 + '"] .edgeLabel .label');
    for (const label of labels) {
      const dim = label.getBBox();
      const rect2 = doc.createElementNS("http://www.w3.org/2000/svg", "rect");
      rect2.setAttribute("rx", 0);
      rect2.setAttribute("ry", 0);
      rect2.setAttribute("width", dim.width);
      rect2.setAttribute("height", dim.height);
      label.insertBefore(rect2, label.firstChild);
    }
  }
  const keys2 = Object.keys(vert);
  keys2.forEach(function(key) {
    const vertex = vert[key];
    if (vertex.link) {
      const node = select("#" + id2 + ' [id="' + key + '"]');
      if (node) {
        const link = doc.createElementNS("http://www.w3.org/2000/svg", "a");
        link.setAttributeNS("http://www.w3.org/2000/svg", "class", vertex.classes.join(" "));
        link.setAttributeNS("http://www.w3.org/2000/svg", "href", vertex.link);
        link.setAttributeNS("http://www.w3.org/2000/svg", "rel", "noopener");
        if (securityLevel === "sandbox") {
          link.setAttributeNS("http://www.w3.org/2000/svg", "target", "_top");
        } else if (vertex.linkTarget) {
          link.setAttributeNS("http://www.w3.org/2000/svg", "target", vertex.linkTarget);
        }
        const linkNode = node.insert(function() {
          return link;
        }, ":first-child");
        const shape = node.select(".label-container");
        if (shape) {
          linkNode.append(function() {
            return shape.node();
          });
        }
        const label = node.select(".label");
        if (label) {
          linkNode.append(function() {
            return label.node();
          });
        }
      }
    }
  });
};
const flowRendererV2 = {
  setConf: setConf$6,
  addVertices,
  addEdges,
  getClasses: getClasses$2,
  draw: draw$9
};
var parser$6 = function() {
  var o = function(k, v, o2, l) {
    for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
      ;
    return o2;
  }, $V0 = [1, 3], $V1 = [1, 5], $V2 = [7, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 25, 26, 28, 35, 40], $V3 = [1, 15], $V4 = [1, 16], $V5 = [1, 17], $V6 = [1, 18], $V7 = [1, 19], $V8 = [1, 20], $V9 = [1, 21], $Va = [1, 22], $Vb = [1, 23], $Vc = [1, 24], $Vd = [1, 25], $Ve = [1, 26], $Vf = [1, 27], $Vg = [1, 29], $Vh = [1, 31], $Vi = [1, 34], $Vj = [5, 7, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 25, 26, 28, 35, 40];
  var parser2 = {
    trace: function trace() {
    },
    yy: {},
    symbols_: { "error": 2, "start": 3, "directive": 4, "gantt": 5, "document": 6, "EOF": 7, "line": 8, "SPACE": 9, "statement": 10, "NL": 11, "dateFormat": 12, "inclusiveEndDates": 13, "topAxis": 14, "axisFormat": 15, "tickInterval": 16, "excludes": 17, "includes": 18, "todayMarker": 19, "title": 20, "acc_title": 21, "acc_title_value": 22, "acc_descr": 23, "acc_descr_value": 24, "acc_descr_multiline_value": 25, "section": 26, "clickStatement": 27, "taskTxt": 28, "taskData": 29, "openDirective": 30, "typeDirective": 31, "closeDirective": 32, ":": 33, "argDirective": 34, "click": 35, "callbackname": 36, "callbackargs": 37, "href": 38, "clickStatementDebug": 39, "open_directive": 40, "type_directive": 41, "arg_directive": 42, "close_directive": 43, "$accept": 0, "$end": 1 },
    terminals_: { 2: "error", 5: "gantt", 7: "EOF", 9: "SPACE", 11: "NL", 12: "dateFormat", 13: "inclusiveEndDates", 14: "topAxis", 15: "axisFormat", 16: "tickInterval", 17: "excludes", 18: "includes", 19: "todayMarker", 20: "title", 21: "acc_title", 22: "acc_title_value", 23: "acc_descr", 24: "acc_descr_value", 25: "acc_descr_multiline_value", 26: "section", 28: "taskTxt", 29: "taskData", 33: ":", 35: "click", 36: "callbackname", 37: "callbackargs", 38: "href", 40: "open_directive", 41: "type_directive", 42: "arg_directive", 43: "close_directive" },
    productions_: [0, [3, 2], [3, 3], [6, 0], [6, 2], [8, 2], [8, 1], [8, 1], [8, 1], [10, 1], [10, 1], [10, 1], [10, 1], [10, 1], [10, 1], [10, 1], [10, 1], [10, 1], [10, 2], [10, 2], [10, 1], [10, 1], [10, 1], [10, 2], [10, 1], [4, 4], [4, 6], [27, 2], [27, 3], [27, 3], [27, 4], [27, 3], [27, 4], [27, 2], [39, 2], [39, 3], [39, 3], [39, 4], [39, 3], [39, 4], [39, 2], [30, 1], [31, 1], [34, 1], [32, 1]],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
      var $0 = $$.length - 1;
      switch (yystate) {
        case 2:
          return $$[$0 - 1];
        case 3:
          this.$ = [];
          break;
        case 4:
          $$[$0 - 1].push($$[$0]);
          this.$ = $$[$0 - 1];
          break;
        case 5:
        case 6:
          this.$ = $$[$0];
          break;
        case 7:
        case 8:
          this.$ = [];
          break;
        case 9:
          yy.setDateFormat($$[$0].substr(11));
          this.$ = $$[$0].substr(11);
          break;
        case 10:
          yy.enableInclusiveEndDates();
          this.$ = $$[$0].substr(18);
          break;
        case 11:
          yy.TopAxis();
          this.$ = $$[$0].substr(8);
          break;
        case 12:
          yy.setAxisFormat($$[$0].substr(11));
          this.$ = $$[$0].substr(11);
          break;
        case 13:
          yy.setTickInterval($$[$0].substr(13));
          this.$ = $$[$0].substr(13);
          break;
        case 14:
          yy.setExcludes($$[$0].substr(9));
          this.$ = $$[$0].substr(9);
          break;
        case 15:
          yy.setIncludes($$[$0].substr(9));
          this.$ = $$[$0].substr(9);
          break;
        case 16:
          yy.setTodayMarker($$[$0].substr(12));
          this.$ = $$[$0].substr(12);
          break;
        case 17:
          yy.setDiagramTitle($$[$0].substr(6));
          this.$ = $$[$0].substr(6);
          break;
        case 18:
          this.$ = $$[$0].trim();
          yy.setAccTitle(this.$);
          break;
        case 19:
        case 20:
          this.$ = $$[$0].trim();
          yy.setAccDescription(this.$);
          break;
        case 21:
          yy.addSection($$[$0].substr(8));
          this.$ = $$[$0].substr(8);
          break;
        case 23:
          yy.addTask($$[$0 - 1], $$[$0]);
          this.$ = "task";
          break;
        case 27:
          this.$ = $$[$0 - 1];
          yy.setClickEvent($$[$0 - 1], $$[$0], null);
          break;
        case 28:
          this.$ = $$[$0 - 2];
          yy.setClickEvent($$[$0 - 2], $$[$0 - 1], $$[$0]);
          break;
        case 29:
          this.$ = $$[$0 - 2];
          yy.setClickEvent($$[$0 - 2], $$[$0 - 1], null);
          yy.setLink($$[$0 - 2], $$[$0]);
          break;
        case 30:
          this.$ = $$[$0 - 3];
          yy.setClickEvent($$[$0 - 3], $$[$0 - 2], $$[$0 - 1]);
          yy.setLink($$[$0 - 3], $$[$0]);
          break;
        case 31:
          this.$ = $$[$0 - 2];
          yy.setClickEvent($$[$0 - 2], $$[$0], null);
          yy.setLink($$[$0 - 2], $$[$0 - 1]);
          break;
        case 32:
          this.$ = $$[$0 - 3];
          yy.setClickEvent($$[$0 - 3], $$[$0 - 1], $$[$0]);
          yy.setLink($$[$0 - 3], $$[$0 - 2]);
          break;
        case 33:
          this.$ = $$[$0 - 1];
          yy.setLink($$[$0 - 1], $$[$0]);
          break;
        case 34:
        case 40:
          this.$ = $$[$0 - 1] + " " + $$[$0];
          break;
        case 35:
        case 36:
        case 38:
          this.$ = $$[$0 - 2] + " " + $$[$0 - 1] + " " + $$[$0];
          break;
        case 37:
        case 39:
          this.$ = $$[$0 - 3] + " " + $$[$0 - 2] + " " + $$[$0 - 1] + " " + $$[$0];
          break;
        case 41:
          yy.parseDirective("%%{", "open_directive");
          break;
        case 42:
          yy.parseDirective($$[$0], "type_directive");
          break;
        case 43:
          $$[$0] = $$[$0].trim().replace(/'/g, '"');
          yy.parseDirective($$[$0], "arg_directive");
          break;
        case 44:
          yy.parseDirective("}%%", "close_directive", "gantt");
          break;
      }
    },
    table: [{ 3: 1, 4: 2, 5: $V0, 30: 4, 40: $V1 }, { 1: [3] }, { 3: 6, 4: 2, 5: $V0, 30: 4, 40: $V1 }, o($V2, [2, 3], { 6: 7 }), { 31: 8, 41: [1, 9] }, { 41: [2, 41] }, { 1: [2, 1] }, { 4: 30, 7: [1, 10], 8: 11, 9: [1, 12], 10: 13, 11: [1, 14], 12: $V3, 13: $V4, 14: $V5, 15: $V6, 16: $V7, 17: $V8, 18: $V9, 19: $Va, 20: $Vb, 21: $Vc, 23: $Vd, 25: $Ve, 26: $Vf, 27: 28, 28: $Vg, 30: 4, 35: $Vh, 40: $V1 }, { 32: 32, 33: [1, 33], 43: $Vi }, o([33, 43], [2, 42]), o($V2, [2, 8], { 1: [2, 2] }), o($V2, [2, 4]), { 4: 30, 10: 35, 12: $V3, 13: $V4, 14: $V5, 15: $V6, 16: $V7, 17: $V8, 18: $V9, 19: $Va, 20: $Vb, 21: $Vc, 23: $Vd, 25: $Ve, 26: $Vf, 27: 28, 28: $Vg, 30: 4, 35: $Vh, 40: $V1 }, o($V2, [2, 6]), o($V2, [2, 7]), o($V2, [2, 9]), o($V2, [2, 10]), o($V2, [2, 11]), o($V2, [2, 12]), o($V2, [2, 13]), o($V2, [2, 14]), o($V2, [2, 15]), o($V2, [2, 16]), o($V2, [2, 17]), { 22: [1, 36] }, { 24: [1, 37] }, o($V2, [2, 20]), o($V2, [2, 21]), o($V2, [2, 22]), { 29: [1, 38] }, o($V2, [2, 24]), { 36: [1, 39], 38: [1, 40] }, { 11: [1, 41] }, { 34: 42, 42: [1, 43] }, { 11: [2, 44] }, o($V2, [2, 5]), o($V2, [2, 18]), o($V2, [2, 19]), o($V2, [2, 23]), o($V2, [2, 27], { 37: [1, 44], 38: [1, 45] }), o($V2, [2, 33], { 36: [1, 46] }), o($Vj, [2, 25]), { 32: 47, 43: $Vi }, { 43: [2, 43] }, o($V2, [2, 28], { 38: [1, 48] }), o($V2, [2, 29]), o($V2, [2, 31], { 37: [1, 49] }), { 11: [1, 50] }, o($V2, [2, 30]), o($V2, [2, 32]), o($Vj, [2, 26])],
    defaultActions: { 5: [2, 41], 6: [2, 1], 34: [2, 44], 43: [2, 43] },
    parseError: function parseError(str2, hash) {
      if (hash.recoverable) {
        this.trace(str2);
      } else {
        var error = new Error(str2);
        error.hash = hash;
        throw error;
      }
    },
    parse: function parse2(input) {
      var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
      var args = lstack.slice.call(arguments, 1);
      var lexer2 = Object.create(this.lexer);
      var sharedState = { yy: {} };
      for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
          sharedState.yy[k] = this.yy[k];
        }
      }
      lexer2.setInput(input, sharedState.yy);
      sharedState.yy.lexer = lexer2;
      sharedState.yy.parser = this;
      if (typeof lexer2.yylloc == "undefined") {
        lexer2.yylloc = {};
      }
      var yyloc = lexer2.yylloc;
      lstack.push(yyloc);
      var ranges = lexer2.options && lexer2.options.ranges;
      if (typeof sharedState.yy.parseError === "function") {
        this.parseError = sharedState.yy.parseError;
      } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
      }
      function lex2() {
        var token;
        token = tstack.pop() || lexer2.lex() || EOF;
        if (typeof token !== "number") {
          if (token instanceof Array) {
            tstack = token;
            token = tstack.pop();
          }
          token = self.symbols_[token] || token;
        }
        return token;
      }
      var symbol, state, action, r, yyval = {}, p, len, newState, expected;
      while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
          action = this.defaultActions[state];
        } else {
          if (symbol === null || typeof symbol == "undefined") {
            symbol = lex2();
          }
          action = table[state] && table[state][symbol];
        }
        if (typeof action === "undefined" || !action.length || !action[0]) {
          var errStr = "";
          expected = [];
          for (p in table[state]) {
            if (this.terminals_[p] && p > TERROR) {
              expected.push("'" + this.terminals_[p] + "'");
            }
          }
          if (lexer2.showPosition) {
            errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
          } else {
            errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
          }
          this.parseError(errStr, {
            text: lexer2.match,
            token: this.terminals_[symbol] || symbol,
            line: lexer2.yylineno,
            loc: yyloc,
            expected
          });
        }
        if (action[0] instanceof Array && action.length > 1) {
          throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
        }
        switch (action[0]) {
          case 1:
            stack.push(symbol);
            vstack.push(lexer2.yytext);
            lstack.push(lexer2.yylloc);
            stack.push(action[1]);
            symbol = null;
            {
              yyleng = lexer2.yyleng;
              yytext = lexer2.yytext;
              yylineno = lexer2.yylineno;
              yyloc = lexer2.yylloc;
            }
            break;
          case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
              first_line: lstack[lstack.length - (len || 1)].first_line,
              last_line: lstack[lstack.length - 1].last_line,
              first_column: lstack[lstack.length - (len || 1)].first_column,
              last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
              yyval._$.range = [
                lstack[lstack.length - (len || 1)].range[0],
                lstack[lstack.length - 1].range[1]
              ];
            }
            r = this.performAction.apply(yyval, [
              yytext,
              yyleng,
              yylineno,
              sharedState.yy,
              action[1],
              vstack,
              lstack
            ].concat(args));
            if (typeof r !== "undefined") {
              return r;
            }
            if (len) {
              stack = stack.slice(0, -1 * len * 2);
              vstack = vstack.slice(0, -1 * len);
              lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
          case 3:
            return true;
        }
      }
      return true;
    }
  };
  var lexer = function() {
    var lexer2 = {
      EOF: 1,
      parseError: function parseError(str2, hash) {
        if (this.yy.parser) {
          this.yy.parser.parseError(str2, hash);
        } else {
          throw new Error(str2);
        }
      },
      // resets the lexer, sets new input
      setInput: function(input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = "";
        this.conditionStack = ["INITIAL"];
        this.yylloc = {
          first_line: 1,
          first_column: 0,
          last_line: 1,
          last_column: 0
        };
        if (this.options.ranges) {
          this.yylloc.range = [0, 0];
        }
        this.offset = 0;
        return this;
      },
      // consumes and returns one char from the input
      input: function() {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno++;
          this.yylloc.last_line++;
        } else {
          this.yylloc.last_column++;
        }
        if (this.options.ranges) {
          this.yylloc.range[1]++;
        }
        this._input = this._input.slice(1);
        return ch;
      },
      // unshifts one char (or a string) into the input
      unput: function(ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);
        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);
        if (lines.length - 1) {
          this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;
        this.yylloc = {
          first_line: this.yylloc.first_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.first_column,
          last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
        };
        if (this.options.ranges) {
          this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
      },
      // When called from action, caches matched text and appends it on next action
      more: function() {
        this._more = true;
        return this;
      },
      // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
      reject: function() {
        if (this.options.backtrack_lexer) {
          this._backtrack = true;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
        return this;
      },
      // retain first n characters of the match
      less: function(n) {
        this.unput(this.match.slice(n));
      },
      // displays already matched input, i.e. for error messages
      pastInput: function() {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
      },
      // displays upcoming input, i.e. for error messages
      upcomingInput: function() {
        var next = this.match;
        if (next.length < 20) {
          next += this._input.substr(0, 20 - next.length);
        }
        return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
      },
      // displays the character position where the lexing error occurred, i.e. for error messages
      showPosition: function() {
        var pre = this.pastInput();
        var c2 = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c2 + "^";
      },
      // test the lexed token: return FALSE when not a match, otherwise return token
      test_match: function(match, indexed_rule) {
        var token, lines, backup;
        if (this.options.backtrack_lexer) {
          backup = {
            yylineno: this.yylineno,
            yylloc: {
              first_line: this.yylloc.first_line,
              last_line: this.last_line,
              first_column: this.yylloc.first_column,
              last_column: this.yylloc.last_column
            },
            yytext: this.yytext,
            match: this.match,
            matches: this.matches,
            matched: this.matched,
            yyleng: this.yyleng,
            offset: this.offset,
            _more: this._more,
            _input: this._input,
            yy: this.yy,
            conditionStack: this.conditionStack.slice(0),
            done: this.done
          };
          if (this.options.ranges) {
            backup.yylloc.range = this.yylloc.range.slice(0);
          }
        }
        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno += lines.length;
        }
        this.yylloc = {
          first_line: this.yylloc.last_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.last_column,
          last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
          this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
          this.done = false;
        }
        if (token) {
          return token;
        } else if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
        return false;
      },
      // return next match in input
      next: function() {
        if (this.done) {
          return this.EOF;
        }
        if (!this._input) {
          this.done = true;
        }
        var token, match, tempMatch, index;
        if (!this._more) {
          this.yytext = "";
          this.match = "";
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
          tempMatch = this._input.match(this.rules[rules[i]]);
          if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
            match = tempMatch;
            index = i;
            if (this.options.backtrack_lexer) {
              token = this.test_match(tempMatch, rules[i]);
              if (token !== false) {
                return token;
              } else if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            } else if (!this.options.flex) {
              break;
            }
          }
        }
        if (match) {
          token = this.test_match(match, rules[index]);
          if (token !== false) {
            return token;
          }
          return false;
        }
        if (this._input === "") {
          return this.EOF;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
      },
      // return next match that has a token
      lex: function lex2() {
        var r = this.next();
        if (r) {
          return r;
        } else {
          return this.lex();
        }
      },
      // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
      begin: function begin(condition) {
        this.conditionStack.push(condition);
      },
      // pop the previously active lexer condition state off the condition stack
      popState: function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
          return this.conditionStack.pop();
        } else {
          return this.conditionStack[0];
        }
      },
      // produce the lexer rule set which is active for the currently active lexer condition state
      _currentRules: function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
          return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
          return this.conditions["INITIAL"].rules;
        }
      },
      // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
      topState: function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
          return this.conditionStack[n];
        } else {
          return "INITIAL";
        }
      },
      // alias for begin(condition)
      pushState: function pushState(condition) {
        this.begin(condition);
      },
      // return the number of states currently on the stack
      stateStackSize: function stateStackSize() {
        return this.conditionStack.length;
      },
      options: { "case-insensitive": true },
      performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
        switch ($avoiding_name_collisions) {
          case 0:
            this.begin("open_directive");
            return 40;
          case 1:
            this.begin("type_directive");
            return 41;
          case 2:
            this.popState();
            this.begin("arg_directive");
            return 33;
          case 3:
            this.popState();
            this.popState();
            return 43;
          case 4:
            return 42;
          case 5:
            this.begin("acc_title");
            return 21;
          case 6:
            this.popState();
            return "acc_title_value";
          case 7:
            this.begin("acc_descr");
            return 23;
          case 8:
            this.popState();
            return "acc_descr_value";
          case 9:
            this.begin("acc_descr_multiline");
            break;
          case 10:
            this.popState();
            break;
          case 11:
            return "acc_descr_multiline_value";
          case 12:
            break;
          case 13:
            break;
          case 14:
            break;
          case 15:
            return 11;
          case 16:
            break;
          case 17:
            break;
          case 18:
            break;
          case 19:
            this.begin("href");
            break;
          case 20:
            this.popState();
            break;
          case 21:
            return 38;
          case 22:
            this.begin("callbackname");
            break;
          case 23:
            this.popState();
            break;
          case 24:
            this.popState();
            this.begin("callbackargs");
            break;
          case 25:
            return 36;
          case 26:
            this.popState();
            break;
          case 27:
            return 37;
          case 28:
            this.begin("click");
            break;
          case 29:
            this.popState();
            break;
          case 30:
            return 35;
          case 31:
            return 5;
          case 32:
            return 12;
          case 33:
            return 13;
          case 34:
            return 14;
          case 35:
            return 15;
          case 36:
            return 16;
          case 37:
            return 18;
          case 38:
            return 17;
          case 39:
            return 19;
          case 40:
            return "date";
          case 41:
            return 20;
          case 42:
            return "accDescription";
          case 43:
            return 26;
          case 44:
            return 28;
          case 45:
            return 29;
          case 46:
            return 33;
          case 47:
            return 7;
          case 48:
            return "INVALID";
        }
      },
      rules: [/^(?:%%\{)/i, /^(?:((?:(?!\}%%)[^:.])*))/i, /^(?::)/i, /^(?:\}%%)/i, /^(?:((?:(?!\}%%).|\n)*))/i, /^(?:accTitle\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*\{\s*)/i, /^(?:[\}])/i, /^(?:[^\}]*)/i, /^(?:%%(?!\{)*[^\n]*)/i, /^(?:[^\}]%%*[^\n]*)/i, /^(?:%%*[^\n]*[\n]*)/i, /^(?:[\n]+)/i, /^(?:\s+)/i, /^(?:#[^\n]*)/i, /^(?:%[^\n]*)/i, /^(?:href[\s]+["])/i, /^(?:["])/i, /^(?:[^"]*)/i, /^(?:call[\s]+)/i, /^(?:\([\s]*\))/i, /^(?:\()/i, /^(?:[^(]*)/i, /^(?:\))/i, /^(?:[^)]*)/i, /^(?:click[\s]+)/i, /^(?:[\s\n])/i, /^(?:[^\s\n]*)/i, /^(?:gantt\b)/i, /^(?:dateFormat\s[^#\n;]+)/i, /^(?:inclusiveEndDates\b)/i, /^(?:topAxis\b)/i, /^(?:axisFormat\s[^#\n;]+)/i, /^(?:tickInterval\s[^#\n;]+)/i, /^(?:includes\s[^#\n;]+)/i, /^(?:excludes\s[^#\n;]+)/i, /^(?:todayMarker\s[^\n;]+)/i, /^(?:\d\d\d\d-\d\d-\d\d\b)/i, /^(?:title\s[^#\n;]+)/i, /^(?:accDescription\s[^#\n;]+)/i, /^(?:section\s[^#:\n;]+)/i, /^(?:[^#:\n;]+)/i, /^(?::[^#\n;]+)/i, /^(?::)/i, /^(?:$)/i, /^(?:.)/i],
      conditions: { "acc_descr_multiline": { "rules": [10, 11], "inclusive": false }, "acc_descr": { "rules": [8], "inclusive": false }, "acc_title": { "rules": [6], "inclusive": false }, "close_directive": { "rules": [], "inclusive": false }, "arg_directive": { "rules": [3, 4], "inclusive": false }, "type_directive": { "rules": [2, 3], "inclusive": false }, "open_directive": { "rules": [1], "inclusive": false }, "callbackargs": { "rules": [26, 27], "inclusive": false }, "callbackname": { "rules": [23, 24, 25], "inclusive": false }, "href": { "rules": [20, 21], "inclusive": false }, "click": { "rules": [29, 30], "inclusive": false }, "INITIAL": { "rules": [0, 5, 7, 9, 12, 13, 14, 15, 16, 17, 18, 19, 22, 28, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48], "inclusive": true } }
    };
    return lexer2;
  }();
  parser2.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  Parser.prototype = parser2;
  parser2.Parser = Parser;
  return new Parser();
}();
parser$6.parser = parser$6;
const ganttParser = parser$6;
const ganttDetector = (txt) => {
  return txt.match(/^\s*gantt/) !== null;
};
dayjs.extend(dayjsIsoWeek);
dayjs.extend(dayjsCustomParseFormat);
dayjs.extend(dayjsAdvancedFormat);
let dateFormat = "";
let axisFormat = "";
let tickInterval = void 0;
let todayMarker = "";
let includes = [];
let excludes = [];
let links = {};
let sections$2 = [];
let tasks$1 = [];
let currentSection$1 = "";
const tags = ["active", "done", "crit", "milestone"];
let funs = [];
let inclusiveEndDates = false;
let topAxis = false;
let lastOrder = 0;
const parseDirective$5 = function(statement, context, type2) {
  mermaidAPI.parseDirective(this, statement, context, type2);
};
const clear$5 = function() {
  sections$2 = [];
  tasks$1 = [];
  currentSection$1 = "";
  funs = [];
  taskCnt = 0;
  lastTask = void 0;
  lastTaskID = void 0;
  rawTasks$1 = [];
  dateFormat = "";
  axisFormat = "";
  tickInterval = void 0;
  todayMarker = "";
  includes = [];
  excludes = [];
  inclusiveEndDates = false;
  topAxis = false;
  lastOrder = 0;
  links = {};
  clear$g();
};
const setAxisFormat = function(txt) {
  axisFormat = txt;
};
const getAxisFormat = function() {
  return axisFormat;
};
const setTickInterval = function(txt) {
  tickInterval = txt;
};
const getTickInterval = function() {
  return tickInterval;
};
const setTodayMarker = function(txt) {
  todayMarker = txt;
};
const getTodayMarker = function() {
  return todayMarker;
};
const setDateFormat = function(txt) {
  dateFormat = txt;
};
const enableInclusiveEndDates = function() {
  inclusiveEndDates = true;
};
const endDatesAreInclusive = function() {
  return inclusiveEndDates;
};
const enableTopAxis = function() {
  topAxis = true;
};
const topAxisEnabled = function() {
  return topAxis;
};
const getDateFormat = function() {
  return dateFormat;
};
const setIncludes = function(txt) {
  includes = txt.toLowerCase().split(/[\s,]+/);
};
const getIncludes = function() {
  return includes;
};
const setExcludes = function(txt) {
  excludes = txt.toLowerCase().split(/[\s,]+/);
};
const getExcludes = function() {
  return excludes;
};
const getLinks = function() {
  return links;
};
const addSection$2 = function(txt) {
  currentSection$1 = txt;
  sections$2.push(txt);
};
const getSections$2 = function() {
  return sections$2;
};
const getTasks$1 = function() {
  let allItemsPricessed = compileTasks$1();
  const maxDepth = 10;
  let iterationCount = 0;
  while (!allItemsPricessed && iterationCount < maxDepth) {
    allItemsPricessed = compileTasks$1();
    iterationCount++;
  }
  tasks$1 = rawTasks$1;
  return tasks$1;
};
const isInvalidDate = function(date, dateFormat2, excludes2, includes2) {
  if (includes2.includes(date.format(dateFormat2.trim()))) {
    return false;
  }
  if (date.isoWeekday() >= 6 && excludes2.includes("weekends")) {
    return true;
  }
  if (excludes2.includes(date.format("dddd").toLowerCase())) {
    return true;
  }
  return excludes2.includes(date.format(dateFormat2.trim()));
};
const checkTaskDates = function(task, dateFormat2, excludes2, includes2) {
  if (!excludes2.length || task.manualEndTime) {
    return;
  }
  let startTime;
  if (task.startTime instanceof Date) {
    startTime = dayjs(task.startTime);
  } else {
    startTime = dayjs(task.startTime, dateFormat2, true);
  }
  startTime = startTime.add(1, "d");
  let originalEndTime;
  if (task.endTime instanceof Date) {
    originalEndTime = dayjs(task.endTime);
  } else {
    originalEndTime = dayjs(task.endTime, dateFormat2, true);
  }
  const [fixedEndTime, renderEndTime] = fixTaskDates(
    startTime,
    originalEndTime,
    dateFormat2,
    excludes2,
    includes2
  );
  task.endTime = fixedEndTime.toDate();
  task.renderEndTime = renderEndTime;
};
const fixTaskDates = function(startTime, endTime, dateFormat2, excludes2, includes2) {
  let invalid = false;
  let renderEndTime = null;
  while (startTime <= endTime) {
    if (!invalid) {
      renderEndTime = endTime.toDate();
    }
    invalid = isInvalidDate(startTime, dateFormat2, excludes2, includes2);
    if (invalid) {
      endTime = endTime.add(1, "d");
    }
    startTime = startTime.add(1, "d");
  }
  return [endTime, renderEndTime];
};
const getStartDate = function(prevTime, dateFormat2, str2) {
  str2 = str2.trim();
  const re = /^after\s+([\d\w- ]+)/;
  const afterStatement = re.exec(str2.trim());
  if (afterStatement !== null) {
    let latestEndingTask = null;
    afterStatement[1].split(" ").forEach(function(id2) {
      let task = findTaskById(id2);
      if (task !== void 0) {
        if (!latestEndingTask) {
          latestEndingTask = task;
        } else {
          if (task.endTime > latestEndingTask.endTime) {
            latestEndingTask = task;
          }
        }
      }
    });
    if (!latestEndingTask) {
      const dt = new Date();
      dt.setHours(0, 0, 0, 0);
      return dt;
    } else {
      return latestEndingTask.endTime;
    }
  }
  let mDate = dayjs(str2, dateFormat2.trim(), true);
  if (mDate.isValid()) {
    return mDate.toDate();
  } else {
    log$1.debug("Invalid date:" + str2);
    log$1.debug("With date format:" + dateFormat2.trim());
    const d = new Date(str2);
    if (d === void 0 || isNaN(d.getTime())) {
      throw new Error("Invalid date:" + str2);
    }
    return d;
  }
};
const parseDuration = function(str2) {
  const statement = /^(\d+(?:\.\d+)?)([Mdhmswy]|ms)$/.exec(str2.trim());
  if (statement !== null) {
    return [Number.parseFloat(statement[1]), statement[2]];
  }
  return [NaN, "ms"];
};
const getEndDate = function(prevTime, dateFormat2, str2, inclusive = false) {
  str2 = str2.trim();
  let mDate = dayjs(str2, dateFormat2.trim(), true);
  if (mDate.isValid()) {
    if (inclusive) {
      mDate = mDate.add(1, "d");
    }
    return mDate.toDate();
  }
  let endTime = dayjs(prevTime);
  const [durationValue, durationUnit] = parseDuration(str2);
  if (!Number.isNaN(durationValue)) {
    const newEndTime = endTime.add(durationValue, durationUnit);
    if (newEndTime.isValid()) {
      endTime = newEndTime;
    }
  }
  return endTime.toDate();
};
let taskCnt = 0;
const parseId = function(idStr) {
  if (idStr === void 0) {
    taskCnt = taskCnt + 1;
    return "task" + taskCnt;
  }
  return idStr;
};
const compileData = function(prevTask, dataStr) {
  let ds;
  if (dataStr.substr(0, 1) === ":") {
    ds = dataStr.substr(1, dataStr.length);
  } else {
    ds = dataStr;
  }
  const data = ds.split(",");
  const task = {};
  getTaskTags(data, task, tags);
  for (let i = 0; i < data.length; i++) {
    data[i] = data[i].trim();
  }
  let endTimeData = "";
  switch (data.length) {
    case 1:
      task.id = parseId();
      task.startTime = prevTask.endTime;
      endTimeData = data[0];
      break;
    case 2:
      task.id = parseId();
      task.startTime = getStartDate(void 0, dateFormat, data[0]);
      endTimeData = data[1];
      break;
    case 3:
      task.id = parseId(data[0]);
      task.startTime = getStartDate(void 0, dateFormat, data[1]);
      endTimeData = data[2];
      break;
  }
  if (endTimeData) {
    task.endTime = getEndDate(task.startTime, dateFormat, endTimeData, inclusiveEndDates);
    task.manualEndTime = dayjs(endTimeData, "YYYY-MM-DD", true).isValid();
    checkTaskDates(task, dateFormat, excludes, includes);
  }
  return task;
};
const parseData = function(prevTaskId, dataStr) {
  let ds;
  if (dataStr.substr(0, 1) === ":") {
    ds = dataStr.substr(1, dataStr.length);
  } else {
    ds = dataStr;
  }
  const data = ds.split(",");
  const task = {};
  getTaskTags(data, task, tags);
  for (let i = 0; i < data.length; i++) {
    data[i] = data[i].trim();
  }
  switch (data.length) {
    case 1:
      task.id = parseId();
      task.startTime = {
        type: "prevTaskEnd",
        id: prevTaskId
      };
      task.endTime = {
        data: data[0]
      };
      break;
    case 2:
      task.id = parseId();
      task.startTime = {
        type: "getStartDate",
        startData: data[0]
      };
      task.endTime = {
        data: data[1]
      };
      break;
    case 3:
      task.id = parseId(data[0]);
      task.startTime = {
        type: "getStartDate",
        startData: data[1]
      };
      task.endTime = {
        data: data[2]
      };
      break;
  }
  return task;
};
let lastTask;
let lastTaskID;
let rawTasks$1 = [];
const taskDb = {};
const addTask$1 = function(descr, data) {
  const rawTask = {
    section: currentSection$1,
    type: currentSection$1,
    processed: false,
    manualEndTime: false,
    renderEndTime: null,
    raw: { data },
    task: descr,
    classes: []
  };
  const taskInfo = parseData(lastTaskID, data);
  rawTask.raw.startTime = taskInfo.startTime;
  rawTask.raw.endTime = taskInfo.endTime;
  rawTask.id = taskInfo.id;
  rawTask.prevTaskId = lastTaskID;
  rawTask.active = taskInfo.active;
  rawTask.done = taskInfo.done;
  rawTask.crit = taskInfo.crit;
  rawTask.milestone = taskInfo.milestone;
  rawTask.order = lastOrder;
  lastOrder++;
  const pos = rawTasks$1.push(rawTask);
  lastTaskID = rawTask.id;
  taskDb[rawTask.id] = pos - 1;
};
const findTaskById = function(id2) {
  const pos = taskDb[id2];
  return rawTasks$1[pos];
};
const addTaskOrg$1 = function(descr, data) {
  const newTask = {
    section: currentSection$1,
    type: currentSection$1,
    description: descr,
    task: descr,
    classes: []
  };
  const taskInfo = compileData(lastTask, data);
  newTask.startTime = taskInfo.startTime;
  newTask.endTime = taskInfo.endTime;
  newTask.id = taskInfo.id;
  newTask.active = taskInfo.active;
  newTask.done = taskInfo.done;
  newTask.crit = taskInfo.crit;
  newTask.milestone = taskInfo.milestone;
  lastTask = newTask;
  tasks$1.push(newTask);
};
const compileTasks$1 = function() {
  const compileTask = function(pos) {
    const task = rawTasks$1[pos];
    let startTime = "";
    switch (rawTasks$1[pos].raw.startTime.type) {
      case "prevTaskEnd": {
        const prevTask = findTaskById(task.prevTaskId);
        task.startTime = prevTask.endTime;
        break;
      }
      case "getStartDate":
        startTime = getStartDate(void 0, dateFormat, rawTasks$1[pos].raw.startTime.startData);
        if (startTime) {
          rawTasks$1[pos].startTime = startTime;
        }
        break;
    }
    if (rawTasks$1[pos].startTime) {
      rawTasks$1[pos].endTime = getEndDate(
        rawTasks$1[pos].startTime,
        dateFormat,
        rawTasks$1[pos].raw.endTime.data,
        inclusiveEndDates
      );
      if (rawTasks$1[pos].endTime) {
        rawTasks$1[pos].processed = true;
        rawTasks$1[pos].manualEndTime = dayjs(
          rawTasks$1[pos].raw.endTime.data,
          "YYYY-MM-DD",
          true
        ).isValid();
        checkTaskDates(rawTasks$1[pos], dateFormat, excludes, includes);
      }
    }
    return rawTasks$1[pos].processed;
  };
  let allProcessed = true;
  for (const [i, rawTask] of rawTasks$1.entries()) {
    compileTask(i);
    allProcessed = allProcessed && rawTask.processed;
  }
  return allProcessed;
};
const setLink = function(ids, _linkStr) {
  let linkStr = _linkStr;
  if (getConfig$1().securityLevel !== "loose") {
    linkStr = sanitizeUrl(_linkStr);
  }
  ids.split(",").forEach(function(id2) {
    let rawTask = findTaskById(id2);
    if (rawTask !== void 0) {
      pushFun(id2, () => {
        window.open(linkStr, "_self");
      });
      links[id2] = linkStr;
    }
  });
  setClass(ids, "clickable");
};
const setClass = function(ids, className) {
  ids.split(",").forEach(function(id2) {
    let rawTask = findTaskById(id2);
    if (rawTask !== void 0) {
      rawTask.classes.push(className);
    }
  });
};
const setClickFun = function(id2, functionName, functionArgs) {
  if (getConfig$1().securityLevel !== "loose") {
    return;
  }
  if (functionName === void 0) {
    return;
  }
  let argList = [];
  if (typeof functionArgs === "string") {
    argList = functionArgs.split(/,(?=(?:(?:[^"]*"){2})*[^"]*$)/);
    for (let i = 0; i < argList.length; i++) {
      let item = argList[i].trim();
      if (item.charAt(0) === '"' && item.charAt(item.length - 1) === '"') {
        item = item.substr(1, item.length - 2);
      }
      argList[i] = item;
    }
  }
  if (argList.length === 0) {
    argList.push(id2);
  }
  let rawTask = findTaskById(id2);
  if (rawTask !== void 0) {
    pushFun(id2, () => {
      utils.runFunc(functionName, ...argList);
    });
  }
};
const pushFun = function(id2, callbackFunction) {
  funs.push(
    function() {
      const elem = document.querySelector(`[id="${id2}"]`);
      if (elem !== null) {
        elem.addEventListener("click", function() {
          callbackFunction();
        });
      }
    },
    function() {
      const elem = document.querySelector(`[id="${id2}-text"]`);
      if (elem !== null) {
        elem.addEventListener("click", function() {
          callbackFunction();
        });
      }
    }
  );
};
const setClickEvent = function(ids, functionName, functionArgs) {
  ids.split(",").forEach(function(id2) {
    setClickFun(id2, functionName, functionArgs);
  });
  setClass(ids, "clickable");
};
const bindFunctions = function(element) {
  funs.forEach(function(fun) {
    fun(element);
  });
};
const ganttDb = {
  parseDirective: parseDirective$5,
  getConfig: () => getConfig$1().gantt,
  clear: clear$5,
  setDateFormat,
  getDateFormat,
  enableInclusiveEndDates,
  endDatesAreInclusive,
  enableTopAxis,
  topAxisEnabled,
  setAxisFormat,
  getAxisFormat,
  setTickInterval,
  getTickInterval,
  setTodayMarker,
  getTodayMarker,
  setAccTitle,
  getAccTitle,
  setDiagramTitle,
  getDiagramTitle,
  setAccDescription,
  getAccDescription,
  addSection: addSection$2,
  getSections: getSections$2,
  getTasks: getTasks$1,
  addTask: addTask$1,
  findTaskById,
  addTaskOrg: addTaskOrg$1,
  setIncludes,
  getIncludes,
  setExcludes,
  getExcludes,
  setClickEvent,
  setLink,
  getLinks,
  bindFunctions,
  parseDuration,
  isInvalidDate
};
function getTaskTags(data, task, tags2) {
  let matchFound = true;
  while (matchFound) {
    matchFound = false;
    tags2.forEach(function(t) {
      const pattern = "^\\s*" + t + "\\s*$";
      const regex = new RegExp(pattern);
      if (data[0].match(regex)) {
        task[t] = true;
        data.shift(1);
        matchFound = true;
      }
    });
  }
}
const setConf$5 = function() {
  log$1.debug("Something is calling, setConf, remove the call");
};
let w;
const draw$8 = function(text, id2, version2, diagObj) {
  const conf2 = getConfig$1().gantt;
  const securityLevel = getConfig$1().securityLevel;
  let sandboxElement;
  if (securityLevel === "sandbox") {
    sandboxElement = select("#i" + id2);
  }
  const root = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
  const doc = securityLevel === "sandbox" ? sandboxElement.nodes()[0].contentDocument : document;
  const elem = doc.getElementById(id2);
  w = elem.parentElement.offsetWidth;
  if (w === void 0) {
    w = 1200;
  }
  if (conf2.useWidth !== void 0) {
    w = conf2.useWidth;
  }
  const taskArray = diagObj.db.getTasks();
  const h = taskArray.length * (conf2.barHeight + conf2.barGap) + 2 * conf2.topPadding;
  elem.setAttribute("viewBox", "0 0 " + w + " " + h);
  const svg = root.select(`[id="${id2}"]`);
  const timeScale = scaleTime().domain([
    min(taskArray, function(d) {
      return d.startTime;
    }),
    max(taskArray, function(d) {
      return d.endTime;
    })
  ]).rangeRound([0, w - conf2.leftPadding - conf2.rightPadding]);
  let categories = [];
  for (const element of taskArray) {
    categories.push(element.type);
  }
  const catsUnfiltered = categories;
  categories = checkUnique(categories);
  function taskCompare(a, b) {
    const taskA = a.startTime;
    const taskB = b.startTime;
    let result = 0;
    if (taskA > taskB) {
      result = 1;
    } else if (taskA < taskB) {
      result = -1;
    }
    return result;
  }
  taskArray.sort(taskCompare);
  makeGant(taskArray, w, h);
  configureSvgSize(svg, h, w, conf2.useMaxWidth);
  svg.append("text").text(diagObj.db.getDiagramTitle()).attr("x", w / 2).attr("y", conf2.titleTopMargin).attr("class", "titleText");
  function makeGant(tasks2, pageWidth, pageHeight) {
    const barHeight = conf2.barHeight;
    const gap = barHeight + conf2.barGap;
    const topPadding = conf2.topPadding;
    const leftPadding = conf2.leftPadding;
    const colorScale = scaleLinear().domain([0, categories.length]).range(["#00B9FA", "#F95002"]).interpolate(interpolateHcl);
    drawExcludeDays(
      gap,
      topPadding,
      leftPadding,
      pageWidth,
      pageHeight,
      tasks2,
      diagObj.db.getExcludes(),
      diagObj.db.getIncludes()
    );
    makeGrid(leftPadding, topPadding, pageWidth, pageHeight);
    drawRects(tasks2, gap, topPadding, leftPadding, barHeight, colorScale, pageWidth);
    vertLabels(gap, topPadding);
    drawToday(leftPadding, topPadding, pageWidth, pageHeight);
  }
  function drawRects(theArray, theGap, theTopPad, theSidePad, theBarHeight, theColorScale, w2) {
    svg.append("g").selectAll("rect").data(theArray).enter().append("rect").attr("x", 0).attr("y", function(d, i) {
      i = d.order;
      return i * theGap + theTopPad - 2;
    }).attr("width", function() {
      return w2 - conf2.rightPadding / 2;
    }).attr("height", theGap).attr("class", function(d) {
      for (const [i, category] of categories.entries()) {
        if (d.type === category) {
          return "section section" + i % conf2.numberSectionStyles;
        }
      }
      return "section section0";
    });
    const rectangles = svg.append("g").selectAll("rect").data(theArray).enter();
    const links2 = diagObj.db.getLinks();
    rectangles.append("rect").attr("id", function(d) {
      return d.id;
    }).attr("rx", 3).attr("ry", 3).attr("x", function(d) {
      if (d.milestone) {
        return timeScale(d.startTime) + theSidePad + 0.5 * (timeScale(d.endTime) - timeScale(d.startTime)) - 0.5 * theBarHeight;
      }
      return timeScale(d.startTime) + theSidePad;
    }).attr("y", function(d, i) {
      i = d.order;
      return i * theGap + theTopPad;
    }).attr("width", function(d) {
      if (d.milestone) {
        return theBarHeight;
      }
      return timeScale(d.renderEndTime || d.endTime) - timeScale(d.startTime);
    }).attr("height", theBarHeight).attr("transform-origin", function(d, i) {
      i = d.order;
      return (timeScale(d.startTime) + theSidePad + 0.5 * (timeScale(d.endTime) - timeScale(d.startTime))).toString() + "px " + (i * theGap + theTopPad + 0.5 * theBarHeight).toString() + "px";
    }).attr("class", function(d) {
      const res = "task";
      let classStr = "";
      if (d.classes.length > 0) {
        classStr = d.classes.join(" ");
      }
      let secNum = 0;
      for (const [i, category] of categories.entries()) {
        if (d.type === category) {
          secNum = i % conf2.numberSectionStyles;
        }
      }
      let taskClass = "";
      if (d.active) {
        if (d.crit) {
          taskClass += " activeCrit";
        } else {
          taskClass = " active";
        }
      } else if (d.done) {
        if (d.crit) {
          taskClass = " doneCrit";
        } else {
          taskClass = " done";
        }
      } else {
        if (d.crit) {
          taskClass += " crit";
        }
      }
      if (taskClass.length === 0) {
        taskClass = " task";
      }
      if (d.milestone) {
        taskClass = " milestone " + taskClass;
      }
      taskClass += secNum;
      taskClass += " " + classStr;
      return res + taskClass;
    });
    rectangles.append("text").attr("id", function(d) {
      return d.id + "-text";
    }).text(function(d) {
      return d.task;
    }).attr("font-size", conf2.fontSize).attr("x", function(d) {
      let startX = timeScale(d.startTime);
      let endX = timeScale(d.renderEndTime || d.endTime);
      if (d.milestone) {
        startX += 0.5 * (timeScale(d.endTime) - timeScale(d.startTime)) - 0.5 * theBarHeight;
      }
      if (d.milestone) {
        endX = startX + theBarHeight;
      }
      const textWidth = this.getBBox().width;
      if (textWidth > endX - startX) {
        if (endX + textWidth + 1.5 * conf2.leftPadding > w2) {
          return startX + theSidePad - 5;
        } else {
          return endX + theSidePad + 5;
        }
      } else {
        return (endX - startX) / 2 + startX + theSidePad;
      }
    }).attr("y", function(d, i) {
      i = d.order;
      return i * theGap + conf2.barHeight / 2 + (conf2.fontSize / 2 - 2) + theTopPad;
    }).attr("text-height", theBarHeight).attr("class", function(d) {
      const startX = timeScale(d.startTime);
      let endX = timeScale(d.endTime);
      if (d.milestone) {
        endX = startX + theBarHeight;
      }
      const textWidth = this.getBBox().width;
      let classStr = "";
      if (d.classes.length > 0) {
        classStr = d.classes.join(" ");
      }
      let secNum = 0;
      for (const [i, category] of categories.entries()) {
        if (d.type === category) {
          secNum = i % conf2.numberSectionStyles;
        }
      }
      let taskType = "";
      if (d.active) {
        if (d.crit) {
          taskType = "activeCritText" + secNum;
        } else {
          taskType = "activeText" + secNum;
        }
      }
      if (d.done) {
        if (d.crit) {
          taskType = taskType + " doneCritText" + secNum;
        } else {
          taskType = taskType + " doneText" + secNum;
        }
      } else {
        if (d.crit) {
          taskType = taskType + " critText" + secNum;
        }
      }
      if (d.milestone) {
        taskType += " milestoneText";
      }
      if (textWidth > endX - startX) {
        if (endX + textWidth + 1.5 * conf2.leftPadding > w2) {
          return classStr + " taskTextOutsideLeft taskTextOutside" + secNum + " " + taskType;
        } else {
          return classStr + " taskTextOutsideRight taskTextOutside" + secNum + " " + taskType + " width-" + textWidth;
        }
      } else {
        return classStr + " taskText taskText" + secNum + " " + taskType + " width-" + textWidth;
      }
    });
    const securityLevel2 = getConfig$1().securityLevel;
    if (securityLevel2 === "sandbox") {
      let sandboxElement2;
      sandboxElement2 = select("#i" + id2);
      const doc2 = sandboxElement2.nodes()[0].contentDocument;
      rectangles.filter(function(d) {
        return links2[d.id] !== void 0;
      }).each(function(o) {
        var taskRect = doc2.querySelector("#" + o.id);
        var taskText = doc2.querySelector("#" + o.id + "-text");
        const oldParent = taskRect.parentNode;
        var Link = doc2.createElement("a");
        Link.setAttribute("xlink:href", links2[o.id]);
        Link.setAttribute("target", "_top");
        oldParent.appendChild(Link);
        Link.appendChild(taskRect);
        Link.appendChild(taskText);
      });
    }
  }
  function drawExcludeDays(theGap, theTopPad, theSidePad, w2, h2, tasks2, excludes2, includes2) {
    const minTime = tasks2.reduce(
      (min2, { startTime }) => min2 ? Math.min(min2, startTime) : startTime,
      0
    );
    const maxTime = tasks2.reduce((max2, { endTime }) => max2 ? Math.max(max2, endTime) : endTime, 0);
    const dateFormat2 = diagObj.db.getDateFormat();
    if (!minTime || !maxTime) {
      return;
    }
    const excludeRanges = [];
    let range = null;
    let d = dayjs(minTime);
    while (d.valueOf() <= maxTime) {
      if (diagObj.db.isInvalidDate(d, dateFormat2, excludes2, includes2)) {
        if (!range) {
          range = {
            start: d,
            end: d
          };
        } else {
          range.end = d;
        }
      } else {
        if (range) {
          excludeRanges.push(range);
          range = null;
        }
      }
      d = d.add(1, "d");
    }
    const rectangles = svg.append("g").selectAll("rect").data(excludeRanges).enter();
    rectangles.append("rect").attr("id", function(d2) {
      return "exclude-" + d2.start.format("YYYY-MM-DD");
    }).attr("x", function(d2) {
      return timeScale(d2.start) + theSidePad;
    }).attr("y", conf2.gridLineStartPadding).attr("width", function(d2) {
      const renderEnd = d2.end.add(1, "day");
      return timeScale(renderEnd) - timeScale(d2.start);
    }).attr("height", h2 - theTopPad - conf2.gridLineStartPadding).attr("transform-origin", function(d2, i) {
      return (timeScale(d2.start) + theSidePad + 0.5 * (timeScale(d2.end) - timeScale(d2.start))).toString() + "px " + (i * theGap + 0.5 * h2).toString() + "px";
    }).attr("class", "exclude-range");
  }
  function makeGrid(theSidePad, theTopPad, w2, h2) {
    let bottomXAxis = axisBottom(timeScale).tickSize(-h2 + theTopPad + conf2.gridLineStartPadding).tickFormat(timeFormat(diagObj.db.getAxisFormat() || conf2.axisFormat || "%Y-%m-%d"));
    const reTickInterval = /^([1-9]\d*)(minute|hour|day|week|month)$/;
    const resultTickInterval = reTickInterval.exec(
      diagObj.db.getTickInterval() || conf2.tickInterval
    );
    if (resultTickInterval !== null) {
      const every = resultTickInterval[1];
      const interval = resultTickInterval[2];
      switch (interval) {
        case "minute":
          bottomXAxis.ticks(timeMinute.every(every));
          break;
        case "hour":
          bottomXAxis.ticks(timeHour.every(every));
          break;
        case "day":
          bottomXAxis.ticks(timeDay.every(every));
          break;
        case "week":
          bottomXAxis.ticks(timeWeek.every(every));
          break;
        case "month":
          bottomXAxis.ticks(timeMonth.every(every));
          break;
      }
    }
    svg.append("g").attr("class", "grid").attr("transform", "translate(" + theSidePad + ", " + (h2 - 50) + ")").call(bottomXAxis).selectAll("text").style("text-anchor", "middle").attr("fill", "#000").attr("stroke", "none").attr("font-size", 10).attr("dy", "1em");
    if (diagObj.db.topAxisEnabled() || conf2.topAxis) {
      let topXAxis = axisTop(timeScale).tickSize(-h2 + theTopPad + conf2.gridLineStartPadding).tickFormat(timeFormat(diagObj.db.getAxisFormat() || conf2.axisFormat || "%Y-%m-%d"));
      if (resultTickInterval !== null) {
        const every = resultTickInterval[1];
        const interval = resultTickInterval[2];
        switch (interval) {
          case "minute":
            topXAxis.ticks(timeMinute.every(every));
            break;
          case "hour":
            topXAxis.ticks(timeHour.every(every));
            break;
          case "day":
            topXAxis.ticks(timeDay.every(every));
            break;
          case "week":
            topXAxis.ticks(timeWeek.every(every));
            break;
          case "month":
            topXAxis.ticks(timeMonth.every(every));
            break;
        }
      }
      svg.append("g").attr("class", "grid").attr("transform", "translate(" + theSidePad + ", " + theTopPad + ")").call(topXAxis).selectAll("text").style("text-anchor", "middle").attr("fill", "#000").attr("stroke", "none").attr("font-size", 10);
    }
  }
  function vertLabels(theGap, theTopPad) {
    const numOccurances = [];
    let prevGap = 0;
    for (const [i, category] of categories.entries()) {
      numOccurances[i] = [category, getCount(category, catsUnfiltered)];
    }
    svg.append("g").selectAll("text").data(numOccurances).enter().append(function(d) {
      const rows = d[0].split(common$1.lineBreakRegex);
      const dy = -(rows.length - 1) / 2;
      const svgLabel = doc.createElementNS("http://www.w3.org/2000/svg", "text");
      svgLabel.setAttribute("dy", dy + "em");
      for (const [j, row] of rows.entries()) {
        const tspan = doc.createElementNS("http://www.w3.org/2000/svg", "tspan");
        tspan.setAttribute("alignment-baseline", "central");
        tspan.setAttribute("x", "10");
        if (j > 0) {
          tspan.setAttribute("dy", "1em");
        }
        tspan.textContent = row;
        svgLabel.appendChild(tspan);
      }
      return svgLabel;
    }).attr("x", 10).attr("y", function(d, i) {
      if (i > 0) {
        for (let j = 0; j < i; j++) {
          prevGap += numOccurances[i - 1][1];
          return d[1] * theGap / 2 + prevGap * theGap + theTopPad;
        }
      } else {
        return d[1] * theGap / 2 + theTopPad;
      }
    }).attr("font-size", conf2.sectionFontSize).attr("font-size", conf2.sectionFontSize).attr("class", function(d) {
      for (const [i, category] of categories.entries()) {
        if (d[0] === category) {
          return "sectionTitle sectionTitle" + i % conf2.numberSectionStyles;
        }
      }
      return "sectionTitle";
    });
  }
  function drawToday(theSidePad, theTopPad, w2, h2) {
    const todayMarker2 = diagObj.db.getTodayMarker();
    if (todayMarker2 === "off") {
      return;
    }
    const todayG = svg.append("g").attr("class", "today");
    const today = new Date();
    const todayLine = todayG.append("line");
    todayLine.attr("x1", timeScale(today) + theSidePad).attr("x2", timeScale(today) + theSidePad).attr("y1", conf2.titleTopMargin).attr("y2", h2 - conf2.titleTopMargin).attr("class", "today");
    if (todayMarker2 !== "") {
      todayLine.attr("style", todayMarker2.replace(/,/g, ";"));
    }
  }
  function checkUnique(arr) {
    const hash = {};
    const result = [];
    for (let i = 0, l = arr.length; i < l; ++i) {
      if (!Object.prototype.hasOwnProperty.call(hash, arr[i])) {
        hash[arr[i]] = true;
        result.push(arr[i]);
      }
    }
    return result;
  }
  function getCounts(arr) {
    let i = arr.length;
    const obj = {};
    while (i) {
      obj[arr[--i]] = (obj[arr[i]] || 0) + 1;
    }
    return obj;
  }
  function getCount(word, arr) {
    return getCounts(arr)[word] || 0;
  }
};
const ganttRenderer = {
  setConf: setConf$5,
  draw: draw$8
};
var parser$5 = function() {
  var o = function(k, v, o2, l) {
    for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
      ;
    return o2;
  }, $V0 = [6, 9, 10];
  var parser2 = {
    trace: function trace() {
    },
    yy: {},
    symbols_: { "error": 2, "start": 3, "info": 4, "document": 5, "EOF": 6, "line": 7, "statement": 8, "NL": 9, "showInfo": 10, "$accept": 0, "$end": 1 },
    terminals_: { 2: "error", 4: "info", 6: "EOF", 9: "NL", 10: "showInfo" },
    productions_: [0, [3, 3], [5, 0], [5, 2], [7, 1], [7, 1], [8, 1]],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
      $$.length - 1;
      switch (yystate) {
        case 1:
          return yy;
        case 4:
          break;
        case 6:
          yy.setInfo(true);
          break;
      }
    },
    table: [{ 3: 1, 4: [1, 2] }, { 1: [3] }, o($V0, [2, 2], { 5: 3 }), { 6: [1, 4], 7: 5, 8: 6, 9: [1, 7], 10: [1, 8] }, { 1: [2, 1] }, o($V0, [2, 3]), o($V0, [2, 4]), o($V0, [2, 5]), o($V0, [2, 6])],
    defaultActions: { 4: [2, 1] },
    parseError: function parseError(str2, hash) {
      if (hash.recoverable) {
        this.trace(str2);
      } else {
        var error = new Error(str2);
        error.hash = hash;
        throw error;
      }
    },
    parse: function parse2(input) {
      var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
      var args = lstack.slice.call(arguments, 1);
      var lexer2 = Object.create(this.lexer);
      var sharedState = { yy: {} };
      for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
          sharedState.yy[k] = this.yy[k];
        }
      }
      lexer2.setInput(input, sharedState.yy);
      sharedState.yy.lexer = lexer2;
      sharedState.yy.parser = this;
      if (typeof lexer2.yylloc == "undefined") {
        lexer2.yylloc = {};
      }
      var yyloc = lexer2.yylloc;
      lstack.push(yyloc);
      var ranges = lexer2.options && lexer2.options.ranges;
      if (typeof sharedState.yy.parseError === "function") {
        this.parseError = sharedState.yy.parseError;
      } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
      }
      function lex2() {
        var token;
        token = tstack.pop() || lexer2.lex() || EOF;
        if (typeof token !== "number") {
          if (token instanceof Array) {
            tstack = token;
            token = tstack.pop();
          }
          token = self.symbols_[token] || token;
        }
        return token;
      }
      var symbol, state, action, r, yyval = {}, p, len, newState, expected;
      while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
          action = this.defaultActions[state];
        } else {
          if (symbol === null || typeof symbol == "undefined") {
            symbol = lex2();
          }
          action = table[state] && table[state][symbol];
        }
        if (typeof action === "undefined" || !action.length || !action[0]) {
          var errStr = "";
          expected = [];
          for (p in table[state]) {
            if (this.terminals_[p] && p > TERROR) {
              expected.push("'" + this.terminals_[p] + "'");
            }
          }
          if (lexer2.showPosition) {
            errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
          } else {
            errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
          }
          this.parseError(errStr, {
            text: lexer2.match,
            token: this.terminals_[symbol] || symbol,
            line: lexer2.yylineno,
            loc: yyloc,
            expected
          });
        }
        if (action[0] instanceof Array && action.length > 1) {
          throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
        }
        switch (action[0]) {
          case 1:
            stack.push(symbol);
            vstack.push(lexer2.yytext);
            lstack.push(lexer2.yylloc);
            stack.push(action[1]);
            symbol = null;
            {
              yyleng = lexer2.yyleng;
              yytext = lexer2.yytext;
              yylineno = lexer2.yylineno;
              yyloc = lexer2.yylloc;
            }
            break;
          case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
              first_line: lstack[lstack.length - (len || 1)].first_line,
              last_line: lstack[lstack.length - 1].last_line,
              first_column: lstack[lstack.length - (len || 1)].first_column,
              last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
              yyval._$.range = [
                lstack[lstack.length - (len || 1)].range[0],
                lstack[lstack.length - 1].range[1]
              ];
            }
            r = this.performAction.apply(yyval, [
              yytext,
              yyleng,
              yylineno,
              sharedState.yy,
              action[1],
              vstack,
              lstack
            ].concat(args));
            if (typeof r !== "undefined") {
              return r;
            }
            if (len) {
              stack = stack.slice(0, -1 * len * 2);
              vstack = vstack.slice(0, -1 * len);
              lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
          case 3:
            return true;
        }
      }
      return true;
    }
  };
  var lexer = function() {
    var lexer2 = {
      EOF: 1,
      parseError: function parseError(str2, hash) {
        if (this.yy.parser) {
          this.yy.parser.parseError(str2, hash);
        } else {
          throw new Error(str2);
        }
      },
      // resets the lexer, sets new input
      setInput: function(input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = "";
        this.conditionStack = ["INITIAL"];
        this.yylloc = {
          first_line: 1,
          first_column: 0,
          last_line: 1,
          last_column: 0
        };
        if (this.options.ranges) {
          this.yylloc.range = [0, 0];
        }
        this.offset = 0;
        return this;
      },
      // consumes and returns one char from the input
      input: function() {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno++;
          this.yylloc.last_line++;
        } else {
          this.yylloc.last_column++;
        }
        if (this.options.ranges) {
          this.yylloc.range[1]++;
        }
        this._input = this._input.slice(1);
        return ch;
      },
      // unshifts one char (or a string) into the input
      unput: function(ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);
        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);
        if (lines.length - 1) {
          this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;
        this.yylloc = {
          first_line: this.yylloc.first_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.first_column,
          last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
        };
        if (this.options.ranges) {
          this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
      },
      // When called from action, caches matched text and appends it on next action
      more: function() {
        this._more = true;
        return this;
      },
      // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
      reject: function() {
        if (this.options.backtrack_lexer) {
          this._backtrack = true;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
        return this;
      },
      // retain first n characters of the match
      less: function(n) {
        this.unput(this.match.slice(n));
      },
      // displays already matched input, i.e. for error messages
      pastInput: function() {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
      },
      // displays upcoming input, i.e. for error messages
      upcomingInput: function() {
        var next = this.match;
        if (next.length < 20) {
          next += this._input.substr(0, 20 - next.length);
        }
        return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
      },
      // displays the character position where the lexing error occurred, i.e. for error messages
      showPosition: function() {
        var pre = this.pastInput();
        var c2 = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c2 + "^";
      },
      // test the lexed token: return FALSE when not a match, otherwise return token
      test_match: function(match, indexed_rule) {
        var token, lines, backup;
        if (this.options.backtrack_lexer) {
          backup = {
            yylineno: this.yylineno,
            yylloc: {
              first_line: this.yylloc.first_line,
              last_line: this.last_line,
              first_column: this.yylloc.first_column,
              last_column: this.yylloc.last_column
            },
            yytext: this.yytext,
            match: this.match,
            matches: this.matches,
            matched: this.matched,
            yyleng: this.yyleng,
            offset: this.offset,
            _more: this._more,
            _input: this._input,
            yy: this.yy,
            conditionStack: this.conditionStack.slice(0),
            done: this.done
          };
          if (this.options.ranges) {
            backup.yylloc.range = this.yylloc.range.slice(0);
          }
        }
        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno += lines.length;
        }
        this.yylloc = {
          first_line: this.yylloc.last_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.last_column,
          last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
          this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
          this.done = false;
        }
        if (token) {
          return token;
        } else if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
        return false;
      },
      // return next match in input
      next: function() {
        if (this.done) {
          return this.EOF;
        }
        if (!this._input) {
          this.done = true;
        }
        var token, match, tempMatch, index;
        if (!this._more) {
          this.yytext = "";
          this.match = "";
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
          tempMatch = this._input.match(this.rules[rules[i]]);
          if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
            match = tempMatch;
            index = i;
            if (this.options.backtrack_lexer) {
              token = this.test_match(tempMatch, rules[i]);
              if (token !== false) {
                return token;
              } else if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            } else if (!this.options.flex) {
              break;
            }
          }
        }
        if (match) {
          token = this.test_match(match, rules[index]);
          if (token !== false) {
            return token;
          }
          return false;
        }
        if (this._input === "") {
          return this.EOF;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
      },
      // return next match that has a token
      lex: function lex2() {
        var r = this.next();
        if (r) {
          return r;
        } else {
          return this.lex();
        }
      },
      // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
      begin: function begin(condition) {
        this.conditionStack.push(condition);
      },
      // pop the previously active lexer condition state off the condition stack
      popState: function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
          return this.conditionStack.pop();
        } else {
          return this.conditionStack[0];
        }
      },
      // produce the lexer rule set which is active for the currently active lexer condition state
      _currentRules: function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
          return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
          return this.conditions["INITIAL"].rules;
        }
      },
      // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
      topState: function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
          return this.conditionStack[n];
        } else {
          return "INITIAL";
        }
      },
      // alias for begin(condition)
      pushState: function pushState(condition) {
        this.begin(condition);
      },
      // return the number of states currently on the stack
      stateStackSize: function stateStackSize() {
        return this.conditionStack.length;
      },
      options: { "case-insensitive": true },
      performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
        switch ($avoiding_name_collisions) {
          case 0:
            return 4;
          case 1:
            return 9;
          case 2:
            return "space";
          case 3:
            return 10;
          case 4:
            return 6;
          case 5:
            return "TXT";
        }
      },
      rules: [/^(?:info\b)/i, /^(?:[\s\n\r]+)/i, /^(?:[\s]+)/i, /^(?:showInfo\b)/i, /^(?:$)/i, /^(?:.)/i],
      conditions: { "INITIAL": { "rules": [0, 1, 2, 3, 4, 5], "inclusive": true } }
    };
    return lexer2;
  }();
  parser2.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  Parser.prototype = parser2;
  parser2.Parser = Parser;
  return new Parser();
}();
parser$5.parser = parser$5;
const infoParser = parser$5;
var message = "";
var info = false;
const setMessage = (txt) => {
  log$1.debug("Setting message to: " + txt);
  message = txt;
};
const getMessage = () => {
  return message;
};
const setInfo = (inf) => {
  info = inf;
};
const getInfo = () => {
  return info;
};
const infoDb = {
  setMessage,
  getMessage,
  setInfo,
  getInfo,
  clear: clear$g
  // parseError
};
const draw$7 = (text, id2, version2) => {
  try {
    log$1.debug("Rendering info diagram\n" + text);
    const securityLevel = getConfig$1().securityLevel;
    let sandboxElement;
    if (securityLevel === "sandbox") {
      sandboxElement = select("#i" + id2);
    }
    const root = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
    const svg = root.select("#" + id2);
    const g = svg.append("g");
    g.append("text").attr("x", 100).attr("y", 40).attr("class", "version").attr("font-size", "32px").style("text-anchor", "middle").text("v " + version2);
    svg.attr("height", 100);
    svg.attr("width", 400);
  } catch (e) {
    log$1.error("Error while rendering info diagram");
    log$1.error(e.message);
  }
};
const infoRenderer = {
  draw: draw$7
};
const infoDetector = (txt) => {
  return txt.match(/^\s*info/) !== null;
};
var parser$4 = function() {
  var o = function(k, v, o2, l) {
    for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
      ;
    return o2;
  }, $V0 = [1, 4], $V1 = [1, 5], $V2 = [1, 6], $V3 = [1, 7], $V4 = [1, 9], $V5 = [1, 11, 13, 15, 17, 19, 20, 26, 27, 28, 29], $V6 = [2, 5], $V7 = [1, 6, 11, 13, 15, 17, 19, 20, 26, 27, 28, 29], $V8 = [26, 27, 28], $V9 = [2, 8], $Va = [1, 18], $Vb = [1, 19], $Vc = [1, 20], $Vd = [1, 21], $Ve = [1, 22], $Vf = [1, 23], $Vg = [1, 28], $Vh = [6, 26, 27, 28, 29];
  var parser2 = {
    trace: function trace() {
    },
    yy: {},
    symbols_: { "error": 2, "start": 3, "eol": 4, "directive": 5, "PIE": 6, "document": 7, "showData": 8, "line": 9, "statement": 10, "txt": 11, "value": 12, "title": 13, "title_value": 14, "acc_title": 15, "acc_title_value": 16, "acc_descr": 17, "acc_descr_value": 18, "acc_descr_multiline_value": 19, "section": 20, "openDirective": 21, "typeDirective": 22, "closeDirective": 23, ":": 24, "argDirective": 25, "NEWLINE": 26, ";": 27, "EOF": 28, "open_directive": 29, "type_directive": 30, "arg_directive": 31, "close_directive": 32, "$accept": 0, "$end": 1 },
    terminals_: { 2: "error", 6: "PIE", 8: "showData", 11: "txt", 12: "value", 13: "title", 14: "title_value", 15: "acc_title", 16: "acc_title_value", 17: "acc_descr", 18: "acc_descr_value", 19: "acc_descr_multiline_value", 20: "section", 24: ":", 26: "NEWLINE", 27: ";", 28: "EOF", 29: "open_directive", 30: "type_directive", 31: "arg_directive", 32: "close_directive" },
    productions_: [0, [3, 2], [3, 2], [3, 2], [3, 3], [7, 0], [7, 2], [9, 2], [10, 0], [10, 2], [10, 2], [10, 2], [10, 2], [10, 1], [10, 1], [10, 1], [5, 3], [5, 5], [4, 1], [4, 1], [4, 1], [21, 1], [22, 1], [25, 1], [23, 1]],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
      var $0 = $$.length - 1;
      switch (yystate) {
        case 4:
          yy.setShowData(true);
          break;
        case 7:
          this.$ = $$[$0 - 1];
          break;
        case 9:
          yy.addSection($$[$0 - 1], yy.cleanupValue($$[$0]));
          break;
        case 10:
          this.$ = $$[$0].trim();
          yy.setDiagramTitle(this.$);
          break;
        case 11:
          this.$ = $$[$0].trim();
          yy.setAccTitle(this.$);
          break;
        case 12:
        case 13:
          this.$ = $$[$0].trim();
          yy.setAccDescription(this.$);
          break;
        case 14:
          yy.addSection($$[$0].substr(8));
          this.$ = $$[$0].substr(8);
          break;
        case 21:
          yy.parseDirective("%%{", "open_directive");
          break;
        case 22:
          yy.parseDirective($$[$0], "type_directive");
          break;
        case 23:
          $$[$0] = $$[$0].trim().replace(/'/g, '"');
          yy.parseDirective($$[$0], "arg_directive");
          break;
        case 24:
          yy.parseDirective("}%%", "close_directive", "pie");
          break;
      }
    },
    table: [{ 3: 1, 4: 2, 5: 3, 6: $V0, 21: 8, 26: $V1, 27: $V2, 28: $V3, 29: $V4 }, { 1: [3] }, { 3: 10, 4: 2, 5: 3, 6: $V0, 21: 8, 26: $V1, 27: $V2, 28: $V3, 29: $V4 }, { 3: 11, 4: 2, 5: 3, 6: $V0, 21: 8, 26: $V1, 27: $V2, 28: $V3, 29: $V4 }, o($V5, $V6, { 7: 12, 8: [1, 13] }), o($V7, [2, 18]), o($V7, [2, 19]), o($V7, [2, 20]), { 22: 14, 30: [1, 15] }, { 30: [2, 21] }, { 1: [2, 1] }, { 1: [2, 2] }, o($V8, $V9, { 21: 8, 9: 16, 10: 17, 5: 24, 1: [2, 3], 11: $Va, 13: $Vb, 15: $Vc, 17: $Vd, 19: $Ve, 20: $Vf, 29: $V4 }), o($V5, $V6, { 7: 25 }), { 23: 26, 24: [1, 27], 32: $Vg }, o([24, 32], [2, 22]), o($V5, [2, 6]), { 4: 29, 26: $V1, 27: $V2, 28: $V3 }, { 12: [1, 30] }, { 14: [1, 31] }, { 16: [1, 32] }, { 18: [1, 33] }, o($V8, [2, 13]), o($V8, [2, 14]), o($V8, [2, 15]), o($V8, $V9, { 21: 8, 9: 16, 10: 17, 5: 24, 1: [2, 4], 11: $Va, 13: $Vb, 15: $Vc, 17: $Vd, 19: $Ve, 20: $Vf, 29: $V4 }), o($Vh, [2, 16]), { 25: 34, 31: [1, 35] }, o($Vh, [2, 24]), o($V5, [2, 7]), o($V8, [2, 9]), o($V8, [2, 10]), o($V8, [2, 11]), o($V8, [2, 12]), { 23: 36, 32: $Vg }, { 32: [2, 23] }, o($Vh, [2, 17])],
    defaultActions: { 9: [2, 21], 10: [2, 1], 11: [2, 2], 35: [2, 23] },
    parseError: function parseError(str2, hash) {
      if (hash.recoverable) {
        this.trace(str2);
      } else {
        var error = new Error(str2);
        error.hash = hash;
        throw error;
      }
    },
    parse: function parse2(input) {
      var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
      var args = lstack.slice.call(arguments, 1);
      var lexer2 = Object.create(this.lexer);
      var sharedState = { yy: {} };
      for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
          sharedState.yy[k] = this.yy[k];
        }
      }
      lexer2.setInput(input, sharedState.yy);
      sharedState.yy.lexer = lexer2;
      sharedState.yy.parser = this;
      if (typeof lexer2.yylloc == "undefined") {
        lexer2.yylloc = {};
      }
      var yyloc = lexer2.yylloc;
      lstack.push(yyloc);
      var ranges = lexer2.options && lexer2.options.ranges;
      if (typeof sharedState.yy.parseError === "function") {
        this.parseError = sharedState.yy.parseError;
      } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
      }
      function lex2() {
        var token;
        token = tstack.pop() || lexer2.lex() || EOF;
        if (typeof token !== "number") {
          if (token instanceof Array) {
            tstack = token;
            token = tstack.pop();
          }
          token = self.symbols_[token] || token;
        }
        return token;
      }
      var symbol, state, action, r, yyval = {}, p, len, newState, expected;
      while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
          action = this.defaultActions[state];
        } else {
          if (symbol === null || typeof symbol == "undefined") {
            symbol = lex2();
          }
          action = table[state] && table[state][symbol];
        }
        if (typeof action === "undefined" || !action.length || !action[0]) {
          var errStr = "";
          expected = [];
          for (p in table[state]) {
            if (this.terminals_[p] && p > TERROR) {
              expected.push("'" + this.terminals_[p] + "'");
            }
          }
          if (lexer2.showPosition) {
            errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
          } else {
            errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
          }
          this.parseError(errStr, {
            text: lexer2.match,
            token: this.terminals_[symbol] || symbol,
            line: lexer2.yylineno,
            loc: yyloc,
            expected
          });
        }
        if (action[0] instanceof Array && action.length > 1) {
          throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
        }
        switch (action[0]) {
          case 1:
            stack.push(symbol);
            vstack.push(lexer2.yytext);
            lstack.push(lexer2.yylloc);
            stack.push(action[1]);
            symbol = null;
            {
              yyleng = lexer2.yyleng;
              yytext = lexer2.yytext;
              yylineno = lexer2.yylineno;
              yyloc = lexer2.yylloc;
            }
            break;
          case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
              first_line: lstack[lstack.length - (len || 1)].first_line,
              last_line: lstack[lstack.length - 1].last_line,
              first_column: lstack[lstack.length - (len || 1)].first_column,
              last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
              yyval._$.range = [
                lstack[lstack.length - (len || 1)].range[0],
                lstack[lstack.length - 1].range[1]
              ];
            }
            r = this.performAction.apply(yyval, [
              yytext,
              yyleng,
              yylineno,
              sharedState.yy,
              action[1],
              vstack,
              lstack
            ].concat(args));
            if (typeof r !== "undefined") {
              return r;
            }
            if (len) {
              stack = stack.slice(0, -1 * len * 2);
              vstack = vstack.slice(0, -1 * len);
              lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
          case 3:
            return true;
        }
      }
      return true;
    }
  };
  var lexer = function() {
    var lexer2 = {
      EOF: 1,
      parseError: function parseError(str2, hash) {
        if (this.yy.parser) {
          this.yy.parser.parseError(str2, hash);
        } else {
          throw new Error(str2);
        }
      },
      // resets the lexer, sets new input
      setInput: function(input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = "";
        this.conditionStack = ["INITIAL"];
        this.yylloc = {
          first_line: 1,
          first_column: 0,
          last_line: 1,
          last_column: 0
        };
        if (this.options.ranges) {
          this.yylloc.range = [0, 0];
        }
        this.offset = 0;
        return this;
      },
      // consumes and returns one char from the input
      input: function() {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno++;
          this.yylloc.last_line++;
        } else {
          this.yylloc.last_column++;
        }
        if (this.options.ranges) {
          this.yylloc.range[1]++;
        }
        this._input = this._input.slice(1);
        return ch;
      },
      // unshifts one char (or a string) into the input
      unput: function(ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);
        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);
        if (lines.length - 1) {
          this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;
        this.yylloc = {
          first_line: this.yylloc.first_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.first_column,
          last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
        };
        if (this.options.ranges) {
          this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
      },
      // When called from action, caches matched text and appends it on next action
      more: function() {
        this._more = true;
        return this;
      },
      // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
      reject: function() {
        if (this.options.backtrack_lexer) {
          this._backtrack = true;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
        return this;
      },
      // retain first n characters of the match
      less: function(n) {
        this.unput(this.match.slice(n));
      },
      // displays already matched input, i.e. for error messages
      pastInput: function() {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
      },
      // displays upcoming input, i.e. for error messages
      upcomingInput: function() {
        var next = this.match;
        if (next.length < 20) {
          next += this._input.substr(0, 20 - next.length);
        }
        return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
      },
      // displays the character position where the lexing error occurred, i.e. for error messages
      showPosition: function() {
        var pre = this.pastInput();
        var c2 = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c2 + "^";
      },
      // test the lexed token: return FALSE when not a match, otherwise return token
      test_match: function(match, indexed_rule) {
        var token, lines, backup;
        if (this.options.backtrack_lexer) {
          backup = {
            yylineno: this.yylineno,
            yylloc: {
              first_line: this.yylloc.first_line,
              last_line: this.last_line,
              first_column: this.yylloc.first_column,
              last_column: this.yylloc.last_column
            },
            yytext: this.yytext,
            match: this.match,
            matches: this.matches,
            matched: this.matched,
            yyleng: this.yyleng,
            offset: this.offset,
            _more: this._more,
            _input: this._input,
            yy: this.yy,
            conditionStack: this.conditionStack.slice(0),
            done: this.done
          };
          if (this.options.ranges) {
            backup.yylloc.range = this.yylloc.range.slice(0);
          }
        }
        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno += lines.length;
        }
        this.yylloc = {
          first_line: this.yylloc.last_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.last_column,
          last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
          this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
          this.done = false;
        }
        if (token) {
          return token;
        } else if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
        return false;
      },
      // return next match in input
      next: function() {
        if (this.done) {
          return this.EOF;
        }
        if (!this._input) {
          this.done = true;
        }
        var token, match, tempMatch, index;
        if (!this._more) {
          this.yytext = "";
          this.match = "";
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
          tempMatch = this._input.match(this.rules[rules[i]]);
          if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
            match = tempMatch;
            index = i;
            if (this.options.backtrack_lexer) {
              token = this.test_match(tempMatch, rules[i]);
              if (token !== false) {
                return token;
              } else if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            } else if (!this.options.flex) {
              break;
            }
          }
        }
        if (match) {
          token = this.test_match(match, rules[index]);
          if (token !== false) {
            return token;
          }
          return false;
        }
        if (this._input === "") {
          return this.EOF;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
      },
      // return next match that has a token
      lex: function lex2() {
        var r = this.next();
        if (r) {
          return r;
        } else {
          return this.lex();
        }
      },
      // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
      begin: function begin(condition) {
        this.conditionStack.push(condition);
      },
      // pop the previously active lexer condition state off the condition stack
      popState: function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
          return this.conditionStack.pop();
        } else {
          return this.conditionStack[0];
        }
      },
      // produce the lexer rule set which is active for the currently active lexer condition state
      _currentRules: function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
          return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
          return this.conditions["INITIAL"].rules;
        }
      },
      // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
      topState: function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
          return this.conditionStack[n];
        } else {
          return "INITIAL";
        }
      },
      // alias for begin(condition)
      pushState: function pushState(condition) {
        this.begin(condition);
      },
      // return the number of states currently on the stack
      stateStackSize: function stateStackSize() {
        return this.conditionStack.length;
      },
      options: { "case-insensitive": true },
      performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
        switch ($avoiding_name_collisions) {
          case 0:
            this.begin("open_directive");
            return 29;
          case 1:
            this.begin("type_directive");
            return 30;
          case 2:
            this.popState();
            this.begin("arg_directive");
            return 24;
          case 3:
            this.popState();
            this.popState();
            return 32;
          case 4:
            return 31;
          case 5:
            break;
          case 6:
            break;
          case 7:
            return 26;
          case 8:
            break;
          case 9:
            break;
          case 10:
            this.begin("title");
            return 13;
          case 11:
            this.popState();
            return "title_value";
          case 12:
            this.begin("acc_title");
            return 15;
          case 13:
            this.popState();
            return "acc_title_value";
          case 14:
            this.begin("acc_descr");
            return 17;
          case 15:
            this.popState();
            return "acc_descr_value";
          case 16:
            this.begin("acc_descr_multiline");
            break;
          case 17:
            this.popState();
            break;
          case 18:
            return "acc_descr_multiline_value";
          case 19:
            this.begin("string");
            break;
          case 20:
            this.popState();
            break;
          case 21:
            return "txt";
          case 22:
            return 6;
          case 23:
            return 8;
          case 24:
            return "value";
          case 25:
            return 28;
        }
      },
      rules: [/^(?:%%\{)/i, /^(?:((?:(?!\}%%)[^:.])*))/i, /^(?::)/i, /^(?:\}%%)/i, /^(?:((?:(?!\}%%).|\n)*))/i, /^(?:%%(?!\{)[^\n]*)/i, /^(?:[^\}]%%[^\n]*)/i, /^(?:[\n\r]+)/i, /^(?:%%[^\n]*)/i, /^(?:[\s]+)/i, /^(?:title\b)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accTitle\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*\{\s*)/i, /^(?:[\}])/i, /^(?:[^\}]*)/i, /^(?:["])/i, /^(?:["])/i, /^(?:[^"]*)/i, /^(?:pie\b)/i, /^(?:showData\b)/i, /^(?::[\s]*[\d]+(?:\.[\d]+)?)/i, /^(?:$)/i],
      conditions: { "acc_descr_multiline": { "rules": [17, 18], "inclusive": false }, "acc_descr": { "rules": [15], "inclusive": false }, "acc_title": { "rules": [13], "inclusive": false }, "close_directive": { "rules": [], "inclusive": false }, "arg_directive": { "rules": [3, 4], "inclusive": false }, "type_directive": { "rules": [2, 3], "inclusive": false }, "open_directive": { "rules": [1], "inclusive": false }, "title": { "rules": [11], "inclusive": false }, "string": { "rules": [20, 21], "inclusive": false }, "INITIAL": { "rules": [0, 5, 6, 7, 8, 9, 10, 12, 14, 16, 19, 22, 23, 24, 25], "inclusive": true } }
    };
    return lexer2;
  }();
  parser2.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  Parser.prototype = parser2;
  parser2.Parser = Parser;
  return new Parser();
}();
parser$4.parser = parser$4;
const pieParser = parser$4;
const pieDetector = (txt) => {
  const logOutput = txt.match(/^\s*pie/) !== null || txt.match(/^\s*bar/) !== null;
  return logOutput;
};
let sections$1 = {};
let showData = false;
const parseDirective$4 = function(statement, context, type2) {
  mermaidAPI.parseDirective(this, statement, context, type2);
};
const addSection$1 = function(id2, value) {
  id2 = common$1.sanitizeText(id2, getConfig$1());
  if (sections$1[id2] === void 0) {
    sections$1[id2] = value;
    log$1.debug("Added new section :", id2);
  }
};
const getSections$1 = () => sections$1;
const setShowData = function(toggle) {
  showData = toggle;
};
const getShowData = function() {
  return showData;
};
const cleanupValue = function(value) {
  if (value.substring(0, 1) === ":") {
    value = value.substring(1).trim();
    return Number(value.trim());
  } else {
    return Number(value.trim());
  }
};
const clear$4 = function() {
  sections$1 = {};
  showData = false;
  clear$g();
};
const pieDb = {
  parseDirective: parseDirective$4,
  getConfig: () => getConfig$1().pie,
  addSection: addSection$1,
  getSections: getSections$1,
  cleanupValue,
  clear: clear$4,
  setAccTitle,
  getAccTitle,
  setDiagramTitle,
  getDiagramTitle,
  setShowData,
  getShowData,
  getAccDescription,
  setAccDescription
};
let conf$5 = getConfig$1();
let width;
const height = 450;
const draw$6 = (txt, id2, _version, diagObj) => {
  try {
    conf$5 = getConfig$1();
    log$1.debug("Rendering info diagram\n" + txt);
    const securityLevel = getConfig$1().securityLevel;
    let sandboxElement;
    if (securityLevel === "sandbox") {
      sandboxElement = select("#i" + id2);
    }
    const root = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
    const doc = securityLevel === "sandbox" ? sandboxElement.nodes()[0].contentDocument : document;
    diagObj.db.clear();
    diagObj.parser.parse(txt);
    log$1.debug("Parsed info diagram");
    const elem = doc.getElementById(id2);
    width = elem.parentElement.offsetWidth;
    if (width === void 0) {
      width = 1200;
    }
    if (conf$5.useWidth !== void 0) {
      width = conf$5.useWidth;
    }
    if (conf$5.pie.useWidth !== void 0) {
      width = conf$5.pie.useWidth;
    }
    const diagram = root.select("#" + id2);
    configureSvgSize(diagram, height, width, conf$5.pie.useMaxWidth);
    elem.setAttribute("viewBox", "0 0 " + width + " " + height);
    var margin = 40;
    var legendRectSize = 18;
    var legendSpacing = 4;
    var radius = Math.min(width, height) / 2 - margin;
    var svg = diagram.append("g").attr("transform", "translate(" + width / 2 + "," + height / 2 + ")");
    var data = diagObj.db.getSections();
    var sum = 0;
    Object.keys(data).forEach(function(key) {
      sum += data[key];
    });
    const themeVariables = conf$5.themeVariables;
    var myGeneratedColors = [
      themeVariables.pie1,
      themeVariables.pie2,
      themeVariables.pie3,
      themeVariables.pie4,
      themeVariables.pie5,
      themeVariables.pie6,
      themeVariables.pie7,
      themeVariables.pie8,
      themeVariables.pie9,
      themeVariables.pie10,
      themeVariables.pie11,
      themeVariables.pie12
    ];
    var color = scaleOrdinal().range(myGeneratedColors);
    var pieData = Object.entries(data).map(function(el, idx) {
      return {
        order: idx,
        name: el[0],
        value: el[1]
      };
    });
    var pie$1 = pie().value(function(d) {
      return d.value;
    }).sort(function(a, b) {
      return a.order - b.order;
    });
    var dataReady = pie$1(pieData);
    var arcGenerator = arc().innerRadius(0).outerRadius(radius);
    svg.selectAll("mySlices").data(dataReady).enter().append("path").attr("d", arcGenerator).attr("fill", function(d) {
      return color(d.data.name);
    }).attr("class", "pieCircle");
    svg.selectAll("mySlices").data(dataReady).enter().append("text").text(function(d) {
      return (d.data.value / sum * 100).toFixed(0) + "%";
    }).attr("transform", function(d) {
      return "translate(" + arcGenerator.centroid(d) + ")";
    }).style("text-anchor", "middle").attr("class", "slice");
    svg.append("text").text(diagObj.db.getDiagramTitle()).attr("x", 0).attr("y", -(height - 50) / 2).attr("class", "pieTitleText");
    var legend = svg.selectAll(".legend").data(color.domain()).enter().append("g").attr("class", "legend").attr("transform", function(d, i) {
      const height2 = legendRectSize + legendSpacing;
      const offset = height2 * color.domain().length / 2;
      const horizontal = 12 * legendRectSize;
      const vertical = i * height2 - offset;
      return "translate(" + horizontal + "," + vertical + ")";
    });
    legend.append("rect").attr("width", legendRectSize).attr("height", legendRectSize).style("fill", color).style("stroke", color);
    legend.data(dataReady).append("text").attr("x", legendRectSize + legendSpacing).attr("y", legendRectSize - legendSpacing).text(function(d) {
      if (diagObj.db.getShowData() || conf$5.showData || conf$5.pie.showData) {
        return d.data.name + " [" + d.data.value + "]";
      } else {
        return d.data.name;
      }
    });
  } catch (e) {
    log$1.error("Error while rendering info diagram");
    log$1.error(e);
  }
};
const pieRenderer = {
  draw: draw$6
};
var parser$3 = function() {
  var o = function(k, v, o2, l) {
    for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
      ;
    return o2;
  }, $V0 = [1, 3], $V1 = [1, 5], $V2 = [1, 6], $V3 = [1, 7], $V4 = [1, 8], $V5 = [5, 6, 8, 14, 16, 18, 19, 40, 41, 42, 43, 44, 45, 53, 71, 72], $V6 = [1, 22], $V7 = [2, 13], $V8 = [1, 26], $V9 = [1, 27], $Va = [1, 28], $Vb = [1, 29], $Vc = [1, 30], $Vd = [1, 31], $Ve = [1, 24], $Vf = [1, 32], $Vg = [1, 33], $Vh = [1, 36], $Vi = [71, 72], $Vj = [5, 8, 14, 16, 18, 19, 40, 41, 42, 43, 44, 45, 53, 60, 62, 71, 72], $Vk = [1, 56], $Vl = [1, 57], $Vm = [1, 58], $Vn = [1, 59], $Vo = [1, 60], $Vp = [1, 61], $Vq = [1, 62], $Vr = [62, 63], $Vs = [1, 74], $Vt = [1, 70], $Vu = [1, 71], $Vv = [1, 72], $Vw = [1, 73], $Vx = [1, 75], $Vy = [1, 79], $Vz = [1, 80], $VA = [1, 77], $VB = [1, 78], $VC = [5, 8, 14, 16, 18, 19, 40, 41, 42, 43, 44, 45, 53, 71, 72];
  var parser2 = {
    trace: function trace() {
    },
    yy: {},
    symbols_: { "error": 2, "start": 3, "directive": 4, "NEWLINE": 5, "RD": 6, "diagram": 7, "EOF": 8, "openDirective": 9, "typeDirective": 10, "closeDirective": 11, ":": 12, "argDirective": 13, "acc_title": 14, "acc_title_value": 15, "acc_descr": 16, "acc_descr_value": 17, "acc_descr_multiline_value": 18, "open_directive": 19, "type_directive": 20, "arg_directive": 21, "close_directive": 22, "requirementDef": 23, "elementDef": 24, "relationshipDef": 25, "requirementType": 26, "requirementName": 27, "STRUCT_START": 28, "requirementBody": 29, "ID": 30, "COLONSEP": 31, "id": 32, "TEXT": 33, "text": 34, "RISK": 35, "riskLevel": 36, "VERIFYMTHD": 37, "verifyType": 38, "STRUCT_STOP": 39, "REQUIREMENT": 40, "FUNCTIONAL_REQUIREMENT": 41, "INTERFACE_REQUIREMENT": 42, "PERFORMANCE_REQUIREMENT": 43, "PHYSICAL_REQUIREMENT": 44, "DESIGN_CONSTRAINT": 45, "LOW_RISK": 46, "MED_RISK": 47, "HIGH_RISK": 48, "VERIFY_ANALYSIS": 49, "VERIFY_DEMONSTRATION": 50, "VERIFY_INSPECTION": 51, "VERIFY_TEST": 52, "ELEMENT": 53, "elementName": 54, "elementBody": 55, "TYPE": 56, "type": 57, "DOCREF": 58, "ref": 59, "END_ARROW_L": 60, "relationship": 61, "LINE": 62, "END_ARROW_R": 63, "CONTAINS": 64, "COPIES": 65, "DERIVES": 66, "SATISFIES": 67, "VERIFIES": 68, "REFINES": 69, "TRACES": 70, "unqString": 71, "qString": 72, "$accept": 0, "$end": 1 },
    terminals_: { 2: "error", 5: "NEWLINE", 6: "RD", 8: "EOF", 12: ":", 14: "acc_title", 15: "acc_title_value", 16: "acc_descr", 17: "acc_descr_value", 18: "acc_descr_multiline_value", 19: "open_directive", 20: "type_directive", 21: "arg_directive", 22: "close_directive", 28: "STRUCT_START", 30: "ID", 31: "COLONSEP", 33: "TEXT", 35: "RISK", 37: "VERIFYMTHD", 39: "STRUCT_STOP", 40: "REQUIREMENT", 41: "FUNCTIONAL_REQUIREMENT", 42: "INTERFACE_REQUIREMENT", 43: "PERFORMANCE_REQUIREMENT", 44: "PHYSICAL_REQUIREMENT", 45: "DESIGN_CONSTRAINT", 46: "LOW_RISK", 47: "MED_RISK", 48: "HIGH_RISK", 49: "VERIFY_ANALYSIS", 50: "VERIFY_DEMONSTRATION", 51: "VERIFY_INSPECTION", 52: "VERIFY_TEST", 53: "ELEMENT", 56: "TYPE", 58: "DOCREF", 60: "END_ARROW_L", 62: "LINE", 63: "END_ARROW_R", 64: "CONTAINS", 65: "COPIES", 66: "DERIVES", 67: "SATISFIES", 68: "VERIFIES", 69: "REFINES", 70: "TRACES", 71: "unqString", 72: "qString" },
    productions_: [0, [3, 3], [3, 2], [3, 4], [4, 3], [4, 5], [4, 2], [4, 2], [4, 1], [9, 1], [10, 1], [13, 1], [11, 1], [7, 0], [7, 2], [7, 2], [7, 2], [7, 2], [7, 2], [23, 5], [29, 5], [29, 5], [29, 5], [29, 5], [29, 2], [29, 1], [26, 1], [26, 1], [26, 1], [26, 1], [26, 1], [26, 1], [36, 1], [36, 1], [36, 1], [38, 1], [38, 1], [38, 1], [38, 1], [24, 5], [55, 5], [55, 5], [55, 2], [55, 1], [25, 5], [25, 5], [61, 1], [61, 1], [61, 1], [61, 1], [61, 1], [61, 1], [61, 1], [27, 1], [27, 1], [32, 1], [32, 1], [34, 1], [34, 1], [54, 1], [54, 1], [57, 1], [57, 1], [59, 1], [59, 1]],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
      var $0 = $$.length - 1;
      switch (yystate) {
        case 6:
          this.$ = $$[$0].trim();
          yy.setAccTitle(this.$);
          break;
        case 7:
        case 8:
          this.$ = $$[$0].trim();
          yy.setAccDescription(this.$);
          break;
        case 9:
          yy.parseDirective("%%{", "open_directive");
          break;
        case 10:
          yy.parseDirective($$[$0], "type_directive");
          break;
        case 11:
          $$[$0] = $$[$0].trim().replace(/'/g, '"');
          yy.parseDirective($$[$0], "arg_directive");
          break;
        case 12:
          yy.parseDirective("}%%", "close_directive", "pie");
          break;
        case 13:
          this.$ = [];
          break;
        case 19:
          yy.addRequirement($$[$0 - 3], $$[$0 - 4]);
          break;
        case 20:
          yy.setNewReqId($$[$0 - 2]);
          break;
        case 21:
          yy.setNewReqText($$[$0 - 2]);
          break;
        case 22:
          yy.setNewReqRisk($$[$0 - 2]);
          break;
        case 23:
          yy.setNewReqVerifyMethod($$[$0 - 2]);
          break;
        case 26:
          this.$ = yy.RequirementType.REQUIREMENT;
          break;
        case 27:
          this.$ = yy.RequirementType.FUNCTIONAL_REQUIREMENT;
          break;
        case 28:
          this.$ = yy.RequirementType.INTERFACE_REQUIREMENT;
          break;
        case 29:
          this.$ = yy.RequirementType.PERFORMANCE_REQUIREMENT;
          break;
        case 30:
          this.$ = yy.RequirementType.PHYSICAL_REQUIREMENT;
          break;
        case 31:
          this.$ = yy.RequirementType.DESIGN_CONSTRAINT;
          break;
        case 32:
          this.$ = yy.RiskLevel.LOW_RISK;
          break;
        case 33:
          this.$ = yy.RiskLevel.MED_RISK;
          break;
        case 34:
          this.$ = yy.RiskLevel.HIGH_RISK;
          break;
        case 35:
          this.$ = yy.VerifyType.VERIFY_ANALYSIS;
          break;
        case 36:
          this.$ = yy.VerifyType.VERIFY_DEMONSTRATION;
          break;
        case 37:
          this.$ = yy.VerifyType.VERIFY_INSPECTION;
          break;
        case 38:
          this.$ = yy.VerifyType.VERIFY_TEST;
          break;
        case 39:
          yy.addElement($$[$0 - 3]);
          break;
        case 40:
          yy.setNewElementType($$[$0 - 2]);
          break;
        case 41:
          yy.setNewElementDocRef($$[$0 - 2]);
          break;
        case 44:
          yy.addRelationship($$[$0 - 2], $$[$0], $$[$0 - 4]);
          break;
        case 45:
          yy.addRelationship($$[$0 - 2], $$[$0 - 4], $$[$0]);
          break;
        case 46:
          this.$ = yy.Relationships.CONTAINS;
          break;
        case 47:
          this.$ = yy.Relationships.COPIES;
          break;
        case 48:
          this.$ = yy.Relationships.DERIVES;
          break;
        case 49:
          this.$ = yy.Relationships.SATISFIES;
          break;
        case 50:
          this.$ = yy.Relationships.VERIFIES;
          break;
        case 51:
          this.$ = yy.Relationships.REFINES;
          break;
        case 52:
          this.$ = yy.Relationships.TRACES;
          break;
      }
    },
    table: [{ 3: 1, 4: 2, 6: $V0, 9: 4, 14: $V1, 16: $V2, 18: $V3, 19: $V4 }, { 1: [3] }, { 3: 10, 4: 2, 5: [1, 9], 6: $V0, 9: 4, 14: $V1, 16: $V2, 18: $V3, 19: $V4 }, { 5: [1, 11] }, { 10: 12, 20: [1, 13] }, { 15: [1, 14] }, { 17: [1, 15] }, o($V5, [2, 8]), { 20: [2, 9] }, { 3: 16, 4: 2, 6: $V0, 9: 4, 14: $V1, 16: $V2, 18: $V3, 19: $V4 }, { 1: [2, 2] }, { 4: 21, 5: $V6, 7: 17, 8: $V7, 9: 4, 14: $V1, 16: $V2, 18: $V3, 19: $V4, 23: 18, 24: 19, 25: 20, 26: 23, 32: 25, 40: $V8, 41: $V9, 42: $Va, 43: $Vb, 44: $Vc, 45: $Vd, 53: $Ve, 71: $Vf, 72: $Vg }, { 11: 34, 12: [1, 35], 22: $Vh }, o([12, 22], [2, 10]), o($V5, [2, 6]), o($V5, [2, 7]), { 1: [2, 1] }, { 8: [1, 37] }, { 4: 21, 5: $V6, 7: 38, 8: $V7, 9: 4, 14: $V1, 16: $V2, 18: $V3, 19: $V4, 23: 18, 24: 19, 25: 20, 26: 23, 32: 25, 40: $V8, 41: $V9, 42: $Va, 43: $Vb, 44: $Vc, 45: $Vd, 53: $Ve, 71: $Vf, 72: $Vg }, { 4: 21, 5: $V6, 7: 39, 8: $V7, 9: 4, 14: $V1, 16: $V2, 18: $V3, 19: $V4, 23: 18, 24: 19, 25: 20, 26: 23, 32: 25, 40: $V8, 41: $V9, 42: $Va, 43: $Vb, 44: $Vc, 45: $Vd, 53: $Ve, 71: $Vf, 72: $Vg }, { 4: 21, 5: $V6, 7: 40, 8: $V7, 9: 4, 14: $V1, 16: $V2, 18: $V3, 19: $V4, 23: 18, 24: 19, 25: 20, 26: 23, 32: 25, 40: $V8, 41: $V9, 42: $Va, 43: $Vb, 44: $Vc, 45: $Vd, 53: $Ve, 71: $Vf, 72: $Vg }, { 4: 21, 5: $V6, 7: 41, 8: $V7, 9: 4, 14: $V1, 16: $V2, 18: $V3, 19: $V4, 23: 18, 24: 19, 25: 20, 26: 23, 32: 25, 40: $V8, 41: $V9, 42: $Va, 43: $Vb, 44: $Vc, 45: $Vd, 53: $Ve, 71: $Vf, 72: $Vg }, { 4: 21, 5: $V6, 7: 42, 8: $V7, 9: 4, 14: $V1, 16: $V2, 18: $V3, 19: $V4, 23: 18, 24: 19, 25: 20, 26: 23, 32: 25, 40: $V8, 41: $V9, 42: $Va, 43: $Vb, 44: $Vc, 45: $Vd, 53: $Ve, 71: $Vf, 72: $Vg }, { 27: 43, 71: [1, 44], 72: [1, 45] }, { 54: 46, 71: [1, 47], 72: [1, 48] }, { 60: [1, 49], 62: [1, 50] }, o($Vi, [2, 26]), o($Vi, [2, 27]), o($Vi, [2, 28]), o($Vi, [2, 29]), o($Vi, [2, 30]), o($Vi, [2, 31]), o($Vj, [2, 55]), o($Vj, [2, 56]), o($V5, [2, 4]), { 13: 51, 21: [1, 52] }, o($V5, [2, 12]), { 1: [2, 3] }, { 8: [2, 14] }, { 8: [2, 15] }, { 8: [2, 16] }, { 8: [2, 17] }, { 8: [2, 18] }, { 28: [1, 53] }, { 28: [2, 53] }, { 28: [2, 54] }, { 28: [1, 54] }, { 28: [2, 59] }, { 28: [2, 60] }, { 61: 55, 64: $Vk, 65: $Vl, 66: $Vm, 67: $Vn, 68: $Vo, 69: $Vp, 70: $Vq }, { 61: 63, 64: $Vk, 65: $Vl, 66: $Vm, 67: $Vn, 68: $Vo, 69: $Vp, 70: $Vq }, { 11: 64, 22: $Vh }, { 22: [2, 11] }, { 5: [1, 65] }, { 5: [1, 66] }, { 62: [1, 67] }, o($Vr, [2, 46]), o($Vr, [2, 47]), o($Vr, [2, 48]), o($Vr, [2, 49]), o($Vr, [2, 50]), o($Vr, [2, 51]), o($Vr, [2, 52]), { 63: [1, 68] }, o($V5, [2, 5]), { 5: $Vs, 29: 69, 30: $Vt, 33: $Vu, 35: $Vv, 37: $Vw, 39: $Vx }, { 5: $Vy, 39: $Vz, 55: 76, 56: $VA, 58: $VB }, { 32: 81, 71: $Vf, 72: $Vg }, { 32: 82, 71: $Vf, 72: $Vg }, o($VC, [2, 19]), { 31: [1, 83] }, { 31: [1, 84] }, { 31: [1, 85] }, { 31: [1, 86] }, { 5: $Vs, 29: 87, 30: $Vt, 33: $Vu, 35: $Vv, 37: $Vw, 39: $Vx }, o($VC, [2, 25]), o($VC, [2, 39]), { 31: [1, 88] }, { 31: [1, 89] }, { 5: $Vy, 39: $Vz, 55: 90, 56: $VA, 58: $VB }, o($VC, [2, 43]), o($VC, [2, 44]), o($VC, [2, 45]), { 32: 91, 71: $Vf, 72: $Vg }, { 34: 92, 71: [1, 93], 72: [1, 94] }, { 36: 95, 46: [1, 96], 47: [1, 97], 48: [1, 98] }, { 38: 99, 49: [1, 100], 50: [1, 101], 51: [1, 102], 52: [1, 103] }, o($VC, [2, 24]), { 57: 104, 71: [1, 105], 72: [1, 106] }, { 59: 107, 71: [1, 108], 72: [1, 109] }, o($VC, [2, 42]), { 5: [1, 110] }, { 5: [1, 111] }, { 5: [2, 57] }, { 5: [2, 58] }, { 5: [1, 112] }, { 5: [2, 32] }, { 5: [2, 33] }, { 5: [2, 34] }, { 5: [1, 113] }, { 5: [2, 35] }, { 5: [2, 36] }, { 5: [2, 37] }, { 5: [2, 38] }, { 5: [1, 114] }, { 5: [2, 61] }, { 5: [2, 62] }, { 5: [1, 115] }, { 5: [2, 63] }, { 5: [2, 64] }, { 5: $Vs, 29: 116, 30: $Vt, 33: $Vu, 35: $Vv, 37: $Vw, 39: $Vx }, { 5: $Vs, 29: 117, 30: $Vt, 33: $Vu, 35: $Vv, 37: $Vw, 39: $Vx }, { 5: $Vs, 29: 118, 30: $Vt, 33: $Vu, 35: $Vv, 37: $Vw, 39: $Vx }, { 5: $Vs, 29: 119, 30: $Vt, 33: $Vu, 35: $Vv, 37: $Vw, 39: $Vx }, { 5: $Vy, 39: $Vz, 55: 120, 56: $VA, 58: $VB }, { 5: $Vy, 39: $Vz, 55: 121, 56: $VA, 58: $VB }, o($VC, [2, 20]), o($VC, [2, 21]), o($VC, [2, 22]), o($VC, [2, 23]), o($VC, [2, 40]), o($VC, [2, 41])],
    defaultActions: { 8: [2, 9], 10: [2, 2], 16: [2, 1], 37: [2, 3], 38: [2, 14], 39: [2, 15], 40: [2, 16], 41: [2, 17], 42: [2, 18], 44: [2, 53], 45: [2, 54], 47: [2, 59], 48: [2, 60], 52: [2, 11], 93: [2, 57], 94: [2, 58], 96: [2, 32], 97: [2, 33], 98: [2, 34], 100: [2, 35], 101: [2, 36], 102: [2, 37], 103: [2, 38], 105: [2, 61], 106: [2, 62], 108: [2, 63], 109: [2, 64] },
    parseError: function parseError(str2, hash) {
      if (hash.recoverable) {
        this.trace(str2);
      } else {
        var error = new Error(str2);
        error.hash = hash;
        throw error;
      }
    },
    parse: function parse2(input) {
      var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
      var args = lstack.slice.call(arguments, 1);
      var lexer2 = Object.create(this.lexer);
      var sharedState = { yy: {} };
      for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
          sharedState.yy[k] = this.yy[k];
        }
      }
      lexer2.setInput(input, sharedState.yy);
      sharedState.yy.lexer = lexer2;
      sharedState.yy.parser = this;
      if (typeof lexer2.yylloc == "undefined") {
        lexer2.yylloc = {};
      }
      var yyloc = lexer2.yylloc;
      lstack.push(yyloc);
      var ranges = lexer2.options && lexer2.options.ranges;
      if (typeof sharedState.yy.parseError === "function") {
        this.parseError = sharedState.yy.parseError;
      } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
      }
      function lex2() {
        var token;
        token = tstack.pop() || lexer2.lex() || EOF;
        if (typeof token !== "number") {
          if (token instanceof Array) {
            tstack = token;
            token = tstack.pop();
          }
          token = self.symbols_[token] || token;
        }
        return token;
      }
      var symbol, state, action, r, yyval = {}, p, len, newState, expected;
      while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
          action = this.defaultActions[state];
        } else {
          if (symbol === null || typeof symbol == "undefined") {
            symbol = lex2();
          }
          action = table[state] && table[state][symbol];
        }
        if (typeof action === "undefined" || !action.length || !action[0]) {
          var errStr = "";
          expected = [];
          for (p in table[state]) {
            if (this.terminals_[p] && p > TERROR) {
              expected.push("'" + this.terminals_[p] + "'");
            }
          }
          if (lexer2.showPosition) {
            errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
          } else {
            errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
          }
          this.parseError(errStr, {
            text: lexer2.match,
            token: this.terminals_[symbol] || symbol,
            line: lexer2.yylineno,
            loc: yyloc,
            expected
          });
        }
        if (action[0] instanceof Array && action.length > 1) {
          throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
        }
        switch (action[0]) {
          case 1:
            stack.push(symbol);
            vstack.push(lexer2.yytext);
            lstack.push(lexer2.yylloc);
            stack.push(action[1]);
            symbol = null;
            {
              yyleng = lexer2.yyleng;
              yytext = lexer2.yytext;
              yylineno = lexer2.yylineno;
              yyloc = lexer2.yylloc;
            }
            break;
          case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
              first_line: lstack[lstack.length - (len || 1)].first_line,
              last_line: lstack[lstack.length - 1].last_line,
              first_column: lstack[lstack.length - (len || 1)].first_column,
              last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
              yyval._$.range = [
                lstack[lstack.length - (len || 1)].range[0],
                lstack[lstack.length - 1].range[1]
              ];
            }
            r = this.performAction.apply(yyval, [
              yytext,
              yyleng,
              yylineno,
              sharedState.yy,
              action[1],
              vstack,
              lstack
            ].concat(args));
            if (typeof r !== "undefined") {
              return r;
            }
            if (len) {
              stack = stack.slice(0, -1 * len * 2);
              vstack = vstack.slice(0, -1 * len);
              lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
          case 3:
            return true;
        }
      }
      return true;
    }
  };
  var lexer = function() {
    var lexer2 = {
      EOF: 1,
      parseError: function parseError(str2, hash) {
        if (this.yy.parser) {
          this.yy.parser.parseError(str2, hash);
        } else {
          throw new Error(str2);
        }
      },
      // resets the lexer, sets new input
      setInput: function(input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = "";
        this.conditionStack = ["INITIAL"];
        this.yylloc = {
          first_line: 1,
          first_column: 0,
          last_line: 1,
          last_column: 0
        };
        if (this.options.ranges) {
          this.yylloc.range = [0, 0];
        }
        this.offset = 0;
        return this;
      },
      // consumes and returns one char from the input
      input: function() {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno++;
          this.yylloc.last_line++;
        } else {
          this.yylloc.last_column++;
        }
        if (this.options.ranges) {
          this.yylloc.range[1]++;
        }
        this._input = this._input.slice(1);
        return ch;
      },
      // unshifts one char (or a string) into the input
      unput: function(ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);
        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);
        if (lines.length - 1) {
          this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;
        this.yylloc = {
          first_line: this.yylloc.first_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.first_column,
          last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
        };
        if (this.options.ranges) {
          this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
      },
      // When called from action, caches matched text and appends it on next action
      more: function() {
        this._more = true;
        return this;
      },
      // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
      reject: function() {
        if (this.options.backtrack_lexer) {
          this._backtrack = true;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
        return this;
      },
      // retain first n characters of the match
      less: function(n) {
        this.unput(this.match.slice(n));
      },
      // displays already matched input, i.e. for error messages
      pastInput: function() {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
      },
      // displays upcoming input, i.e. for error messages
      upcomingInput: function() {
        var next = this.match;
        if (next.length < 20) {
          next += this._input.substr(0, 20 - next.length);
        }
        return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
      },
      // displays the character position where the lexing error occurred, i.e. for error messages
      showPosition: function() {
        var pre = this.pastInput();
        var c2 = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c2 + "^";
      },
      // test the lexed token: return FALSE when not a match, otherwise return token
      test_match: function(match, indexed_rule) {
        var token, lines, backup;
        if (this.options.backtrack_lexer) {
          backup = {
            yylineno: this.yylineno,
            yylloc: {
              first_line: this.yylloc.first_line,
              last_line: this.last_line,
              first_column: this.yylloc.first_column,
              last_column: this.yylloc.last_column
            },
            yytext: this.yytext,
            match: this.match,
            matches: this.matches,
            matched: this.matched,
            yyleng: this.yyleng,
            offset: this.offset,
            _more: this._more,
            _input: this._input,
            yy: this.yy,
            conditionStack: this.conditionStack.slice(0),
            done: this.done
          };
          if (this.options.ranges) {
            backup.yylloc.range = this.yylloc.range.slice(0);
          }
        }
        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno += lines.length;
        }
        this.yylloc = {
          first_line: this.yylloc.last_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.last_column,
          last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
          this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
          this.done = false;
        }
        if (token) {
          return token;
        } else if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
        return false;
      },
      // return next match in input
      next: function() {
        if (this.done) {
          return this.EOF;
        }
        if (!this._input) {
          this.done = true;
        }
        var token, match, tempMatch, index;
        if (!this._more) {
          this.yytext = "";
          this.match = "";
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
          tempMatch = this._input.match(this.rules[rules[i]]);
          if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
            match = tempMatch;
            index = i;
            if (this.options.backtrack_lexer) {
              token = this.test_match(tempMatch, rules[i]);
              if (token !== false) {
                return token;
              } else if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            } else if (!this.options.flex) {
              break;
            }
          }
        }
        if (match) {
          token = this.test_match(match, rules[index]);
          if (token !== false) {
            return token;
          }
          return false;
        }
        if (this._input === "") {
          return this.EOF;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
      },
      // return next match that has a token
      lex: function lex2() {
        var r = this.next();
        if (r) {
          return r;
        } else {
          return this.lex();
        }
      },
      // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
      begin: function begin(condition) {
        this.conditionStack.push(condition);
      },
      // pop the previously active lexer condition state off the condition stack
      popState: function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
          return this.conditionStack.pop();
        } else {
          return this.conditionStack[0];
        }
      },
      // produce the lexer rule set which is active for the currently active lexer condition state
      _currentRules: function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
          return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
          return this.conditions["INITIAL"].rules;
        }
      },
      // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
      topState: function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
          return this.conditionStack[n];
        } else {
          return "INITIAL";
        }
      },
      // alias for begin(condition)
      pushState: function pushState(condition) {
        this.begin(condition);
      },
      // return the number of states currently on the stack
      stateStackSize: function stateStackSize() {
        return this.conditionStack.length;
      },
      options: { "case-insensitive": true },
      performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
        switch ($avoiding_name_collisions) {
          case 0:
            this.begin("open_directive");
            return 19;
          case 1:
            this.begin("type_directive");
            return 20;
          case 2:
            this.popState();
            this.begin("arg_directive");
            return 12;
          case 3:
            this.popState();
            this.popState();
            return 22;
          case 4:
            return 21;
          case 5:
            return "title";
          case 6:
            this.begin("acc_title");
            return 14;
          case 7:
            this.popState();
            return "acc_title_value";
          case 8:
            this.begin("acc_descr");
            return 16;
          case 9:
            this.popState();
            return "acc_descr_value";
          case 10:
            this.begin("acc_descr_multiline");
            break;
          case 11:
            this.popState();
            break;
          case 12:
            return "acc_descr_multiline_value";
          case 13:
            return 5;
          case 14:
            break;
          case 15:
            break;
          case 16:
            break;
          case 17:
            return 8;
          case 18:
            return 6;
          case 19:
            return 28;
          case 20:
            return 39;
          case 21:
            return 31;
          case 22:
            return 30;
          case 23:
            return 33;
          case 24:
            return 35;
          case 25:
            return 37;
          case 26:
            return 40;
          case 27:
            return 41;
          case 28:
            return 42;
          case 29:
            return 43;
          case 30:
            return 44;
          case 31:
            return 45;
          case 32:
            return 46;
          case 33:
            return 47;
          case 34:
            return 48;
          case 35:
            return 49;
          case 36:
            return 50;
          case 37:
            return 51;
          case 38:
            return 52;
          case 39:
            return 53;
          case 40:
            return 64;
          case 41:
            return 65;
          case 42:
            return 66;
          case 43:
            return 67;
          case 44:
            return 68;
          case 45:
            return 69;
          case 46:
            return 70;
          case 47:
            return 56;
          case 48:
            return 58;
          case 49:
            return 60;
          case 50:
            return 63;
          case 51:
            return 62;
          case 52:
            this.begin("string");
            break;
          case 53:
            this.popState();
            break;
          case 54:
            return "qString";
          case 55:
            yy_.yytext = yy_.yytext.trim();
            return 71;
        }
      },
      rules: [/^(?:%%\{)/i, /^(?:((?:(?!\}%%)[^:.])*))/i, /^(?::)/i, /^(?:\}%%)/i, /^(?:((?:(?!\}%%).|\n)*))/i, /^(?:title\s[^#\n;]+)/i, /^(?:accTitle\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*\{\s*)/i, /^(?:[\}])/i, /^(?:[^\}]*)/i, /^(?:(\r?\n)+)/i, /^(?:\s+)/i, /^(?:#[^\n]*)/i, /^(?:%[^\n]*)/i, /^(?:$)/i, /^(?:requirementDiagram\b)/i, /^(?:\{)/i, /^(?:\})/i, /^(?::)/i, /^(?:id\b)/i, /^(?:text\b)/i, /^(?:risk\b)/i, /^(?:verifyMethod\b)/i, /^(?:requirement\b)/i, /^(?:functionalRequirement\b)/i, /^(?:interfaceRequirement\b)/i, /^(?:performanceRequirement\b)/i, /^(?:physicalRequirement\b)/i, /^(?:designConstraint\b)/i, /^(?:low\b)/i, /^(?:medium\b)/i, /^(?:high\b)/i, /^(?:analysis\b)/i, /^(?:demonstration\b)/i, /^(?:inspection\b)/i, /^(?:test\b)/i, /^(?:element\b)/i, /^(?:contains\b)/i, /^(?:copies\b)/i, /^(?:derives\b)/i, /^(?:satisfies\b)/i, /^(?:verifies\b)/i, /^(?:refines\b)/i, /^(?:traces\b)/i, /^(?:type\b)/i, /^(?:docref\b)/i, /^(?:<-)/i, /^(?:->)/i, /^(?:-)/i, /^(?:["])/i, /^(?:["])/i, /^(?:[^"]*)/i, /^(?:[\w][^\r\n\{\<\>\-\=]*)/i],
      conditions: { "acc_descr_multiline": { "rules": [11, 12], "inclusive": false }, "acc_descr": { "rules": [9], "inclusive": false }, "acc_title": { "rules": [7], "inclusive": false }, "close_directive": { "rules": [], "inclusive": false }, "arg_directive": { "rules": [3, 4], "inclusive": false }, "type_directive": { "rules": [2, 3], "inclusive": false }, "open_directive": { "rules": [1], "inclusive": false }, "unqString": { "rules": [], "inclusive": false }, "token": { "rules": [], "inclusive": false }, "string": { "rules": [53, 54], "inclusive": false }, "INITIAL": { "rules": [0, 5, 6, 8, 10, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 55], "inclusive": true } }
    };
    return lexer2;
  }();
  parser2.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  Parser.prototype = parser2;
  parser2.Parser = Parser;
  return new Parser();
}();
parser$3.parser = parser$3;
const requirementParser = parser$3;
const requirementDetector = (txt) => {
  return txt.match(/^\s*requirement(Diagram)?/) !== null;
};
let relations = [];
let latestRequirement = {};
let requirements = {};
let latestElement = {};
let elements = {};
const RequirementType = {
  REQUIREMENT: "Requirement",
  FUNCTIONAL_REQUIREMENT: "Functional Requirement",
  INTERFACE_REQUIREMENT: "Interface Requirement",
  PERFORMANCE_REQUIREMENT: "Performance Requirement",
  PHYSICAL_REQUIREMENT: "Physical Requirement",
  DESIGN_CONSTRAINT: "Design Constraint"
};
const RiskLevel = {
  LOW_RISK: "Low",
  MED_RISK: "Medium",
  HIGH_RISK: "High"
};
const VerifyType = {
  VERIFY_ANALYSIS: "Analysis",
  VERIFY_DEMONSTRATION: "Demonstration",
  VERIFY_INSPECTION: "Inspection",
  VERIFY_TEST: "Test"
};
const Relationships = {
  CONTAINS: "contains",
  COPIES: "copies",
  DERIVES: "derives",
  SATISFIES: "satisfies",
  VERIFIES: "verifies",
  REFINES: "refines",
  TRACES: "traces"
};
const parseDirective$3 = function(statement, context, type2) {
  mermaidAPI.parseDirective(this, statement, context, type2);
};
const addRequirement = (name, type2) => {
  if (requirements[name] === void 0) {
    requirements[name] = {
      name,
      type: type2,
      id: latestRequirement.id,
      text: latestRequirement.text,
      risk: latestRequirement.risk,
      verifyMethod: latestRequirement.verifyMethod
    };
  }
  latestRequirement = {};
  return requirements[name];
};
const getRequirements = () => requirements;
const setNewReqId = (id2) => {
  if (latestRequirement !== void 0) {
    latestRequirement.id = id2;
  }
};
const setNewReqText = (text) => {
  if (latestRequirement !== void 0) {
    latestRequirement.text = text;
  }
};
const setNewReqRisk = (risk) => {
  if (latestRequirement !== void 0) {
    latestRequirement.risk = risk;
  }
};
const setNewReqVerifyMethod = (verifyMethod) => {
  if (latestRequirement !== void 0) {
    latestRequirement.verifyMethod = verifyMethod;
  }
};
const addElement = (name) => {
  if (elements[name] === void 0) {
    elements[name] = {
      name,
      type: latestElement.type,
      docRef: latestElement.docRef
    };
    log$1.info("Added new requirement: ", name);
  }
  latestElement = {};
  return elements[name];
};
const getElements = () => elements;
const setNewElementType = (type2) => {
  if (latestElement !== void 0) {
    latestElement.type = type2;
  }
};
const setNewElementDocRef = (docRef) => {
  if (latestElement !== void 0) {
    latestElement.docRef = docRef;
  }
};
const addRelationship = (type2, src, dst) => {
  relations.push({
    type: type2,
    src,
    dst
  });
};
const getRelationships = () => relations;
const clear$3 = () => {
  relations = [];
  latestRequirement = {};
  requirements = {};
  latestElement = {};
  elements = {};
  clear$g();
};
const requirementDb = {
  RequirementType,
  RiskLevel,
  VerifyType,
  Relationships,
  parseDirective: parseDirective$3,
  getConfig: () => getConfig$1().req,
  addRequirement,
  getRequirements,
  setNewReqId,
  setNewReqText,
  setNewReqRisk,
  setNewReqVerifyMethod,
  setAccTitle,
  getAccTitle,
  setAccDescription,
  getAccDescription,
  addElement,
  getElements,
  setNewElementType,
  setNewElementDocRef,
  addRelationship,
  getRelationships,
  clear: clear$3
};
const ReqMarkers = {
  CONTAINS: "contains",
  ARROW: "arrow"
};
const insertLineEndings = (parentNode, conf2) => {
  let containsNode = parentNode.append("defs").append("marker").attr("id", ReqMarkers.CONTAINS + "_line_ending").attr("refX", 0).attr("refY", conf2.line_height / 2).attr("markerWidth", conf2.line_height).attr("markerHeight", conf2.line_height).attr("orient", "auto").append("g");
  containsNode.append("circle").attr("cx", conf2.line_height / 2).attr("cy", conf2.line_height / 2).attr("r", conf2.line_height / 2).attr("fill", "none");
  containsNode.append("line").attr("x1", 0).attr("x2", conf2.line_height).attr("y1", conf2.line_height / 2).attr("y2", conf2.line_height / 2).attr("stroke-width", 1);
  containsNode.append("line").attr("y1", 0).attr("y2", conf2.line_height).attr("x1", conf2.line_height / 2).attr("x2", conf2.line_height / 2).attr("stroke-width", 1);
  parentNode.append("defs").append("marker").attr("id", ReqMarkers.ARROW + "_line_ending").attr("refX", conf2.line_height).attr("refY", 0.5 * conf2.line_height).attr("markerWidth", conf2.line_height).attr("markerHeight", conf2.line_height).attr("orient", "auto").append("path").attr(
    "d",
    `M0,0
      L${conf2.line_height},${conf2.line_height / 2}
      M${conf2.line_height},${conf2.line_height / 2}
      L0,${conf2.line_height}`
  ).attr("stroke-width", 1);
};
const markers = {
  ReqMarkers,
  insertLineEndings
};
let conf$4 = {};
let relCnt = 0;
const newRectNode = (parentNode, id2) => {
  return parentNode.insert("rect", "#" + id2).attr("class", "req reqBox").attr("x", 0).attr("y", 0).attr("width", conf$4.rect_min_width + "px").attr("height", conf$4.rect_min_height + "px");
};
const newTitleNode = (parentNode, id2, txts) => {
  let x = conf$4.rect_min_width / 2;
  let title2 = parentNode.append("text").attr("class", "req reqLabel reqTitle").attr("id", id2).attr("x", x).attr("y", conf$4.rect_padding).attr("dominant-baseline", "hanging");
  let i = 0;
  txts.forEach((textStr) => {
    if (i == 0) {
      title2.append("tspan").attr("text-anchor", "middle").attr("x", conf$4.rect_min_width / 2).attr("dy", 0).text(textStr);
    } else {
      title2.append("tspan").attr("text-anchor", "middle").attr("x", conf$4.rect_min_width / 2).attr("dy", conf$4.line_height * 0.75).text(textStr);
    }
    i++;
  });
  let yPadding = 1.5 * conf$4.rect_padding;
  let linePadding = i * conf$4.line_height * 0.75;
  let totalY = yPadding + linePadding;
  parentNode.append("line").attr("class", "req-title-line").attr("x1", "0").attr("x2", conf$4.rect_min_width).attr("y1", totalY).attr("y2", totalY);
  return {
    titleNode: title2,
    y: totalY
  };
};
const newBodyNode = (parentNode, id2, txts, yStart) => {
  let body = parentNode.append("text").attr("class", "req reqLabel").attr("id", id2).attr("x", conf$4.rect_padding).attr("y", yStart).attr("dominant-baseline", "hanging");
  let currentRow = 0;
  const charLimit = 30;
  let wrappedTxts = [];
  txts.forEach((textStr) => {
    let currentTextLen = textStr.length;
    while (currentTextLen > charLimit && currentRow < 3) {
      let firstPart = textStr.substring(0, charLimit);
      textStr = textStr.substring(charLimit, textStr.length);
      currentTextLen = textStr.length;
      wrappedTxts[wrappedTxts.length] = firstPart;
      currentRow++;
    }
    if (currentRow == 3) {
      let lastStr = wrappedTxts[wrappedTxts.length - 1];
      wrappedTxts[wrappedTxts.length - 1] = lastStr.substring(0, lastStr.length - 4) + "...";
    } else {
      wrappedTxts[wrappedTxts.length] = textStr;
    }
    currentRow = 0;
  });
  wrappedTxts.forEach((textStr) => {
    body.append("tspan").attr("x", conf$4.rect_padding).attr("dy", conf$4.line_height).text(textStr);
  });
  return body;
};
const addEdgeLabel = (parentNode, svgPath, conf2, txt) => {
  const len = svgPath.node().getTotalLength();
  const labelPoint = svgPath.node().getPointAtLength(len * 0.5);
  const labelId = "rel" + relCnt;
  relCnt++;
  const labelNode = parentNode.append("text").attr("class", "req relationshipLabel").attr("id", labelId).attr("x", labelPoint.x).attr("y", labelPoint.y).attr("text-anchor", "middle").attr("dominant-baseline", "middle").text(txt);
  const labelBBox = labelNode.node().getBBox();
  parentNode.insert("rect", "#" + labelId).attr("class", "req reqLabelBox").attr("x", labelPoint.x - labelBBox.width / 2).attr("y", labelPoint.y - labelBBox.height / 2).attr("width", labelBBox.width).attr("height", labelBBox.height).attr("fill", "white").attr("fill-opacity", "85%");
};
const drawRelationshipFromLayout = function(svg, rel, g, insert, diagObj) {
  const edge = g.edge(elementString(rel.src), elementString(rel.dst));
  const lineFunction = line().x(function(d) {
    return d.x;
  }).y(function(d) {
    return d.y;
  });
  const svgPath = svg.insert("path", "#" + insert).attr("class", "er relationshipLine").attr("d", lineFunction(edge.points)).attr("fill", "none");
  if (rel.type == diagObj.db.Relationships.CONTAINS) {
    svgPath.attr(
      "marker-start",
      "url(" + common$1.getUrl(conf$4.arrowMarkerAbsolute) + "#" + rel.type + "_line_ending)"
    );
  } else {
    svgPath.attr("stroke-dasharray", "10,7");
    svgPath.attr(
      "marker-end",
      "url(" + common$1.getUrl(conf$4.arrowMarkerAbsolute) + "#" + markers.ReqMarkers.ARROW + "_line_ending)"
    );
  }
  addEdgeLabel(svg, svgPath, conf$4, `<<${rel.type}>>`);
  return;
};
const drawReqs = (reqs, graph, svgNode) => {
  Object.keys(reqs).forEach((reqName) => {
    let req = reqs[reqName];
    reqName = elementString(reqName);
    log$1.info("Added new requirement: ", reqName);
    const groupNode = svgNode.append("g").attr("id", reqName);
    const textId = "req-" + reqName;
    const rectNode = newRectNode(groupNode, textId);
    let titleNodeInfo = newTitleNode(groupNode, reqName + "_title", [
      `<<${req.type}>>`,
      `${req.name}`
    ]);
    newBodyNode(
      groupNode,
      reqName + "_body",
      [
        `Id: ${req.id}`,
        `Text: ${req.text}`,
        `Risk: ${req.risk}`,
        `Verification: ${req.verifyMethod}`
      ],
      titleNodeInfo.y
    );
    const rectBBox = rectNode.node().getBBox();
    graph.setNode(reqName, {
      width: rectBBox.width,
      height: rectBBox.height,
      shape: "rect",
      id: reqName
    });
  });
};
const drawElements = (els, graph, svgNode) => {
  Object.keys(els).forEach((elName) => {
    let el = els[elName];
    const id2 = elementString(elName);
    const groupNode = svgNode.append("g").attr("id", id2);
    const textId = "element-" + id2;
    const rectNode = newRectNode(groupNode, textId);
    let titleNodeInfo = newTitleNode(groupNode, textId + "_title", [`<<Element>>`, `${elName}`]);
    newBodyNode(
      groupNode,
      textId + "_body",
      [`Type: ${el.type || "Not Specified"}`, `Doc Ref: ${el.docRef || "None"}`],
      titleNodeInfo.y
    );
    const rectBBox = rectNode.node().getBBox();
    graph.setNode(id2, {
      width: rectBBox.width,
      height: rectBBox.height,
      shape: "rect",
      id: id2
    });
  });
};
const addRelationships = (relationships2, g) => {
  relationships2.forEach(function(r) {
    let src = elementString(r.src);
    let dst = elementString(r.dst);
    g.setEdge(src, dst, { relationship: r });
  });
  return relationships2;
};
const adjustEntities = function(svgNode, graph) {
  graph.nodes().forEach(function(v) {
    if (v !== void 0 && graph.node(v) !== void 0) {
      svgNode.select("#" + v);
      svgNode.select("#" + v).attr(
        "transform",
        "translate(" + (graph.node(v).x - graph.node(v).width / 2) + "," + (graph.node(v).y - graph.node(v).height / 2) + " )"
      );
    }
  });
  return;
};
const elementString = (str2) => {
  return str2.replace(/\s/g, "").replace(/\./g, "_");
};
const draw$5 = (text, id2, _version, diagObj) => {
  conf$4 = getConfig$1().requirement;
  diagObj.db.clear();
  diagObj.parser.parse(text);
  const securityLevel = conf$4.securityLevel;
  let sandboxElement;
  if (securityLevel === "sandbox") {
    sandboxElement = select("#i" + id2);
  }
  const root = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
  const svg = root.select(`[id='${id2}']`);
  markers.insertLineEndings(svg, conf$4);
  const g = new graphlib.Graph({
    multigraph: false,
    compound: false,
    directed: true
  }).setGraph({
    rankdir: conf$4.layoutDirection,
    marginx: 20,
    marginy: 20,
    nodesep: 100,
    edgesep: 100,
    ranksep: 100
  }).setDefaultEdgeLabel(function() {
    return {};
  });
  let requirements2 = diagObj.db.getRequirements();
  let elements2 = diagObj.db.getElements();
  let relationships2 = diagObj.db.getRelationships();
  drawReqs(requirements2, g, svg);
  drawElements(elements2, g, svg);
  addRelationships(relationships2, g);
  layout(g);
  adjustEntities(svg, g);
  relationships2.forEach(function(rel) {
    drawRelationshipFromLayout(svg, rel, g, id2, diagObj);
  });
  const padding2 = conf$4.rect_padding;
  const svgBounds = svg.node().getBBox();
  const width2 = svgBounds.width + padding2 * 2;
  const height2 = svgBounds.height + padding2 * 2;
  configureSvgSize(svg, height2, width2, conf$4.useMaxWidth);
  svg.attr("viewBox", `${svgBounds.x - padding2} ${svgBounds.y - padding2} ${width2} ${height2}`);
};
const requirementRenderer = {
  draw: draw$5
};
var parser$2 = function() {
  var o = function(k, v, o2, l) {
    for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
      ;
    return o2;
  }, $V0 = [1, 2], $V1 = [1, 3], $V2 = [1, 5], $V3 = [1, 7], $V4 = [2, 5], $V5 = [1, 15], $V6 = [1, 17], $V7 = [1, 19], $V8 = [1, 21], $V9 = [1, 22], $Va = [1, 23], $Vb = [1, 29], $Vc = [1, 30], $Vd = [1, 31], $Ve = [1, 32], $Vf = [1, 33], $Vg = [1, 34], $Vh = [1, 35], $Vi = [1, 36], $Vj = [1, 37], $Vk = [1, 38], $Vl = [1, 39], $Vm = [1, 40], $Vn = [1, 42], $Vo = [1, 43], $Vp = [1, 45], $Vq = [1, 46], $Vr = [1, 47], $Vs = [1, 48], $Vt = [1, 49], $Vu = [1, 50], $Vv = [1, 53], $Vw = [1, 4, 5, 19, 21, 23, 26, 28, 34, 35, 36, 38, 40, 41, 42, 43, 44, 46, 48, 50, 51, 52, 53, 54, 56, 57, 62, 63, 64, 65, 73, 83], $Vx = [4, 5, 21, 54, 56], $Vy = [4, 5, 19, 21, 23, 26, 28, 34, 35, 36, 38, 40, 41, 42, 43, 44, 46, 48, 50, 54, 56, 57, 62, 63, 64, 65, 73, 83], $Vz = [4, 5, 19, 21, 23, 26, 28, 34, 35, 36, 38, 40, 41, 42, 43, 44, 46, 48, 50, 53, 54, 56, 57, 62, 63, 64, 65, 73, 83], $VA = [4, 5, 19, 21, 23, 26, 28, 34, 35, 36, 38, 40, 41, 42, 43, 44, 46, 48, 50, 52, 54, 56, 57, 62, 63, 64, 65, 73, 83], $VB = [4, 5, 19, 21, 23, 26, 28, 34, 35, 36, 38, 40, 41, 42, 43, 44, 46, 48, 50, 51, 54, 56, 57, 62, 63, 64, 65, 73, 83], $VC = [71, 72, 73], $VD = [1, 125], $VE = [1, 4, 5, 7, 19, 21, 23, 26, 28, 34, 35, 36, 38, 40, 41, 42, 43, 44, 46, 48, 50, 51, 52, 53, 54, 56, 57, 62, 63, 64, 65, 73, 83];
  var parser2 = {
    trace: function trace() {
    },
    yy: {},
    symbols_: { "error": 2, "start": 3, "SPACE": 4, "NEWLINE": 5, "directive": 6, "SD": 7, "document": 8, "line": 9, "statement": 10, "box_section": 11, "box_line": 12, "participant_statement": 13, "openDirective": 14, "typeDirective": 15, "closeDirective": 16, ":": 17, "argDirective": 18, "box": 19, "restOfLine": 20, "end": 21, "signal": 22, "autonumber": 23, "NUM": 24, "off": 25, "activate": 26, "actor": 27, "deactivate": 28, "note_statement": 29, "links_statement": 30, "link_statement": 31, "properties_statement": 32, "details_statement": 33, "title": 34, "legacy_title": 35, "acc_title": 36, "acc_title_value": 37, "acc_descr": 38, "acc_descr_value": 39, "acc_descr_multiline_value": 40, "loop": 41, "rect": 42, "opt": 43, "alt": 44, "else_sections": 45, "par": 46, "par_sections": 47, "critical": 48, "option_sections": 49, "break": 50, "option": 51, "and": 52, "else": 53, "participant": 54, "AS": 55, "participant_actor": 56, "note": 57, "placement": 58, "text2": 59, "over": 60, "actor_pair": 61, "links": 62, "link": 63, "properties": 64, "details": 65, "spaceList": 66, ",": 67, "left_of": 68, "right_of": 69, "signaltype": 70, "+": 71, "-": 72, "ACTOR": 73, "SOLID_OPEN_ARROW": 74, "DOTTED_OPEN_ARROW": 75, "SOLID_ARROW": 76, "DOTTED_ARROW": 77, "SOLID_CROSS": 78, "DOTTED_CROSS": 79, "SOLID_POINT": 80, "DOTTED_POINT": 81, "TXT": 82, "open_directive": 83, "type_directive": 84, "arg_directive": 85, "close_directive": 86, "$accept": 0, "$end": 1 },
    terminals_: { 2: "error", 4: "SPACE", 5: "NEWLINE", 7: "SD", 17: ":", 19: "box", 20: "restOfLine", 21: "end", 23: "autonumber", 24: "NUM", 25: "off", 26: "activate", 28: "deactivate", 34: "title", 35: "legacy_title", 36: "acc_title", 37: "acc_title_value", 38: "acc_descr", 39: "acc_descr_value", 40: "acc_descr_multiline_value", 41: "loop", 42: "rect", 43: "opt", 44: "alt", 46: "par", 48: "critical", 50: "break", 51: "option", 52: "and", 53: "else", 54: "participant", 55: "AS", 56: "participant_actor", 57: "note", 60: "over", 62: "links", 63: "link", 64: "properties", 65: "details", 67: ",", 68: "left_of", 69: "right_of", 71: "+", 72: "-", 73: "ACTOR", 74: "SOLID_OPEN_ARROW", 75: "DOTTED_OPEN_ARROW", 76: "SOLID_ARROW", 77: "DOTTED_ARROW", 78: "SOLID_CROSS", 79: "DOTTED_CROSS", 80: "SOLID_POINT", 81: "DOTTED_POINT", 82: "TXT", 83: "open_directive", 84: "type_directive", 85: "arg_directive", 86: "close_directive" },
    productions_: [0, [3, 2], [3, 2], [3, 2], [3, 2], [8, 0], [8, 2], [9, 2], [9, 1], [9, 1], [11, 0], [11, 2], [12, 2], [12, 1], [12, 1], [6, 4], [6, 6], [10, 1], [10, 4], [10, 2], [10, 4], [10, 3], [10, 3], [10, 2], [10, 3], [10, 3], [10, 2], [10, 2], [10, 2], [10, 2], [10, 2], [10, 1], [10, 1], [10, 2], [10, 2], [10, 1], [10, 4], [10, 4], [10, 4], [10, 4], [10, 4], [10, 4], [10, 4], [10, 1], [49, 1], [49, 4], [47, 1], [47, 4], [45, 1], [45, 4], [13, 5], [13, 3], [13, 5], [13, 3], [29, 4], [29, 4], [30, 3], [31, 3], [32, 3], [33, 3], [66, 2], [66, 1], [61, 3], [61, 1], [58, 1], [58, 1], [22, 5], [22, 5], [22, 4], [27, 1], [70, 1], [70, 1], [70, 1], [70, 1], [70, 1], [70, 1], [70, 1], [70, 1], [59, 1], [14, 1], [15, 1], [18, 1], [16, 1]],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
      var $0 = $$.length - 1;
      switch (yystate) {
        case 4:
          yy.apply($$[$0]);
          return $$[$0];
        case 5:
        case 10:
          this.$ = [];
          break;
        case 6:
        case 11:
          $$[$0 - 1].push($$[$0]);
          this.$ = $$[$0 - 1];
          break;
        case 7:
        case 8:
        case 12:
        case 13:
          this.$ = $$[$0];
          break;
        case 9:
        case 14:
          this.$ = [];
          break;
        case 18:
          $$[$0 - 1].unshift({ type: "boxStart", boxData: yy.parseBoxData($$[$0 - 2]) });
          $$[$0 - 1].push({ type: "boxEnd", boxText: $$[$0 - 2] });
          this.$ = $$[$0 - 1];
          break;
        case 20:
          this.$ = { type: "sequenceIndex", sequenceIndex: Number($$[$0 - 2]), sequenceIndexStep: Number($$[$0 - 1]), sequenceVisible: true, signalType: yy.LINETYPE.AUTONUMBER };
          break;
        case 21:
          this.$ = { type: "sequenceIndex", sequenceIndex: Number($$[$0 - 1]), sequenceIndexStep: 1, sequenceVisible: true, signalType: yy.LINETYPE.AUTONUMBER };
          break;
        case 22:
          this.$ = { type: "sequenceIndex", sequenceVisible: false, signalType: yy.LINETYPE.AUTONUMBER };
          break;
        case 23:
          this.$ = { type: "sequenceIndex", sequenceVisible: true, signalType: yy.LINETYPE.AUTONUMBER };
          break;
        case 24:
          this.$ = { type: "activeStart", signalType: yy.LINETYPE.ACTIVE_START, actor: $$[$0 - 1] };
          break;
        case 25:
          this.$ = { type: "activeEnd", signalType: yy.LINETYPE.ACTIVE_END, actor: $$[$0 - 1] };
          break;
        case 31:
          yy.setDiagramTitle($$[$0].substring(6));
          this.$ = $$[$0].substring(6);
          break;
        case 32:
          yy.setDiagramTitle($$[$0].substring(7));
          this.$ = $$[$0].substring(7);
          break;
        case 33:
          this.$ = $$[$0].trim();
          yy.setAccTitle(this.$);
          break;
        case 34:
        case 35:
          this.$ = $$[$0].trim();
          yy.setAccDescription(this.$);
          break;
        case 36:
          $$[$0 - 1].unshift({ type: "loopStart", loopText: yy.parseMessage($$[$0 - 2]), signalType: yy.LINETYPE.LOOP_START });
          $$[$0 - 1].push({ type: "loopEnd", loopText: $$[$0 - 2], signalType: yy.LINETYPE.LOOP_END });
          this.$ = $$[$0 - 1];
          break;
        case 37:
          $$[$0 - 1].unshift({ type: "rectStart", color: yy.parseMessage($$[$0 - 2]), signalType: yy.LINETYPE.RECT_START });
          $$[$0 - 1].push({ type: "rectEnd", color: yy.parseMessage($$[$0 - 2]), signalType: yy.LINETYPE.RECT_END });
          this.$ = $$[$0 - 1];
          break;
        case 38:
          $$[$0 - 1].unshift({ type: "optStart", optText: yy.parseMessage($$[$0 - 2]), signalType: yy.LINETYPE.OPT_START });
          $$[$0 - 1].push({ type: "optEnd", optText: yy.parseMessage($$[$0 - 2]), signalType: yy.LINETYPE.OPT_END });
          this.$ = $$[$0 - 1];
          break;
        case 39:
          $$[$0 - 1].unshift({ type: "altStart", altText: yy.parseMessage($$[$0 - 2]), signalType: yy.LINETYPE.ALT_START });
          $$[$0 - 1].push({ type: "altEnd", signalType: yy.LINETYPE.ALT_END });
          this.$ = $$[$0 - 1];
          break;
        case 40:
          $$[$0 - 1].unshift({ type: "parStart", parText: yy.parseMessage($$[$0 - 2]), signalType: yy.LINETYPE.PAR_START });
          $$[$0 - 1].push({ type: "parEnd", signalType: yy.LINETYPE.PAR_END });
          this.$ = $$[$0 - 1];
          break;
        case 41:
          $$[$0 - 1].unshift({ type: "criticalStart", criticalText: yy.parseMessage($$[$0 - 2]), signalType: yy.LINETYPE.CRITICAL_START });
          $$[$0 - 1].push({ type: "criticalEnd", signalType: yy.LINETYPE.CRITICAL_END });
          this.$ = $$[$0 - 1];
          break;
        case 42:
          $$[$0 - 1].unshift({ type: "breakStart", breakText: yy.parseMessage($$[$0 - 2]), signalType: yy.LINETYPE.BREAK_START });
          $$[$0 - 1].push({ type: "breakEnd", optText: yy.parseMessage($$[$0 - 2]), signalType: yy.LINETYPE.BREAK_END });
          this.$ = $$[$0 - 1];
          break;
        case 45:
          this.$ = $$[$0 - 3].concat([{ type: "option", optionText: yy.parseMessage($$[$0 - 1]), signalType: yy.LINETYPE.CRITICAL_OPTION }, $$[$0]]);
          break;
        case 47:
          this.$ = $$[$0 - 3].concat([{ type: "and", parText: yy.parseMessage($$[$0 - 1]), signalType: yy.LINETYPE.PAR_AND }, $$[$0]]);
          break;
        case 49:
          this.$ = $$[$0 - 3].concat([{ type: "else", altText: yy.parseMessage($$[$0 - 1]), signalType: yy.LINETYPE.ALT_ELSE }, $$[$0]]);
          break;
        case 50:
          $$[$0 - 3].type = "addParticipant";
          $$[$0 - 3].description = yy.parseMessage($$[$0 - 1]);
          this.$ = $$[$0 - 3];
          break;
        case 51:
          $$[$0 - 1].type = "addParticipant";
          this.$ = $$[$0 - 1];
          break;
        case 52:
          $$[$0 - 3].type = "addActor";
          $$[$0 - 3].description = yy.parseMessage($$[$0 - 1]);
          this.$ = $$[$0 - 3];
          break;
        case 53:
          $$[$0 - 1].type = "addActor";
          this.$ = $$[$0 - 1];
          break;
        case 54:
          this.$ = [$$[$0 - 1], { type: "addNote", placement: $$[$0 - 2], actor: $$[$0 - 1].actor, text: $$[$0] }];
          break;
        case 55:
          $$[$0 - 2] = [].concat($$[$0 - 1], $$[$0 - 1]).slice(0, 2);
          $$[$0 - 2][0] = $$[$0 - 2][0].actor;
          $$[$0 - 2][1] = $$[$0 - 2][1].actor;
          this.$ = [$$[$0 - 1], { type: "addNote", placement: yy.PLACEMENT.OVER, actor: $$[$0 - 2].slice(0, 2), text: $$[$0] }];
          break;
        case 56:
          this.$ = [$$[$0 - 1], { type: "addLinks", actor: $$[$0 - 1].actor, text: $$[$0] }];
          break;
        case 57:
          this.$ = [$$[$0 - 1], { type: "addALink", actor: $$[$0 - 1].actor, text: $$[$0] }];
          break;
        case 58:
          this.$ = [$$[$0 - 1], { type: "addProperties", actor: $$[$0 - 1].actor, text: $$[$0] }];
          break;
        case 59:
          this.$ = [$$[$0 - 1], { type: "addDetails", actor: $$[$0 - 1].actor, text: $$[$0] }];
          break;
        case 62:
          this.$ = [$$[$0 - 2], $$[$0]];
          break;
        case 63:
          this.$ = $$[$0];
          break;
        case 64:
          this.$ = yy.PLACEMENT.LEFTOF;
          break;
        case 65:
          this.$ = yy.PLACEMENT.RIGHTOF;
          break;
        case 66:
          this.$ = [
            $$[$0 - 4],
            $$[$0 - 1],
            { type: "addMessage", from: $$[$0 - 4].actor, to: $$[$0 - 1].actor, signalType: $$[$0 - 3], msg: $$[$0] },
            { type: "activeStart", signalType: yy.LINETYPE.ACTIVE_START, actor: $$[$0 - 1] }
          ];
          break;
        case 67:
          this.$ = [
            $$[$0 - 4],
            $$[$0 - 1],
            { type: "addMessage", from: $$[$0 - 4].actor, to: $$[$0 - 1].actor, signalType: $$[$0 - 3], msg: $$[$0] },
            { type: "activeEnd", signalType: yy.LINETYPE.ACTIVE_END, actor: $$[$0 - 4] }
          ];
          break;
        case 68:
          this.$ = [$$[$0 - 3], $$[$0 - 1], { type: "addMessage", from: $$[$0 - 3].actor, to: $$[$0 - 1].actor, signalType: $$[$0 - 2], msg: $$[$0] }];
          break;
        case 69:
          this.$ = { type: "addParticipant", actor: $$[$0] };
          break;
        case 70:
          this.$ = yy.LINETYPE.SOLID_OPEN;
          break;
        case 71:
          this.$ = yy.LINETYPE.DOTTED_OPEN;
          break;
        case 72:
          this.$ = yy.LINETYPE.SOLID;
          break;
        case 73:
          this.$ = yy.LINETYPE.DOTTED;
          break;
        case 74:
          this.$ = yy.LINETYPE.SOLID_CROSS;
          break;
        case 75:
          this.$ = yy.LINETYPE.DOTTED_CROSS;
          break;
        case 76:
          this.$ = yy.LINETYPE.SOLID_POINT;
          break;
        case 77:
          this.$ = yy.LINETYPE.DOTTED_POINT;
          break;
        case 78:
          this.$ = yy.parseMessage($$[$0].trim().substring(1));
          break;
        case 79:
          yy.parseDirective("%%{", "open_directive");
          break;
        case 80:
          yy.parseDirective($$[$0], "type_directive");
          break;
        case 81:
          $$[$0] = $$[$0].trim().replace(/'/g, '"');
          yy.parseDirective($$[$0], "arg_directive");
          break;
        case 82:
          yy.parseDirective("}%%", "close_directive", "sequence");
          break;
      }
    },
    table: [{ 3: 1, 4: $V0, 5: $V1, 6: 4, 7: $V2, 14: 6, 83: $V3 }, { 1: [3] }, { 3: 8, 4: $V0, 5: $V1, 6: 4, 7: $V2, 14: 6, 83: $V3 }, { 3: 9, 4: $V0, 5: $V1, 6: 4, 7: $V2, 14: 6, 83: $V3 }, { 3: 10, 4: $V0, 5: $V1, 6: 4, 7: $V2, 14: 6, 83: $V3 }, o([1, 4, 5, 19, 23, 26, 28, 34, 35, 36, 38, 40, 41, 42, 43, 44, 46, 48, 50, 54, 56, 57, 62, 63, 64, 65, 73, 83], $V4, { 8: 11 }), { 15: 12, 84: [1, 13] }, { 84: [2, 79] }, { 1: [2, 1] }, { 1: [2, 2] }, { 1: [2, 3] }, { 1: [2, 4], 4: $V5, 5: $V6, 6: 41, 9: 14, 10: 16, 13: 18, 14: 6, 19: $V7, 22: 20, 23: $V8, 26: $V9, 27: 44, 28: $Va, 29: 24, 30: 25, 31: 26, 32: 27, 33: 28, 34: $Vb, 35: $Vc, 36: $Vd, 38: $Ve, 40: $Vf, 41: $Vg, 42: $Vh, 43: $Vi, 44: $Vj, 46: $Vk, 48: $Vl, 50: $Vm, 54: $Vn, 56: $Vo, 57: $Vp, 62: $Vq, 63: $Vr, 64: $Vs, 65: $Vt, 73: $Vu, 83: $V3 }, { 16: 51, 17: [1, 52], 86: $Vv }, o([17, 86], [2, 80]), o($Vw, [2, 6]), { 6: 41, 10: 54, 13: 18, 14: 6, 19: $V7, 22: 20, 23: $V8, 26: $V9, 27: 44, 28: $Va, 29: 24, 30: 25, 31: 26, 32: 27, 33: 28, 34: $Vb, 35: $Vc, 36: $Vd, 38: $Ve, 40: $Vf, 41: $Vg, 42: $Vh, 43: $Vi, 44: $Vj, 46: $Vk, 48: $Vl, 50: $Vm, 54: $Vn, 56: $Vo, 57: $Vp, 62: $Vq, 63: $Vr, 64: $Vs, 65: $Vt, 73: $Vu, 83: $V3 }, o($Vw, [2, 8]), o($Vw, [2, 9]), o($Vw, [2, 17]), { 20: [1, 55] }, { 5: [1, 56] }, { 5: [1, 59], 24: [1, 57], 25: [1, 58] }, { 27: 60, 73: $Vu }, { 27: 61, 73: $Vu }, { 5: [1, 62] }, { 5: [1, 63] }, { 5: [1, 64] }, { 5: [1, 65] }, { 5: [1, 66] }, o($Vw, [2, 31]), o($Vw, [2, 32]), { 37: [1, 67] }, { 39: [1, 68] }, o($Vw, [2, 35]), { 20: [1, 69] }, { 20: [1, 70] }, { 20: [1, 71] }, { 20: [1, 72] }, { 20: [1, 73] }, { 20: [1, 74] }, { 20: [1, 75] }, o($Vw, [2, 43]), { 27: 76, 73: $Vu }, { 27: 77, 73: $Vu }, { 70: 78, 74: [1, 79], 75: [1, 80], 76: [1, 81], 77: [1, 82], 78: [1, 83], 79: [1, 84], 80: [1, 85], 81: [1, 86] }, { 58: 87, 60: [1, 88], 68: [1, 89], 69: [1, 90] }, { 27: 91, 73: $Vu }, { 27: 92, 73: $Vu }, { 27: 93, 73: $Vu }, { 27: 94, 73: $Vu }, o([5, 55, 67, 74, 75, 76, 77, 78, 79, 80, 81, 82], [2, 69]), { 5: [1, 95] }, { 18: 96, 85: [1, 97] }, { 5: [2, 82] }, o($Vw, [2, 7]), o($Vx, [2, 10], { 11: 98 }), o($Vw, [2, 19]), { 5: [1, 100], 24: [1, 99] }, { 5: [1, 101] }, o($Vw, [2, 23]), { 5: [1, 102] }, { 5: [1, 103] }, o($Vw, [2, 26]), o($Vw, [2, 27]), o($Vw, [2, 28]), o($Vw, [2, 29]), o($Vw, [2, 30]), o($Vw, [2, 33]), o($Vw, [2, 34]), o($Vy, $V4, { 8: 104 }), o($Vy, $V4, { 8: 105 }), o($Vy, $V4, { 8: 106 }), o($Vz, $V4, { 45: 107, 8: 108 }), o($VA, $V4, { 47: 109, 8: 110 }), o($VB, $V4, { 49: 111, 8: 112 }), o($Vy, $V4, { 8: 113 }), { 5: [1, 115], 55: [1, 114] }, { 5: [1, 117], 55: [1, 116] }, { 27: 120, 71: [1, 118], 72: [1, 119], 73: $Vu }, o($VC, [2, 70]), o($VC, [2, 71]), o($VC, [2, 72]), o($VC, [2, 73]), o($VC, [2, 74]), o($VC, [2, 75]), o($VC, [2, 76]), o($VC, [2, 77]), { 27: 121, 73: $Vu }, { 27: 123, 61: 122, 73: $Vu }, { 73: [2, 64] }, { 73: [2, 65] }, { 59: 124, 82: $VD }, { 59: 126, 82: $VD }, { 59: 127, 82: $VD }, { 59: 128, 82: $VD }, o($VE, [2, 15]), { 16: 129, 86: $Vv }, { 86: [2, 81] }, { 4: [1, 132], 5: [1, 134], 12: 131, 13: 133, 21: [1, 130], 54: $Vn, 56: $Vo }, { 5: [1, 135] }, o($Vw, [2, 21]), o($Vw, [2, 22]), o($Vw, [2, 24]), o($Vw, [2, 25]), { 4: $V5, 5: $V6, 6: 41, 9: 14, 10: 16, 13: 18, 14: 6, 19: $V7, 21: [1, 136], 22: 20, 23: $V8, 26: $V9, 27: 44, 28: $Va, 29: 24, 30: 25, 31: 26, 32: 27, 33: 28, 34: $Vb, 35: $Vc, 36: $Vd, 38: $Ve, 40: $Vf, 41: $Vg, 42: $Vh, 43: $Vi, 44: $Vj, 46: $Vk, 48: $Vl, 50: $Vm, 54: $Vn, 56: $Vo, 57: $Vp, 62: $Vq, 63: $Vr, 64: $Vs, 65: $Vt, 73: $Vu, 83: $V3 }, { 4: $V5, 5: $V6, 6: 41, 9: 14, 10: 16, 13: 18, 14: 6, 19: $V7, 21: [1, 137], 22: 20, 23: $V8, 26: $V9, 27: 44, 28: $Va, 29: 24, 30: 25, 31: 26, 32: 27, 33: 28, 34: $Vb, 35: $Vc, 36: $Vd, 38: $Ve, 40: $Vf, 41: $Vg, 42: $Vh, 43: $Vi, 44: $Vj, 46: $Vk, 48: $Vl, 50: $Vm, 54: $Vn, 56: $Vo, 57: $Vp, 62: $Vq, 63: $Vr, 64: $Vs, 65: $Vt, 73: $Vu, 83: $V3 }, { 4: $V5, 5: $V6, 6: 41, 9: 14, 10: 16, 13: 18, 14: 6, 19: $V7, 21: [1, 138], 22: 20, 23: $V8, 26: $V9, 27: 44, 28: $Va, 29: 24, 30: 25, 31: 26, 32: 27, 33: 28, 34: $Vb, 35: $Vc, 36: $Vd, 38: $Ve, 40: $Vf, 41: $Vg, 42: $Vh, 43: $Vi, 44: $Vj, 46: $Vk, 48: $Vl, 50: $Vm, 54: $Vn, 56: $Vo, 57: $Vp, 62: $Vq, 63: $Vr, 64: $Vs, 65: $Vt, 73: $Vu, 83: $V3 }, { 21: [1, 139] }, { 4: $V5, 5: $V6, 6: 41, 9: 14, 10: 16, 13: 18, 14: 6, 19: $V7, 21: [2, 48], 22: 20, 23: $V8, 26: $V9, 27: 44, 28: $Va, 29: 24, 30: 25, 31: 26, 32: 27, 33: 28, 34: $Vb, 35: $Vc, 36: $Vd, 38: $Ve, 40: $Vf, 41: $Vg, 42: $Vh, 43: $Vi, 44: $Vj, 46: $Vk, 48: $Vl, 50: $Vm, 53: [1, 140], 54: $Vn, 56: $Vo, 57: $Vp, 62: $Vq, 63: $Vr, 64: $Vs, 65: $Vt, 73: $Vu, 83: $V3 }, { 21: [1, 141] }, { 4: $V5, 5: $V6, 6: 41, 9: 14, 10: 16, 13: 18, 14: 6, 19: $V7, 21: [2, 46], 22: 20, 23: $V8, 26: $V9, 27: 44, 28: $Va, 29: 24, 30: 25, 31: 26, 32: 27, 33: 28, 34: $Vb, 35: $Vc, 36: $Vd, 38: $Ve, 40: $Vf, 41: $Vg, 42: $Vh, 43: $Vi, 44: $Vj, 46: $Vk, 48: $Vl, 50: $Vm, 52: [1, 142], 54: $Vn, 56: $Vo, 57: $Vp, 62: $Vq, 63: $Vr, 64: $Vs, 65: $Vt, 73: $Vu, 83: $V3 }, { 21: [1, 143] }, { 4: $V5, 5: $V6, 6: 41, 9: 14, 10: 16, 13: 18, 14: 6, 19: $V7, 21: [2, 44], 22: 20, 23: $V8, 26: $V9, 27: 44, 28: $Va, 29: 24, 30: 25, 31: 26, 32: 27, 33: 28, 34: $Vb, 35: $Vc, 36: $Vd, 38: $Ve, 40: $Vf, 41: $Vg, 42: $Vh, 43: $Vi, 44: $Vj, 46: $Vk, 48: $Vl, 50: $Vm, 51: [1, 144], 54: $Vn, 56: $Vo, 57: $Vp, 62: $Vq, 63: $Vr, 64: $Vs, 65: $Vt, 73: $Vu, 83: $V3 }, { 4: $V5, 5: $V6, 6: 41, 9: 14, 10: 16, 13: 18, 14: 6, 19: $V7, 21: [1, 145], 22: 20, 23: $V8, 26: $V9, 27: 44, 28: $Va, 29: 24, 30: 25, 31: 26, 32: 27, 33: 28, 34: $Vb, 35: $Vc, 36: $Vd, 38: $Ve, 40: $Vf, 41: $Vg, 42: $Vh, 43: $Vi, 44: $Vj, 46: $Vk, 48: $Vl, 50: $Vm, 54: $Vn, 56: $Vo, 57: $Vp, 62: $Vq, 63: $Vr, 64: $Vs, 65: $Vt, 73: $Vu, 83: $V3 }, { 20: [1, 146] }, o($Vw, [2, 51]), { 20: [1, 147] }, o($Vw, [2, 53]), { 27: 148, 73: $Vu }, { 27: 149, 73: $Vu }, { 59: 150, 82: $VD }, { 59: 151, 82: $VD }, { 59: 152, 82: $VD }, { 67: [1, 153], 82: [2, 63] }, { 5: [2, 56] }, { 5: [2, 78] }, { 5: [2, 57] }, { 5: [2, 58] }, { 5: [2, 59] }, { 5: [1, 154] }, o($Vw, [2, 18]), o($Vx, [2, 11]), { 13: 155, 54: $Vn, 56: $Vo }, o($Vx, [2, 13]), o($Vx, [2, 14]), o($Vw, [2, 20]), o($Vw, [2, 36]), o($Vw, [2, 37]), o($Vw, [2, 38]), o($Vw, [2, 39]), { 20: [1, 156] }, o($Vw, [2, 40]), { 20: [1, 157] }, o($Vw, [2, 41]), { 20: [1, 158] }, o($Vw, [2, 42]), { 5: [1, 159] }, { 5: [1, 160] }, { 59: 161, 82: $VD }, { 59: 162, 82: $VD }, { 5: [2, 68] }, { 5: [2, 54] }, { 5: [2, 55] }, { 27: 163, 73: $Vu }, o($VE, [2, 16]), o($Vx, [2, 12]), o($Vz, $V4, { 8: 108, 45: 164 }), o($VA, $V4, { 8: 110, 47: 165 }), o($VB, $V4, { 8: 112, 49: 166 }), o($Vw, [2, 50]), o($Vw, [2, 52]), { 5: [2, 66] }, { 5: [2, 67] }, { 82: [2, 62] }, { 21: [2, 49] }, { 21: [2, 47] }, { 21: [2, 45] }],
    defaultActions: { 7: [2, 79], 8: [2, 1], 9: [2, 2], 10: [2, 3], 53: [2, 82], 89: [2, 64], 90: [2, 65], 97: [2, 81], 124: [2, 56], 125: [2, 78], 126: [2, 57], 127: [2, 58], 128: [2, 59], 150: [2, 68], 151: [2, 54], 152: [2, 55], 161: [2, 66], 162: [2, 67], 163: [2, 62], 164: [2, 49], 165: [2, 47], 166: [2, 45] },
    parseError: function parseError(str2, hash) {
      if (hash.recoverable) {
        this.trace(str2);
      } else {
        var error = new Error(str2);
        error.hash = hash;
        throw error;
      }
    },
    parse: function parse2(input) {
      var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
      var args = lstack.slice.call(arguments, 1);
      var lexer2 = Object.create(this.lexer);
      var sharedState = { yy: {} };
      for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
          sharedState.yy[k] = this.yy[k];
        }
      }
      lexer2.setInput(input, sharedState.yy);
      sharedState.yy.lexer = lexer2;
      sharedState.yy.parser = this;
      if (typeof lexer2.yylloc == "undefined") {
        lexer2.yylloc = {};
      }
      var yyloc = lexer2.yylloc;
      lstack.push(yyloc);
      var ranges = lexer2.options && lexer2.options.ranges;
      if (typeof sharedState.yy.parseError === "function") {
        this.parseError = sharedState.yy.parseError;
      } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
      }
      function lex2() {
        var token;
        token = tstack.pop() || lexer2.lex() || EOF;
        if (typeof token !== "number") {
          if (token instanceof Array) {
            tstack = token;
            token = tstack.pop();
          }
          token = self.symbols_[token] || token;
        }
        return token;
      }
      var symbol, state, action, r, yyval = {}, p, len, newState, expected;
      while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
          action = this.defaultActions[state];
        } else {
          if (symbol === null || typeof symbol == "undefined") {
            symbol = lex2();
          }
          action = table[state] && table[state][symbol];
        }
        if (typeof action === "undefined" || !action.length || !action[0]) {
          var errStr = "";
          expected = [];
          for (p in table[state]) {
            if (this.terminals_[p] && p > TERROR) {
              expected.push("'" + this.terminals_[p] + "'");
            }
          }
          if (lexer2.showPosition) {
            errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
          } else {
            errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
          }
          this.parseError(errStr, {
            text: lexer2.match,
            token: this.terminals_[symbol] || symbol,
            line: lexer2.yylineno,
            loc: yyloc,
            expected
          });
        }
        if (action[0] instanceof Array && action.length > 1) {
          throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
        }
        switch (action[0]) {
          case 1:
            stack.push(symbol);
            vstack.push(lexer2.yytext);
            lstack.push(lexer2.yylloc);
            stack.push(action[1]);
            symbol = null;
            {
              yyleng = lexer2.yyleng;
              yytext = lexer2.yytext;
              yylineno = lexer2.yylineno;
              yyloc = lexer2.yylloc;
            }
            break;
          case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
              first_line: lstack[lstack.length - (len || 1)].first_line,
              last_line: lstack[lstack.length - 1].last_line,
              first_column: lstack[lstack.length - (len || 1)].first_column,
              last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
              yyval._$.range = [
                lstack[lstack.length - (len || 1)].range[0],
                lstack[lstack.length - 1].range[1]
              ];
            }
            r = this.performAction.apply(yyval, [
              yytext,
              yyleng,
              yylineno,
              sharedState.yy,
              action[1],
              vstack,
              lstack
            ].concat(args));
            if (typeof r !== "undefined") {
              return r;
            }
            if (len) {
              stack = stack.slice(0, -1 * len * 2);
              vstack = vstack.slice(0, -1 * len);
              lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
          case 3:
            return true;
        }
      }
      return true;
    }
  };
  var lexer = function() {
    var lexer2 = {
      EOF: 1,
      parseError: function parseError(str2, hash) {
        if (this.yy.parser) {
          this.yy.parser.parseError(str2, hash);
        } else {
          throw new Error(str2);
        }
      },
      // resets the lexer, sets new input
      setInput: function(input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = "";
        this.conditionStack = ["INITIAL"];
        this.yylloc = {
          first_line: 1,
          first_column: 0,
          last_line: 1,
          last_column: 0
        };
        if (this.options.ranges) {
          this.yylloc.range = [0, 0];
        }
        this.offset = 0;
        return this;
      },
      // consumes and returns one char from the input
      input: function() {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno++;
          this.yylloc.last_line++;
        } else {
          this.yylloc.last_column++;
        }
        if (this.options.ranges) {
          this.yylloc.range[1]++;
        }
        this._input = this._input.slice(1);
        return ch;
      },
      // unshifts one char (or a string) into the input
      unput: function(ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);
        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);
        if (lines.length - 1) {
          this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;
        this.yylloc = {
          first_line: this.yylloc.first_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.first_column,
          last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
        };
        if (this.options.ranges) {
          this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
      },
      // When called from action, caches matched text and appends it on next action
      more: function() {
        this._more = true;
        return this;
      },
      // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
      reject: function() {
        if (this.options.backtrack_lexer) {
          this._backtrack = true;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
        return this;
      },
      // retain first n characters of the match
      less: function(n) {
        this.unput(this.match.slice(n));
      },
      // displays already matched input, i.e. for error messages
      pastInput: function() {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
      },
      // displays upcoming input, i.e. for error messages
      upcomingInput: function() {
        var next = this.match;
        if (next.length < 20) {
          next += this._input.substr(0, 20 - next.length);
        }
        return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
      },
      // displays the character position where the lexing error occurred, i.e. for error messages
      showPosition: function() {
        var pre = this.pastInput();
        var c2 = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c2 + "^";
      },
      // test the lexed token: return FALSE when not a match, otherwise return token
      test_match: function(match, indexed_rule) {
        var token, lines, backup;
        if (this.options.backtrack_lexer) {
          backup = {
            yylineno: this.yylineno,
            yylloc: {
              first_line: this.yylloc.first_line,
              last_line: this.last_line,
              first_column: this.yylloc.first_column,
              last_column: this.yylloc.last_column
            },
            yytext: this.yytext,
            match: this.match,
            matches: this.matches,
            matched: this.matched,
            yyleng: this.yyleng,
            offset: this.offset,
            _more: this._more,
            _input: this._input,
            yy: this.yy,
            conditionStack: this.conditionStack.slice(0),
            done: this.done
          };
          if (this.options.ranges) {
            backup.yylloc.range = this.yylloc.range.slice(0);
          }
        }
        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno += lines.length;
        }
        this.yylloc = {
          first_line: this.yylloc.last_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.last_column,
          last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
          this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
          this.done = false;
        }
        if (token) {
          return token;
        } else if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
        return false;
      },
      // return next match in input
      next: function() {
        if (this.done) {
          return this.EOF;
        }
        if (!this._input) {
          this.done = true;
        }
        var token, match, tempMatch, index;
        if (!this._more) {
          this.yytext = "";
          this.match = "";
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
          tempMatch = this._input.match(this.rules[rules[i]]);
          if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
            match = tempMatch;
            index = i;
            if (this.options.backtrack_lexer) {
              token = this.test_match(tempMatch, rules[i]);
              if (token !== false) {
                return token;
              } else if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            } else if (!this.options.flex) {
              break;
            }
          }
        }
        if (match) {
          token = this.test_match(match, rules[index]);
          if (token !== false) {
            return token;
          }
          return false;
        }
        if (this._input === "") {
          return this.EOF;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
      },
      // return next match that has a token
      lex: function lex2() {
        var r = this.next();
        if (r) {
          return r;
        } else {
          return this.lex();
        }
      },
      // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
      begin: function begin(condition) {
        this.conditionStack.push(condition);
      },
      // pop the previously active lexer condition state off the condition stack
      popState: function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
          return this.conditionStack.pop();
        } else {
          return this.conditionStack[0];
        }
      },
      // produce the lexer rule set which is active for the currently active lexer condition state
      _currentRules: function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
          return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
          return this.conditions["INITIAL"].rules;
        }
      },
      // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
      topState: function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
          return this.conditionStack[n];
        } else {
          return "INITIAL";
        }
      },
      // alias for begin(condition)
      pushState: function pushState(condition) {
        this.begin(condition);
      },
      // return the number of states currently on the stack
      stateStackSize: function stateStackSize() {
        return this.conditionStack.length;
      },
      options: { "case-insensitive": true },
      performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
        switch ($avoiding_name_collisions) {
          case 0:
            this.begin("open_directive");
            return 83;
          case 1:
            this.begin("type_directive");
            return 84;
          case 2:
            this.popState();
            this.begin("arg_directive");
            return 17;
          case 3:
            this.popState();
            this.popState();
            return 86;
          case 4:
            return 85;
          case 5:
            return 5;
          case 6:
            break;
          case 7:
            break;
          case 8:
            break;
          case 9:
            break;
          case 10:
            break;
          case 11:
            return 24;
          case 12:
            this.begin("LINE");
            return 19;
          case 13:
            this.begin("ID");
            return 54;
          case 14:
            this.begin("ID");
            return 56;
          case 15:
            yy_.yytext = yy_.yytext.trim();
            this.begin("ALIAS");
            return 73;
          case 16:
            this.popState();
            this.popState();
            this.begin("LINE");
            return 55;
          case 17:
            this.popState();
            this.popState();
            return 5;
          case 18:
            this.begin("LINE");
            return 41;
          case 19:
            this.begin("LINE");
            return 42;
          case 20:
            this.begin("LINE");
            return 43;
          case 21:
            this.begin("LINE");
            return 44;
          case 22:
            this.begin("LINE");
            return 53;
          case 23:
            this.begin("LINE");
            return 46;
          case 24:
            this.begin("LINE");
            return 52;
          case 25:
            this.begin("LINE");
            return 48;
          case 26:
            this.begin("LINE");
            return 51;
          case 27:
            this.begin("LINE");
            return 50;
          case 28:
            this.popState();
            return 20;
          case 29:
            return 21;
          case 30:
            return 68;
          case 31:
            return 69;
          case 32:
            return 62;
          case 33:
            return 63;
          case 34:
            return 64;
          case 35:
            return 65;
          case 36:
            return 60;
          case 37:
            return 57;
          case 38:
            this.begin("ID");
            return 26;
          case 39:
            this.begin("ID");
            return 28;
          case 40:
            return 34;
          case 41:
            return 35;
          case 42:
            this.begin("acc_title");
            return 36;
          case 43:
            this.popState();
            return "acc_title_value";
          case 44:
            this.begin("acc_descr");
            return 38;
          case 45:
            this.popState();
            return "acc_descr_value";
          case 46:
            this.begin("acc_descr_multiline");
            break;
          case 47:
            this.popState();
            break;
          case 48:
            return "acc_descr_multiline_value";
          case 49:
            return 7;
          case 50:
            return 23;
          case 51:
            return 25;
          case 52:
            return 67;
          case 53:
            return 5;
          case 54:
            yy_.yytext = yy_.yytext.trim();
            return 73;
          case 55:
            return 76;
          case 56:
            return 77;
          case 57:
            return 74;
          case 58:
            return 75;
          case 59:
            return 78;
          case 60:
            return 79;
          case 61:
            return 80;
          case 62:
            return 81;
          case 63:
            return 82;
          case 64:
            return 71;
          case 65:
            return 72;
          case 66:
            return 5;
          case 67:
            return "INVALID";
        }
      },
      rules: [/^(?:%%\{)/i, /^(?:((?:(?!\}%%)[^:.])*))/i, /^(?::)/i, /^(?:\}%%)/i, /^(?:((?:(?!\}%%).|\n)*))/i, /^(?:[\n]+)/i, /^(?:\s+)/i, /^(?:((?!\n)\s)+)/i, /^(?:#[^\n]*)/i, /^(?:%(?!\{)[^\n]*)/i, /^(?:[^\}]%%[^\n]*)/i, /^(?:[0-9]+(?=[ \n]+))/i, /^(?:box\b)/i, /^(?:participant\b)/i, /^(?:actor\b)/i, /^(?:[^\->:\n,;]+?([\-]*[^\->:\n,;]+?)*?(?=((?!\n)\s)+as(?!\n)\s|[#\n;]|$))/i, /^(?:as\b)/i, /^(?:(?:))/i, /^(?:loop\b)/i, /^(?:rect\b)/i, /^(?:opt\b)/i, /^(?:alt\b)/i, /^(?:else\b)/i, /^(?:par\b)/i, /^(?:and\b)/i, /^(?:critical\b)/i, /^(?:option\b)/i, /^(?:break\b)/i, /^(?:(?:[:]?(?:no)?wrap)?[^#\n;]*)/i, /^(?:end\b)/i, /^(?:left of\b)/i, /^(?:right of\b)/i, /^(?:links\b)/i, /^(?:link\b)/i, /^(?:properties\b)/i, /^(?:details\b)/i, /^(?:over\b)/i, /^(?:note\b)/i, /^(?:activate\b)/i, /^(?:deactivate\b)/i, /^(?:title\s[^#\n;]+)/i, /^(?:title:\s[^#\n;]+)/i, /^(?:accTitle\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*:\s*)/i, /^(?:(?!\n||)*[^\n]*)/i, /^(?:accDescr\s*\{\s*)/i, /^(?:[\}])/i, /^(?:[^\}]*)/i, /^(?:sequenceDiagram\b)/i, /^(?:autonumber\b)/i, /^(?:off\b)/i, /^(?:,)/i, /^(?:;)/i, /^(?:[^\+\->:\n,;]+((?!(-x|--x|-\)|--\)))[\-]*[^\+\->:\n,;]+)*)/i, /^(?:->>)/i, /^(?:-->>)/i, /^(?:->)/i, /^(?:-->)/i, /^(?:-[x])/i, /^(?:--[x])/i, /^(?:-[\)])/i, /^(?:--[\)])/i, /^(?::(?:(?:no)?wrap)?[^#\n;]+)/i, /^(?:\+)/i, /^(?:-)/i, /^(?:$)/i, /^(?:.)/i],
      conditions: { "acc_descr_multiline": { "rules": [47, 48], "inclusive": false }, "acc_descr": { "rules": [45], "inclusive": false }, "acc_title": { "rules": [43], "inclusive": false }, "open_directive": { "rules": [1, 8], "inclusive": false }, "type_directive": { "rules": [2, 3, 8], "inclusive": false }, "arg_directive": { "rules": [3, 4, 8], "inclusive": false }, "ID": { "rules": [7, 8, 15], "inclusive": false }, "ALIAS": { "rules": [7, 8, 16, 17], "inclusive": false }, "LINE": { "rules": [7, 8, 28], "inclusive": false }, "INITIAL": { "rules": [0, 5, 6, 8, 9, 10, 11, 12, 13, 14, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67], "inclusive": true } }
    };
    return lexer2;
  }();
  parser2.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  Parser.prototype = parser2;
  parser2.Parser = Parser;
  return new Parser();
}();
parser$2.parser = parser$2;
const sequenceParser = parser$2;
const sequenceDetector = (txt) => {
  return txt.match(/^\s*sequenceDiagram/) !== null;
};
let prevActor = void 0;
let actors$1 = {};
let boxes = [];
let messages = [];
let sequenceNumbersEnabled = false;
let wrapEnabled;
let currentBox = void 0;
const parseDirective$2 = function(statement, context, type2) {
  mermaidAPI.parseDirective(this, statement, context, type2);
};
const addBox = function(data) {
  boxes.push({
    name: data.text,
    wrap: data.wrap === void 0 && autoWrap() || !!data.wrap,
    fill: data.color,
    actorKeys: []
  });
  currentBox = boxes.slice(-1)[0];
};
const addActor = function(id2, name, description2, type2) {
  let assignedBox = currentBox;
  const old = actors$1[id2];
  if (old) {
    if (currentBox && old.box && currentBox !== old.box) {
      throw new Error(
        "A same participant should only be defined in one Box: " + old.name + " can't be in '" + old.box.name + "' and in '" + currentBox.name + "' at the same time."
      );
    }
    assignedBox = old.box ? old.box : currentBox;
    old.box = assignedBox;
    if (old && name === old.name && description2 == null) {
      return;
    }
  }
  if (description2 == null || description2.text == null) {
    description2 = { text: name, wrap: null, type: type2 };
  }
  if (type2 == null || description2.text == null) {
    description2 = { text: name, wrap: null, type: type2 };
  }
  actors$1[id2] = {
    box: assignedBox,
    name,
    description: description2.text,
    wrap: description2.wrap === void 0 && autoWrap() || !!description2.wrap,
    prevActor,
    links: {},
    properties: {},
    actorCnt: null,
    rectData: null,
    type: type2 || "participant"
  };
  if (prevActor && actors$1[prevActor]) {
    actors$1[prevActor].nextActor = id2;
  }
  if (currentBox) {
    currentBox.actorKeys.push(id2);
  }
  prevActor = id2;
};
const activationCount = (part) => {
  let i;
  let count = 0;
  for (i = 0; i < messages.length; i++) {
    if (messages[i].type === LINETYPE.ACTIVE_START && messages[i].from.actor === part) {
      count++;
    }
    if (messages[i].type === LINETYPE.ACTIVE_END && messages[i].from.actor === part) {
      count--;
    }
  }
  return count;
};
const addMessage = function(idFrom, idTo, message2, answer) {
  messages.push({
    from: idFrom,
    to: idTo,
    message: message2.text,
    wrap: message2.wrap === void 0 && autoWrap() || !!message2.wrap,
    answer
  });
};
const addSignal = function(idFrom, idTo, message2 = { text: void 0, wrap: void 0 }, messageType) {
  if (messageType === LINETYPE.ACTIVE_END) {
    const cnt2 = activationCount(idFrom.actor);
    if (cnt2 < 1) {
      let error = new Error("Trying to inactivate an inactive participant (" + idFrom.actor + ")");
      error.hash = {
        text: "->>-",
        token: "->>-",
        line: "1",
        loc: { first_line: 1, last_line: 1, first_column: 1, last_column: 1 },
        expected: ["'ACTIVE_PARTICIPANT'"]
      };
      throw error;
    }
  }
  messages.push({
    from: idFrom,
    to: idTo,
    message: message2.text,
    wrap: message2.wrap === void 0 && autoWrap() || !!message2.wrap,
    type: messageType
  });
  return true;
};
const hasAtLeastOneBox = function() {
  return boxes.length > 0;
};
const hasAtLeastOneBoxWithTitle = function() {
  return boxes.some((b) => b.name);
};
const getMessages = function() {
  return messages;
};
const getBoxes = function() {
  return boxes;
};
const getActors$1 = function() {
  return actors$1;
};
const getActor = function(id2) {
  return actors$1[id2];
};
const getActorKeys = function() {
  return Object.keys(actors$1);
};
const enableSequenceNumbers = function() {
  sequenceNumbersEnabled = true;
};
const disableSequenceNumbers = function() {
  sequenceNumbersEnabled = false;
};
const showSequenceNumbers = () => sequenceNumbersEnabled;
const setWrap = function(wrapSetting) {
  wrapEnabled = wrapSetting;
};
const autoWrap = () => {
  if (wrapEnabled !== void 0) {
    return wrapEnabled;
  }
  return getConfig$1().sequence.wrap;
};
const clear$2 = function() {
  actors$1 = {};
  boxes = [];
  messages = [];
  sequenceNumbersEnabled = false;
  clear$g();
};
const parseMessage = function(str2) {
  const _str = str2.trim();
  const message2 = {
    text: _str.replace(/^:?(?:no)?wrap:/, "").trim(),
    wrap: _str.match(/^:?wrap:/) !== null ? true : _str.match(/^:?nowrap:/) !== null ? false : void 0
  };
  log$1.debug("parseMessage:", message2);
  return message2;
};
const parseBoxData = function(str2) {
  const match = str2.match(/^((?:rgba?|hsla?)\s*\(.*\)|\w*)(.*)$/);
  let color = match != null && match[1] ? match[1].trim() : "transparent";
  let title2 = match != null && match[2] ? match[2].trim() : void 0;
  if (window && window.CSS) {
    if (!window.CSS.supports("color", color)) {
      color = "transparent";
      title2 = str2.trim();
    }
  } else {
    const style = new Option().style;
    style.color = color;
    if (style.color !== color) {
      color = "transparent";
      title2 = str2.trim();
    }
  }
  const boxData = {
    color,
    text: title2 !== void 0 ? sanitizeText$5(title2.replace(/^:?(?:no)?wrap:/, ""), getConfig$1()) : void 0,
    wrap: title2 !== void 0 ? title2.match(/^:?wrap:/) !== null ? true : title2.match(/^:?nowrap:/) !== null ? false : void 0 : void 0
  };
  return boxData;
};
const LINETYPE = {
  SOLID: 0,
  DOTTED: 1,
  NOTE: 2,
  SOLID_CROSS: 3,
  DOTTED_CROSS: 4,
  SOLID_OPEN: 5,
  DOTTED_OPEN: 6,
  LOOP_START: 10,
  LOOP_END: 11,
  ALT_START: 12,
  ALT_ELSE: 13,
  ALT_END: 14,
  OPT_START: 15,
  OPT_END: 16,
  ACTIVE_START: 17,
  ACTIVE_END: 18,
  PAR_START: 19,
  PAR_AND: 20,
  PAR_END: 21,
  RECT_START: 22,
  RECT_END: 23,
  SOLID_POINT: 24,
  DOTTED_POINT: 25,
  AUTONUMBER: 26,
  CRITICAL_START: 27,
  CRITICAL_OPTION: 28,
  CRITICAL_END: 29,
  BREAK_START: 30,
  BREAK_END: 31
};
const ARROWTYPE = {
  FILLED: 0,
  OPEN: 1
};
const PLACEMENT = {
  LEFTOF: 0,
  RIGHTOF: 1,
  OVER: 2
};
const addNote = function(actor, placement, message2) {
  ({
    actor,
    placement,
    message: message2.text,
    wrap: message2.wrap === void 0 && autoWrap() || !!message2.wrap
  });
  const actors2 = [].concat(actor, actor);
  messages.push({
    from: actors2[0],
    to: actors2[1],
    message: message2.text,
    wrap: message2.wrap === void 0 && autoWrap() || !!message2.wrap,
    type: LINETYPE.NOTE,
    placement
  });
};
const addLinks = function(actorId, text) {
  const actor = getActor(actorId);
  try {
    let sanitizedText = sanitizeText$5(text.text, getConfig$1());
    sanitizedText = sanitizedText.replace(/&amp;/g, "&");
    sanitizedText = sanitizedText.replace(/&equals;/g, "=");
    const links2 = JSON.parse(sanitizedText);
    insertLinks(actor, links2);
  } catch (e) {
    log$1.error("error while parsing actor link text", e);
  }
};
const addALink = function(actorId, text) {
  const actor = getActor(actorId);
  try {
    const links2 = {};
    let sanitizedText = sanitizeText$5(text.text, getConfig$1());
    var sep = sanitizedText.indexOf("@");
    sanitizedText = sanitizedText.replace(/&amp;/g, "&");
    sanitizedText = sanitizedText.replace(/&equals;/g, "=");
    var label = sanitizedText.slice(0, sep - 1).trim();
    var link = sanitizedText.slice(sep + 1).trim();
    links2[label] = link;
    insertLinks(actor, links2);
  } catch (e) {
    log$1.error("error while parsing actor link text", e);
  }
};
function insertLinks(actor, links2) {
  if (actor.links == null) {
    actor.links = links2;
  } else {
    for (let key in links2) {
      actor.links[key] = links2[key];
    }
  }
}
const addProperties = function(actorId, text) {
  const actor = getActor(actorId);
  try {
    let sanitizedText = sanitizeText$5(text.text, getConfig$1());
    const properties = JSON.parse(sanitizedText);
    insertProperties(actor, properties);
  } catch (e) {
    log$1.error("error while parsing actor properties text", e);
  }
};
function insertProperties(actor, properties) {
  if (actor.properties == null) {
    actor.properties = properties;
  } else {
    for (let key in properties) {
      actor.properties[key] = properties[key];
    }
  }
}
function boxEnd() {
  currentBox = void 0;
}
const addDetails = function(actorId, text) {
  const actor = getActor(actorId);
  const elem = document.getElementById(text.text);
  try {
    const text2 = elem.innerHTML;
    const details = JSON.parse(text2);
    if (details["properties"]) {
      insertProperties(actor, details["properties"]);
    }
    if (details["links"]) {
      insertLinks(actor, details["links"]);
    }
  } catch (e) {
    log$1.error("error while parsing actor details text", e);
  }
};
const getActorProperty = function(actor, key) {
  if (actor !== void 0 && actor.properties !== void 0) {
    return actor.properties[key];
  }
  return void 0;
};
const apply = function(param) {
  if (Array.isArray(param)) {
    param.forEach(function(item) {
      apply(item);
    });
  } else {
    switch (param.type) {
      case "sequenceIndex":
        messages.push({
          from: void 0,
          to: void 0,
          message: {
            start: param.sequenceIndex,
            step: param.sequenceIndexStep,
            visible: param.sequenceVisible
          },
          wrap: false,
          type: param.signalType
        });
        break;
      case "addParticipant":
        addActor(param.actor, param.actor, param.description, "participant");
        break;
      case "addActor":
        addActor(param.actor, param.actor, param.description, "actor");
        break;
      case "activeStart":
        addSignal(param.actor, void 0, void 0, param.signalType);
        break;
      case "activeEnd":
        addSignal(param.actor, void 0, void 0, param.signalType);
        break;
      case "addNote":
        addNote(param.actor, param.placement, param.text);
        break;
      case "addLinks":
        addLinks(param.actor, param.text);
        break;
      case "addALink":
        addALink(param.actor, param.text);
        break;
      case "addProperties":
        addProperties(param.actor, param.text);
        break;
      case "addDetails":
        addDetails(param.actor, param.text);
        break;
      case "addMessage":
        addSignal(param.from, param.to, param.msg, param.signalType);
        break;
      case "boxStart":
        addBox(param.boxData);
        break;
      case "boxEnd":
        boxEnd();
        break;
      case "loopStart":
        addSignal(void 0, void 0, param.loopText, param.signalType);
        break;
      case "loopEnd":
        addSignal(void 0, void 0, void 0, param.signalType);
        break;
      case "rectStart":
        addSignal(void 0, void 0, param.color, param.signalType);
        break;
      case "rectEnd":
        addSignal(void 0, void 0, void 0, param.signalType);
        break;
      case "optStart":
        addSignal(void 0, void 0, param.optText, param.signalType);
        break;
      case "optEnd":
        addSignal(void 0, void 0, void 0, param.signalType);
        break;
      case "altStart":
        addSignal(void 0, void 0, param.altText, param.signalType);
        break;
      case "else":
        addSignal(void 0, void 0, param.altText, param.signalType);
        break;
      case "altEnd":
        addSignal(void 0, void 0, void 0, param.signalType);
        break;
      case "setAccTitle":
        setAccTitle(param.text);
        break;
      case "parStart":
        addSignal(void 0, void 0, param.parText, param.signalType);
        break;
      case "and":
        addSignal(void 0, void 0, param.parText, param.signalType);
        break;
      case "parEnd":
        addSignal(void 0, void 0, void 0, param.signalType);
        break;
      case "criticalStart":
        addSignal(void 0, void 0, param.criticalText, param.signalType);
        break;
      case "option":
        addSignal(void 0, void 0, param.optionText, param.signalType);
        break;
      case "criticalEnd":
        addSignal(void 0, void 0, void 0, param.signalType);
        break;
      case "breakStart":
        addSignal(void 0, void 0, param.breakText, param.signalType);
        break;
      case "breakEnd":
        addSignal(void 0, void 0, void 0, param.signalType);
        break;
    }
  }
};
const sequenceDb = {
  addActor,
  addMessage,
  addSignal,
  addLinks,
  addDetails,
  addProperties,
  autoWrap,
  setWrap,
  enableSequenceNumbers,
  disableSequenceNumbers,
  showSequenceNumbers,
  getMessages,
  getActors: getActors$1,
  getActor,
  getActorKeys,
  getActorProperty,
  getAccTitle,
  getBoxes,
  getDiagramTitle,
  setDiagramTitle,
  parseDirective: parseDirective$2,
  getConfig: () => getConfig$1().sequence,
  clear: clear$2,
  parseMessage,
  parseBoxData,
  LINETYPE,
  ARROWTYPE,
  PLACEMENT,
  addNote,
  setAccTitle,
  apply,
  setAccDescription,
  getAccDescription,
  hasAtLeastOneBox,
  hasAtLeastOneBoxWithTitle
};
let interactionFunctions = [];
const addFunction = (func) => {
  interactionFunctions.push(func);
};
const attachFunctions = () => {
  interactionFunctions.forEach((f) => {
    f();
  });
  interactionFunctions = [];
};
const drawRect$1 = function(elem, rectData) {
  const rectElem = elem.append("rect");
  rectElem.attr("x", rectData.x);
  rectElem.attr("y", rectData.y);
  rectElem.attr("fill", rectData.fill);
  rectElem.attr("stroke", rectData.stroke);
  rectElem.attr("width", rectData.width);
  rectElem.attr("height", rectData.height);
  rectElem.attr("rx", rectData.rx);
  rectElem.attr("ry", rectData.ry);
  if (rectData.class !== void 0) {
    rectElem.attr("class", rectData.class);
  }
  return rectElem;
};
const addPopupInteraction = (id2, actorCnt2) => {
  addFunction(() => {
    const arr = document.querySelectorAll(id2);
    if (arr.length === 0) {
      return;
    }
    arr[0].addEventListener("mouseover", function() {
      popupMenuUpFunc("actor" + actorCnt2 + "_popup");
    });
    arr[0].addEventListener("mouseout", function() {
      popupMenuDownFunc("actor" + actorCnt2 + "_popup");
    });
  });
};
const drawPopup = function(elem, actor, minMenuWidth, textAttrs, forceMenus) {
  if (actor.links === void 0 || actor.links === null || Object.keys(actor.links).length === 0) {
    return { height: 0, width: 0 };
  }
  const links2 = actor.links;
  const actorCnt2 = actor.actorCnt;
  const rectData = actor.rectData;
  var displayValue = "none";
  if (forceMenus) {
    displayValue = "block !important";
  }
  const g = elem.append("g");
  g.attr("id", "actor" + actorCnt2 + "_popup");
  g.attr("class", "actorPopupMenu");
  g.attr("display", displayValue);
  addPopupInteraction("#actor" + actorCnt2 + "_popup", actorCnt2);
  var actorClass = "";
  if (rectData.class !== void 0) {
    actorClass = " " + rectData.class;
  }
  let menuWidth = rectData.width > minMenuWidth ? rectData.width : minMenuWidth;
  const rectElem = g.append("rect");
  rectElem.attr("class", "actorPopupMenuPanel" + actorClass);
  rectElem.attr("x", rectData.x);
  rectElem.attr("y", rectData.height);
  rectElem.attr("fill", rectData.fill);
  rectElem.attr("stroke", rectData.stroke);
  rectElem.attr("width", menuWidth);
  rectElem.attr("height", rectData.height);
  rectElem.attr("rx", rectData.rx);
  rectElem.attr("ry", rectData.ry);
  if (links2 != null) {
    var linkY = 20;
    for (let key in links2) {
      var linkElem = g.append("a");
      var sanitizedLink = sanitizeUrl(links2[key]);
      linkElem.attr("xlink:href", sanitizedLink);
      linkElem.attr("target", "_blank");
      _drawMenuItemTextCandidateFunc(textAttrs)(
        key,
        linkElem,
        rectData.x + 10,
        rectData.height + linkY,
        menuWidth,
        20,
        { class: "actor" },
        textAttrs
      );
      linkY += 30;
    }
  }
  rectElem.attr("height", linkY);
  return { height: rectData.height + linkY, width: menuWidth };
};
const drawImage = function(elem, x, y, link) {
  const imageElem = elem.append("image");
  imageElem.attr("x", x);
  imageElem.attr("y", y);
  var sanitizedLink = sanitizeUrl(link);
  imageElem.attr("xlink:href", sanitizedLink);
};
const drawEmbeddedImage = function(elem, x, y, link) {
  const imageElem = elem.append("use");
  imageElem.attr("x", x);
  imageElem.attr("y", y);
  var sanitizedLink = sanitizeUrl(link);
  imageElem.attr("xlink:href", "#" + sanitizedLink);
};
const popupMenu = function(popid) {
  return "var pu = document.getElementById('" + popid + "'); if (pu != null) { pu.style.display = 'block'; }";
};
const popdownMenu = function(popid) {
  return "var pu = document.getElementById('" + popid + "'); if (pu != null) { pu.style.display = 'none'; }";
};
const popupMenuUpFunc = function(popupId) {
  var pu = document.getElementById(popupId);
  if (pu != null) {
    pu.style.display = "block";
  }
};
const popupMenuDownFunc = function(popupId) {
  var pu = document.getElementById(popupId);
  if (pu != null) {
    pu.style.display = "none";
  }
};
const drawText$1 = function(elem, textData) {
  let prevTextHeight = 0, textHeight = 0;
  const lines = textData.text.split(common$1.lineBreakRegex);
  const [_textFontSize, _textFontSizePx] = parseFontSize(textData.fontSize);
  let textElems = [];
  let dy = 0;
  let yfunc = () => textData.y;
  if (textData.valign !== void 0 && textData.textMargin !== void 0 && textData.textMargin > 0) {
    switch (textData.valign) {
      case "top":
      case "start":
        yfunc = () => Math.round(textData.y + textData.textMargin);
        break;
      case "middle":
      case "center":
        yfunc = () => Math.round(textData.y + (prevTextHeight + textHeight + textData.textMargin) / 2);
        break;
      case "bottom":
      case "end":
        yfunc = () => Math.round(
          textData.y + (prevTextHeight + textHeight + 2 * textData.textMargin) - textData.textMargin
        );
        break;
    }
  }
  if (textData.anchor !== void 0 && textData.textMargin !== void 0 && textData.width !== void 0) {
    switch (textData.anchor) {
      case "left":
      case "start":
        textData.x = Math.round(textData.x + textData.textMargin);
        textData.anchor = "start";
        textData.dominantBaseline = "middle";
        textData.alignmentBaseline = "middle";
        break;
      case "middle":
      case "center":
        textData.x = Math.round(textData.x + textData.width / 2);
        textData.anchor = "middle";
        textData.dominantBaseline = "middle";
        textData.alignmentBaseline = "middle";
        break;
      case "right":
      case "end":
        textData.x = Math.round(textData.x + textData.width - textData.textMargin);
        textData.anchor = "end";
        textData.dominantBaseline = "middle";
        textData.alignmentBaseline = "middle";
        break;
    }
  }
  for (let [i, line2] of lines.entries()) {
    if (textData.textMargin !== void 0 && textData.textMargin === 0 && _textFontSize !== void 0) {
      dy = i * _textFontSize;
    }
    const textElem = elem.append("text");
    textElem.attr("x", textData.x);
    textElem.attr("y", yfunc());
    if (textData.anchor !== void 0) {
      textElem.attr("text-anchor", textData.anchor).attr("dominant-baseline", textData.dominantBaseline).attr("alignment-baseline", textData.alignmentBaseline);
    }
    if (textData.fontFamily !== void 0) {
      textElem.style("font-family", textData.fontFamily);
    }
    if (_textFontSizePx !== void 0) {
      textElem.style("font-size", _textFontSizePx);
    }
    if (textData.fontWeight !== void 0) {
      textElem.style("font-weight", textData.fontWeight);
    }
    if (textData.fill !== void 0) {
      textElem.attr("fill", textData.fill);
    }
    if (textData.class !== void 0) {
      textElem.attr("class", textData.class);
    }
    if (textData.dy !== void 0) {
      textElem.attr("dy", textData.dy);
    } else if (dy !== 0) {
      textElem.attr("dy", dy);
    }
    if (textData.tspan) {
      const span = textElem.append("tspan");
      span.attr("x", textData.x);
      if (textData.fill !== void 0) {
        span.attr("fill", textData.fill);
      }
      span.text(line2);
    } else {
      textElem.text(line2);
    }
    if (textData.valign !== void 0 && textData.textMargin !== void 0 && textData.textMargin > 0) {
      textHeight += (textElem._groups || textElem)[0][0].getBBox().height;
      prevTextHeight = textHeight;
    }
    textElems.push(textElem);
  }
  return textElems;
};
const drawLabel$1 = function(elem, txtObject) {
  function genPoints(x, y, width2, height2, cut) {
    return x + "," + y + " " + (x + width2) + "," + y + " " + (x + width2) + "," + (y + height2 - cut) + " " + (x + width2 - cut * 1.2) + "," + (y + height2) + " " + x + "," + (y + height2);
  }
  const polygon = elem.append("polygon");
  polygon.attr("points", genPoints(txtObject.x, txtObject.y, txtObject.width, txtObject.height, 7));
  polygon.attr("class", "labelBox");
  txtObject.y = txtObject.y + txtObject.height / 2;
  drawText$1(elem, txtObject);
  return polygon;
};
let actorCnt = -1;
const fixLifeLineHeights = (diagram, bounds2) => {
  if (!diagram.selectAll) {
    return;
  }
  diagram.selectAll(".actor-line").attr("class", "200").attr("y2", bounds2 - 55);
};
const drawActorTypeParticipant = function(elem, actor, conf2, isFooter) {
  const center = actor.x + actor.width / 2;
  const centerY = actor.y + 5;
  const boxpluslineGroup = elem.append("g");
  var g = boxpluslineGroup;
  if (!isFooter) {
    actorCnt++;
    g.append("line").attr("id", "actor" + actorCnt).attr("x1", center).attr("y1", centerY).attr("x2", center).attr("y2", 2e3).attr("class", "actor-line").attr("stroke-width", "0.5px").attr("stroke", "#999");
    g = boxpluslineGroup.append("g");
    actor.actorCnt = actorCnt;
    if (actor.links != null) {
      g.attr("id", "root-" + actorCnt);
      addPopupInteraction("#root-" + actorCnt, actorCnt);
    }
  }
  const rect2 = getNoteRect$1();
  var cssclass = "actor";
  if (actor.properties != null && actor.properties["class"]) {
    cssclass = actor.properties["class"];
  } else {
    rect2.fill = "#eaeaea";
  }
  rect2.x = actor.x;
  rect2.y = actor.y;
  rect2.width = actor.width;
  rect2.height = actor.height;
  rect2.class = cssclass;
  rect2.rx = 3;
  rect2.ry = 3;
  const rectElem = drawRect$1(g, rect2);
  actor.rectData = rect2;
  if (actor.properties != null && actor.properties["icon"]) {
    const iconSrc = actor.properties["icon"].trim();
    if (iconSrc.charAt(0) === "@") {
      drawEmbeddedImage(g, rect2.x + rect2.width - 20, rect2.y + 10, iconSrc.substr(1));
    } else {
      drawImage(g, rect2.x + rect2.width - 20, rect2.y + 10, iconSrc);
    }
  }
  _drawTextCandidateFunc$1(conf2)(
    actor.description,
    g,
    rect2.x,
    rect2.y,
    rect2.width,
    rect2.height,
    { class: "actor" },
    conf2
  );
  let height2 = actor.height;
  if (rectElem.node) {
    const bounds2 = rectElem.node().getBBox();
    actor.height = bounds2.height;
    height2 = bounds2.height;
  }
  return height2;
};
const drawActorTypeActor = function(elem, actor, conf2, isFooter) {
  const center = actor.x + actor.width / 2;
  const centerY = actor.y + 80;
  if (!isFooter) {
    actorCnt++;
    elem.append("line").attr("id", "actor" + actorCnt).attr("x1", center).attr("y1", centerY).attr("x2", center).attr("y2", 2e3).attr("class", "actor-line").attr("stroke-width", "0.5px").attr("stroke", "#999");
  }
  const actElem = elem.append("g");
  actElem.attr("class", "actor-man");
  const rect2 = getNoteRect$1();
  rect2.x = actor.x;
  rect2.y = actor.y;
  rect2.fill = "#eaeaea";
  rect2.width = actor.width;
  rect2.height = actor.height;
  rect2.class = "actor";
  rect2.rx = 3;
  rect2.ry = 3;
  actElem.append("line").attr("id", "actor-man-torso" + actorCnt).attr("x1", center).attr("y1", actor.y + 25).attr("x2", center).attr("y2", actor.y + 45);
  actElem.append("line").attr("id", "actor-man-arms" + actorCnt).attr("x1", center - 18).attr("y1", actor.y + 33).attr("x2", center + 18).attr("y2", actor.y + 33);
  actElem.append("line").attr("x1", center - 18).attr("y1", actor.y + 60).attr("x2", center).attr("y2", actor.y + 45);
  actElem.append("line").attr("x1", center).attr("y1", actor.y + 45).attr("x2", center + 16).attr("y2", actor.y + 60);
  const circle2 = actElem.append("circle");
  circle2.attr("cx", actor.x + actor.width / 2);
  circle2.attr("cy", actor.y + 10);
  circle2.attr("r", 15);
  circle2.attr("width", actor.width);
  circle2.attr("height", actor.height);
  const bounds2 = actElem.node().getBBox();
  actor.height = bounds2.height;
  _drawTextCandidateFunc$1(conf2)(
    actor.description,
    actElem,
    rect2.x,
    rect2.y + 35,
    rect2.width,
    rect2.height,
    { class: "actor" },
    conf2
  );
  return actor.height;
};
const drawActor = function(elem, actor, conf2, isFooter) {
  switch (actor.type) {
    case "actor":
      return drawActorTypeActor(elem, actor, conf2, isFooter);
    case "participant":
      return drawActorTypeParticipant(elem, actor, conf2, isFooter);
  }
};
const drawBox = function(elem, box, conf2) {
  const boxplustextGroup = elem.append("g");
  const g = boxplustextGroup;
  drawBackgroundRect$1(g, box);
  if (box.name) {
    _drawTextCandidateFunc$1(conf2)(
      box.name,
      g,
      box.x,
      box.y + (box.textMaxHeight || 0) / 2,
      box.width,
      0,
      { class: "text" },
      conf2
    );
  }
  g.lower();
};
const anchorElement = function(elem) {
  return elem.append("g");
};
const drawActivation = function(elem, bounds2, verticalPos, conf2, actorActivations2) {
  const rect2 = getNoteRect$1();
  const g = bounds2.anchored;
  rect2.x = bounds2.startx;
  rect2.y = bounds2.starty;
  rect2.class = "activation" + actorActivations2 % 3;
  rect2.width = bounds2.stopx - bounds2.startx;
  rect2.height = verticalPos - bounds2.starty;
  drawRect$1(g, rect2);
};
const drawLoop = function(elem, loopModel, labelText, conf2) {
  const {
    boxMargin,
    boxTextMargin,
    labelBoxHeight,
    labelBoxWidth,
    messageFontFamily: fontFamily,
    messageFontSize: fontSize,
    messageFontWeight: fontWeight
  } = conf2;
  const g = elem.append("g");
  const drawLoopLine = function(startx, starty, stopx, stopy) {
    return g.append("line").attr("x1", startx).attr("y1", starty).attr("x2", stopx).attr("y2", stopy).attr("class", "loopLine");
  };
  drawLoopLine(loopModel.startx, loopModel.starty, loopModel.stopx, loopModel.starty);
  drawLoopLine(loopModel.stopx, loopModel.starty, loopModel.stopx, loopModel.stopy);
  drawLoopLine(loopModel.startx, loopModel.stopy, loopModel.stopx, loopModel.stopy);
  drawLoopLine(loopModel.startx, loopModel.starty, loopModel.startx, loopModel.stopy);
  if (loopModel.sections !== void 0) {
    loopModel.sections.forEach(function(item) {
      drawLoopLine(loopModel.startx, item.y, loopModel.stopx, item.y).style(
        "stroke-dasharray",
        "3, 3"
      );
    });
  }
  let txt = getTextObj$1();
  txt.text = labelText;
  txt.x = loopModel.startx;
  txt.y = loopModel.starty;
  txt.fontFamily = fontFamily;
  txt.fontSize = fontSize;
  txt.fontWeight = fontWeight;
  txt.anchor = "middle";
  txt.valign = "middle";
  txt.tspan = false;
  txt.width = labelBoxWidth || 50;
  txt.height = labelBoxHeight || 20;
  txt.textMargin = boxTextMargin;
  txt.class = "labelText";
  drawLabel$1(g, txt);
  txt = getTextObj$1();
  txt.text = loopModel.title;
  txt.x = loopModel.startx + labelBoxWidth / 2 + (loopModel.stopx - loopModel.startx) / 2;
  txt.y = loopModel.starty + boxMargin + boxTextMargin;
  txt.anchor = "middle";
  txt.valign = "middle";
  txt.textMargin = boxTextMargin;
  txt.class = "loopText";
  txt.fontFamily = fontFamily;
  txt.fontSize = fontSize;
  txt.fontWeight = fontWeight;
  txt.wrap = true;
  let textElem = drawText$1(g, txt);
  if (loopModel.sectionTitles !== void 0) {
    loopModel.sectionTitles.forEach(function(item, idx) {
      if (item.message) {
        txt.text = item.message;
        txt.x = loopModel.startx + (loopModel.stopx - loopModel.startx) / 2;
        txt.y = loopModel.sections[idx].y + boxMargin + boxTextMargin;
        txt.class = "loopText";
        txt.anchor = "middle";
        txt.valign = "middle";
        txt.tspan = false;
        txt.fontFamily = fontFamily;
        txt.fontSize = fontSize;
        txt.fontWeight = fontWeight;
        txt.wrap = loopModel.wrap;
        textElem = drawText$1(g, txt);
        let sectionHeight = Math.round(
          textElem.map((te) => (te._groups || te)[0][0].getBBox().height).reduce((acc, curr) => acc + curr)
        );
        loopModel.sections[idx].height += sectionHeight - (boxMargin + boxTextMargin);
      }
    });
  }
  loopModel.height = Math.round(loopModel.stopy - loopModel.starty);
  return g;
};
const drawBackgroundRect$1 = function(elem, bounds2) {
  const rectElem = drawRect$1(elem, {
    x: bounds2.startx,
    y: bounds2.starty,
    width: bounds2.stopx - bounds2.startx,
    height: bounds2.stopy - bounds2.starty,
    fill: bounds2.fill,
    stroke: bounds2.stroke,
    class: "rect"
  });
  rectElem.lower();
};
const insertDatabaseIcon = function(elem) {
  elem.append("defs").append("symbol").attr("id", "database").attr("fill-rule", "evenodd").attr("clip-rule", "evenodd").append("path").attr("transform", "scale(.5)").attr(
    "d",
    "M12.258.001l.256.004.255.005.253.008.251.01.249.012.247.015.246.016.242.019.241.02.239.023.236.024.233.027.231.028.229.031.225.032.223.034.22.036.217.038.214.04.211.041.208.043.205.045.201.046.198.048.194.05.191.051.187.053.183.054.18.056.175.057.172.059.168.06.163.061.16.063.155.064.15.066.074.033.073.033.071.034.07.034.069.035.068.035.067.035.066.035.064.036.064.036.062.036.06.036.06.037.058.037.058.037.055.038.055.038.053.038.052.038.051.039.05.039.048.039.047.039.045.04.044.04.043.04.041.04.04.041.039.041.037.041.036.041.034.041.033.042.032.042.03.042.029.042.027.042.026.043.024.043.023.043.021.043.02.043.018.044.017.043.015.044.013.044.012.044.011.045.009.044.007.045.006.045.004.045.002.045.001.045v17l-.001.045-.002.045-.004.045-.006.045-.007.045-.009.044-.011.045-.012.044-.013.044-.015.044-.017.043-.018.044-.02.043-.021.043-.023.043-.024.043-.026.043-.027.042-.029.042-.03.042-.032.042-.033.042-.034.041-.036.041-.037.041-.039.041-.04.041-.041.04-.043.04-.044.04-.045.04-.047.039-.048.039-.05.039-.051.039-.052.038-.053.038-.055.038-.055.038-.058.037-.058.037-.06.037-.06.036-.062.036-.064.036-.064.036-.066.035-.067.035-.068.035-.069.035-.07.034-.071.034-.073.033-.074.033-.15.066-.155.064-.16.063-.163.061-.168.06-.172.059-.175.057-.18.056-.183.054-.187.053-.191.051-.194.05-.198.048-.201.046-.205.045-.208.043-.211.041-.214.04-.217.038-.22.036-.223.034-.225.032-.229.031-.231.028-.233.027-.236.024-.239.023-.241.02-.242.019-.246.016-.247.015-.249.012-.251.01-.253.008-.255.005-.256.004-.258.001-.258-.001-.256-.004-.255-.005-.253-.008-.251-.01-.249-.012-.247-.015-.245-.016-.243-.019-.241-.02-.238-.023-.236-.024-.234-.027-.231-.028-.228-.031-.226-.032-.223-.034-.22-.036-.217-.038-.214-.04-.211-.041-.208-.043-.204-.045-.201-.046-.198-.048-.195-.05-.19-.051-.187-.053-.184-.054-.179-.056-.176-.057-.172-.059-.167-.06-.164-.061-.159-.063-.155-.064-.151-.066-.074-.033-.072-.033-.072-.034-.07-.034-.069-.035-.068-.035-.067-.035-.066-.035-.064-.036-.063-.036-.062-.036-.061-.036-.06-.037-.058-.037-.057-.037-.056-.038-.055-.038-.053-.038-.052-.038-.051-.039-.049-.039-.049-.039-.046-.039-.046-.04-.044-.04-.043-.04-.041-.04-.04-.041-.039-.041-.037-.041-.036-.041-.034-.041-.033-.042-.032-.042-.03-.042-.029-.042-.027-.042-.026-.043-.024-.043-.023-.043-.021-.043-.02-.043-.018-.044-.017-.043-.015-.044-.013-.044-.012-.044-.011-.045-.009-.044-.007-.045-.006-.045-.004-.045-.002-.045-.001-.045v-17l.001-.045.002-.045.004-.045.006-.045.007-.045.009-.044.011-.045.012-.044.013-.044.015-.044.017-.043.018-.044.02-.043.021-.043.023-.043.024-.043.026-.043.027-.042.029-.042.03-.042.032-.042.033-.042.034-.041.036-.041.037-.041.039-.041.04-.041.041-.04.043-.04.044-.04.046-.04.046-.039.049-.039.049-.039.051-.039.052-.038.053-.038.055-.038.056-.038.057-.037.058-.037.06-.037.061-.036.062-.036.063-.036.064-.036.066-.035.067-.035.068-.035.069-.035.07-.034.072-.034.072-.033.074-.033.151-.066.155-.064.159-.063.164-.061.167-.06.172-.059.176-.057.179-.056.184-.054.187-.053.19-.051.195-.05.198-.048.201-.046.204-.045.208-.043.211-.041.214-.04.217-.038.22-.036.223-.034.226-.032.228-.031.231-.028.234-.027.236-.024.238-.023.241-.02.243-.019.245-.016.247-.015.249-.012.251-.01.253-.008.255-.005.256-.004.258-.001.258.001zm-9.258 20.499v.01l.001.021.003.021.004.022.005.021.006.022.007.022.009.023.01.022.011.023.012.023.013.023.015.023.016.024.017.023.018.024.019.024.021.024.022.025.023.024.024.025.052.049.056.05.061.051.066.051.07.051.075.051.079.052.084.052.088.052.092.052.097.052.102.051.105.052.11.052.114.051.119.051.123.051.127.05.131.05.135.05.139.048.144.049.147.047.152.047.155.047.16.045.163.045.167.043.171.043.176.041.178.041.183.039.187.039.19.037.194.035.197.035.202.033.204.031.209.03.212.029.216.027.219.025.222.024.226.021.23.02.233.018.236.016.24.015.243.012.246.01.249.008.253.005.256.004.259.001.26-.001.257-.004.254-.005.25-.008.247-.011.244-.012.241-.014.237-.016.233-.018.231-.021.226-.021.224-.024.22-.026.216-.027.212-.028.21-.031.205-.031.202-.034.198-.034.194-.036.191-.037.187-.039.183-.04.179-.04.175-.042.172-.043.168-.044.163-.045.16-.046.155-.046.152-.047.148-.048.143-.049.139-.049.136-.05.131-.05.126-.05.123-.051.118-.052.114-.051.11-.052.106-.052.101-.052.096-.052.092-.052.088-.053.083-.051.079-.052.074-.052.07-.051.065-.051.06-.051.056-.05.051-.05.023-.024.023-.025.021-.024.02-.024.019-.024.018-.024.017-.024.015-.023.014-.024.013-.023.012-.023.01-.023.01-.022.008-.022.006-.022.006-.022.004-.022.004-.021.001-.021.001-.021v-4.127l-.077.055-.08.053-.083.054-.085.053-.087.052-.09.052-.093.051-.095.05-.097.05-.1.049-.102.049-.105.048-.106.047-.109.047-.111.046-.114.045-.115.045-.118.044-.12.043-.122.042-.124.042-.126.041-.128.04-.13.04-.132.038-.134.038-.135.037-.138.037-.139.035-.142.035-.143.034-.144.033-.147.032-.148.031-.15.03-.151.03-.153.029-.154.027-.156.027-.158.026-.159.025-.161.024-.162.023-.163.022-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.011-.178.01-.179.008-.179.008-.181.006-.182.005-.182.004-.184.003-.184.002h-.37l-.184-.002-.184-.003-.182-.004-.182-.005-.181-.006-.179-.008-.179-.008-.178-.01-.176-.011-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.022-.162-.023-.161-.024-.159-.025-.157-.026-.156-.027-.155-.027-.153-.029-.151-.03-.15-.03-.148-.031-.146-.032-.145-.033-.143-.034-.141-.035-.14-.035-.137-.037-.136-.037-.134-.038-.132-.038-.13-.04-.128-.04-.126-.041-.124-.042-.122-.042-.12-.044-.117-.043-.116-.045-.113-.045-.112-.046-.109-.047-.106-.047-.105-.048-.102-.049-.1-.049-.097-.05-.095-.05-.093-.052-.09-.051-.087-.052-.085-.053-.083-.054-.08-.054-.077-.054v4.127zm0-5.654v.011l.001.021.003.021.004.021.005.022.006.022.007.022.009.022.01.022.011.023.012.023.013.023.015.024.016.023.017.024.018.024.019.024.021.024.022.024.023.025.024.024.052.05.056.05.061.05.066.051.07.051.075.052.079.051.084.052.088.052.092.052.097.052.102.052.105.052.11.051.114.051.119.052.123.05.127.051.131.05.135.049.139.049.144.048.147.048.152.047.155.046.16.045.163.045.167.044.171.042.176.042.178.04.183.04.187.038.19.037.194.036.197.034.202.033.204.032.209.03.212.028.216.027.219.025.222.024.226.022.23.02.233.018.236.016.24.014.243.012.246.01.249.008.253.006.256.003.259.001.26-.001.257-.003.254-.006.25-.008.247-.01.244-.012.241-.015.237-.016.233-.018.231-.02.226-.022.224-.024.22-.025.216-.027.212-.029.21-.03.205-.032.202-.033.198-.035.194-.036.191-.037.187-.039.183-.039.179-.041.175-.042.172-.043.168-.044.163-.045.16-.045.155-.047.152-.047.148-.048.143-.048.139-.05.136-.049.131-.05.126-.051.123-.051.118-.051.114-.052.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.051.07-.052.065-.051.06-.05.056-.051.051-.049.023-.025.023-.024.021-.025.02-.024.019-.024.018-.024.017-.024.015-.023.014-.023.013-.024.012-.022.01-.023.01-.023.008-.022.006-.022.006-.022.004-.021.004-.022.001-.021.001-.021v-4.139l-.077.054-.08.054-.083.054-.085.052-.087.053-.09.051-.093.051-.095.051-.097.05-.1.049-.102.049-.105.048-.106.047-.109.047-.111.046-.114.045-.115.044-.118.044-.12.044-.122.042-.124.042-.126.041-.128.04-.13.039-.132.039-.134.038-.135.037-.138.036-.139.036-.142.035-.143.033-.144.033-.147.033-.148.031-.15.03-.151.03-.153.028-.154.028-.156.027-.158.026-.159.025-.161.024-.162.023-.163.022-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.011-.178.009-.179.009-.179.007-.181.007-.182.005-.182.004-.184.003-.184.002h-.37l-.184-.002-.184-.003-.182-.004-.182-.005-.181-.007-.179-.007-.179-.009-.178-.009-.176-.011-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.022-.162-.023-.161-.024-.159-.025-.157-.026-.156-.027-.155-.028-.153-.028-.151-.03-.15-.03-.148-.031-.146-.033-.145-.033-.143-.033-.141-.035-.14-.036-.137-.036-.136-.037-.134-.038-.132-.039-.13-.039-.128-.04-.126-.041-.124-.042-.122-.043-.12-.043-.117-.044-.116-.044-.113-.046-.112-.046-.109-.046-.106-.047-.105-.048-.102-.049-.1-.049-.097-.05-.095-.051-.093-.051-.09-.051-.087-.053-.085-.052-.083-.054-.08-.054-.077-.054v4.139zm0-5.666v.011l.001.02.003.022.004.021.005.022.006.021.007.022.009.023.01.022.011.023.012.023.013.023.015.023.016.024.017.024.018.023.019.024.021.025.022.024.023.024.024.025.052.05.056.05.061.05.066.051.07.051.075.052.079.051.084.052.088.052.092.052.097.052.102.052.105.051.11.052.114.051.119.051.123.051.127.05.131.05.135.05.139.049.144.048.147.048.152.047.155.046.16.045.163.045.167.043.171.043.176.042.178.04.183.04.187.038.19.037.194.036.197.034.202.033.204.032.209.03.212.028.216.027.219.025.222.024.226.021.23.02.233.018.236.017.24.014.243.012.246.01.249.008.253.006.256.003.259.001.26-.001.257-.003.254-.006.25-.008.247-.01.244-.013.241-.014.237-.016.233-.018.231-.02.226-.022.224-.024.22-.025.216-.027.212-.029.21-.03.205-.032.202-.033.198-.035.194-.036.191-.037.187-.039.183-.039.179-.041.175-.042.172-.043.168-.044.163-.045.16-.045.155-.047.152-.047.148-.048.143-.049.139-.049.136-.049.131-.051.126-.05.123-.051.118-.052.114-.051.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.052.07-.051.065-.051.06-.051.056-.05.051-.049.023-.025.023-.025.021-.024.02-.024.019-.024.018-.024.017-.024.015-.023.014-.024.013-.023.012-.023.01-.022.01-.023.008-.022.006-.022.006-.022.004-.022.004-.021.001-.021.001-.021v-4.153l-.077.054-.08.054-.083.053-.085.053-.087.053-.09.051-.093.051-.095.051-.097.05-.1.049-.102.048-.105.048-.106.048-.109.046-.111.046-.114.046-.115.044-.118.044-.12.043-.122.043-.124.042-.126.041-.128.04-.13.039-.132.039-.134.038-.135.037-.138.036-.139.036-.142.034-.143.034-.144.033-.147.032-.148.032-.15.03-.151.03-.153.028-.154.028-.156.027-.158.026-.159.024-.161.024-.162.023-.163.023-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.01-.178.01-.179.009-.179.007-.181.006-.182.006-.182.004-.184.003-.184.001-.185.001-.185-.001-.184-.001-.184-.003-.182-.004-.182-.006-.181-.006-.179-.007-.179-.009-.178-.01-.176-.01-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.023-.162-.023-.161-.024-.159-.024-.157-.026-.156-.027-.155-.028-.153-.028-.151-.03-.15-.03-.148-.032-.146-.032-.145-.033-.143-.034-.141-.034-.14-.036-.137-.036-.136-.037-.134-.038-.132-.039-.13-.039-.128-.041-.126-.041-.124-.041-.122-.043-.12-.043-.117-.044-.116-.044-.113-.046-.112-.046-.109-.046-.106-.048-.105-.048-.102-.048-.1-.05-.097-.049-.095-.051-.093-.051-.09-.052-.087-.052-.085-.053-.083-.053-.08-.054-.077-.054v4.153zm8.74-8.179l-.257.004-.254.005-.25.008-.247.011-.244.012-.241.014-.237.016-.233.018-.231.021-.226.022-.224.023-.22.026-.216.027-.212.028-.21.031-.205.032-.202.033-.198.034-.194.036-.191.038-.187.038-.183.04-.179.041-.175.042-.172.043-.168.043-.163.045-.16.046-.155.046-.152.048-.148.048-.143.048-.139.049-.136.05-.131.05-.126.051-.123.051-.118.051-.114.052-.11.052-.106.052-.101.052-.096.052-.092.052-.088.052-.083.052-.079.052-.074.051-.07.052-.065.051-.06.05-.056.05-.051.05-.023.025-.023.024-.021.024-.02.025-.019.024-.018.024-.017.023-.015.024-.014.023-.013.023-.012.023-.01.023-.01.022-.008.022-.006.023-.006.021-.004.022-.004.021-.001.021-.001.021.001.021.001.021.004.021.004.022.006.021.006.023.008.022.01.022.01.023.012.023.013.023.014.023.015.024.017.023.018.024.019.024.02.025.021.024.023.024.023.025.051.05.056.05.06.05.065.051.07.052.074.051.079.052.083.052.088.052.092.052.096.052.101.052.106.052.11.052.114.052.118.051.123.051.126.051.131.05.136.05.139.049.143.048.148.048.152.048.155.046.16.046.163.045.168.043.172.043.175.042.179.041.183.04.187.038.191.038.194.036.198.034.202.033.205.032.21.031.212.028.216.027.22.026.224.023.226.022.231.021.233.018.237.016.241.014.244.012.247.011.25.008.254.005.257.004.26.001.26-.001.257-.004.254-.005.25-.008.247-.011.244-.012.241-.014.237-.016.233-.018.231-.021.226-.022.224-.023.22-.026.216-.027.212-.028.21-.031.205-.032.202-.033.198-.034.194-.036.191-.038.187-.038.183-.04.179-.041.175-.042.172-.043.168-.043.163-.045.16-.046.155-.046.152-.048.148-.048.143-.048.139-.049.136-.05.131-.05.126-.051.123-.051.118-.051.114-.052.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.051.07-.052.065-.051.06-.05.056-.05.051-.05.023-.025.023-.024.021-.024.02-.025.019-.024.018-.024.017-.023.015-.024.014-.023.013-.023.012-.023.01-.023.01-.022.008-.022.006-.023.006-.021.004-.022.004-.021.001-.021.001-.021-.001-.021-.001-.021-.004-.021-.004-.022-.006-.021-.006-.023-.008-.022-.01-.022-.01-.023-.012-.023-.013-.023-.014-.023-.015-.024-.017-.023-.018-.024-.019-.024-.02-.025-.021-.024-.023-.024-.023-.025-.051-.05-.056-.05-.06-.05-.065-.051-.07-.052-.074-.051-.079-.052-.083-.052-.088-.052-.092-.052-.096-.052-.101-.052-.106-.052-.11-.052-.114-.052-.118-.051-.123-.051-.126-.051-.131-.05-.136-.05-.139-.049-.143-.048-.148-.048-.152-.048-.155-.046-.16-.046-.163-.045-.168-.043-.172-.043-.175-.042-.179-.041-.183-.04-.187-.038-.191-.038-.194-.036-.198-.034-.202-.033-.205-.032-.21-.031-.212-.028-.216-.027-.22-.026-.224-.023-.226-.022-.231-.021-.233-.018-.237-.016-.241-.014-.244-.012-.247-.011-.25-.008-.254-.005-.257-.004-.26-.001-.26.001z"
  );
};
const insertComputerIcon = function(elem) {
  elem.append("defs").append("symbol").attr("id", "computer").attr("width", "24").attr("height", "24").append("path").attr("transform", "scale(.5)").attr(
    "d",
    "M2 2v13h20v-13h-20zm18 11h-16v-9h16v9zm-10.228 6l.466-1h3.524l.467 1h-4.457zm14.228 3h-24l2-6h2.104l-1.33 4h18.45l-1.297-4h2.073l2 6zm-5-10h-14v-7h14v7z"
  );
};
const insertClockIcon = function(elem) {
  elem.append("defs").append("symbol").attr("id", "clock").attr("width", "24").attr("height", "24").append("path").attr("transform", "scale(.5)").attr(
    "d",
    "M12 2c5.514 0 10 4.486 10 10s-4.486 10-10 10-10-4.486-10-10 4.486-10 10-10zm0-2c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm5.848 12.459c.202.038.202.333.001.372-1.907.361-6.045 1.111-6.547 1.111-.719 0-1.301-.582-1.301-1.301 0-.512.77-5.447 1.125-7.445.034-.192.312-.181.343.014l.985 6.238 5.394 1.011z"
  );
};
const insertArrowHead = function(elem) {
  elem.append("defs").append("marker").attr("id", "arrowhead").attr("refX", 9).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 0 0 L 10 5 L 0 10 z");
};
const insertArrowFilledHead = function(elem) {
  elem.append("defs").append("marker").attr("id", "filled-head").attr("refX", 18).attr("refY", 7).attr("marke