### Changelog

All notable changes to this project will be documented in this file. Dates are displayed in UTC.

#### [v8.0.0](https://github.com/pahen/madge/compare/v7.0.0...v8.0.0)

- chore: edit test/output.sh comply with POSIX [`#391`](https://github.com/pahen/madge/pull/391)
- Update ts-graphviz@2.1.2 and typescript@5.4.4 [`#424`](https://github.com/pahen/madge/pull/424)
- Remove not required dep on precinct [`#421`](https://github.com/pahen/madge/pull/421)
- Cleanup README and remove Travis config [`#422`](https://github.com/pahen/madge/pull/422)
- Correct engine requirements [`#419`](https://github.com/pahen/madge/pull/419)
- Add tests for Vue [`#418`](https://github.com/pahen/madge/pull/418)
- Update to dependency-tree@11 [`#417`](https://github.com/pahen/madge/pull/417)
- Add empty TS config to fix the tests [`0163dc4`](https://github.com/pahen/madge/commit/0163dc469b3a52af423540ea75301d2f6e01b018)
- Add comment [`3a52fae`](https://github.com/pahen/madge/commit/3a52fae6cf4ad3018c3a8c43be4e361cbf4679ec)
- Remove integrated npm cache [`e25fa64`](https://github.com/pahen/madge/commit/e25fa6440631af238edafe02706f3a4616862ffa)

### [v7.0.0](https://github.com/pahen/madge/compare/v6.1.0...v7.0.0)

> 8 April 2024

- devDeps: release-it@^15.6.0-&gt;^16.2.1 [`#393`](https://github.com/pahen/madge/pull/393)
- ci: Run build & test scripts on GitHub Actions [`#394`](https://github.com/pahen/madge/pull/394)
- chore: bump and align dependencies; dedupe typescript [`#379`](https://github.com/pahen/madge/pull/379)
- Adding option to not print the circular file count [`#387`](https://github.com/pahen/madge/pull/387)
- Update README, explaining to how ignore typed imports on .tsx files [`#389`](https://github.com/pahen/madge/pull/389)
- docs: update README to include ignore dynamic imports FAQ [`#360`](https://github.com/pahen/madge/pull/360)
- docs: fix donate anchor [`#362`](https://github.com/pahen/madge/pull/362)
- Release 6.1.0 [`#378`](https://github.com/pahen/madge/pull/378)
- chore: check in package-lock.json [`2137846`](https://github.com/pahen/madge/commit/2137846544697e3cdad9fb9d3599875f241dcb3d)
- devDeps: release-it@^16.1.5-&gt;^16.2.1 [`1bcdc12`](https://github.com/pahen/madge/commit/1bcdc12093131b0a92fc9dc76a701cfccdf03867)
- ci: add build/test workflow for GitHub Actions [`fa34634`](https://github.com/pahen/madge/commit/fa34634e06116572d606e6035f7402a7d276ab6e)

#### [v6.1.0](https://github.com/pahen/madge/compare/v6.0.0...v6.1.0)

> 4 June 2023

- constrain and bump typescript versions [`#376`](https://github.com/pahen/madge/pull/376)
- Disable spinner when running in CI [`#356`](https://github.com/pahen/madge/pull/356)
- Remove deploy to NPM from Travis build [`#354`](https://github.com/pahen/madge/pull/354)
- feat: support for rankdir in CLI [`#311`](https://github.com/pahen/madge/pull/311)
- Move typescript to peer dependencies [`#350`](https://github.com/pahen/madge/pull/350)
- Release 6.0.0 [`#352`](https://github.com/pahen/madge/pull/352)
- Release 6.1.0 [`66bb0c3`](https://github.com/pahen/madge/commit/66bb0c30798b31557d239ca61b2a43ffa6f53fba)
- install and use ci-info [`c35da47`](https://github.com/pahen/madge/commit/c35da472e7352340209f4537d020b2702f9e67e7)
- remove ci-info and change isEnabled setting [`a771115`](https://github.com/pahen/madge/commit/a771115ce570c8ea8d4c3ca68300dcfa0b5759ea)

### [v6.0.0](https://github.com/pahen/madge/compare/v5.0.2...v6.0.0)

> 29 January 2023

- Handle collect tsconfig's extends fileds [`#349`](https://github.com/pahen/madge/pull/349)
- Update packages detective-* to latest [`#348`](https://github.com/pahen/madge/pull/348)
- chore: bump 'detective-typescript' package to allow newer TS versions [`#321`](https://github.com/pahen/madge/pull/321)
- Replace to ts-graphviz package [`#341`](https://github.com/pahen/madge/pull/341)
- chore: bump detective-postcss to v6 [`#319`](https://github.com/pahen/madge/pull/319)
- Drop support Node.js EOL versions(&lt;14) [`#342`](https://github.com/pahen/madge/pull/342)
- handle collect tsconfig's extends fileds [`#323`](https://github.com/pahen/madge/issues/323)
- Changed to depend on the ts-graphviz package [`9b9ae87`](https://github.com/pahen/madge/commit/9b9ae878622be4a58951c5fcb9d46cc0c44e4593)
- Release 6.0.0 [`2aa75b2`](https://github.com/pahen/madge/commit/2aa75b2aba279d02dd7cf7640a0fcd6236322228)
- update packages detective-* to latest [`60b6557`](https://github.com/pahen/madge/commit/60b6557efc5a1da04452dfc0f0b1a0281f9c8776)

#### [v5.0.2](https://github.com/pahen/madge/compare/v5.0.1...v5.0.2)

> 27 January 2023

- Add NPM task and docs for creating a release [`#346`](https://github.com/pahen/madge/pull/346)
- Fix broken link to Travis in README [`#345`](https://github.com/pahen/madge/pull/345)
- docs: fix subtrees typo in README [`#325`](https://github.com/pahen/madge/pull/325)
- minor typo in README.md [`#300`](https://github.com/pahen/madge/pull/300)
- Release 5.0.2 [`614d44d`](https://github.com/pahen/madge/commit/614d44d5f1ab3cc9e9875e67d1e46f4b971d660a)
- minor typos in README.md [`edc27c8`](https://github.com/pahen/madge/commit/edc27c85c5257df65184fd44c80549ffd0346360)
- minor type in README.md [`9f5514c`](https://github.com/pahen/madge/commit/9f5514c568aa1d3944a17c459daee93c2948e144)

#### [v5.0.1](https://github.com/pahen/madge/compare/v5.0.0...v5.0.1)

> 23 June 2021

- Fix issue with command line options stopped working [`512c2cb`](https://github.com/pahen/madge/commit/512c2cbfec1db53068e9b805e181ec1b38d30a41)
- Update README [`8e98136`](https://github.com/pahen/madge/commit/8e98136c5597f87acfa93cdae18c477cbf8a30da)

### [v5.0.0](https://github.com/pahen/madge/compare/v4.0.2...v5.0.0)

> 22 June 2021

- Improve Graphviz support detection [`#274`](https://github.com/pahen/madge/pull/274)
- Update list of donations [`aa49a0a`](https://github.com/pahen/madge/commit/aa49a0a94fd966be25141c92c75f97d90ad73dc6)
- Update deps [`820c9b8`](https://github.com/pahen/madge/commit/820c9b827b3ec1c51e454b0ce7ea6f2427f3b6da)

#### [v4.0.2](https://github.com/pahen/madge/compare/v4.0.1...v4.0.2)

> 8 March 2021

- Bump detective-typescript [`e6985d2`](https://github.com/pahen/madge/commit/e6985d25518ea48f816ee007d0bde519ce6a3106)

#### [v4.0.1](https://github.com/pahen/madge/compare/v4.0.0...v4.0.1)

> 5 March 2021

- Fix potential command injection vulnerability [`da5cbc9`](https://github.com/pahen/madge/commit/da5cbc9ab30372d687fa7c324b22af7ffa5c6332)

### [v4.0.0](https://github.com/pahen/madge/compare/v3.12.0...v4.0.0)

> 5 January 2021

- Upgrade dependencies & raise minimum Node.js version [`#269`](https://github.com/pahen/madge/pull/269)
- Upgrade core dependencies [`fe8a186`](https://github.com/pahen/madge/commit/fe8a186b18a08a6e6f69d49d95f156660f575851)
- Upgrade commander to version 6 [`5ca410c`](https://github.com/pahen/madge/commit/5ca410c4b4332c67a3104b7e851d0976be78de9e)
- Require Node.js 10.13 [`eee3dc0`](https://github.com/pahen/madge/commit/eee3dc0540ce3592fbbbada8586cf5b59e5ba33d)

#### [v3.12.0](https://github.com/pahen/madge/compare/v3.11.0...v3.12.0)

> 2 November 2020

- Remove pify again [`#264`](https://github.com/pahen/madge/pull/264)
- Update ora to version 5 [`#262`](https://github.com/pahen/madge/pull/262)
- Replace pify with util.promisify [`#263`](https://github.com/pahen/madge/pull/263)
- Update README [`e4be868`](https://github.com/pahen/madge/commit/e4be868c6c057be3799d8b8fd0c9fa928bbc9b80)
- Bump dependency-tree to 7.2.2 [`0eaccb7`](https://github.com/pahen/madge/commit/0eaccb728dbdcf36e67850fc89a552361c69a200)

#### [v3.11.0](https://github.com/pahen/madge/compare/v3.10.0...v3.11.0)

> 1 October 2020

- Add support for combining --circular and --dot [`d2ce3f7`](https://github.com/pahen/madge/commit/d2ce3f7ac0dec928eaee37ab8d768d291fa24f84)

#### [v3.10.0](https://github.com/pahen/madge/compare/v3.9.2...v3.10.0)

> 14 September 2020

- Add support for combining --image and --circular [`7a4bd3b`](https://github.com/pahen/madge/commit/7a4bd3be2fbefab3e9468272c912991602360562)

#### [v3.9.2](https://github.com/pahen/madge/compare/v3.9.1...v3.9.2)

> 16 June 2020

- Bump dependencies [`a8e3674`](https://github.com/pahen/madge/commit/a8e367464f5a4bc1586c4a21735691253406ddb4)
- Downgrade to ESLint 6.8.0 [`bc539af`](https://github.com/pahen/madge/commit/bc539afcda79291b5f694c0b8ab8423356f0d53e)

#### [v3.9.1](https://github.com/pahen/madge/compare/v3.9.0...v3.9.1)

> 8 June 2020

- chore: significant speedup by skipping filing-cabinet ts-config parsing [`#237`](https://github.com/pahen/madge/pull/237)
- Clarification for mixed projects (with JS and TS) [`#246`](https://github.com/pahen/madge/pull/246)

#### [v3.9.0](https://github.com/pahen/madge/compare/v3.8.0...v3.9.0)

> 7 May 2020

- Remove info about Patreon and Open Collective [`a57eeff`](https://github.com/pahen/madge/commit/a57eeffd27efdf18dbd3d5f941bb23a1aab18f48)
- Update list of backers [`545be08`](https://github.com/pahen/madge/commit/545be086dec854fd46024cf6a1f6df2c9d710d5e)
- Update dependencies [`ffa4fdd`](https://github.com/pahen/madge/commit/ffa4fdd64695b22002adaf2add100f1a3da028bc)

#### [v3.8.0](https://github.com/pahen/madge/compare/v3.7.0...v3.8.0)

> 9 March 2020

- Add `leaves` option to show modules that do not have dependencies [`97ed27f`](https://github.com/pahen/madge/commit/97ed27f846f3e53dc127c577e6667f5faf6a814b)
- Update README [`9c1f7d2`](https://github.com/pahen/madge/commit/9c1f7d2d9a23b42582caebd529cf73753a3226cc)
- Updated list of donations [`899f15f`](https://github.com/pahen/madge/commit/899f15f1d4b7673d0a7f35b74ae171517eaad5a9)

#### [v3.7.0](https://github.com/pahen/madge/compare/v3.6.0...v3.7.0)

> 30 January 2020

- feat: support package.json config [`#236`](https://github.com/pahen/madge/pull/236)
- review [`0acebb7`](https://github.com/pahen/madge/commit/0acebb7417ea17a0980630685ee4dfe182fbcdbb)
- Drop Node.js 8 support [`2cba3e1`](https://github.com/pahen/madge/commit/2cba3e1a93e45b74cf680119e3affffc0feaa695)
- Drop Node.JS 6 support [`ca3c555`](https://github.com/pahen/madge/commit/ca3c5553e72457d7f96fefa828ef03f6a1cbe0b8)

#### [v3.6.0](https://github.com/pahen/madge/compare/v3.5.1...v3.6.0)

> 11 November 2019

- Add test for TypeScript with mixed import syntax [`50c1c10`](https://github.com/pahen/madge/commit/50c1c10c1e7d369c5e7d1017463451f8d270cdf9)
- Update deps [`f1125d0`](https://github.com/pahen/madge/commit/f1125d0af5da27510f709a4b8a2e84b45ff5f578)

#### [v3.5.1](https://github.com/pahen/madge/compare/v3.5.0...v3.5.1)

> 7 November 2019

- Add funding to package.json [`8ee9126`](https://github.com/pahen/madge/commit/8ee91265973985eee08b873eff0e5104d48d4f61)

#### [v3.5.0](https://github.com/pahen/madge/compare/v3.4.4...v3.5.0)

> 28 October 2019

- Add an .svg public method to the API [`#171`](https://github.com/pahen/madge/pull/171)
- Respect graphVizOptions in DOT output [`4edf82a`](https://github.com/pahen/madge/commit/4edf82a3578639972229034aed4ebe1d51ae2bdf)
- Added credits to README [`9287c3c`](https://github.com/pahen/madge/commit/9287c3c1f1f51ffdb6c27a890c51f32f383b9c5c)
- Add .svg() in API to export the svg as a Buffer [`d01f6f3`](https://github.com/pahen/madge/commit/d01f6f33a67ecfb7072667b08f6c6550d52a5043)

#### [v3.4.4](https://github.com/pahen/madge/compare/v3.4.3...v3.4.4)

> 12 February 2019

- [Fixes #203] Exclude test folder from npm registry [`#205`](https://github.com/pahen/madge/pull/205)
- Merge pull request #205 from SethDavenport/chore(exclude-test-folder-from-npm) [`#203`](https://github.com/pahen/madge/issues/203)
- Add NPM releasing from Travis [`97f060b`](https://github.com/pahen/madge/commit/97f060b1b0f19c6d08b0fc53c24494df7fdd6cdc)
- Exclude test folder from npm registry [`41f94f2`](https://github.com/pahen/madge/commit/41f94f22f5521bde0523ec7df17fbdf43e587e33)

#### [v3.4.3](https://github.com/pahen/madge/compare/v3.4.2...v3.4.3)

> 17 January 2019

- Add link to my Patreon page in README [`9ee722a`](https://github.com/pahen/madge/commit/9ee722a8d4708f978042c17ffc172409470dfa86)
- Add info about --orphans to CLI docs [`925c57e`](https://github.com/pahen/madge/commit/925c57efcbe2357f49131e51050107e9ad54eab1)
- Bump dependency-tree [`c2ce2ac`](https://github.com/pahen/madge/commit/c2ce2ac17888c71aa020ac7da5277535ffaacdac)

#### [v3.4.2](https://github.com/pahen/madge/compare/v3.4.1...v3.4.2)

> 10 January 2019

- Eslint should not be a dev dependency [`3165988`](https://github.com/pahen/madge/commit/316598895e64bbca42654ae263422dba0d365772)

#### [v3.4.1](https://github.com/pahen/madge/compare/v3.4.0...v3.4.1)

> 10 January 2019

- Update eslint (peer dependency for typescript-eslint-parser) [`2e6643a`](https://github.com/pahen/madge/commit/2e6643af90b70cc055e37725942a2177f3e05bdd)

#### [v3.4.0](https://github.com/pahen/madge/compare/v3.3.0...v3.4.0)

> 7 January 2019

- Support .tsx files and specifying a tsconfig [`#193`](https://github.com/pahen/madge/pull/193)
- README: improve instructions related to Graphviz [`#183`](https://github.com/pahen/madge/pull/183)

#### [v3.3.0](https://github.com/pahen/madge/compare/v3.2.0...v3.3.0)

> 31 October 2018

- Update dependencies & test on Node.js 10 [`#176`](https://github.com/pahen/madge/pull/176)
- Add --no-spinner option [`b1ad3eb`](https://github.com/pahen/madge/commit/b1ad3eb5d878e31f1f87d99f6b3de713003079c1)
- Update dependencies [`9b1293e`](https://github.com/pahen/madge/commit/9b1293e4f7c990efd1e58cd9f069bdd3a6b36fb7)
- Update dev dependencies [`2260b61`](https://github.com/pahen/madge/commit/2260b613ecddb6f623584b82b1a30542b01c90e7)

#### [v3.2.0](https://github.com/pahen/madge/compare/v3.1.1...v3.2.0)

> 26 June 2018

- Plot nodes as boxes [`#165`](https://github.com/pahen/madge/pull/165)
- Document new graph settings [`c6e742f`](https://github.com/pahen/madge/commit/c6e742f97a065a452445702645ec06c1ea91ea07)
- aesthetic changes: plot rounded boxes, prefer left to right. [`7a7ed8c`](https://github.com/pahen/madge/commit/7a7ed8c2f9f4f189d0ba1372d30b06fef7e50cc4)
- fix incorrect hex. 5 -&gt; 6 digits. [`e8e330c`](https://github.com/pahen/madge/commit/e8e330c9f5b70c3d925ec1674c7d62253750196e)

#### [v3.1.1](https://github.com/pahen/madge/compare/v3.1.0...v3.1.1)

> 24 May 2018

#### [v3.1.0](https://github.com/pahen/madge/compare/v3.0.1...v3.1.0)

> 22 May 2018

- Bind all dependencies to latest version [`#161`](https://github.com/pahen/madge/pull/161)
- Update ora to version 2 [`#155`](https://github.com/pahen/madge/pull/155)
- Remove mz as a production dependency. Instead use pify for promisifying. [`#154`](https://github.com/pahen/madge/pull/154)
- Remove package-lock.json [`8fd1859`](https://github.com/pahen/madge/commit/8fd18595a9b8bf28f67c01795b3ed182eb2d4b8d)
- Bind all dependencies to latest version, It fixes security issue in rc =&gt; deep-extend library. And added .idea project files to gitignore [`147d431`](https://github.com/pahen/madge/commit/147d431e506dac03230fedb2cf12be5a11e79c7d)
- Use caret ranges for all dependencies [`b0e334a`](https://github.com/pahen/madge/commit/b0e334ac22059edcf3bee059ba075cd1b12da985)

#### [v3.0.1](https://github.com/pahen/madge/compare/v3.0.0...v3.0.1)

> 5 February 2018

- Fix broken link [`#149`](https://github.com/pahen/madge/pull/149)
- Update deps [`3ba103c`](https://github.com/pahen/madge/commit/3ba103c8afa978b9163e9958d3197b294f9a93ce)
- Fix issue with short CLI options not working properly [`f73704d`](https://github.com/pahen/madge/commit/f73704dc3bd88fbc6308f1799319825d10251505)

### [v3.0.0](https://github.com/pahen/madge/compare/v2.2.0...v3.0.0)

> 22 January 2018

- chore: upgrade dependency-tree to 6.0.0 to address warning [`#147`](https://github.com/pahen/madge/pull/147)
- Update dev-dependencies [`#144`](https://github.com/pahen/madge/pull/144)
- Use caret ranges for all dependencies [`#141`](https://github.com/pahen/madge/pull/141)
- Update chalk to 2.3.0 [`#140`](https://github.com/pahen/madge/pull/140)
- Updates dependencies (not dev-dependencies) [`#134`](https://github.com/pahen/madge/pull/134)
- deps: Update debug to fix security issue [`#130`](https://github.com/pahen/madge/pull/130)
- Regenerate package-lock.json [`5d26187`](https://github.com/pahen/madge/commit/5d261874f7471cf66898205b83c967401c050fd3)
- dependency-tree@5.11.1 [`c35174c`](https://github.com/pahen/madge/commit/c35174c39c58ed7a5cf4e9560c1d16407870c4ea)
- Updat eslint to 4.13.0 and @aptoma/eslint-config to 7.0.1. [`b184021`](https://github.com/pahen/madge/commit/b184021cf758eeffad2eb7f590e218c463e191dc)

#### [v2.2.0](https://github.com/pahen/madge/compare/v2.1.0...v2.2.0)

> 29 August 2017

#### [v2.1.0](https://github.com/pahen/madge/compare/v2.0.0...v2.1.0)

> 26 August 2017

- Support for TypeScript [`#124`](https://github.com/pahen/madge/pull/124)
- Add tests for TypeScript [`50eb3ca`](https://github.com/pahen/madge/commit/50eb3ca5a884ce7cf23118755b8ed13f2ccf01a1)
- Center badges in README [`5b981cd`](https://github.com/pahen/madge/commit/5b981cd637787241e119587207ef09a878650136)
- Create LICENSE [`741cd76`](https://github.com/pahen/madge/commit/741cd761d4d0358022fee20ad3312f5230708603)

### [v2.0.0](https://github.com/pahen/madge/compare/v1.6.0...v2.0.0)

> 15 July 2017

- Add —-orphans to show modules that no one is depending on [`#121`](https://github.com/pahen/madge/pull/121)
- Fix typo [`#119`](https://github.com/pahen/madge/pull/119)
- fix typo in `.image()` example [`#113`](https://github.com/pahen/madge/pull/113)
- Always include file extension [`b6cac48`](https://github.com/pahen/madge/commit/b6cac48c9162736a40e1f6b7aa9dd3a8d225d6da)
- Fix bug with --extensions not working [`fc4acce`](https://github.com/pahen/madge/commit/fc4acce1517514dc7e34e7a6fb569e83047251b4)
- Support for Less [`d2d4b96`](https://github.com/pahen/madge/commit/d2d4b96cd160b4bea3d24b8399100a0030158feb)

#### [v1.6.0](https://github.com/pahen/madge/compare/v1.5.0...v1.6.0)

> 8 February 2017

- Show CLI spinner with the currently processed file [`f57480a`](https://github.com/pahen/madge/commit/f57480aaaa4e70e9d9afcab78f425ee0ee6f5754)
- Add support for dependencyFilter function [`eac8591`](https://github.com/pahen/madge/commit/eac85914a69e8359aca3dd737ff1d6026419f79b)
- Add script for testing output [`e74df55`](https://github.com/pahen/madge/commit/e74df55c6a5d1f16eda3ef708b1f43bddb7a25d9)

#### [v1.5.0](https://github.com/pahen/madge/compare/v1.4.6...v1.5.0)

> 13 January 2017

- Tweak output colors and error messages [`60d59a6`](https://github.com/pahen/madge/commit/60d59a664dda42d98a4cd7f772afb9acbb38da70)
- Support running —circular with —-warning [`b8a0371`](https://github.com/pahen/madge/commit/b8a0371c2695dbd4afbade785b87e9be42182ca7)
- Update changelog [`fa7cc99`](https://github.com/pahen/madge/commit/fa7cc99a09cf4e1af9f9a6664dd57eda1f862fa0)

#### [v1.4.6](https://github.com/pahen/madge/compare/v1.4.5...v1.4.6)

> 9 January 2017

- Update circular dependency check output [`4ec6322`](https://github.com/pahen/madge/commit/4ec6322ec50b5e8bdd16fc0a697fd0f68e803ba7)
- Update changelog [`d718612`](https://github.com/pahen/madge/commit/d718612b0d00e3bf382a8042ce97aa76fa232de4)
- Bump dependency-tree [`3bc9689`](https://github.com/pahen/madge/commit/3bc9689c903b2431e0dee3e6796fa23b3bd7886f)

#### [v1.4.5](https://github.com/pahen/madge/compare/v1.4.4...v1.4.5)

> 7 January 2017

- Keep file extension in module paths until we output the graph [`bd980cf`](https://github.com/pahen/madge/commit/bd980cfdbafa1952607df442ca771e68d58a4757)
- Update changelog [`0492763`](https://github.com/pahen/madge/commit/04927633ce7223980dbbc4818e6e1fbb533737b3)

#### [v1.4.4](https://github.com/pahen/madge/compare/v1.4.3...v1.4.4)

> 4 January 2017

- Add tests for resolving using webpack resolve.root [`8452575`](https://github.com/pahen/madge/commit/8452575bb2ea567593ef1488e6148f96f82acd26)
- Update changelog [`13648c7`](https://github.com/pahen/madge/commit/13648c709886dfaf8bff1bd4fa24624d12d769ba)
- Bump dependencies [`c9b1795`](https://github.com/pahen/madge/commit/c9b17951afd7e9caeaa00cd5b61d4ebdd262a937)

#### [v1.4.3](https://github.com/pahen/madge/compare/v1.4.2...v1.4.3)

> 12 October 2016

- Fix bug with CLI —-require-config and --webpack-config not working [`386d710`](https://github.com/pahen/madge/commit/386d71055e263f04cc05779ebd259979c1415b7b)
- Update changelog [`cc4cb9e`](https://github.com/pahen/madge/commit/cc4cb9ea38f60341b1a57996a52036da1626f9a2)
- Update changelog [`97ba4c2`](https://github.com/pahen/madge/commit/97ba4c2cb78568766593fabbe89eec738ea4f65d)

#### [v1.4.2](https://github.com/pahen/madge/compare/v1.4.1...v1.4.2)

> 6 October 2016

- Rename —-show-skipped to —-warning [`a2d7c99`](https://github.com/pahen/madge/commit/a2d7c99d9b8e8c04e982a9505e1c95f682f22dc4)

#### [v1.4.1](https://github.com/pahen/madge/compare/v1.4.0...v1.4.1)

> 6 October 2016

- Don’t show warnings about skipped files by default [`2cfa8d7`](https://github.com/pahen/madge/commit/2cfa8d74d7fad3d85225523515a9c36addbe0b3a)

#### [v1.4.0](https://github.com/pahen/madge/compare/v1.3.2...v1.4.0)

> 6 October 2016

- Show skipped files as warnings (disable with —-no-warning) [`#108`](https://github.com/pahen/madge/pull/108)
- Update changelog [`4cb2c4c`](https://github.com/pahen/madge/commit/4cb2c4c806cfe87db8dabbc32920ac8f539e3dcc)

#### [v1.3.2](https://github.com/pahen/madge/compare/v1.3.1...v1.3.2)

> 3 October 2016

- Bump dependency-tree [`6fb76b2`](https://github.com/pahen/madge/commit/6fb76b2fe29a760b4652edf60724880f10518dda)

#### [v1.3.1](https://github.com/pahen/madge/compare/v1.3.0...v1.3.1)

> 1 October 2016

- Allow to pass options to detectives [`#105`](https://github.com/pahen/madge/pull/105)
- Bump dependency-tree to 5.7.0 [`d5c5de2`](https://github.com/pahen/madge/commit/d5c5de26c1c12f716d58fb0a780094ea939ed954)

#### [v1.3.0](https://github.com/pahen/madge/compare/v1.2.0...v1.3.0)

> 6 September 2016

- Improve performance on large codebase [`#104`](https://github.com/pahen/madge/pull/104)
- Cache paths when converting tree for better performance [`fc67d00`](https://github.com/pahen/madge/commit/fc67d0060d3050357f161cf5a86973a53b82910c)
- Rename commonjs to cjs [`8c56037`](https://github.com/pahen/madge/commit/8c56037570f53ed0c0560fcff391efe05227dc1b)
- Remove unnecessary mapping of CLI args to config [`93f19da`](https://github.com/pahen/madge/commit/93f19da023ff3ddfd52b89854272555640b3104e)

#### [v1.2.0](https://github.com/pahen/madge/compare/v1.1.0...v1.2.0)

> 1 September 2016

- Add option —-stdin for piping predefined tree [`#103`](https://github.com/pahen/madge/pull/103)
- Cleanup in tests [`75dce71`](https://github.com/pahen/madge/commit/75dce7194059337163632f284e78c6e4dd795883)
- Add missing test file [`1ce0c01`](https://github.com/pahen/madge/commit/1ce0c015269b56f32994621226753579ddac2c64)

#### [v1.1.0](https://github.com/pahen/madge/compare/v1.0.0...v1.1.0)

> 23 August 2016

- Fix failing tests on Windows [`#98`](https://github.com/pahen/madge/pull/98)
- Support for setting custom GraphViz options. Fixes #94 [`#94`](https://github.com/pahen/madge/issues/94)
- Replace parsers with dependency-tree module [`4be7db2`](https://github.com/pahen/madge/commit/4be7db2f096c6695ac1b8eacfd0095c5fa7ac7fb)
- Use promises in API [`dbad4b6`](https://github.com/pahen/madge/commit/dbad4b6ba89a05168be8eb702340f9887e1bf46a)
- Move tree generation to tree.js and add support folders [`07a36ed`](https://github.com/pahen/madge/commit/07a36edb65d84a84096ef3bb7228f4b9448df37d)

### [v1.0.0](https://github.com/pahen/madge/compare/0.6.0...v1.0.0)

> 19 August 2016

- Version 1.0 [`#96`](https://github.com/pahen/madge/pull/96)

#### [0.6.0](https://github.com/pahen/madge/compare/0.5.5...0.6.0)

> 6 July 2016

- Convert classes to ES6. [`8134400`](https://github.com/pahen/madge/commit/8134400915e1e6bef99fc3bceb5c790e7aa2caa7)
- Convert tests to ES6. [`4a9797e`](https://github.com/pahen/madge/commit/4a9797eac699df69e86d36a12ae92beb28836395)
- Use ES6 internally. [`6a0e2ca`](https://github.com/pahen/madge/commit/6a0e2ca5838ceb509ba3330fa4031ea1a6f7f7e5)

#### [0.5.5](https://github.com/pahen/madge/compare/0.5.4...0.5.5)

> 3 July 2016

- Fix matching absolute path [`#80`](https://github.com/pahen/madge/pull/80)
- Support for es6 re-export syntax [`#91`](https://github.com/pahen/madge/pull/91)
- AMD: Support files with embedded es6 [`#90`](https://github.com/pahen/madge/pull/90)
- Improve readme circular return object [`#85`](https://github.com/pahen/madge/pull/85)
- AMD: Support files with embedded es6 (#90) [`#84`](https://github.com/pahen/madge/issues/84)
- Update code to pass ESLint rules. [`e0866d5`](https://github.com/pahen/madge/commit/e0866d56e6b7dc7112f71616ac22dc7c0d954ea2)
- Remove react-tools since detective-es6 handles it now. [`b16f946`](https://github.com/pahen/madge/commit/b16f94625846436859ef7a5a5f68545305db509e)
- Move RequireJS specific code into amd.js [`374d14c`](https://github.com/pahen/madge/commit/374d14c1742a1feba2e6fb7805ab1d510b78d661)

#### [0.5.4](https://github.com/pahen/madge/compare/0.5.3...0.5.4)

> 13 June 2016

- Bump detective-es6 for JSX and ES7 support [`#83`](https://github.com/pahen/madge/pull/83)
- Don't use sudo to install the package [`#76`](https://github.com/pahen/madge/pull/76)
- Correct CLI API for mainRequireModule [`#72`](https://github.com/pahen/madge/pull/72)
- Bump detective-es6 for JSX and ES7 support [`#81`](https://github.com/pahen/madge/issues/81) [`#61`](https://github.com/pahen/madge/issues/61)
- Update status icons in README. [`61429de`](https://github.com/pahen/madge/commit/61429ded932c32426b20c86552ff5096d715d726)
- Update releasenotes. [`bf0e987`](https://github.com/pahen/madge/commit/bf0e987b7da6d2d84e142a3cbb5388e7a2e0659c)
- Bump to version 0.5.4 [`38c40ac`](https://github.com/pahen/madge/commit/38c40ac17d653103187bcc1c5e2512aa3c5b0c4c)

#### [0.5.3](https://github.com/pahen/madge/compare/0.5.2...0.5.3)

> 25 November 2015

- Correct regex on CommonJS parser to detect a core module [`#71`](https://github.com/pahen/madge/pull/71)
- Update README.md [`#70`](https://github.com/pahen/madge/pull/70)
- List "es6" format in CLI help [`#66`](https://github.com/pahen/madge/pull/66)
- Update releasenotes. [`153235d`](https://github.com/pahen/madge/commit/153235dba6df0b40b4305c1331fa7856b9a9bd25)
- Bump to version 0.5.3 [`c00dd70`](https://github.com/pahen/madge/commit/c00dd70f684cb71c651a7e57eeeb89728cb9434c)
- Correct regex on CJS parser to detect a core module [`67a449a`](https://github.com/pahen/madge/commit/67a449a276d250950dd839ffb37bb2b9bb7a82bd)

#### [0.5.2](https://github.com/pahen/madge/compare/0.5.1...0.5.2)

> 16 October 2015

- Update resolve to latest version. [`21f787c`](https://github.com/pahen/madge/commit/21f787ced85df3002508a1de4fc3b4fe23fbfc06)
- Bump to version 0.5.2 [`95faed0`](https://github.com/pahen/madge/commit/95faed027d21af80e58697588f061787b2f8592f)

#### [0.5.1](https://github.com/pahen/madge/compare/0.5.0...0.5.1)

> 15 October 2015

- Update modules without any change to the code [`#65`](https://github.com/pahen/madge/pull/65)
- Update all dependencies that will not break tests [`65dcaf3`](https://github.com/pahen/madge/commit/65dcaf318defa3140222c9774b35d51373bd5aa1)
- Update shrinkwrap [`08ad266`](https://github.com/pahen/madge/commit/08ad266ea7e922762798b5a5bacc103c7d6b9762)
- Update releasenotes. [`774f8d8`](https://github.com/pahen/madge/commit/774f8d855bf77da0211df97c97b97dc2d44cab69)

#### [0.5.0](https://github.com/pahen/madge/compare/0.4.1...0.5.0)

> 2 April 2015

- Add 'comma separated' to -p usage for clarity [`#49`](https://github.com/pahen/madge/pull/49)
- Add ES6 module support [`d5b0b60`](https://github.com/pahen/madge/commit/d5b0b60cff78aa473e60cf81322a9cfc716643a4)
- Use npm-shrinkwrap instead of “npm shrinkwrap” to get consistent “resolved” fields. [`082abcb`](https://github.com/pahen/madge/commit/082abcb83a34aec2db0edeb728b85cf2e0be2e0b)
- Cleanup after PL. [`a0d18ff`](https://github.com/pahen/madge/commit/a0d18ffdf8530ca10ebc6ab8e4e86f160b4b524c)

#### [0.4.1](https://github.com/pahen/madge/compare/0.4.0...0.4.1)

> 19 December 2014

- Move method to proper file. [`f17a64a`](https://github.com/pahen/madge/commit/f17a64ae0f1c1e506a99fe739b2bc4a6ef2013cc)
- Fix bug with absolute paths for module IDs in Windows. [`f64697a`](https://github.com/pahen/madge/commit/f64697a25718ca16e5af5aa21594cfd98bc23701)
- Fix issues with absolute paths for modules IDs in Windows (all tests should now pass on Windows too). [`9d524e4`](https://github.com/pahen/madge/commit/9d524e4cc044533029ca6a67e1fba1fac1532984)

#### [0.4.0](https://github.com/pahen/madge/compare/0.3.5...0.4.0)

> 19 December 2014

- Update NPM shrinkwrap file. [`a23178c`](https://github.com/pahen/madge/commit/a23178c990c87556e2f126a548005ce2a8f35b37)
- Resolve the module IDs from the RequireJS paths-config properly. [`41b54e2`](https://github.com/pahen/madge/commit/41b54e2ecde61972ea1f2dfd1a75904ec1029d5a)
- Add support for JSX (React) and additional module paths. [`858cd72`](https://github.com/pahen/madge/commit/858cd7290d87477ada8b588d85c93f32a6b932e9)

#### [0.3.5](https://github.com/pahen/madge/compare/0.3.3...0.3.5)

> 22 September 2014

- IMPROVED: correctly detect circular dependencies when using path aliases (amd) [`324b12b`](https://github.com/pahen/madge/commit/324b12b7a04c7f3bfd431b057e1487e6cf0e6442)
- Clear generated graph nodes on each render of a graph. [`4bd4f00`](https://github.com/pahen/madge/commit/4bd4f0035ea2989e7c59249d0ef54be762fbaad5)
- Update releasenotes. [`d3df3ab`](https://github.com/pahen/madge/commit/d3df3ab7e22234a21a229296811c8171ee3beefb)

#### [0.3.3](https://github.com/pahen/madge/compare/0.3.2...0.3.3)

> 11 July 2014

- Use path.resolve() to resolve relative paths in AMD dependencies instead of substack’s resolve lib since it works as expected (fixes #33). [`#33`](https://github.com/pahen/madge/issues/33)
- Use amdetective infavor of parse.js for parsing AMD dependencies. [`28e462d`](https://github.com/pahen/madge/commit/28e462d6a016f5b44aa1324392532073d8442005)
- Bump to version 0.3.3 [`dc35cf4`](https://github.com/pahen/madge/commit/dc35cf45fa7bacc23f31c5cd0cc5888806624ddc)

#### [0.3.2](https://github.com/pahen/madge/compare/0.3.1...0.3.2)

> 25 June 2014

- convert spaces to tabs [`#30`](https://github.com/pahen/madge/pull/30)
- Code cleanup. [`a235a00`](https://github.com/pahen/madge/commit/a235a0074ba9fb3ca7e6a02aedc6d96c40c8ad5b)
- Added failing test cases. [`d095e6a`](https://github.com/pahen/madge/commit/d095e6af71093c16ed0ba704a11f8eed05f76912)
- Added code to pass the tests. [`b2276f5`](https://github.com/pahen/madge/commit/b2276f5fc8a121d87d9d38a94b5a894e5103d7dc)

#### [0.3.1](https://github.com/pahen/madge/compare/0.3.0...0.3.1)

> 3 June 2014

- Apply exclude to RequireJS shim dependencies [`02f3d28`](https://github.com/pahen/madge/commit/02f3d28f26af12d0b0ade3c56df42451161b3882)
- Update releasenotes. [`8dd4fb2`](https://github.com/pahen/madge/commit/8dd4fb2168c357e9ccdfabe68c5d62b13e654c26)
- Bump to version 0.3.1 [`c41987b`](https://github.com/pahen/madge/commit/c41987b0ad5c952af9554552bcbbddb87139b2e6)

#### [0.3.0](https://github.com/pahen/madge/compare/0.2.0...0.3.0)

> 26 May 2014

- Lock down dependencies. [`9dcc9b7`](https://github.com/pahen/madge/commit/9dcc9b71348b733aad12e5373f9955158d085509)
- make pluggbable by adding onParseFile and onAddModule options that hook into these events with returned madge as the bound context [`ee04d41`](https://github.com/pahen/madge/commit/ee04d418a0cfc61cffbf210edd60129ca609be98)
- Add some documentation about onParseFile and onAddModule options. [`dfa9c2b`](https://github.com/pahen/madge/commit/dfa9c2b4491bd34e6444b0f602bc329eb6c80639)

#### 0.2.0

> 18 April 2014

- Update README.md [`#13`](https://github.com/pahen/madge/pull/13)
- Using require() to get version number instead of version.js [`#11`](https://github.com/pahen/madge/pull/11)
- Complete path in circular dependencies is now printed (and marked as red in image graphs). Fixes #4 [`#4`](https://github.com/pahen/madge/issues/4)
- Fixed Node.js v0.8 issues. Closes #2 [`#2`](https://github.com/pahen/madge/issues/2)
- first commit [`c730a52`](https://github.com/pahen/madge/commit/c730a52ac6eb49c7a5813146c42ef9861c364aee)
- Added support for CoffeeScript. Files with extension .coffee will automatically be compiled on-the-fly. [`67fa4ec`](https://github.com/pahen/madge/commit/67fa4ec53d2ae2a85ed0c83ea656dd20364f7f03)
- Some code cleanup. [`d976942`](https://github.com/pahen/madge/commit/d9769421ad0aa8e5a3109158f33ce80ea926881b)
