"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLapRecorder = exports.polyHrTime = exports.toMilliseconds = exports.createTimer = void 0;
const _hrTime = (process === null || process === void 0 ? void 0 : process.hrtime) || polyHrTime;
function createTimer(hrTimeFn = _hrTime) {
    let start = hrTimeFn();
    let lastLap = 0;
    function elapsed() {
        return toMilliseconds(hrTimeFn(start));
    }
    return {
        start() {
            start = hrTimeFn();
            lastLap = 0;
        },
        elapsed,
        lap() {
            const now = elapsed();
            const diff = now - lastLap;
            lastLap = now;
            return diff;
        },
    };
}
exports.createTimer = createTimer;
function toMilliseconds(t) {
    return (t[0] + t[1] * 1e-9) * 1000;
}
exports.toMilliseconds = toMilliseconds;
function polyHrTime(time) {
    const now = Date.now() - (time ? toMilliseconds(time) : 0);
    const inSeconds = now * 1.0e-3;
    const s = Math.floor(inSeconds);
    const n = (inSeconds - s) * 1.0e9;
    return [s, n];
}
exports.polyHrTime = polyHrTime;
function createLapRecorder() {
    const timer = createTimer();
    const times = [];
    let lapTime = 0;
    function lap(name) {
        const now = timer.elapsed();
        const diff = now - lapTime;
        times.push([name, diff, now]);
        lapTime = diff;
    }
    function report() {
        return times.map(([name, time]) => `${name}: ${time.toFixed(2)}`);
    }
    return {
        times,
        lap,
        report,
    };
}
exports.createLapRecorder = createLapRecorder;
//# sourceMappingURL=timer.js.map