export interface Timer {
    /** Start / restart the timer. */
    start(): void;
    /**
     * Calculate the amount of time in ms since the
     * timer was created / started.
     */
    elapsed(): number;
    /**
     * Calculate the amount of time in ms since the
     * end of the last lap.
     */
    lap(): number;
}
export declare function createTimer(hrTimeFn?: HRTimeFn): Timer;
export declare type HRTimeFn = (time?: HRTime) => HRTime;
export declare type HRTime = [number, number];
export declare function toMilliseconds(t: HRTime): number;
export declare function polyHrTime(time?: HRTime): HRTime;
export interface LapRecorder {
    times: [name: string, lapTime: number, totalTime: number][];
    lap(name: string): void;
    report(): string[];
}
export declare function createLapRecorder(): LapRecorder;
//# sourceMappingURL=timer.d.ts.map