"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.binarySearch = void 0;
/**
 * Search for an item in a sorted array.
 * The value returned is either the position of the item or where it should be inserted.
 */
function binarySearch(arr, item, leftOffset, rightOffset) {
    let left = Math.max(leftOffset !== null && leftOffset !== void 0 ? leftOffset : 0, 0);
    let right = Math.min(rightOffset !== null && rightOffset !== void 0 ? rightOffset : arr.length, arr.length);
    while (left < right) {
        const pos = (left + right) >> 1;
        if (arr[pos] < item) {
            left = pos + 1;
        }
        else {
            right = pos;
        }
    }
    return left;
}
exports.binarySearch = binarySearch;
//# sourceMappingURL=search.js.map