"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveFile = void 0;
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const resolve_from_1 = __importDefault(require("resolve-from"));
const os = __importStar(require("os"));
const resolve_global_1 = __importDefault(require("resolve-global"));
const testNodeModules = /^node_modules\//;
/**
 * Resolve filename to absolute paths.
 * It tries to look for local files as well as node_modules
 * @param filename an absolute path, relative path, `~` path, or a node_module.
 * @param relativeTo absolute path
 */
function resolveFile(filename, relativeTo) {
    filename = filename.replace(/^~/, os.homedir());
    const steps = [
        { filename: filename, fn: tryNodeResolve },
        { filename: path.resolve(relativeTo, filename), fn: tryResolveExists },
        { filename: path.resolve(filename), fn: tryResolveExists },
        { filename: filename, fn: tryNodeResolveDefaultPaths },
        { filename: filename, fn: tryResolveFrom },
        { filename: filename.replace(testNodeModules, ''), fn: tryResolveFrom },
        { filename: filename, fn: tryResolveGlobal },
    ];
    for (const step of steps) {
        const r = step.fn(step.filename, relativeTo);
        if (r.found)
            return r;
    }
    return { filename: path.resolve(relativeTo, filename), relativeTo, found: false };
}
exports.resolveFile = resolveFile;
function tryNodeResolveDefaultPaths(filename) {
    try {
        const r = require.resolve(filename);
        return { filename: r, relativeTo: undefined, found: true };
    }
    catch (_) {
        return { filename, relativeTo: undefined, found: false };
    }
}
function tryNodeResolve(filename, relativeTo) {
    const home = os.homedir();
    function calcPaths(p) {
        const paths = [p];
        // Do not progress towards the root if it is a relative filename.
        if (filename.startsWith('.') &&
            (filename.startsWith('./') || filename.startsWith('.' + path.sep) || filename.startsWith('..'))) {
            return paths;
        }
        for (; p && path.dirname(p) !== p && p !== home; p = path.dirname(p)) {
            paths.push(p);
        }
        return paths;
    }
    const paths = calcPaths(path.resolve(relativeTo));
    try {
        const r = require.resolve(filename, { paths });
        return { filename: r, relativeTo, found: true };
    }
    catch (_) {
        return { filename, relativeTo, found: false };
    }
}
function tryResolveGlobal(filename) {
    const r = resolve_global_1.default.silent(filename);
    return { filename: r || filename, relativeTo: undefined, found: !!r };
}
function tryResolveExists(filename) {
    return { filename, relativeTo: undefined, found: fs.existsSync(filename) };
}
function tryResolveFrom(filename, relativeTo) {
    try {
        return { filename: (0, resolve_from_1.default)(relativeTo, filename), relativeTo, found: true };
    }
    catch (error) {
        // Failed to resolve a relative module request
        return { filename: filename, relativeTo, found: false };
    }
}
//# sourceMappingURL=resolveFile.js.map