/// <reference types="node" />
declare type Console = typeof console;
export interface Logger {
    log: Console['log'];
    warn: Console['warn'];
    error: Console['error'];
}
/**
 * See `Console.error`
 */
export declare function logError(...args: any[]): void;
/**
 * See `Console.warn`
 */
export declare function logWarning(...args: any[]): void;
/**
 * See `Console.log`
 */
export declare function log(...args: any[]): void;
/**
 * Set the global cspell-lib logger
 * @param logger - a logger like `console`
 * @returns the old logger.
 */
export declare function setLogger(logger: Logger): Logger;
/**
 * Get the current cspell-lib logger.
 * @returns the current logger.
 */
export declare function getLogger(): Logger;
export {};
//# sourceMappingURL=logger.d.ts.map