"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.__testing__ = exports.UnknownError = exports.toError = exports.isError = exports.isErrnoException = void 0;
const util_1 = require("util");
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function getTypeOf(t) {
    return typeof t;
}
const allowStringOrUndefined = {
    string: true,
    undefined: true,
};
const allowNumberOrUndefined = {
    number: true,
    undefined: true,
};
function isErrnoException(e) {
    if (!e || typeof e !== 'object')
        return false;
    if (!isError(e))
        return false;
    const ex = e;
    return (typeof ex.errno in allowNumberOrUndefined &&
        typeof ex.code in allowStringOrUndefined &&
        typeof ex.path in allowStringOrUndefined);
}
exports.isErrnoException = isErrnoException;
function isError(e) {
    if (e instanceof Error)
        return true;
    if (!e || typeof e !== 'object')
        return false;
    const ex = e;
    return typeof ex.name == 'string' && typeof ex.message == 'string' && typeof ex.stack in allowStringOrUndefined;
}
exports.isError = isError;
function toError(e, errorFactory = UnknownError) {
    if (isError(e))
        return e;
    return new errorFactory(e);
}
exports.toError = toError;
class UnknownError extends Error {
    constructor(cause) {
        super((0, util_1.format)(cause));
        this.cause = cause;
    }
}
exports.UnknownError = UnknownError;
exports.__testing__ = {
    getTypeOf,
};
//# sourceMappingURL=errors.js.map