export interface MatchRange {
    startPos: number;
    endPos: number;
}
export interface MatchRangeWithText extends MatchRange {
    text: string;
}
export interface MatchRangeOptionalText extends MatchRange {
    text?: string;
}
export declare function findMatchingRanges(pattern: RegExp, text: string): MatchRangeOptionalText[];
export declare function unionRanges(ranges: MatchRange[]): MatchRange[];
export declare function findMatchingRangesForPatterns(patterns: RegExp[], text: string): MatchRange[];
/**
 * Create a new set of positions that have the excluded position ranges removed.
 */
export declare function excludeRanges(includeRanges: MatchRange[], excludeRanges: MatchRange[]): MatchRange[];
export declare function extractRangeText(text: string, ranges: MatchRange[]): MatchRangeWithText[];
declare const SymSortedMatchRangeArray: unique symbol;
interface SortedMatchRangeArray extends Array<MatchRange> {
    [SymSortedMatchRangeArray]: true;
}
declare function makeSortedMatchRangeArray(sortedValues: MatchRange[]): SortedMatchRangeArray;
export declare const __testing__: {
    makeSortedMatchRangeArray: typeof makeSortedMatchRangeArray;
};
export {};
//# sourceMappingURL=TextRange.d.ts.map