"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.heapMethods = exports.PairingHeap = void 0;
class PairingHeap {
    constructor(compare) {
        this.compare = compare;
        this._size = 0;
    }
    add(v) {
        this._heap = insert(this.compare, this._heap, v);
        ++this._size;
        return this;
    }
    dequeue() {
        const n = this.next();
        if (n.done)
            return undefined;
        return n.value;
    }
    concat(i) {
        for (const v of i) {
            this.add(v);
        }
        return this;
    }
    next() {
        if (!this._heap) {
            return { value: undefined, done: true };
        }
        const value = this._heap.v;
        --this._size;
        this._heap = removeHead(this.compare, this._heap);
        return { value };
    }
    peek() {
        var _a;
        return (_a = this._heap) === null || _a === void 0 ? void 0 : _a.v;
    }
    [Symbol.iterator]() {
        return this;
    }
    get length() {
        return this._size;
    }
}
exports.PairingHeap = PairingHeap;
function removeHead(compare, heap) {
    if (!heap || !heap.c)
        return undefined;
    return mergeSiblings(compare, heap.c);
}
function insert(compare, heap, v) {
    const n = {
        v,
        s: undefined,
        c: undefined,
    };
    if (!heap || compare(v, heap.v) <= 0) {
        n.c = heap;
        return n;
    }
    n.s = heap.c;
    heap.c = n;
    return heap;
}
function merge(compare, a, b) {
    if (compare(a.v, b.v) <= 0) {
        a.s = undefined;
        b.s = a.c;
        a.c = b;
        return a;
    }
    b.s = undefined;
    a.s = b.c;
    b.c = a;
    return b;
}
function mergeSiblings(compare, n) {
    if (!n.s)
        return n;
    const s = n.s;
    const ss = s.s;
    const m = merge(compare, n, s);
    return ss ? merge(compare, m, mergeSiblings(compare, ss)) : m;
}
exports.heapMethods = {
    insert,
    merge,
    mergeSiblings,
};
//# sourceMappingURL=PairingHeap.js.map