"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.traceWordsAsync = exports.traceWords = void 0;
const gensequence_1 = require("gensequence");
const Settings_1 = require("./Settings");
const CSpellSettingsServer_1 = require("./Settings/CSpellSettingsServer");
const LanguageSettings_1 = require("./Settings/LanguageSettings");
const SpellingDictionary_1 = require("./SpellingDictionary");
const util = __importStar(require("./util/util"));
async function traceWords(words, settings, options) {
    const results = await util.asyncIterableToArray(traceWordsAsync(words, settings, options));
    const s = (0, gensequence_1.genSequence)(results)
        .concatMap((p) => p)
        .toArray();
    return s;
}
exports.traceWords = traceWords;
async function* traceWordsAsync(words, settings, options) {
    const { languageId, locale: language, ignoreCase = true, allowCompoundWords } = options || {};
    async function finalize(config) {
        var _a;
        const withLocale = (0, Settings_1.mergeSettings)(config, util.clean({
            language: language || config.language,
            allowCompoundWords: allowCompoundWords !== null && allowCompoundWords !== void 0 ? allowCompoundWords : config.allowCompoundWords,
        }));
        const withLanguageId = (0, LanguageSettings_1.calcSettingsForLanguageId)(withLocale, (_a = languageId !== null && languageId !== void 0 ? languageId : withLocale.languageId) !== null && _a !== void 0 ? _a : 'plaintext');
        const settings = (0, Settings_1.finalizeSettings)(withLanguageId);
        const dictionaries = (settings.dictionaries || [])
            .concat((settings.dictionaryDefinitions || []).map((d) => d.name))
            .filter(util.uniqueFn);
        const dictSettings = (0, CSpellSettingsServer_1.toInternalSettings)({ ...settings, dictionaries });
        const dictBase = await (0, SpellingDictionary_1.getDictionaryInternal)(settings);
        const dicts = await (0, SpellingDictionary_1.getDictionaryInternal)(dictSettings);
        const activeDictionaries = dictBase.dictionaries.map((d) => d.name);
        return {
            activeDictionaries,
            config: settings,
            dicts,
        };
    }
    await (0, SpellingDictionary_1.refreshDictionaryCache)();
    const { config, dicts, activeDictionaries } = await finalize(settings);
    const setOfActiveDicts = new Set(activeDictionaries);
    const opts = util.clean({ ignoreCase, useCompounds: config.allowCompoundWords });
    function normalizeErrors(errors) {
        if (!(errors === null || errors === void 0 ? void 0 : errors.length))
            return undefined;
        return errors;
    }
    function processWord(word) {
        return dicts.dictionaries
            .map((dict) => ({ dict, findResult: dict.find(word, opts) }))
            .map(({ dict, findResult }) => {
            var _a;
            return ({
                word,
                found: !!(findResult === null || findResult === void 0 ? void 0 : findResult.found),
                foundWord: (findResult === null || findResult === void 0 ? void 0 : findResult.found) || undefined,
                forbidden: (findResult === null || findResult === void 0 ? void 0 : findResult.forbidden) || false,
                noSuggest: (findResult === null || findResult === void 0 ? void 0 : findResult.noSuggest) || false,
                dictName: dict.name,
                dictSource: dict.source,
                dictActive: setOfActiveDicts.has(dict.name),
                configSource: config.name || '',
                errors: normalizeErrors((_a = dict.getErrors) === null || _a === void 0 ? void 0 : _a.call(dict)),
            });
        });
    }
    for await (const word of words) {
        yield processWord(word);
    }
}
exports.traceWordsAsync = traceWordsAsync;
//# sourceMappingURL=trace.js.map