"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.determineTextDocumentSettings = void 0;
const path = __importStar(require("path"));
const LanguageIds_1 = require("../LanguageIds");
const Settings_1 = require("../Settings");
const TextDocumentSettings_1 = require("../Settings/TextDocumentSettings");
/**
 * Combines all relevant setting values into a final configuration to be used for spell checking.
 * It applies any overrides and appropriate language settings by taking into account the document type (languageId)
 * the locale (natural language) and any in document settings.
 *
 * Note: this method will not search for configuration files. Configuration files should already be merged into `settings`.
 * It is NOT necessary to include the cspell defaultSettings or globalSettings. They will be applied within this function.
 * @param document - The document to be spell checked. Note: if the URI doesn't have a path, overrides cannot be applied.
 *   `locale` - if defined will be used unless it is overridden by an in-document setting.
 *   `languageId` - if defined will be used to select appropriate file type dictionaries.
 * @param settings - The near final settings. Should already be the combination of all configuration files.
 */
function determineTextDocumentSettings(doc, settings) {
    var _a, _b;
    const filename = doc.uri.fsPath;
    const settingsWithDefaults = (0, Settings_1.mergeSettings)((0, Settings_1.getDefaultSettings)((_a = settings.loadDefaultConfiguration) !== null && _a !== void 0 ? _a : true), (0, Settings_1.getGlobalSettings)(), settings);
    const fileSettings = (0, Settings_1.calcOverrideSettings)(settingsWithDefaults, filename);
    const languageIds = ((_b = fileSettings === null || fileSettings === void 0 ? void 0 : fileSettings.languageId) === null || _b === void 0 ? void 0 : _b.length)
        ? fileSettings.languageId
        : doc.languageId
            ? doc.languageId
            : getLanguageForFilename(filename);
    if (doc.locale) {
        fileSettings.language = doc.locale;
    }
    return (0, TextDocumentSettings_1.combineTextAndLanguageSettings)(fileSettings, doc.text, languageIds);
}
exports.determineTextDocumentSettings = determineTextDocumentSettings;
function getLanguageForFilename(filename) {
    const basename = path.basename(filename);
    return (0, LanguageIds_1.getLanguagesForBasename)(basename);
}
//# sourceMappingURL=determineTextDocumentSettings.js.map