"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuggestionError = exports.suggestionsForWord = exports.suggestionsForWords = void 0;
const Settings_1 = require("./Settings");
const LanguageSettings_1 = require("./Settings/LanguageSettings");
const SpellingDictionary_1 = require("./SpellingDictionary");
const util = __importStar(require("./util/util"));
async function* suggestionsForWords(words, options, settings = {}) {
    for await (const word of words) {
        yield await suggestionsForWord(word, options, settings);
    }
}
exports.suggestionsForWords = suggestionsForWords;
async function suggestionsForWord(word, options, settings = {}) {
    var _a;
    const { languageId, locale: language, strict = true, numChanges = 4, numSuggestions = 8, includeTies = true, includeDefaultConfig = true, dictionaries, } = options || {};
    const ignoreCase = !strict;
    async function determineDictionaries(config) {
        var _a, _b;
        const withLocale = (0, Settings_1.mergeSettings)(config, util.clean({
            language: language || config.language,
            // dictionaries: dictionaries?.length ? dictionaries : config.dictionaries,
        }));
        const withLanguageId = (0, LanguageSettings_1.calcSettingsForLanguageId)(withLocale, (_a = languageId !== null && languageId !== void 0 ? languageId : withLocale.languageId) !== null && _a !== void 0 ? _a : 'plaintext');
        const settings = (0, Settings_1.finalizeSettings)(withLanguageId);
        settings.dictionaries = (dictionaries === null || dictionaries === void 0 ? void 0 : dictionaries.length) ? dictionaries : settings.dictionaries || [];
        validateDictionaries(settings, dictionaries);
        const dictionaryCollection = await (0, SpellingDictionary_1.getDictionaryInternal)(settings);
        settings.dictionaries = ((_b = settings.dictionaryDefinitions) === null || _b === void 0 ? void 0 : _b.map((def) => def.name)) || [];
        const allDictionaryCollection = await (0, SpellingDictionary_1.getDictionaryInternal)(settings);
        return {
            dictionaryCollection,
            allDictionaryCollection,
        };
    }
    await (0, SpellingDictionary_1.refreshDictionaryCache)();
    const config = includeDefaultConfig
        ? (0, Settings_1.mergeSettings)((0, Settings_1.getDefaultSettings)((_a = settings.loadDefaultConfiguration) !== null && _a !== void 0 ? _a : true), (0, Settings_1.getGlobalSettings)(), settings)
        : settings;
    const { dictionaryCollection, allDictionaryCollection } = await determineDictionaries(config);
    const opts = { ignoreCase, numChanges, numSuggestions, includeTies };
    const suggestionsByDictionary = dictionaryCollection.dictionaries.map((dict) => dict.suggest(word, opts).map((r) => ({ ...r, dictName: dict.name })));
    const combined = combine(util.flatten(suggestionsByDictionary).sort((a, b) => a.cost - b.cost || (a.word <= b.word ? -1 : 1)));
    const findOpts = {};
    const allSugs = combined.map((sug) => {
        const found = allDictionaryCollection.find(sug.word, findOpts);
        return {
            ...sug,
            forbidden: (found === null || found === void 0 ? void 0 : found.forbidden) || false,
            noSuggest: (found === null || found === void 0 ? void 0 : found.noSuggest) || false,
        };
    });
    return {
        word,
        suggestions: limitResults(allSugs, numSuggestions, includeTies),
    };
}
exports.suggestionsForWord = suggestionsForWord;
function combine(suggestions) {
    const words = new Map();
    for (const sug of suggestions) {
        const { word, cost, dictName, ...rest } = sug;
        const f = words.get(word) || { word, cost, ...rest, dictionaries: [] };
        f.cost = Math.min(f.cost, cost);
        f.dictionaries.push(dictName);
        f.dictionaries.sort();
        words.set(word, f);
    }
    return [...words.values()];
}
function limitResults(suggestions, numSuggestions, includeTies) {
    var _a;
    let cost = (_a = suggestions[0]) === null || _a === void 0 ? void 0 : _a.cost;
    let i = 0;
    for (; i < suggestions.length; ++i) {
        if (i >= numSuggestions && (!includeTies || suggestions[i].cost > cost)) {
            break;
        }
        cost = suggestions[i].cost;
    }
    return suggestions.slice(0, i);
}
function validateDictionaries(settings, dictionaries) {
    var _a;
    if (!(dictionaries === null || dictionaries === void 0 ? void 0 : dictionaries.length))
        return;
    const knownDicts = new Set(((_a = settings.dictionaryDefinitions) === null || _a === void 0 ? void 0 : _a.map((def) => def.name)) || []);
    for (const dict of dictionaries) {
        if (!knownDicts.has(dict)) {
            throw new SuggestionError(`Unknown dictionary: "${dict}"`, 'E_dictionary_unknown');
        }
    }
}
class SuggestionError extends Error {
    constructor(message, code) {
        super(message);
        this.code = code;
    }
}
exports.SuggestionError = SuggestionError;
//# sourceMappingURL=suggestions.js.map