"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.__testing__ = exports.removePathsFromGlobalImports = exports.addPathsToGlobalImports = exports.listGlobalImports = void 0;
const fs = __importStar(require("fs"));
const Path = __importStar(require("path"));
const util_1 = require("../util/util");
const configLoader_1 = require("./configLoader");
const GlobalSettings_1 = require("./GlobalSettings");
function listGlobalImports() {
    const globalSettings = (0, GlobalSettings_1.getRawGlobalSettings)();
    const list = resolveImports(globalSettings).map(({ filename, settings, error }) => ({
        filename,
        error,
        id: settings.id,
        name: settings.name,
        dictionaryDefinitions: settings.dictionaryDefinitions,
        languageSettings: settings.languageSettings,
        package: findPackageForCSpellConfig(Path.dirname(filename)),
    }));
    return {
        list,
        globalSettings,
    };
}
exports.listGlobalImports = listGlobalImports;
function isString(s) {
    return s !== undefined;
}
function addPathsToGlobalImports(paths) {
    const resolvedSettings = paths.map(resolveSettings);
    const hasError = resolvedSettings.filter((r) => !!r.error).length > 0;
    if (hasError) {
        return {
            success: false,
            resolvedSettings,
            error: 'Unable to resolve files.',
        };
    }
    const rawGlobalSettings = (0, GlobalSettings_1.getRawGlobalSettings)();
    const resolvedImports = resolveImports(rawGlobalSettings);
    const imports = new Set(resolvedImports.map((r) => r.resolvedToFilename || r.filename));
    resolvedSettings
        .map((s) => s.resolvedToFilename)
        .filter(isString)
        .reduce((imports, s) => imports.add(s), imports);
    const globalSettings = {
        import: [...imports],
    };
    const error = (0, GlobalSettings_1.writeRawGlobalSettings)(globalSettings);
    return {
        success: !error,
        error: error === null || error === void 0 ? void 0 : error.message,
        resolvedSettings,
    };
}
exports.addPathsToGlobalImports = addPathsToGlobalImports;
/**
 * Remove files from the global setting.
 * @param paths match against the partial file path, or package name, or id.
 *   To match against a partial file path, it must match against the subdirectory and filename.
 * Note: for Idempotent reasons, asking to remove a path that is not in the global settings is considered a success.
 *   It is possible to check for this by looking at the returned list of removed paths.
 */
function removePathsFromGlobalImports(paths) {
    const listResult = listGlobalImports();
    const toRemove = new Set();
    function matchPackage(pathToRemove) {
        return ({ package: pkg, id }) => pathToRemove === (pkg === null || pkg === void 0 ? void 0 : pkg.name) || pathToRemove === id;
    }
    function compareFilenames(fullPath, partialPath) {
        if (fullPath === partialPath)
            return true;
        if (!fullPath.endsWith(partialPath))
            return false;
        const c = fullPath[fullPath.length - partialPath.length - 1];
        return c === Path.sep || c === Path.posix.sep;
    }
    function matchFilename(pathToRemove) {
        return Path.dirname(pathToRemove) != '.'
            ? ({ filename }) => compareFilenames(filename, pathToRemove)
            : () => false;
    }
    paths
        .map((a) => a.trim())
        .filter((a) => !!a)
        .forEach((pathToRemove) => {
        const excludePackage = matchPackage(pathToRemove);
        const excludeFilename = matchFilename(pathToRemove);
        const shouldExclude = (r) => excludePackage(r) || excludeFilename(r);
        for (const r of listResult.list) {
            if (shouldExclude(r)) {
                toRemove.add(r.filename);
            }
        }
    });
    const toImport = normalizeImports(listResult.globalSettings.import).filter((p) => !toRemove.has(p));
    const updatedSettings = {
        import: toImport,
    };
    const error = toRemove.size > 0 ? (0, GlobalSettings_1.writeRawGlobalSettings)(updatedSettings) : undefined;
    return {
        success: true,
        removed: [...toRemove],
        error: error === null || error === void 0 ? void 0 : error.toString(),
    };
}
exports.removePathsFromGlobalImports = removePathsFromGlobalImports;
function resolveSettings(filename) {
    var _a;
    const settings = (0, configLoader_1.readRawSettings)(filename);
    const ref = settings.__importRef;
    const resolvedToFilename = ref === null || ref === void 0 ? void 0 : ref.filename;
    const error = ((_a = ref === null || ref === void 0 ? void 0 : ref.error) === null || _a === void 0 ? void 0 : _a.message) || (!resolvedToFilename && 'File not Found') || undefined;
    return (0, util_1.clean)({
        filename,
        resolvedToFilename,
        error,
        settings,
    });
}
function normalizeImports(imports) {
    return typeof imports === 'string' ? [imports] : imports || [];
}
function resolveImports(s) {
    const imported = normalizeImports(s.import);
    return imported.map(resolveSettings);
}
function findPackageForCSpellConfig(pathToConfig) {
    try {
        const filename = Path.join(pathToConfig, 'package.json');
        const pkg = JSON.parse(fs.readFileSync(filename, 'utf8'));
        return {
            filename,
            name: pkg['name'],
        };
    }
    catch (e) {
        return undefined;
    }
}
exports.__testing__ = {
    findPackageForCSpellConfig,
};
//# sourceMappingURL=link.js.map