"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.__testing__ = exports.extractImportErrors = exports.clearCachedSettingsFiles = exports.getCachedFileSize = exports.getGlobalSettings = exports.readSettingsFiles = exports.readRawSettings = exports.loadPnPSync = exports.loadPnP = exports.loadConfigSync = exports.loadConfig = exports.searchForConfigSync = exports.searchForConfig = exports.readSettings = exports.defaultConfigFilenames = exports.defaultFileName = exports.sectionCSpell = void 0;
const json = __importStar(require("comment-json"));
const cosmiconfig_1 = require("cosmiconfig");
const path = __importStar(require("path"));
const vscode_uri_1 = require("vscode-uri");
const CSpellSettingsInternalDef_1 = require("../Models/CSpellSettingsInternalDef");
const logger_1 = require("../util/logger");
const resolveFile_1 = require("../util/resolveFile");
const util = __importStar(require("../util/util"));
const CSpellSettingsServer_1 = require("./CSpellSettingsServer");
const DictionarySettings_1 = require("./DictionarySettings");
const GlobalSettings_1 = require("./GlobalSettings");
const ImportError_1 = require("./ImportError");
const pnpLoader_1 = require("./pnpLoader");
const supportedCSpellConfigVersions = [CSpellSettingsServer_1.configSettingsFileVersion0_2];
const setOfSupportedConfigVersions = new Set(supportedCSpellConfigVersions);
exports.sectionCSpell = 'cSpell';
exports.defaultFileName = 'cspell.json';
/**
 * Logic of the locations:
 * - Support backward compatibility with the VS Code Spell Checker
 *   the spell checker extension can only write to `.json` files because
 *   it would be too difficult to automatically modify a `.js` or `.cjs` file.
 * - To support `cspell.config.js` in a VS Code environment, have a `cspell.json` import
 *   the `cspell.config.js`.
 */
const searchPlaces = [
    'package.json',
    // Original locations
    '.cspell.json',
    'cspell.json',
    '.cSpell.json',
    'cSpell.json',
    // Original locations jsonc
    '.cspell.jsonc',
    'cspell.jsonc',
    // Alternate locations
    '.vscode/cspell.json',
    '.vscode/cSpell.json',
    '.vscode/.cspell.json',
    // Standard Locations
    'cspell.config.json',
    'cspell.config.jsonc',
    'cspell.config.yaml',
    'cspell.config.yml',
    'cspell.yaml',
    'cspell.yml',
    // Dynamic config is looked for last
    'cspell.config.js',
    'cspell.config.cjs',
];
const cspellCosmiconfig = {
    searchPlaces,
    loaders: {
        '.json': parseJson,
        '.jsonc': parseJson,
    },
};
function parseJson(_filename, content) {
    return json.parse(content);
}
exports.defaultConfigFilenames = Object.freeze(searchPlaces.concat());
const cspellConfigExplorer = (0, cosmiconfig_1.cosmiconfig)('cspell', cspellCosmiconfig);
const cspellConfigExplorerSync = (0, cosmiconfig_1.cosmiconfigSync)('cspell', cspellCosmiconfig);
let globalSettings;
const defaultSettings = (0, CSpellSettingsInternalDef_1.createCSpellSettingsInternal)({
    id: 'default',
    name: 'default',
    version: CSpellSettingsServer_1.currentSettingsFileVersion,
});
const defaultPnPSettings = {};
const cachedFiles = new Map();
/**
 * Read a config file and inject the fileRef.
 * @param fileRef - filename plus context, injected into the resulting config.
 */
function readConfig(fileRef) {
    // cspellConfigExplorerSync
    const { filename } = fileRef;
    const s = {};
    try {
        const r = cspellConfigExplorerSync.load(filename);
        if (!(r === null || r === void 0 ? void 0 : r.config))
            throw new Error(`not found: "${filename}"`);
        Object.assign(s, r.config);
        normalizeRawConfig(s);
        validateRawConfig(s, fileRef);
    }
    catch (err) {
        fileRef.error =
            err instanceof ImportError_1.ImportError ? err : new ImportError_1.ImportError(`Failed to read config file: "${filename}"`, err);
    }
    s.__importRef = fileRef;
    return s;
}
/**
 * normalizeSettings handles correcting all relative paths, anchoring globs, and importing other config files.
 * @param rawSettings - raw configuration settings
 * @param pathToSettingsFile - path to the source file of the configuration settings.
 */
function normalizeSettings(rawSettings, pathToSettingsFile, pnpSettings) {
    const id = rawSettings.id ||
        [path.basename(path.dirname(pathToSettingsFile)), path.basename(pathToSettingsFile)].join('/');
    const name = rawSettings.name || id;
    // Try to load any .pnp files before reading dictionaries or other config files.
    const { usePnP = pnpSettings.usePnP, pnpFiles = pnpSettings.pnpFiles } = rawSettings;
    const pnpSettingsToUse = {
        usePnP,
        pnpFiles,
    };
    const pathToSettingsDir = path.dirname(pathToSettingsFile);
    loadPnPSync(pnpSettingsToUse, vscode_uri_1.URI.file(pathToSettingsDir));
    // Fix up dictionaryDefinitions
    const settings = {
        version: defaultSettings.version,
        ...rawSettings,
        id,
        name,
        globRoot: resolveGlobRoot(rawSettings, pathToSettingsFile),
        languageSettings: normalizeLanguageSettings(rawSettings.languageSettings),
    };
    const pathToSettings = path.dirname(pathToSettingsFile);
    const normalizedDictionaryDefs = normalizeDictionaryDefs(settings, pathToSettingsFile);
    const normalizedSettingsGlobs = normalizeSettingsGlobs(settings, pathToSettingsFile);
    const normalizedOverrides = normalizeOverrides(settings, pathToSettingsFile);
    const normalizedReporters = normalizeReporters(settings, pathToSettingsFile);
    const normalizedGitignoreRoot = normalizeGitignoreRoot(settings, pathToSettingsFile);
    const normalizedCacheSettings = normalizeCacheSettings(settings, pathToSettingsDir);
    const imports = typeof settings.import === 'string' ? [settings.import] : settings.import || [];
    const source = settings.source || {
        name: settings.name,
        filename: pathToSettingsFile,
    };
    const fileSettings = (0, CSpellSettingsInternalDef_1.createCSpellSettingsInternal)({
        ...settings,
        source,
        ...normalizedDictionaryDefs,
        ...normalizedSettingsGlobs,
        ...normalizedOverrides,
        ...normalizedReporters,
        ...normalizedGitignoreRoot,
        ...normalizedCacheSettings,
    });
    if (!imports.length) {
        return fileSettings;
    }
    const importedSettings = imports
        .map((name) => resolveFilename(name, pathToSettings))
        .map((ref) => ((ref.referencedBy = [source]), ref))
        .map((ref) => importSettings(ref, undefined, pnpSettingsToUse))
        .reduce((a, b) => (0, CSpellSettingsServer_1.mergeSettings)(a, b));
    const finalizeSettings = (0, CSpellSettingsServer_1.mergeSettings)(importedSettings, fileSettings);
    finalizeSettings.name = settings.name || finalizeSettings.name || '';
    finalizeSettings.id = settings.id || finalizeSettings.id || '';
    return finalizeSettings;
}
function mergeSourceList(orig, append) {
    const collection = new Map(orig.map((s) => [s.name + (s.filename || ''), s]));
    for (const s of append || []) {
        const key = s.name + (s.filename || '');
        if (!collection.has(key)) {
            collection.set(key, s);
        }
    }
    return [...collection.values()];
}
function importSettings(fileRef, defaultValues, pnpSettings) {
    defaultValues = defaultValues !== null && defaultValues !== void 0 ? defaultValues : defaultSettings;
    let { filename } = fileRef;
    filename = path.resolve(filename);
    const importRef = { ...fileRef, filename };
    const cached = cachedFiles.get(filename);
    if (cached) {
        const cachedImportRef = cached.__importRef || importRef;
        cachedImportRef.referencedBy = mergeSourceList(cachedImportRef.referencedBy || [], importRef.referencedBy);
        cached.__importRef = cachedImportRef;
        return cached;
    }
    const id = [path.basename(path.dirname(filename)), path.basename(filename)].join('/');
    const name = id;
    const finalizeSettings = (0, CSpellSettingsInternalDef_1.createCSpellSettingsInternal)({ id, name, __importRef: importRef });
    cachedFiles.set(filename, finalizeSettings); // add an empty entry to prevent circular references.
    const settings = { ...defaultValues, id, name, ...readConfig(importRef) };
    Object.assign(finalizeSettings, normalizeSettings(settings, filename, pnpSettings));
    const finalizeSrc = { name: path.basename(filename), ...finalizeSettings.source };
    finalizeSettings.source = { ...finalizeSrc, filename };
    cachedFiles.set(filename, finalizeSettings);
    return finalizeSettings;
}
function readSettings(filename, relativeToOrDefault, defaultValue) {
    const relativeTo = typeof relativeToOrDefault === 'string' ? relativeToOrDefault : process.cwd();
    defaultValue = defaultValue || (typeof relativeToOrDefault !== 'string' ? relativeToOrDefault : undefined);
    const ref = resolveFilename(filename, relativeTo);
    return importSettings(ref, defaultValue, defaultValue || defaultPnPSettings);
}
exports.readSettings = readSettings;
async function normalizeSearchForConfigResultAsync(searchPath, searchResult, pnpSettings) {
    let result;
    try {
        result = (await searchResult) || undefined;
    }
    catch (cause) {
        result = new ImportError_1.ImportError(`Failed to find config file at: "${searchPath}"`, cause);
    }
    return normalizeSearchForConfigResult(searchPath, result, pnpSettings);
}
function normalizeSearchForConfigResult(searchPath, searchResult, pnpSettings) {
    var _a;
    const error = searchResult instanceof ImportError_1.ImportError ? searchResult : undefined;
    const result = searchResult instanceof ImportError_1.ImportError ? undefined : searchResult;
    const filepath = result === null || result === void 0 ? void 0 : result.filepath;
    if (filepath) {
        const cached = cachedFiles.get(filepath);
        if (cached) {
            return {
                config: cached,
                filepath,
                error,
            };
        }
    }
    const { config = (0, CSpellSettingsInternalDef_1.createCSpellSettingsInternal)({}) } = result || {};
    const filename = (_a = result === null || result === void 0 ? void 0 : result.filepath) !== null && _a !== void 0 ? _a : searchPath;
    const importRef = { filename: filename, error };
    const id = [path.basename(path.dirname(filename)), path.basename(filename)].join('/');
    const name = (result === null || result === void 0 ? void 0 : result.filepath) ? id : `Config not found: ${id}`;
    const finalizeSettings = (0, CSpellSettingsInternalDef_1.createCSpellSettingsInternal)({ id, name, __importRef: importRef });
    const settings = { id, ...config };
    cachedFiles.set(filename, finalizeSettings); // add an empty entry to prevent circular references.
    Object.assign(finalizeSettings, normalizeSettings(settings, filename, pnpSettings));
    return {
        config: finalizeSettings,
        filepath,
        error,
    };
}
function searchForConfig(searchFrom, pnpSettings = defaultPnPSettings) {
    return normalizeSearchForConfigResultAsync(searchFrom || process.cwd(), cspellConfigExplorer.search(searchFrom), pnpSettings).then((r) => (r.filepath ? r.config : undefined));
}
exports.searchForConfig = searchForConfig;
function searchForConfigSync(searchFrom, pnpSettings = defaultPnPSettings) {
    let searchResult;
    try {
        searchResult = cspellConfigExplorerSync.search(searchFrom) || undefined;
    }
    catch (err) {
        searchResult = new ImportError_1.ImportError(`Failed to find config file from: "${searchFrom}"`, err);
    }
    return normalizeSearchForConfigResult(searchFrom || process.cwd(), searchResult, pnpSettings).config;
}
exports.searchForConfigSync = searchForConfigSync;
/**
 * Load a CSpell configuration files.
 * @param file - path or package reference to load.
 * @param pnpSettings - PnP settings
 * @returns normalized CSpellSettings
 */
function loadConfig(file, pnpSettings = defaultPnPSettings) {
    const cached = cachedFiles.get(path.resolve(file));
    if (cached) {
        return Promise.resolve(cached);
    }
    return normalizeSearchForConfigResultAsync(file, cspellConfigExplorer.load(file), pnpSettings).then((r) => r.config);
}
exports.loadConfig = loadConfig;
/**
 * Load a CSpell configuration files.
 * @param filename - path or package reference to load.
 * @param pnpSettings - PnP settings
 * @returns normalized CSpellSettings
 */
function loadConfigSync(filename, pnpSettings = defaultPnPSettings) {
    const cached = cachedFiles.get(path.resolve(filename));
    if (cached) {
        return cached;
    }
    let searchResult;
    try {
        searchResult = cspellConfigExplorerSync.load(filename) || undefined;
    }
    catch (err) {
        searchResult = new ImportError_1.ImportError(`Failed to find config file at: "${filename}"`, err);
    }
    return normalizeSearchForConfigResult(filename, searchResult, pnpSettings).config;
}
exports.loadConfigSync = loadConfigSync;
function loadPnP(pnpSettings, searchFrom) {
    if (!pnpSettings.usePnP) {
        return Promise.resolve(undefined);
    }
    const loader = (0, pnpLoader_1.pnpLoader)(pnpSettings.pnpFiles);
    return loader.load(searchFrom);
}
exports.loadPnP = loadPnP;
function loadPnPSync(pnpSettings, searchFrom) {
    if (!pnpSettings.usePnP) {
        return undefined;
    }
    const loader = (0, pnpLoader_1.pnpLoader)(pnpSettings.pnpFiles);
    return loader.loadSync(searchFrom);
}
exports.loadPnPSync = loadPnPSync;
function readRawSettings(filename, relativeTo) {
    relativeTo = relativeTo || process.cwd();
    const ref = resolveFilename(filename, relativeTo);
    return readConfig(ref);
}
exports.readRawSettings = readRawSettings;
/**
 *
 * @param filenames - settings files to read
 * @returns combined configuration
 * @deprecated true
 */
function readSettingsFiles(filenames) {
    return filenames.map((filename) => readSettings(filename)).reduce((a, b) => (0, CSpellSettingsServer_1.mergeSettings)(a, b), defaultSettings);
}
exports.readSettingsFiles = readSettingsFiles;
function resolveFilename(filename, relativeTo) {
    const r = (0, resolveFile_1.resolveFile)(filename, relativeTo);
    return {
        filename: r.filename,
        error: r.found ? undefined : new Error(`Failed to resolve file: "${filename}"`),
    };
}
function getGlobalSettings() {
    if (!globalSettings) {
        const globalConf = (0, GlobalSettings_1.getRawGlobalSettings)();
        globalSettings = {
            id: 'global_config',
            ...normalizeSettings(globalConf || {}, './global_config', {}),
        };
    }
    return globalSettings;
}
exports.getGlobalSettings = getGlobalSettings;
function getCachedFileSize() {
    return cachedFiles.size;
}
exports.getCachedFileSize = getCachedFileSize;
function clearCachedSettingsFiles() {
    globalSettings = undefined;
    cachedFiles.clear();
    cspellConfigExplorer.clearCaches();
    cspellConfigExplorerSync.clearCaches();
}
exports.clearCachedSettingsFiles = clearCachedSettingsFiles;
function mergeImportRefs(left, right = {}) {
    var _a;
    const imports = new Map(left.__imports || []);
    if (left.__importRef) {
        imports.set(left.__importRef.filename, left.__importRef);
    }
    if (right.__importRef) {
        imports.set(right.__importRef.filename, right.__importRef);
    }
    const rightImports = ((_a = right.__imports) === null || _a === void 0 ? void 0 : _a.values()) || [];
    for (const ref of rightImports) {
        imports.set(ref.filename, ref);
    }
    return imports.size ? imports : undefined;
}
function isImportFileRefWithError(ref) {
    return !!ref.error;
}
function extractImportErrors(settings) {
    const imports = mergeImportRefs(settings);
    return !imports ? [] : [...imports.values()].filter(isImportFileRefWithError);
}
exports.extractImportErrors = extractImportErrors;
function resolveGlobRoot(settings, pathToSettingsFile) {
    var _a;
    const settingsFileDirRaw = path.dirname(pathToSettingsFile);
    const isVSCode = path.basename(settingsFileDirRaw) === '.vscode';
    const settingsFileDir = isVSCode ? path.dirname(settingsFileDirRaw) : settingsFileDirRaw;
    const envGlobRoot = process.env[CSpellSettingsServer_1.ENV_CSPELL_GLOB_ROOT];
    const defaultGlobRoot = envGlobRoot !== null && envGlobRoot !== void 0 ? envGlobRoot : '${cwd}';
    const rawRoot = (_a = settings.globRoot) !== null && _a !== void 0 ? _a : (settings.version === CSpellSettingsServer_1.configSettingsFileVersion0_1 ||
        (envGlobRoot && !settings.version) ||
        (isVSCode && !settings.version)
        ? defaultGlobRoot
        : settingsFileDir);
    const globRoot = rawRoot.startsWith('${cwd}') ? rawRoot : path.resolve(settingsFileDir, rawRoot);
    return globRoot;
}
function resolveFilePath(filename, pathToSettingsFile) {
    const cwd = process.cwd();
    return path.resolve(pathToSettingsFile, filename.replace('${cwd}', cwd));
}
function toGlobDef(g, root, source) {
    if (g === undefined)
        return undefined;
    if (Array.isArray(g)) {
        return g.map((g) => toGlobDef(g, root, source));
    }
    if (typeof g === 'string') {
        const glob = { glob: g };
        if (root !== undefined) {
            glob.root = root;
        }
        return toGlobDef(glob, root, source);
    }
    if (source) {
        return { ...g, source };
    }
    return g;
}
function normalizeDictionaryDefs(settings, pathToSettingsFile) {
    var _a;
    const dictionaryDefinitions = (0, DictionarySettings_1.mapDictDefsToInternal)(settings.dictionaryDefinitions, pathToSettingsFile);
    const languageSettings = (_a = settings.languageSettings) === null || _a === void 0 ? void 0 : _a.map((langSetting) => util.clean({
        ...langSetting,
        dictionaryDefinitions: (0, DictionarySettings_1.mapDictDefsToInternal)(langSetting.dictionaryDefinitions, pathToSettingsFile),
    }));
    return util.clean({
        dictionaryDefinitions,
        languageSettings,
    });
}
function normalizeOverrides(settings, pathToSettingsFile) {
    var _a;
    const { globRoot = path.dirname(pathToSettingsFile) } = settings;
    const overrides = (_a = settings.overrides) === null || _a === void 0 ? void 0 : _a.map((override) => {
        const filename = toGlobDef(override.filename, globRoot, pathToSettingsFile);
        const { dictionaryDefinitions, languageSettings } = normalizeDictionaryDefs(override, pathToSettingsFile);
        return util.clean({
            ...override,
            filename,
            dictionaryDefinitions,
            languageSettings: normalizeLanguageSettings(languageSettings),
        });
    });
    return overrides ? { overrides } : {};
}
function normalizeReporters(settings, pathToSettingsFile) {
    if (settings.reporters === undefined)
        return {};
    const folder = path.dirname(pathToSettingsFile);
    function resolve(s) {
        const r = (0, resolveFile_1.resolveFile)(s, folder);
        if (!r.found) {
            throw new Error(`Not found: "${s}"`);
        }
        return r.filename;
    }
    function resolveReporter(s) {
        if (typeof s === 'string') {
            return resolve(s);
        }
        if (!Array.isArray(s) || typeof s[0] !== 'string')
            throw new Error('Invalid Reporter');
        // Preserve the shape of Reporter Setting while resolving the reporter file.
        const [r, ...rest] = s;
        return [resolve(r), ...rest];
    }
    return {
        reporters: settings.reporters.map(resolveReporter),
    };
}
function normalizeLanguageSettings(languageSettings) {
    if (!languageSettings)
        return undefined;
    function fixLocale(s) {
        const { local: locale, ...rest } = s;
        return util.clean({ locale, ...rest });
    }
    return languageSettings.map(fixLocale);
}
function normalizeGitignoreRoot(settings, pathToSettingsFile) {
    const { gitignoreRoot } = settings;
    if (!gitignoreRoot)
        return {};
    const dir = path.dirname(pathToSettingsFile);
    const roots = Array.isArray(gitignoreRoot) ? gitignoreRoot : [gitignoreRoot];
    return {
        gitignoreRoot: roots.map((p) => path.resolve(dir, p)),
    };
}
function normalizeSettingsGlobs(settings, pathToSettingsFile) {
    const { globRoot } = settings;
    if (settings.ignorePaths === undefined)
        return {};
    const ignorePaths = toGlobDef(settings.ignorePaths, globRoot, pathToSettingsFile);
    return {
        ignorePaths,
    };
}
function normalizeCacheSettings(settings, pathToSettingsDir) {
    const { cache } = settings;
    if (cache === undefined)
        return {};
    const { cacheLocation } = cache;
    if (cacheLocation === undefined)
        return { cache };
    return { cache: { ...cache, cacheLocation: resolveFilePath(cacheLocation, pathToSettingsDir) } };
}
function validationMessage(msg, fileRef) {
    return msg + `\n  File: "${fileRef.filename}"`;
}
function validateRawConfigVersion(config, fileRef) {
    const { version } = config;
    if (version === undefined)
        return;
    if (typeof version !== 'string') {
        (0, logger_1.logError)(validationMessage(`Unsupported config file version: "${version}", string expected`, fileRef));
        return;
    }
    if (setOfSupportedConfigVersions.has(version))
        return;
    if (!/^\d+(\.\d+)*$/.test(version)) {
        (0, logger_1.logError)(validationMessage(`Unsupported config file version: "${version}"`, fileRef));
        return;
    }
    const msg = version > CSpellSettingsServer_1.currentSettingsFileVersion
        ? `Newer config file version found: "${version}". Supported version is "${CSpellSettingsServer_1.currentSettingsFileVersion}"`
        : `Legacy config file version found: "${version}", upgrade to "${CSpellSettingsServer_1.currentSettingsFileVersion}"`;
    (0, logger_1.logWarning)(validationMessage(msg, fileRef));
}
function validateRawConfigExports(config, fileRef) {
    if (config.default) {
        throw new ImportError_1.ImportError(validationMessage('Module `export default` is not supported.\n  Use `module.exports =` instead.', fileRef));
    }
}
function normalizeRawConfig(config) {
    if (typeof config.version === 'number') {
        config.version = config.version.toString();
    }
}
function validateRawConfig(config, fileRef) {
    const validations = [validateRawConfigExports, validateRawConfigVersion];
    validations.forEach((fn) => fn(config, fileRef));
}
exports.__testing__ = {
    normalizeCacheSettings,
    normalizeSettings,
    validateRawConfigExports,
    validateRawConfigVersion,
};
//# sourceMappingURL=configLoader.js.map