"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.regExHashStrings = exports.regExSha = exports.regExRepeatedChar = exports.regExEmail = exports.rexExPythonStyleComments = exports.regExCStyleComments = exports.regExString = exports.regExPhpHereDoc = exports.regExBase64MultiLine = exports.regExBase64SingleLine = exports.regExBase64 = exports.regExEscapeCharacters = exports.regExSshRSA = exports.regExCert = exports.regExPublicKey = exports.regExIgnoreSpellingDirectives = exports.regExSpellingGuardLine = exports.regExSpellingGuardNext = exports.regExSpellingGuardBlock = exports.regExUnicodeRef = exports.regExUUID = exports.regExCSSHexValue = exports.regExCStyleHexValue = exports.regExCommitHashLink = exports.regExCommitHash = exports.regExMatchCommonHexFormats = exports.regExHRef = exports.regExMatchUrls = void 0;
// Exclude Expressions
// cSpell:ignore anrvtbf
exports.regExMatchUrls = /(?:https?|ftp):\/\/[^\s"]+/gi;
exports.regExHRef = /\bhref\s*=\s*".*?"/gi;
exports.regExMatchCommonHexFormats = /(?:#[0-9a-f]{3,8})|(?:0x[0-9a-f]+)|(?:\\u[0-9a-f]{4})|(?:\\x\{[0-9a-f]{4}\})/gi;
exports.regExCommitHash = /\b(?![a-f]+\b)(?:0x)?[0-9a-f]{7,}\b/gi; // Match Commit Hashes that contain at least one digit.
exports.regExCommitHashLink = /\[[0-9a-f]{7,}\]/gi; // Match Commit Hash Markdown link: [abcdef0].
exports.regExCStyleHexValue = /\b0x[0-9a-f]+\b/gi;
exports.regExCSSHexValue = /#[0-9a-f]{3,8}\b/gi;
exports.regExUUID = /\b[0-9a-fx]{8}-[0-9a-fx]{4}-[0-9a-fx]{4}-[0-9a-fx]{4}-[0-9a-fx]{12}\b/gi; // x - represents placeholder values
exports.regExUnicodeRef = /\bU\+[0-9a-f]{4,5}(?:-[0-9a-f]{4,5})?/gi;
exports.regExSpellingGuardBlock = /(\bc?spell(?:-?checker)?::?)\s*disable(?!-line|-next)\b[\s\S]*?((?:\1\s*enable\b)|$)/gi;
exports.regExSpellingGuardNext = /\bc?spell(?:-?checker)?::?\s*disable-next\b.*\s\s?.*/gi;
exports.regExSpellingGuardLine = /^.*\bc?spell(?:-?checker)?::?\s*disable-line\b.*/gim;
exports.regExIgnoreSpellingDirectives = /\bc?spell(?:-?checker)?::?\s*ignoreRegExp.*/gim;
exports.regExPublicKey = /-{5}BEGIN\s+((?:RSA\s+)?PUBLIC\s+KEY)[\w=+\-/=\\\s]+?END\s+\1-{5}/g;
exports.regExCert = /-{5}BEGIN\s+(CERTIFICATE|(?:RSA\s+)?(?:PRIVATE|PUBLIC)\s+KEY)[\w=+\-/=\\\s]+?END\s+\1-{5}/g;
exports.regExSshRSA = /ssh-rsa\s+[a-z0-9/+]{28,}={0,3}(?![a-z0-9/+=])/gi;
exports.regExEscapeCharacters = /\\(?:[anrvtbf]|[xu][a-f0-9]+)/gi;
exports.regExBase64 = /(?<![A-Za-z0-9/+])(?:[A-Za-z0-9/+]{40,})(?:\s^\s*[A-Za-z0-9/+]{40,})*(?:\s^\s*[A-Za-z0-9/+]+=*)?(?![A-Za-z0-9/+=])/gm;
/**
 * Detect a string of characters that look like a Base64 string.
 *
 * It must be:
 * - at least 40 characters
 * - contain at least 1 of [0-9+=]
 * - end at the end of the line or with [,"'\]
 */
exports.regExBase64SingleLine = /(?<![A-Za-z0-9/+])(?=[^/]|[/][A-Za-z0-9/+]+?[=+])(?![A-Za-z/]+(?![A-Za-z0-9/+=]))(?=[A-Za-z0-9/+=]*?(?:[A-Z]{2}|[0-9]{2}))(?:[A-Za-z0-9/+]{4}){10,}(?:[A-Za-z0-9/+]{3}={1}|[A-Za-z0-9/+]{2}={2}|[A-Za-z0-9/+]{1}={3})?(?![A-Za-z0-9/+=])(?=$|[:.,"'\\)])/gm;
exports.regExBase64MultiLine = /(?<![A-Za-z0-9/+])["']?(?:[A-Za-z0-9/+]{40,})["']?(?:\s^\s*["']?[A-Za-z0-9/+]{40,}["']?)+(?:\s^\s*["']?[A-Za-z0-9/+]+={0,3}["']?)?(?![A-Za-z0-9/+=])/gm;
// cspell:ignore aeiou
// The following is an attempt at detecting random strings.
// export const regExRandomString =
//     /\b(?=\w*(?:[A-Z]{2}|[A-Z][a-z][A-Z]|\d\w\d))(?=(?:\w*[A-Z]){2})(?=(?:\w*[a-z]){2})(?=\w*[^aeiouAEIOU\W]{4})[\w]{10,}\b/g;
// Include Expressions
exports.regExPhpHereDoc = /<<<['"]?(\w+)['"]?[\s\S]+?^\1;/gm;
exports.regExString = /(?:(['"]).*?(?<![^\\]\\(\\\\)*)\1)|(?:`[\s\S]*?(?<![^\\]\\(\\\\)*)`)/g;
// Note: the C Style Comments incorrectly considers '/*' and '//' inside of strings as comments.
exports.regExCStyleComments = /(?<!\w:)(?:\/\/.*)|(?:\/\*[\s\S]*?\*\/)/g;
exports.rexExPythonStyleComments = /#.*|(?:('''|""")[^\1]+?\1)/gm;
exports.regExEmail = /<?\b[\w.\-+]{1,128}@\w{1,63}(\.\w{1,63}){1,4}\b>?/gi;
exports.regExRepeatedChar = /^(\w)\1{3,}$/i;
exports.regExSha = /\bsha\d+-[a-z0-9+/]{25,}={0,3}/gi;
/**
 * Detect common hash strings like:
 * - `sha1`, `sha256`, `sha512`
 * - `md5`
 * - `base64` - used in email
 * - `crypt`, `bcrypt`, `script`
 * - `token`
 * - `assertion` - use with jwt
 */
exports.regExHashStrings = /(?:\b(?:sha\d+|md5|base64|crypt|bcrypt|scrypt|security-token|assertion)[-,:$=]|#code[/])[-\w/+%.]{25,}={0,3}(?:(['"])\s*\+?\s*\1?[-\w/+%.]+={0,3})*(?![-\w/+=%.])/gi;
//# sourceMappingURL=RegExpPatterns.js.map