"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.calcSettingsForLanguageId = exports.calcUserSettingsForLanguage = exports.calcSettingsForLanguage = exports.isLocaleInSet = exports.normalizeLocale = exports.normalizeLanguageId = exports.getDefaultLanguageSettings = void 0;
const Memorizer_1 = require("../util/Memorizer");
const util_1 = require("../util/util");
const SpellSettings = __importStar(require("./CSpellSettingsServer"));
const defaultLocale = 'en';
const defaultLanguageSettings = [];
function getDefaultLanguageSettings() {
    return defaultLanguageSettings;
}
exports.getDefaultLanguageSettings = getDefaultLanguageSettings;
function localesToList(locales) {
    return stringToList(locales.replace(/\s+/g, ','));
}
function stringToList(sList) {
    return sList
        .replace(/[|;]/g, ',')
        .split(',')
        .map((s) => s.trim())
        .filter((s) => !!s);
}
const _normalizeLanguageId = (0, Memorizer_1.memorizerAll)(__normalizeLanguageId);
function __normalizeLanguageId(langId) {
    const langIds = stringToList(langId);
    return new Set(langIds.map((a) => a.toLowerCase()));
}
function normalizeLanguageId(langId) {
    return _normalizeLanguageId(typeof langId === 'string' ? langId : langId.join(','));
}
exports.normalizeLanguageId = normalizeLanguageId;
const _normalizeLocale = (0, Memorizer_1.memorizerAll)(__normalizeLocale);
function __normalizeLocale(locale) {
    const locales = localesToList(locale);
    return new Set(locales.map((locale) => locale.toLowerCase().replace(/[^a-z]/g, '')));
}
function normalizeLocale(locale) {
    locale = typeof locale === 'string' ? locale : locale.join(',');
    return _normalizeLocale(locale);
}
exports.normalizeLocale = normalizeLocale;
function isLocaleInSet(locale, setOfLocals) {
    const locales = normalizeLocale(locale);
    return (0, util_1.doSetsIntersect)(locales, setOfLocals);
}
exports.isLocaleInSet = isLocaleInSet;
function calcSettingsForLanguage(languageSettings, languageId, locale) {
    languageId = languageId.toLowerCase();
    const allowedLocals = normalizeLocale(locale);
    const ls = languageSettings
        .filter((s) => doesLanguageSettingMatchLanguageId(s, languageId))
        .filter((s) => !s.locale || s.locale === '*' || isLocaleInSet(s.locale, allowedLocals))
        .map((langSetting) => {
        const { languageId: _languageId, locale: _locale, ...s } = langSetting;
        return s;
    })
        .reduce((langSetting, setting) => SpellSettings.mergeSettings(langSetting, setting), {});
    ls.languageId = languageId;
    ls.locale = locale;
    return ls;
}
exports.calcSettingsForLanguage = calcSettingsForLanguage;
const cacheDoesLanguageSettingMatchLanguageId = new WeakMap();
function doesLanguageSettingMatchLanguageId(s, languageId) {
    var _a;
    const r = (_a = cacheDoesLanguageSettingMatchLanguageId.get(s)) !== null && _a !== void 0 ? _a : new Map();
    const f = r.get(languageId);
    if (f !== undefined) {
        return f;
    }
    const v = _doesLanguageSettingMatchLanguageId(s, languageId);
    r.set(languageId, v);
    cacheDoesLanguageSettingMatchLanguageId.set(s, r);
    return v;
}
function _doesLanguageSettingMatchLanguageId(s, languageId) {
    const languageSettingsLanguageIds = s.languageId;
    if (!languageSettingsLanguageIds || languageSettingsLanguageIds === '*')
        return true;
    const ids = normalizeLanguageId(languageSettingsLanguageIds);
    if (ids.has(languageId))
        return true;
    if (ids.has('!' + languageId))
        return false;
    const numExcludes = [...ids].filter((id) => id.startsWith('!')).length;
    return numExcludes === ids.size;
}
function calcUserSettingsForLanguage(settings, languageId) {
    const { languageSettings = [], language: locale = defaultLocale, allowCompoundWords, enabled } = settings;
    const langSettings = {
        allowCompoundWords,
        enabled,
        ...calcSettingsForLanguage(languageSettings, languageId, locale),
    };
    return SpellSettings.mergeSettings(settings, langSettings);
}
exports.calcUserSettingsForLanguage = calcUserSettingsForLanguage;
function calcSettingsForLanguageId(baseSettings, languageId) {
    const langIds = ['*'].concat(languageId instanceof Array ? languageId : [languageId]);
    const langSettings = langIds.reduce((settings, languageId) => {
        return calcUserSettingsForLanguage(settings, languageId);
    }, baseSettings);
    return langSettings;
}
exports.calcSettingsForLanguageId = calcSettingsForLanguageId;
//# sourceMappingURL=LanguageSettings.js.map