"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultBundledSettings = exports.getDefaultSettings = exports._defaultSettings = exports._defaultSettingsBasis = void 0;
const CSpellSettingsInternalDef_1 = require("../Models/CSpellSettingsInternalDef");
const PatternRegExp_1 = require("../Models/PatternRegExp");
const resolveFile_1 = require("../util/resolveFile");
const configLoader_1 = require("./configLoader");
const index_1 = require("./index");
const LanguageSettings = __importStar(require("./LanguageSettings"));
const RegPat = __importStar(require("./RegExpPatterns"));
const defaultConfigFileModuleRef = '@cspell/cspell-bundled-dicts/cspell-default.json';
// Do not use require.resolve because webpack will mess it up.
const defaultConfigFile = resolveConfigModule(defaultConfigFileModuleRef);
const regExpSpellCheckerDisable = [
    new PatternRegExp_1.PatternRegExp(RegPat.regExSpellingGuardBlock),
    new PatternRegExp_1.PatternRegExp(RegPat.regExSpellingGuardLine),
    new PatternRegExp_1.PatternRegExp(RegPat.regExSpellingGuardNext),
];
// cspell:ignore filetypes
const predefinedPatterns = [
    // Exclude patterns
    { name: 'CommitHash', pattern: RegPat.regExCommitHash },
    { name: 'CommitHashLink', pattern: RegPat.regExCommitHashLink },
    { name: 'CStyleHexValue', pattern: RegPat.regExCStyleHexValue },
    { name: 'CSSHexValue', pattern: RegPat.regExCSSHexValue },
    { name: 'Urls', pattern: RegPat.regExMatchUrls },
    { name: 'HexValues', pattern: RegPat.regExMatchCommonHexFormats },
    { name: 'SpellCheckerDisable', pattern: regExpSpellCheckerDisable },
    { name: 'PublicKey', pattern: RegPat.regExPublicKey },
    { name: 'RsaCert', pattern: RegPat.regExCert },
    { name: 'SshRsa', pattern: RegPat.regExSshRSA },
    { name: 'EscapeCharacters', pattern: RegPat.regExEscapeCharacters },
    { name: 'Base64', pattern: RegPat.regExBase64 },
    { name: 'Base64SingleLine', pattern: RegPat.regExBase64SingleLine },
    { name: 'Base64MultiLine', pattern: RegPat.regExBase64MultiLine },
    { name: 'Email', pattern: RegPat.regExEmail },
    { name: 'SHA', pattern: RegPat.regExSha },
    { name: 'HashStrings', pattern: RegPat.regExHashStrings },
    { name: 'UnicodeRef', pattern: RegPat.regExUnicodeRef },
    { name: 'UUID', pattern: RegPat.regExUUID },
    { name: 'href', pattern: RegPat.regExHRef },
    { name: 'SpellCheckerDisableBlock', pattern: RegPat.regExSpellingGuardBlock },
    { name: 'SpellCheckerDisableLine', pattern: RegPat.regExSpellingGuardLine },
    { name: 'SpellCheckerDisableNext', pattern: RegPat.regExSpellingGuardNext },
    { name: 'SpellCheckerIgnoreInDocSetting', pattern: RegPat.regExIgnoreSpellingDirectives },
    // Include Patterns
    { name: 'PhpHereDoc', pattern: RegPat.regExPhpHereDoc },
    { name: 'string', pattern: RegPat.regExString },
    { name: 'CStyleComment', pattern: RegPat.regExCStyleComments },
    { name: 'Everything', pattern: '.*' },
];
const defaultRegExpPatterns = [...predefinedPatterns].map(normalizePattern);
const definedDefaultRegExpExcludeList = [
    'SpellCheckerDisable',
    'SpellCheckerIgnoreInDocSetting',
    'Urls',
    'Email',
    'RsaCert',
    'SshRsa',
    'Base64MultiLine',
    'Base64SingleLine',
    'CommitHash',
    'CommitHashLink',
    'CStyleHexValue',
    'CSSHexValue',
    'SHA',
    'HashStrings',
    'UnicodeRef',
    'UUID',
];
// This bit of copying is done to have the complier ensure that the defaults exist.
const defaultRegExpExcludeList = definedDefaultRegExpExcludeList;
exports._defaultSettingsBasis = Object.freeze((0, CSpellSettingsInternalDef_1.createCSpellSettingsInternal)({
    id: 'static_defaults',
    language: 'en',
    name: 'Static Defaults',
    enabled: true,
    enabledLanguageIds: [],
    maxNumberOfProblems: 100,
    numSuggestions: 10,
    suggestionsTimeout: 500,
    suggestionNumChanges: 3,
    words: [],
    userWords: [],
    ignorePaths: [],
    allowCompoundWords: false,
    patterns: defaultRegExpPatterns,
    ignoreRegExpList: [],
    languageSettings: [],
    source: { name: 'defaultSettings' },
    reporters: [],
}));
exports._defaultSettings = Object.freeze((0, CSpellSettingsInternalDef_1.createCSpellSettingsInternal)({
    ...exports._defaultSettingsBasis,
    enabledLanguageIds: [
        'ada',
        'csharp',
        'go',
        'javascript',
        'javascriptreact',
        'json',
        'markdown',
        'mdx',
        'php',
        'plaintext',
        'python',
        'text',
        'typescript',
        'typescriptreact',
        'haskell',
        'html',
        'css',
        'less',
        'scss',
        'latex',
        'ruby',
        'rust',
        'shellscript',
        'toml',
    ],
    ignoreRegExpList: defaultRegExpExcludeList,
    languageSettings: LanguageSettings.getDefaultLanguageSettings(),
}));
const getSettings = (function () {
    let settings = undefined;
    return function (useDefaultDictionaries) {
        if (!useDefaultDictionaries) {
            return exports._defaultSettingsBasis;
        }
        if (!settings) {
            const jsonSettings = (0, configLoader_1.readSettings)(defaultConfigFile);
            settings = (0, index_1.mergeSettings)(exports._defaultSettings, jsonSettings);
            if (jsonSettings.name !== undefined) {
                settings.name = jsonSettings.name;
            }
            else {
                delete settings.name;
            }
        }
        return settings;
    };
})();
function resolveConfigModule(configModuleName) {
    return (0, resolveFile_1.resolveFile)(configModuleName, __dirname).filename;
}
function normalizePattern(pat) {
    const { name, pattern, description } = pat;
    if (!(pattern instanceof RegExp))
        return pat;
    return {
        name,
        pattern: new PatternRegExp_1.PatternRegExp(pattern),
        description,
    };
}
function getDefaultSettings(useDefaultDictionaries = true) {
    return getSettings(useDefaultDictionaries);
}
exports.getDefaultSettings = getDefaultSettings;
function getDefaultBundledSettings() {
    return getDefaultSettings();
}
exports.getDefaultBundledSettings = getDefaultBundledSettings;
//# sourceMappingURL=DefaultSettings.js.map