import { IconProvider, EraserMode, SelectionMode } from 'js-draw';
/**
 * Parts of the js-draw library required by this package.
 *
 * **Note**: Additional properties may be added to this type between
 * minor js-draw releases. It is recommended that you either:
 * - Provide the entire js-draw library to {@link makeMaterialIconProviderClass}.
 * - Use the {@link MaterialIconProvider} exported by this package.
 */
export type JsDrawSlice = {
    IconProvider: typeof IconProvider;
    EraserMode: typeof EraserMode;
    SelectionMode: typeof SelectionMode;
};
/**
 * Creates a `MaterialIconProvider` class bound to a particular instance of the `js-draw`
 * library.
 *
 * **Example**:
 * ```ts,runnable
 * import * as jsdraw from 'js-draw';
 * import { makeMaterialIconProviderClass } from '@js-draw/material-icons';
 * const MaterialIconProvider = makeMaterialIconProviderClass(jsdraw);
 *
 * (new jsdraw.Editor(
 *     document.body, { iconProvider: new MaterialIconProvider() },
 * )).addToolbar();
 * ```
 *
 * If you only have one instance of `js-draw` (which is almost always the case), prefer
 * `new` {@link MaterialIconProvider}.
 *
 * @returns an uninstantiated subclass of {@link js-draw!IconProvider | IconProvider}.
 */
declare const makeMaterialIconProviderClass: ({ IconProvider, EraserMode, }: JsDrawSlice) => typeof IconProvider;
export default makeMaterialIconProviderClass;
