"use strict";
/**
 * # `@js-draw/material-icons`
 *
 * Provides a material icon theme for `js-draw`.
 *
 * @example
 * ```ts,runnable
 * import { Editor, makeEdgeToolbar } from 'js-draw';
 * import { MaterialIconProvider } from '@js-draw/material-icons';
 *
 * // Apply js-draw CSS
 * import 'js-draw/styles';
 *
 * const editor = new Editor(document.body, {
 *   iconProvider: new MaterialIconProvider(),
 * });
 *
 * // Ensure that there is enough room for the toolbar
 * editor.getRootElement().style.minHeight = '500px';
 *
 * // Add a toolbar
 * const toolbar = makeEdgeToolbar(editor);
 *
 * // ...with the default elements
 * toolbar.addDefaults();
 * ```
 *
 * @see
 * {@link MaterialIconProvider}
 *
 * @packageDocumentation
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeMaterialIconProviderClass = exports.MaterialIconProvider = void 0;
const js_draw_1 = require("js-draw");
const makeMaterialIconProvider_1 = __importDefault(require("./makeMaterialIconProvider"));
exports.makeMaterialIconProviderClass = makeMaterialIconProvider_1.default;
/**
 * An {@link js-draw!IconProvider | IconProvider} that uses [material icons](https://github.com/google/material-design-icons).
 */
const MaterialIconProvider = (0, makeMaterialIconProvider_1.default)({
    IconProvider: js_draw_1.IconProvider,
    EraserMode: js_draw_1.EraserMode,
    SelectionMode: js_draw_1.SelectionMode,
});
exports.MaterialIconProvider = MaterialIconProvider;
exports.default = MaterialIconProvider;
