/**
 * This returns a new Error with a custom prototype. Note that it's _not_ a constructor
 *
 * @param message Error message
 *
 * **Example**
 *
 * ```js
 * throw EtaErr("template not found")
 * ```
 */
declare function EtaErr(message: string): Error;
declare namespace EtaErr {
    var prototype: any;
}
export default EtaErr;
/**
 * Throws an EtaErr with a nicely formatted error and message showing where in the template the error occurred.
 */
export declare function ParseErr(message: string, str: string, indx: number): void;
//# sourceMappingURL=err.d.ts.map