"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.run = void 0;
const _1 = require(".");
const path = __importStar(require("path"));
const helpText = `Usage cspell-gitignore [options] <files>

Check files against .gitignore
Compare against git check-ignore -v -n <files>

Options:
-r, --root   Add a root to prevent searching for .gitignore files above the root if the file is under the root.
             This option can be used multiple times to add multiple roots. The default root is the current
             repository root determined by the \`.git\` directory.

Example:
  cspell-gitignore README.md
  cspell-gitignore -r . node_modules
`;
async function run(args) {
    const { roots, files, help } = parseArgs(args.slice(2));
    const cwd = process.cwd();
    const repo = (await (0, _1.findRepoRoot)(cwd)) || cwd;
    const gi = await createGitIgnore(roots, repo);
    if (help) {
        console.log(help);
        return;
    }
    if (!files.length) {
        console.error('Missing files');
        process.exitCode = 1;
        return;
    }
    for (const file of files) {
        const filename = path.relative(cwd, file);
        const pFile = gi.isIgnoredEx(file);
        const pDir = gi.isIgnoredEx(file + '/ ');
        const r = (await pFile) || (await pDir);
        const gitignore = (r === null || r === void 0 ? void 0 : r.gitIgnoreFile) ? path.relative(repo, r.gitIgnoreFile) : '';
        const line = (r === null || r === void 0 ? void 0 : r.line) || '';
        const glob = (r === null || r === void 0 ? void 0 : r.glob) || '';
        console.log(`${gitignore}:${line}:${glob}\t${filename}`);
    }
}
exports.run = run;
function parseArgs(params) {
    var _a;
    const roots = [];
    const files = [];
    let help = '';
    const options = {
        '-r': optionRoot,
        '--root': optionRoot,
        '-h': optionHelp,
        '--help': optionHelp,
    };
    function optionRoot(params) {
        const root = params[1];
        if (!root) {
            throw new Error('Missing root parameter.');
        }
        roots.push(path.resolve(root));
        return params.slice(2);
    }
    function optionFile(params) {
        const file = params[0].trim();
        if (file) {
            files.push(path.resolve(file));
        }
        return params.slice(1);
    }
    function optionHelp(_params) {
        help = helpText;
        return [];
    }
    while (params.length) {
        const fn = options[params[0]];
        params = (_a = fn === null || fn === void 0 ? void 0 : fn(params)) !== null && _a !== void 0 ? _a : optionFile(params);
    }
    return { roots, files, help };
}
async function createGitIgnore(roots, repoRoot) {
    if (!roots.length) {
        roots.push(repoRoot);
    }
    return new _1.GitIgnore(roots);
}
//# sourceMappingURL=app.js.map