"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.__testing__ = exports.loadGitIgnore = exports.GitIgnoreHierarchy = exports.GitIgnoreFile = void 0;
const cspell_glob_1 = require("cspell-glob");
const fs_1 = require("fs");
const path = __importStar(require("path"));
/**
 * Represents an instance of a .gitignore file.
 */
class GitIgnoreFile {
    constructor(matcher, gitignore) {
        this.matcher = matcher;
        this.gitignore = gitignore;
    }
    get root() {
        return this.matcher.root;
    }
    isIgnored(file) {
        return this.matcher.match(file);
    }
    isIgnoredEx(file) {
        var _a;
        const m = this.matcher.matchEx(file);
        const { matched } = m;
        const partial = m;
        const pattern = partial.pattern;
        const glob = (_a = pattern === null || pattern === void 0 ? void 0 : pattern.rawGlob) !== null && _a !== void 0 ? _a : partial.glob;
        const root = partial.root;
        const line = pattern === null || pattern === void 0 ? void 0 : pattern.line;
        return { glob, matched, gitIgnoreFile: this.gitignore, root, line };
    }
    static async loadGitignore(gitignore) {
        gitignore = path.resolve(gitignore);
        const content = await fs_1.promises.readFile(gitignore, 'utf8');
        const options = { root: path.dirname(gitignore) };
        const globs = content.split('\n').map((glob, index) => ({
            glob,
            source: gitignore,
            line: index + 1,
        }));
        const globMatcher = new cspell_glob_1.GlobMatcher(globs, options);
        return new GitIgnoreFile(globMatcher, gitignore);
    }
}
exports.GitIgnoreFile = GitIgnoreFile;
/**
 * A collection of nested GitIgnoreFiles to be evaluated from top to bottom.
 */
class GitIgnoreHierarchy {
    constructor(gitIgnoreChain) {
        this.gitIgnoreChain = gitIgnoreChain;
        mustBeHierarchical(gitIgnoreChain);
    }
    isIgnored(file) {
        for (const git of this.gitIgnoreChain) {
            if (git.isIgnored(file))
                return true;
        }
        return false;
    }
    /**
     * Check to see which `.gitignore` file ignored the given file.
     * @param file - fsPath to check.
     * @returns IsIgnoredExResult of the match or undefined if there was no match.
     */
    isIgnoredEx(file) {
        for (const git of this.gitIgnoreChain) {
            const r = git.isIgnoredEx(file);
            if (r.matched)
                return r;
        }
        return undefined;
    }
}
exports.GitIgnoreHierarchy = GitIgnoreHierarchy;
async function loadGitIgnore(dir) {
    const file = path.join(dir, '.gitignore');
    try {
        return await GitIgnoreFile.loadGitignore(file);
    }
    catch (e) {
        return undefined;
    }
}
exports.loadGitIgnore = loadGitIgnore;
function mustBeHierarchical(chain) {
    let root = '';
    for (const file of chain) {
        if (!file.root.startsWith(root)) {
            throw new Error('Hierarchy violation - files are not nested');
        }
        root = file.root;
    }
}
exports.__testing__ = {
    mustBeHierarchical,
};
//# sourceMappingURL=GitIgnoreFile.js.map