import { GlobMatcher } from 'cspell-glob';
export interface IsIgnoredExResult {
    glob: string | undefined;
    root: string | undefined;
    matched: boolean;
    gitIgnoreFile: string;
    line: number | undefined;
}
/**
 * Represents an instance of a .gitignore file.
 */
export declare class GitIgnoreFile {
    readonly matcher: GlobMatcher;
    readonly gitignore: string;
    constructor(matcher: GlobMatcher, gitignore: string);
    get root(): string;
    isIgnored(file: string): boolean;
    isIgnoredEx(file: string): IsIgnoredExResult;
    static loadGitignore(gitignore: string): Promise<GitIgnoreFile>;
}
/**
 * A collection of nested GitIgnoreFiles to be evaluated from top to bottom.
 */
export declare class GitIgnoreHierarchy {
    readonly gitIgnoreChain: GitIgnoreFile[];
    constructor(gitIgnoreChain: GitIgnoreFile[]);
    isIgnored(file: string): boolean;
    /**
     * Check to see which `.gitignore` file ignored the given file.
     * @param file - fsPath to check.
     * @returns IsIgnoredExResult of the match or undefined if there was no match.
     */
    isIgnoredEx(file: string): IsIgnoredExResult | undefined;
}
export declare function loadGitIgnore(dir: string): Promise<GitIgnoreFile | undefined>;
declare function mustBeHierarchical(chain: GitIgnoreFile[]): void;
export declare const __testing__: {
    mustBeHierarchical: typeof mustBeHierarchical;
};
export {};
//# sourceMappingURL=GitIgnoreFile.d.ts.map