"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitIgnore = void 0;
const path = __importStar(require("path"));
const _1 = require(".");
const GitIgnoreFile_1 = require("./GitIgnoreFile");
/**
 * Class to cache and process `.gitignore` file queries.
 */
class GitIgnore {
    /**
     * @param roots - (search roots) an optional array of root paths to prevent searching for `.gitignore` files above the root.
     *   If a file is under multiple roots, the closest root will apply. If a file is not under any root, then
     *   the search for `.gitignore` will go all the way to the system root of the file.
     */
    constructor(roots = []) {
        this.resolvedGitIgnoreHierarchies = new Map();
        this.knownGitIgnoreHierarchies = new Map();
        this._sortedRoots = resolveAndSortRoots(roots);
        this._roots = new Set(this._sortedRoots);
    }
    findResolvedGitIgnoreHierarchy(directory) {
        return this.resolvedGitIgnoreHierarchies.get(directory);
    }
    isIgnoredQuick(file) {
        const gh = this.findResolvedGitIgnoreHierarchy(path.dirname(file));
        return gh === null || gh === void 0 ? void 0 : gh.isIgnored(file);
    }
    async isIgnored(file) {
        const gh = await this.findGitIgnoreHierarchy(path.dirname(file));
        return gh.isIgnored(file);
    }
    async isIgnoredEx(file) {
        const gh = await this.findGitIgnoreHierarchy(path.dirname(file));
        return gh.isIgnoredEx(file);
    }
    async findGitIgnoreHierarchy(directory) {
        const known = this.knownGitIgnoreHierarchies.get(directory);
        if (known) {
            return known;
        }
        const find = this._findGitIgnoreHierarchy(directory);
        this.knownGitIgnoreHierarchies.set(directory, find);
        const found = await find;
        this.resolvedGitIgnoreHierarchies.set(directory, found);
        return find;
    }
    filterOutIgnored(files) {
        const iter = this.filterOutIgnoredAsync(files);
        return isAsyncIterable(files) ? iter : asyncIterableToArray(iter);
    }
    async *filterOutIgnoredAsync(files) {
        var _a;
        for await (const file of files) {
            const isIgnored = (_a = this.isIgnoredQuick(file)) !== null && _a !== void 0 ? _a : (await this.isIgnored(file));
            if (!isIgnored) {
                yield file;
            }
        }
    }
    get roots() {
        return this._sortedRoots;
    }
    addRoots(roots) {
        const rootsToAdd = roots.map((p) => path.resolve(p)).filter((r) => !this._roots.has(r));
        if (!rootsToAdd.length)
            return;
        rootsToAdd.forEach((r) => this._roots.add(r));
        this._sortedRoots = resolveAndSortRoots([...this._roots]);
        this.cleanCachedEntries();
    }
    peekGitIgnoreHierarchy(directory) {
        return this.knownGitIgnoreHierarchies.get(directory);
    }
    cleanCachedEntries() {
        this.knownGitIgnoreHierarchies.clear();
        this.resolvedGitIgnoreHierarchies.clear();
    }
    async _findGitIgnoreHierarchy(directory) {
        var _a;
        const root = this.determineRoot(directory);
        const parent = path.dirname(directory);
        const parentHierarchy = parent !== directory && (0, _1.contains)(root, parent) ? await this.findGitIgnoreHierarchy(parent) : undefined;
        const git = await (0, GitIgnoreFile_1.loadGitIgnore)(directory);
        if (!git) {
            return parentHierarchy || new GitIgnoreFile_1.GitIgnoreHierarchy([]);
        }
        const chain = (_a = parentHierarchy === null || parentHierarchy === void 0 ? void 0 : parentHierarchy.gitIgnoreChain.concat([git])) !== null && _a !== void 0 ? _a : [git];
        return new GitIgnoreFile_1.GitIgnoreHierarchy(chain);
    }
    determineRoot(directory) {
        const roots = this.roots;
        for (let i = roots.length - 1; i >= 0; --i) {
            const r = roots[i];
            if ((0, _1.contains)(r, directory))
                return r;
        }
        return path.parse(directory).root;
    }
}
exports.GitIgnore = GitIgnore;
function resolveAndSortRoots(roots) {
    const sortedRoots = roots.map((a) => path.resolve(a));
    sortRoots(sortedRoots);
    Object.freeze(sortedRoots);
    return sortedRoots;
}
/**
 * Sorts root paths based upon their length.
 * @param roots - array to be sorted
 */
function sortRoots(roots) {
    roots.sort((a, b) => a.length - b.length);
    return roots;
}
function isAsyncIterable(i) {
    const as = i;
    return typeof as[Symbol.asyncIterator] === 'function';
}
async function asyncIterableToArray(iter) {
    const r = [];
    for await (const t of iter) {
        r.push(t);
    }
    return r;
}
//# sourceMappingURL=GitIgnore.js.map