/**
 * Compile-time assertion that a branch of code is unreachable.
 * @internal
 */
export declare function assertUnreachable(key: never): never;
/**
 * Throws an exception if the typeof given value is not a number or `value` is NaN.
 *
 * @example
 * ```ts
 * const foo: unknown = 3;
 * assertIsNumber(foo);
 *
 * assertIsNumber('hello, world'); // throws an Error.
 * ```
 */
export declare function assertIsNumber(value: unknown, allowNaN?: boolean): asserts value is number;
/** Throws an `Error` if the given `value` is not a `string`. */
export declare function assertIsString(value: unknown): asserts value is string;
export declare function assertIsArray(values: unknown): asserts values is unknown[];
/**
 * Throws if any of `values` is not of type number.
 */
export declare function assertIsNumberArray(values: unknown, allowNaN?: boolean): asserts values is number[];
/**
 * Throws if any of `values` is not of type `string`.
 */
export declare function assertIsStringArray(values: unknown): asserts values is string[];
/**
 * Throws an exception if `typeof value` is not a boolean.
 */
export declare function assertIsBoolean(value: unknown): asserts value is boolean;
export declare function assertTruthy<T>(value: T | null | undefined | false | 0): asserts value is T;
export declare function assertIsObject(value: unknown): asserts value is Record<string, unknown>;
