// Types related to the image editor
/** @see {@link EditorNotifier} */
export var EditorEventType;
(function (EditorEventType) {
    EditorEventType[EditorEventType["ToolEnabled"] = 0] = "ToolEnabled";
    EditorEventType[EditorEventType["ToolDisabled"] = 1] = "ToolDisabled";
    EditorEventType[EditorEventType["ToolUpdated"] = 2] = "ToolUpdated";
    EditorEventType[EditorEventType["UndoRedoStackUpdated"] = 3] = "UndoRedoStackUpdated";
    EditorEventType[EditorEventType["CommandDone"] = 4] = "CommandDone";
    EditorEventType[EditorEventType["CommandUndone"] = 5] = "CommandUndone";
    EditorEventType[EditorEventType["ObjectAdded"] = 6] = "ObjectAdded";
    EditorEventType[EditorEventType["ViewportChanged"] = 7] = "ViewportChanged";
    EditorEventType[EditorEventType["DisplayResized"] = 8] = "DisplayResized";
    EditorEventType[EditorEventType["SelectionUpdated"] = 9] = "SelectionUpdated";
    EditorEventType[EditorEventType["ReadOnlyModeToggled"] = 10] = "ReadOnlyModeToggled";
    /** @internal */
    EditorEventType[EditorEventType["ColorPickerToggled"] = 11] = "ColorPickerToggled";
    /** @internal */
    EditorEventType[EditorEventType["ColorPickerColorSelected"] = 12] = "ColorPickerColorSelected";
    /** @deprecated @internal */
    EditorEventType[EditorEventType["ToolbarDropdownShown"] = 13] = "ToolbarDropdownShown";
})(EditorEventType || (EditorEventType = {}));
// Types of `EditorUndoStackUpdated` events.
export var UndoEventType;
(function (UndoEventType) {
    UndoEventType[UndoEventType["CommandDone"] = 0] = "CommandDone";
    UndoEventType[UndoEventType["CommandUndone"] = 1] = "CommandUndone";
    UndoEventType[UndoEventType["CommandRedone"] = 2] = "CommandRedone";
})(UndoEventType || (UndoEventType = {}));
